(ns test
  (use clara.rules)
  (use clojure.walk))

(defrecord Person [first last age city])

(macroexpand-all 
 '(defrule is-old
   [Person (> age 50) (= ?first first)]
   =>
   (println ?first "is old!")))

(defrule is-older-than
  [Person (= ?age1 age) (= ?first1 first)]
  [Person (= ?age2 age) (= ?first2 first)]
  [:test (> ?age1 ?age2)]
  =>
  (println ?first1 "is older than" ?first2))

(defrule awesome-city
  [?person <- Person (= "Overland Park" city)]
  =>
  (let [{last :last} ?person]
    (println last "lives in an awesome city")))

(->
 (mk-session)
 (insert (->Person "Mike" "Smith" 70 "Kansas City")
         (->Person "Pete" "Jones" 75 "Overland Park"))
 (fire-rules))