/*
 * Decompiled with CFR 0.152.
 */
package org.tomdz.storm.esper;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPAdministrator;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tomdz.storm.esper.EventTypeDescriptor;
import org.tomdz.storm.esper.StreamId;
import org.tomdz.storm.esper.TupleTypeDescriptor;

public class EsperBolt
extends BaseRichBolt
implements UpdateListener {
    private static final long serialVersionUID = 1L;
    private final Map<StreamId, String> inputAliases = new LinkedHashMap<StreamId, String>();
    private final Map<StreamId, TupleTypeDescriptor> tupleTypes = new LinkedHashMap<StreamId, TupleTypeDescriptor>();
    private final Map<String, EventTypeDescriptor> eventTypes = new LinkedHashMap<String, EventTypeDescriptor>();
    private final List<String> statements = new ArrayList<String>();
    private transient EPServiceProvider esperSink;
    private transient EPRuntime runtime;
    private transient EPAdministrator admin;
    private transient OutputCollector collector;

    private EsperBolt() {
    }

    private void addInputAlias(StreamId streamId, String name, TupleTypeDescriptor typeDesc) {
        this.inputAliases.put(streamId, name);
        if (typeDesc != null) {
            this.tupleTypes.put(streamId, typeDesc);
        }
    }

    private void addNamedOutput(String streamId, String eventTypeName, String ... fields) {
        this.eventTypes.put(eventTypeName, new EventTypeDescriptor(eventTypeName, fields, streamId));
    }

    private void setAnonymousOutput(String streamId, String ... fields) {
        this.eventTypes.put(null, new EventTypeDescriptor(null, fields, streamId));
    }

    private void addStatement(String stmt) {
        this.statements.add(stmt);
    }

    public EventTypeDescriptor getEventType(String name) {
        return this.eventTypes.get(name);
    }

    public Collection<EventTypeDescriptor> getEventTypes() {
        return new ArrayList<EventTypeDescriptor>(this.eventTypes.values());
    }

    public EventTypeDescriptor getEventTypeForStreamId(String streamId) {
        for (EventTypeDescriptor eventType : this.eventTypes.values()) {
            if (!streamId.equals(eventType.getStreamId())) continue;
            return eventType;
        }
        return null;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (EventTypeDescriptor eventType : this.eventTypes.values()) {
            declarer.declareStream(eventType.getStreamId(), eventType.getFields());
        }
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        Configuration configuration = new Configuration();
        this.setupEventTypes(context, configuration);
        this.esperSink = EPServiceProviderManager.getProvider((String)((Object)((Object)this)).toString(), (Configuration)configuration);
        this.esperSink.initialize();
        this.runtime = this.esperSink.getEPRuntime();
        this.admin = this.esperSink.getEPAdministrator();
        for (String stmt : this.statements) {
            EPStatement statement = this.admin.createEPL(stmt);
            statement.addListener((UpdateListener)this);
        }
    }

    private String getEventTypeName(String componentId, String streamId) {
        String alias = this.inputAliases.get(new StreamId(componentId, streamId));
        if (alias == null) {
            alias = String.format("%s_%s", componentId, streamId);
        }
        return alias;
    }

    private void setupEventTypes(TopologyContext context, Configuration configuration) {
        Set sourceIds = context.getThisSources().keySet();
        for (GlobalStreamId id : sourceIds) {
            String eventTypeName = this.getEventTypeName(id.get_componentId(), id.get_streamId());
            Fields fields = context.getComponentOutputFields(id.get_componentId(), id.get_streamId());
            TupleTypeDescriptor typeDesc = this.tupleTypes.get(new StreamId(id.get_componentId(), id.get_streamId()));
            Map<String, Object> props = this.setupEventTypeProperties(fields, typeDesc);
            configuration.addEventType(eventTypeName, props);
        }
    }

    private Map<String, Object> setupEventTypeProperties(Fields fields, TupleTypeDescriptor typeDesc) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int numFields = fields.size();
        for (int idx = 0; idx < numFields; ++idx) {
            String clazzName;
            String fieldName = fields.get(idx);
            Class clazz = null;
            if (typeDesc != null && (clazzName = typeDesc.getFieldType(fieldName)) != null) {
                try {
                    clazz = Class.forName(clazzName);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Cannot find class " + clazzName + "declared for field " + fieldName);
                }
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            properties.put(fieldName, clazz);
        }
        return properties;
    }

    public void execute(Tuple tuple) {
        String eventType = this.getEventTypeName(tuple.getSourceComponent(), tuple.getSourceStreamId());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Fields fields = tuple.getFields();
        int numFields = fields.size();
        for (int idx = 0; idx < numFields; ++idx) {
            String name = fields.get(idx);
            Object value = tuple.getValue(idx);
            data.put(name, value);
        }
        this.runtime.sendEvent(data, eventType);
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                EventTypeDescriptor eventType = this.getEventType(newEvent.getEventType().getName());
                if (eventType == null) {
                    eventType = this.getEventType(null);
                }
                if (eventType == null) continue;
                this.collector.emit(eventType.getStreamId(), this.toTuple(newEvent, eventType.getFields()));
            }
        }
    }

    private List<Object> toTuple(EventBean event, Fields fields) {
        int numFields = fields.size();
        ArrayList<Object> tuple = new ArrayList<Object>(numFields);
        for (int idx = 0; idx < numFields; ++idx) {
            tuple.add(event.get(fields.get(idx)));
        }
        return tuple;
    }

    public void cleanup() {
        if (this.esperSink != null) {
            this.esperSink.destroy();
        }
    }

    public static final class StatementsBuilder
    extends Builder {
        private StatementsBuilder(EsperBolt bolt) {
            super(bolt);
        }

        public StatementsBuilder add(String statement) {
            this.bolt.addStatement(statement);
            return this;
        }
    }

    public static final class NamedOutputStreamBuilder {
        private final EsperBolt bolt;
        private final String streamName;
        private final String eventTypeName;

        private NamedOutputStreamBuilder(EsperBolt bolt, String streamName, String eventTypeName) {
            this.bolt = bolt;
            this.streamName = streamName;
            this.eventTypeName = eventTypeName;
        }

        public OutputsBuilder emit(String ... fields) {
            this.bolt.addNamedOutput(this.streamName, this.eventTypeName, fields);
            return new OutputsBuilder(this.bolt);
        }
    }

    public static final class OutputStreamBuilder {
        private final EsperBolt bolt;
        private final String streamName;

        private OutputStreamBuilder(EsperBolt bolt, String streamName) {
            this.bolt = bolt;
            this.streamName = streamName;
        }

        public NamedOutputStreamBuilder fromEventType(String name) {
            return new NamedOutputStreamBuilder(this.bolt, this.streamName, name);
        }

        public OutputsBuilder emit(String ... fields) {
            this.bolt.setAnonymousOutput(this.streamName, fields);
            return new OutputsBuilder(this.bolt);
        }
    }

    public static final class OutputsBuilder
    extends Builder {
        private OutputsBuilder(EsperBolt bolt) {
            super(bolt);
        }

        public OutputStreamBuilder onStream(String streamName) {
            return new OutputStreamBuilder(this.bolt, streamName);
        }

        public OutputStreamBuilder onDefaultStream() {
            return new OutputStreamBuilder(this.bolt, "default");
        }
    }

    public static final class TypedInputBuilder {
        private final EsperBolt bolt;
        private final StreamId streamId;
        private final Map<String, String> fieldTypes;
        private final String[] fieldNames;

        private TypedInputBuilder(EsperBolt bolt, StreamId streamId, Map<String, String> fieldTypes, String ... fieldNames) {
            this.bolt = bolt;
            this.streamId = streamId;
            this.fieldTypes = fieldTypes;
            this.fieldNames = fieldNames;
        }

        public AliasedInputBuilder ofType(Class<?> type) {
            for (String fieldName : this.fieldNames) {
                this.fieldTypes.put(fieldName, type.getName());
            }
            return new AliasedInputBuilder(this.bolt, this.streamId, this.fieldTypes);
        }
    }

    public static final class AliasedInputBuilder {
        private final EsperBolt bolt;
        private final StreamId streamId;
        private final Map<String, String> fieldTypes;

        private AliasedInputBuilder(EsperBolt bolt, StreamId streamId) {
            this(bolt, streamId, new HashMap<String, String>());
        }

        private AliasedInputBuilder(EsperBolt bolt, StreamId streamId, Map<String, String> fieldTypes) {
            this.bolt = bolt;
            this.streamId = streamId;
            this.fieldTypes = fieldTypes;
        }

        public TypedInputBuilder withField(String fieldNames) {
            return new TypedInputBuilder(this.bolt, this.streamId, (Map)this.fieldTypes, new String[]{fieldNames});
        }

        public TypedInputBuilder withFields(String ... fieldNames) {
            return new TypedInputBuilder(this.bolt, this.streamId, (Map)this.fieldTypes, fieldNames);
        }

        public InputsBuilder toEventType(String name) {
            this.bolt.addInputAlias(this.streamId, name, new TupleTypeDescriptor(this.fieldTypes));
            return new InputsBuilder(this.bolt);
        }
    }

    public static class InputsBuilder
    extends Builder {
        private InputsBuilder(EsperBolt bolt) {
            super(bolt);
        }

        public AliasedInputBuilder aliasComponent(String componentId) {
            return new AliasedInputBuilder(this.bolt, new StreamId(componentId));
        }

        public AliasedInputBuilder aliasStream(String componentId, String streamId) {
            return new AliasedInputBuilder(this.bolt, new StreamId(componentId, streamId));
        }
    }

    public static class Builder {
        protected final EsperBolt bolt;

        public Builder() {
            this(new EsperBolt());
        }

        protected Builder(EsperBolt bolt) {
            this.bolt = bolt;
        }

        public InputsBuilder inputs() {
            return new InputsBuilder(this.bolt);
        }

        public OutputsBuilder outputs() {
            return new OutputsBuilder(this.bolt);
        }

        public StatementsBuilder statements() {
            return new StatementsBuilder(this.bolt);
        }

        public EsperBolt build() {
            return this.bolt;
        }
    }
}

