/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.MarcException;
import org.marc4j.converter.impl.ReverseCodeTable;
import org.marc4j.converter.impl.ReverseCodeTableHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ReverseCodeTableHash
extends ReverseCodeTable {
    protected static Hashtable charset = null;
    protected static Vector combining = null;

    @Override
    public boolean isCombining(Character c) {
        return combining.contains(c);
    }

    @Override
    public Hashtable getCharTable(Character c) {
        return (Hashtable)charset.get(c);
    }

    public ReverseCodeTableHash(InputStream byteStream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(byteStream);
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public ReverseCodeTableHash(String filename) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File(filename);
            InputSource src = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public ReverseCodeTableHash(URI uri) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(uri.toURL().openStream());
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }
}

