/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.marc4j.MarcStreamWriter;
import org.marc4j.marc.Leader;

public class MarcPermissiveStreamWriter
extends MarcStreamWriter {
    private static DecimalFormat format4 = new DecimalFormat("0000");
    private static DecimalFormat format5 = new DecimalFormat("00000");

    public MarcPermissiveStreamWriter(OutputStream out) {
        super(out);
    }

    public MarcPermissiveStreamWriter(OutputStream out, String encoding) {
        super(out, encoding);
    }

    protected void write(Leader ldr) throws IOException {
        int recLength = ldr.getRecordLength();
        if (recLength > 99999) {
            recLength = 99999;
        }
        this.out.write(format5.format(recLength).getBytes(this.encoding));
        this.out.write(ldr.getRecordStatus());
        this.out.write(ldr.getTypeOfRecord());
        this.out.write(new String(ldr.getImplDefined1()).getBytes(this.encoding));
        this.out.write(ldr.getCharCodingScheme());
        this.out.write(Integer.toString(ldr.getIndicatorCount()).getBytes(this.encoding));
        this.out.write(Integer.toString(ldr.getSubfieldCodeLength()).getBytes(this.encoding));
        this.out.write(format5.format(ldr.getBaseAddressOfData()).getBytes(this.encoding));
        this.out.write(new String(ldr.getImplDefined2()).getBytes(this.encoding));
        this.out.write(new String(ldr.getEntryMap()).getBytes(this.encoding));
    }

    @Override
    protected byte[] getEntry(String tag, int length, int start) throws IOException {
        if (length > 9999) {
            length = 9999;
        }
        if (start > 99999) {
            start = 99999;
        }
        return (tag + format4.format(length) + format5.format(start)).getBytes(this.encoding);
    }
}

