/*
 * Decompiled with CFR 0.152.
 */
package org.tigerdb.lion.store;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mpizutil.electrolist.structure.ElectroList;
import org.tigerdb.lion.exceptions.InvalidObjectTypeException;
import org.tigerdb.lion.exceptions.UnknownFieldException;
import org.tigerdb.lion.store.threads.TSaver;
import org.tigerdb.lion.streams.ObjectReader;
import org.tigerdb.lion.streams.ObjectWriter;

public class StoreManager<T> {
    private ElectroList<T> listObjects = new ElectroList();
    private final ObjectWriter<T> writer;
    private final ObjectReader<T> reader;
    private TSaver<T> tSaver;
    private File fileRecords;
    private final Class<T> objectsClazz;
    private final Field[] classFields;
    private final Method[] classMethods;
    private final Method equalsMethod;

    public StoreManager(Class<T> objectsClazz, File tblFolder) throws IOException, ClassNotFoundException {
        this.objectsClazz = objectsClazz;
        this.fileRecords = new File(tblFolder, "records.db");
        if (!this.fileRecords.exists()) {
            this.fileRecords.createNewFile();
        }
        this.writer = new ObjectWriter(this.fileRecords);
        this.reader = new ObjectReader(this.fileRecords);
        this.classFields = objectsClazz.getDeclaredFields();
        this.classMethods = objectsClazz.getDeclaredMethods();
        for (Field field : this.classFields) {
            field.setAccessible(true);
        }
        this.equalsMethod = this.getMethod("equals");
        this.loadAll();
    }

    private boolean isValidField(String fieldName) {
        for (int i = 0; i < this.classFields.length; ++i) {
            if (!this.classFields[i].getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumberType(Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        String className = clazz.getTypeName();
        return className.equals("byte") || className.equals("short") || className.equals("int") || className.equals("long") || className.equals("float") || className.equals("double");
    }

    private boolean isString(Class<?> clazz) {
        return clazz.getSimpleName().equals("String");
    }

    private boolean isEqualsNumbers(Object o1, Object o2) {
        if (Number.class.isAssignableFrom(o1.getClass()) && Number.class.isAssignableFrom(o2.getClass())) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (Double.class.isInstance(o1) && Double.class.isInstance(o2) || Float.class.isInstance(o1) && Float.class.isInstance(o2)) {
                return n1.doubleValue() == n2.doubleValue();
            }
            return n1.longValue() == n2.longValue();
        }
        if (Double.TYPE.isInstance(o1) && Double.TYPE.isInstance(o2) || Float.TYPE.isInstance(o1) && Float.TYPE.isInstance(o2)) {
            return ((Double)o1).doubleValue() == ((Double)o2).doubleValue();
        }
        return ((Long)o1).longValue() == ((Long)o2).longValue();
    }

    private void loadAll() throws ClassNotFoundException, IOException {
        this.listObjects = this.reader.readAllObjects();
    }

    private Field getField(String fieldName) {
        for (int i = 0; i < this.classFields.length; ++i) {
            if (!this.classFields[i].getName().equals(fieldName)) continue;
            this.classFields[i].setAccessible(true);
            return this.classFields[i];
        }
        return null;
    }

    private Method getMethod(String methodName) {
        for (int i = 0; i < this.classMethods.length; ++i) {
            if (!this.classMethods[i].getName().equals(methodName)) continue;
            this.classMethods[i].setAccessible(true);
            return this.classMethods[i];
        }
        return null;
    }

    private long toNumber(String str) {
        char[] chars = str.toCharArray();
        if (chars == null || chars.length == 0) {
            return 0L;
        }
        int valAcumulator = 0;
        for (int i = 0; i < chars.length; ++i) {
            valAcumulator += chars[i];
        }
        return valAcumulator;
    }

    public long getObjectsCount() {
        return this.listObjects.size();
    }

    public long getSumBy(String fieldName) {
        Field field = this.getField(fieldName);
        boolean isString = false;
        if (field == null) {
            throw new UnknownFieldException(fieldName);
        }
        if (!this.isNumberType(field.getType()) && !(isString = this.isString(field.getType()))) {
            throw new InvalidObjectTypeException(field.getType().getName());
        }
        long sum = 0L;
        if (isString) {
            for (T obj : this.listObjects) {
                try {
                    sum += this.toNumber(field.get(obj).toString());
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            for (T obj : this.listObjects) {
                try {
                    sum += field.getLong(obj);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return sum;
    }

    public void startSaver() {
        this.tSaver = new TSaver<T>(this.listObjects, this.writer);
        this.tSaver.start();
    }

    public long getMaxBy(String fieldName) {
        Field field = this.getField(fieldName);
        boolean isString = false;
        if (field == null) {
            throw new UnknownFieldException(fieldName);
        }
        if (!this.isNumberType(field.getType()) && !(isString = this.isString(field.getType()))) {
            throw new InvalidObjectTypeException(field.getType().getName());
        }
        long max = Long.MIN_VALUE;
        long curValue = 0L;
        if (isString) {
            for (T obj : this.listObjects) {
                try {
                    curValue = this.toNumber(field.get(obj).toString());
                    if (curValue <= max) continue;
                    max = curValue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            for (T obj : this.listObjects) {
                try {
                    curValue = field.getLong(obj);
                    if (curValue <= max) continue;
                    max = curValue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return max;
    }

    public long getMinBy(String fieldName) {
        Field field = this.getField(fieldName);
        boolean isString = false;
        if (field == null) {
            throw new UnknownFieldException(fieldName);
        }
        if (!this.isNumberType(field.getType()) && !(isString = this.isString(field.getType()))) {
            throw new InvalidObjectTypeException(field.getType().getName());
        }
        long min = Long.MAX_VALUE;
        long curValue = 0L;
        if (isString) {
            for (T obj : this.listObjects) {
                try {
                    curValue = this.toNumber(field.get(obj).toString());
                    if (curValue >= min) continue;
                    min = curValue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            for (T obj : this.listObjects) {
                try {
                    curValue = field.getLong(obj);
                    if (curValue >= min) continue;
                    min = curValue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return min;
    }

    public double getAvgBy(String fieldName) {
        Field field = this.getField(fieldName);
        boolean isString = false;
        if (field == null) {
            throw new UnknownFieldException(fieldName);
        }
        if (!this.isNumberType(field.getType()) && !(isString = this.isString(field.getType()))) {
            throw new InvalidObjectTypeException(field.getType().getName());
        }
        long counter = 0L;
        double sum = 0.0;
        if (isString) {
            for (T object : this.listObjects) {
                try {
                    sum += (double)this.toNumber(field.get(object).toString());
                    ++counter;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            for (T object : this.listObjects) {
                try {
                    sum += field.getDouble(object);
                    ++counter;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return sum / (double)counter;
    }

    public void addObject(T object) throws IOException {
        this.writer.writeObject(object);
        this.listObjects.add(object);
    }

    public void addObjectParallel(T object) throws IOException {
        this.listObjects.add(object);
    }

    public void addObjectsFrom(Collection<T> list) throws IOException {
        for (T t : list) {
            this.listObjects.add(t);
        }
        this.writer.update(this.listObjects);
    }

    public ElectroList<T> getObjects() {
        return this.listObjects;
    }

    public T getFirstObject() {
        return this.listObjects.peekFirst();
    }

    public T getLastObject() {
        return this.listObjects.peekFirst();
    }

    public T getObjectBy(int index) {
        return this.listObjects.isEmpty() ? null : (T)this.listObjects.get(index);
    }

    public T getObjectBy(String fieldName, Object valueToFind) throws IllegalArgumentException, IllegalAccessException {
        Field field = this.getField(fieldName);
        if (field == null) {
            throw new UnknownFieldException("El campo " + fieldName + " no existe");
        }
        for (T object : this.listObjects) {
            if (!field.get(object).toString().contains(valueToFind.toString())) continue;
            return object;
        }
        return null;
    }

    public ElectroList<T> getObjectsBy(String fieldName, Object valueToFind) throws IllegalArgumentException, IllegalAccessException {
        Field field = this.getField(fieldName);
        if (field == null) {
            throw new UnknownFieldException("El campo " + fieldName + " no existe");
        }
        ElectroList<T> listResults = new ElectroList<T>();
        for (T object : this.listObjects) {
            if (!field.get(object).toString().contains(valueToFind.toString())) continue;
            listResults.add(object);
        }
        return listResults;
    }

    public T getFirstObjectBy(String fieldName, Object valueToFind) {
        Field field = this.getField(fieldName);
        if (field == null) {
            throw new UnknownFieldException("El campo " + fieldName + " no existe");
        }
        for (T object : this.listObjects) {
            try {
                Object objField = field.get(object);
                if (!(this.isNumberType(objField.getClass()) && this.isNumberType(valueToFind.getClass()) ? this.isEqualsNumbers(objField, valueToFind) : objField.equals(valueToFind))) continue;
                return object;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(StoreManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public void setObject(int index, T newObject) throws IOException {
        this.listObjects.set(index, newObject);
        this.writer.update(this.listObjects);
    }

    public void setObjects(String fieldName, Object valueToFind, T newObject) throws IllegalArgumentException, IllegalAccessException, IOException {
        Field field = this.getField(fieldName);
        if (field == null) {
            throw new UnknownFieldException("El campo " + fieldName + " no existe");
        }
        int counter = 0;
        for (T object : this.listObjects) {
            if (field.get(object).toString().contains(valueToFind.toString())) {
                this.listObjects.set(counter, newObject);
            }
            ++counter;
        }
        this.writer.update(this.listObjects);
    }

    public void setObject(T oldObj, T newObj) throws IOException {
        this.listObjects.set(this.listObjects.indexOf(oldObj), newObj);
        this.writer.update(this.listObjects);
    }

    public void deleteAllObjects() throws IOException {
        this.listObjects.clear();
        this.writer.clearFile();
    }

    public void deleteObject(int index) throws IOException {
        this.listObjects.remove(index);
        this.writer.update(this.listObjects);
    }

    public void deleteObjectsBy(String fieldName, Object valueToFind) throws IllegalArgumentException, IllegalAccessException, IOException {
        Field field = this.getField(fieldName);
        if (field == null) {
            throw new UnknownFieldException("El campo " + fieldName + " no existe");
        }
        int counter = 0;
        for (T object : this.listObjects) {
            if (field.get(object).toString().equals(valueToFind.toString())) {
                this.listObjects.remove(object);
            }
            ++counter;
        }
        this.writer.update(this.listObjects);
    }

    public void deleteFile() {
        this.fileRecords.delete();
    }
}

