/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.structure;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Node<E>
implements Cloneable,
Comparable<E>,
Serializable {
    private static StringBuilder sb;
    public transient Node<E> prev;
    public E data;
    public transient Node<E> next;

    Node(E data) {
        this(null, data, null);
    }

    Node(Node<E> prev, E data, Node<E> next) {
        this.prev = prev;
        this.data = data;
        this.next = next;
    }

    boolean hasNext() {
        return this.next != null;
    }

    boolean hasPrevious() {
        return this.prev != null;
    }

    int getDequeCount() {
        int counter = 0;
        Node<E> n = this.next;
        while (n != null) {
            ++counter;
            n = n.next;
        }
        return counter;
    }

    void connect() {
        this.connectNext();
        this.connectPrevious();
    }

    void connectNext() {
        if (this.hasNext()) {
            this.next.prev = this;
        }
    }

    void connectPrevious() {
        if (this.hasPrevious()) {
            this.prev.next = this;
        }
    }

    void setPrevious(Node<E> prev) {
        this.prev = prev;
    }

    void setNext(Node<E> next) {
        this.next = next;
    }

    void unlinkPrevious() {
        this.prev = null;
    }

    void unlinkNext() {
        this.next = null;
    }

    private void unlinkAll() {
        this.unlinkPrevious();
        this.unlinkNext();
    }

    void skip() {
        if (this.hasPrevious()) {
            this.prev.next = this.next;
        }
        if (this.hasNext()) {
            this.next.prev = this.prev;
        }
        this.unlink();
    }

    void unlink() {
        this.unlinkAll();
        this.data = null;
    }

    void kill() {
        try {
            this.unlink();
            this.finalize();
        }
        catch (Throwable ex) {
            Logger.getLogger(Node.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void print() {
        System.out.print(this.data);
        if (this.hasNext()) {
            System.out.print("->");
            this.next.print();
        }
    }

    boolean equals(Node<E> another) {
        return this.hashCode() == another.hashCode();
    }

    protected Node<E> clone() throws CloneNotSupportedException {
        return new Node<E>(this.prev, this.data, this.next);
    }

    @Override
    public int compareTo(E o) {
        int hashO;
        int hashData = this.data.hashCode();
        if (hashData >= (hashO = o.hashCode())) {
            if (hashData > hashO) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public String toString() {
        return this.data.toString();
    }
}

