/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.structure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mpizutil.electrolist.searchs.TSearcherManager;
import org.mpizutil.electrolist.structure.Node;
import org.mpizutil.electrolist.structure.StreamSupport;

public class ElectroList<E>
extends AbstractSequentialList<E>
implements Deque<E>,
Cloneable,
Serializable,
StreamSupport<E> {
    private transient Node<E> first;
    private transient Node<E> last;
    private String name;
    private transient int size;
    private static final long serialVersionUID = 80031400030040L;

    public static <E> void sort(ElectroList<E> list, Comparator<E> c) {
        list.sort(c);
    }

    public ElectroList() {
        this.name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    public ElectroList(Collection<? extends E> col) {
        this.addAll(col);
    }

    public ElectroList(E[] array) {
        this.addAll(array);
    }

    public ElectroList(String name) {
        this.name = name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Node<E> x = this.first;
        while (x != null) {
            out.writeObject(x.data);
            x = x.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.linkLast(in.readObject());
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(index + "");
        }
    }

    private Node<E> getNode(int index) {
        if (index == this.size || index < 0) {
            return null;
        }
        if (index < this.size >> 1) {
            Node<E> aux = this.first;
            for (int i = 0; i < index; ++i) {
                aux = aux.next;
            }
            return aux;
        }
        Node<E> aux = this.last;
        for (int i = this.size - 1; i > index; --i) {
            aux = aux.prev;
        }
        return aux;
    }

    private void unlinkNode(Node<E> node) {
        if (this.size == 1) {
            this.first.data = null;
            this.last = null;
            this.first = null;
        } else {
            node.skip();
            node = null;
        }
    }

    private void linkLast(E e) {
        Node<E> newNode = new Node<E>(this.last, e, null);
        this.last = newNode;
        if (!newNode.hasPrevious()) {
            this.first = newNode;
        } else {
            newNode.prev.next = newNode;
        }
        ++this.size;
    }

    private void linkFirst(E e) {
        Node<E> f = this.first;
        Node<E> newNode = new Node<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
    }

    private void linkBefore(E e, Node<E> node) {
        Node newNode = new Node(node.prev, e, node);
        newNode.connect();
    }

    private void linkAfter(E e, Node<E> node) {
        Node<E> newNode = new Node<E>(node, e, node.next);
        newNode.connect();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void collectTo(List<E> list) {
        Node<E> f = this.first;
        while (f != null) {
            list.add(f.data);
            f = f.next;
        }
    }

    public LinkedList<E> collect() {
        LinkedList list = new LinkedList();
        this.collectTo(list);
        return list;
    }

    public void drainTo(List<E> list) {
        this.collectTo(list);
        this.clear();
    }

    public LinkedList<E> drain() {
        LinkedList<E> listCollect = this.collect();
        this.clear();
        return listCollect;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        Node<E> aux = this.first;
        while (aux != null) {
            if (predicate.test(aux.data)) {
                return true;
            }
            aux = aux.next;
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        Node<E> aux = this.first;
        while (aux != null) {
            if (!predicate.test(aux.data)) {
                return false;
            }
            aux = aux.next;
        }
        return true;
    }

    @Override
    public Stream<E> filter(Predicate<? super E> predicate) {
        ElectroList filterList = new ElectroList();
        Node<E> aux = this.first;
        while (aux != null) {
            if (predicate.test(aux.data)) {
                filterList.add(aux.data);
            }
            aux = aux.next;
        }
        return filterList.stream();
    }

    @Override
    public E findFirst(Predicate<? super E> predicate) {
        Node<E> f = this.first;
        while (f != null) {
            if (predicate.test(f.data)) {
                return f.data;
            }
            f = f.next;
        }
        return null;
    }

    @Override
    public E findLast(Predicate<? super E> predicate) {
        Node<E> l = this.last;
        while (l != null) {
            if (predicate.test(l.data)) {
                return l.data;
            }
            l = l.prev;
        }
        return null;
    }

    @Override
    public E findAny(Predicate<? super E> predicate) {
        return new TSearcherManager<E>(this, predicate).getFirstOcurrence();
    }

    @Override
    public Stream<E> parallelFilter(Predicate<? super E> predicate) {
        TSearcherManager<E> searchsManager = new TSearcherManager<E>(this, predicate);
        return searchsManager.getStreamResults();
    }

    @Override
    public ElectroList<E> parallelSearch(Predicate<? super E> predicate) {
        TSearcherManager<E> searchsManager = new TSearcherManager<E>(this, predicate);
        return searchsManager.getResults();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Node<E> aux = this.first;
        while (aux != null) {
            action.accept(aux.data);
            aux = aux.next;
        }
    }

    @Override
    public E removeFirst(Predicate<? super E> predicate) {
        Node<E> f = this.first;
        while (f != null) {
            if (predicate.test(f.data)) {
                Object data = f.data;
                this.unlinkNode(f);
                return data;
            }
            f = f.next;
        }
        return null;
    }

    @Override
    public E removeLast(Predicate<? super E> predicate) {
        Node<E> l = this.last;
        while (l != null) {
            if (predicate.test(l.data)) {
                Object data = l.data;
                this.unlinkNode(l);
                return data;
            }
            l = l.prev;
        }
        return null;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Node<E> aux = this.first;
        boolean removed = false;
        int listSize = this.size;
        for (int i = 0; i < listSize; ++i) {
            Node next = aux.next;
            if (filter.test(aux.data)) {
                this.unlinkNode(aux);
                removed = true;
                --this.size;
            }
            aux = next;
        }
        return removed;
    }

    @Override
    public boolean retainIf(Predicate<? super E> filter) {
        Node<E> aux = this.first;
        boolean retained = false;
        int listSize = this.size;
        for (int i = 0; i < listSize; ++i) {
            Node next = aux.next;
            if (!filter.test(aux.data)) {
                this.unlinkNode(aux);
                retained = true;
                --this.size;
            }
            aux = next;
        }
        return retained;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElectroIterator(this);
    }

    @Override
    public E[] toArray() {
        Object[] array = new Object[this.size];
        Node<E> aux = this.first;
        int listSize = this.size;
        for (int i = 0; i < listSize; ++i) {
            array[i] = aux.data;
            aux = aux.next;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        a = this.toArray();
        return a;
    }

    public void copyTo(E[] array) {
        if (array.length != this.size) {
            array = new Object[this.size];
        }
        int i = 0;
        Node<E> f = this.first;
        while (f != null) {
            array[i] = f.data;
            f = f.next;
            ++i;
        }
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Node<E> aux = this.first;
        while (aux != null) {
            if (aux.data.equals(o)) {
                this.unlinkNode(aux);
                --this.size;
                return true;
            }
            aux = aux.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean containsAll = false;
        for (Object object : c) {
            containsAll = this.contains(object);
            if (containsAll) continue;
            return containsAll;
        }
        return containsAll;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(0, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkIndex(index);
        Node<E> aux = this.getNode(index);
        Node next = aux.next;
        for (E e : c) {
            aux.next = new Node<E>(aux, e, null);
            aux = aux.next;
        }
        aux.next = next;
        if (aux.hasNext()) {
            aux.next.connect();
        }
        return true;
    }

    public void addAll(E[] array) {
        this.addAll(array, 0);
    }

    public void addAll(E[] array, int index) {
        if (index >= array.length || index < 0) {
            throw new IndexOutOfBoundsException(index + "");
        }
        int arrayLen = array.length;
        int elementCount = arrayLen - index;
        this.add(array[index]);
        Node<E> l = this.last;
        for (int i = index + 1; i < arrayLen; ++i) {
            Node<E> newNode = new Node<E>(l, array[i], null);
            newNode.connectPrevious();
            l = newNode;
        }
        this.size += elementCount;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        Node<E> aux = this.first;
        for (int i = 0; i < this.size; ++i) {
            for (Object object : c) {
                if (!aux.data.equals(object)) continue;
                this.unlinkNode(aux);
                --this.size;
            }
            aux = aux.next;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        Node<E> aux = this.first;
        for (int i = 0; i < this.size; ++i) {
            for (Object object : c) {
                if (aux.data.equals(object)) continue;
                this.unlinkNode(aux);
                --this.size;
            }
            aux = aux.next;
        }
        return true;
    }

    @Override
    public void clear() {
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.getNode((int)index).data;
    }

    public ElectroList<E> get(int start, int end) {
        this.checkIndex(start);
        this.checkIndex(end);
        ElectroList listGet = new ElectroList();
        Node<E> aux = this.getNode(start);
        for (int i = start; i < end; ++i) {
            listGet.add(aux.data);
            aux = aux.next;
        }
        return listGet;
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        Node<E> node = this.getNode(index);
        Object data = node.data;
        node.data = element;
        return data;
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.linkFirst(element);
        } else {
            this.checkIndex(index);
            Node<E> node = this.getNode(index);
            Node newNode = new Node(node.prev, element, node);
            if (newNode.hasPrevious()) {
                newNode.prev.next = newNode;
            } else {
                this.first = newNode;
            }
            node.prev = newNode;
        }
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        Node<E> node = this.getNode(index);
        Object element = node.data;
        this.unlinkNode(node);
        --this.size;
        return element;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        Node<E> aux = this.first;
        while (aux != null) {
            if (aux.data.equals(o)) {
                return index;
            }
            ++index;
            aux = aux.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size - 1;
        Node<E> aux = this.last;
        while (aux != null) {
            if (aux.data.equals(o)) {
                return index;
            }
            --index;
            aux = aux.prev;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.checkIndex(fromIndex);
        this.checkIndex(toIndex);
        ElectroList subList = new ElectroList();
        Node<E> aux = this.getNode(fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            subList.add(aux.data);
            aux = aux.next;
        }
        return subList;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NullPointerException();
        }
        Object data = this.first.data;
        this.unlinkNode(this.first);
        --this.size;
        return data;
    }

    @Override
    public E removeLast() {
        if (this.isEmpty()) {
            throw new NullPointerException();
        }
        Object data = this.last.data;
        this.unlinkNode(this.last);
        --this.size;
        return data;
    }

    @Override
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            throw new NullPointerException();
        }
        return this.first.data;
    }

    @Override
    public E getLast() {
        if (this.isEmpty()) {
            throw new NullPointerException();
        }
        return this.last.data;
    }

    @Override
    public E peekFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.first.data;
    }

    @Override
    public E peekLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.last.data;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Node<E> aux = this.last;
        while (aux != null) {
            if (aux.data.equals(o)) {
                this.unlinkNode(aux);
                --this.size;
                return true;
            }
            aux = aux.prev;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        this.add(e);
        return true;
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    public void cut(int index) {
        if (index == this.size) {
            this.clear();
            return;
        }
        Node begin = this.getNode(index);
        begin.setPrevious(null);
        this.first = begin;
        if (begin == this.last) {
            this.last = begin;
            begin.setNext(null);
        }
        this.size -= index;
    }

    public void removeAt(int start, int end) {
        if (this.size == 0) {
            return;
        }
        int siz = end - start;
        if (start > end || siz <= 0 || start < 0 || end < 0 || end > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node<E> begin = this.getNode(start);
        Node en = this.getNode(end);
        if (this.size == 1) {
            this.last = null;
            this.first = null;
            this.size = 0;
        } else if (begin == this.first || en == this.last) {
            if (begin == this.first && en == this.last) {
                en.prev = null;
                this.last = en;
                this.first = this.last;
                this.size = 1;
            } else if (begin == this.first) {
                this.first = en;
                en.setPrevious(null);
            } else {
                this.last = en;
                this.last.setNext(null);
                this.last.setPrevious(begin.prev);
                begin.prev.setNext(this.last);
            }
        } else {
            begin.prev.setNext(en);
            en.setPrevious(begin.prev);
        }
        this.size -= siz;
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.add(0, e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ElectroIterator(this, true);
    }

    @Override
    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        String strList = null;
        sBuilder.append(this.name);
        sBuilder.append(' ');
        sBuilder.append('[');
        Node<E> aux = this.first;
        while (aux != null) {
            sBuilder.append(aux.data);
            if (aux.next != null) {
                sBuilder.append(", ");
            }
            aux = aux.next;
        }
        sBuilder.append(']');
        strList = sBuilder.toString();
        sBuilder = null;
        return strList;
    }

    @Override
    public boolean equals(Object another) {
        return this == another;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.first);
        hash = 97 * hash + Objects.hashCode(this.last);
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + this.size;
        return hash;
    }

    public void println() {
        this.forEach((Consumer<? super E>)((Consumer<Object>)System.out::println));
    }

    public boolean equals(ElectroList<E> anotherList) {
        return this == anotherList;
    }

    private static class ElectroListIterator<E>
    implements ListIterator<E> {
        private ElectroList<E> list;
        private int index;
        private static final long serialVersionUID = 122000300500L;

        public ElectroListIterator(ElectroList<E> list) {
            this.list = list;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ElectroList)this.list).size;
        }

        @Override
        public E next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return this.list.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.list.remove(this.index);
        }

        @Override
        public void set(E e) {
            this.list.set(this.index, e);
        }

        @Override
        public void add(E e) {
            this.list.add(e);
        }
    }

    private static class ElectroIterator<E>
    implements Iterator<E> {
        private ElectroList<E> list;
        private Node<E> current;
        boolean isDescending;
        private static final long serialVersionUID = 122000300400L;

        public ElectroIterator(ElectroList<E> list) {
            this(list, false);
        }

        public ElectroIterator(ElectroList<E> list, boolean isDescending) {
            this.list = list;
            this.current = isDescending ? ((ElectroList)list).getNode(((ElectroList)list).size - 1) : ((ElectroList)list).getNode(0);
            this.isDescending = isDescending;
        }

        @Override
        public void remove() {
            if (this.isDescending) {
                this.current = this.current.prev;
                ((ElectroList)this.list).unlinkNode(this.current.next);
            } else {
                this.current = this.current.next;
                ((ElectroList)this.list).unlinkNode(this.current.prev);
            }
            ((ElectroList)this.list).size--;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            Object data = this.current.data;
            this.current = this.isDescending ? this.current.prev : this.current.next;
            return data;
        }
    }
}

