/*
 * Decompiled with CFR 0.152.
 */
package org.mpizutil.electrolist.searchs;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mpizutil.electrolist.searchs.TSearcher;
import org.mpizutil.electrolist.structure.ElectroList;

public class TSearcherManager<T> {
    private final TSearcher<T> searcher1;
    private final TSearcher<T> searcher2;
    private final ElectroList<T> listResults = new ElectroList();

    public TSearcherManager(ElectroList<T> listSearch, Predicate<? super T> predicate) {
        this.searcher1 = new TSearcher<T>(listSearch, this.listResults, predicate);
        this.searcher2 = new TSearcher<T>(listSearch, this.listResults, predicate, true);
    }

    private void stopSearchers() {
        this.searcher1.interrupt();
        this.searcher2.interrupt();
    }

    public T getFirstOcurrence() {
        while (!this.searcher1.isFinished() || !this.searcher2.isFinished() && this.listResults.isEmpty()) {
        }
        return this.listResults.pollFirst();
    }

    public ElectroList<T> getResults() {
        while (!this.searcher1.isFinished() && !this.searcher2.isFinished()) {
        }
        return this.listResults;
    }

    public Stream<T> getStreamResults() {
        return this.getResults().stream();
    }
}

