(defproject org.theparanoidtimes/cljs-map-pins "0.2.1"
  :description "cljs-map-pins is a ClojureScript library for drawing a set of pins from an EDN file on a world map"
  :url "https://sr.ht/~tpt/cljs-map-pins/"
  :license {:name "GNU Lesser General Public License v3.0"
            :distribution :repo
            :url "https://www.gnu.org/licenses/lgpl-3.0.en.html"}
  :pom-addition ([:developers [:developer
                               [:id "tpt"]
                               [:name "Dejan Josifović"]
                               [:url "https://theparanoidtimes.org"]
                               [:email "theparanoidtimes@posteo.net"]
                               [:roles
                                [:role "developer"]
                                [:role "maintainer"]]]]
                 [:organization ([:name "theparanoidtimes.org"]
                                 [:url "https://theparanoidtimes.org"])])
  :manifest {"Built-By" "tpt"
             "X-Author" "tpt"
             "X-Author-Email" "theparanoidtimes@posteo.net"
             "Implementation-Title" ~#(:name %)
             "Implementation-Version" ~#(:version %)
             "Implementation-Vendor" "theparanoidtimes.org"
             "Implementation-URL" ~#(:url %)}
  :min-lein-version "2.7.1"
  :deploy-repositories [["releases" {:url "https://repo.clojars.org"
                                     :creds :gpg}]
                        ["snapshots" {:url "https://repo.clojars.org"
                                      :creds :gpg}]]
  :signing {:gpg-key "theparanoidtimes@posteo.net"}
  :dependencies [[org.clojure/clojure "1.12.4"]
                 [org.clojure/clojurescript "1.12.134"]
                 [prismatic/schema "1.4.1"]]
  :source-paths ["src/main"]
  :jar-exclusions [#"public" #"html" #"md"]
  :plugins [[lein-exec "0.3.7"]
            [lein-codox "0.10.8"]]
  :codox {:language :clojurescript
          :output-path "doc/api"}
  :aliases {"full-clean" ["exec" "build/clean.clj"]})
