/*
 * Decompiled with CFR 0.152.
 */
package m;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicPropertyFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import m.b;
import m.c;
import m.d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements c {
    private static final Logger lw = LoggerFactory.getLogger(a.class);
    final String keyspace;
    public static final String zS = "uid";
    public static final String zT = "time";
    public static final String zU = "data";
    private Session zV;
    private Cluster cluster;
    private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
    static final Map zW = Maps.newHashMap();
    private static final ThreadPoolExecutor zX;
    private int zY = 3600;
    private static final Timer zZ;
    private static final Timer Aa;
    private static final Meter Ab;
    private static final Meter Ac;
    private static final Meter Ad;
    private static final Meter Ae;

    public a(String string) {
        this.keyspace = string;
        lw.info("cassandra keyspace:{}", (Object)this.keyspace);
    }

    public a(String string, int n2) {
        this(string);
        this.zY = n2;
    }

    private static ThreadPoolExecutor q(int n2, int n3) {
        return new ThreadPoolExecutor(n2, n2, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(n3, true), new ThreadFactoryBuilder().setNameFormat("cassandra-cbk-thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void connect() {
        Metadata metadata = this.propertyFactory.getStringProperty("contactPoints", null).get().split(",");
        HashSet<InetSocketAddress> hashSet = new HashSet<InetSocketAddress>();
        for (String string : metadata) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string.split(":")[0], Integer.parseInt(string.split(":")[1]));
            hashSet.add(inetSocketAddress);
        }
        this.cluster = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build())).withPoolingOptions(this.getPoolingOptions()).addContactPointsWithPorts(hashSet).withRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE).build();
        Metadata metadata2 = this.cluster.getMetadata();
        System.out.printf("Connected to cluster: %s%n", metadata2.getClusterName());
        for (Host host : metadata2.getAllHosts()) {
            System.out.printf("Datacenter: %s; Host: %s; Rack: %s%n", host.getDatacenter(), host.getAddress(), host.getRack());
        }
        try {
            this.zV = this.cluster.connect(this.keyspace);
        }
        catch (NoHostAvailableException noHostAvailableException) {
            noHostAvailableException.printStackTrace();
        }
        d.getRegistry().register(MetricRegistry.name(a.class, (String[])new String[]{"ckb.queue.size"}), (Metric)((Gauge)() -> zX.getQueue().size()));
    }

    @Override
    public void shutdown() {
        try {
            zX.shutdown();
            zX.awaitTermination(60L, TimeUnit.SECONDS);
            if (this.zV != null) {
                this.zV.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public List c(long l2, long l3, long l4, long l5) {
        Ac.mark();
        Select select = this.c(l2, (Long)l3, (Long)l4, (Long)l5);
        try {
            Timer.Context context = Aa.time();
            ResultSetFuture resultSetFuture = this.zV.executeAsync((Statement)select);
            ResultSet resultSet = (ResultSet)resultSetFuture.get(15L, TimeUnit.SECONDS);
            context.stop();
            return resultSet.all().stream().map(row -> row.getBytes(zU).array()).collect(Collectors.toList());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Select c(long l2, Long l3, Long l4, Long l5) {
        Select select = QueryBuilder.select().column(zU).from((String)zW.get(l2));
        select.where(QueryBuilder.eq((String)zS, (Object)l3)).and(QueryBuilder.gte((String)zT, (Object)l4)).and(QueryBuilder.lte((String)zT, (Object)l5));
        return select;
    }

    @Override
    public void c(long l2, long l3, long l4, long l5, Consumer consumer) {
        Ac.mark();
        Select select = this.c(l2, (Long)l3, (Long)l4, (Long)l5);
        ResultSetFuture resultSetFuture = this.zV.executeAsync((Statement)select);
        Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new b(this, consumer), (Executor)zX);
    }

    @Override
    public void g(long l2, long l3, long l4, byte[] byArray) {
        Ab.mark();
        Insert insert = this.h(l2, l3, l4, byArray);
        this.zV.executeAsync((Statement)insert);
    }

    private Insert h(long l2, long l3, long l4, byte[] byArray) {
        Insert insert = QueryBuilder.insertInto((String)((String)zW.get(l2))).value(zS, (Object)l3).value(zT, (Object)l4).value(zU, (Object)ByteBuffer.wrap(byArray));
        insert.using(QueryBuilder.ttl((int)this.zY));
        return insert;
    }

    @Override
    public boolean i(long l2, long l3, long l4, byte[] byArray) {
        Ab.mark();
        Insert insert = this.h(l2, l3, l4, byArray);
        try {
            Timer.Context context = zZ.time();
            this.zV.execute((Statement)insert);
            context.stop();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private PoolingOptions getPoolingOptions() {
        int n2 = this.propertyFactory.getIntProperty("connectionsPerHost", 10).get();
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, n2).setMaxConnectionsPerHost(HostDistance.LOCAL, n2).setCoreConnectionsPerHost(HostDistance.REMOTE, 2).setMaxConnectionsPerHost(HostDistance.REMOTE, 4).setHeartbeatIntervalSeconds(60);
        return poolingOptions;
    }

    static /* synthetic */ Meter hF() {
        return Ad;
    }

    static /* synthetic */ Meter hG() {
        return Ae;
    }

    static /* synthetic */ DynamicPropertyFactory a(a a2) {
        return a2.propertyFactory;
    }

    static {
        LongStream.range(0L, 60L).forEach(l2 -> zW.put(l2, "S" + l2));
        zX = a.q(Runtime.getRuntime().availableProcessors(), 200000);
        zZ = d.j(a.class, "time.write");
        Aa = d.j(a.class, "time.read");
        Ab = d.i(a.class, "meter.write");
        Ac = d.i(a.class, "meter.read");
        Ad = d.i(a.class, "meter.readme.success");
        Ae = d.i(a.class, "meter.readme.error");
    }
}

