(ns org.tcrawley.datastar-pedestal-adapter
  {:clj-kondo/config
   '{:lint-as {starfederation.datastar.clojure.utils/def-clone clojure.core/def}}}
  (:require
    [io.pedestal.http.sse :as pedestal.sse]
    [org.tcrawley.datastar-pedestal-adapter.impl :as impl]
    [starfederation.datastar.clojure.adapter.common :as ac]
    [starfederation.datastar.clojure.utils :refer [def-clone]]))

(def-clone on-open ac/on-open)
(def-clone on-close ac/on-close)
(def-clone on-exception ac/on-exception)
(def-clone default-on-exception ac/default-on-exception)

(def-clone write-profile ac/write-profile)

(def-clone basic-profile                impl/basic-profile)
;; (def-clone buffered-writer-profile      ac/buffered-writer-profile)
;; (def-clone gzip-profile                 ac/gzip-profile)
;; (def-clone gzip-buffered-writer-profile ac/gzip-buffered-writer-profile)

(defn ->sse-response
  "Make a Pedestal context that will start a SSE stream.

  Note that the SSE connection stays opened util you close it.

  General options:
  - [[on-open]]: mandatory callback called when the generator is ready to send. 
    Will be passsed the generator.
  - [[on-close]]: callback called when the generator is ready to send. 
    Will be passsed the sse connection, along with a status (either `:server-close` or 
    `:client-disconnect`).
  - [[on-exception]]: callback called when sending a SSE event throws.
  - [[write-profile]]: write profile for the connection.
    Defaults to [[basic-profile]]

  SDK provided write profiles:
  - [[basic-profile]]
  
  Note: Pedestal doesn't allow us to implement compression or buffered writer
  profiles without bypassing pedestal and writing to the underlying server impl
  directly.

  Note: Pedestal does not allow sending a non-200 status code or custom headers
  with SSE responses."
  [context opts]
  {:pre [(on-open opts)]}
  (let [on-open-cb (on-open opts)
        opts (if (write-profile opts)
               opts
               (assoc opts write-profile basic-profile))
        sse-gen-promise (promise)]
    (pedestal.sse/start-stream
      (fn [event-ch _context]
        (let [send! (impl/->send! event-ch opts)
              sse-gen (impl/->sse-gen event-ch send! opts)]
          (deliver sse-gen-promise sse-gen)
          (on-open-cb sse-gen)))
      context
      ;; TODO: expose these as options? 
      10 ;; Heartbeat delay, the pedestal default
      10 ;; Core.async buffer size, the pedestal default 
      {:on-client-disconnect (impl/->on-client-disconnect sse-gen-promise)})))

