/*
 * Decompiled with CFR 0.152.
 */
package de.jetwick.snacktory;

import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.nodes.Element;

public class SHelper {
    public static final String UTF8 = "UTF-8";
    private static final Pattern SPACE = Pattern.compile(" ");

    public static String replaceSpaces(String url) {
        if (!url.isEmpty() && (url = url.trim()).contains(" ")) {
            Matcher spaces = SPACE.matcher(url);
            url = spaces.replaceAll("%20");
        }
        return url;
    }

    public static int count(String str, String substring) {
        int c = 0;
        int index1 = str.indexOf(substring);
        if (index1 >= 0) {
            ++c;
            c += SHelper.count(str.substring(index1 + substring.length()), substring);
        }
        return c;
    }

    public static String innerTrim(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean previousSpace = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') {
                previousSpace = true;
                continue;
            }
            if (previousSpace) {
                sb.append(' ');
            }
            previousSpace = false;
            sb.append(c);
        }
        return sb.toString().trim();
    }

    public static String encodingCleanup(String str) {
        StringBuilder sb = new StringBuilder();
        boolean startedWithCorrectString = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '-' || c == '_') {
                startedWithCorrectString = true;
                sb.append(c);
                continue;
            }
            if (startedWithCorrectString) break;
        }
        return sb.toString().trim();
    }

    public static String getLongestSubstring(String str1, String str2) {
        int[] res = SHelper.longestSubstring(str1, str2);
        if (res == null || res[0] >= res[1]) {
            return "";
        }
        return str1.substring(res[0], res[1]);
    }

    public static int[] longestSubstring(String str1, String str2) {
        if (str1 == null || str1.isEmpty() || str2 == null || str2.isEmpty()) {
            return null;
        }
        int[][] num = new int[str1.length()][str2.length()];
        int maxlen = 0;
        int lastSubstrBegin = 0;
        int endIndex = 0;
        for (int i = 0; i < str1.length(); ++i) {
            for (int j = 0; j < str2.length(); ++j) {
                if (str1.charAt(i) != str2.charAt(j)) continue;
                num[i][j] = i == 0 || j == 0 ? 1 : 1 + num[i - 1][j - 1];
                if (num[i][j] <= maxlen) continue;
                maxlen = num[i][j];
                lastSubstrBegin = i - num[i][j] + 1;
                endIndex = i + 1;
            }
        }
        return new int[]{lastSubstrBegin, endIndex};
    }

    public static String getDefaultFavicon(String url) {
        return SHelper.useDomainOfFirstArg4Second(url, "/favicon.ico");
    }

    public static String useDomainOfFirstArg4Second(String urlForDomain, String path) {
        if (path.startsWith("http")) {
            return path;
        }
        if ("favicon.ico".equals(path)) {
            path = "/favicon.ico";
        }
        if (path.startsWith("//")) {
            if (urlForDomain.startsWith("https:")) {
                return "https:" + path;
            }
            return "http:" + path;
        }
        if (path.startsWith("/")) {
            return "http://" + SHelper.extractHost(urlForDomain) + path;
        }
        if (path.startsWith("../")) {
            int slashIndex = urlForDomain.lastIndexOf("/");
            if (slashIndex > 0 && slashIndex + 1 < urlForDomain.length()) {
                urlForDomain = urlForDomain.substring(0, slashIndex + 1);
            }
            return urlForDomain + path;
        }
        return path;
    }

    public static String extractHost(String url) {
        return SHelper.extractDomain(url, false);
    }

    public static String extractDomain(String url, boolean aggressive) {
        int slashIndex;
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        } else if (url.startsWith("https://")) {
            url = url.substring("https://".length());
        }
        if (aggressive) {
            if (url.startsWith("www.")) {
                url = url.substring("www.".length());
            }
            if (url.startsWith("m.")) {
                url = url.substring("m.".length());
            }
        }
        if ((slashIndex = url.indexOf("/")) > 0) {
            url = url.substring(0, slashIndex);
        }
        return url;
    }

    public static boolean isVideoLink(String url) {
        return (url = SHelper.extractDomain(url, true)).startsWith("youtube.com") || url.startsWith("video.yahoo.com") || url.startsWith("vimeo.com") || url.startsWith("blip.tv");
    }

    public static boolean isVideo(String url) {
        return url.endsWith(".mpeg") || url.endsWith(".mpg") || url.endsWith(".avi") || url.endsWith(".mov") || url.endsWith(".mpg4") || url.endsWith(".mp4") || url.endsWith(".flv") || url.endsWith(".wmv");
    }

    public static boolean isAudio(String url) {
        return url.endsWith(".mp3") || url.endsWith(".ogg") || url.endsWith(".m3u") || url.endsWith(".wav");
    }

    public static boolean isDoc(String url) {
        return url.endsWith(".pdf") || url.endsWith(".ppt") || url.endsWith(".doc") || url.endsWith(".swf") || url.endsWith(".rtf") || url.endsWith(".xls");
    }

    public static boolean isPackage(String url) {
        return url.endsWith(".gz") || url.endsWith(".tgz") || url.endsWith(".zip") || url.endsWith(".rar") || url.endsWith(".deb") || url.endsWith(".rpm") || url.endsWith(".7z");
    }

    public static boolean isApp(String url) {
        return url.endsWith(".exe") || url.endsWith(".bin") || url.endsWith(".bat") || url.endsWith(".dmg");
    }

    public static boolean isImage(String url) {
        return url.endsWith(".png") || url.endsWith(".jpeg") || url.endsWith(".gif") || url.endsWith(".jpg") || url.endsWith(".bmp") || url.endsWith(".ico") || url.endsWith(".eps");
    }

    public static void enableCookieMgmt() {
        CookieManager manager = new CookieManager();
        manager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(manager);
    }

    public static void enableUserAgentOverwrite() {
        System.setProperty("http.agent", "");
    }

    public static String getUrlFromUglyGoogleRedirect(String url) {
        String[] arr;
        if (url.startsWith("http://www.google.com/url?") && (arr = SHelper.urlDecode(url = url.substring("http://www.google.com/url?".length())).split("\\&")) != null) {
            for (String str : arr) {
                if (!str.startsWith("q=")) continue;
                return str.substring("q=".length());
            }
        }
        return null;
    }

    public static String getUrlFromUglyFacebookRedirect(String url) {
        if (url.startsWith("http://www.facebook.com/l.php?u=")) {
            url = url.substring("http://www.facebook.com/l.php?u=".length());
            return SHelper.urlDecode(url);
        }
        return null;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String removeHashbang(String url) {
        return url.replaceFirst("#!", "");
    }

    public static String printNode(Element root) {
        return SHelper.printNode(root, 0);
    }

    public static String printNode(Element root, int indentation) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            sb.append(' ');
        }
        sb.append(root.tagName());
        sb.append(":");
        sb.append(root.ownText());
        sb.append("\n");
        for (Element el : root.children()) {
            sb.append(SHelper.printNode(el, indentation + 1));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String estimateDate(String url) {
        int index = url.indexOf("://");
        if (index > 0) {
            url = url.substring(index + 3);
        }
        int year = -1;
        int yearCounter = -1;
        int month = -1;
        int monthCounter = -1;
        int day = -1;
        String[] strs = url.split("/");
        for (int counter = 0; counter < strs.length; ++counter) {
            String str = strs[counter];
            if (str.length() == 4) {
                try {
                    year = Integer.parseInt(str);
                }
                catch (Exception ex) {
                    continue;
                }
                if (year < 1970 || year > 3000) {
                    year = -1;
                    continue;
                }
                yearCounter = counter;
                continue;
            }
            if (str.length() != 2) continue;
            if (monthCounter < 0 && counter == yearCounter + 1) {
                try {
                    month = Integer.parseInt(str);
                }
                catch (Exception ex) {
                    continue;
                }
                if (month < 1 || month > 12) {
                    month = -1;
                    continue;
                }
                monthCounter = counter;
                continue;
            }
            if (counter != monthCounter + 1) continue;
            try {
                day = Integer.parseInt(str);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (day >= 1 && day <= 31) break;
            day = -1;
        }
        if (year < 0) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append(year);
        if (month < 1) {
            return str.toString();
        }
        str.append('/');
        if (month < 10) {
            str.append('0');
        }
        str.append(month);
        if (day < 1) {
            return str.toString();
        }
        str.append('/');
        if (day < 10) {
            str.append('0');
        }
        str.append(day);
        return str.toString();
    }

    public static String completeDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        int index = dateStr.indexOf(47);
        if (index > 0) {
            if ((index = dateStr.indexOf(47, index + 1)) > 0) {
                return dateStr;
            }
            return dateStr + "/01";
        }
        return dateStr + "/01/01";
    }

    public static SimpleDateFormat createDateFormatter() {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static void enableAnySSL() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

