/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm;

import clojure.asm.AnnotationVisitor;
import clojure.asm.Attribute;
import clojure.asm.FieldVisitor;
import clojure.asm.MethodVisitor;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api) {
        this(api, null);
    }

    public ClassVisitor(int api, ClassVisitor cv) {
        if (api != 262144) {
            throw new IllegalArgumentException();
        }
        this.api = api;
        this.cv = cv;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version, access, name2, signature, superName, interfaces);
        }
    }

    public void visitSource(String source, String debug) {
        if (this.cv != null) {
            this.cv.visitSource(source, debug);
        }
    }

    public void visitOuterClass(String owner, String name2, String desc) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner, name2, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(desc, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name2, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value) {
        if (this.cv != null) {
            return this.cv.visitField(access, name2, desc, signature, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name2, desc, signature, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

