/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ARef;
import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Settable;
import clojure.lang.Symbol;
import clojure.lang.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Var
extends ARef
implements IFn,
IRef,
Settable {
    static final ThreadLocal<Frame> dvals = new ThreadLocal<Frame>(){

        @Override
        protected Frame initialValue() {
            return Frame.TOP;
        }
    };
    public static volatile int rev = 0;
    static Keyword privateKey = Keyword.intern(null, "private");
    static IPersistentMap privateMeta = new PersistentArrayMap(new Object[]{privateKey, Boolean.TRUE});
    static Keyword macroKey = Keyword.intern(null, "macro");
    static Keyword nameKey = Keyword.intern(null, "name");
    static Keyword nsKey = Keyword.intern(null, "ns");
    volatile Object root;
    volatile boolean dynamic = false;
    volatile boolean notLean = false;
    final transient AtomicBoolean threadBound;
    public final Symbol sym;
    public final Namespace ns;
    static IFn assoc = new AFn(){

        @Override
        public Object invoke(Object m, Object k, Object v) {
            return RT.assoc(m, k, v);
        }
    };
    static IFn dissoc = new AFn(){

        @Override
        public Object invoke(Object c, Object k) {
            return RT.dissoc(c, k);
        }
    };

    public static Object getThreadBindingFrame() {
        return dvals.get();
    }

    public static Object cloneThreadBindingFrame() {
        return dvals.get().clone();
    }

    public static void resetThreadBindingFrame(Object frame) {
        dvals.set((Frame)frame);
    }

    public Var setDynamic() {
        this.dynamic = true;
        return this;
    }

    public Var setDynamic(boolean b) {
        this.dynamic = b;
        return this;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public Var setNotLean(boolean b) {
        this.notLean = b;
        return this;
    }

    public final boolean isNotLean() {
        return this.notLean;
    }

    public static Var intern(Namespace ns, Symbol sym, Object root) {
        return Var.intern(ns, sym, root, true);
    }

    public static Var intern(Namespace ns, Symbol sym, Object root, boolean replaceRoot) {
        Var dvout = ns.intern(sym);
        if (!dvout.hasRoot() || replaceRoot) {
            dvout.bindRoot(root);
        }
        return dvout;
    }

    public String toString() {
        if (this.ns != null) {
            return "#'" + this.ns.name + "/" + this.sym;
        }
        return "#<Var: " + (this.sym != null ? this.sym.toString() : "--unnamed--") + ">";
    }

    public static Var find(Symbol nsQualifiedSym) {
        if (nsQualifiedSym.ns == null) {
            throw new IllegalArgumentException("Symbol must be namespace-qualified");
        }
        Namespace ns = Namespace.find(Symbol.intern(nsQualifiedSym.ns));
        if (ns == null) {
            throw new IllegalArgumentException("No such namespace: " + nsQualifiedSym.ns);
        }
        return ns.findInternedVar(Symbol.intern(nsQualifiedSym.name));
    }

    public static Var intern(Symbol nsName, Symbol sym) {
        Namespace ns = Namespace.findOrCreate(nsName);
        return Var.intern(ns, sym);
    }

    public static Var internPrivate(String nsName, String sym) {
        Namespace ns = Namespace.findOrCreate(Symbol.intern(nsName));
        Var ret = Var.intern(ns, Symbol.intern(sym));
        ret.setMeta(privateMeta);
        return ret;
    }

    public static Var intern(Namespace ns, Symbol sym) {
        return ns.intern(sym);
    }

    public static Var create() {
        return new Var(null, null);
    }

    public static Var create(Object root) {
        return new Var(null, null, root);
    }

    Var(Namespace ns, Symbol sym) {
        this.ns = ns;
        this.sym = sym;
        this.threadBound = new AtomicBoolean(false);
        this.root = new Unbound(this);
        this.setMeta(PersistentHashMap.EMPTY);
    }

    Var(Namespace ns, Symbol sym, Object root) {
        this(ns, sym);
        this.root = root;
        ++rev;
    }

    public boolean isBound() {
        return this.hasRoot() || this.threadBound.get() && Var.dvals.get().bindings.containsKey(this);
    }

    public final Object get() {
        if (!this.threadBound.get()) {
            return this.root;
        }
        return this.deref();
    }

    @Override
    public final Object deref() {
        TBox b = this.getThreadBinding();
        if (b != null) {
            return b.val;
        }
        return this.root;
    }

    @Override
    public void setValidator(IFn vf) {
        if (this.hasRoot()) {
            this.validate(vf, this.root);
        }
        this.validator = vf;
    }

    public Object alter(IFn fn, ISeq args) {
        this.set(fn.applyTo(RT.cons(this.deref(), args)));
        return this;
    }

    public Object set(Object val2) {
        this.validate(this.getValidator(), val2);
        TBox b = this.getThreadBinding();
        if (b != null) {
            if (Thread.currentThread() != b.thread) {
                throw new IllegalStateException(String.format("Can't set!: %s from non-binding thread", this.sym));
            }
            b.val = val2;
            return b.val;
        }
        return null;
    }

    @Override
    public Object doSet(Object val2) {
        return this.set(val2);
    }

    @Override
    public Object doReset(Object val2) {
        this.bindRoot(val2);
        return val2;
    }

    public void setMeta(IPersistentMap m) {
        this.resetMeta(m.assoc(nameKey, this.sym).assoc(nsKey, this.ns));
    }

    public void setMacro() {
        this.alterMeta(assoc, RT.list(macroKey, RT.T));
    }

    public boolean isMacro() {
        return RT.booleanCast(this.meta().valAt(macroKey));
    }

    public boolean isPublic() {
        return !RT.booleanCast(this.meta().valAt(privateKey));
    }

    public final Object getRawRoot() {
        return this.root;
    }

    public Object getTag() {
        return this.meta().valAt(RT.TAG_KEY);
    }

    public void setTag(Symbol tag) {
        this.alterMeta(assoc, RT.list(RT.TAG_KEY, tag));
    }

    public static boolean hasRoot(Object v) {
        if (v instanceof Var) {
            return ((Var)v).hasRoot();
        }
        return v != null;
    }

    public final boolean hasRoot() {
        return !(this.root instanceof Unbound);
    }

    public synchronized void bindRoot(Object root) {
        this.validate(this.getValidator(), root);
        Object oldroot = this.root;
        this.root = root;
        ++rev;
        this.alterMeta(dissoc, RT.list(macroKey));
        this.notifyWatches(oldroot, this.root);
    }

    synchronized void swapRoot(Object root) {
        this.validate(this.getValidator(), root);
        Object oldroot = this.root;
        this.root = root;
        ++rev;
        this.notifyWatches(oldroot, root);
    }

    public synchronized void unbindRoot() {
        this.root = new Unbound(this);
        ++rev;
    }

    public synchronized void commuteRoot(IFn fn) {
        Object newRoot = fn.invoke(this.root);
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
    }

    public synchronized Object alterRoot(IFn fn, ISeq args) {
        Object newRoot = fn.applyTo(RT.cons(this.root, args));
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
        return newRoot;
    }

    public static Object alterVarRoot(Object var, IFn fn, ISeq args) {
        if (var instanceof Var) {
            return ((Var)var).alterRoot(fn, args);
        }
        Object newRoot = fn.applyTo(RT.cons(var, args));
        return newRoot;
    }

    public static void pushThreadBindings(Associative bindings) {
        Frame f = dvals.get();
        Associative bmap = f.bindings;
        for (ISeq bs = bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e = (IMapEntry)bs.first();
            Var v = (Var)e.key();
            if (!v.dynamic) {
                throw new IllegalStateException(String.format("Can't dynamically bind non-dynamic var: %s/%s", v.ns, v.sym));
            }
            v.validate(v.getValidator(), e.val());
            v.threadBound.set(true);
            bmap = bmap.assoc(v, new TBox(Thread.currentThread(), e.val()));
        }
        dvals.set(new Frame(bmap, f));
    }

    public static void popThreadBindings() {
        Frame f = Var.dvals.get().prev;
        if (f == null) {
            throw new IllegalStateException("Pop without matching push");
        }
        if (f == Frame.TOP) {
            dvals.remove();
        } else {
            dvals.set(f);
        }
    }

    public static Associative getThreadBindings() {
        Frame f = dvals.get();
        IPersistentMap ret = PersistentHashMap.EMPTY;
        for (ISeq bs = f.bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e = (IMapEntry)bs.first();
            Var v = (Var)e.key();
            TBox b = (TBox)e.val();
            ret = ret.assoc(v, b.val);
        }
        return ret;
    }

    public final TBox getThreadBinding() {
        IMapEntry e;
        if (this.threadBound.get() && (e = Var.dvals.get().bindings.entryAt(this)) != null) {
            return (TBox)e.val();
        }
        return null;
    }

    public final IFn fn() {
        return (IFn)this.deref();
    }

    public Object call() {
        return this.invoke();
    }

    @Override
    public void run() {
        this.invoke();
    }

    @Override
    public Object invoke() {
        return this.fn().invoke();
    }

    @Override
    public Object invoke(Object arg1) {
        Object object = arg1;
        arg1 = null;
        return this.fn().invoke(Util.ret1(object, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        Object[] objectArray = args;
        args = null;
        return this.fn().invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null), (Object[])Util.ret1(objectArray, null));
    }

    @Override
    public Object applyTo(ISeq arglist) {
        return AFn.applyToHelper(this, arglist);
    }

    static class Frame {
        static final Frame TOP = new Frame(PersistentHashMap.EMPTY, null);
        Associative bindings;
        Frame prev;

        public Frame(Associative bindings, Frame prev) {
            this.bindings = bindings;
            this.prev = prev;
        }

        protected Object clone() {
            return new Frame(this.bindings, null);
        }
    }

    public static class Unbound
    extends AFn {
        public final Var v;

        public Unbound(Var v) {
            this.v = v;
        }

        public String toString() {
            return "Unbound: " + this.v;
        }

        @Override
        public Object throwArity(int n) {
            throw new IllegalStateException("Attempting to call unbound fn: " + this.v);
        }
    }

    static class TBox {
        volatile Object val;
        final Thread thread;

        public TBox(Thread t, Object val2) {
            this.thread = t;
            this.val = val2;
        }
    }
}

