// Compiled by ClojureScript 1.9.521 {}
goog.provide('markdown.core');
goog.require('cljs.core');
goog.require('markdown.common');
goog.require('markdown.links');
goog.require('markdown.transformers');
markdown.core.init_transformer = (function markdown$core$init_transformer(p__18032){
var map__18043 = p__18032;
var map__18043__$1 = ((((!((map__18043 == null)))?((((map__18043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18043):map__18043);
var replacement_transformers = cljs.core.get.call(null,map__18043__$1,new cljs.core.Keyword(null,"replacement-transformers","replacement-transformers",-2028552897));
var custom_transformers = cljs.core.get.call(null,map__18043__$1,new cljs.core.Keyword(null,"custom-transformers","custom-transformers",1440601790));
var inhibit_separator = cljs.core.get.call(null,map__18043__$1,new cljs.core.Keyword(null,"inhibit-separator","inhibit-separator",1268116222));
return ((function (map__18043,map__18043__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (html,line,next_line,state){
var _STAR_inhibit_separator_STAR_18045 = markdown.common._STAR_inhibit_separator_STAR_;
markdown.common._STAR_inhibit_separator_STAR_ = inhibit_separator;

try{var vec__18046 = cljs.core.reduce.call(null,((function (_STAR_inhibit_separator_STAR_18045,map__18043,map__18043__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (p__18049,transformer){
var vec__18050 = p__18049;
var text = cljs.core.nth.call(null,vec__18050,(0),null);
var state__$1 = cljs.core.nth.call(null,vec__18050,(1),null);
return transformer.call(null,text,cljs.core.assoc.call(null,state__$1,new cljs.core.Keyword(null,"next-line","next-line",-1187000287),next_line));
});})(_STAR_inhibit_separator_STAR_18045,map__18043,map__18043__$1,replacement_transformers,custom_transformers,inhibit_separator))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,state], null),(function (){var or__6892__auto__ = replacement_transformers;
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return cljs.core.into.call(null,markdown.transformers.transformer_vector,custom_transformers);
}
})());
var text = cljs.core.nth.call(null,vec__18046,(0),null);
var new_state = cljs.core.nth.call(null,vec__18046,(1),null);
html.append(text);

return new_state;
}finally {markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR_18045;
}});
;})(map__18043,map__18043__$1,replacement_transformers,custom_transformers,inhibit_separator))
});
/**
 * Removed from cljs.core 0.0-1885, Ref. http://goo.gl/su7Xkj
 */
markdown.core.format = (function markdown$core$format(var_args){
var args__8012__auto__ = [];
var len__8005__auto___18055 = arguments.length;
var i__8006__auto___18056 = (0);
while(true){
if((i__8006__auto___18056 < len__8005__auto___18055)){
args__8012__auto__.push((arguments[i__8006__auto___18056]));

var G__18057 = (i__8006__auto___18056 + (1));
i__8006__auto___18056 = G__18057;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

markdown.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

markdown.core.format.cljs$lang$maxFixedArity = (1);

markdown.core.format.cljs$lang$applyTo = (function (seq18053){
var G__18054 = cljs.core.first.call(null,seq18053);
var seq18053__$1 = cljs.core.next.call(null,seq18053);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic(G__18054,seq18053__$1);
});

markdown.core.parse_references = (function markdown$core$parse_references(lines){
var references = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var seq__18062_18066 = cljs.core.seq.call(null,lines);
var chunk__18063_18067 = null;
var count__18064_18068 = (0);
var i__18065_18069 = (0);
while(true){
if((i__18065_18069 < count__18064_18068)){
var line_18070 = cljs.core._nth.call(null,chunk__18063_18067,i__18065_18069);
markdown.links.parse_reference_link.call(null,line_18070,references);

var G__18071 = seq__18062_18066;
var G__18072 = chunk__18063_18067;
var G__18073 = count__18064_18068;
var G__18074 = (i__18065_18069 + (1));
seq__18062_18066 = G__18071;
chunk__18063_18067 = G__18072;
count__18064_18068 = G__18073;
i__18065_18069 = G__18074;
continue;
} else {
var temp__4657__auto___18075 = cljs.core.seq.call(null,seq__18062_18066);
if(temp__4657__auto___18075){
var seq__18062_18076__$1 = temp__4657__auto___18075;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18062_18076__$1)){
var c__7711__auto___18077 = cljs.core.chunk_first.call(null,seq__18062_18076__$1);
var G__18078 = cljs.core.chunk_rest.call(null,seq__18062_18076__$1);
var G__18079 = c__7711__auto___18077;
var G__18080 = cljs.core.count.call(null,c__7711__auto___18077);
var G__18081 = (0);
seq__18062_18066 = G__18078;
chunk__18063_18067 = G__18079;
count__18064_18068 = G__18080;
i__18065_18069 = G__18081;
continue;
} else {
var line_18082 = cljs.core.first.call(null,seq__18062_18076__$1);
markdown.links.parse_reference_link.call(null,line_18082,references);

var G__18083 = cljs.core.next.call(null,seq__18062_18076__$1);
var G__18084 = null;
var G__18085 = (0);
var G__18086 = (0);
seq__18062_18066 = G__18083;
chunk__18063_18067 = G__18084;
count__18064_18068 = G__18085;
i__18065_18069 = G__18086;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,references);
});
markdown.core.parse_footnotes = (function markdown$core$parse_footnotes(lines){
var footnotes = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"next-fn-id","next-fn-id",738579636),(1),new cljs.core.Keyword(null,"processed","processed",800622264),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"unprocessed","unprocessed",766771972),cljs.core.PersistentArrayMap.EMPTY], null));
var seq__18091_18095 = cljs.core.seq.call(null,lines);
var chunk__18092_18096 = null;
var count__18093_18097 = (0);
var i__18094_18098 = (0);
while(true){
if((i__18094_18098 < count__18093_18097)){
var line_18099 = cljs.core._nth.call(null,chunk__18092_18096,i__18094_18098);
markdown.links.parse_footnote_link.call(null,line_18099,footnotes);

var G__18100 = seq__18091_18095;
var G__18101 = chunk__18092_18096;
var G__18102 = count__18093_18097;
var G__18103 = (i__18094_18098 + (1));
seq__18091_18095 = G__18100;
chunk__18092_18096 = G__18101;
count__18093_18097 = G__18102;
i__18094_18098 = G__18103;
continue;
} else {
var temp__4657__auto___18104 = cljs.core.seq.call(null,seq__18091_18095);
if(temp__4657__auto___18104){
var seq__18091_18105__$1 = temp__4657__auto___18104;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18091_18105__$1)){
var c__7711__auto___18106 = cljs.core.chunk_first.call(null,seq__18091_18105__$1);
var G__18107 = cljs.core.chunk_rest.call(null,seq__18091_18105__$1);
var G__18108 = c__7711__auto___18106;
var G__18109 = cljs.core.count.call(null,c__7711__auto___18106);
var G__18110 = (0);
seq__18091_18095 = G__18107;
chunk__18092_18096 = G__18108;
count__18093_18097 = G__18109;
i__18094_18098 = G__18110;
continue;
} else {
var line_18111 = cljs.core.first.call(null,seq__18091_18105__$1);
markdown.links.parse_footnote_link.call(null,line_18111,footnotes);

var G__18112 = cljs.core.next.call(null,seq__18091_18105__$1);
var G__18113 = null;
var G__18114 = (0);
var G__18115 = (0);
seq__18091_18095 = G__18112;
chunk__18092_18096 = G__18113;
count__18093_18097 = G__18114;
i__18094_18098 = G__18115;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,footnotes);
});
markdown.core.parse_metadata = (function markdown$core$parse_metadata(lines){
var vec__18120 = cljs.core.split_with.call(null,(function (p1__18116_SHARP_){
return cljs.core.not_empty.call(null,p1__18116_SHARP_.trim());
}),lines);
var metadata = cljs.core.nth.call(null,vec__18120,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__18120,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [markdown.transformers.parse_metadata_headers.call(null,metadata),lines__$1], null);
});
/**
 * processes input text line by line and outputs an HTML string
 */
markdown.core.md_to_html_string_STAR_ = (function markdown$core$md_to_html_string_STAR_(text,params){
var _STAR_substring_STAR_18138 = markdown.common._STAR_substring_STAR_;
var _STAR_formatter_STAR_18139 = markdown.transformers._STAR_formatter_STAR_;
markdown.common._STAR_substring_STAR_ = ((function (_STAR_substring_STAR_18138,_STAR_formatter_STAR_18139){
return (function (s,n){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.drop.call(null,n,s));
});})(_STAR_substring_STAR_18138,_STAR_formatter_STAR_18139))
;

markdown.transformers._STAR_formatter_STAR_ = markdown.core.format;

try{var params__$1 = (cljs.core.truth_(params)?cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.assoc,cljs.core.PersistentArrayMap.EMPTY),params):null);
var lines = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n")].join('').split("\n");
var html = (new goog.string.StringBuffer(""));
var references = (cljs.core.truth_(new cljs.core.Keyword(null,"reference-links?","reference-links?",-2003778981).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_references.call(null,lines):null);
var footnotes = (cljs.core.truth_(new cljs.core.Keyword(null,"footnotes?","footnotes?",-1590157845).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_footnotes.call(null,lines):null);
var vec__18140 = (cljs.core.truth_(new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_metadata.call(null,lines):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,lines], null));
var metadata = cljs.core.nth.call(null,vec__18140,(0),null);
var lines__$1 = cljs.core.nth.call(null,vec__18140,(1),null);
var transformer = markdown.core.init_transformer.call(null,params__$1);
var G__18146_18153 = lines__$1;
var vec__18147_18154 = G__18146_18153;
var seq__18148_18155 = cljs.core.seq.call(null,vec__18147_18154);
var first__18149_18156 = cljs.core.first.call(null,seq__18148_18155);
var seq__18148_18157__$1 = cljs.core.next.call(null,seq__18148_18155);
var line_18158 = first__18149_18156;
var more_18159 = seq__18148_18157__$1;
var state_18160 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"clojurescript","clojurescript",-299769403),true,new cljs.core.Keyword(null,"references","references",882562509),references,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205),footnotes,new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true], null),params__$1);
var G__18146_18161__$1 = G__18146_18153;
var state_18162__$1 = state_18160;
while(true){
var vec__18150_18163 = G__18146_18161__$1;
var seq__18151_18164 = cljs.core.seq.call(null,vec__18150_18163);
var first__18152_18165 = cljs.core.first.call(null,seq__18151_18164);
var seq__18151_18166__$1 = cljs.core.next.call(null,seq__18151_18164);
var line_18167__$1 = first__18152_18165;
var more_18168__$1 = seq__18151_18166__$1;
var state_18169__$2 = state_18162__$1;
var line_18170__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749).cljs$core$IFn$_invoke$arity$1(state_18169__$2))?"":line_18167__$1);
var state_18171__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_18169__$2))?transformer.call(null,html,new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_18169__$2),new cljs.core.Keyword(null,"next-line","next-line",-1187000287).cljs$core$IFn$_invoke$arity$1(state_18169__$2),cljs.core.assoc.call(null,cljs.core.dissoc.call(null,state_18169__$2,new cljs.core.Keyword(null,"buf","buf",-213913340),new cljs.core.Keyword(null,"lists","lists",-884730684),new cljs.core.Keyword(null,"next-line","next-line",-1187000287)),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true)):state_18169__$2);
if(cljs.core.truth_(cljs.core.not_empty.call(null,more_18168__$1))){
var G__18172 = more_18168__$1;
var G__18173 = cljs.core.assoc.call(null,transformer.call(null,html,line_18170__$2,cljs.core.first.call(null,more_18168__$1),cljs.core.dissoc.call(null,state_18171__$3,new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749))),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),cljs.core.empty_QMARK_.call(null,line_18170__$2));
G__18146_18161__$1 = G__18172;
state_18162__$1 = G__18173;
continue;
} else {
transformer.call(null,html.append(markdown.transformers.footer.call(null,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205).cljs$core$IFn$_invoke$arity$1(state_18171__$3))),line_18170__$2,"",cljs.core.assoc.call(null,state_18171__$3,new cljs.core.Keyword(null,"eof","eof",-489063237),true));
}
break;
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"metadata","metadata",1799301597),metadata,new cljs.core.Keyword(null,"html","html",-998796897),html.toString()], null);
}finally {markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR_18139;

markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR_18138;
}});
markdown.core.md__GT_html = (function markdown$core$md__GT_html(var_args){
var args__8012__auto__ = [];
var len__8005__auto___18176 = arguments.length;
var i__8006__auto___18177 = (0);
while(true){
if((i__8006__auto___18177 < len__8005__auto___18176)){
args__8012__auto__.push((arguments[i__8006__auto___18177]));

var G__18178 = (i__8006__auto___18177 + (1));
i__8006__auto___18177 = G__18178;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return new cljs.core.Keyword(null,"html","html",-998796897).cljs$core$IFn$_invoke$arity$1(markdown.core.md_to_html_string_STAR_.call(null,text,params));
});

markdown.core.md__GT_html.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html.cljs$lang$applyTo = (function (seq18174){
var G__18175 = cljs.core.first.call(null,seq18174);
var seq18174__$1 = cljs.core.next.call(null,seq18174);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic(G__18175,seq18174__$1);
});

markdown.core.md__GT_html_with_meta = (function markdown$core$md__GT_html_with_meta(var_args){
var args__8012__auto__ = [];
var len__8005__auto___18181 = arguments.length;
var i__8006__auto___18182 = (0);
while(true){
if((i__8006__auto___18182 < len__8005__auto___18181)){
args__8012__auto__.push((arguments[i__8006__auto___18182]));

var G__18183 = (i__8006__auto___18182 + (1));
i__8006__auto___18182 = G__18183;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return markdown.core.md_to_html_string_STAR_.call(null,text,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742),true], null),params));
});

markdown.core.md__GT_html_with_meta.cljs$lang$maxFixedArity = (1);

markdown.core.md__GT_html_with_meta.cljs$lang$applyTo = (function (seq18179){
var G__18180 = cljs.core.first.call(null,seq18179);
var seq18179__$1 = cljs.core.next.call(null,seq18179);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic(G__18180,seq18179__$1);
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtml = (function markdown$core$mdToHtml(var_args){
var args__8012__auto__ = [];
var len__8005__auto___18185 = arguments.length;
var i__8006__auto___18186 = (0);
while(true){
if((i__8006__auto___18186 < len__8005__auto___18185)){
args__8012__auto__.push((arguments[i__8006__auto___18186]));

var G__18187 = (i__8006__auto___18186 + (1));
i__8006__auto___18186 = G__18187;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((0) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(argseq__8013__auto__);
});
goog.exportSymbol('markdown.core.mdToHtml', markdown.core.mdToHtml);

markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html,params);
});

markdown.core.mdToHtml.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtml.cljs$lang$applyTo = (function (seq18184){
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18184));
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtmlWithMeta = (function markdown$core$mdToHtmlWithMeta(var_args){
var args__8012__auto__ = [];
var len__8005__auto___18189 = arguments.length;
var i__8006__auto___18190 = (0);
while(true){
if((i__8006__auto___18190 < len__8005__auto___18189)){
args__8012__auto__.push((arguments[i__8006__auto___18190]));

var G__18191 = (i__8006__auto___18190 + (1));
i__8006__auto___18190 = G__18191;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((0) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(argseq__8013__auto__);
});
goog.exportSymbol('markdown.core.mdToHtmlWithMeta', markdown.core.mdToHtmlWithMeta);

markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.call(null,markdown.core.md__GT_html_with_meta,params);
});

markdown.core.mdToHtmlWithMeta.cljs$lang$maxFixedArity = (0);

markdown.core.mdToHtmlWithMeta.cljs$lang$applyTo = (function (seq18188){
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18188));
});

