// Compiled by ClojureScript 1.9.521 {}
goog.provide('hickory.hiccup_utils');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * Given two possible indexes, returns the lesser that is not -1. If both
 * are -1, then -1 is returned. Useful for searching strings for multiple
 * markers, as many routines will return -1 for not found.
 * 
 * Examples: (first-idx -1 -1) => -1
 *           (first-idx -1 2) => 2
 *           (first-idx 5 -1) => 5
 *           (first-idx 5 3) => 3
 */
hickory.hiccup_utils.first_idx = (function hickory$hiccup_utils$first_idx(a,b){
if((a === (-1))){
return b;
} else {
if((b === (-1))){
return a;
} else {
var x__7235__auto__ = a;
var y__7236__auto__ = b;
return ((x__7235__auto__ < y__7236__auto__) ? x__7235__auto__ : y__7236__auto__);
}
}
});
hickory.hiccup_utils.index_of = (function hickory$hiccup_utils$index_of(var_args){
var args22751 = [];
var len__8005__auto___22754 = arguments.length;
var i__8006__auto___22755 = (0);
while(true){
if((i__8006__auto___22755 < len__8005__auto___22754)){
args22751.push((arguments[i__8006__auto___22755]));

var G__22756 = (i__8006__auto___22755 + (1));
i__8006__auto___22755 = G__22756;
continue;
} else {
}
break;
}

var G__22753 = args22751.length;
switch (G__22753) {
case 2:
return hickory.hiccup_utils.index_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hickory.hiccup_utils.index_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22751.length)].join('')));

}
});

hickory.hiccup_utils.index_of.cljs$core$IFn$_invoke$arity$2 = (function (s,c){
return s.indexOf(c);
});

hickory.hiccup_utils.index_of.cljs$core$IFn$_invoke$arity$3 = (function (s,c,idx){
return s.indexOf(c,idx);
});

hickory.hiccup_utils.index_of.cljs$lang$maxFixedArity = 3;

/**
 * clojure.string/split is a wrapper on java.lang.String/split with the limit
 * parameter equal to 0, which keeps leading empty strings, but discards
 * trailing empty strings. This makes no sense, so we have to write our own
 * to keep the trailing empty strings.
 */
hickory.hiccup_utils.split_keep_trailing_empty = (function hickory$hiccup_utils$split_keep_trailing_empty(s,re){
return clojure.string.split.call(null,s,re,(-1));
});
/**
 * Given a hiccup tag element, returns true iff the tag is in 'valid' hiccup
 * format. Which in this function means:
 *    1. Tag name is non-empty.
 *    2. If there is an id, there is only one.
 *    3. If there is an id, it is nonempty.
 *    4. If there is an id, it comes before any classes.
 *    5. Any class name is nonempty.
 */
hickory.hiccup_utils.tag_well_formed_QMARK_ = (function hickory$hiccup_utils$tag_well_formed_QMARK_(tag_elem){
var tag_elem__$1 = cljs.core.name.call(null,tag_elem);
var hash_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,"#") | (0));
var dot_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".") | (0));
var tag_cutoff = hickory.hiccup_utils.first_idx.call(null,hash_idx,dot_idx);
var and__6880__auto__ = ((0) < cljs.core.count.call(null,tag_elem__$1));
if(and__6880__auto__){
var and__6880__auto____$1 = (((tag_cutoff === (-1)))?true:(tag_cutoff > (0)));
if(and__6880__auto____$1){
var and__6880__auto____$2 = (((hash_idx === (-1)))?true:(((-1) === hickory.hiccup_utils.index_of.call(null,tag_elem__$1,"#",(hash_idx + (1))))) && (((hash_idx + (1)) < hickory.hiccup_utils.first_idx.call(null,hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".",(hash_idx + (1))),cljs.core.count.call(null,tag_elem__$1)))));
if(and__6880__auto____$2){
var and__6880__auto____$3 = (((cljs.core.not_EQ_.call(null,hash_idx,(-1))) && (cljs.core.not_EQ_.call(null,dot_idx,(-1))))?(hash_idx < dot_idx):true);
if(and__6880__auto____$3){
if((dot_idx === (-1))){
return true;
} else {
var classes = tag_elem__$1.substring((dot_idx + (1)));
return cljs.core.every_QMARK_.call(null,((function (classes,and__6880__auto____$3,and__6880__auto____$2,and__6880__auto____$1,and__6880__auto__,tag_elem__$1,hash_idx,dot_idx,tag_cutoff){
return (function (p1__22758_SHARP_){
return ((0) < cljs.core.count.call(null,p1__22758_SHARP_));
});})(classes,and__6880__auto____$3,and__6880__auto____$2,and__6880__auto____$1,and__6880__auto__,tag_elem__$1,hash_idx,dot_idx,tag_cutoff))
,hickory.hiccup_utils.split_keep_trailing_empty.call(null,classes,/\./));
}
} else {
return and__6880__auto____$3;
}
} else {
return and__6880__auto____$2;
}
} else {
return and__6880__auto____$1;
}
} else {
return and__6880__auto__;
}
});
/**
 * Given a well-formed hiccup tag element, return just the tag name as
 *   a string.
 */
hickory.hiccup_utils.tag_name = (function hickory$hiccup_utils$tag_name(tag_elem){
var tag_elem__$1 = cljs.core.name.call(null,tag_elem);
var hash_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,"#") | (0));
var dot_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".") | (0));
var cutoff = hickory.hiccup_utils.first_idx.call(null,hash_idx,dot_idx);
if((cutoff === (-1))){
return tag_elem__$1;
} else {
return tag_elem__$1.substring((0),cutoff);
}
});
/**
 * Given a well-formed hiccup tag element, return a vector containing
 * any class names included in the tag, as strings. Ignores the hiccup
 * requirement that any id on the tag must come
 * first. Example: :div.foo.bar => ["foo" "bar"].
 */
hickory.hiccup_utils.class_names = (function hickory$hiccup_utils$class_names(tag_elem){
var tag_elem__$1 = cljs.core.name.call(null,tag_elem);
var curr_dot = hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".");
var classes = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
if((curr_dot === (-1))){
return cljs.core.persistent_BANG_.call(null,classes);
} else {
var next_dot = hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".",(curr_dot + (1)));
var next_hash = hickory.hiccup_utils.index_of.call(null,tag_elem__$1,"#",(curr_dot + (1)));
var cutoff = hickory.hiccup_utils.first_idx.call(null,next_dot,next_hash);
if((cutoff === (-1))){
var G__22759 = next_dot;
var G__22760 = cljs.core.conj_BANG_.call(null,classes,tag_elem__$1.substring((curr_dot + (1))));
curr_dot = G__22759;
classes = G__22760;
continue;
} else {
var G__22761 = next_dot;
var G__22762 = cljs.core.conj_BANG_.call(null,classes,tag_elem__$1.substring((curr_dot + (1)),cutoff));
curr_dot = G__22761;
classes = G__22762;
continue;
}
}
break;
}
});
/**
 * Given a well-formed hiccup tag element, return a string containing
 * the id, or nil if there isn't one.
 */
hickory.hiccup_utils.id = (function hickory$hiccup_utils$id(tag_elem){
var tag_elem__$1 = cljs.core.name.call(null,tag_elem);
var hash_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,"#") | (0));
var next_dot_idx = (hickory.hiccup_utils.index_of.call(null,tag_elem__$1,".",hash_idx) | (0));
if((hash_idx === (-1))){
return null;
} else {
if((next_dot_idx === (-1))){
return tag_elem__$1.substring((hash_idx + (1)));
} else {
return tag_elem__$1.substring((hash_idx + (1)),next_dot_idx);
}
}
});
/**
 * Given a sequence of hiccup forms, presumably the content forms of another
 * hiccup element, return a new sequence with any sequence elements expanded
 * into the main sequence. This logic does not apply recursively, so sequences
 * inside sequences won't be expanded out. Also note that this really only
 * applies to sequences; things that seq? returns true on. So this excludes
 * vectors.
 *   (expand-content-seqs [1 '(2 3) (for [x [1 2 3]] (* x 2)) [5]])
 *   ==> (1 2 3 2 4 6 [5])
 */
hickory.hiccup_utils.expand_content_seqs = (function hickory$hiccup_utils$expand_content_seqs(content){
var remaining_content = content;
var result = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
if((remaining_content == null)){
return cljs.core.persistent_BANG_.call(null,result);
} else {
if(cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,remaining_content))){
var G__22763 = cljs.core.next.call(null,remaining_content);
var G__22764 = (function (){var remaining_seq = cljs.core.first.call(null,remaining_content);
var result__$1 = result;
while(true){
if((remaining_seq == null)){
return result__$1;
} else {
var G__22765 = cljs.core.next.call(null,remaining_seq);
var G__22766 = cljs.core.conj_BANG_.call(null,result__$1,cljs.core.first.call(null,remaining_seq));
remaining_seq = G__22765;
result__$1 = G__22766;
continue;
}
break;
}
})();
remaining_content = G__22763;
result = G__22764;
continue;
} else {
var G__22767 = cljs.core.next.call(null,remaining_content);
var G__22768 = cljs.core.conj_BANG_.call(null,result,cljs.core.first.call(null,remaining_content));
remaining_content = G__22767;
result = G__22768;
continue;
}
}
break;
}
});
/**
 * Given a well-formed hiccup form, ensure that it is in the form
 *   [tag attributes content1 ... contentN].
 * That is, an unadorned tag name (keyword, lowercase), all attributes in the
 * attribute map in the second element, and then any children. Note that this
 * does not happen recursively; content is not modified.
 */
hickory.hiccup_utils.normalize_element = (function hickory$hiccup_utils$normalize_element(hiccup_form){
var vec__22775 = hiccup_form;
var seq__22776 = cljs.core.seq.call(null,vec__22775);
var first__22777 = cljs.core.first.call(null,seq__22776);
var seq__22776__$1 = cljs.core.next.call(null,seq__22776);
var tag_elem = first__22777;
var content = seq__22776__$1;
if(cljs.core.not.call(null,hickory.hiccup_utils.tag_well_formed_QMARK_.call(null,tag_elem))){
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid input: Tag element"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_elem),cljs.core.str.cljs$core$IFn$_invoke$arity$1("is not well-formed.")].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

var tag_name = cljs.core.keyword.call(null,clojure.string.lower_case.call(null,hickory.hiccup_utils.tag_name.call(null,tag_elem)));
var tag_classes = hickory.hiccup_utils.class_names.call(null,tag_elem);
var tag_id = hickory.hiccup_utils.id.call(null,tag_elem);
var tag_attrs = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),tag_id,new cljs.core.Keyword(null,"class","class",-2030961996),((!(cljs.core.empty_QMARK_.call(null,tag_classes)))?clojure.string.join.call(null," ",tag_classes):null)], null);
var vec__22778 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,content)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,content),cljs.core.rest.call(null,content)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,content], null));
var map_attrs = cljs.core.nth.call(null,vec__22778,(0),null);
var content__$1 = cljs.core.nth.call(null,vec__22778,(1),null);
var attrs = cljs.core.merge.call(null,tag_attrs,map_attrs);
return cljs.core.apply.call(null,cljs.core.vector,tag_name,attrs,content__$1);
});
/**
 * Given a well-formed hiccup form, recursively normalizes it, so that it and
 * all children elements will also be normalized. A normalized form is in the
 * form
 *   [tag attributes content1 ... contentN].
 * That is, an unadorned tag name (keyword, lowercase), all attributes in the
 * attribute map in the second element, and then any children. Any content
 * that is a sequence is also expanded out into the main sequence of content
 * items.
 */
hickory.hiccup_utils.normalize_form = (function hickory$hiccup_utils$normalize_form(form){
if(typeof form === 'string'){
return form;
} else {
var vec__22785 = hickory.hiccup_utils.normalize_element.call(null,form);
var seq__22786 = cljs.core.seq.call(null,vec__22785);
var first__22787 = cljs.core.first.call(null,seq__22786);
var seq__22786__$1 = cljs.core.next.call(null,seq__22786);
var tag = first__22787;
var first__22787__$1 = cljs.core.first.call(null,seq__22786__$1);
var seq__22786__$2 = cljs.core.next.call(null,seq__22786__$1);
var attrs = first__22787__$1;
var contents = seq__22786__$2;
return cljs.core.apply.call(null,cljs.core.vector,tag,attrs,cljs.core.map.call(null,((function (vec__22785,seq__22786,first__22787,seq__22786__$1,tag,first__22787__$1,seq__22786__$2,attrs,contents){
return (function (p1__22781_SHARP_){
if(cljs.core.vector_QMARK_.call(null,p1__22781_SHARP_)){
return hickory.hiccup_utils.normalize_form.call(null,p1__22781_SHARP_);
} else {
return p1__22781_SHARP_;
}
});})(vec__22785,seq__22786,first__22787,seq__22786__$1,tag,first__22787__$1,seq__22786__$2,attrs,contents))
,hickory.hiccup_utils.expand_content_seqs.call(null,contents)));
}
});
