// Compiled by ClojureScript 1.9.521 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__8012__auto__ = [];
var len__8005__auto___17370 = arguments.length;
var i__8006__auto___17371 = (0);
while(true){
if((i__8006__auto___17371 < len__8005__auto___17370)){
args__8012__auto__.push((arguments[i__8006__auto___17371]));

var G__17372 = (i__8006__auto___17371 + (1));
i__8006__auto___17371 = G__17372;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((0) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__8013__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq17369){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17369));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__8012__auto__ = [];
var len__8005__auto___17380 = arguments.length;
var i__8006__auto___17381 = (0);
while(true){
if((i__8006__auto___17381 < len__8005__auto___17380)){
args__8012__auto__.push((arguments[i__8006__auto___17381]));

var G__17382 = (i__8006__auto___17381 + (1));
i__8006__auto___17381 = G__17382;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((3) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8013__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__17377){
var map__17378 = p__17377;
var map__17378__$1 = ((((!((map__17378 == null)))?((((map__17378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17378.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17378):map__17378);
var merge_fn = cljs.core.get.call(null,map__17378__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq17373){
var G__17374 = cljs.core.first.call(null,seq17373);
var seq17373__$1 = cljs.core.next.call(null,seq17373);
var G__17375 = cljs.core.first.call(null,seq17373__$1);
var seq17373__$2 = cljs.core.next.call(null,seq17373__$1);
var G__17376 = cljs.core.first.call(null,seq17373__$2);
var seq17373__$3 = cljs.core.next.call(null,seq17373__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__17374,G__17375,G__17376,seq17373__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,((function (latenavfn){
return (function() { 
var G__17383__delegate = function (args){
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,args))){
return latenavfn.call(null,cljs.core.first.call(null,args));
} else {
return cljs.core.map.call(null,latenavfn,args);
}
};
var G__17383 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17384__i = 0, G__17384__a = new Array(arguments.length -  0);
while (G__17384__i < G__17384__a.length) {G__17384__a[G__17384__i] = arguments[G__17384__i + 0]; ++G__17384__i;}
  args = new cljs.core.IndexedSeq(G__17384__a,0);
} 
return G__17383__delegate.call(this,args);};
G__17383.cljs$lang$maxFixedArity = 0;
G__17383.cljs$lang$applyTo = (function (arglist__17385){
var args = cljs.core.seq(arglist__17385);
return G__17383__delegate(args);
});
G__17383.cljs$core$IFn$_invoke$arity$variadic = G__17383__delegate;
return G__17383;
})()
;})(latenavfn))
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17386 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17386 = (function (meta17387){
this.meta17387 = meta17387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17388,meta17387__$1){
var self__ = this;
var _17388__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17386(meta17387__$1));
});

com.rpl.specter.t_com$rpl$specter17386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17388){
var self__ = this;
var _17388__$1 = this;
return self__.meta17387;
});

com.rpl.specter.t_com$rpl$specter17386.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17386.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter17386.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter17386.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17387","meta17387",-1340022937,null)], null);
});

com.rpl.specter.t_com$rpl$specter17386.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17386.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17386";

com.rpl.specter.t_com$rpl$specter17386.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17386");
});

com.rpl.specter.__GT_t_com$rpl$specter17386 = (function com$rpl$specter$__GT_t_com$rpl$specter17386(meta17387){
return (new com.rpl.specter.t_com$rpl$specter17386(meta17387));
});

}

return (new com.rpl.specter.t_com$rpl$specter17386(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter17389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17389 = (function (afn,meta17390){
this.afn = afn;
this.meta17390 = meta17390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17391,meta17390__$1){
var self__ = this;
var _17391__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17389(self__.afn,meta17390__$1));
});

com.rpl.specter.t_com$rpl$specter17389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17391){
var self__ = this;
var _17391__$1 = this;
return self__.meta17390;
});

com.rpl.specter.t_com$rpl$specter17389.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17389.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});

com.rpl.specter.t_com$rpl$specter17389.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter17389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta17390","meta17390",222724006,null)], null);
});

com.rpl.specter.t_com$rpl$specter17389.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17389.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17389";

com.rpl.specter.t_com$rpl$specter17389.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17389");
});

com.rpl.specter.__GT_t_com$rpl$specter17389 = (function com$rpl$specter$__GT_t_com$rpl$specter17389(afn__$1,meta17390){
return (new com.rpl.specter.t_com$rpl$specter17389(afn__$1,meta17390));
});

}

return (new com.rpl.specter.t_com$rpl$specter17389(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17392 = (function (meta17393){
this.meta17393 = meta17393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17394,meta17393__$1){
var self__ = this;
var _17394__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17392(meta17393__$1));
});

com.rpl.specter.t_com$rpl$specter17392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17394){
var self__ = this;
var _17394__$1 = this;
return self__.meta17393;
});

com.rpl.specter.t_com$rpl$specter17392.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17392.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter17392.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter17392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17393","meta17393",-1241391408,null)], null);
});

com.rpl.specter.t_com$rpl$specter17392.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17392.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17392";

com.rpl.specter.t_com$rpl$specter17392.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17392");
});

com.rpl.specter.__GT_t_com$rpl$specter17392 = (function com$rpl$specter$__GT_t_com$rpl$specter17392(meta17393){
return (new com.rpl.specter.t_com$rpl$specter17392(meta17393));
});

}

return (new com.rpl.specter.t_com$rpl$specter17392(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__14369__auto__,v){
var ret__14370__auto__ = next_fn.call(null,v);
if((ret__14370__auto__ === com.rpl.specter.NONE)){
return curr__14369__auto__;
} else {
return ret__14370__auto__;
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17395 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17395 = (function (meta17396){
this.meta17396 = meta17396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17397,meta17396__$1){
var self__ = this;
var _17397__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17395(meta17396__$1));
});

com.rpl.specter.t_com$rpl$specter17395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17397){
var self__ = this;
var _17397__$1 = this;
return self__.meta17396;
});

com.rpl.specter.t_com$rpl$specter17395.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17395.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__16117__auto____$1){
return (function (curr__14369__auto__,v){
var ret__14370__auto__ = next_fn.call(null,v);
if((ret__14370__auto__ === com.rpl.specter.NONE)){
return curr__14369__auto__;
} else {
return ret__14370__auto__;
}
});})(next_fn,this__16117__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17395.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter17395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17396","meta17396",-144765119,null)], null);
});

com.rpl.specter.t_com$rpl$specter17395.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17395.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17395";

com.rpl.specter.t_com$rpl$specter17395.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17395");
});

com.rpl.specter.__GT_t_com$rpl$specter17395 = (function com$rpl$specter$__GT_t_com$rpl$specter17395(meta17396){
return (new com.rpl.specter.t_com$rpl$specter17395(meta17396));
});

}

return (new com.rpl.specter.t_com$rpl$specter17395(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17398 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17398 = (function (meta17399){
this.meta17399 = meta17399;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17398.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17400,meta17399__$1){
var self__ = this;
var _17400__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17398(meta17399__$1));
});

com.rpl.specter.t_com$rpl$specter17398.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17400){
var self__ = this;
var _17400__$1 = this;
return self__.meta17399;
});

com.rpl.specter.t_com$rpl$specter17398.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17398.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter17398.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter17398.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17399","meta17399",1102856562,null)], null);
});

com.rpl.specter.t_com$rpl$specter17398.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17398.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17398";

com.rpl.specter.t_com$rpl$specter17398.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17398");
});

com.rpl.specter.__GT_t_com$rpl$specter17398 = (function com$rpl$specter$__GT_t_com$rpl$specter17398(meta17399){
return (new com.rpl.specter.t_com$rpl$specter17398(meta17399));
});

}

return (new com.rpl.specter.t_com$rpl$specter17398(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start_fn.call(null,structure),end_fn.call(null,structure),next_fn);
});

/**
 * Uses start-fn and end-fn to determine the bounds of the subsequence
 *        to select when navigating. Each function takes in the structure as input.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_fn,end_fn){
if(typeof com.rpl.specter.t_com$rpl$specter17401 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17401 = (function (start_fn,end_fn,meta17402){
this.start_fn = start_fn;
this.end_fn = end_fn;
this.meta17402 = meta17402;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17401.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17403,meta17402__$1){
var self__ = this;
var _17403__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17401(self__.start_fn,self__.end_fn,meta17402__$1));
});

com.rpl.specter.t_com$rpl$specter17401.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17403){
var self__ = this;
var _17403__$1 = this;
return self__.meta17402;
});

com.rpl.specter.t_com$rpl$specter17401.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17401.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter17401.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start_fn.call(null,structure),self__.end_fn.call(null,structure),next_fn);
});

com.rpl.specter.t_com$rpl$specter17401.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-fn","start-fn",-1617360859,null),new cljs.core.Symbol(null,"end-fn","end-fn",1694587211,null),new cljs.core.Symbol(null,"meta17402","meta17402",-954798538,null)], null);
});

com.rpl.specter.t_com$rpl$specter17401.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17401.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17401";

com.rpl.specter.t_com$rpl$specter17401.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17401");
});

com.rpl.specter.__GT_t_com$rpl$specter17401 = (function com$rpl$specter$__GT_t_com$rpl$specter17401(start_fn__$1,end_fn__$1,meta17402){
return (new com.rpl.specter.t_com$rpl$specter17401(start_fn__$1,end_fn__$1,meta17402));
});

}

return (new com.rpl.specter.t_com$rpl$specter17401(start_fn,end_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter17404 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17404 = (function (start,end,meta17405){
this.start = start;
this.end = end;
this.meta17405 = meta17405;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17404.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17406,meta17405__$1){
var self__ = this;
var _17406__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17404(self__.start,self__.end,meta17405__$1));
});

com.rpl.specter.t_com$rpl$specter17404.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17406){
var self__ = this;
var _17406__$1 = this;
return self__.meta17405;
});

com.rpl.specter.t_com$rpl$specter17404.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17404.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter17404.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter17404.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta17405","meta17405",786698129,null)], null);
});

com.rpl.specter.t_com$rpl$specter17404.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17404.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17404";

com.rpl.specter.t_com$rpl$specter17404.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17404");
});

com.rpl.specter.__GT_t_com$rpl$specter17404 = (function com$rpl$specter$__GT_t_com$rpl$specter17404(start__$1,end__$1,meta17405){
return (new com.rpl.specter.t_com$rpl$specter17404(start__$1,end__$1,meta17405));
});

}

return (new com.rpl.specter.t_com$rpl$specter17404(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__14369__auto__,p__17411){
var vec__17412 = p__17411;
var s = cljs.core.nth.call(null,vec__17412,(0),null);
var e = cljs.core.nth.call(null,vec__17412,(1),null);
var ret__14370__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__14370__auto__ === com.rpl.specter.NONE)){
return curr__14369__auto__;
} else {
return ret__14370__auto__;
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter17415 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17415 = (function (pred,meta17416){
this.pred = pred;
this.meta17416 = meta17416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17417,meta17416__$1){
var self__ = this;
var _17417__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17415(self__.pred,meta17416__$1));
});

com.rpl.specter.t_com$rpl$specter17415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17417){
var self__ = this;
var _17417__$1 = this;
return self__.meta17416;
});

com.rpl.specter.t_com$rpl$specter17415.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17415.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__16117__auto____$1){
return (function (curr__14369__auto__,p__17418){
var vec__17419 = p__17418;
var s = cljs.core.nth.call(null,vec__17419,(0),null);
var e = cljs.core.nth.call(null,vec__17419,(1),null);
var ret__14370__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__14370__auto__ === com.rpl.specter.NONE)){
return curr__14369__auto__;
} else {
return ret__14370__auto__;
}
});})(next_fn,this__16117__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});

com.rpl.specter.t_com$rpl$specter17415.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter17415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta17416","meta17416",1012592487,null)], null);
});

com.rpl.specter.t_com$rpl$specter17415.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17415.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17415";

com.rpl.specter.t_com$rpl$specter17415.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17415");
});

com.rpl.specter.__GT_t_com$rpl$specter17415 = (function com$rpl$specter$__GT_t_com$rpl$specter17415(pred__$1,meta17416){
return (new com.rpl.specter.t_com$rpl$specter17415(pred__$1,meta17416));
});

}

return (new com.rpl.specter.t_com$rpl$specter17415(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17422 = (function (meta17423){
this.meta17423 = meta17423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17424,meta17423__$1){
var self__ = this;
var _17424__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17422(meta17423__$1));
});

com.rpl.specter.t_com$rpl$specter17422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17424){
var self__ = this;
var _17424__$1 = this;
return self__.meta17423;
});

com.rpl.specter.t_com$rpl$specter17422.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17422.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter17422.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
});

com.rpl.specter.t_com$rpl$specter17422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17423","meta17423",1813781225,null)], null);
});

com.rpl.specter.t_com$rpl$specter17422.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17422.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17422";

com.rpl.specter.t_com$rpl$specter17422.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17422");
});

com.rpl.specter.__GT_t_com$rpl$specter17422 = (function com$rpl$specter$__GT_t_com$rpl$specter17422(meta17423){
return (new com.rpl.specter.t_com$rpl$specter17422(meta17423));
});

}

return (new com.rpl.specter.t_com$rpl$specter17422(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17425 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17425 = (function (meta17426){
this.meta17426 = meta17426;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17425.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17427,meta17426__$1){
var self__ = this;
var _17427__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17425(meta17426__$1));
});

com.rpl.specter.t_com$rpl$specter17425.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17427){
var self__ = this;
var _17427__$1 = this;
return self__.meta17426;
});

com.rpl.specter.t_com$rpl$specter17425.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17425.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter17425.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
});

com.rpl.specter.t_com$rpl$specter17425.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17426","meta17426",430463975,null)], null);
});

com.rpl.specter.t_com$rpl$specter17425.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17425.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17425";

com.rpl.specter.t_com$rpl$specter17425.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17425");
});

com.rpl.specter.__GT_t_com$rpl$specter17425 = (function com$rpl$specter$__GT_t_com$rpl$specter17425(meta17426){
return (new com.rpl.specter.t_com$rpl$specter17425(meta17426));
});

}

return (new com.rpl.specter.t_com$rpl$specter17425(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter17428 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17428 = (function (aset,meta17429){
this.aset = aset;
this.meta17429 = meta17429;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17428.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17430,meta17429__$1){
var self__ = this;
var _17430__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17428(self__.aset,meta17429__$1));
});

com.rpl.specter.t_com$rpl$specter17428.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17430){
var self__ = this;
var _17430__$1 = this;
return self__.meta17429;
});

com.rpl.specter.t_com$rpl$specter17428.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17428.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});

com.rpl.specter.t_com$rpl$specter17428.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter17428.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta17429","meta17429",1503770683,null)], null);
});

com.rpl.specter.t_com$rpl$specter17428.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17428.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17428";

com.rpl.specter.t_com$rpl$specter17428.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17428");
});

com.rpl.specter.__GT_t_com$rpl$specter17428 = (function com$rpl$specter$__GT_t_com$rpl$specter17428(aset__$1,meta17429){
return (new com.rpl.specter.t_com$rpl$specter17428(aset__$1,meta17429));
});

}

return (new com.rpl.specter.t_com$rpl$specter17428(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter17431 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17431 = (function (m_keys,meta17432){
this.m_keys = m_keys;
this.meta17432 = meta17432;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17431.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17433,meta17432__$1){
var self__ = this;
var _17433__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17431(self__.m_keys,meta17432__$1));
});

com.rpl.specter.t_com$rpl$specter17431.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17433){
var self__ = this;
var _17433__$1 = this;
return self__.meta17432;
});

com.rpl.specter.t_com$rpl$specter17431.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17431.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});

com.rpl.specter.t_com$rpl$specter17431.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter17431.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta17432","meta17432",-1105043736,null)], null);
});

com.rpl.specter.t_com$rpl$specter17431.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17431.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17431";

com.rpl.specter.t_com$rpl$specter17431.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17431");
});

com.rpl.specter.__GT_t_com$rpl$specter17431 = (function com$rpl$specter$__GT_t_com$rpl$specter17431(m_keys__$1,meta17432){
return (new com.rpl.specter.t_com$rpl$specter17431(m_keys__$1,meta17432));
});

}

return (new com.rpl.specter.t_com$rpl$specter17431(m_keys,null));
}));


com.rpl.specter.walker_select_STAR_ = (function com$rpl$specter$walker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.walker_transform_STAR_ = (function com$rpl$specter$walker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_until.call(null,afn,next_fn,structure);
});

/**
 * Using clojure.walk, navigate the data structure until reaching
 *        a value for which `afn` returns truthy.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter17434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17434 = (function (afn,meta17435){
this.afn = afn;
this.meta17435 = meta17435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17436,meta17435__$1){
var self__ = this;
var _17436__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17434(self__.afn,meta17435__$1));
});

com.rpl.specter.t_com$rpl$specter17434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17436){
var self__ = this;
var _17436__$1 = this;
return self__.meta17435;
});

com.rpl.specter.t_com$rpl$specter17434.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17434.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter17434.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.walk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter17434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta17435","meta17435",472407260,null)], null);
});

com.rpl.specter.t_com$rpl$specter17434.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17434.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17434";

com.rpl.specter.t_com$rpl$specter17434.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17434");
});

com.rpl.specter.__GT_t_com$rpl$specter17434 = (function com$rpl$specter$__GT_t_com$rpl$specter17434(afn__$1,meta17435){
return (new com.rpl.specter.t_com$rpl$specter17434(afn__$1,meta17435));
});

}

return (new com.rpl.specter.t_com$rpl$specter17434(afn,null));
}));


com.rpl.specter.codewalker_select_STAR_ = (function com$rpl$specter$codewalker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select.call(null,afn,next_fn,structure);
});

com.rpl.specter.codewalker_transform_STAR_ = (function com$rpl$specter$codewalker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.impl.codewalk_until.call(null,afn,next_fn,structure);
});

/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter17437 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17437 = (function (afn,meta17438){
this.afn = afn;
this.meta17438 = meta17438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17439,meta17438__$1){
var self__ = this;
var _17439__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17437(self__.afn,meta17438__$1));
});

com.rpl.specter.t_com$rpl$specter17437.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17439){
var self__ = this;
var _17439__$1 = this;
return self__.meta17438;
});

com.rpl.specter.t_com$rpl$specter17437.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17437.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.navs.walk_select.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter17437.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return com.rpl.specter.impl.codewalk_until.call(null,self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter17437.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta17438","meta17438",-2080262844,null)], null);
});

com.rpl.specter.t_com$rpl$specter17437.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17437.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17437";

com.rpl.specter.t_com$rpl$specter17437.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17437");
});

com.rpl.specter.__GT_t_com$rpl$specter17437 = (function com$rpl$specter$__GT_t_com$rpl$specter17437(afn__$1,meta17438){
return (new com.rpl.specter.t_com$rpl$specter17437(afn__$1,meta17438));
});

}

return (new com.rpl.specter.t_com$rpl$specter17437(afn,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,(function() { 
var G__17443__delegate = function (path){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter17440 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17440 = (function (path,late,meta17441){
this.path = path;
this.late = late;
this.meta17441 = meta17441;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17440.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17442,meta17441__$1){
var self__ = this;
var _17442__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17440(self__.path,self__.late,meta17441__$1));
});

com.rpl.specter.t_com$rpl$specter17440.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17442){
var self__ = this;
var _17442__$1 = this;
return self__.meta17441;
});

com.rpl.specter.t_com$rpl$specter17440.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17440.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});

com.rpl.specter.t_com$rpl$specter17440.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__16117__auto____$1){
return (function (_){
var next_val = cljs.core.first.call(null,com.rpl.specter.impl.get_cell.call(null,values_to_insert));
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.rest);

return next_val;
});})(select_result,transformed,values_to_insert,next_fn,this__16117__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter17440.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta17441","meta17441",319828858,null)], null);
});

com.rpl.specter.t_com$rpl$specter17440.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17440.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17440";

com.rpl.specter.t_com$rpl$specter17440.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17440");
});

com.rpl.specter.__GT_t_com$rpl$specter17440 = (function com$rpl$specter$__GT_t_com$rpl$specter17440(path__$1,late__$1,meta17441){
return (new com.rpl.specter.t_com$rpl$specter17440(path__$1,late__$1,meta17441));
});

}

return (new com.rpl.specter.t_com$rpl$specter17440(path,late,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
};
var G__17443 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17444__i = 0, G__17444__a = new Array(arguments.length -  0);
while (G__17444__i < G__17444__a.length) {G__17444__a[G__17444__i] = arguments[G__17444__i + 0]; ++G__17444__i;}
  path = new cljs.core.IndexedSeq(G__17444__a,0);
} 
return G__17443__delegate.call(this,path);};
G__17443.cljs$lang$maxFixedArity = 0;
G__17443.cljs$lang$applyTo = (function (arglist__17445){
var path = cljs.core.seq(arglist__17445);
return G__17443__delegate(path);
});
G__17443.cljs$core$IFn$_invoke$arity$variadic = G__17443__delegate;
return G__17443;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter17446 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17446 = (function (afn,meta17447){
this.afn = afn;
this.meta17447 = meta17447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17448,meta17447__$1){
var self__ = this;
var _17448__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17446(self__.afn,meta17447__$1));
});

com.rpl.specter.t_com$rpl$specter17446.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17448){
var self__ = this;
var _17448__$1 = this;
return self__.meta17447;
});

com.rpl.specter.t_com$rpl$specter17446.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17446.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17446.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17446.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta17447","meta17447",153528133,null)], null);
});

com.rpl.specter.t_com$rpl$specter17446.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17446.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17446";

com.rpl.specter.t_com$rpl$specter17446.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17446");
});

com.rpl.specter.__GT_t_com$rpl$specter17446 = (function com$rpl$specter$__GT_t_com$rpl$specter17446(afn__$1,meta17447){
return (new com.rpl.specter.t_com$rpl$specter17446(afn__$1,meta17447));
});

}

return (new com.rpl.specter.t_com$rpl$specter17446(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter17449 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17449 = (function (parse_fn,unparse_fn,meta17450){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta17450 = meta17450;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17449.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17451,meta17450__$1){
var self__ = this;
var _17451__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17449(self__.parse_fn,self__.unparse_fn,meta17450__$1));
});

com.rpl.specter.t_com$rpl$specter17449.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17451){
var self__ = this;
var _17451__$1 = this;
return self__.meta17450;
});

com.rpl.specter.t_com$rpl$specter17449.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17449.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17449.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter17449.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta17450","meta17450",1118014411,null)], null);
});

com.rpl.specter.t_com$rpl$specter17449.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17449.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17449";

com.rpl.specter.t_com$rpl$specter17449.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17449");
});

com.rpl.specter.__GT_t_com$rpl$specter17449 = (function com$rpl$specter$__GT_t_com$rpl$specter17449(parse_fn__$1,unparse_fn__$1,meta17450){
return (new com.rpl.specter.t_com$rpl$specter17449(parse_fn__$1,unparse_fn__$1,meta17450));
});

}

return (new com.rpl.specter.t_com$rpl$specter17449(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17452 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17452 = (function (meta17453){
this.meta17453 = meta17453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17454,meta17453__$1){
var self__ = this;
var _17454__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17452(meta17453__$1));
});

com.rpl.specter.t_com$rpl$specter17452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17454){
var self__ = this;
var _17454__$1 = this;
return self__.meta17453;
});

com.rpl.specter.t_com$rpl$specter17452.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17452.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17452.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter17452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17453","meta17453",-1489914070,null)], null);
});

com.rpl.specter.t_com$rpl$specter17452.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17452.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17452";

com.rpl.specter.t_com$rpl$specter17452.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17452");
});

com.rpl.specter.__GT_t_com$rpl$specter17452 = (function com$rpl$specter$__GT_t_com$rpl$specter17452(meta17453){
return (new com.rpl.specter.t_com$rpl$specter17452(meta17453));
});

}

return (new com.rpl.specter.t_com$rpl$specter17452(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__17460__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter17457 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17457 = (function (path,temp__4655__auto__,late,meta17458){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta17458 = meta17458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_17459,meta17458__$1){
var self__ = this;
var _17459__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17457(self__.path,self__.temp__4655__auto__,self__.late,meta17458__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17457.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_17459){
var self__ = this;
var _17459__$1 = this;
return self__.meta17458;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17457.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17457.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1,temp__4655__auto__){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__16117__auto____$1,temp__4655__auto__){
return (function (p1__17455_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__17455_SHARP_);
});})(next_fn,this__16117__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17457.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1,temp__4655__auto__){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__16117__auto____$1,temp__4655__auto__){
return (function (p1__17456_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,p1__17456_SHARP_);
});})(next_fn,this__16117__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17457.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta17458","meta17458",1894265949,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17457.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17457.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17457";

com.rpl.specter.t_com$rpl$specter17457.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17457");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter17457 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter17457(path__$1,temp__4655__auto____$1,late__$1,meta17458){
return (new com.rpl.specter.t_com$rpl$specter17457(path__$1,temp__4655__auto____$1,late__$1,meta17458));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter17457(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
}
};
var G__17460 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17461__i = 0, G__17461__a = new Array(arguments.length -  0);
while (G__17461__i < G__17461__a.length) {G__17461__a[G__17461__i] = arguments[G__17461__i + 0]; ++G__17461__i;}
  path = new cljs.core.IndexedSeq(G__17461__a,0);
} 
return G__17460__delegate.call(this,path);};
G__17460.cljs$lang$maxFixedArity = 0;
G__17460.cljs$lang$applyTo = (function (arglist__17462){
var path = cljs.core.seq(arglist__17462);
return G__17460__delegate(path);
});
G__17460.cljs$core$IFn$_invoke$arity$variadic = G__17460__delegate;
return G__17460;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,(function() { 
var G__17468__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter17465 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17465 = (function (path,temp__4655__auto__,late,meta17466){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta17466 = meta17466;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17465.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_17467,meta17466__$1){
var self__ = this;
var _17467__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17465(self__.path,self__.temp__4655__auto__,self__.late,meta17466__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17465.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_17467){
var self__ = this;
var _17467__$1 = this;
return self__.meta17466;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17465.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17465.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1,temp__4655__auto__){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_select.call(null,((function (next_fn,this__16117__auto____$1,temp__4655__auto__){
return (function (p1__17463_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__17463_SHARP_);
});})(next_fn,this__16117__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17465.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1,temp__4655__auto__){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1,temp__4655__auto__))
;
return com.rpl.specter.impl.filter_transform.call(null,((function (next_fn,this__16117__auto____$1,temp__4655__auto__){
return (function (p1__17464_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,p1__17464_SHARP_);
});})(next_fn,this__16117__auto____$1,temp__4655__auto__))
,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17465.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta17466","meta17466",-986619597,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17465.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17465.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17465";

com.rpl.specter.t_com$rpl$specter17465.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17465");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter17465 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter17465(path__$1,temp__4655__auto____$1,late__$1,meta17466){
return (new com.rpl.specter.t_com$rpl$specter17465(path__$1,temp__4655__auto____$1,late__$1,meta17466));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter17465(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
}
};
var G__17468 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17469__i = 0, G__17469__a = new Array(arguments.length -  0);
while (G__17469__i < G__17469__a.length) {G__17469__a[G__17469__i] = arguments[G__17469__i + 0]; ++G__17469__i;}
  path = new cljs.core.IndexedSeq(G__17469__a,0);
} 
return G__17468__delegate.call(this,path);};
G__17468.cljs$lang$maxFixedArity = 0;
G__17468.cljs$lang$applyTo = (function (arglist__17470){
var path = cljs.core.seq(arglist__17470);
return G__17468__delegate(path);
});
G__17468.cljs$core$IFn$_invoke$arity$variadic = G__17468__delegate;
return G__17468;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,(function() { 
var G__17471__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__17471 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17472__i = 0, G__17472__a = new Array(arguments.length -  0);
while (G__17472__i < G__17472__a.length) {G__17472__a[G__17472__i] = arguments[G__17472__i + 0]; ++G__17472__i;}
  path = new cljs.core.IndexedSeq(G__17472__a,0);
} 
return G__17471__delegate.call(this,path);};
G__17471.cljs$lang$maxFixedArity = 0;
G__17471.cljs$lang$applyTo = (function (arglist__17473){
var path = cljs.core.seq(arglist__17473);
return G__17471__delegate(path);
});
G__17471.cljs$core$IFn$_invoke$arity$variadic = G__17471__delegate;
return G__17471;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,(function (path,update_fn){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter17474 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17474 = (function (path,update_fn,late,late_fn,meta17475){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta17475 = meta17475;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17474.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17476,meta17475__$1){
var self__ = this;
var _17476__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17474(self__.path,self__.update_fn,self__.late,self__.late_fn,meta17475__$1));
});

com.rpl.specter.t_com$rpl$specter17474.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17476){
var self__ = this;
var _17476__$1 = this;
return self__.meta17475;
});

com.rpl.specter.t_com$rpl$specter17474.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17474.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter17474.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter17474.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta17475","meta17475",508228667,null)], null);
});

com.rpl.specter.t_com$rpl$specter17474.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17474.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17474";

com.rpl.specter.t_com$rpl$specter17474.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17474");
});

com.rpl.specter.__GT_t_com$rpl$specter17474 = (function com$rpl$specter$__GT_t_com$rpl$specter17474(path__$1,update_fn__$1,late__$1,late_fn__$1,meta17475){
return (new com.rpl.specter.t_com$rpl$specter17474(path__$1,update_fn__$1,late__$1,late_fn__$1,meta17475));
});

}

return (new com.rpl.specter.t_com$rpl$specter17474(path,update_fn,late,late_fn,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,(function (path,reduce_fn){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter17477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17477 = (function (path,reduce_fn,late,late_fn,meta17478){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta17478 = meta17478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17479,meta17478__$1){
var self__ = this;
var _17479__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17477(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta17478__$1));
});

com.rpl.specter.t_com$rpl$specter17477.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17479){
var self__ = this;
var _17479__$1 = this;
return self__.meta17478;
});

com.rpl.specter.t_com$rpl$specter17477.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17477.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter17477.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter17477.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta17478","meta17478",756241644,null)], null);
});

com.rpl.specter.t_com$rpl$specter17477.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17477.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17477";

com.rpl.specter.t_com$rpl$specter17477.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17477");
});

com.rpl.specter.__GT_t_com$rpl$specter17477 = (function com$rpl$specter$__GT_t_com$rpl$specter17477(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta17478){
return (new com.rpl.specter.t_com$rpl$specter17477(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta17478));
});

}

return (new com.rpl.specter.t_com$rpl$specter17477(path,reduce_fn,late,late_fn,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
}),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
(com.rpl.specter.protocols.ImplicitNav["null"] = true);

(com.rpl.specter.protocols.implicit_nav["null"] = (function (this$){
return com.rpl.specter.STAY;
}));
cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
(com.rpl.specter.protocols.ImplicitNav["function"] = true);

(com.rpl.specter.protocols.implicit_nav["function"] = (function (this$){
return com.rpl.specter.pred.call(null,this$);
}));
cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter17480 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17480 = (function (v,meta17481){
this.v = v;
this.meta17481 = meta17481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17482,meta17481__$1){
var self__ = this;
var _17482__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17480(self__.v,meta17481__$1));
});

com.rpl.specter.t_com$rpl$specter17480.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17482){
var self__ = this;
var _17482__$1 = this;
return self__.meta17481;
});

com.rpl.specter.t_com$rpl$specter17480.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17480.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter17480.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter17480.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta17481","meta17481",1948834947,null)], null);
});

com.rpl.specter.t_com$rpl$specter17480.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17480.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17480";

com.rpl.specter.t_com$rpl$specter17480.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17480");
});

com.rpl.specter.__GT_t_com$rpl$specter17480 = (function com$rpl$specter$__GT_t_com$rpl$specter17480(v__$1,meta17481){
return (new com.rpl.specter.t_com$rpl$specter17480(v__$1,meta17481));
});

}

return (new com.rpl.specter.t_com$rpl$specter17480(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17483 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17483 = (function (meta17484){
this.meta17484 = meta17484;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17483.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17485,meta17484__$1){
var self__ = this;
var _17485__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17483(meta17484__$1));
});

com.rpl.specter.t_com$rpl$specter17483.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17485){
var self__ = this;
var _17485__$1 = this;
return self__.meta17484;
});

com.rpl.specter.t_com$rpl$specter17483.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17483.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter17483.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16117__auto__,vals__16118__auto__,structure,next_fn__16119__auto__){
var self__ = this;
var this__16117__auto____$1 = this;
var next_fn = ((function (this__16117__auto____$1){
return (function (s__16120__auto__){
return next_fn__16119__auto__.call(null,vals__16118__auto__,s__16120__auto__);
});})(this__16117__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter17483.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17484","meta17484",-1104007038,null)], null);
});

com.rpl.specter.t_com$rpl$specter17483.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17483.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17483";

com.rpl.specter.t_com$rpl$specter17483.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17483");
});

com.rpl.specter.__GT_t_com$rpl$specter17483 = (function com$rpl$specter$__GT_t_com$rpl$specter17483(meta17484){
return (new com.rpl.specter.t_com$rpl$specter17483(meta17484));
});

}

return (new com.rpl.specter.t_com$rpl$specter17483(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,(function() { 
var G__17489__delegate = function (path){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter17486 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17486 = (function (path,late,meta17487){
this.path = path;
this.late = late;
this.meta17487 = meta17487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17488,meta17487__$1){
var self__ = this;
var _17488__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17486(self__.path,self__.late,meta17487__$1));
});

com.rpl.specter.t_com$rpl$specter17486.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17488){
var self__ = this;
var _17488__$1 = this;
return self__.meta17487;
});

com.rpl.specter.t_com$rpl$specter17486.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17486.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter17486.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter17486.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta17487","meta17487",274027511,null)], null);
});

com.rpl.specter.t_com$rpl$specter17486.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17486.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17486";

com.rpl.specter.t_com$rpl$specter17486.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17486");
});

com.rpl.specter.__GT_t_com$rpl$specter17486 = (function com$rpl$specter$__GT_t_com$rpl$specter17486(path__$1,late__$1,meta17487){
return (new com.rpl.specter.t_com$rpl$specter17486(path__$1,late__$1,meta17487));
});

}

return (new com.rpl.specter.t_com$rpl$specter17486(path,late,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
};
var G__17489 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17490__i = 0, G__17490__a = new Array(arguments.length -  0);
while (G__17490__i < G__17490__a.length) {G__17490__a[G__17490__i] = arguments[G__17490__i + 0]; ++G__17490__i;}
  path = new cljs.core.IndexedSeq(G__17490__a,0);
} 
return G__17489__delegate.call(this,path);};
G__17489.cljs$lang$maxFixedArity = 0;
G__17489.cljs$lang$applyTo = (function (arglist__17491){
var path = cljs.core.seq(arglist__17491);
return G__17489__delegate(path);
});
G__17489.cljs$core$IFn$_invoke$arity$variadic = G__17489__delegate;
return G__17489;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,(function() { 
var G__17495__delegate = function (path){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter17492 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17492 = (function (path,late,meta17493){
this.path = path;
this.late = late;
this.meta17493 = meta17493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17494,meta17493__$1){
var self__ = this;
var _17494__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17492(self__.path,self__.late,meta17493__$1));
});

com.rpl.specter.t_com$rpl$specter17492.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17494){
var self__ = this;
var _17494__$1 = this;
return self__.meta17493;
});

com.rpl.specter.t_com$rpl$specter17492.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17492.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter17492.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter17492.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta17493","meta17493",167891240,null)], null);
});

com.rpl.specter.t_com$rpl$specter17492.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17492.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17492";

com.rpl.specter.t_com$rpl$specter17492.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17492");
});

com.rpl.specter.__GT_t_com$rpl$specter17492 = (function com$rpl$specter$__GT_t_com$rpl$specter17492(path__$1,late__$1,meta17493){
return (new com.rpl.specter.t_com$rpl$specter17492(path__$1,late__$1,meta17493));
});

}

return (new com.rpl.specter.t_com$rpl$specter17492(path,late,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
};
var G__17495 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17496__i = 0, G__17496__a = new Array(arguments.length -  0);
while (G__17496__i < G__17496__a.length) {G__17496__a[G__17496__i] = arguments[G__17496__i + 0]; ++G__17496__i;}
  path = new cljs.core.IndexedSeq(G__17496__a,0);
} 
return G__17495__delegate.call(this,path);};
G__17495.cljs$lang$maxFixedArity = 0;
G__17495.cljs$lang$applyTo = (function (arglist__17497){
var path = cljs.core.seq(arglist__17497);
return G__17495__delegate(path);
});
G__17495.cljs$core$IFn$_invoke$arity$variadic = G__17495__delegate;
return G__17495;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter17498 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17498 = (function (val,meta17499){
this.val = val;
this.meta17499 = meta17499;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17498.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17500,meta17499__$1){
var self__ = this;
var _17500__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17498(self__.val,meta17499__$1));
});

com.rpl.specter.t_com$rpl$specter17498.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17500){
var self__ = this;
var _17500__$1 = this;
return self__.meta17499;
});

com.rpl.specter.t_com$rpl$specter17498.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17498.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter17498.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__16752__auto__,vals__16753__auto__,structure,next_fn__16754__auto__){
var self__ = this;
var this__16752__auto____$1 = this;
return next_fn__16754__auto__.call(null,cljs.core.conj.call(null,vals__16753__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter17498.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta17499","meta17499",1095255994,null)], null);
});

com.rpl.specter.t_com$rpl$specter17498.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17498.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17498";

com.rpl.specter.t_com$rpl$specter17498.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17498");
});

com.rpl.specter.__GT_t_com$rpl$specter17498 = (function com$rpl$specter$__GT_t_com$rpl$specter17498(val__$1,meta17499){
return (new com.rpl.specter.t_com$rpl$specter17498(val__$1,meta17499));
});

}

return (new com.rpl.specter.t_com$rpl$specter17498(val,null));
}));
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter17501 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17501 = (function (meta17502){
this.meta17502 = meta17502;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17501.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17503,meta17502__$1){
var self__ = this;
var _17503__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17501(meta17502__$1));
});

com.rpl.specter.t_com$rpl$specter17501.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17503){
var self__ = this;
var _17503__$1 = this;
return self__.meta17502;
});

com.rpl.specter.t_com$rpl$specter17501.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17501.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter17501.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter17501.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta17502","meta17502",-524090627,null)], null);
});

com.rpl.specter.t_com$rpl$specter17501.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17501.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17501";

com.rpl.specter.t_com$rpl$specter17501.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17501");
});

com.rpl.specter.__GT_t_com$rpl$specter17501 = (function com$rpl$specter$__GT_t_com$rpl$specter17501(meta17502){
return (new com.rpl.specter.t_com$rpl$specter17501(meta17502));
});

}

return (new com.rpl.specter.t_com$rpl$specter17501(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,(function() {
var G__17512 = null;
var G__17512__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__17512__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter17506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17506 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta17507){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta17507 = meta17507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_17508,meta17507__$1){
var self__ = this;
var _17508__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17506(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta17507__$1));
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17506.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_17508){
var self__ = this;
var _17508__$1 = this;
return self__.meta17507;
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17506.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17506.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17506.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17506.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta17507","meta17507",1694017443,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17506.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17506.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17506";

com.rpl.specter.t_com$rpl$specter17506.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17506");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter17506 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter17506(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta17507){
return (new com.rpl.specter.t_com$rpl$specter17506(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta17507));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter17506(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
} else {
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter17509 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17509 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta17510){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta17510 = meta17510;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17509.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_17511,meta17510__$1){
var self__ = this;
var _17511__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17509(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta17510__$1));
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17509.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_17511){
var self__ = this;
var _17511__$1 = this;
return self__.meta17510;
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17509.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17509.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__17504_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__17504_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17509.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__17505_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,p1__17505_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17509.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta17510","meta17510",21619082,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter17509.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17509.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17509";

com.rpl.specter.t_com$rpl$specter17509.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17509");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter17509 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter17509(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta17510){
return (new com.rpl.specter.t_com$rpl$specter17509(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta17510));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter17509(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
}
});
G__17512 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__17512__2.call(this,cond_p,then_path);
case 3:
return G__17512__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__17512.cljs$core$IFn$_invoke$arity$2 = G__17512__2;
G__17512.cljs$core$IFn$_invoke$arity$3 = G__17512__3;
return G__17512;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,(function() { 
var G__17517__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__17513){
var vec__17514 = p__17513;
var tester = cljs.core.nth.call(null,vec__17514,(0),null);
var apath = cljs.core.nth.call(null,vec__17514,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__17517 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__17518__i = 0, G__17518__a = new Array(arguments.length -  0);
while (G__17518__i < G__17518__a.length) {G__17518__a[G__17518__i] = arguments[G__17518__i + 0]; ++G__17518__i;}
  conds = new cljs.core.IndexedSeq(G__17518__a,0);
} 
return G__17517__delegate.call(this,conds);};
G__17517.cljs$lang$maxFixedArity = 0;
G__17517.cljs$lang$applyTo = (function (arglist__17519){
var conds = cljs.core.seq(arglist__17519);
return G__17517__delegate(conds);
});
G__17517.cljs$core$IFn$_invoke$arity$variadic = G__17517__delegate;
return G__17517;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,(function() {
var G__17527 = null;
var G__17527__0 = (function (){
return com.rpl.specter.STAY;
});
var G__17527__1 = (function (path){
return path;
});
var G__17527__2 = (function (path1,path2){
var builder__16755__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter17520 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter17520 = (function (path1,path2,late1,late2,meta17521){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta17521 = meta17521;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter17520.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17522,meta17521__$1){
var self__ = this;
var _17522__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter17520(self__.path1,self__.path2,self__.late1,self__.late2,meta17521__$1));
});

com.rpl.specter.t_com$rpl$specter17520.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17522){
var self__ = this;
var _17522__$1 = this;
return self__.meta17521;
});

com.rpl.specter.t_com$rpl$specter17520.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter17520.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res2)){
return res1;
} else {
return res2;
}
});

com.rpl.specter.t_com$rpl$specter17520.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter17520.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta17521","meta17521",1547748683,null)], null);
});

com.rpl.specter.t_com$rpl$specter17520.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter17520.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter17520";

com.rpl.specter.t_com$rpl$specter17520.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"com.rpl.specter/t_com$rpl$specter17520");
});

com.rpl.specter.__GT_t_com$rpl$specter17520 = (function com$rpl$specter$__GT_t_com$rpl$specter17520(path1__$1,path2__$1,late1__$1,late2__$1,meta17521){
return (new com.rpl.specter.t_com$rpl$specter17520(path1__$1,path2__$1,late1__$1,late2__$1,meta17521));
});

}

return (new com.rpl.specter.t_com$rpl$specter17520(path1,path2,late1,late2,null));
}));
var curr_params__16756__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__16756__auto__)){
return cljs.core.apply.call(null,builder__16755__auto__,curr_params__16756__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__16755__auto__,curr_params__16756__auto__);
}
});
var G__17527__3 = (function() { 
var G__17528__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__17528 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__17529__i = 0, G__17529__a = new Array(arguments.length -  2);
while (G__17529__i < G__17529__a.length) {G__17529__a[G__17529__i] = arguments[G__17529__i + 2]; ++G__17529__i;}
  paths = new cljs.core.IndexedSeq(G__17529__a,0);
} 
return G__17528__delegate.call(this,path1,path2,paths);};
G__17528.cljs$lang$maxFixedArity = 2;
G__17528.cljs$lang$applyTo = (function (arglist__17530){
var path1 = cljs.core.first(arglist__17530);
arglist__17530 = cljs.core.next(arglist__17530);
var path2 = cljs.core.first(arglist__17530);
var paths = cljs.core.rest(arglist__17530);
return G__17528__delegate(path1,path2,paths);
});
G__17528.cljs$core$IFn$_invoke$arity$variadic = G__17528__delegate;
return G__17528;
})()
;
G__17527 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__17527__0.call(this);
case 1:
return G__17527__1.call(this,path1);
case 2:
return G__17527__2.call(this,path1,path2);
default:
var G__17531 = null;
if (arguments.length > 2) {
var G__17532__i = 0, G__17532__a = new Array(arguments.length -  2);
while (G__17532__i < G__17532__a.length) {G__17532__a[G__17532__i] = arguments[G__17532__i + 2]; ++G__17532__i;}
G__17531 = new cljs.core.IndexedSeq(G__17532__a,0);
}
return G__17527__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__17531);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__17527.cljs$lang$maxFixedArity = 2;
G__17527.cljs$lang$applyTo = G__17527__3.cljs$lang$applyTo;
G__17527.cljs$core$IFn$_invoke$arity$0 = G__17527__0;
G__17527.cljs$core$IFn$_invoke$arity$1 = G__17527__1;
G__17527.cljs$core$IFn$_invoke$arity$2 = G__17527__2;
G__17527.cljs$core$IFn$_invoke$arity$variadic = G__17527__3.cljs$core$IFn$_invoke$arity$variadic;
return G__17527;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,(function() { 
var G__17533__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__17533 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17534__i = 0, G__17534__a = new Array(arguments.length -  0);
while (G__17534__i < G__17534__a.length) {G__17534__a[G__17534__i] = arguments[G__17534__i + 0]; ++G__17534__i;}
  path = new cljs.core.IndexedSeq(G__17534__a,0);
} 
return G__17533__delegate.call(this,path);};
G__17533.cljs$lang$maxFixedArity = 0;
G__17533.cljs$lang$applyTo = (function (arglist__17535){
var path = cljs.core.seq(arglist__17535);
return G__17533__delegate(path);
});
G__17533.cljs$core$IFn$_invoke$arity$variadic = G__17533__delegate;
return G__17533;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,(function() { 
var G__17536__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__17536 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__17537__i = 0, G__17537__a = new Array(arguments.length -  0);
while (G__17537__i < G__17537__a.length) {G__17537__a[G__17537__i] = arguments[G__17537__i + 0]; ++G__17537__i;}
  path = new cljs.core.IndexedSeq(G__17537__a,0);
} 
return G__17536__delegate.call(this,path);};
G__17536.cljs$lang$maxFixedArity = 0;
G__17536.cljs$lang$applyTo = (function (arglist__17538){
var path = cljs.core.seq(arglist__17538);
return G__17536__delegate(path);
});
G__17536.cljs$core$IFn$_invoke$arity$variadic = G__17536__delegate;
return G__17536;
})()
,cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
