// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__6880__auto__ = v;
if(cljs.core.truth_(and__6880__auto__)){
return (v > (0));
} else {
return and__6880__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__22999_SHARP_,p2__22998_SHARP_){
var vec__23003 = clojure.string.split.call(null,p2__22998_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__23003,(0),null);
var v = cljs.core.nth.call(null,vec__23003,(1),null);
return cljs.core.assoc.call(null,p1__22999_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__23006_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__23006_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__23007){
var vec__23011 = p__23007;
var k = cljs.core.nth.call(null,vec__23011,(0),null);
var v = cljs.core.nth.call(null,vec__23011,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__23014_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__23014_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__6880__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__6880__auto__){
var and__6880__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__6880__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__6880__auto____$1;
}
} else {
return and__6880__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__23015_SHARP_){
return cljs_http.client.decode_body.call(null,p1__23015_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23022 = arguments.length;
var i__8006__auto___23023 = (0);
while(true){
if((i__8006__auto___23023 < len__8005__auto___23022)){
args__8012__auto__.push((arguments[i__8006__auto___23023]));

var G__23024 = (i__8006__auto___23023 + (1));
i__8006__auto___23023 = G__23024;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__23018){
var vec__23019 = p__23018;
var default_headers = cljs.core.nth.call(null,vec__23019,(0),null);
return ((function (vec__23019,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__6892__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__23019,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq23016){
var G__23017 = cljs.core.first.call(null,seq23016);
var seq23016__$1 = cljs.core.next.call(null,seq23016);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__23017,seq23016__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23031 = arguments.length;
var i__8006__auto___23032 = (0);
while(true){
if((i__8006__auto___23032 < len__8005__auto___23031)){
args__8012__auto__.push((arguments[i__8006__auto___23032]));

var G__23033 = (i__8006__auto___23032 + (1));
i__8006__auto___23032 = G__23033;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__23027){
var vec__23028 = p__23027;
var accept = cljs.core.nth.call(null,vec__23028,(0),null);
return ((function (vec__23028,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__6892__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__23028,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq23025){
var G__23026 = cljs.core.first.call(null,seq23025);
var seq23025__$1 = cljs.core.next.call(null,seq23025);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__23026,seq23025__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23040 = arguments.length;
var i__8006__auto___23041 = (0);
while(true){
if((i__8006__auto___23041 < len__8005__auto___23040)){
args__8012__auto__.push((arguments[i__8006__auto___23041]));

var G__23042 = (i__8006__auto___23041 + (1));
i__8006__auto___23041 = G__23042;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__23036){
var vec__23037 = p__23036;
var content_type = cljs.core.nth.call(null,vec__23037,(0),null);
return ((function (vec__23037,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__6892__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__23037,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq23034){
var G__23035 = cljs.core.first.call(null,seq23034);
var seq23034__$1 = cljs.core.next.call(null,seq23034);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__23035,seq23034__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__23045 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__23045__$1 = ((((!((map__23045 == null)))?((((map__23045.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23045.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23045):map__23045);
var encoding = cljs.core.get.call(null,map__23045__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__23045__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__23051 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__23051__$1 = ((((!((map__23051 == null)))?((((map__23051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23051.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23051):map__23051);
var decoding = cljs.core.get.call(null,map__23051__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__23051__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__23051,map__23051__$1,decoding,decoding_opts){
return (function (p1__23047_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__23047_SHARP_,decoding,decoding_opts);
});})(map__23051,map__23051__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__23051,map__23051__$1,decoding,decoding_opts,transit_decode){
return (function (p1__23048_SHARP_){
return cljs_http.client.decode_body.call(null,p1__23048_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__23051,map__23051__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__23053_SHARP_){
return cljs_http.client.decode_body.call(null,p1__23053_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__23057){
var map__23058 = p__23057;
var map__23058__$1 = ((((!((map__23058 == null)))?((((map__23058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23058.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23058):map__23058);
var req = map__23058__$1;
var query_params = cljs.core.get.call(null,map__23058__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__23063){
var map__23064 = p__23063;
var map__23064__$1 = ((((!((map__23064 == null)))?((((map__23064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23064.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23064):map__23064);
var request = map__23064__$1;
var form_params = cljs.core.get.call(null,map__23064__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__23064__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__23064__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__6880__auto__ = form_params;
if(cljs.core.truth_(and__6880__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6880__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__23076_23086 = cljs.core.seq.call(null,params);
var chunk__23077_23087 = null;
var count__23078_23088 = (0);
var i__23079_23089 = (0);
while(true){
if((i__23079_23089 < count__23078_23088)){
var vec__23080_23090 = cljs.core._nth.call(null,chunk__23077_23087,i__23079_23089);
var k_23091 = cljs.core.nth.call(null,vec__23080_23090,(0),null);
var v_23092 = cljs.core.nth.call(null,vec__23080_23090,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_23092)){
form_data.append(cljs.core.name.call(null,k_23091),cljs.core.first.call(null,v_23092),cljs.core.second.call(null,v_23092));
} else {
form_data.append(cljs.core.name.call(null,k_23091),v_23092);
}

var G__23093 = seq__23076_23086;
var G__23094 = chunk__23077_23087;
var G__23095 = count__23078_23088;
var G__23096 = (i__23079_23089 + (1));
seq__23076_23086 = G__23093;
chunk__23077_23087 = G__23094;
count__23078_23088 = G__23095;
i__23079_23089 = G__23096;
continue;
} else {
var temp__4657__auto___23097 = cljs.core.seq.call(null,seq__23076_23086);
if(temp__4657__auto___23097){
var seq__23076_23098__$1 = temp__4657__auto___23097;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23076_23098__$1)){
var c__7711__auto___23099 = cljs.core.chunk_first.call(null,seq__23076_23098__$1);
var G__23100 = cljs.core.chunk_rest.call(null,seq__23076_23098__$1);
var G__23101 = c__7711__auto___23099;
var G__23102 = cljs.core.count.call(null,c__7711__auto___23099);
var G__23103 = (0);
seq__23076_23086 = G__23100;
chunk__23077_23087 = G__23101;
count__23078_23088 = G__23102;
i__23079_23089 = G__23103;
continue;
} else {
var vec__23083_23104 = cljs.core.first.call(null,seq__23076_23098__$1);
var k_23105 = cljs.core.nth.call(null,vec__23083_23104,(0),null);
var v_23106 = cljs.core.nth.call(null,vec__23083_23104,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_23106)){
form_data.append(cljs.core.name.call(null,k_23105),cljs.core.first.call(null,v_23106),cljs.core.second.call(null,v_23106));
} else {
form_data.append(cljs.core.name.call(null,k_23105),v_23106);
}

var G__23107 = cljs.core.next.call(null,seq__23076_23098__$1);
var G__23108 = null;
var G__23109 = (0);
var G__23110 = (0);
seq__23076_23086 = G__23107;
chunk__23077_23087 = G__23108;
count__23078_23088 = G__23109;
i__23079_23089 = G__23110;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__23114){
var map__23115 = p__23114;
var map__23115__$1 = ((((!((map__23115 == null)))?((((map__23115.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23115.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23115):map__23115);
var request = map__23115__$1;
var multipart_params = cljs.core.get.call(null,map__23115__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__23115__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__6880__auto__ = multipart_params;
if(cljs.core.truth_(and__6880__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6880__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__23117_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__23117_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__23122){
var map__23123 = p__23122;
var map__23123__$1 = ((((!((map__23123 == null)))?((((map__23123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23123.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23123):map__23123);
var req = map__23123__$1;
var query_params = cljs.core.get.call(null,map__23123__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__23123,map__23123__$1,req,query_params){
return (function (p1__23118_SHARP_){
return cljs.core.merge.call(null,p1__23118_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__23123,map__23123__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23131 = arguments.length;
var i__8006__auto___23132 = (0);
while(true){
if((i__8006__auto___23132 < len__8005__auto___23131)){
args__8012__auto__.push((arguments[i__8006__auto___23132]));

var G__23133 = (i__8006__auto___23132 + (1));
i__8006__auto___23132 = G__23133;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__23127){
var vec__23128 = p__23127;
var credentials = cljs.core.nth.call(null,vec__23128,(0),null);
return ((function (vec__23128,credentials){
return (function (req){
var credentials__$1 = (function (){var or__6892__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__23128,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq23125){
var G__23126 = cljs.core.first.call(null,seq23125);
var seq23125__$1 = cljs.core.next.call(null,seq23125);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__23126,seq23125__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23140 = arguments.length;
var i__8006__auto___23141 = (0);
while(true){
if((i__8006__auto___23141 < len__8005__auto___23140)){
args__8012__auto__.push((arguments[i__8006__auto___23141]));

var G__23142 = (i__8006__auto___23141 + (1));
i__8006__auto___23141 = G__23142;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23136){
var vec__23137 = p__23136;
var req = cljs.core.nth.call(null,vec__23137,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq23134){
var G__23135 = cljs.core.first.call(null,seq23134);
var seq23134__$1 = cljs.core.next.call(null,seq23134);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__23135,seq23134__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23149 = arguments.length;
var i__8006__auto___23150 = (0);
while(true){
if((i__8006__auto___23150 < len__8005__auto___23149)){
args__8012__auto__.push((arguments[i__8006__auto___23150]));

var G__23151 = (i__8006__auto___23150 + (1));
i__8006__auto___23150 = G__23151;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23145){
var vec__23146 = p__23145;
var req = cljs.core.nth.call(null,vec__23146,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq23143){
var G__23144 = cljs.core.first.call(null,seq23143);
var seq23143__$1 = cljs.core.next.call(null,seq23143);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__23144,seq23143__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23158 = arguments.length;
var i__8006__auto___23159 = (0);
while(true){
if((i__8006__auto___23159 < len__8005__auto___23158)){
args__8012__auto__.push((arguments[i__8006__auto___23159]));

var G__23160 = (i__8006__auto___23159 + (1));
i__8006__auto___23159 = G__23160;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23154){
var vec__23155 = p__23154;
var req = cljs.core.nth.call(null,vec__23155,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq23152){
var G__23153 = cljs.core.first.call(null,seq23152);
var seq23152__$1 = cljs.core.next.call(null,seq23152);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__23153,seq23152__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23167 = arguments.length;
var i__8006__auto___23168 = (0);
while(true){
if((i__8006__auto___23168 < len__8005__auto___23167)){
args__8012__auto__.push((arguments[i__8006__auto___23168]));

var G__23169 = (i__8006__auto___23168 + (1));
i__8006__auto___23168 = G__23169;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23163){
var vec__23164 = p__23163;
var req = cljs.core.nth.call(null,vec__23164,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq23161){
var G__23162 = cljs.core.first.call(null,seq23161);
var seq23161__$1 = cljs.core.next.call(null,seq23161);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__23162,seq23161__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23176 = arguments.length;
var i__8006__auto___23177 = (0);
while(true){
if((i__8006__auto___23177 < len__8005__auto___23176)){
args__8012__auto__.push((arguments[i__8006__auto___23177]));

var G__23178 = (i__8006__auto___23177 + (1));
i__8006__auto___23177 = G__23178;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23172){
var vec__23173 = p__23172;
var req = cljs.core.nth.call(null,vec__23173,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq23170){
var G__23171 = cljs.core.first.call(null,seq23170);
var seq23170__$1 = cljs.core.next.call(null,seq23170);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__23171,seq23170__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23185 = arguments.length;
var i__8006__auto___23186 = (0);
while(true){
if((i__8006__auto___23186 < len__8005__auto___23185)){
args__8012__auto__.push((arguments[i__8006__auto___23186]));

var G__23187 = (i__8006__auto___23186 + (1));
i__8006__auto___23186 = G__23187;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23181){
var vec__23182 = p__23181;
var req = cljs.core.nth.call(null,vec__23182,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq23179){
var G__23180 = cljs.core.first.call(null,seq23179);
var seq23179__$1 = cljs.core.next.call(null,seq23179);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__23180,seq23179__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23194 = arguments.length;
var i__8006__auto___23195 = (0);
while(true){
if((i__8006__auto___23195 < len__8005__auto___23194)){
args__8012__auto__.push((arguments[i__8006__auto___23195]));

var G__23196 = (i__8006__auto___23195 + (1));
i__8006__auto___23195 = G__23196;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23190){
var vec__23191 = p__23190;
var req = cljs.core.nth.call(null,vec__23191,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq23188){
var G__23189 = cljs.core.first.call(null,seq23188);
var seq23188__$1 = cljs.core.next.call(null,seq23188);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__23189,seq23188__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23203 = arguments.length;
var i__8006__auto___23204 = (0);
while(true){
if((i__8006__auto___23204 < len__8005__auto___23203)){
args__8012__auto__.push((arguments[i__8006__auto___23204]));

var G__23205 = (i__8006__auto___23204 + (1));
i__8006__auto___23204 = G__23205;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23199){
var vec__23200 = p__23199;
var req = cljs.core.nth.call(null,vec__23200,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq23197){
var G__23198 = cljs.core.first.call(null,seq23197);
var seq23197__$1 = cljs.core.next.call(null,seq23197);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__23198,seq23197__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__8012__auto__ = [];
var len__8005__auto___23212 = arguments.length;
var i__8006__auto___23213 = (0);
while(true){
if((i__8006__auto___23213 < len__8005__auto___23212)){
args__8012__auto__.push((arguments[i__8006__auto___23213]));

var G__23214 = (i__8006__auto___23213 + (1));
i__8006__auto___23213 = G__23214;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__23208){
var vec__23209 = p__23208;
var req = cljs.core.nth.call(null,vec__23209,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq23206){
var G__23207 = cljs.core.first.call(null,seq23206);
var seq23206__$1 = cljs.core.next.call(null,seq23206);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__23207,seq23206__$1);
});

