// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args19753 = [];
var len__8005__auto___19759 = arguments.length;
var i__8006__auto___19760 = (0);
while(true){
if((i__8006__auto___19760 < len__8005__auto___19759)){
args19753.push((arguments[i__8006__auto___19760]));

var G__19761 = (i__8006__auto___19760 + (1));
i__8006__auto___19760 = G__19761;
continue;
} else {
}
break;
}

var G__19755 = args19753.length;
switch (G__19755) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19753.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async19756 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19756 = (function (f,blockable,meta19757){
this.f = f;
this.blockable = blockable;
this.meta19757 = meta19757;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19758,meta19757__$1){
var self__ = this;
var _19758__$1 = this;
return (new cljs.core.async.t_cljs$core$async19756(self__.f,self__.blockable,meta19757__$1));
});

cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19758){
var self__ = this;
var _19758__$1 = this;
return self__.meta19757;
});

cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async19756.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async19756.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19757","meta19757",-1222288500,null)], null);
});

cljs.core.async.t_cljs$core$async19756.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19756.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19756";

cljs.core.async.t_cljs$core$async19756.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async19756");
});

cljs.core.async.__GT_t_cljs$core$async19756 = (function cljs$core$async$__GT_t_cljs$core$async19756(f__$1,blockable__$1,meta19757){
return (new cljs.core.async.t_cljs$core$async19756(f__$1,blockable__$1,meta19757));
});

}

return (new cljs.core.async.t_cljs$core$async19756(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19765 = [];
var len__8005__auto___19768 = arguments.length;
var i__8006__auto___19769 = (0);
while(true){
if((i__8006__auto___19769 < len__8005__auto___19768)){
args19765.push((arguments[i__8006__auto___19769]));

var G__19770 = (i__8006__auto___19769 + (1));
i__8006__auto___19769 = G__19770;
continue;
} else {
}
break;
}

var G__19767 = args19765.length;
switch (G__19767) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19765.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19772 = [];
var len__8005__auto___19775 = arguments.length;
var i__8006__auto___19776 = (0);
while(true){
if((i__8006__auto___19776 < len__8005__auto___19775)){
args19772.push((arguments[i__8006__auto___19776]));

var G__19777 = (i__8006__auto___19776 + (1));
i__8006__auto___19776 = G__19777;
continue;
} else {
}
break;
}

var G__19774 = args19772.length;
switch (G__19774) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19772.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19779 = [];
var len__8005__auto___19782 = arguments.length;
var i__8006__auto___19783 = (0);
while(true){
if((i__8006__auto___19783 < len__8005__auto___19782)){
args19779.push((arguments[i__8006__auto___19783]));

var G__19784 = (i__8006__auto___19783 + (1));
i__8006__auto___19783 = G__19784;
continue;
} else {
}
break;
}

var G__19781 = args19779.length;
switch (G__19781) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19779.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19786 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19786);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19786,ret){
return (function (){
return fn1.call(null,val_19786);
});})(val_19786,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19787 = [];
var len__8005__auto___19790 = arguments.length;
var i__8006__auto___19791 = (0);
while(true){
if((i__8006__auto___19791 < len__8005__auto___19790)){
args19787.push((arguments[i__8006__auto___19791]));

var G__19792 = (i__8006__auto___19791 + (1));
i__8006__auto___19791 = G__19792;
continue;
} else {
}
break;
}

var G__19789 = args19787.length;
switch (G__19789) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19787.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7815__auto___19794 = n;
var x_19795 = (0);
while(true){
if((x_19795 < n__7815__auto___19794)){
(a[x_19795] = (0));

var G__19796 = (x_19795 + (1));
x_19795 = G__19796;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19797 = (i + (1));
i = G__19797;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19801 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19801 = (function (flag,meta19802){
this.flag = flag;
this.meta19802 = meta19802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19803,meta19802__$1){
var self__ = this;
var _19803__$1 = this;
return (new cljs.core.async.t_cljs$core$async19801(self__.flag,meta19802__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19803){
var self__ = this;
var _19803__$1 = this;
return self__.meta19802;
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19802","meta19802",319522597,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19801.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19801.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19801";

cljs.core.async.t_cljs$core$async19801.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async19801");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19801 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19801(flag__$1,meta19802){
return (new cljs.core.async.t_cljs$core$async19801(flag__$1,meta19802));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19801(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19807 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19807 = (function (flag,cb,meta19808){
this.flag = flag;
this.cb = cb;
this.meta19808 = meta19808;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19809,meta19808__$1){
var self__ = this;
var _19809__$1 = this;
return (new cljs.core.async.t_cljs$core$async19807(self__.flag,self__.cb,meta19808__$1));
});

cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19809){
var self__ = this;
var _19809__$1 = this;
return self__.meta19808;
});

cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19807.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19807.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19808","meta19808",-1743421826,null)], null);
});

cljs.core.async.t_cljs$core$async19807.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19807.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19807";

cljs.core.async.t_cljs$core$async19807.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async19807");
});

cljs.core.async.__GT_t_cljs$core$async19807 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19807(flag__$1,cb__$1,meta19808){
return (new cljs.core.async.t_cljs$core$async19807(flag__$1,cb__$1,meta19808));
});

}

return (new cljs.core.async.t_cljs$core$async19807(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19810_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19810_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19811_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19811_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6892__auto__ = wport;
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19812 = (i + (1));
i = G__19812;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6892__auto__ = ret;
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6880__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6880__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6880__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8012__auto__ = [];
var len__8005__auto___19818 = arguments.length;
var i__8006__auto___19819 = (0);
while(true){
if((i__8006__auto___19819 < len__8005__auto___19818)){
args__8012__auto__.push((arguments[i__8006__auto___19819]));

var G__19820 = (i__8006__auto___19819 + (1));
i__8006__auto___19819 = G__19820;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((1) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8013__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19815){
var map__19816 = p__19815;
var map__19816__$1 = ((((!((map__19816 == null)))?((((map__19816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19816.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19816):map__19816);
var opts = map__19816__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19813){
var G__19814 = cljs.core.first.call(null,seq19813);
var seq19813__$1 = cljs.core.next.call(null,seq19813);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19814,seq19813__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19821 = [];
var len__8005__auto___19871 = arguments.length;
var i__8006__auto___19872 = (0);
while(true){
if((i__8006__auto___19872 < len__8005__auto___19871)){
args19821.push((arguments[i__8006__auto___19872]));

var G__19873 = (i__8006__auto___19872 + (1));
i__8006__auto___19872 = G__19873;
continue;
} else {
}
break;
}

var G__19823 = args19821.length;
switch (G__19823) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args19821.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19708__auto___19875 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___19875){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___19875){
return (function (state_19847){
var state_val_19848 = (state_19847[(1)]);
if((state_val_19848 === (7))){
var inst_19843 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
var statearr_19849_19876 = state_19847__$1;
(statearr_19849_19876[(2)] = inst_19843);

(statearr_19849_19876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (1))){
var state_19847__$1 = state_19847;
var statearr_19850_19877 = state_19847__$1;
(statearr_19850_19877[(2)] = null);

(statearr_19850_19877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (4))){
var inst_19826 = (state_19847[(7)]);
var inst_19826__$1 = (state_19847[(2)]);
var inst_19827 = (inst_19826__$1 == null);
var state_19847__$1 = (function (){var statearr_19851 = state_19847;
(statearr_19851[(7)] = inst_19826__$1);

return statearr_19851;
})();
if(cljs.core.truth_(inst_19827)){
var statearr_19852_19878 = state_19847__$1;
(statearr_19852_19878[(1)] = (5));

} else {
var statearr_19853_19879 = state_19847__$1;
(statearr_19853_19879[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (13))){
var state_19847__$1 = state_19847;
var statearr_19854_19880 = state_19847__$1;
(statearr_19854_19880[(2)] = null);

(statearr_19854_19880[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (6))){
var inst_19826 = (state_19847[(7)]);
var state_19847__$1 = state_19847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19847__$1,(11),to,inst_19826);
} else {
if((state_val_19848 === (3))){
var inst_19845 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19847__$1,inst_19845);
} else {
if((state_val_19848 === (12))){
var state_19847__$1 = state_19847;
var statearr_19855_19881 = state_19847__$1;
(statearr_19855_19881[(2)] = null);

(statearr_19855_19881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (2))){
var state_19847__$1 = state_19847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19847__$1,(4),from);
} else {
if((state_val_19848 === (11))){
var inst_19836 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
if(cljs.core.truth_(inst_19836)){
var statearr_19856_19882 = state_19847__$1;
(statearr_19856_19882[(1)] = (12));

} else {
var statearr_19857_19883 = state_19847__$1;
(statearr_19857_19883[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (9))){
var state_19847__$1 = state_19847;
var statearr_19858_19884 = state_19847__$1;
(statearr_19858_19884[(2)] = null);

(statearr_19858_19884[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (5))){
var state_19847__$1 = state_19847;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19859_19885 = state_19847__$1;
(statearr_19859_19885[(1)] = (8));

} else {
var statearr_19860_19886 = state_19847__$1;
(statearr_19860_19886[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (14))){
var inst_19841 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
var statearr_19861_19887 = state_19847__$1;
(statearr_19861_19887[(2)] = inst_19841);

(statearr_19861_19887[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (10))){
var inst_19833 = (state_19847[(2)]);
var state_19847__$1 = state_19847;
var statearr_19862_19888 = state_19847__$1;
(statearr_19862_19888[(2)] = inst_19833);

(statearr_19862_19888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19848 === (8))){
var inst_19830 = cljs.core.async.close_BANG_.call(null,to);
var state_19847__$1 = state_19847;
var statearr_19863_19889 = state_19847__$1;
(statearr_19863_19889[(2)] = inst_19830);

(statearr_19863_19889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___19875))
;
return ((function (switch__19596__auto__,c__19708__auto___19875){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_19867 = [null,null,null,null,null,null,null,null];
(statearr_19867[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_19867[(1)] = (1));

return statearr_19867;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_19847){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_19847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e19868){if((e19868 instanceof Object)){
var ex__19600__auto__ = e19868;
var statearr_19869_19890 = state_19847;
(statearr_19869_19890[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19868;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19891 = state_19847;
state_19847 = G__19891;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_19847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_19847);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___19875))
})();
var state__19710__auto__ = (function (){var statearr_19870 = f__19709__auto__.call(null);
(statearr_19870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___19875);

return statearr_19870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___19875))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20079){
var vec__20080 = p__20079;
var v = cljs.core.nth.call(null,vec__20080,(0),null);
var p = cljs.core.nth.call(null,vec__20080,(1),null);
var job = vec__20080;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__19708__auto___20266 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results){
return (function (state_20087){
var state_val_20088 = (state_20087[(1)]);
if((state_val_20088 === (1))){
var state_20087__$1 = state_20087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20087__$1,(2),res,v);
} else {
if((state_val_20088 === (2))){
var inst_20084 = (state_20087[(2)]);
var inst_20085 = cljs.core.async.close_BANG_.call(null,res);
var state_20087__$1 = (function (){var statearr_20089 = state_20087;
(statearr_20089[(7)] = inst_20084);

return statearr_20089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20087__$1,inst_20085);
} else {
return null;
}
}
});})(c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results))
;
return ((function (switch__19596__auto__,c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_20093 = [null,null,null,null,null,null,null,null];
(statearr_20093[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__);

(statearr_20093[(1)] = (1));

return statearr_20093;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1 = (function (state_20087){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20094){if((e20094 instanceof Object)){
var ex__19600__auto__ = e20094;
var statearr_20095_20267 = state_20087;
(statearr_20095_20267[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20268 = state_20087;
state_20087 = G__20268;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = function(state_20087){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1.call(this,state_20087);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results))
})();
var state__19710__auto__ = (function (){var statearr_20096 = f__19709__auto__.call(null);
(statearr_20096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___20266);

return statearr_20096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___20266,res,vec__20080,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20097){
var vec__20098 = p__20097;
var v = cljs.core.nth.call(null,vec__20098,(0),null);
var p = cljs.core.nth.call(null,vec__20098,(1),null);
var job = vec__20098;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7815__auto___20269 = n;
var __20270 = (0);
while(true){
if((__20270 < n__7815__auto___20269)){
var G__20101_20271 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20101_20271) {
case "compute":
var c__19708__auto___20273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20270,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (__20270,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function (state_20114){
var state_val_20115 = (state_20114[(1)]);
if((state_val_20115 === (1))){
var state_20114__$1 = state_20114;
var statearr_20116_20274 = state_20114__$1;
(statearr_20116_20274[(2)] = null);

(statearr_20116_20274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20115 === (2))){
var state_20114__$1 = state_20114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20114__$1,(4),jobs);
} else {
if((state_val_20115 === (3))){
var inst_20112 = (state_20114[(2)]);
var state_20114__$1 = state_20114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20114__$1,inst_20112);
} else {
if((state_val_20115 === (4))){
var inst_20104 = (state_20114[(2)]);
var inst_20105 = process.call(null,inst_20104);
var state_20114__$1 = state_20114;
if(cljs.core.truth_(inst_20105)){
var statearr_20117_20275 = state_20114__$1;
(statearr_20117_20275[(1)] = (5));

} else {
var statearr_20118_20276 = state_20114__$1;
(statearr_20118_20276[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20115 === (5))){
var state_20114__$1 = state_20114;
var statearr_20119_20277 = state_20114__$1;
(statearr_20119_20277[(2)] = null);

(statearr_20119_20277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20115 === (6))){
var state_20114__$1 = state_20114;
var statearr_20120_20278 = state_20114__$1;
(statearr_20120_20278[(2)] = null);

(statearr_20120_20278[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20115 === (7))){
var inst_20110 = (state_20114[(2)]);
var state_20114__$1 = state_20114;
var statearr_20121_20279 = state_20114__$1;
(statearr_20121_20279[(2)] = inst_20110);

(statearr_20121_20279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20270,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
;
return ((function (__20270,switch__19596__auto__,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_20125 = [null,null,null,null,null,null,null];
(statearr_20125[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__);

(statearr_20125[(1)] = (1));

return statearr_20125;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1 = (function (state_20114){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20126){if((e20126 instanceof Object)){
var ex__19600__auto__ = e20126;
var statearr_20127_20280 = state_20114;
(statearr_20127_20280[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20114);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20126;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20281 = state_20114;
state_20114 = G__20281;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = function(state_20114){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1.call(this,state_20114);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__;
})()
;})(__20270,switch__19596__auto__,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
})();
var state__19710__auto__ = (function (){var statearr_20128 = f__19709__auto__.call(null);
(statearr_20128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___20273);

return statearr_20128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(__20270,c__19708__auto___20273,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
);


break;
case "async":
var c__19708__auto___20282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20270,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (__20270,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function (state_20141){
var state_val_20142 = (state_20141[(1)]);
if((state_val_20142 === (1))){
var state_20141__$1 = state_20141;
var statearr_20143_20283 = state_20141__$1;
(statearr_20143_20283[(2)] = null);

(statearr_20143_20283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20142 === (2))){
var state_20141__$1 = state_20141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20141__$1,(4),jobs);
} else {
if((state_val_20142 === (3))){
var inst_20139 = (state_20141[(2)]);
var state_20141__$1 = state_20141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20141__$1,inst_20139);
} else {
if((state_val_20142 === (4))){
var inst_20131 = (state_20141[(2)]);
var inst_20132 = async.call(null,inst_20131);
var state_20141__$1 = state_20141;
if(cljs.core.truth_(inst_20132)){
var statearr_20144_20284 = state_20141__$1;
(statearr_20144_20284[(1)] = (5));

} else {
var statearr_20145_20285 = state_20141__$1;
(statearr_20145_20285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20142 === (5))){
var state_20141__$1 = state_20141;
var statearr_20146_20286 = state_20141__$1;
(statearr_20146_20286[(2)] = null);

(statearr_20146_20286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20142 === (6))){
var state_20141__$1 = state_20141;
var statearr_20147_20287 = state_20141__$1;
(statearr_20147_20287[(2)] = null);

(statearr_20147_20287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20142 === (7))){
var inst_20137 = (state_20141[(2)]);
var state_20141__$1 = state_20141;
var statearr_20148_20288 = state_20141__$1;
(statearr_20148_20288[(2)] = inst_20137);

(statearr_20148_20288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20270,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
;
return ((function (__20270,switch__19596__auto__,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_20152 = [null,null,null,null,null,null,null];
(statearr_20152[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__);

(statearr_20152[(1)] = (1));

return statearr_20152;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1 = (function (state_20141){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20153){if((e20153 instanceof Object)){
var ex__19600__auto__ = e20153;
var statearr_20154_20289 = state_20141;
(statearr_20154_20289[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20153;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20290 = state_20141;
state_20141 = G__20290;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = function(state_20141){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1.call(this,state_20141);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__;
})()
;})(__20270,switch__19596__auto__,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
})();
var state__19710__auto__ = (function (){var statearr_20155 = f__19709__auto__.call(null);
(statearr_20155[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___20282);

return statearr_20155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(__20270,c__19708__auto___20282,G__20101_20271,n__7815__auto___20269,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__20291 = (__20270 + (1));
__20270 = G__20291;
continue;
} else {
}
break;
}

var c__19708__auto___20292 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___20292,jobs,results,process,async){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___20292,jobs,results,process,async){
return (function (state_20177){
var state_val_20178 = (state_20177[(1)]);
if((state_val_20178 === (1))){
var state_20177__$1 = state_20177;
var statearr_20179_20293 = state_20177__$1;
(statearr_20179_20293[(2)] = null);

(statearr_20179_20293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20178 === (2))){
var state_20177__$1 = state_20177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20177__$1,(4),from);
} else {
if((state_val_20178 === (3))){
var inst_20175 = (state_20177[(2)]);
var state_20177__$1 = state_20177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20177__$1,inst_20175);
} else {
if((state_val_20178 === (4))){
var inst_20158 = (state_20177[(7)]);
var inst_20158__$1 = (state_20177[(2)]);
var inst_20159 = (inst_20158__$1 == null);
var state_20177__$1 = (function (){var statearr_20180 = state_20177;
(statearr_20180[(7)] = inst_20158__$1);

return statearr_20180;
})();
if(cljs.core.truth_(inst_20159)){
var statearr_20181_20294 = state_20177__$1;
(statearr_20181_20294[(1)] = (5));

} else {
var statearr_20182_20295 = state_20177__$1;
(statearr_20182_20295[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20178 === (5))){
var inst_20161 = cljs.core.async.close_BANG_.call(null,jobs);
var state_20177__$1 = state_20177;
var statearr_20183_20296 = state_20177__$1;
(statearr_20183_20296[(2)] = inst_20161);

(statearr_20183_20296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20178 === (6))){
var inst_20158 = (state_20177[(7)]);
var inst_20163 = (state_20177[(8)]);
var inst_20163__$1 = cljs.core.async.chan.call(null,(1));
var inst_20164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20165 = [inst_20158,inst_20163__$1];
var inst_20166 = (new cljs.core.PersistentVector(null,2,(5),inst_20164,inst_20165,null));
var state_20177__$1 = (function (){var statearr_20184 = state_20177;
(statearr_20184[(8)] = inst_20163__$1);

return statearr_20184;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20177__$1,(8),jobs,inst_20166);
} else {
if((state_val_20178 === (7))){
var inst_20173 = (state_20177[(2)]);
var state_20177__$1 = state_20177;
var statearr_20185_20297 = state_20177__$1;
(statearr_20185_20297[(2)] = inst_20173);

(statearr_20185_20297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20178 === (8))){
var inst_20163 = (state_20177[(8)]);
var inst_20168 = (state_20177[(2)]);
var state_20177__$1 = (function (){var statearr_20186 = state_20177;
(statearr_20186[(9)] = inst_20168);

return statearr_20186;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20177__$1,(9),results,inst_20163);
} else {
if((state_val_20178 === (9))){
var inst_20170 = (state_20177[(2)]);
var state_20177__$1 = (function (){var statearr_20187 = state_20177;
(statearr_20187[(10)] = inst_20170);

return statearr_20187;
})();
var statearr_20188_20298 = state_20177__$1;
(statearr_20188_20298[(2)] = null);

(statearr_20188_20298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___20292,jobs,results,process,async))
;
return ((function (switch__19596__auto__,c__19708__auto___20292,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_20192 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20192[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__);

(statearr_20192[(1)] = (1));

return statearr_20192;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1 = (function (state_20177){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20193){if((e20193 instanceof Object)){
var ex__19600__auto__ = e20193;
var statearr_20194_20299 = state_20177;
(statearr_20194_20299[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20193;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20300 = state_20177;
state_20177 = G__20300;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = function(state_20177){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1.call(this,state_20177);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___20292,jobs,results,process,async))
})();
var state__19710__auto__ = (function (){var statearr_20195 = f__19709__auto__.call(null);
(statearr_20195[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___20292);

return statearr_20195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___20292,jobs,results,process,async))
);


var c__19708__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto__,jobs,results,process,async){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto__,jobs,results,process,async){
return (function (state_20233){
var state_val_20234 = (state_20233[(1)]);
if((state_val_20234 === (7))){
var inst_20229 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
var statearr_20235_20301 = state_20233__$1;
(statearr_20235_20301[(2)] = inst_20229);

(statearr_20235_20301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (20))){
var state_20233__$1 = state_20233;
var statearr_20236_20302 = state_20233__$1;
(statearr_20236_20302[(2)] = null);

(statearr_20236_20302[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (1))){
var state_20233__$1 = state_20233;
var statearr_20237_20303 = state_20233__$1;
(statearr_20237_20303[(2)] = null);

(statearr_20237_20303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (4))){
var inst_20198 = (state_20233[(7)]);
var inst_20198__$1 = (state_20233[(2)]);
var inst_20199 = (inst_20198__$1 == null);
var state_20233__$1 = (function (){var statearr_20238 = state_20233;
(statearr_20238[(7)] = inst_20198__$1);

return statearr_20238;
})();
if(cljs.core.truth_(inst_20199)){
var statearr_20239_20304 = state_20233__$1;
(statearr_20239_20304[(1)] = (5));

} else {
var statearr_20240_20305 = state_20233__$1;
(statearr_20240_20305[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (15))){
var inst_20211 = (state_20233[(8)]);
var state_20233__$1 = state_20233;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20233__$1,(18),to,inst_20211);
} else {
if((state_val_20234 === (21))){
var inst_20224 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
var statearr_20241_20306 = state_20233__$1;
(statearr_20241_20306[(2)] = inst_20224);

(statearr_20241_20306[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (13))){
var inst_20226 = (state_20233[(2)]);
var state_20233__$1 = (function (){var statearr_20242 = state_20233;
(statearr_20242[(9)] = inst_20226);

return statearr_20242;
})();
var statearr_20243_20307 = state_20233__$1;
(statearr_20243_20307[(2)] = null);

(statearr_20243_20307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (6))){
var inst_20198 = (state_20233[(7)]);
var state_20233__$1 = state_20233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20233__$1,(11),inst_20198);
} else {
if((state_val_20234 === (17))){
var inst_20219 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
if(cljs.core.truth_(inst_20219)){
var statearr_20244_20308 = state_20233__$1;
(statearr_20244_20308[(1)] = (19));

} else {
var statearr_20245_20309 = state_20233__$1;
(statearr_20245_20309[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (3))){
var inst_20231 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20233__$1,inst_20231);
} else {
if((state_val_20234 === (12))){
var inst_20208 = (state_20233[(10)]);
var state_20233__$1 = state_20233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20233__$1,(14),inst_20208);
} else {
if((state_val_20234 === (2))){
var state_20233__$1 = state_20233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20233__$1,(4),results);
} else {
if((state_val_20234 === (19))){
var state_20233__$1 = state_20233;
var statearr_20246_20310 = state_20233__$1;
(statearr_20246_20310[(2)] = null);

(statearr_20246_20310[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (11))){
var inst_20208 = (state_20233[(2)]);
var state_20233__$1 = (function (){var statearr_20247 = state_20233;
(statearr_20247[(10)] = inst_20208);

return statearr_20247;
})();
var statearr_20248_20311 = state_20233__$1;
(statearr_20248_20311[(2)] = null);

(statearr_20248_20311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (9))){
var state_20233__$1 = state_20233;
var statearr_20249_20312 = state_20233__$1;
(statearr_20249_20312[(2)] = null);

(statearr_20249_20312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (5))){
var state_20233__$1 = state_20233;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20250_20313 = state_20233__$1;
(statearr_20250_20313[(1)] = (8));

} else {
var statearr_20251_20314 = state_20233__$1;
(statearr_20251_20314[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (14))){
var inst_20211 = (state_20233[(8)]);
var inst_20213 = (state_20233[(11)]);
var inst_20211__$1 = (state_20233[(2)]);
var inst_20212 = (inst_20211__$1 == null);
var inst_20213__$1 = cljs.core.not.call(null,inst_20212);
var state_20233__$1 = (function (){var statearr_20252 = state_20233;
(statearr_20252[(8)] = inst_20211__$1);

(statearr_20252[(11)] = inst_20213__$1);

return statearr_20252;
})();
if(inst_20213__$1){
var statearr_20253_20315 = state_20233__$1;
(statearr_20253_20315[(1)] = (15));

} else {
var statearr_20254_20316 = state_20233__$1;
(statearr_20254_20316[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (16))){
var inst_20213 = (state_20233[(11)]);
var state_20233__$1 = state_20233;
var statearr_20255_20317 = state_20233__$1;
(statearr_20255_20317[(2)] = inst_20213);

(statearr_20255_20317[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (10))){
var inst_20205 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
var statearr_20256_20318 = state_20233__$1;
(statearr_20256_20318[(2)] = inst_20205);

(statearr_20256_20318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (18))){
var inst_20216 = (state_20233[(2)]);
var state_20233__$1 = state_20233;
var statearr_20257_20319 = state_20233__$1;
(statearr_20257_20319[(2)] = inst_20216);

(statearr_20257_20319[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20234 === (8))){
var inst_20202 = cljs.core.async.close_BANG_.call(null,to);
var state_20233__$1 = state_20233;
var statearr_20258_20320 = state_20233__$1;
(statearr_20258_20320[(2)] = inst_20202);

(statearr_20258_20320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto__,jobs,results,process,async))
;
return ((function (switch__19596__auto__,c__19708__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_20262 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20262[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__);

(statearr_20262[(1)] = (1));

return statearr_20262;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1 = (function (state_20233){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20263){if((e20263 instanceof Object)){
var ex__19600__auto__ = e20263;
var statearr_20264_20321 = state_20233;
(statearr_20264_20321[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20233);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20322 = state_20233;
state_20233 = G__20322;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__ = function(state_20233){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1.call(this,state_20233);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto__,jobs,results,process,async))
})();
var state__19710__auto__ = (function (){var statearr_20265 = f__19709__auto__.call(null);
(statearr_20265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto__);

return statearr_20265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto__,jobs,results,process,async))
);

return c__19708__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args20323 = [];
var len__8005__auto___20326 = arguments.length;
var i__8006__auto___20327 = (0);
while(true){
if((i__8006__auto___20327 < len__8005__auto___20326)){
args20323.push((arguments[i__8006__auto___20327]));

var G__20328 = (i__8006__auto___20327 + (1));
i__8006__auto___20327 = G__20328;
continue;
} else {
}
break;
}

var G__20325 = args20323.length;
switch (G__20325) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args20323.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args20330 = [];
var len__8005__auto___20333 = arguments.length;
var i__8006__auto___20334 = (0);
while(true){
if((i__8006__auto___20334 < len__8005__auto___20333)){
args20330.push((arguments[i__8006__auto___20334]));

var G__20335 = (i__8006__auto___20334 + (1));
i__8006__auto___20334 = G__20335;
continue;
} else {
}
break;
}

var G__20332 = args20330.length;
switch (G__20332) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args20330.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args20337 = [];
var len__8005__auto___20390 = arguments.length;
var i__8006__auto___20391 = (0);
while(true){
if((i__8006__auto___20391 < len__8005__auto___20390)){
args20337.push((arguments[i__8006__auto___20391]));

var G__20392 = (i__8006__auto___20391 + (1));
i__8006__auto___20391 = G__20392;
continue;
} else {
}
break;
}

var G__20339 = args20337.length;
switch (G__20339) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args20337.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__19708__auto___20394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___20394,tc,fc){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___20394,tc,fc){
return (function (state_20365){
var state_val_20366 = (state_20365[(1)]);
if((state_val_20366 === (7))){
var inst_20361 = (state_20365[(2)]);
var state_20365__$1 = state_20365;
var statearr_20367_20395 = state_20365__$1;
(statearr_20367_20395[(2)] = inst_20361);

(statearr_20367_20395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (1))){
var state_20365__$1 = state_20365;
var statearr_20368_20396 = state_20365__$1;
(statearr_20368_20396[(2)] = null);

(statearr_20368_20396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (4))){
var inst_20342 = (state_20365[(7)]);
var inst_20342__$1 = (state_20365[(2)]);
var inst_20343 = (inst_20342__$1 == null);
var state_20365__$1 = (function (){var statearr_20369 = state_20365;
(statearr_20369[(7)] = inst_20342__$1);

return statearr_20369;
})();
if(cljs.core.truth_(inst_20343)){
var statearr_20370_20397 = state_20365__$1;
(statearr_20370_20397[(1)] = (5));

} else {
var statearr_20371_20398 = state_20365__$1;
(statearr_20371_20398[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (13))){
var state_20365__$1 = state_20365;
var statearr_20372_20399 = state_20365__$1;
(statearr_20372_20399[(2)] = null);

(statearr_20372_20399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (6))){
var inst_20342 = (state_20365[(7)]);
var inst_20348 = p.call(null,inst_20342);
var state_20365__$1 = state_20365;
if(cljs.core.truth_(inst_20348)){
var statearr_20373_20400 = state_20365__$1;
(statearr_20373_20400[(1)] = (9));

} else {
var statearr_20374_20401 = state_20365__$1;
(statearr_20374_20401[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (3))){
var inst_20363 = (state_20365[(2)]);
var state_20365__$1 = state_20365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20365__$1,inst_20363);
} else {
if((state_val_20366 === (12))){
var state_20365__$1 = state_20365;
var statearr_20375_20402 = state_20365__$1;
(statearr_20375_20402[(2)] = null);

(statearr_20375_20402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (2))){
var state_20365__$1 = state_20365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20365__$1,(4),ch);
} else {
if((state_val_20366 === (11))){
var inst_20342 = (state_20365[(7)]);
var inst_20352 = (state_20365[(2)]);
var state_20365__$1 = state_20365;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20365__$1,(8),inst_20352,inst_20342);
} else {
if((state_val_20366 === (9))){
var state_20365__$1 = state_20365;
var statearr_20376_20403 = state_20365__$1;
(statearr_20376_20403[(2)] = tc);

(statearr_20376_20403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (5))){
var inst_20345 = cljs.core.async.close_BANG_.call(null,tc);
var inst_20346 = cljs.core.async.close_BANG_.call(null,fc);
var state_20365__$1 = (function (){var statearr_20377 = state_20365;
(statearr_20377[(8)] = inst_20345);

return statearr_20377;
})();
var statearr_20378_20404 = state_20365__$1;
(statearr_20378_20404[(2)] = inst_20346);

(statearr_20378_20404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (14))){
var inst_20359 = (state_20365[(2)]);
var state_20365__$1 = state_20365;
var statearr_20379_20405 = state_20365__$1;
(statearr_20379_20405[(2)] = inst_20359);

(statearr_20379_20405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (10))){
var state_20365__$1 = state_20365;
var statearr_20380_20406 = state_20365__$1;
(statearr_20380_20406[(2)] = fc);

(statearr_20380_20406[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20366 === (8))){
var inst_20354 = (state_20365[(2)]);
var state_20365__$1 = state_20365;
if(cljs.core.truth_(inst_20354)){
var statearr_20381_20407 = state_20365__$1;
(statearr_20381_20407[(1)] = (12));

} else {
var statearr_20382_20408 = state_20365__$1;
(statearr_20382_20408[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___20394,tc,fc))
;
return ((function (switch__19596__auto__,c__19708__auto___20394,tc,fc){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_20386 = [null,null,null,null,null,null,null,null,null];
(statearr_20386[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_20386[(1)] = (1));

return statearr_20386;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_20365){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20387){if((e20387 instanceof Object)){
var ex__19600__auto__ = e20387;
var statearr_20388_20409 = state_20365;
(statearr_20388_20409[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20410 = state_20365;
state_20365 = G__20410;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_20365){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_20365);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___20394,tc,fc))
})();
var state__19710__auto__ = (function (){var statearr_20389 = f__19709__auto__.call(null);
(statearr_20389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___20394);

return statearr_20389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___20394,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19708__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto__){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto__){
return (function (state_20474){
var state_val_20475 = (state_20474[(1)]);
if((state_val_20475 === (7))){
var inst_20470 = (state_20474[(2)]);
var state_20474__$1 = state_20474;
var statearr_20476_20497 = state_20474__$1;
(statearr_20476_20497[(2)] = inst_20470);

(statearr_20476_20497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (1))){
var inst_20454 = init;
var state_20474__$1 = (function (){var statearr_20477 = state_20474;
(statearr_20477[(7)] = inst_20454);

return statearr_20477;
})();
var statearr_20478_20498 = state_20474__$1;
(statearr_20478_20498[(2)] = null);

(statearr_20478_20498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (4))){
var inst_20457 = (state_20474[(8)]);
var inst_20457__$1 = (state_20474[(2)]);
var inst_20458 = (inst_20457__$1 == null);
var state_20474__$1 = (function (){var statearr_20479 = state_20474;
(statearr_20479[(8)] = inst_20457__$1);

return statearr_20479;
})();
if(cljs.core.truth_(inst_20458)){
var statearr_20480_20499 = state_20474__$1;
(statearr_20480_20499[(1)] = (5));

} else {
var statearr_20481_20500 = state_20474__$1;
(statearr_20481_20500[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (6))){
var inst_20461 = (state_20474[(9)]);
var inst_20454 = (state_20474[(7)]);
var inst_20457 = (state_20474[(8)]);
var inst_20461__$1 = f.call(null,inst_20454,inst_20457);
var inst_20462 = cljs.core.reduced_QMARK_.call(null,inst_20461__$1);
var state_20474__$1 = (function (){var statearr_20482 = state_20474;
(statearr_20482[(9)] = inst_20461__$1);

return statearr_20482;
})();
if(inst_20462){
var statearr_20483_20501 = state_20474__$1;
(statearr_20483_20501[(1)] = (8));

} else {
var statearr_20484_20502 = state_20474__$1;
(statearr_20484_20502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (3))){
var inst_20472 = (state_20474[(2)]);
var state_20474__$1 = state_20474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20474__$1,inst_20472);
} else {
if((state_val_20475 === (2))){
var state_20474__$1 = state_20474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20474__$1,(4),ch);
} else {
if((state_val_20475 === (9))){
var inst_20461 = (state_20474[(9)]);
var inst_20454 = inst_20461;
var state_20474__$1 = (function (){var statearr_20485 = state_20474;
(statearr_20485[(7)] = inst_20454);

return statearr_20485;
})();
var statearr_20486_20503 = state_20474__$1;
(statearr_20486_20503[(2)] = null);

(statearr_20486_20503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (5))){
var inst_20454 = (state_20474[(7)]);
var state_20474__$1 = state_20474;
var statearr_20487_20504 = state_20474__$1;
(statearr_20487_20504[(2)] = inst_20454);

(statearr_20487_20504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (10))){
var inst_20468 = (state_20474[(2)]);
var state_20474__$1 = state_20474;
var statearr_20488_20505 = state_20474__$1;
(statearr_20488_20505[(2)] = inst_20468);

(statearr_20488_20505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (8))){
var inst_20461 = (state_20474[(9)]);
var inst_20464 = cljs.core.deref.call(null,inst_20461);
var state_20474__$1 = state_20474;
var statearr_20489_20506 = state_20474__$1;
(statearr_20489_20506[(2)] = inst_20464);

(statearr_20489_20506[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto__))
;
return ((function (switch__19596__auto__,c__19708__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19597__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19597__auto____0 = (function (){
var statearr_20493 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20493[(0)] = cljs$core$async$reduce_$_state_machine__19597__auto__);

(statearr_20493[(1)] = (1));

return statearr_20493;
});
var cljs$core$async$reduce_$_state_machine__19597__auto____1 = (function (state_20474){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20494){if((e20494 instanceof Object)){
var ex__19600__auto__ = e20494;
var statearr_20495_20507 = state_20474;
(statearr_20495_20507[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20508 = state_20474;
state_20474 = G__20508;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19597__auto__ = function(state_20474){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19597__auto____1.call(this,state_20474);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19597__auto____0;
cljs$core$async$reduce_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19597__auto____1;
return cljs$core$async$reduce_$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto__))
})();
var state__19710__auto__ = (function (){var statearr_20496 = f__19709__auto__.call(null);
(statearr_20496[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto__);

return statearr_20496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto__))
);

return c__19708__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args20509 = [];
var len__8005__auto___20561 = arguments.length;
var i__8006__auto___20562 = (0);
while(true){
if((i__8006__auto___20562 < len__8005__auto___20561)){
args20509.push((arguments[i__8006__auto___20562]));

var G__20563 = (i__8006__auto___20562 + (1));
i__8006__auto___20562 = G__20563;
continue;
} else {
}
break;
}

var G__20511 = args20509.length;
switch (G__20511) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args20509.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19708__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto__){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto__){
return (function (state_20536){
var state_val_20537 = (state_20536[(1)]);
if((state_val_20537 === (7))){
var inst_20518 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20538_20565 = state_20536__$1;
(statearr_20538_20565[(2)] = inst_20518);

(statearr_20538_20565[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (1))){
var inst_20512 = cljs.core.seq.call(null,coll);
var inst_20513 = inst_20512;
var state_20536__$1 = (function (){var statearr_20539 = state_20536;
(statearr_20539[(7)] = inst_20513);

return statearr_20539;
})();
var statearr_20540_20566 = state_20536__$1;
(statearr_20540_20566[(2)] = null);

(statearr_20540_20566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (4))){
var inst_20513 = (state_20536[(7)]);
var inst_20516 = cljs.core.first.call(null,inst_20513);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20536__$1,(7),ch,inst_20516);
} else {
if((state_val_20537 === (13))){
var inst_20530 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20541_20567 = state_20536__$1;
(statearr_20541_20567[(2)] = inst_20530);

(statearr_20541_20567[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (6))){
var inst_20521 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
if(cljs.core.truth_(inst_20521)){
var statearr_20542_20568 = state_20536__$1;
(statearr_20542_20568[(1)] = (8));

} else {
var statearr_20543_20569 = state_20536__$1;
(statearr_20543_20569[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (3))){
var inst_20534 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20536__$1,inst_20534);
} else {
if((state_val_20537 === (12))){
var state_20536__$1 = state_20536;
var statearr_20544_20570 = state_20536__$1;
(statearr_20544_20570[(2)] = null);

(statearr_20544_20570[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (2))){
var inst_20513 = (state_20536[(7)]);
var state_20536__$1 = state_20536;
if(cljs.core.truth_(inst_20513)){
var statearr_20545_20571 = state_20536__$1;
(statearr_20545_20571[(1)] = (4));

} else {
var statearr_20546_20572 = state_20536__$1;
(statearr_20546_20572[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (11))){
var inst_20527 = cljs.core.async.close_BANG_.call(null,ch);
var state_20536__$1 = state_20536;
var statearr_20547_20573 = state_20536__$1;
(statearr_20547_20573[(2)] = inst_20527);

(statearr_20547_20573[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (9))){
var state_20536__$1 = state_20536;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20548_20574 = state_20536__$1;
(statearr_20548_20574[(1)] = (11));

} else {
var statearr_20549_20575 = state_20536__$1;
(statearr_20549_20575[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (5))){
var inst_20513 = (state_20536[(7)]);
var state_20536__$1 = state_20536;
var statearr_20550_20576 = state_20536__$1;
(statearr_20550_20576[(2)] = inst_20513);

(statearr_20550_20576[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (10))){
var inst_20532 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20551_20577 = state_20536__$1;
(statearr_20551_20577[(2)] = inst_20532);

(statearr_20551_20577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (8))){
var inst_20513 = (state_20536[(7)]);
var inst_20523 = cljs.core.next.call(null,inst_20513);
var inst_20513__$1 = inst_20523;
var state_20536__$1 = (function (){var statearr_20552 = state_20536;
(statearr_20552[(7)] = inst_20513__$1);

return statearr_20552;
})();
var statearr_20553_20578 = state_20536__$1;
(statearr_20553_20578[(2)] = null);

(statearr_20553_20578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto__))
;
return ((function (switch__19596__auto__,c__19708__auto__){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_20557 = [null,null,null,null,null,null,null,null];
(statearr_20557[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_20557[(1)] = (1));

return statearr_20557;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_20536){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e20558){if((e20558 instanceof Object)){
var ex__19600__auto__ = e20558;
var statearr_20559_20579 = state_20536;
(statearr_20559_20579[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20536);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20558;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20580 = state_20536;
state_20536 = G__20580;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_20536){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_20536);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto__))
})();
var state__19710__auto__ = (function (){var statearr_20560 = f__19709__auto__.call(null);
(statearr_20560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto__);

return statearr_20560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto__))
);

return c__19708__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7560__auto__ = (((_ == null))?null:_);
var m__7561__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,_);
} else {
var m__7561__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7561__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,ch);
} else {
var m__7561__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m);
} else {
var m__7561__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20806 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20806 = (function (ch,cs,meta20807){
this.ch = ch;
this.cs = cs;
this.meta20807 = meta20807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20808,meta20807__$1){
var self__ = this;
var _20808__$1 = this;
return (new cljs.core.async.t_cljs$core$async20806(self__.ch,self__.cs,meta20807__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20808){
var self__ = this;
var _20808__$1 = this;
return self__.meta20807;
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20807","meta20807",1150901440,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20806.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20806.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20806";

cljs.core.async.t_cljs$core$async20806.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async20806");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20806 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20806(ch__$1,cs__$1,meta20807){
return (new cljs.core.async.t_cljs$core$async20806(ch__$1,cs__$1,meta20807));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20806(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19708__auto___21031 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21031,cs,m,dchan,dctr,done){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21031,cs,m,dchan,dctr,done){
return (function (state_20943){
var state_val_20944 = (state_20943[(1)]);
if((state_val_20944 === (7))){
var inst_20939 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_20945_21032 = state_20943__$1;
(statearr_20945_21032[(2)] = inst_20939);

(statearr_20945_21032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (20))){
var inst_20842 = (state_20943[(7)]);
var inst_20854 = cljs.core.first.call(null,inst_20842);
var inst_20855 = cljs.core.nth.call(null,inst_20854,(0),null);
var inst_20856 = cljs.core.nth.call(null,inst_20854,(1),null);
var state_20943__$1 = (function (){var statearr_20946 = state_20943;
(statearr_20946[(8)] = inst_20855);

return statearr_20946;
})();
if(cljs.core.truth_(inst_20856)){
var statearr_20947_21033 = state_20943__$1;
(statearr_20947_21033[(1)] = (22));

} else {
var statearr_20948_21034 = state_20943__$1;
(statearr_20948_21034[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (27))){
var inst_20811 = (state_20943[(9)]);
var inst_20886 = (state_20943[(10)]);
var inst_20891 = (state_20943[(11)]);
var inst_20884 = (state_20943[(12)]);
var inst_20891__$1 = cljs.core._nth.call(null,inst_20884,inst_20886);
var inst_20892 = cljs.core.async.put_BANG_.call(null,inst_20891__$1,inst_20811,done);
var state_20943__$1 = (function (){var statearr_20949 = state_20943;
(statearr_20949[(11)] = inst_20891__$1);

return statearr_20949;
})();
if(cljs.core.truth_(inst_20892)){
var statearr_20950_21035 = state_20943__$1;
(statearr_20950_21035[(1)] = (30));

} else {
var statearr_20951_21036 = state_20943__$1;
(statearr_20951_21036[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (1))){
var state_20943__$1 = state_20943;
var statearr_20952_21037 = state_20943__$1;
(statearr_20952_21037[(2)] = null);

(statearr_20952_21037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (24))){
var inst_20842 = (state_20943[(7)]);
var inst_20861 = (state_20943[(2)]);
var inst_20862 = cljs.core.next.call(null,inst_20842);
var inst_20820 = inst_20862;
var inst_20821 = null;
var inst_20822 = (0);
var inst_20823 = (0);
var state_20943__$1 = (function (){var statearr_20953 = state_20943;
(statearr_20953[(13)] = inst_20822);

(statearr_20953[(14)] = inst_20861);

(statearr_20953[(15)] = inst_20823);

(statearr_20953[(16)] = inst_20820);

(statearr_20953[(17)] = inst_20821);

return statearr_20953;
})();
var statearr_20954_21038 = state_20943__$1;
(statearr_20954_21038[(2)] = null);

(statearr_20954_21038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (39))){
var state_20943__$1 = state_20943;
var statearr_20958_21039 = state_20943__$1;
(statearr_20958_21039[(2)] = null);

(statearr_20958_21039[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (4))){
var inst_20811 = (state_20943[(9)]);
var inst_20811__$1 = (state_20943[(2)]);
var inst_20812 = (inst_20811__$1 == null);
var state_20943__$1 = (function (){var statearr_20959 = state_20943;
(statearr_20959[(9)] = inst_20811__$1);

return statearr_20959;
})();
if(cljs.core.truth_(inst_20812)){
var statearr_20960_21040 = state_20943__$1;
(statearr_20960_21040[(1)] = (5));

} else {
var statearr_20961_21041 = state_20943__$1;
(statearr_20961_21041[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (15))){
var inst_20822 = (state_20943[(13)]);
var inst_20823 = (state_20943[(15)]);
var inst_20820 = (state_20943[(16)]);
var inst_20821 = (state_20943[(17)]);
var inst_20838 = (state_20943[(2)]);
var inst_20839 = (inst_20823 + (1));
var tmp20955 = inst_20822;
var tmp20956 = inst_20820;
var tmp20957 = inst_20821;
var inst_20820__$1 = tmp20956;
var inst_20821__$1 = tmp20957;
var inst_20822__$1 = tmp20955;
var inst_20823__$1 = inst_20839;
var state_20943__$1 = (function (){var statearr_20962 = state_20943;
(statearr_20962[(13)] = inst_20822__$1);

(statearr_20962[(15)] = inst_20823__$1);

(statearr_20962[(16)] = inst_20820__$1);

(statearr_20962[(18)] = inst_20838);

(statearr_20962[(17)] = inst_20821__$1);

return statearr_20962;
})();
var statearr_20963_21042 = state_20943__$1;
(statearr_20963_21042[(2)] = null);

(statearr_20963_21042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (21))){
var inst_20865 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_20967_21043 = state_20943__$1;
(statearr_20967_21043[(2)] = inst_20865);

(statearr_20967_21043[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (31))){
var inst_20891 = (state_20943[(11)]);
var inst_20895 = done.call(null,null);
var inst_20896 = cljs.core.async.untap_STAR_.call(null,m,inst_20891);
var state_20943__$1 = (function (){var statearr_20968 = state_20943;
(statearr_20968[(19)] = inst_20895);

return statearr_20968;
})();
var statearr_20969_21044 = state_20943__$1;
(statearr_20969_21044[(2)] = inst_20896);

(statearr_20969_21044[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (32))){
var inst_20883 = (state_20943[(20)]);
var inst_20886 = (state_20943[(10)]);
var inst_20884 = (state_20943[(12)]);
var inst_20885 = (state_20943[(21)]);
var inst_20898 = (state_20943[(2)]);
var inst_20899 = (inst_20886 + (1));
var tmp20964 = inst_20883;
var tmp20965 = inst_20884;
var tmp20966 = inst_20885;
var inst_20883__$1 = tmp20964;
var inst_20884__$1 = tmp20965;
var inst_20885__$1 = tmp20966;
var inst_20886__$1 = inst_20899;
var state_20943__$1 = (function (){var statearr_20970 = state_20943;
(statearr_20970[(20)] = inst_20883__$1);

(statearr_20970[(10)] = inst_20886__$1);

(statearr_20970[(22)] = inst_20898);

(statearr_20970[(12)] = inst_20884__$1);

(statearr_20970[(21)] = inst_20885__$1);

return statearr_20970;
})();
var statearr_20971_21045 = state_20943__$1;
(statearr_20971_21045[(2)] = null);

(statearr_20971_21045[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (40))){
var inst_20911 = (state_20943[(23)]);
var inst_20915 = done.call(null,null);
var inst_20916 = cljs.core.async.untap_STAR_.call(null,m,inst_20911);
var state_20943__$1 = (function (){var statearr_20972 = state_20943;
(statearr_20972[(24)] = inst_20915);

return statearr_20972;
})();
var statearr_20973_21046 = state_20943__$1;
(statearr_20973_21046[(2)] = inst_20916);

(statearr_20973_21046[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (33))){
var inst_20902 = (state_20943[(25)]);
var inst_20904 = cljs.core.chunked_seq_QMARK_.call(null,inst_20902);
var state_20943__$1 = state_20943;
if(inst_20904){
var statearr_20974_21047 = state_20943__$1;
(statearr_20974_21047[(1)] = (36));

} else {
var statearr_20975_21048 = state_20943__$1;
(statearr_20975_21048[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (13))){
var inst_20832 = (state_20943[(26)]);
var inst_20835 = cljs.core.async.close_BANG_.call(null,inst_20832);
var state_20943__$1 = state_20943;
var statearr_20976_21049 = state_20943__$1;
(statearr_20976_21049[(2)] = inst_20835);

(statearr_20976_21049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (22))){
var inst_20855 = (state_20943[(8)]);
var inst_20858 = cljs.core.async.close_BANG_.call(null,inst_20855);
var state_20943__$1 = state_20943;
var statearr_20977_21050 = state_20943__$1;
(statearr_20977_21050[(2)] = inst_20858);

(statearr_20977_21050[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (36))){
var inst_20902 = (state_20943[(25)]);
var inst_20906 = cljs.core.chunk_first.call(null,inst_20902);
var inst_20907 = cljs.core.chunk_rest.call(null,inst_20902);
var inst_20908 = cljs.core.count.call(null,inst_20906);
var inst_20883 = inst_20907;
var inst_20884 = inst_20906;
var inst_20885 = inst_20908;
var inst_20886 = (0);
var state_20943__$1 = (function (){var statearr_20978 = state_20943;
(statearr_20978[(20)] = inst_20883);

(statearr_20978[(10)] = inst_20886);

(statearr_20978[(12)] = inst_20884);

(statearr_20978[(21)] = inst_20885);

return statearr_20978;
})();
var statearr_20979_21051 = state_20943__$1;
(statearr_20979_21051[(2)] = null);

(statearr_20979_21051[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (41))){
var inst_20902 = (state_20943[(25)]);
var inst_20918 = (state_20943[(2)]);
var inst_20919 = cljs.core.next.call(null,inst_20902);
var inst_20883 = inst_20919;
var inst_20884 = null;
var inst_20885 = (0);
var inst_20886 = (0);
var state_20943__$1 = (function (){var statearr_20980 = state_20943;
(statearr_20980[(27)] = inst_20918);

(statearr_20980[(20)] = inst_20883);

(statearr_20980[(10)] = inst_20886);

(statearr_20980[(12)] = inst_20884);

(statearr_20980[(21)] = inst_20885);

return statearr_20980;
})();
var statearr_20981_21052 = state_20943__$1;
(statearr_20981_21052[(2)] = null);

(statearr_20981_21052[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (43))){
var state_20943__$1 = state_20943;
var statearr_20982_21053 = state_20943__$1;
(statearr_20982_21053[(2)] = null);

(statearr_20982_21053[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (29))){
var inst_20927 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_20983_21054 = state_20943__$1;
(statearr_20983_21054[(2)] = inst_20927);

(statearr_20983_21054[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (44))){
var inst_20936 = (state_20943[(2)]);
var state_20943__$1 = (function (){var statearr_20984 = state_20943;
(statearr_20984[(28)] = inst_20936);

return statearr_20984;
})();
var statearr_20985_21055 = state_20943__$1;
(statearr_20985_21055[(2)] = null);

(statearr_20985_21055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (6))){
var inst_20875 = (state_20943[(29)]);
var inst_20874 = cljs.core.deref.call(null,cs);
var inst_20875__$1 = cljs.core.keys.call(null,inst_20874);
var inst_20876 = cljs.core.count.call(null,inst_20875__$1);
var inst_20877 = cljs.core.reset_BANG_.call(null,dctr,inst_20876);
var inst_20882 = cljs.core.seq.call(null,inst_20875__$1);
var inst_20883 = inst_20882;
var inst_20884 = null;
var inst_20885 = (0);
var inst_20886 = (0);
var state_20943__$1 = (function (){var statearr_20986 = state_20943;
(statearr_20986[(29)] = inst_20875__$1);

(statearr_20986[(30)] = inst_20877);

(statearr_20986[(20)] = inst_20883);

(statearr_20986[(10)] = inst_20886);

(statearr_20986[(12)] = inst_20884);

(statearr_20986[(21)] = inst_20885);

return statearr_20986;
})();
var statearr_20987_21056 = state_20943__$1;
(statearr_20987_21056[(2)] = null);

(statearr_20987_21056[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (28))){
var inst_20883 = (state_20943[(20)]);
var inst_20902 = (state_20943[(25)]);
var inst_20902__$1 = cljs.core.seq.call(null,inst_20883);
var state_20943__$1 = (function (){var statearr_20988 = state_20943;
(statearr_20988[(25)] = inst_20902__$1);

return statearr_20988;
})();
if(inst_20902__$1){
var statearr_20989_21057 = state_20943__$1;
(statearr_20989_21057[(1)] = (33));

} else {
var statearr_20990_21058 = state_20943__$1;
(statearr_20990_21058[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (25))){
var inst_20886 = (state_20943[(10)]);
var inst_20885 = (state_20943[(21)]);
var inst_20888 = (inst_20886 < inst_20885);
var inst_20889 = inst_20888;
var state_20943__$1 = state_20943;
if(cljs.core.truth_(inst_20889)){
var statearr_20991_21059 = state_20943__$1;
(statearr_20991_21059[(1)] = (27));

} else {
var statearr_20992_21060 = state_20943__$1;
(statearr_20992_21060[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (34))){
var state_20943__$1 = state_20943;
var statearr_20993_21061 = state_20943__$1;
(statearr_20993_21061[(2)] = null);

(statearr_20993_21061[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (17))){
var state_20943__$1 = state_20943;
var statearr_20994_21062 = state_20943__$1;
(statearr_20994_21062[(2)] = null);

(statearr_20994_21062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (3))){
var inst_20941 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20943__$1,inst_20941);
} else {
if((state_val_20944 === (12))){
var inst_20870 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_20995_21063 = state_20943__$1;
(statearr_20995_21063[(2)] = inst_20870);

(statearr_20995_21063[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (2))){
var state_20943__$1 = state_20943;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20943__$1,(4),ch);
} else {
if((state_val_20944 === (23))){
var state_20943__$1 = state_20943;
var statearr_20996_21064 = state_20943__$1;
(statearr_20996_21064[(2)] = null);

(statearr_20996_21064[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (35))){
var inst_20925 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_20997_21065 = state_20943__$1;
(statearr_20997_21065[(2)] = inst_20925);

(statearr_20997_21065[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (19))){
var inst_20842 = (state_20943[(7)]);
var inst_20846 = cljs.core.chunk_first.call(null,inst_20842);
var inst_20847 = cljs.core.chunk_rest.call(null,inst_20842);
var inst_20848 = cljs.core.count.call(null,inst_20846);
var inst_20820 = inst_20847;
var inst_20821 = inst_20846;
var inst_20822 = inst_20848;
var inst_20823 = (0);
var state_20943__$1 = (function (){var statearr_20998 = state_20943;
(statearr_20998[(13)] = inst_20822);

(statearr_20998[(15)] = inst_20823);

(statearr_20998[(16)] = inst_20820);

(statearr_20998[(17)] = inst_20821);

return statearr_20998;
})();
var statearr_20999_21066 = state_20943__$1;
(statearr_20999_21066[(2)] = null);

(statearr_20999_21066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (11))){
var inst_20842 = (state_20943[(7)]);
var inst_20820 = (state_20943[(16)]);
var inst_20842__$1 = cljs.core.seq.call(null,inst_20820);
var state_20943__$1 = (function (){var statearr_21000 = state_20943;
(statearr_21000[(7)] = inst_20842__$1);

return statearr_21000;
})();
if(inst_20842__$1){
var statearr_21001_21067 = state_20943__$1;
(statearr_21001_21067[(1)] = (16));

} else {
var statearr_21002_21068 = state_20943__$1;
(statearr_21002_21068[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (9))){
var inst_20872 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_21003_21069 = state_20943__$1;
(statearr_21003_21069[(2)] = inst_20872);

(statearr_21003_21069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (5))){
var inst_20818 = cljs.core.deref.call(null,cs);
var inst_20819 = cljs.core.seq.call(null,inst_20818);
var inst_20820 = inst_20819;
var inst_20821 = null;
var inst_20822 = (0);
var inst_20823 = (0);
var state_20943__$1 = (function (){var statearr_21004 = state_20943;
(statearr_21004[(13)] = inst_20822);

(statearr_21004[(15)] = inst_20823);

(statearr_21004[(16)] = inst_20820);

(statearr_21004[(17)] = inst_20821);

return statearr_21004;
})();
var statearr_21005_21070 = state_20943__$1;
(statearr_21005_21070[(2)] = null);

(statearr_21005_21070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (14))){
var state_20943__$1 = state_20943;
var statearr_21006_21071 = state_20943__$1;
(statearr_21006_21071[(2)] = null);

(statearr_21006_21071[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (45))){
var inst_20933 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_21007_21072 = state_20943__$1;
(statearr_21007_21072[(2)] = inst_20933);

(statearr_21007_21072[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (26))){
var inst_20875 = (state_20943[(29)]);
var inst_20929 = (state_20943[(2)]);
var inst_20930 = cljs.core.seq.call(null,inst_20875);
var state_20943__$1 = (function (){var statearr_21008 = state_20943;
(statearr_21008[(31)] = inst_20929);

return statearr_21008;
})();
if(inst_20930){
var statearr_21009_21073 = state_20943__$1;
(statearr_21009_21073[(1)] = (42));

} else {
var statearr_21010_21074 = state_20943__$1;
(statearr_21010_21074[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (16))){
var inst_20842 = (state_20943[(7)]);
var inst_20844 = cljs.core.chunked_seq_QMARK_.call(null,inst_20842);
var state_20943__$1 = state_20943;
if(inst_20844){
var statearr_21011_21075 = state_20943__$1;
(statearr_21011_21075[(1)] = (19));

} else {
var statearr_21012_21076 = state_20943__$1;
(statearr_21012_21076[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (38))){
var inst_20922 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_21013_21077 = state_20943__$1;
(statearr_21013_21077[(2)] = inst_20922);

(statearr_21013_21077[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (30))){
var state_20943__$1 = state_20943;
var statearr_21014_21078 = state_20943__$1;
(statearr_21014_21078[(2)] = null);

(statearr_21014_21078[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (10))){
var inst_20823 = (state_20943[(15)]);
var inst_20821 = (state_20943[(17)]);
var inst_20831 = cljs.core._nth.call(null,inst_20821,inst_20823);
var inst_20832 = cljs.core.nth.call(null,inst_20831,(0),null);
var inst_20833 = cljs.core.nth.call(null,inst_20831,(1),null);
var state_20943__$1 = (function (){var statearr_21015 = state_20943;
(statearr_21015[(26)] = inst_20832);

return statearr_21015;
})();
if(cljs.core.truth_(inst_20833)){
var statearr_21016_21079 = state_20943__$1;
(statearr_21016_21079[(1)] = (13));

} else {
var statearr_21017_21080 = state_20943__$1;
(statearr_21017_21080[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (18))){
var inst_20868 = (state_20943[(2)]);
var state_20943__$1 = state_20943;
var statearr_21018_21081 = state_20943__$1;
(statearr_21018_21081[(2)] = inst_20868);

(statearr_21018_21081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (42))){
var state_20943__$1 = state_20943;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20943__$1,(45),dchan);
} else {
if((state_val_20944 === (37))){
var inst_20911 = (state_20943[(23)]);
var inst_20811 = (state_20943[(9)]);
var inst_20902 = (state_20943[(25)]);
var inst_20911__$1 = cljs.core.first.call(null,inst_20902);
var inst_20912 = cljs.core.async.put_BANG_.call(null,inst_20911__$1,inst_20811,done);
var state_20943__$1 = (function (){var statearr_21019 = state_20943;
(statearr_21019[(23)] = inst_20911__$1);

return statearr_21019;
})();
if(cljs.core.truth_(inst_20912)){
var statearr_21020_21082 = state_20943__$1;
(statearr_21020_21082[(1)] = (39));

} else {
var statearr_21021_21083 = state_20943__$1;
(statearr_21021_21083[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20944 === (8))){
var inst_20822 = (state_20943[(13)]);
var inst_20823 = (state_20943[(15)]);
var inst_20825 = (inst_20823 < inst_20822);
var inst_20826 = inst_20825;
var state_20943__$1 = state_20943;
if(cljs.core.truth_(inst_20826)){
var statearr_21022_21084 = state_20943__$1;
(statearr_21022_21084[(1)] = (10));

} else {
var statearr_21023_21085 = state_20943__$1;
(statearr_21023_21085[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21031,cs,m,dchan,dctr,done))
;
return ((function (switch__19596__auto__,c__19708__auto___21031,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19597__auto__ = null;
var cljs$core$async$mult_$_state_machine__19597__auto____0 = (function (){
var statearr_21027 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21027[(0)] = cljs$core$async$mult_$_state_machine__19597__auto__);

(statearr_21027[(1)] = (1));

return statearr_21027;
});
var cljs$core$async$mult_$_state_machine__19597__auto____1 = (function (state_20943){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_20943);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21028){if((e21028 instanceof Object)){
var ex__19600__auto__ = e21028;
var statearr_21029_21086 = state_20943;
(statearr_21029_21086[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20943);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21028;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21087 = state_20943;
state_20943 = G__21087;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19597__auto__ = function(state_20943){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19597__auto____1.call(this,state_20943);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19597__auto____0;
cljs$core$async$mult_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19597__auto____1;
return cljs$core$async$mult_$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21031,cs,m,dchan,dctr,done))
})();
var state__19710__auto__ = (function (){var statearr_21030 = f__19709__auto__.call(null);
(statearr_21030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21031);

return statearr_21030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21031,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21088 = [];
var len__8005__auto___21091 = arguments.length;
var i__8006__auto___21092 = (0);
while(true){
if((i__8006__auto___21092 < len__8005__auto___21091)){
args21088.push((arguments[i__8006__auto___21092]));

var G__21093 = (i__8006__auto___21092 + (1));
i__8006__auto___21092 = G__21093;
continue;
} else {
}
break;
}

var G__21090 = args21088.length;
switch (G__21090) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21088.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,ch);
} else {
var m__7561__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,ch);
} else {
var m__7561__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m);
} else {
var m__7561__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,state_map);
} else {
var m__7561__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7560__auto__ = (((m == null))?null:m);
var m__7561__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,m,mode);
} else {
var m__7561__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8012__auto__ = [];
var len__8005__auto___21105 = arguments.length;
var i__8006__auto___21106 = (0);
while(true){
if((i__8006__auto___21106 < len__8005__auto___21105)){
args__8012__auto__.push((arguments[i__8006__auto___21106]));

var G__21107 = (i__8006__auto___21106 + (1));
i__8006__auto___21106 = G__21107;
continue;
} else {
}
break;
}

var argseq__8013__auto__ = ((((3) < args__8012__auto__.length))?(new cljs.core.IndexedSeq(args__8012__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8013__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21099){
var map__21100 = p__21099;
var map__21100__$1 = ((((!((map__21100 == null)))?((((map__21100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21100.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21100):map__21100);
var opts = map__21100__$1;
var statearr_21102_21108 = state;
(statearr_21102_21108[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__21100,map__21100__$1,opts){
return (function (val){
var statearr_21103_21109 = state;
(statearr_21103_21109[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21100,map__21100__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_21104_21110 = state;
(statearr_21104_21110[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21095){
var G__21096 = cljs.core.first.call(null,seq21095);
var seq21095__$1 = cljs.core.next.call(null,seq21095);
var G__21097 = cljs.core.first.call(null,seq21095__$1);
var seq21095__$2 = cljs.core.next.call(null,seq21095__$1);
var G__21098 = cljs.core.first.call(null,seq21095__$2);
var seq21095__$3 = cljs.core.next.call(null,seq21095__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21096,G__21097,G__21098,seq21095__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21278 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta21279){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta21279 = meta21279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21280,meta21279__$1){
var self__ = this;
var _21280__$1 = this;
return (new cljs.core.async.t_cljs$core$async21278(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta21279__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21280){
var self__ = this;
var _21280__$1 = this;
return self__.meta21279;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta21279","meta21279",1330155759,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21278.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21278.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21278";

cljs.core.async.t_cljs$core$async21278.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21278");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async21278 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async21278(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta21279){
return (new cljs.core.async.t_cljs$core$async21278(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta21279));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async21278(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19708__auto___21445 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_21382){
var state_val_21383 = (state_21382[(1)]);
if((state_val_21383 === (7))){
var inst_21297 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
var statearr_21384_21446 = state_21382__$1;
(statearr_21384_21446[(2)] = inst_21297);

(statearr_21384_21446[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (20))){
var inst_21309 = (state_21382[(7)]);
var state_21382__$1 = state_21382;
var statearr_21385_21447 = state_21382__$1;
(statearr_21385_21447[(2)] = inst_21309);

(statearr_21385_21447[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (27))){
var state_21382__$1 = state_21382;
var statearr_21386_21448 = state_21382__$1;
(statearr_21386_21448[(2)] = null);

(statearr_21386_21448[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (1))){
var inst_21284 = (state_21382[(8)]);
var inst_21284__$1 = calc_state.call(null);
var inst_21286 = (inst_21284__$1 == null);
var inst_21287 = cljs.core.not.call(null,inst_21286);
var state_21382__$1 = (function (){var statearr_21387 = state_21382;
(statearr_21387[(8)] = inst_21284__$1);

return statearr_21387;
})();
if(inst_21287){
var statearr_21388_21449 = state_21382__$1;
(statearr_21388_21449[(1)] = (2));

} else {
var statearr_21389_21450 = state_21382__$1;
(statearr_21389_21450[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (24))){
var inst_21356 = (state_21382[(9)]);
var inst_21333 = (state_21382[(10)]);
var inst_21342 = (state_21382[(11)]);
var inst_21356__$1 = inst_21333.call(null,inst_21342);
var state_21382__$1 = (function (){var statearr_21390 = state_21382;
(statearr_21390[(9)] = inst_21356__$1);

return statearr_21390;
})();
if(cljs.core.truth_(inst_21356__$1)){
var statearr_21391_21451 = state_21382__$1;
(statearr_21391_21451[(1)] = (29));

} else {
var statearr_21392_21452 = state_21382__$1;
(statearr_21392_21452[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (4))){
var inst_21300 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21300)){
var statearr_21393_21453 = state_21382__$1;
(statearr_21393_21453[(1)] = (8));

} else {
var statearr_21394_21454 = state_21382__$1;
(statearr_21394_21454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (15))){
var inst_21327 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21327)){
var statearr_21395_21455 = state_21382__$1;
(statearr_21395_21455[(1)] = (19));

} else {
var statearr_21396_21456 = state_21382__$1;
(statearr_21396_21456[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (21))){
var inst_21332 = (state_21382[(12)]);
var inst_21332__$1 = (state_21382[(2)]);
var inst_21333 = cljs.core.get.call(null,inst_21332__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21334 = cljs.core.get.call(null,inst_21332__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21335 = cljs.core.get.call(null,inst_21332__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_21382__$1 = (function (){var statearr_21397 = state_21382;
(statearr_21397[(13)] = inst_21334);

(statearr_21397[(10)] = inst_21333);

(statearr_21397[(12)] = inst_21332__$1);

return statearr_21397;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21382__$1,(22),inst_21335);
} else {
if((state_val_21383 === (31))){
var inst_21364 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21364)){
var statearr_21398_21457 = state_21382__$1;
(statearr_21398_21457[(1)] = (32));

} else {
var statearr_21399_21458 = state_21382__$1;
(statearr_21399_21458[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (32))){
var inst_21341 = (state_21382[(14)]);
var state_21382__$1 = state_21382;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21382__$1,(35),out,inst_21341);
} else {
if((state_val_21383 === (33))){
var inst_21332 = (state_21382[(12)]);
var inst_21309 = inst_21332;
var state_21382__$1 = (function (){var statearr_21400 = state_21382;
(statearr_21400[(7)] = inst_21309);

return statearr_21400;
})();
var statearr_21401_21459 = state_21382__$1;
(statearr_21401_21459[(2)] = null);

(statearr_21401_21459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (13))){
var inst_21309 = (state_21382[(7)]);
var inst_21316 = inst_21309.cljs$lang$protocol_mask$partition0$;
var inst_21317 = (inst_21316 & (64));
var inst_21318 = inst_21309.cljs$core$ISeq$;
var inst_21319 = (cljs.core.PROTOCOL_SENTINEL === inst_21318);
var inst_21320 = (inst_21317) || (inst_21319);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21320)){
var statearr_21402_21460 = state_21382__$1;
(statearr_21402_21460[(1)] = (16));

} else {
var statearr_21403_21461 = state_21382__$1;
(statearr_21403_21461[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (22))){
var inst_21342 = (state_21382[(11)]);
var inst_21341 = (state_21382[(14)]);
var inst_21340 = (state_21382[(2)]);
var inst_21341__$1 = cljs.core.nth.call(null,inst_21340,(0),null);
var inst_21342__$1 = cljs.core.nth.call(null,inst_21340,(1),null);
var inst_21343 = (inst_21341__$1 == null);
var inst_21344 = cljs.core._EQ_.call(null,inst_21342__$1,change);
var inst_21345 = (inst_21343) || (inst_21344);
var state_21382__$1 = (function (){var statearr_21404 = state_21382;
(statearr_21404[(11)] = inst_21342__$1);

(statearr_21404[(14)] = inst_21341__$1);

return statearr_21404;
})();
if(cljs.core.truth_(inst_21345)){
var statearr_21405_21462 = state_21382__$1;
(statearr_21405_21462[(1)] = (23));

} else {
var statearr_21406_21463 = state_21382__$1;
(statearr_21406_21463[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (36))){
var inst_21332 = (state_21382[(12)]);
var inst_21309 = inst_21332;
var state_21382__$1 = (function (){var statearr_21407 = state_21382;
(statearr_21407[(7)] = inst_21309);

return statearr_21407;
})();
var statearr_21408_21464 = state_21382__$1;
(statearr_21408_21464[(2)] = null);

(statearr_21408_21464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (29))){
var inst_21356 = (state_21382[(9)]);
var state_21382__$1 = state_21382;
var statearr_21409_21465 = state_21382__$1;
(statearr_21409_21465[(2)] = inst_21356);

(statearr_21409_21465[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (6))){
var state_21382__$1 = state_21382;
var statearr_21410_21466 = state_21382__$1;
(statearr_21410_21466[(2)] = false);

(statearr_21410_21466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (28))){
var inst_21352 = (state_21382[(2)]);
var inst_21353 = calc_state.call(null);
var inst_21309 = inst_21353;
var state_21382__$1 = (function (){var statearr_21411 = state_21382;
(statearr_21411[(15)] = inst_21352);

(statearr_21411[(7)] = inst_21309);

return statearr_21411;
})();
var statearr_21412_21467 = state_21382__$1;
(statearr_21412_21467[(2)] = null);

(statearr_21412_21467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (25))){
var inst_21378 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
var statearr_21413_21468 = state_21382__$1;
(statearr_21413_21468[(2)] = inst_21378);

(statearr_21413_21468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (34))){
var inst_21376 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
var statearr_21414_21469 = state_21382__$1;
(statearr_21414_21469[(2)] = inst_21376);

(statearr_21414_21469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (17))){
var state_21382__$1 = state_21382;
var statearr_21415_21470 = state_21382__$1;
(statearr_21415_21470[(2)] = false);

(statearr_21415_21470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (3))){
var state_21382__$1 = state_21382;
var statearr_21416_21471 = state_21382__$1;
(statearr_21416_21471[(2)] = false);

(statearr_21416_21471[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (12))){
var inst_21380 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21382__$1,inst_21380);
} else {
if((state_val_21383 === (2))){
var inst_21284 = (state_21382[(8)]);
var inst_21289 = inst_21284.cljs$lang$protocol_mask$partition0$;
var inst_21290 = (inst_21289 & (64));
var inst_21291 = inst_21284.cljs$core$ISeq$;
var inst_21292 = (cljs.core.PROTOCOL_SENTINEL === inst_21291);
var inst_21293 = (inst_21290) || (inst_21292);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21293)){
var statearr_21417_21472 = state_21382__$1;
(statearr_21417_21472[(1)] = (5));

} else {
var statearr_21418_21473 = state_21382__$1;
(statearr_21418_21473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (23))){
var inst_21341 = (state_21382[(14)]);
var inst_21347 = (inst_21341 == null);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21347)){
var statearr_21419_21474 = state_21382__$1;
(statearr_21419_21474[(1)] = (26));

} else {
var statearr_21420_21475 = state_21382__$1;
(statearr_21420_21475[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (35))){
var inst_21367 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
if(cljs.core.truth_(inst_21367)){
var statearr_21421_21476 = state_21382__$1;
(statearr_21421_21476[(1)] = (36));

} else {
var statearr_21422_21477 = state_21382__$1;
(statearr_21422_21477[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (19))){
var inst_21309 = (state_21382[(7)]);
var inst_21329 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21309);
var state_21382__$1 = state_21382;
var statearr_21423_21478 = state_21382__$1;
(statearr_21423_21478[(2)] = inst_21329);

(statearr_21423_21478[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (11))){
var inst_21309 = (state_21382[(7)]);
var inst_21313 = (inst_21309 == null);
var inst_21314 = cljs.core.not.call(null,inst_21313);
var state_21382__$1 = state_21382;
if(inst_21314){
var statearr_21424_21479 = state_21382__$1;
(statearr_21424_21479[(1)] = (13));

} else {
var statearr_21425_21480 = state_21382__$1;
(statearr_21425_21480[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (9))){
var inst_21284 = (state_21382[(8)]);
var state_21382__$1 = state_21382;
var statearr_21426_21481 = state_21382__$1;
(statearr_21426_21481[(2)] = inst_21284);

(statearr_21426_21481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (5))){
var state_21382__$1 = state_21382;
var statearr_21427_21482 = state_21382__$1;
(statearr_21427_21482[(2)] = true);

(statearr_21427_21482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (14))){
var state_21382__$1 = state_21382;
var statearr_21428_21483 = state_21382__$1;
(statearr_21428_21483[(2)] = false);

(statearr_21428_21483[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (26))){
var inst_21342 = (state_21382[(11)]);
var inst_21349 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_21342);
var state_21382__$1 = state_21382;
var statearr_21429_21484 = state_21382__$1;
(statearr_21429_21484[(2)] = inst_21349);

(statearr_21429_21484[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (16))){
var state_21382__$1 = state_21382;
var statearr_21430_21485 = state_21382__$1;
(statearr_21430_21485[(2)] = true);

(statearr_21430_21485[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (38))){
var inst_21372 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
var statearr_21431_21486 = state_21382__$1;
(statearr_21431_21486[(2)] = inst_21372);

(statearr_21431_21486[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (30))){
var inst_21334 = (state_21382[(13)]);
var inst_21333 = (state_21382[(10)]);
var inst_21342 = (state_21382[(11)]);
var inst_21359 = cljs.core.empty_QMARK_.call(null,inst_21333);
var inst_21360 = inst_21334.call(null,inst_21342);
var inst_21361 = cljs.core.not.call(null,inst_21360);
var inst_21362 = (inst_21359) && (inst_21361);
var state_21382__$1 = state_21382;
var statearr_21432_21487 = state_21382__$1;
(statearr_21432_21487[(2)] = inst_21362);

(statearr_21432_21487[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (10))){
var inst_21284 = (state_21382[(8)]);
var inst_21305 = (state_21382[(2)]);
var inst_21306 = cljs.core.get.call(null,inst_21305,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21307 = cljs.core.get.call(null,inst_21305,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21308 = cljs.core.get.call(null,inst_21305,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_21309 = inst_21284;
var state_21382__$1 = (function (){var statearr_21433 = state_21382;
(statearr_21433[(16)] = inst_21307);

(statearr_21433[(7)] = inst_21309);

(statearr_21433[(17)] = inst_21308);

(statearr_21433[(18)] = inst_21306);

return statearr_21433;
})();
var statearr_21434_21488 = state_21382__$1;
(statearr_21434_21488[(2)] = null);

(statearr_21434_21488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (18))){
var inst_21324 = (state_21382[(2)]);
var state_21382__$1 = state_21382;
var statearr_21435_21489 = state_21382__$1;
(statearr_21435_21489[(2)] = inst_21324);

(statearr_21435_21489[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (37))){
var state_21382__$1 = state_21382;
var statearr_21436_21490 = state_21382__$1;
(statearr_21436_21490[(2)] = null);

(statearr_21436_21490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21383 === (8))){
var inst_21284 = (state_21382[(8)]);
var inst_21302 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21284);
var state_21382__$1 = state_21382;
var statearr_21437_21491 = state_21382__$1;
(statearr_21437_21491[(2)] = inst_21302);

(statearr_21437_21491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19596__auto__,c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19597__auto__ = null;
var cljs$core$async$mix_$_state_machine__19597__auto____0 = (function (){
var statearr_21441 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21441[(0)] = cljs$core$async$mix_$_state_machine__19597__auto__);

(statearr_21441[(1)] = (1));

return statearr_21441;
});
var cljs$core$async$mix_$_state_machine__19597__auto____1 = (function (state_21382){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21442){if((e21442 instanceof Object)){
var ex__19600__auto__ = e21442;
var statearr_21443_21492 = state_21382;
(statearr_21443_21492[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21382);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21442;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21493 = state_21382;
state_21382 = G__21493;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19597__auto__ = function(state_21382){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19597__auto____1.call(this,state_21382);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19597__auto____0;
cljs$core$async$mix_$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19597__auto____1;
return cljs$core$async$mix_$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19710__auto__ = (function (){var statearr_21444 = f__19709__auto__.call(null);
(statearr_21444[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21445);

return statearr_21444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21445,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7560__auto__ = (((p == null))?null:p);
var m__7561__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7561__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7560__auto__ = (((p == null))?null:p);
var m__7561__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,p,v,ch);
} else {
var m__7561__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args21494 = [];
var len__8005__auto___21497 = arguments.length;
var i__8006__auto___21498 = (0);
while(true){
if((i__8006__auto___21498 < len__8005__auto___21497)){
args21494.push((arguments[i__8006__auto___21498]));

var G__21499 = (i__8006__auto___21498 + (1));
i__8006__auto___21498 = G__21499;
continue;
} else {
}
break;
}

var G__21496 = args21494.length;
switch (G__21496) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21494.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7560__auto__ = (((p == null))?null:p);
var m__7561__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,p);
} else {
var m__7561__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7560__auto__ = (((p == null))?null:p);
var m__7561__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7560__auto__)]);
if(!((m__7561__auto__ == null))){
return m__7561__auto__.call(null,p,v);
} else {
var m__7561__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7561__auto____$1 == null))){
return m__7561__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args21502 = [];
var len__8005__auto___21627 = arguments.length;
var i__8006__auto___21628 = (0);
while(true){
if((i__8006__auto___21628 < len__8005__auto___21627)){
args21502.push((arguments[i__8006__auto___21628]));

var G__21629 = (i__8006__auto___21628 + (1));
i__8006__auto___21628 = G__21629;
continue;
} else {
}
break;
}

var G__21504 = args21502.length;
switch (G__21504) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21502.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6892__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6892__auto__)){
return or__6892__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6892__auto__,mults){
return (function (p1__21501_SHARP_){
if(cljs.core.truth_(p1__21501_SHARP_.call(null,topic))){
return p1__21501_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__21501_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6892__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async21505 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21505 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta21506){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta21506 = meta21506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_21507,meta21506__$1){
var self__ = this;
var _21507__$1 = this;
return (new cljs.core.async.t_cljs$core$async21505(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta21506__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_21507){
var self__ = this;
var _21507__$1 = this;
return self__.meta21506;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta21506","meta21506",-230423745,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async21505.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21505";

cljs.core.async.t_cljs$core$async21505.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21505");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async21505 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async21505(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21506){
return (new cljs.core.async.t_cljs$core$async21505(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21506));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async21505(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19708__auto___21631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21631,mults,ensure_mult,p){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21631,mults,ensure_mult,p){
return (function (state_21579){
var state_val_21580 = (state_21579[(1)]);
if((state_val_21580 === (7))){
var inst_21575 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21581_21632 = state_21579__$1;
(statearr_21581_21632[(2)] = inst_21575);

(statearr_21581_21632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (20))){
var state_21579__$1 = state_21579;
var statearr_21582_21633 = state_21579__$1;
(statearr_21582_21633[(2)] = null);

(statearr_21582_21633[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (1))){
var state_21579__$1 = state_21579;
var statearr_21583_21634 = state_21579__$1;
(statearr_21583_21634[(2)] = null);

(statearr_21583_21634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (24))){
var inst_21558 = (state_21579[(7)]);
var inst_21567 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_21558);
var state_21579__$1 = state_21579;
var statearr_21584_21635 = state_21579__$1;
(statearr_21584_21635[(2)] = inst_21567);

(statearr_21584_21635[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (4))){
var inst_21510 = (state_21579[(8)]);
var inst_21510__$1 = (state_21579[(2)]);
var inst_21511 = (inst_21510__$1 == null);
var state_21579__$1 = (function (){var statearr_21585 = state_21579;
(statearr_21585[(8)] = inst_21510__$1);

return statearr_21585;
})();
if(cljs.core.truth_(inst_21511)){
var statearr_21586_21636 = state_21579__$1;
(statearr_21586_21636[(1)] = (5));

} else {
var statearr_21587_21637 = state_21579__$1;
(statearr_21587_21637[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (15))){
var inst_21552 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21588_21638 = state_21579__$1;
(statearr_21588_21638[(2)] = inst_21552);

(statearr_21588_21638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (21))){
var inst_21572 = (state_21579[(2)]);
var state_21579__$1 = (function (){var statearr_21589 = state_21579;
(statearr_21589[(9)] = inst_21572);

return statearr_21589;
})();
var statearr_21590_21639 = state_21579__$1;
(statearr_21590_21639[(2)] = null);

(statearr_21590_21639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (13))){
var inst_21534 = (state_21579[(10)]);
var inst_21536 = cljs.core.chunked_seq_QMARK_.call(null,inst_21534);
var state_21579__$1 = state_21579;
if(inst_21536){
var statearr_21591_21640 = state_21579__$1;
(statearr_21591_21640[(1)] = (16));

} else {
var statearr_21592_21641 = state_21579__$1;
(statearr_21592_21641[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (22))){
var inst_21564 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
if(cljs.core.truth_(inst_21564)){
var statearr_21593_21642 = state_21579__$1;
(statearr_21593_21642[(1)] = (23));

} else {
var statearr_21594_21643 = state_21579__$1;
(statearr_21594_21643[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (6))){
var inst_21560 = (state_21579[(11)]);
var inst_21558 = (state_21579[(7)]);
var inst_21510 = (state_21579[(8)]);
var inst_21558__$1 = topic_fn.call(null,inst_21510);
var inst_21559 = cljs.core.deref.call(null,mults);
var inst_21560__$1 = cljs.core.get.call(null,inst_21559,inst_21558__$1);
var state_21579__$1 = (function (){var statearr_21595 = state_21579;
(statearr_21595[(11)] = inst_21560__$1);

(statearr_21595[(7)] = inst_21558__$1);

return statearr_21595;
})();
if(cljs.core.truth_(inst_21560__$1)){
var statearr_21596_21644 = state_21579__$1;
(statearr_21596_21644[(1)] = (19));

} else {
var statearr_21597_21645 = state_21579__$1;
(statearr_21597_21645[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (25))){
var inst_21569 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21598_21646 = state_21579__$1;
(statearr_21598_21646[(2)] = inst_21569);

(statearr_21598_21646[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (17))){
var inst_21534 = (state_21579[(10)]);
var inst_21543 = cljs.core.first.call(null,inst_21534);
var inst_21544 = cljs.core.async.muxch_STAR_.call(null,inst_21543);
var inst_21545 = cljs.core.async.close_BANG_.call(null,inst_21544);
var inst_21546 = cljs.core.next.call(null,inst_21534);
var inst_21520 = inst_21546;
var inst_21521 = null;
var inst_21522 = (0);
var inst_21523 = (0);
var state_21579__$1 = (function (){var statearr_21599 = state_21579;
(statearr_21599[(12)] = inst_21545);

(statearr_21599[(13)] = inst_21520);

(statearr_21599[(14)] = inst_21523);

(statearr_21599[(15)] = inst_21521);

(statearr_21599[(16)] = inst_21522);

return statearr_21599;
})();
var statearr_21600_21647 = state_21579__$1;
(statearr_21600_21647[(2)] = null);

(statearr_21600_21647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (3))){
var inst_21577 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21579__$1,inst_21577);
} else {
if((state_val_21580 === (12))){
var inst_21554 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21601_21648 = state_21579__$1;
(statearr_21601_21648[(2)] = inst_21554);

(statearr_21601_21648[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (2))){
var state_21579__$1 = state_21579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21579__$1,(4),ch);
} else {
if((state_val_21580 === (23))){
var state_21579__$1 = state_21579;
var statearr_21602_21649 = state_21579__$1;
(statearr_21602_21649[(2)] = null);

(statearr_21602_21649[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (19))){
var inst_21560 = (state_21579[(11)]);
var inst_21510 = (state_21579[(8)]);
var inst_21562 = cljs.core.async.muxch_STAR_.call(null,inst_21560);
var state_21579__$1 = state_21579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21579__$1,(22),inst_21562,inst_21510);
} else {
if((state_val_21580 === (11))){
var inst_21520 = (state_21579[(13)]);
var inst_21534 = (state_21579[(10)]);
var inst_21534__$1 = cljs.core.seq.call(null,inst_21520);
var state_21579__$1 = (function (){var statearr_21603 = state_21579;
(statearr_21603[(10)] = inst_21534__$1);

return statearr_21603;
})();
if(inst_21534__$1){
var statearr_21604_21650 = state_21579__$1;
(statearr_21604_21650[(1)] = (13));

} else {
var statearr_21605_21651 = state_21579__$1;
(statearr_21605_21651[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (9))){
var inst_21556 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21606_21652 = state_21579__$1;
(statearr_21606_21652[(2)] = inst_21556);

(statearr_21606_21652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (5))){
var inst_21517 = cljs.core.deref.call(null,mults);
var inst_21518 = cljs.core.vals.call(null,inst_21517);
var inst_21519 = cljs.core.seq.call(null,inst_21518);
var inst_21520 = inst_21519;
var inst_21521 = null;
var inst_21522 = (0);
var inst_21523 = (0);
var state_21579__$1 = (function (){var statearr_21607 = state_21579;
(statearr_21607[(13)] = inst_21520);

(statearr_21607[(14)] = inst_21523);

(statearr_21607[(15)] = inst_21521);

(statearr_21607[(16)] = inst_21522);

return statearr_21607;
})();
var statearr_21608_21653 = state_21579__$1;
(statearr_21608_21653[(2)] = null);

(statearr_21608_21653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (14))){
var state_21579__$1 = state_21579;
var statearr_21612_21654 = state_21579__$1;
(statearr_21612_21654[(2)] = null);

(statearr_21612_21654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (16))){
var inst_21534 = (state_21579[(10)]);
var inst_21538 = cljs.core.chunk_first.call(null,inst_21534);
var inst_21539 = cljs.core.chunk_rest.call(null,inst_21534);
var inst_21540 = cljs.core.count.call(null,inst_21538);
var inst_21520 = inst_21539;
var inst_21521 = inst_21538;
var inst_21522 = inst_21540;
var inst_21523 = (0);
var state_21579__$1 = (function (){var statearr_21613 = state_21579;
(statearr_21613[(13)] = inst_21520);

(statearr_21613[(14)] = inst_21523);

(statearr_21613[(15)] = inst_21521);

(statearr_21613[(16)] = inst_21522);

return statearr_21613;
})();
var statearr_21614_21655 = state_21579__$1;
(statearr_21614_21655[(2)] = null);

(statearr_21614_21655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (10))){
var inst_21520 = (state_21579[(13)]);
var inst_21523 = (state_21579[(14)]);
var inst_21521 = (state_21579[(15)]);
var inst_21522 = (state_21579[(16)]);
var inst_21528 = cljs.core._nth.call(null,inst_21521,inst_21523);
var inst_21529 = cljs.core.async.muxch_STAR_.call(null,inst_21528);
var inst_21530 = cljs.core.async.close_BANG_.call(null,inst_21529);
var inst_21531 = (inst_21523 + (1));
var tmp21609 = inst_21520;
var tmp21610 = inst_21521;
var tmp21611 = inst_21522;
var inst_21520__$1 = tmp21609;
var inst_21521__$1 = tmp21610;
var inst_21522__$1 = tmp21611;
var inst_21523__$1 = inst_21531;
var state_21579__$1 = (function (){var statearr_21615 = state_21579;
(statearr_21615[(17)] = inst_21530);

(statearr_21615[(13)] = inst_21520__$1);

(statearr_21615[(14)] = inst_21523__$1);

(statearr_21615[(15)] = inst_21521__$1);

(statearr_21615[(16)] = inst_21522__$1);

return statearr_21615;
})();
var statearr_21616_21656 = state_21579__$1;
(statearr_21616_21656[(2)] = null);

(statearr_21616_21656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (18))){
var inst_21549 = (state_21579[(2)]);
var state_21579__$1 = state_21579;
var statearr_21617_21657 = state_21579__$1;
(statearr_21617_21657[(2)] = inst_21549);

(statearr_21617_21657[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21580 === (8))){
var inst_21523 = (state_21579[(14)]);
var inst_21522 = (state_21579[(16)]);
var inst_21525 = (inst_21523 < inst_21522);
var inst_21526 = inst_21525;
var state_21579__$1 = state_21579;
if(cljs.core.truth_(inst_21526)){
var statearr_21618_21658 = state_21579__$1;
(statearr_21618_21658[(1)] = (10));

} else {
var statearr_21619_21659 = state_21579__$1;
(statearr_21619_21659[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21631,mults,ensure_mult,p))
;
return ((function (switch__19596__auto__,c__19708__auto___21631,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_21623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21623[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_21623[(1)] = (1));

return statearr_21623;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_21579){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21624){if((e21624 instanceof Object)){
var ex__19600__auto__ = e21624;
var statearr_21625_21660 = state_21579;
(statearr_21625_21660[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21661 = state_21579;
state_21579 = G__21661;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_21579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_21579);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21631,mults,ensure_mult,p))
})();
var state__19710__auto__ = (function (){var statearr_21626 = f__19709__auto__.call(null);
(statearr_21626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21631);

return statearr_21626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21631,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args21662 = [];
var len__8005__auto___21665 = arguments.length;
var i__8006__auto___21666 = (0);
while(true){
if((i__8006__auto___21666 < len__8005__auto___21665)){
args21662.push((arguments[i__8006__auto___21666]));

var G__21667 = (i__8006__auto___21666 + (1));
i__8006__auto___21666 = G__21667;
continue;
} else {
}
break;
}

var G__21664 = args21662.length;
switch (G__21664) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21662.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args21669 = [];
var len__8005__auto___21672 = arguments.length;
var i__8006__auto___21673 = (0);
while(true){
if((i__8006__auto___21673 < len__8005__auto___21672)){
args21669.push((arguments[i__8006__auto___21673]));

var G__21674 = (i__8006__auto___21673 + (1));
i__8006__auto___21673 = G__21674;
continue;
} else {
}
break;
}

var G__21671 = args21669.length;
switch (G__21671) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21669.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args21676 = [];
var len__8005__auto___21747 = arguments.length;
var i__8006__auto___21748 = (0);
while(true){
if((i__8006__auto___21748 < len__8005__auto___21747)){
args21676.push((arguments[i__8006__auto___21748]));

var G__21749 = (i__8006__auto___21748 + (1));
i__8006__auto___21748 = G__21749;
continue;
} else {
}
break;
}

var G__21678 = args21676.length;
switch (G__21678) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21676.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__19708__auto___21751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_21717){
var state_val_21718 = (state_21717[(1)]);
if((state_val_21718 === (7))){
var state_21717__$1 = state_21717;
var statearr_21719_21752 = state_21717__$1;
(statearr_21719_21752[(2)] = null);

(statearr_21719_21752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (1))){
var state_21717__$1 = state_21717;
var statearr_21720_21753 = state_21717__$1;
(statearr_21720_21753[(2)] = null);

(statearr_21720_21753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (4))){
var inst_21681 = (state_21717[(7)]);
var inst_21683 = (inst_21681 < cnt);
var state_21717__$1 = state_21717;
if(cljs.core.truth_(inst_21683)){
var statearr_21721_21754 = state_21717__$1;
(statearr_21721_21754[(1)] = (6));

} else {
var statearr_21722_21755 = state_21717__$1;
(statearr_21722_21755[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (15))){
var inst_21713 = (state_21717[(2)]);
var state_21717__$1 = state_21717;
var statearr_21723_21756 = state_21717__$1;
(statearr_21723_21756[(2)] = inst_21713);

(statearr_21723_21756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (13))){
var inst_21706 = cljs.core.async.close_BANG_.call(null,out);
var state_21717__$1 = state_21717;
var statearr_21724_21757 = state_21717__$1;
(statearr_21724_21757[(2)] = inst_21706);

(statearr_21724_21757[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (6))){
var state_21717__$1 = state_21717;
var statearr_21725_21758 = state_21717__$1;
(statearr_21725_21758[(2)] = null);

(statearr_21725_21758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (3))){
var inst_21715 = (state_21717[(2)]);
var state_21717__$1 = state_21717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21717__$1,inst_21715);
} else {
if((state_val_21718 === (12))){
var inst_21703 = (state_21717[(8)]);
var inst_21703__$1 = (state_21717[(2)]);
var inst_21704 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_21703__$1);
var state_21717__$1 = (function (){var statearr_21726 = state_21717;
(statearr_21726[(8)] = inst_21703__$1);

return statearr_21726;
})();
if(cljs.core.truth_(inst_21704)){
var statearr_21727_21759 = state_21717__$1;
(statearr_21727_21759[(1)] = (13));

} else {
var statearr_21728_21760 = state_21717__$1;
(statearr_21728_21760[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (2))){
var inst_21680 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_21681 = (0);
var state_21717__$1 = (function (){var statearr_21729 = state_21717;
(statearr_21729[(7)] = inst_21681);

(statearr_21729[(9)] = inst_21680);

return statearr_21729;
})();
var statearr_21730_21761 = state_21717__$1;
(statearr_21730_21761[(2)] = null);

(statearr_21730_21761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (11))){
var inst_21681 = (state_21717[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_21717,(10),Object,null,(9));
var inst_21690 = chs__$1.call(null,inst_21681);
var inst_21691 = done.call(null,inst_21681);
var inst_21692 = cljs.core.async.take_BANG_.call(null,inst_21690,inst_21691);
var state_21717__$1 = state_21717;
var statearr_21731_21762 = state_21717__$1;
(statearr_21731_21762[(2)] = inst_21692);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21717__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (9))){
var inst_21681 = (state_21717[(7)]);
var inst_21694 = (state_21717[(2)]);
var inst_21695 = (inst_21681 + (1));
var inst_21681__$1 = inst_21695;
var state_21717__$1 = (function (){var statearr_21732 = state_21717;
(statearr_21732[(10)] = inst_21694);

(statearr_21732[(7)] = inst_21681__$1);

return statearr_21732;
})();
var statearr_21733_21763 = state_21717__$1;
(statearr_21733_21763[(2)] = null);

(statearr_21733_21763[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (5))){
var inst_21701 = (state_21717[(2)]);
var state_21717__$1 = (function (){var statearr_21734 = state_21717;
(statearr_21734[(11)] = inst_21701);

return statearr_21734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21717__$1,(12),dchan);
} else {
if((state_val_21718 === (14))){
var inst_21703 = (state_21717[(8)]);
var inst_21708 = cljs.core.apply.call(null,f,inst_21703);
var state_21717__$1 = state_21717;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21717__$1,(16),out,inst_21708);
} else {
if((state_val_21718 === (16))){
var inst_21710 = (state_21717[(2)]);
var state_21717__$1 = (function (){var statearr_21735 = state_21717;
(statearr_21735[(12)] = inst_21710);

return statearr_21735;
})();
var statearr_21736_21764 = state_21717__$1;
(statearr_21736_21764[(2)] = null);

(statearr_21736_21764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (10))){
var inst_21685 = (state_21717[(2)]);
var inst_21686 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_21717__$1 = (function (){var statearr_21737 = state_21717;
(statearr_21737[(13)] = inst_21685);

return statearr_21737;
})();
var statearr_21738_21765 = state_21717__$1;
(statearr_21738_21765[(2)] = inst_21686);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21717__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21718 === (8))){
var inst_21699 = (state_21717[(2)]);
var state_21717__$1 = state_21717;
var statearr_21739_21766 = state_21717__$1;
(statearr_21739_21766[(2)] = inst_21699);

(statearr_21739_21766[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19596__auto__,c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_21743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21743[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_21743[(1)] = (1));

return statearr_21743;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_21717){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21744){if((e21744 instanceof Object)){
var ex__19600__auto__ = e21744;
var statearr_21745_21767 = state_21717;
(statearr_21745_21767[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21717);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21744;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21768 = state_21717;
state_21717 = G__21768;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_21717){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_21717);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19710__auto__ = (function (){var statearr_21746 = f__19709__auto__.call(null);
(statearr_21746[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21751);

return statearr_21746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21751,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args21770 = [];
var len__8005__auto___21828 = arguments.length;
var i__8006__auto___21829 = (0);
while(true){
if((i__8006__auto___21829 < len__8005__auto___21828)){
args21770.push((arguments[i__8006__auto___21829]));

var G__21830 = (i__8006__auto___21829 + (1));
i__8006__auto___21829 = G__21830;
continue;
} else {
}
break;
}

var G__21772 = args21770.length;
switch (G__21772) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21770.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___21832 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21832,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21832,out){
return (function (state_21804){
var state_val_21805 = (state_21804[(1)]);
if((state_val_21805 === (7))){
var inst_21784 = (state_21804[(7)]);
var inst_21783 = (state_21804[(8)]);
var inst_21783__$1 = (state_21804[(2)]);
var inst_21784__$1 = cljs.core.nth.call(null,inst_21783__$1,(0),null);
var inst_21785 = cljs.core.nth.call(null,inst_21783__$1,(1),null);
var inst_21786 = (inst_21784__$1 == null);
var state_21804__$1 = (function (){var statearr_21806 = state_21804;
(statearr_21806[(7)] = inst_21784__$1);

(statearr_21806[(9)] = inst_21785);

(statearr_21806[(8)] = inst_21783__$1);

return statearr_21806;
})();
if(cljs.core.truth_(inst_21786)){
var statearr_21807_21833 = state_21804__$1;
(statearr_21807_21833[(1)] = (8));

} else {
var statearr_21808_21834 = state_21804__$1;
(statearr_21808_21834[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (1))){
var inst_21773 = cljs.core.vec.call(null,chs);
var inst_21774 = inst_21773;
var state_21804__$1 = (function (){var statearr_21809 = state_21804;
(statearr_21809[(10)] = inst_21774);

return statearr_21809;
})();
var statearr_21810_21835 = state_21804__$1;
(statearr_21810_21835[(2)] = null);

(statearr_21810_21835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (4))){
var inst_21774 = (state_21804[(10)]);
var state_21804__$1 = state_21804;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21804__$1,(7),inst_21774);
} else {
if((state_val_21805 === (6))){
var inst_21800 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21811_21836 = state_21804__$1;
(statearr_21811_21836[(2)] = inst_21800);

(statearr_21811_21836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (3))){
var inst_21802 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21804__$1,inst_21802);
} else {
if((state_val_21805 === (2))){
var inst_21774 = (state_21804[(10)]);
var inst_21776 = cljs.core.count.call(null,inst_21774);
var inst_21777 = (inst_21776 > (0));
var state_21804__$1 = state_21804;
if(cljs.core.truth_(inst_21777)){
var statearr_21813_21837 = state_21804__$1;
(statearr_21813_21837[(1)] = (4));

} else {
var statearr_21814_21838 = state_21804__$1;
(statearr_21814_21838[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (11))){
var inst_21774 = (state_21804[(10)]);
var inst_21793 = (state_21804[(2)]);
var tmp21812 = inst_21774;
var inst_21774__$1 = tmp21812;
var state_21804__$1 = (function (){var statearr_21815 = state_21804;
(statearr_21815[(11)] = inst_21793);

(statearr_21815[(10)] = inst_21774__$1);

return statearr_21815;
})();
var statearr_21816_21839 = state_21804__$1;
(statearr_21816_21839[(2)] = null);

(statearr_21816_21839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (9))){
var inst_21784 = (state_21804[(7)]);
var state_21804__$1 = state_21804;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21804__$1,(11),out,inst_21784);
} else {
if((state_val_21805 === (5))){
var inst_21798 = cljs.core.async.close_BANG_.call(null,out);
var state_21804__$1 = state_21804;
var statearr_21817_21840 = state_21804__$1;
(statearr_21817_21840[(2)] = inst_21798);

(statearr_21817_21840[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (10))){
var inst_21796 = (state_21804[(2)]);
var state_21804__$1 = state_21804;
var statearr_21818_21841 = state_21804__$1;
(statearr_21818_21841[(2)] = inst_21796);

(statearr_21818_21841[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21805 === (8))){
var inst_21784 = (state_21804[(7)]);
var inst_21774 = (state_21804[(10)]);
var inst_21785 = (state_21804[(9)]);
var inst_21783 = (state_21804[(8)]);
var inst_21788 = (function (){var cs = inst_21774;
var vec__21779 = inst_21783;
var v = inst_21784;
var c = inst_21785;
return ((function (cs,vec__21779,v,c,inst_21784,inst_21774,inst_21785,inst_21783,state_val_21805,c__19708__auto___21832,out){
return (function (p1__21769_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__21769_SHARP_);
});
;})(cs,vec__21779,v,c,inst_21784,inst_21774,inst_21785,inst_21783,state_val_21805,c__19708__auto___21832,out))
})();
var inst_21789 = cljs.core.filterv.call(null,inst_21788,inst_21774);
var inst_21774__$1 = inst_21789;
var state_21804__$1 = (function (){var statearr_21819 = state_21804;
(statearr_21819[(10)] = inst_21774__$1);

return statearr_21819;
})();
var statearr_21820_21842 = state_21804__$1;
(statearr_21820_21842[(2)] = null);

(statearr_21820_21842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21832,out))
;
return ((function (switch__19596__auto__,c__19708__auto___21832,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_21824 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21824[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_21824[(1)] = (1));

return statearr_21824;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_21804){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21804);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21825){if((e21825 instanceof Object)){
var ex__19600__auto__ = e21825;
var statearr_21826_21843 = state_21804;
(statearr_21826_21843[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21804);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21844 = state_21804;
state_21804 = G__21844;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_21804){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_21804);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21832,out))
})();
var state__19710__auto__ = (function (){var statearr_21827 = f__19709__auto__.call(null);
(statearr_21827[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21832);

return statearr_21827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21832,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21845 = [];
var len__8005__auto___21894 = arguments.length;
var i__8006__auto___21895 = (0);
while(true){
if((i__8006__auto___21895 < len__8005__auto___21894)){
args21845.push((arguments[i__8006__auto___21895]));

var G__21896 = (i__8006__auto___21895 + (1));
i__8006__auto___21895 = G__21896;
continue;
} else {
}
break;
}

var G__21847 = args21845.length;
switch (G__21847) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21845.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___21898 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21898,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21898,out){
return (function (state_21871){
var state_val_21872 = (state_21871[(1)]);
if((state_val_21872 === (7))){
var inst_21853 = (state_21871[(7)]);
var inst_21853__$1 = (state_21871[(2)]);
var inst_21854 = (inst_21853__$1 == null);
var inst_21855 = cljs.core.not.call(null,inst_21854);
var state_21871__$1 = (function (){var statearr_21873 = state_21871;
(statearr_21873[(7)] = inst_21853__$1);

return statearr_21873;
})();
if(inst_21855){
var statearr_21874_21899 = state_21871__$1;
(statearr_21874_21899[(1)] = (8));

} else {
var statearr_21875_21900 = state_21871__$1;
(statearr_21875_21900[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (1))){
var inst_21848 = (0);
var state_21871__$1 = (function (){var statearr_21876 = state_21871;
(statearr_21876[(8)] = inst_21848);

return statearr_21876;
})();
var statearr_21877_21901 = state_21871__$1;
(statearr_21877_21901[(2)] = null);

(statearr_21877_21901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (4))){
var state_21871__$1 = state_21871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21871__$1,(7),ch);
} else {
if((state_val_21872 === (6))){
var inst_21866 = (state_21871[(2)]);
var state_21871__$1 = state_21871;
var statearr_21878_21902 = state_21871__$1;
(statearr_21878_21902[(2)] = inst_21866);

(statearr_21878_21902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (3))){
var inst_21868 = (state_21871[(2)]);
var inst_21869 = cljs.core.async.close_BANG_.call(null,out);
var state_21871__$1 = (function (){var statearr_21879 = state_21871;
(statearr_21879[(9)] = inst_21868);

return statearr_21879;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21871__$1,inst_21869);
} else {
if((state_val_21872 === (2))){
var inst_21848 = (state_21871[(8)]);
var inst_21850 = (inst_21848 < n);
var state_21871__$1 = state_21871;
if(cljs.core.truth_(inst_21850)){
var statearr_21880_21903 = state_21871__$1;
(statearr_21880_21903[(1)] = (4));

} else {
var statearr_21881_21904 = state_21871__$1;
(statearr_21881_21904[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (11))){
var inst_21848 = (state_21871[(8)]);
var inst_21858 = (state_21871[(2)]);
var inst_21859 = (inst_21848 + (1));
var inst_21848__$1 = inst_21859;
var state_21871__$1 = (function (){var statearr_21882 = state_21871;
(statearr_21882[(8)] = inst_21848__$1);

(statearr_21882[(10)] = inst_21858);

return statearr_21882;
})();
var statearr_21883_21905 = state_21871__$1;
(statearr_21883_21905[(2)] = null);

(statearr_21883_21905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (9))){
var state_21871__$1 = state_21871;
var statearr_21884_21906 = state_21871__$1;
(statearr_21884_21906[(2)] = null);

(statearr_21884_21906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (5))){
var state_21871__$1 = state_21871;
var statearr_21885_21907 = state_21871__$1;
(statearr_21885_21907[(2)] = null);

(statearr_21885_21907[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (10))){
var inst_21863 = (state_21871[(2)]);
var state_21871__$1 = state_21871;
var statearr_21886_21908 = state_21871__$1;
(statearr_21886_21908[(2)] = inst_21863);

(statearr_21886_21908[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21872 === (8))){
var inst_21853 = (state_21871[(7)]);
var state_21871__$1 = state_21871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21871__$1,(11),out,inst_21853);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21898,out))
;
return ((function (switch__19596__auto__,c__19708__auto___21898,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_21890 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21890[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_21890[(1)] = (1));

return statearr_21890;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_21871){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21891){if((e21891 instanceof Object)){
var ex__19600__auto__ = e21891;
var statearr_21892_21909 = state_21871;
(statearr_21892_21909[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21910 = state_21871;
state_21871 = G__21910;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_21871){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_21871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21898,out))
})();
var state__19710__auto__ = (function (){var statearr_21893 = f__19709__auto__.call(null);
(statearr_21893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21898);

return statearr_21893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21898,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21918 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21918 = (function (f,ch,meta21919){
this.f = f;
this.ch = ch;
this.meta21919 = meta21919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21920,meta21919__$1){
var self__ = this;
var _21920__$1 = this;
return (new cljs.core.async.t_cljs$core$async21918(self__.f,self__.ch,meta21919__$1));
});

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21920){
var self__ = this;
var _21920__$1 = this;
return self__.meta21919;
});

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21921 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21921 = (function (f,ch,meta21919,_,fn1,meta21922){
this.f = f;
this.ch = ch;
this.meta21919 = meta21919;
this._ = _;
this.fn1 = fn1;
this.meta21922 = meta21922;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21923,meta21922__$1){
var self__ = this;
var _21923__$1 = this;
return (new cljs.core.async.t_cljs$core$async21921(self__.f,self__.ch,self__.meta21919,self__._,self__.fn1,meta21922__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21923){
var self__ = this;
var _21923__$1 = this;
return self__.meta21922;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21911_SHARP_){
return f1.call(null,(((p1__21911_SHARP_ == null))?null:self__.f.call(null,p1__21911_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21919","meta21919",-2048534791,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21918","cljs.core.async/t_cljs$core$async21918",337874547,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21922","meta21922",-559664396,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21921.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21921.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21921";

cljs.core.async.t_cljs$core$async21921.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21921");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21921 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21921(f__$1,ch__$1,meta21919__$1,___$2,fn1__$1,meta21922){
return (new cljs.core.async.t_cljs$core$async21921(f__$1,ch__$1,meta21919__$1,___$2,fn1__$1,meta21922));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21921(self__.f,self__.ch,self__.meta21919,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6880__auto__ = ret;
if(cljs.core.truth_(and__6880__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6880__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21918.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21918.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21919","meta21919",-2048534791,null)], null);
});

cljs.core.async.t_cljs$core$async21918.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21918.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21918";

cljs.core.async.t_cljs$core$async21918.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21918");
});

cljs.core.async.__GT_t_cljs$core$async21918 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21918(f__$1,ch__$1,meta21919){
return (new cljs.core.async.t_cljs$core$async21918(f__$1,ch__$1,meta21919));
});

}

return (new cljs.core.async.t_cljs$core$async21918(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21927 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21927 = (function (f,ch,meta21928){
this.f = f;
this.ch = ch;
this.meta21928 = meta21928;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21929,meta21928__$1){
var self__ = this;
var _21929__$1 = this;
return (new cljs.core.async.t_cljs$core$async21927(self__.f,self__.ch,meta21928__$1));
});

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21929){
var self__ = this;
var _21929__$1 = this;
return self__.meta21928;
});

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21927.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21927.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21928","meta21928",-1375018053,null)], null);
});

cljs.core.async.t_cljs$core$async21927.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21927.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21927";

cljs.core.async.t_cljs$core$async21927.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21927");
});

cljs.core.async.__GT_t_cljs$core$async21927 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21927(f__$1,ch__$1,meta21928){
return (new cljs.core.async.t_cljs$core$async21927(f__$1,ch__$1,meta21928));
});

}

return (new cljs.core.async.t_cljs$core$async21927(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21933 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21933 = (function (p,ch,meta21934){
this.p = p;
this.ch = ch;
this.meta21934 = meta21934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21935,meta21934__$1){
var self__ = this;
var _21935__$1 = this;
return (new cljs.core.async.t_cljs$core$async21933(self__.p,self__.ch,meta21934__$1));
});

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21935){
var self__ = this;
var _21935__$1 = this;
return self__.meta21934;
});

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21933.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21933.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21934","meta21934",-885364965,null)], null);
});

cljs.core.async.t_cljs$core$async21933.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21933.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21933";

cljs.core.async.t_cljs$core$async21933.cljs$lang$ctorPrWriter = (function (this__7503__auto__,writer__7504__auto__,opt__7505__auto__){
return cljs.core._write.call(null,writer__7504__auto__,"cljs.core.async/t_cljs$core$async21933");
});

cljs.core.async.__GT_t_cljs$core$async21933 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21933(p__$1,ch__$1,meta21934){
return (new cljs.core.async.t_cljs$core$async21933(p__$1,ch__$1,meta21934));
});

}

return (new cljs.core.async.t_cljs$core$async21933(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21936 = [];
var len__8005__auto___21980 = arguments.length;
var i__8006__auto___21981 = (0);
while(true){
if((i__8006__auto___21981 < len__8005__auto___21980)){
args21936.push((arguments[i__8006__auto___21981]));

var G__21982 = (i__8006__auto___21981 + (1));
i__8006__auto___21981 = G__21982;
continue;
} else {
}
break;
}

var G__21938 = args21936.length;
switch (G__21938) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21936.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___21984 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___21984,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___21984,out){
return (function (state_21959){
var state_val_21960 = (state_21959[(1)]);
if((state_val_21960 === (7))){
var inst_21955 = (state_21959[(2)]);
var state_21959__$1 = state_21959;
var statearr_21961_21985 = state_21959__$1;
(statearr_21961_21985[(2)] = inst_21955);

(statearr_21961_21985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (1))){
var state_21959__$1 = state_21959;
var statearr_21962_21986 = state_21959__$1;
(statearr_21962_21986[(2)] = null);

(statearr_21962_21986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (4))){
var inst_21941 = (state_21959[(7)]);
var inst_21941__$1 = (state_21959[(2)]);
var inst_21942 = (inst_21941__$1 == null);
var state_21959__$1 = (function (){var statearr_21963 = state_21959;
(statearr_21963[(7)] = inst_21941__$1);

return statearr_21963;
})();
if(cljs.core.truth_(inst_21942)){
var statearr_21964_21987 = state_21959__$1;
(statearr_21964_21987[(1)] = (5));

} else {
var statearr_21965_21988 = state_21959__$1;
(statearr_21965_21988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (6))){
var inst_21941 = (state_21959[(7)]);
var inst_21946 = p.call(null,inst_21941);
var state_21959__$1 = state_21959;
if(cljs.core.truth_(inst_21946)){
var statearr_21966_21989 = state_21959__$1;
(statearr_21966_21989[(1)] = (8));

} else {
var statearr_21967_21990 = state_21959__$1;
(statearr_21967_21990[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (3))){
var inst_21957 = (state_21959[(2)]);
var state_21959__$1 = state_21959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21959__$1,inst_21957);
} else {
if((state_val_21960 === (2))){
var state_21959__$1 = state_21959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21959__$1,(4),ch);
} else {
if((state_val_21960 === (11))){
var inst_21949 = (state_21959[(2)]);
var state_21959__$1 = state_21959;
var statearr_21968_21991 = state_21959__$1;
(statearr_21968_21991[(2)] = inst_21949);

(statearr_21968_21991[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (9))){
var state_21959__$1 = state_21959;
var statearr_21969_21992 = state_21959__$1;
(statearr_21969_21992[(2)] = null);

(statearr_21969_21992[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (5))){
var inst_21944 = cljs.core.async.close_BANG_.call(null,out);
var state_21959__$1 = state_21959;
var statearr_21970_21993 = state_21959__$1;
(statearr_21970_21993[(2)] = inst_21944);

(statearr_21970_21993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (10))){
var inst_21952 = (state_21959[(2)]);
var state_21959__$1 = (function (){var statearr_21971 = state_21959;
(statearr_21971[(8)] = inst_21952);

return statearr_21971;
})();
var statearr_21972_21994 = state_21959__$1;
(statearr_21972_21994[(2)] = null);

(statearr_21972_21994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21960 === (8))){
var inst_21941 = (state_21959[(7)]);
var state_21959__$1 = state_21959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21959__$1,(11),out,inst_21941);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___21984,out))
;
return ((function (switch__19596__auto__,c__19708__auto___21984,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_21976 = [null,null,null,null,null,null,null,null,null];
(statearr_21976[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_21976[(1)] = (1));

return statearr_21976;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_21959){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_21959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e21977){if((e21977 instanceof Object)){
var ex__19600__auto__ = e21977;
var statearr_21978_21995 = state_21959;
(statearr_21978_21995[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21977;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21996 = state_21959;
state_21959 = G__21996;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_21959){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_21959);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___21984,out))
})();
var state__19710__auto__ = (function (){var statearr_21979 = f__19709__auto__.call(null);
(statearr_21979[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___21984);

return statearr_21979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___21984,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21997 = [];
var len__8005__auto___22000 = arguments.length;
var i__8006__auto___22001 = (0);
while(true){
if((i__8006__auto___22001 < len__8005__auto___22000)){
args21997.push((arguments[i__8006__auto___22001]));

var G__22002 = (i__8006__auto___22001 + (1));
i__8006__auto___22001 = G__22002;
continue;
} else {
}
break;
}

var G__21999 = args21997.length;
switch (G__21999) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args21997.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19708__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto__){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto__){
return (function (state_22169){
var state_val_22170 = (state_22169[(1)]);
if((state_val_22170 === (7))){
var inst_22165 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
var statearr_22171_22212 = state_22169__$1;
(statearr_22171_22212[(2)] = inst_22165);

(statearr_22171_22212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (20))){
var inst_22135 = (state_22169[(7)]);
var inst_22146 = (state_22169[(2)]);
var inst_22147 = cljs.core.next.call(null,inst_22135);
var inst_22121 = inst_22147;
var inst_22122 = null;
var inst_22123 = (0);
var inst_22124 = (0);
var state_22169__$1 = (function (){var statearr_22172 = state_22169;
(statearr_22172[(8)] = inst_22124);

(statearr_22172[(9)] = inst_22122);

(statearr_22172[(10)] = inst_22146);

(statearr_22172[(11)] = inst_22121);

(statearr_22172[(12)] = inst_22123);

return statearr_22172;
})();
var statearr_22173_22213 = state_22169__$1;
(statearr_22173_22213[(2)] = null);

(statearr_22173_22213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (1))){
var state_22169__$1 = state_22169;
var statearr_22174_22214 = state_22169__$1;
(statearr_22174_22214[(2)] = null);

(statearr_22174_22214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (4))){
var inst_22110 = (state_22169[(13)]);
var inst_22110__$1 = (state_22169[(2)]);
var inst_22111 = (inst_22110__$1 == null);
var state_22169__$1 = (function (){var statearr_22175 = state_22169;
(statearr_22175[(13)] = inst_22110__$1);

return statearr_22175;
})();
if(cljs.core.truth_(inst_22111)){
var statearr_22176_22215 = state_22169__$1;
(statearr_22176_22215[(1)] = (5));

} else {
var statearr_22177_22216 = state_22169__$1;
(statearr_22177_22216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (15))){
var state_22169__$1 = state_22169;
var statearr_22181_22217 = state_22169__$1;
(statearr_22181_22217[(2)] = null);

(statearr_22181_22217[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (21))){
var state_22169__$1 = state_22169;
var statearr_22182_22218 = state_22169__$1;
(statearr_22182_22218[(2)] = null);

(statearr_22182_22218[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (13))){
var inst_22124 = (state_22169[(8)]);
var inst_22122 = (state_22169[(9)]);
var inst_22121 = (state_22169[(11)]);
var inst_22123 = (state_22169[(12)]);
var inst_22131 = (state_22169[(2)]);
var inst_22132 = (inst_22124 + (1));
var tmp22178 = inst_22122;
var tmp22179 = inst_22121;
var tmp22180 = inst_22123;
var inst_22121__$1 = tmp22179;
var inst_22122__$1 = tmp22178;
var inst_22123__$1 = tmp22180;
var inst_22124__$1 = inst_22132;
var state_22169__$1 = (function (){var statearr_22183 = state_22169;
(statearr_22183[(8)] = inst_22124__$1);

(statearr_22183[(9)] = inst_22122__$1);

(statearr_22183[(14)] = inst_22131);

(statearr_22183[(11)] = inst_22121__$1);

(statearr_22183[(12)] = inst_22123__$1);

return statearr_22183;
})();
var statearr_22184_22219 = state_22169__$1;
(statearr_22184_22219[(2)] = null);

(statearr_22184_22219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (22))){
var state_22169__$1 = state_22169;
var statearr_22185_22220 = state_22169__$1;
(statearr_22185_22220[(2)] = null);

(statearr_22185_22220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (6))){
var inst_22110 = (state_22169[(13)]);
var inst_22119 = f.call(null,inst_22110);
var inst_22120 = cljs.core.seq.call(null,inst_22119);
var inst_22121 = inst_22120;
var inst_22122 = null;
var inst_22123 = (0);
var inst_22124 = (0);
var state_22169__$1 = (function (){var statearr_22186 = state_22169;
(statearr_22186[(8)] = inst_22124);

(statearr_22186[(9)] = inst_22122);

(statearr_22186[(11)] = inst_22121);

(statearr_22186[(12)] = inst_22123);

return statearr_22186;
})();
var statearr_22187_22221 = state_22169__$1;
(statearr_22187_22221[(2)] = null);

(statearr_22187_22221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (17))){
var inst_22135 = (state_22169[(7)]);
var inst_22139 = cljs.core.chunk_first.call(null,inst_22135);
var inst_22140 = cljs.core.chunk_rest.call(null,inst_22135);
var inst_22141 = cljs.core.count.call(null,inst_22139);
var inst_22121 = inst_22140;
var inst_22122 = inst_22139;
var inst_22123 = inst_22141;
var inst_22124 = (0);
var state_22169__$1 = (function (){var statearr_22188 = state_22169;
(statearr_22188[(8)] = inst_22124);

(statearr_22188[(9)] = inst_22122);

(statearr_22188[(11)] = inst_22121);

(statearr_22188[(12)] = inst_22123);

return statearr_22188;
})();
var statearr_22189_22222 = state_22169__$1;
(statearr_22189_22222[(2)] = null);

(statearr_22189_22222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (3))){
var inst_22167 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22169__$1,inst_22167);
} else {
if((state_val_22170 === (12))){
var inst_22155 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
var statearr_22190_22223 = state_22169__$1;
(statearr_22190_22223[(2)] = inst_22155);

(statearr_22190_22223[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (2))){
var state_22169__$1 = state_22169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22169__$1,(4),in$);
} else {
if((state_val_22170 === (23))){
var inst_22163 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
var statearr_22191_22224 = state_22169__$1;
(statearr_22191_22224[(2)] = inst_22163);

(statearr_22191_22224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (19))){
var inst_22150 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
var statearr_22192_22225 = state_22169__$1;
(statearr_22192_22225[(2)] = inst_22150);

(statearr_22192_22225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (11))){
var inst_22135 = (state_22169[(7)]);
var inst_22121 = (state_22169[(11)]);
var inst_22135__$1 = cljs.core.seq.call(null,inst_22121);
var state_22169__$1 = (function (){var statearr_22193 = state_22169;
(statearr_22193[(7)] = inst_22135__$1);

return statearr_22193;
})();
if(inst_22135__$1){
var statearr_22194_22226 = state_22169__$1;
(statearr_22194_22226[(1)] = (14));

} else {
var statearr_22195_22227 = state_22169__$1;
(statearr_22195_22227[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (9))){
var inst_22157 = (state_22169[(2)]);
var inst_22158 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22169__$1 = (function (){var statearr_22196 = state_22169;
(statearr_22196[(15)] = inst_22157);

return statearr_22196;
})();
if(cljs.core.truth_(inst_22158)){
var statearr_22197_22228 = state_22169__$1;
(statearr_22197_22228[(1)] = (21));

} else {
var statearr_22198_22229 = state_22169__$1;
(statearr_22198_22229[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (5))){
var inst_22113 = cljs.core.async.close_BANG_.call(null,out);
var state_22169__$1 = state_22169;
var statearr_22199_22230 = state_22169__$1;
(statearr_22199_22230[(2)] = inst_22113);

(statearr_22199_22230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (14))){
var inst_22135 = (state_22169[(7)]);
var inst_22137 = cljs.core.chunked_seq_QMARK_.call(null,inst_22135);
var state_22169__$1 = state_22169;
if(inst_22137){
var statearr_22200_22231 = state_22169__$1;
(statearr_22200_22231[(1)] = (17));

} else {
var statearr_22201_22232 = state_22169__$1;
(statearr_22201_22232[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (16))){
var inst_22153 = (state_22169[(2)]);
var state_22169__$1 = state_22169;
var statearr_22202_22233 = state_22169__$1;
(statearr_22202_22233[(2)] = inst_22153);

(statearr_22202_22233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22170 === (10))){
var inst_22124 = (state_22169[(8)]);
var inst_22122 = (state_22169[(9)]);
var inst_22129 = cljs.core._nth.call(null,inst_22122,inst_22124);
var state_22169__$1 = state_22169;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22169__$1,(13),out,inst_22129);
} else {
if((state_val_22170 === (18))){
var inst_22135 = (state_22169[(7)]);
var inst_22144 = cljs.core.first.call(null,inst_22135);
var state_22169__$1 = state_22169;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22169__$1,(20),out,inst_22144);
} else {
if((state_val_22170 === (8))){
var inst_22124 = (state_22169[(8)]);
var inst_22123 = (state_22169[(12)]);
var inst_22126 = (inst_22124 < inst_22123);
var inst_22127 = inst_22126;
var state_22169__$1 = state_22169;
if(cljs.core.truth_(inst_22127)){
var statearr_22203_22234 = state_22169__$1;
(statearr_22203_22234[(1)] = (10));

} else {
var statearr_22204_22235 = state_22169__$1;
(statearr_22204_22235[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto__))
;
return ((function (switch__19596__auto__,c__19708__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____0 = (function (){
var statearr_22208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22208[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__);

(statearr_22208[(1)] = (1));

return statearr_22208;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____1 = (function (state_22169){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_22169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e22209){if((e22209 instanceof Object)){
var ex__19600__auto__ = e22209;
var statearr_22210_22236 = state_22169;
(statearr_22210_22236[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22237 = state_22169;
state_22169 = G__22237;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__ = function(state_22169){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____1.call(this,state_22169);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19597__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto__))
})();
var state__19710__auto__ = (function (){var statearr_22211 = f__19709__auto__.call(null);
(statearr_22211[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto__);

return statearr_22211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto__))
);

return c__19708__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args22238 = [];
var len__8005__auto___22241 = arguments.length;
var i__8006__auto___22242 = (0);
while(true){
if((i__8006__auto___22242 < len__8005__auto___22241)){
args22238.push((arguments[i__8006__auto___22242]));

var G__22243 = (i__8006__auto___22242 + (1));
i__8006__auto___22242 = G__22243;
continue;
} else {
}
break;
}

var G__22240 = args22238.length;
switch (G__22240) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22238.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args22245 = [];
var len__8005__auto___22248 = arguments.length;
var i__8006__auto___22249 = (0);
while(true){
if((i__8006__auto___22249 < len__8005__auto___22248)){
args22245.push((arguments[i__8006__auto___22249]));

var G__22250 = (i__8006__auto___22249 + (1));
i__8006__auto___22249 = G__22250;
continue;
} else {
}
break;
}

var G__22247 = args22245.length;
switch (G__22247) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22245.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args22252 = [];
var len__8005__auto___22303 = arguments.length;
var i__8006__auto___22304 = (0);
while(true){
if((i__8006__auto___22304 < len__8005__auto___22303)){
args22252.push((arguments[i__8006__auto___22304]));

var G__22305 = (i__8006__auto___22304 + (1));
i__8006__auto___22304 = G__22305;
continue;
} else {
}
break;
}

var G__22254 = args22252.length;
switch (G__22254) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22252.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___22307 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___22307,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___22307,out){
return (function (state_22278){
var state_val_22279 = (state_22278[(1)]);
if((state_val_22279 === (7))){
var inst_22273 = (state_22278[(2)]);
var state_22278__$1 = state_22278;
var statearr_22280_22308 = state_22278__$1;
(statearr_22280_22308[(2)] = inst_22273);

(statearr_22280_22308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (1))){
var inst_22255 = null;
var state_22278__$1 = (function (){var statearr_22281 = state_22278;
(statearr_22281[(7)] = inst_22255);

return statearr_22281;
})();
var statearr_22282_22309 = state_22278__$1;
(statearr_22282_22309[(2)] = null);

(statearr_22282_22309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (4))){
var inst_22258 = (state_22278[(8)]);
var inst_22258__$1 = (state_22278[(2)]);
var inst_22259 = (inst_22258__$1 == null);
var inst_22260 = cljs.core.not.call(null,inst_22259);
var state_22278__$1 = (function (){var statearr_22283 = state_22278;
(statearr_22283[(8)] = inst_22258__$1);

return statearr_22283;
})();
if(inst_22260){
var statearr_22284_22310 = state_22278__$1;
(statearr_22284_22310[(1)] = (5));

} else {
var statearr_22285_22311 = state_22278__$1;
(statearr_22285_22311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (6))){
var state_22278__$1 = state_22278;
var statearr_22286_22312 = state_22278__$1;
(statearr_22286_22312[(2)] = null);

(statearr_22286_22312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (3))){
var inst_22275 = (state_22278[(2)]);
var inst_22276 = cljs.core.async.close_BANG_.call(null,out);
var state_22278__$1 = (function (){var statearr_22287 = state_22278;
(statearr_22287[(9)] = inst_22275);

return statearr_22287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22278__$1,inst_22276);
} else {
if((state_val_22279 === (2))){
var state_22278__$1 = state_22278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22278__$1,(4),ch);
} else {
if((state_val_22279 === (11))){
var inst_22258 = (state_22278[(8)]);
var inst_22267 = (state_22278[(2)]);
var inst_22255 = inst_22258;
var state_22278__$1 = (function (){var statearr_22288 = state_22278;
(statearr_22288[(10)] = inst_22267);

(statearr_22288[(7)] = inst_22255);

return statearr_22288;
})();
var statearr_22289_22313 = state_22278__$1;
(statearr_22289_22313[(2)] = null);

(statearr_22289_22313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (9))){
var inst_22258 = (state_22278[(8)]);
var state_22278__$1 = state_22278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22278__$1,(11),out,inst_22258);
} else {
if((state_val_22279 === (5))){
var inst_22258 = (state_22278[(8)]);
var inst_22255 = (state_22278[(7)]);
var inst_22262 = cljs.core._EQ_.call(null,inst_22258,inst_22255);
var state_22278__$1 = state_22278;
if(inst_22262){
var statearr_22291_22314 = state_22278__$1;
(statearr_22291_22314[(1)] = (8));

} else {
var statearr_22292_22315 = state_22278__$1;
(statearr_22292_22315[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (10))){
var inst_22270 = (state_22278[(2)]);
var state_22278__$1 = state_22278;
var statearr_22293_22316 = state_22278__$1;
(statearr_22293_22316[(2)] = inst_22270);

(statearr_22293_22316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22279 === (8))){
var inst_22255 = (state_22278[(7)]);
var tmp22290 = inst_22255;
var inst_22255__$1 = tmp22290;
var state_22278__$1 = (function (){var statearr_22294 = state_22278;
(statearr_22294[(7)] = inst_22255__$1);

return statearr_22294;
})();
var statearr_22295_22317 = state_22278__$1;
(statearr_22295_22317[(2)] = null);

(statearr_22295_22317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___22307,out))
;
return ((function (switch__19596__auto__,c__19708__auto___22307,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_22299 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22299[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_22299[(1)] = (1));

return statearr_22299;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_22278){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_22278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e22300){if((e22300 instanceof Object)){
var ex__19600__auto__ = e22300;
var statearr_22301_22318 = state_22278;
(statearr_22301_22318[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22300;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22319 = state_22278;
state_22278 = G__22319;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_22278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_22278);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___22307,out))
})();
var state__19710__auto__ = (function (){var statearr_22302 = f__19709__auto__.call(null);
(statearr_22302[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___22307);

return statearr_22302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___22307,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args22320 = [];
var len__8005__auto___22390 = arguments.length;
var i__8006__auto___22391 = (0);
while(true){
if((i__8006__auto___22391 < len__8005__auto___22390)){
args22320.push((arguments[i__8006__auto___22391]));

var G__22392 = (i__8006__auto___22391 + (1));
i__8006__auto___22391 = G__22392;
continue;
} else {
}
break;
}

var G__22322 = args22320.length;
switch (G__22322) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22320.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___22394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___22394,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___22394,out){
return (function (state_22360){
var state_val_22361 = (state_22360[(1)]);
if((state_val_22361 === (7))){
var inst_22356 = (state_22360[(2)]);
var state_22360__$1 = state_22360;
var statearr_22362_22395 = state_22360__$1;
(statearr_22362_22395[(2)] = inst_22356);

(statearr_22362_22395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (1))){
var inst_22323 = (new Array(n));
var inst_22324 = inst_22323;
var inst_22325 = (0);
var state_22360__$1 = (function (){var statearr_22363 = state_22360;
(statearr_22363[(7)] = inst_22324);

(statearr_22363[(8)] = inst_22325);

return statearr_22363;
})();
var statearr_22364_22396 = state_22360__$1;
(statearr_22364_22396[(2)] = null);

(statearr_22364_22396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (4))){
var inst_22328 = (state_22360[(9)]);
var inst_22328__$1 = (state_22360[(2)]);
var inst_22329 = (inst_22328__$1 == null);
var inst_22330 = cljs.core.not.call(null,inst_22329);
var state_22360__$1 = (function (){var statearr_22365 = state_22360;
(statearr_22365[(9)] = inst_22328__$1);

return statearr_22365;
})();
if(inst_22330){
var statearr_22366_22397 = state_22360__$1;
(statearr_22366_22397[(1)] = (5));

} else {
var statearr_22367_22398 = state_22360__$1;
(statearr_22367_22398[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (15))){
var inst_22350 = (state_22360[(2)]);
var state_22360__$1 = state_22360;
var statearr_22368_22399 = state_22360__$1;
(statearr_22368_22399[(2)] = inst_22350);

(statearr_22368_22399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (13))){
var state_22360__$1 = state_22360;
var statearr_22369_22400 = state_22360__$1;
(statearr_22369_22400[(2)] = null);

(statearr_22369_22400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (6))){
var inst_22325 = (state_22360[(8)]);
var inst_22346 = (inst_22325 > (0));
var state_22360__$1 = state_22360;
if(cljs.core.truth_(inst_22346)){
var statearr_22370_22401 = state_22360__$1;
(statearr_22370_22401[(1)] = (12));

} else {
var statearr_22371_22402 = state_22360__$1;
(statearr_22371_22402[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (3))){
var inst_22358 = (state_22360[(2)]);
var state_22360__$1 = state_22360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22360__$1,inst_22358);
} else {
if((state_val_22361 === (12))){
var inst_22324 = (state_22360[(7)]);
var inst_22348 = cljs.core.vec.call(null,inst_22324);
var state_22360__$1 = state_22360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22360__$1,(15),out,inst_22348);
} else {
if((state_val_22361 === (2))){
var state_22360__$1 = state_22360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22360__$1,(4),ch);
} else {
if((state_val_22361 === (11))){
var inst_22340 = (state_22360[(2)]);
var inst_22341 = (new Array(n));
var inst_22324 = inst_22341;
var inst_22325 = (0);
var state_22360__$1 = (function (){var statearr_22372 = state_22360;
(statearr_22372[(7)] = inst_22324);

(statearr_22372[(10)] = inst_22340);

(statearr_22372[(8)] = inst_22325);

return statearr_22372;
})();
var statearr_22373_22403 = state_22360__$1;
(statearr_22373_22403[(2)] = null);

(statearr_22373_22403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (9))){
var inst_22324 = (state_22360[(7)]);
var inst_22338 = cljs.core.vec.call(null,inst_22324);
var state_22360__$1 = state_22360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22360__$1,(11),out,inst_22338);
} else {
if((state_val_22361 === (5))){
var inst_22324 = (state_22360[(7)]);
var inst_22325 = (state_22360[(8)]);
var inst_22333 = (state_22360[(11)]);
var inst_22328 = (state_22360[(9)]);
var inst_22332 = (inst_22324[inst_22325] = inst_22328);
var inst_22333__$1 = (inst_22325 + (1));
var inst_22334 = (inst_22333__$1 < n);
var state_22360__$1 = (function (){var statearr_22374 = state_22360;
(statearr_22374[(11)] = inst_22333__$1);

(statearr_22374[(12)] = inst_22332);

return statearr_22374;
})();
if(cljs.core.truth_(inst_22334)){
var statearr_22375_22404 = state_22360__$1;
(statearr_22375_22404[(1)] = (8));

} else {
var statearr_22376_22405 = state_22360__$1;
(statearr_22376_22405[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (14))){
var inst_22353 = (state_22360[(2)]);
var inst_22354 = cljs.core.async.close_BANG_.call(null,out);
var state_22360__$1 = (function (){var statearr_22378 = state_22360;
(statearr_22378[(13)] = inst_22353);

return statearr_22378;
})();
var statearr_22379_22406 = state_22360__$1;
(statearr_22379_22406[(2)] = inst_22354);

(statearr_22379_22406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (10))){
var inst_22344 = (state_22360[(2)]);
var state_22360__$1 = state_22360;
var statearr_22380_22407 = state_22360__$1;
(statearr_22380_22407[(2)] = inst_22344);

(statearr_22380_22407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22361 === (8))){
var inst_22324 = (state_22360[(7)]);
var inst_22333 = (state_22360[(11)]);
var tmp22377 = inst_22324;
var inst_22324__$1 = tmp22377;
var inst_22325 = inst_22333;
var state_22360__$1 = (function (){var statearr_22381 = state_22360;
(statearr_22381[(7)] = inst_22324__$1);

(statearr_22381[(8)] = inst_22325);

return statearr_22381;
})();
var statearr_22382_22408 = state_22360__$1;
(statearr_22382_22408[(2)] = null);

(statearr_22382_22408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___22394,out))
;
return ((function (switch__19596__auto__,c__19708__auto___22394,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_22386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22386[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_22386[(1)] = (1));

return statearr_22386;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_22360){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_22360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e22387){if((e22387 instanceof Object)){
var ex__19600__auto__ = e22387;
var statearr_22388_22409 = state_22360;
(statearr_22388_22409[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22410 = state_22360;
state_22360 = G__22410;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_22360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_22360);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___22394,out))
})();
var state__19710__auto__ = (function (){var statearr_22389 = f__19709__auto__.call(null);
(statearr_22389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___22394);

return statearr_22389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___22394,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args22411 = [];
var len__8005__auto___22485 = arguments.length;
var i__8006__auto___22486 = (0);
while(true){
if((i__8006__auto___22486 < len__8005__auto___22485)){
args22411.push((arguments[i__8006__auto___22486]));

var G__22487 = (i__8006__auto___22486 + (1));
i__8006__auto___22486 = G__22487;
continue;
} else {
}
break;
}

var G__22413 = args22411.length;
switch (G__22413) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args22411.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19708__auto___22489 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19708__auto___22489,out){
return (function (){
var f__19709__auto__ = (function (){var switch__19596__auto__ = ((function (c__19708__auto___22489,out){
return (function (state_22455){
var state_val_22456 = (state_22455[(1)]);
if((state_val_22456 === (7))){
var inst_22451 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
var statearr_22457_22490 = state_22455__$1;
(statearr_22457_22490[(2)] = inst_22451);

(statearr_22457_22490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (1))){
var inst_22414 = [];
var inst_22415 = inst_22414;
var inst_22416 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_22455__$1 = (function (){var statearr_22458 = state_22455;
(statearr_22458[(7)] = inst_22416);

(statearr_22458[(8)] = inst_22415);

return statearr_22458;
})();
var statearr_22459_22491 = state_22455__$1;
(statearr_22459_22491[(2)] = null);

(statearr_22459_22491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (4))){
var inst_22419 = (state_22455[(9)]);
var inst_22419__$1 = (state_22455[(2)]);
var inst_22420 = (inst_22419__$1 == null);
var inst_22421 = cljs.core.not.call(null,inst_22420);
var state_22455__$1 = (function (){var statearr_22460 = state_22455;
(statearr_22460[(9)] = inst_22419__$1);

return statearr_22460;
})();
if(inst_22421){
var statearr_22461_22492 = state_22455__$1;
(statearr_22461_22492[(1)] = (5));

} else {
var statearr_22462_22493 = state_22455__$1;
(statearr_22462_22493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (15))){
var inst_22445 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
var statearr_22463_22494 = state_22455__$1;
(statearr_22463_22494[(2)] = inst_22445);

(statearr_22463_22494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (13))){
var state_22455__$1 = state_22455;
var statearr_22464_22495 = state_22455__$1;
(statearr_22464_22495[(2)] = null);

(statearr_22464_22495[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (6))){
var inst_22415 = (state_22455[(8)]);
var inst_22440 = inst_22415.length;
var inst_22441 = (inst_22440 > (0));
var state_22455__$1 = state_22455;
if(cljs.core.truth_(inst_22441)){
var statearr_22465_22496 = state_22455__$1;
(statearr_22465_22496[(1)] = (12));

} else {
var statearr_22466_22497 = state_22455__$1;
(statearr_22466_22497[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (3))){
var inst_22453 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22455__$1,inst_22453);
} else {
if((state_val_22456 === (12))){
var inst_22415 = (state_22455[(8)]);
var inst_22443 = cljs.core.vec.call(null,inst_22415);
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22455__$1,(15),out,inst_22443);
} else {
if((state_val_22456 === (2))){
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22455__$1,(4),ch);
} else {
if((state_val_22456 === (11))){
var inst_22419 = (state_22455[(9)]);
var inst_22423 = (state_22455[(10)]);
var inst_22433 = (state_22455[(2)]);
var inst_22434 = [];
var inst_22435 = inst_22434.push(inst_22419);
var inst_22415 = inst_22434;
var inst_22416 = inst_22423;
var state_22455__$1 = (function (){var statearr_22467 = state_22455;
(statearr_22467[(7)] = inst_22416);

(statearr_22467[(11)] = inst_22435);

(statearr_22467[(8)] = inst_22415);

(statearr_22467[(12)] = inst_22433);

return statearr_22467;
})();
var statearr_22468_22498 = state_22455__$1;
(statearr_22468_22498[(2)] = null);

(statearr_22468_22498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (9))){
var inst_22415 = (state_22455[(8)]);
var inst_22431 = cljs.core.vec.call(null,inst_22415);
var state_22455__$1 = state_22455;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22455__$1,(11),out,inst_22431);
} else {
if((state_val_22456 === (5))){
var inst_22416 = (state_22455[(7)]);
var inst_22419 = (state_22455[(9)]);
var inst_22423 = (state_22455[(10)]);
var inst_22423__$1 = f.call(null,inst_22419);
var inst_22424 = cljs.core._EQ_.call(null,inst_22423__$1,inst_22416);
var inst_22425 = cljs.core.keyword_identical_QMARK_.call(null,inst_22416,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_22426 = (inst_22424) || (inst_22425);
var state_22455__$1 = (function (){var statearr_22469 = state_22455;
(statearr_22469[(10)] = inst_22423__$1);

return statearr_22469;
})();
if(cljs.core.truth_(inst_22426)){
var statearr_22470_22499 = state_22455__$1;
(statearr_22470_22499[(1)] = (8));

} else {
var statearr_22471_22500 = state_22455__$1;
(statearr_22471_22500[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (14))){
var inst_22448 = (state_22455[(2)]);
var inst_22449 = cljs.core.async.close_BANG_.call(null,out);
var state_22455__$1 = (function (){var statearr_22473 = state_22455;
(statearr_22473[(13)] = inst_22448);

return statearr_22473;
})();
var statearr_22474_22501 = state_22455__$1;
(statearr_22474_22501[(2)] = inst_22449);

(statearr_22474_22501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (10))){
var inst_22438 = (state_22455[(2)]);
var state_22455__$1 = state_22455;
var statearr_22475_22502 = state_22455__$1;
(statearr_22475_22502[(2)] = inst_22438);

(statearr_22475_22502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22456 === (8))){
var inst_22419 = (state_22455[(9)]);
var inst_22423 = (state_22455[(10)]);
var inst_22415 = (state_22455[(8)]);
var inst_22428 = inst_22415.push(inst_22419);
var tmp22472 = inst_22415;
var inst_22415__$1 = tmp22472;
var inst_22416 = inst_22423;
var state_22455__$1 = (function (){var statearr_22476 = state_22455;
(statearr_22476[(7)] = inst_22416);

(statearr_22476[(14)] = inst_22428);

(statearr_22476[(8)] = inst_22415__$1);

return statearr_22476;
})();
var statearr_22477_22503 = state_22455__$1;
(statearr_22477_22503[(2)] = null);

(statearr_22477_22503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19708__auto___22489,out))
;
return ((function (switch__19596__auto__,c__19708__auto___22489,out){
return (function() {
var cljs$core$async$state_machine__19597__auto__ = null;
var cljs$core$async$state_machine__19597__auto____0 = (function (){
var statearr_22481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22481[(0)] = cljs$core$async$state_machine__19597__auto__);

(statearr_22481[(1)] = (1));

return statearr_22481;
});
var cljs$core$async$state_machine__19597__auto____1 = (function (state_22455){
while(true){
var ret_value__19598__auto__ = (function (){try{while(true){
var result__19599__auto__ = switch__19596__auto__.call(null,state_22455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19599__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19599__auto__;
}
break;
}
}catch (e22482){if((e22482 instanceof Object)){
var ex__19600__auto__ = e22482;
var statearr_22483_22504 = state_22455;
(statearr_22483_22504[(5)] = ex__19600__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22482;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19598__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22505 = state_22455;
state_22455 = G__22505;
continue;
} else {
return ret_value__19598__auto__;
}
break;
}
});
cljs$core$async$state_machine__19597__auto__ = function(state_22455){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19597__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19597__auto____1.call(this,state_22455);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19597__auto____0;
cljs$core$async$state_machine__19597__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19597__auto____1;
return cljs$core$async$state_machine__19597__auto__;
})()
;})(switch__19596__auto__,c__19708__auto___22489,out))
})();
var state__19710__auto__ = (function (){var statearr_22484 = f__19709__auto__.call(null);
(statearr_22484[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19708__auto___22489);

return statearr_22484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19710__auto__);
});})(c__19708__auto___22489,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

