/*
 * Decompiled with CFR 0.152.
 */
package org.sift.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.runtime.spi.Shuffler;

public class MemSortMergeShuffler
implements Shuffler,
Comparator<Tuple> {
    @Override
    public List<Tuple> sort(List<Tuple> tuples) {
        Collections.sort(tuples, this);
        LinkedList<Tuple> sortMergeTuples = new LinkedList<Tuple>();
        Tuple mergedTuple = null;
        for (Tuple tuple : tuples) {
            if (mergedTuple == null) {
                mergedTuple = tuple.clone();
                mergedTuple.setValue(Fields.SOURCES, null);
                mergedTuple.setValue(Fields.SOURCES, new LinkedList<Object>(tuple.getList(Fields.SOURCES)));
                mergedTuple.setValue(Fields.VALUES, null);
                mergedTuple.addToList(Fields.VALUES, tuple.getList(Fields.VALUES).get(0));
                continue;
            }
            if (!mergedTuple.getString(Fields.KEY).equals(tuple.getString(Fields.KEY))) {
                sortMergeTuples.add(mergedTuple);
                mergedTuple = tuple.clone();
                mergedTuple.setValue(Fields.SOURCES, null);
                mergedTuple.setValue(Fields.SOURCES, new LinkedList<Object>(tuple.getList(Fields.SOURCES)));
                mergedTuple.setValue(Fields.VALUES, null);
                mergedTuple.addToList(Fields.VALUES, tuple.getList(Fields.VALUES).get(0));
                continue;
            }
            if (mergedTuple.getString(Fields.KEY).equals(tuple.getString(Fields.KEY))) {
                for (Object uri : tuple.getList(Fields.SOURCES)) {
                    if (mergedTuple.getList(Fields.SOURCES) != null && mergedTuple.getList(Fields.SOURCES).contains(uri)) continue;
                    mergedTuple.addToList(Fields.SOURCES, uri);
                }
                ArrayList<Object> oldTupleValues = new ArrayList<Object>();
                oldTupleValues.addAll(tuple.getList(Fields.VALUES));
                Collections.addAll(mergedTuple.getList(Fields.VALUES), oldTupleValues.toArray(new Object[0]));
                continue;
            }
            throw new RuntimeException("Unable to sort and merge tuple data!");
        }
        return sortMergeTuples;
    }

    @Override
    public int compare(Tuple tuple1, Tuple tuple2) {
        return tuple1.getString(Fields.KEY).compareTo(tuple2.getString(Fields.KEY));
    }
}

