/*
 * Decompiled with CFR 0.152.
 */
package org.sift.runtime.impl;

import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.runtime.spi.OutputCollector;
import org.sift.runtime.spi.Processor;

public class LineSplitterProcessor
implements Processor {
    public static int minLineLength = 3;
    public static String LINE_SPLIT_REGEX = "\\\\n|\\.(?!\\d)|(?<!\\d)\\.";
    public static String NEW_LINE_CHAR = "\\n";

    @Override
    public void process(Tuple tuple, OutputCollector collector) {
        Tuple returnTuple = new Tuple(Fields.KEY, Fields.SOURCES, Fields.VALUES);
        returnTuple.setValue(Fields.KEY, tuple.getString(Fields.KEY));
        returnTuple.setValue(Fields.SOURCES, tuple.getList(Fields.SOURCES));
        for (Object value : tuple.getList(Fields.VALUES)) {
            for (String line : this.getLines(((String)value).toLowerCase())) {
                if (line.length() <= minLineLength) continue;
                returnTuple.addToList(Fields.VALUES, line.trim());
            }
        }
        collector.emit(returnTuple);
    }

    public String[] getLines(String rawLine) {
        String[] lines;
        for (String line : lines = rawLine.split(LINE_SPLIT_REGEX)) {
            line.replaceAll("\\\\n", "");
            line.replaceAll(NEW_LINE_CHAR, "");
        }
        return lines;
    }
}

