/*
 * Decompiled with CFR 0.152.
 */
package org.sift.runtime.impl;

import java.util.List;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.runtime.spi.OutputCollector;
import org.sift.runtime.spi.Processor;
import org.sift.winnow.StopWords;

public class WordSplitterProcessor
implements Processor {
    private int nGram = 1;
    private StopWords stopWords;

    @Override
    public void process(Tuple tuple, OutputCollector collector) {
        Tuple returnTuple = tuple.clone();
        returnTuple.setValue(Fields.VALUES, null);
        List<Object> values = tuple.getList(Fields.VALUES);
        for (Object value : values) {
            String line = (String)value;
            String[] tokens = this.stopWords.split(line);
            for (int i = 0; i < tokens.length; ++i) {
                StringBuffer tokenBuffer = new StringBuffer();
                for (int j = 0; j < this.getnGram() && i + j < tokens.length; ++j) {
                    tokenBuffer.append(tokens[i + j]);
                    tokenBuffer.append(" ");
                    String word = tokenBuffer.toString().trim();
                    if (this.getStopWords() == null || this.getStopWords().isStopWord(word)) continue;
                    returnTuple.addToList(Fields.VALUES, word);
                }
            }
        }
        collector.emit(returnTuple);
    }

    public static int getWordsLength(String words) {
        return words.split("\\s+|[^a-zA-Z0-9]+").length;
    }

    public int getnGram() {
        return this.nGram;
    }

    public void setnGram(int nGram) {
        this.nGram = nGram;
    }

    public StopWords getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(StopWords stopWords) {
        this.stopWords = stopWords;
    }
}

