/*
 * Decompiled with CFR 0.152.
 */
package org.sift.runtime.impl;

import java.util.Collections;
import java.util.List;
import org.sift.runtime.Fields;
import org.sift.runtime.Tuple;
import org.sift.runtime.spi.OutputCollector;
import org.sift.runtime.spi.Shuffler;

public class ValueAggregatingOutputCollector
implements OutputCollector {
    private static final Object MONITOR = new Object();
    protected OutputCollector delegate;
    protected Shuffler shuffler;

    @Override
    public void emit(Tuple tuple) {
        throw new UnsupportedOperationException("Cannot emit Tuple instances to this class. Use ValueAggregatingOutputCollector#setTuples instead");
    }

    @Override
    public List<Tuple> getEmittedTuples() {
        return this.delegate.getEmittedTuples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTuples(Tuple ... tuples) {
        Object object = MONITOR;
        synchronized (object) {
            Collections.addAll(this.getEmittedTuples(), tuples);
            List<Tuple> sortMergedTuples = this.shuffler.sort(this.getEmittedTuples());
            Tuple[] aggregatedTuples = this.aggregateValue(sortMergedTuples);
            this.delegate.setTuples(aggregatedTuples);
        }
    }

    protected Tuple[] aggregateValue(List<Tuple> sortMergedTuples) {
        Tuple[] aggregatedTuples = new Tuple[sortMergedTuples.size()];
        int count = 0;
        for (Tuple sortMergedTuple : sortMergedTuples) {
            Tuple aggregatedValuesTuple = sortMergedTuple.clone();
            aggregatedValuesTuple.setValue(Fields.VALUES, null);
            Integer aggregateValue = 0;
            for (Object value : sortMergedTuple.getList(Fields.VALUES)) {
                aggregateValue = aggregateValue + (Integer)value;
            }
            aggregatedValuesTuple.addToList(Fields.VALUES, aggregateValue);
            aggregatedTuples[count] = aggregatedValuesTuple;
            ++count;
        }
        return aggregatedTuples;
    }

    public OutputCollector getDelegate() {
        return this.delegate;
    }

    public void setDelegate(OutputCollector delegate) {
        this.delegate = delegate;
    }

    public Shuffler getShuffler() {
        return this.shuffler;
    }

    public void setShuffler(Shuffler shuffler) {
        this.shuffler = shuffler;
    }
}

