/*
 * Decompiled with CFR 0.152.
 */
package org.sift.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sift.runtime.Fields;

public class Tuple {
    public static String KEY = "key";
    public static String SOURCES = "sourceURIs";
    public static String VALUES = "values";
    public static final String KEY_SEP_CHAR = ":";
    public static final String UNDEFINED_KEY = "UNDEFINED";
    public static final String VALUE_SEP_CHAR = ",";
    private List<Fields> fields;
    private List<Object> values = new ArrayList<Object>();

    public Tuple(Fields ... fields) {
        this.fields = new ArrayList<Fields>(Arrays.asList(fields));
        this.values = new ArrayList<Object>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            this.values.add(null);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("TUPLE");
        buffer.append(" ");
        for (Fields field : this.getFields()) {
            buffer.append((Object)field);
            buffer.append(KEY_SEP_CHAR);
            buffer.append(this.getValue(field));
            buffer.append("; ");
        }
        return buffer.toString();
    }

    public void addField(Fields field) {
        if (this.fields.contains((Object)field)) {
            return;
        }
        this.fields.add(field);
        this.values.add(null);
    }

    public void setValue(Fields field, Object value) {
        this.values.set(this.getFieldIndex(field), value);
    }

    public void addToList(Fields field, Object value) {
        if (value == null) {
            return;
        }
        List<Object> fieldList = this.getList(field);
        if (fieldList == null) {
            fieldList = new ArrayList<Object>();
            this.setValue(field, fieldList);
        }
        fieldList.add(value);
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public Object getValue(Fields field) {
        if (!this.contains(field)) {
            return null;
        }
        return this.values.get(this.getFieldIndex(field));
    }

    public int getInt(Fields field) {
        return (Integer)this.getValue(field);
    }

    public String getString(Fields field) {
        return (String)this.getValue(field);
    }

    public List<Object> getList(Fields field) {
        if (this.getValue(field) == null) {
            ArrayList newList = new ArrayList();
            this.setValue(field, newList);
        }
        return (List)this.getValue(field);
    }

    public boolean contains(Fields field) {
        return this.getFieldIndex(field) != -1;
    }

    public Tuple clone() {
        Tuple returnTuple = new Tuple(this.fields.toArray(new Fields[0]));
        for (Fields field : this.getFields()) {
            returnTuple.setValue(field, this.getValue(field));
        }
        return returnTuple;
    }

    private int getFieldIndex(Fields field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) != field) continue;
            return i;
        }
        return -1;
    }
}

