/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tuple;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class MultiThreadedMultiResourceItemReader<T>
implements ItemReader<T>,
ItemStream,
InitializingBean {
    private static final Object MONITOR = new Object();
    private static final Logger LOGGER = LogFactory.getLogger(MultiThreadedMultiResourceItemReader.class);
    private static final int INVALID_INDEX = -1;
    private ResourceAwareItemReaderItemStream<? extends T> delegate;
    private Resource[] resources;
    private int currentResourceIndex = -1;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"The 'delegate' may not be null");
        Assert.notNull((Object)this.resources, (String)"The 'resources' may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        Object object = MONITOR;
        synchronized (object) {
            if (this.currentResourceIndex == -1) {
                this.openNextAvailableResource();
            }
            Object item = this.delegate.read();
            while (true) {
                if (item != null) {
                    return (T)item;
                }
                this.openNextAvailableResource();
                if (this.currentResourceIndex >= this.getResources().length) {
                    return null;
                }
                item = this.delegate.read();
            }
        }
    }

    public void close() throws ItemStreamException {
        this.delegate.close();
        this.currentResourceIndex = -1;
    }

    public void open(ExecutionContext ctx) throws ItemStreamException {
    }

    public void update(ExecutionContext ctx) throws ItemStreamException {
    }

    public Resource getCurrentResource() {
        if (this.currentResourceIndex >= this.getResources().length) {
            return null;
        }
        return this.getResources()[this.currentResourceIndex];
    }

    private void openNextAvailableResource() throws Exception {
        ++this.currentResourceIndex;
        if (this.currentResourceIndex >= this.getResources().length) {
            return;
        }
        this.delegate.close();
        this.delegate.setResource(this.getResources()[this.currentResourceIndex]);
        this.getDelegate().open(new ExecutionContext());
        LOGGER.info("Opened Resource {} for read. Resource Index, Resource Length is : [" + this.currentResourceIndex + "," + this.getResources().length + "]", (Object)this.getResources()[this.currentResourceIndex]);
    }

    public ResourceAwareItemReaderItemStream<? extends T> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ResourceAwareItemReaderItemStream<? extends T> delegate) {
        this.delegate = delegate;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }
}

