/*
 * Decompiled with CFR 0.152.
 */
package org.sift.batch.tag;

import java.util.List;
import org.sift.tagcloud.Tag;
import org.sift.tagcloud.TagCloud;
import org.sift.tagcloud.spi.service.PersistenceService;
import org.sift.tagcloud.ui.DisplayTag;
import org.sift.tagcloud.ui.DisplayTagCloud;
import org.springframework.batch.item.ItemWriter;

public class TagCloudWriter<T extends Tag, S extends TagCloud<T>>
implements ItemWriter<DisplayTagCloud<DisplayTag>> {
    private List<PersistenceService<T, S>> persistenceServices;

    public void write(List<? extends DisplayTagCloud<DisplayTag>> tagClouds) throws Exception {
        for (DisplayTagCloud<DisplayTag> displayTagCloud : tagClouds) {
            for (PersistenceService<T, S> persistenceService : this.persistenceServices) {
                persistenceService.persistTagCloud(displayTagCloud);
            }
        }
    }

    public List<PersistenceService<T, S>> getPersistenceServices() {
        return this.persistenceServices;
    }

    public void setPersistenceServices(List<PersistenceService<T, S>> persistenceServices) {
        this.persistenceServices = persistenceServices;
    }
}

