;; Copyright (c) 2008,2009 Lau B. Jensen <lau.jensen {at} bestinclass.dk
;;                         Meikel Brandmeyer <mb {at} kotka.de>
;; All rights reserved.
;;
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file LICENSE.txt at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by the
;; terms of this license. You must not remove this notice, or any other, from
;; this software.

(clojure.core/ns clojureql.backend.postgres
  (:require
     [clojureql :as cql]
     [clojureql.util :as util]))

(defmethod cql/compile-sql
  [::cql/CreateTable org.postgresql.PGConnection]
  [stmt db]
  (cql/with-table-options stmt
    (str "CREATE TABLE " table " ("
      (util/str-cat ","
        (concat
          (map (fn [[column col-type]]
                 (str column " "
                      (cql/standard-column
                       (if (contains? auto-inc column)
                         "SERIAL"
                         col-type)
                       :not-null (and (contains? non-nulls column)
                                      (not (contains? auto-inc  column)))
                       :default (get defaults column))))
               columns)
          (cql/standard-table-constraints
            primary-key
            uniques
            checks
            foreign-key)))
      ")")))

(prefer-method cql/compile-sql
               [::cql/CreateTable org.postgresql.PGConnection]
               [::cql/CreateTable ::cql/Generic])

(defmethod cql/compile-sql-alter [::cql/Rename org.postgresql.PGConnection]
  [stmt _]
  (let [{:keys [options table]} stmt]
    (util/str-cat " "
      ["ALTER TABLE" table "RENAME"
        (if (= 'column (first options))
          (str (options 1) " TO " (options 2))
          (str "TO " (first options)))])))

(prefer-method cql/compile-sql-alter
               [::cql/Rename org.postgresql.PGConnection]
               [::cql/Rename ::cql/Generic])
