(ns wolframite.wolfram "[GENERATED - see `...wolfram-syms.write-ns/write-ns!`]\n           Vars for all Wolfram functions (and their Clojurite aliases, where those exist).\n          These can be composed into expressions and passed to `wl/!`.\n\n          BEWARE: This is based off a particular version of Wolfram and you may need to refresh it." (:require wolframite.impl.wolfram-syms.intern clojure.walk) (:refer-clojure :only [ns-unmap map let defmacro list]))
(do (clojure.core/ns-unmap clojure.core/*ns* (quote Byte)) (clojure.core/ns-unmap clojure.core/*ns* (quote Character)) (clojure.core/ns-unmap clojure.core/*ns* (quote Integer)) (clojure.core/ns-unmap clojure.core/*ns* (quote Number)) (clojure.core/ns-unmap clojure.core/*ns* (quote Short)) (clojure.core/ns-unmap clojure.core/*ns* (quote String)) (clojure.core/ns-unmap clojure.core/*ns* (quote Thread)))
(def ^:dynamic *wolfram-version* 14.0)
(def ^:dynamic *wolfram-kernel-name* "Mathematica 14.0.0 Kernel")
(def $Aborted "$Aborted is a special symbol that is returned as the result from a calculation that has been aborted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Aborted)))
(def $ActivationKey "$ActivationKey is a string that gives the activation key under which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ActivationKey)))
(def $AllowDataUpdates "$AllowDataUpdates controls whether the Wolfram System is allowed to automatically update certain types of content." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AllowDataUpdates)))
(def $AllowExternalChannelFunctions "$AllowExternalChannelFunctions specifies whether to allow interaction with channels that contain functions that might be executed in your session in response to events on the channel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AllowExternalChannelFunctions)))
(def $AllowInternet "$AllowInternet controls whether the Wolfram System is allowed to access the internet." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AllowInternet)))
(def $AssertFunction "$AssertFunction specifies a function to apply to assertions that fail." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AssertFunction)))
(def $Assumptions "$Assumptions is the default setting for the Assumptions option used in such functions as Simplify, Refine, and Integrate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Assumptions)))
(def $AudioDecoders "$AudioDecoders gives the list of audio decoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AudioDecoders)))
(def $AudioEncoders "$AudioEncoders gives the list of audio encoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AudioEncoders)))
(def $AudioInputDevices "$AudioInputDevices gives the list of available audio input devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AudioInputDevices)))
(def $AudioOutputDevices "$AudioOutputDevices gives the list of available audio output devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $AudioOutputDevices)))
(def $BaseDirectory "$BaseDirectory gives the base directory in which systemwide files to be loaded by the Wolfram System are conventionally placed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $BaseDirectory)))
(def $BasePacletsDirectory "$BasePacletsDirectory gives the base directory that the Wolfram System uses to find paclets that can be seen by all users on the system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $BasePacletsDirectory)))
(def $BatchInput "$BatchInput is True if input in the current session is being fed directly to the Wolfram Language kernel in batch mode." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $BatchInput)))
(def $BatchOutput "$BatchOutput is True if output in the current session is being sent in batch mode, suitable for reading by other programs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $BatchOutput)))
(def $BlockchainBase "$BlockchainBase gives the name of the default blockchain to be used for blockchain computations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $BlockchainBase)))
(def $ByteOrdering "$ByteOrdering gives the native ordering of bytes in binary data on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ByteOrdering)))
(def $CacheBaseDirectory "$CacheBaseDirectory is the directory on your local file system used for storing cache data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CacheBaseDirectory)))
(def $Canceled "$Canceled is a symbol returned when notebook input is canceled, for example from a dialog box." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Canceled)))
(def $ChannelBase "$ChannelBase gives the base URL of the server to use for brokering channel communications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ChannelBase)))
(def $CharacterEncoding "$CharacterEncoding specifies the default raw character encoding to use for input and output functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CharacterEncoding)))
(def $CharacterEncodings "$CharacterEncodings gives the list of character encodings that can be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CharacterEncodings)))
(def $CloudAccountName "$CloudAccountName gives the name assigned to the cloud account of a currently logged-in user or the user who owns a cloud object containing the code used for the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudAccountName)))
(def $CloudBase "$CloudBase gives the base URI of the server to use for cloud operations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudBase)))
(def $CloudConnected "$CloudConnected gives True if an authenticated connection to the Wolfram Cloud has been set up, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudConnected)))
(def $CloudCreditsAvailable "$CloudCreditsAvailable gives the total number of cloud credits currently available in the cloud account being used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudCreditsAvailable)))
(def $CloudEvaluation "$CloudEvaluation gives True if the current evaluation is occurring in the cloud, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudEvaluation)))
(def $CloudExpressionBase "$CloudExpressionBase gives the base URI used for storing cloud expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudExpressionBase)))
(def $CloudObjectNameFormat "$CloudObjectNameFormat is the default setting used for the CloudObjectNameFormat option when constructing a CloudObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudObjectNameFormat)))
(def $CloudObjectURLType "$CloudObjectURLType is the default setting for the CloudObjectURLType option when constructing a CloudObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudObjectURLType)))
(def $CloudRootDirectory "$CloudRootDirectory is the cloud object corresponding to the root directory for the file structure in which the current user's cloud objects are stored." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudRootDirectory)))
(def $CloudSymbolBase "$CloudSymbolBase gives the base for storing the values of CloudSymbol objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudSymbolBase)))
(def $CloudUserID "$CloudUserID gives the cloud user ID of a currently logged-in user, or the user who owns a cloud object containing the code used for the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudUserID)))
(def $CloudUserUUID "$CloudUserUUID gives the cloud UUID of a currently logged-in user, or the user who owns a cloud object containing the code used for the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudUserUUID)))
(def $CloudVersion "$CloudVersion gives the version of the currently connected cloud server." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CloudVersion)))
(def $CommandLine "$CommandLine is a list of strings giving the elements of the original operating system command line with which the current instantiation of the Wolfram Language was invoked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CommandLine)))
(def $CompilationTarget "$CompilationTarget gives the default value for the option CompilationTarget of Compile." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CompilationTarget)))
(def $CompilerEnvironment "$CompilerEnvironment is the collection of definitions typically used by FunctionCompile and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CompilerEnvironment)))
(def $ConfiguredKernels "$ConfiguredKernels is the list of kernels that are configured to be selected for remote or parallel computing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ConfiguredKernels)))
(def $Context "$Context is a global variable that gives the current context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Context)))
(def $ContextAliases "$ContextAliases is a global variable that gives an association with mappings from aliases to contexts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ContextAliases)))
(def $ContextPath "$ContextPath is a global variable that gives a list of contexts to search, before $Context, in trying to find a symbol that has been entered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ContextPath)))
(def $ControlActiveSetting "$ControlActiveSetting is a symbol whose value is True if it is evaluated while a control is active, or in certain other previewing situations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ControlActiveSetting)))
(def $CookieStore "$CookieStore gives the location at which to store information on persistent cookies to be used by URLRead and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CookieStore)))
(def $Cookies "$Cookies is a global variable that contains a list of cookies to be used by functions such as URLExecute." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Cookies)))
(def $CreationDate "$CreationDate gives the date at which the particular release of the Wolfram Language kernel you are running was created." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CreationDate)))
(def $CryptographicEllipticCurveNames "$CryptographicEllipticCurveNames gives a list of the elliptic curves supported for key generation and digital signatures." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CryptographicEllipticCurveNames)))
(def $CurrentLink "$CurrentLink is the LinkObject representing the WSTP connection for an external program currently being installed or being called." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CurrentLink)))
(def $CurrentTask "$CurrentTask gives the TaskObject[…] corresponding to the task in which it is being evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CurrentTask)))
(def $CurrentWebSession "$CurrentWebSession gives the currently active web session used by WebExecute." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $CurrentWebSession)))
(def $DataStructures "$DataStructures gives a list of the currently available data structure types for the CreateDataStructure function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DataStructures)))
(def $DateStringFormat "$DateStringFormat gives the default format to use for date strings generated by DateString." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DateStringFormat)))
(def $DefaultAudioInputDevice "$DefaultAudioInputDevice gives the name of the default audio input device attached to the computer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultAudioInputDevice)))
(def $DefaultAudioOutputDevice "$DefaultAudioOutputDevice gives the name of the default audio output device attached to the computer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultAudioOutputDevice)))
(def $DefaultFrontEnd "$DefaultFrontEnd is a global symbol that can be queried for the factory-default front end option values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultFrontEnd)))
(def $DefaultImagingDevice "$DefaultImagingDevice gives the name of the default imaging device attached to the computer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultImagingDevice)))
(def $DefaultLocalBase "$DefaultLocalBase gives the default base directory to use for local object storage." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultLocalBase)))
(def $DefaultLocalKernel "$DefaultLocalKernel gives the kernel configuration corresponding to the default kernel to be used by LocalEvaluate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultLocalKernel)))
(def $DefaultNetworkInterface "$DefaultNetworkInterface gives the default network interface used on your machine." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultNetworkInterface)))
(def $DefaultParallelKernels "$DefaultParallelKernels is the list of kernels that are configured for parallel computing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultParallelKernels)))
(def $DefaultProxyRules "$DefaultProxyRules gives the proxy settings used by the Wolfram System when accessing the network.\n$DefaultProxyRules[\"prop\"]=value sets the value of a proxy setting." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultProxyRules)))
(def $DefaultRemoteBatchSubmissionEnvironment "$DefaultRemoteBatchSubmissionEnvironment gives the default environment to which remote batch jobs will be submitted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultRemoteBatchSubmissionEnvironment)))
(def $DefaultRemoteKernel "$DefaultRemoteKernel gives the kernel configuration corresponding to the default remote kernel to be used by RemoteEvaluate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultRemoteKernel)))
(def $DefaultSystemCredentialStore "$DefaultSystemCredentialStore gives the default credential store settings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DefaultSystemCredentialStore)))
(def $Display "$Display gives a list of files and pipes to be used with the default $DisplayFunction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Display)))
(def $DisplayFunction "$DisplayFunction gives the default setting for the option DisplayFunction in graphics functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DisplayFunction)))
(def $DistributedContexts "$DistributedContexts is the default value of the DistributedContexts option of functions such as ParallelTable and ParallelMap." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DistributedContexts)))
(def $DistributedDefinitions "$DistributedDefinitions gives the list of all symbols whose definitions have been distributed to parallel kernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DistributedDefinitions)))
(def $DynamicEvaluation "$DynamicEvaluation is a symbol whose value is True if it is evaluated as part of the evaluation of a Dynamic." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $DynamicEvaluation)))
(def $Echo "$Echo gives a list of files and pipes to which all input is echoed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Echo)))
(def $EmbedCodeEnvironments "$EmbedCodeEnvironments gives a list of environments currently supported by EmbedCode in your Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $EmbedCodeEnvironments)))
(def $EmbeddableServices "$EmbeddableServices gives a list of external embeddable services that can be accessed through EmbeddedService." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $EmbeddableServices)))
(def $Epilog "$Epilog is a symbol whose value, if any, is evaluated when a dialog or a Wolfram System session is terminated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Epilog)))
(def $EvaluationCloudBase "$EvaluationCloudBase gives the base URI of the cloud server on which the current evaluation is being done." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $EvaluationCloudBase)))
(def $EvaluationCloudObject "$EvaluationCloudObject gives the cloud object containing the code currently being executed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $EvaluationCloudObject)))
(def $EvaluationEnvironment "$EvaluationEnvironment gives a string indicating the type of local or cloud environment in which the current Wolfram Language evaluation is being performed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $EvaluationEnvironment)))
(def $ExportFormats "$ExportFormats gives a list of export formats currently supported in your Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ExportFormats)))
(def $ExternalIdentifierTypes "$ExternalIdentifierTypes gives a list of types available to ExternalIdentifier." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ExternalIdentifierTypes)))
(def $ExternalStorageBase "$ExternalStorageBase gives the name of the default external storage service to be used for external storage operations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ExternalStorageBase)))
(def $Failed "$Failed is a special symbol returned by certain functions when they cannot do what they were asked to do." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Failed)))
(def $FontFamilies "$FontFamilies gives the list of the font families available to the Wolfram System." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $FontFamilies)))
(def $FrontEnd "$FrontEnd is a global variable that specifies to what front end object, if any, the kernel is currently connected." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $FrontEnd)))
(def $FrontEndSession "$FrontEndSession is a global symbol that represents the current session of the front end from which the kernel is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $FrontEndSession)))
(def $GeneratedAssetLocation "$GeneratedAssetLocation gives the default setting for GeneratedAssetLocation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $GeneratedAssetLocation)))
(def $GeoLocation "$GeoLocation is a settable global variable that specifies the default geodetic location to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $GeoLocation)))
(def $GeoLocationCity "$GeoLocationCity gives the city entity for the current setting for $GeoLocation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $GeoLocationCity)))
(def $GeoLocationCountry "$GeoLocationCountry gives the country entity for the current setting for $GeoLocation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $GeoLocationCountry)))
(def $GeoLocationSource "$GeoLocationSource is a string giving the source of the current geodetic location." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $GeoLocationSource)))
(def $HistoryLength "$HistoryLength specifies the number of previous lines of input and output to keep in a Wolfram System session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $HistoryLength)))
(def $HomeDirectory "$HomeDirectory gives your \"home\" directory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $HomeDirectory)))
(def $IgnoreEOF "$IgnoreEOF specifies whether the Wolfram System should terminate when it receives an end‐of‐file character as input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $IgnoreEOF)))
(def $ImageFormattingWidth "$ImageFormattingWidth gives the default target width at which to wrap when formatting objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ImageFormattingWidth)))
(def $ImageResolution "$ImageResolution gives the default image resolution to use when rasterizing to create images." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ImageResolution)))
(def $ImagingDevice "$ImagingDevice gives the name of the imaging device used to capture images." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ImagingDevice)))
(def $ImagingDevices "$ImagingDevices gives a list of available imaging devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ImagingDevices)))
(def $ImportFormats "$ImportFormats gives a list of import formats currently supported in your Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ImportFormats)))
(def $IncomingMailSettings "$IncomingMailSettings gives the default settings used by MailServerConnect to connect to an incoming mail server." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $IncomingMailSettings)))
(def $InitialDirectory "$InitialDirectory gives the initial directory when the current Wolfram System session was started." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InitialDirectory)))
(def $Initialization "$Initialization is a symbol whose value, if any, is evaluated with ReleaseHold[$Initialization] at the start of a Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Initialization)))
(def $InitializationContexts "$InitializationContexts is a symbol whose value, if any, specifies a list of packages to read with Needs at the start of a Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InitializationContexts)))
(def $Input "$Input is a global variable whose value is the name of the stream from which input to the Wolfram Language is currently being sought." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Input)))
(def $InputFileName "$InputFileName is a global variable whose value is the absolute file name of the input file from which input to the Wolfram Language is currently being sought." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InputFileName)))
(def $InputStreamMethods "$InputStreamMethods gives the list of input stream methods that can be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InputStreamMethods)))
(def $Inspector "$Inspector is a global variable which gives a function to apply when the inspector is invoked from an interrupt menu." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Inspector)))
(def $InstallationDirectory "$InstallationDirectory gives the top‐level directory in which your Wolfram System installation resides." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InstallationDirectory)))
(def $InterpreterTypes "$InterpreterTypes gives a list of the currently available types for the Interpreter function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $InterpreterTypes)))
(def $IterationLimit "$IterationLimit gives the maximum length of evaluation chain used in trying to evaluate any expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $IterationLimit)))
(def $KernelCount "$KernelCount gives the number of subkernels available for parallel computations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $KernelCount)))
(def $KernelID "$KernelID is a unique ID number assigned to each running parallel kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $KernelID)))
(def $LLMEvaluator "$LLMEvaluator is the default LLMConfiguration used by functions such as LLMSynthesize." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LLMEvaluator)))
(def $Language "$Language is a settable global variable that specifies the default language used by the Wolfram System." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Language)))
(def $LibraryPath "$LibraryPath gives the default list of directories to search in attempting to find a library." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LibraryPath)))
(def $LicenseExpirationDate "$LicenseExpirationDate gives the expiration date for the license under which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LicenseExpirationDate)))
(def $LicenseID "$LicenseID is a string that gives the license ID under which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LicenseID)))
(def $LicenseServer "$LicenseServer is a string that gives the name of the license server that is currently authorizing the Wolfram System to be run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LicenseServer)))
(def $Line "$Line is a global variable that specifies the number of the current input line." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Line)))
(def $Linked "$Linked is True if the Wolfram Language kernel is being run through WSTP." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Linked)))
(def $LocalBase "$LocalBase gives the base directory to use for local object storage." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LocalBase)))
(def $LocalSymbolBase "$LocalSymbolBase gives the base directory for storing values of LocalSymbol objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $LocalSymbolBase)))
(def $MachineAddresses "$MachineAddresses gives a list of strings specifying the current IP addresses associated with the computer on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineAddresses)))
(def $MachineDomains "$MachineDomains is a list of strings giving the names of the current network domains associated with the computer on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineDomains)))
(def $MachineEpsilon "$MachineEpsilon gives the difference between 1.0 and the next-nearest number representable as a machine-precision number." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineEpsilon)))
(def $MachineID "$MachineID is a string that gives, if possible, a unique identification code for the computer on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineID)))
(def $MachineName "$MachineName is a string that gives the assigned name of the computer on which the Wolfram System is being run, if such a name is defined." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineName)))
(def $MachinePrecision "$MachinePrecision gives the number of decimal digits of precision used for machine‐precision numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachinePrecision)))
(def $MachineType "$MachineType is a string giving the general type of computer on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MachineType)))
(def $MaxDisplayedChildren "$MaxDisplayedChildren is a global variable whose value specifies the maximum number of children that should be displayed in Tree objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxDisplayedChildren)))
(def $MaxExtraPrecision "$MaxExtraPrecision gives the maximum number of extra digits of precision to be used in functions such as N." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxExtraPrecision)))
(def $MaxMachineNumber "$MaxMachineNumber is the largest machine‐precision number that can be used on a particular computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxMachineNumber)))
(def $MaxNumber "$MaxNumber gives the maximum arbitrary‐precision number that can be represented on a particular computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxNumber)))
(def $MaxPiecewiseCases "$MaxPiecewiseCases gives the maximum number of cases to allow in explicit Piecewise objects generated by expanding any single piecewise function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxPiecewiseCases)))
(def $MaxPrecision "$MaxPrecision gives the maximum number of digits of precision to be allowed in arbitrary‐precision numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxPrecision)))
(def $MaxRootDegree "$MaxRootDegree specifies the maximum degree of polynomial to allow in Root objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MaxRootDegree)))
(def $MessageGroups "$MessageGroups is the list of rules that gives named message groups used in functions like On and Quiet." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MessageGroups)))
(def $MessageList "$MessageList is a global variable that gives a list of the names of messages generated during the evaluation of the current input line." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MessageList)))
(def $MessagePrePrint "$MessagePrePrint is a global variable whose value, if set, is applied to expressions before they are included in the text of messages." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MessagePrePrint)))
(def $Messages "$Messages gives the list of files and pipes to which message output is sent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Messages)))
(def $MinMachineNumber "$MinMachineNumber is the smallest positive machine‐precision number that can be represented in normalized form on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MinMachineNumber)))
(def $MinNumber "$MinNumber gives the minimum positive arbitrary‐precision number that can be represented on a particular computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MinNumber)))
(def $MinPrecision "$MinPrecision gives the minimum number of digits of precision to be allowed in arbitrary‐precision numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MinPrecision)))
(def $MobilePhone "$MobilePhone gives the verified mobile phone number associated with the current user account." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $MobilePhone)))
(def $ModuleNumber "$ModuleNumber gives the current serial number to be used for local variables that are created." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ModuleNumber)))
(def $NetworkConnected "$NetworkConnected gives True if your computer has a network interface that is active and capable of sending and receiving IP traffic, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NetworkConnected)))
(def $NetworkInterfaces "$NetworkInterfaces gives the list of network interfaces available on your machine." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NetworkInterfaces)))
(def $NewMessage "$NewMessage is a global variable that, if set, is applied to the symbol name and tag of messages that are requested but have not yet been defined." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NewMessage)))
(def $NewSymbol "$NewSymbol is a global variable which, if set, is applied to the name and context of each new symbol that the Wolfram Language creates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NewSymbol)))
(def $NoValue "$NoValue is a special value that can be assigned to an InitializationValue[…] object to indicate that the symbol referenced by the initialization value should be initialized with no value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NoValue)))
(def $NotebookInlineStorageLimit "$NotebookInlineStorageLimit specifies the maximum size in bytes of expressions that will be stored in displayed summary boxes, datasets and other compact outputs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NotebookInlineStorageLimit)))
(def $Notebooks "$Notebooks is True if the Wolfram System is being used with a notebook‐based front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Notebooks)))
(def $NumberMarks "$NumberMarks gives the default value for the option NumberMarks, which specifies whether ` marks should be included in the input form representations of approximate numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $NumberMarks)))
(def $OperatingSystem "$OperatingSystem is a string giving the type of operating system under which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $OperatingSystem)))
(def $Output "$Output gives the list of files and pipes to which standard output from the Wolfram Language is sent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Output)))
(def $OutputSizeLimit "$OutputSizeLimit specifies the maximum size in bytes of expressions that will automatically be output in their entirety in a Wolfram System notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $OutputSizeLimit)))
(def $OutputStreamMethods "$OutputStreamMethods gives the list of output stream methods that can be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $OutputStreamMethods)))
(def $Packages "$Packages gives a list of the contexts corresponding to all packages that have been loaded in your current Wolfram System session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Packages)))
(def $ParentLink "$ParentLink is the WSTP LinkObject currently used for input and output by the Wolfram Language kernel in a particular session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ParentLink)))
(def $ParentProcessID "$ParentProcessID gives the ID assigned to the process which invokes the Wolfram Language kernel by the operating system under which it is run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ParentProcessID)))
(def $PasswordFile "$PasswordFile is a string giving the password file used when the kernel was started." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PasswordFile)))
(def $Path "$Path gives the default list of directories to search in attempting to find an external file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Path)))
(def $PathnameSeparator "$PathnameSeparator is a string used as a separator when full file and directory names are constructed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PathnameSeparator)))
(def $PerformanceGoal "$PerformanceGoal gives the default setting for the option PerformanceGoal for graphics and other algorithmic functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PerformanceGoal)))
(def $Permissions "$Permissions is the default setting used for the Permissions option when cloud objects are created." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Permissions)))
(def $PersistenceBase "$PersistenceBase gives the default persistence location at which to store new values assigned to PersistentSymbol objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PersistenceBase)))
(def $PersistencePath "$PersistencePath gives the default list of persistence locations at which to look for values assigned to PersistentSymbol objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PersistencePath)))
(def $PlotTheme "$PlotTheme gives the default setting for the option PlotTheme for graphics functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PlotTheme)))
(def $Post "$Post is a global variable whose value, if set, is applied to every output expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Post)))
(def $Pre "$Pre is a global variable whose value, if set, is applied to every input expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Pre)))
(def $PreInitialization "$PreInitialization is a symbol whose value, if any, is evaluated with ReleaseHold[$PreInitialization] before any other initializations in a Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PreInitialization)))
(def $PrePrint "$PrePrint is a global variable whose value, if set, is applied to every expression before it is printed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PrePrint)))
(def $PreRead "$PreRead is a global variable whose value, if set, is applied to the text or box form of every input expression before it is fed to the Wolfram Language." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PreRead)))
(def $Printout3DPreviewer "$Printout3DPreviewer gives the default setting for the option Printout3DPreviewer in 3D printing functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Printout3DPreviewer)))
(def $ProcessID "$ProcessID gives the ID assigned to the Wolfram Language kernel process by the operating system under which it is run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ProcessID)))
(def $ProcessorCount "$ProcessorCount gives the number of processor cores available on the computer system on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ProcessorCount)))
(def $ProcessorType "$ProcessorType is a string giving the architecture of the processor on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ProcessorType)))
(def $ProgressReporting "$ProgressReporting is a settable global variable that specifies the default progress reporting method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ProgressReporting)))
(def $PublisherID "$PublisherID gives the default ID used to submit resources for publication in the resource system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $PublisherID)))
(def $RandomGeneratorState "$RandomGeneratorState gives a representation of the internal state of the default pseudorandom generator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RandomGeneratorState)))
(def $RecursionLimit "$RecursionLimit gives the current limit on the number of levels of recursion that the Wolfram Language can use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RecursionLimit)))
(def $ReleaseNumber "$ReleaseNumber is an integer which gives the current Wolfram Language kernel release number, and increases in successive releases." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ReleaseNumber)))
(def $RequesterAddress "$RequesterAddress gives the IP address originating an HTTP request that initiated the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RequesterAddress)))
(def $RequesterCloudUserID "$RequesterCloudUserID gives the cloud user ID of the authenticated user requesting the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RequesterCloudUserID)))
(def $RequesterCloudUserUUID "$RequesterCloudUserUUID gives the cloud user UUID of an authenticated user requesting the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RequesterCloudUserUUID)))
(def $RequesterWolframID "$RequesterWolframID gives the Wolfram ID of an authenticated user requesting the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RequesterWolframID)))
(def $RequesterWolframUUID "$RequesterWolframUUID gives the Wolfram UUID of an authenticated user requesting the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RequesterWolframUUID)))
(def $ResourceSystemBase "$ResourceSystemBase gives the base URI for the resource system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ResourceSystemBase)))
(def $ResourceSystemPath "$ResourceSystemPath gives the default list of locations at which to look for resource objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ResourceSystemPath)))
(def $RootDirectory "$RootDirectory gives the root directory of your file system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $RootDirectory)))
(def $SSHAuthentication "$SSHAuthentication specifies the default authentication options to use for SSH-related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SSHAuthentication)))
(def $ScriptCommandLine "$ScriptCommandLine is a list of strings giving the elements of the command line with which the standalone Wolfram System script was invoked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ScriptCommandLine)))
(def $ScriptInputString "$ScriptInputString represents input given on the standard input channel to the original operating system command with which the current instantiation of the Wolfram Language was invoked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ScriptInputString)))
(def $ServiceCreditsAvailable "$ServiceCreditsAvailable gives the available Service Credits in the user's account." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $ServiceCreditsAvailable)))
(def $Services "$Services gives a list of external services available through ServiceConnect." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Services)))
(def $SessionID "$SessionID is a number set up to be unique to a particular Wolfram System session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SessionID)))
(def $SharedFunctions "$SharedFunctions is the list of functions currently being shared among parallel kernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SharedFunctions)))
(def $SharedVariables "$SharedVariables is the list of variables currently being shared among parallel kernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SharedVariables)))
(def $SoundDisplayFunction "$SoundDisplayFunction gives the default setting for the option DisplayFunction in sound functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SoundDisplayFunction)))
(def $SourceLink "$SourceLink specifies the default source to be used for deployed cloud objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SourceLink)))
(def $StandardErrorStream "$StandardErrorStream gives the output stream object to which standard error from the Wolfram Language is sent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $StandardErrorStream)))
(def $StandardOutputStream "$StandardOutputStream gives the output stream object to which standard output from the Wolfram Language is sent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $StandardOutputStream)))
(def $SubtitleDecoders "$SubtitleDecoders gives the list of subtitle decoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SubtitleDecoders)))
(def $SubtitleEncoders "$SubtitleEncoders gives the list of subtitle encoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SubtitleEncoders)))
(def $SynchronousEvaluation "$SynchronousEvaluation is a symbol whose value is True if it is evaluated as part of a synchronous evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SynchronousEvaluation)))
(def $SyntaxHandler "$SyntaxHandler is a global variable that, if set, is applied to any input string that is found to contain a syntax error." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SyntaxHandler)))
(def $System "$System is a string describing the type of computer system on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $System)))
(def $SystemCharacterEncoding "$SystemCharacterEncoding gives the default raw character encoding for the computer system on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemCharacterEncoding)))
(def $SystemCredentialStore "$SystemCredentialStore gives the current credential store." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemCredentialStore)))
(def $SystemID "$SystemID is a short string that identifies the type of computer system on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemID)))
(def $SystemShell "$SystemShell is a symbol that specifies the system shell for the OS that is currently being used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemShell)))
(def $SystemTimeZone "$SystemTimeZone gives the current time zone for the computer system on which the Wolfram System is being run." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemTimeZone)))
(def $SystemWordLength "$SystemWordLength gives the effective number of bits in raw machine words on the computer system where the Wolfram System is running." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $SystemWordLength)))
(def $TargetSystems "$TargetSystems gives the list of possible machine architectures for code generation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TargetSystems)))
(def $TemplatePath "$TemplatePath gives the default list of directories to search in attempting to find a template file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TemplatePath)))
(def $TemporaryDirectory "$TemporaryDirectory gives the main system directory for temporary files on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TemporaryDirectory)))
(def $TestFileName "$TestFileName gives the absolute file name of the currently executing test file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TestFileName)))
(def $TimeUnit "$TimeUnit gives the minimum time interval in seconds recorded on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TimeUnit)))
(def $TimeZone "$TimeZone gives the current time zone to assume for dates and times." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TimeZone)))
(def $TimeZoneEntity "$TimeZoneEntity gives the time zone Entity corresponding to the locale setting for your computer operating system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TimeZoneEntity)))
(def $TimedOut "$TimedOut is a special symbol returned by certain functions when an operation times out." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $TimedOut)))
(def $UnitSystem "$UnitSystem gives the unit system to assume for returned quantities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UnitSystem)))
(def $Urgent "$Urgent gives the list of files and pipes to which urgent output from the Wolfram Language is sent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Urgent)))
(def $UserAgent "$UserAgent gives the user agent information from an HTTP request that initiated the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserAgent)))
(def $UserAgentString "$UserAgentString gives the user agent string from an HTTP request that initiated the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserAgentString)))
(def $UserBaseDirectory "$UserBaseDirectory gives the base directory in which user‐specific files to be loaded by the Wolfram System are conventionally placed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserBaseDirectory)))
(def $UserBasePacletsDirectory "$UserBasePacletsDirectory gives the base directory that the Wolfram System uses to store user-specific installed paclets and paclet configuration data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserBasePacletsDirectory)))
(def $UserDocumentsDirectory "$UserDocumentsDirectory gives your default \"documents\" directory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserDocumentsDirectory)))
(def $UserURLBase "$UserURLBase gives the user identification element to be inserted in the URLs of cloud objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $UserURLBase)))
(def $Username "$Username gives the login name of the user who invoked the Wolfram Language kernel, as recorded by the operating system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Username)))
(def $Version "$Version is a string that gives the version of the Wolfram Language kernel you are running." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $Version)))
(def $VersionNumber "$VersionNumber is a real number which gives the current Wolfram Language kernel version number, and increases in successive versions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $VersionNumber)))
(def $VideoDecoders "$VideoDecoders gives the list of video decoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $VideoDecoders)))
(def $VideoEncoders "$VideoEncoders gives the list of available video encoders available for each video container." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $VideoEncoders)))
(def $VoiceStyles "$VoiceStyles gives the list of available voices for speech synthesis." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $VoiceStyles)))
(def $WolframDocumentsDirectory "$WolframDocumentsDirectory gives the Wolfram subdirectory of the user's \"documents\" directory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $WolframDocumentsDirectory)))
(def $WolframID "$WolframID gives the Wolfram ID of a currently logged-in user, or the user who owns a cloud object containing the code used for the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $WolframID)))
(def $WolframUUID "$WolframUUID gives the Wolfram UUID of a currently logged-in user, or the user who owns a cloud object containing the code used for the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote $WolframUUID)))
(def AASTriangle "AASTriangle[α, β, a] returns a filled triangle with angles α and β and side length a, where a is adjacent to one angle only." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AASTriangle)))
(def APIFunction "APIFunction[{name1type1, name2type2, …}, fun] represents an API with parameters namei that evaluates the function fun whenever it is called. The function fun is applied to name1val1, name2val2, …, where the vali are the settings for the parameters, interpreted as being of types typei.\nAPIFunction[{name1type1default1, …}, fun] takes the value of the parameter namei to be defaulti if it is not specified when the API is called.\nAPIFunction[params, fun, fmt] specifies that the result from applying fun should be returned in format fmt.\nAPIFunction[params, fun, {fmt, rform}] specifies that the result should be returned as a response of the form rform.\nAPIFunction[params, fun, {fmt, rform, failfmt}] specifies that in the event of failure, the result should be returned in format failfmt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote APIFunction)))
(def ARCHProcess "ARCHProcess[κ, {α1, …, αq}] represents an autoregressive conditionally heteroscedastic process of order q, driven by a standard white noise.\nARCHProcess[κ, {α1, …, αq}, init] represents an ARCH process with initial data init." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ARCHProcess)))
(def ARIMAProcess "ARIMAProcess[{a1, …, ap}, d, {b1, …, bq}, v] represents an autoregressive integrated moving-average process y(t) such that its d ^th difference is a weakly stationary ARMAProcess[{a1, …, ap}, {b1, …, bq}, v].\nARIMAProcess[{a1, …, ap}, d, {b1, …, bq}, Σ] represents a vector ARIMA process (y1(t), … , yn(t)) such that its (d, …, d)^th difference is a vector weakly stationary ARMAProcess.\nARIMAProcess[{a1, …, ap}, {d1, …, dn}, {b1, …, bq}, Σ] represents a vector ARIMA process (y1(t), … , yn(t)) such that its (d1, …, dn)^th difference is a vector weakly stationary ARMAProcess.\nARIMAProcess[{a1, …, ap}, d, {b1, …, bq}, v, init] represents an ARIMA process with initial data init. \nARIMAProcess[c, …] represents an ARIMA process with a constant c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ARIMAProcess)))
(def ARMAProcess "ARMAProcess[{a1, …, ap}, {b1, …, bq}, v] represents a weakly stationary autoregressive moving-average process with AR coefficients ai, MA coefficients bj, and normal white noise variance v.\nARMAProcess[{a1, …, ap}, {b1, …, bq}, Σ] represents a weakly stationary vector ARMA process with coefficient matrices ai and bj and covariance matrix Σ. \nARMAProcess[{a1, …, ap}, {b1, …, bq}, v, init] represents an ARMA process with initial data init. \nARMAProcess[c, …] represents an ARMA process with a constant c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ARMAProcess)))
(def ARProcess "ARProcess[{a1, …, ap}, v] represents a weakly stationary autoregressive process of order p with normal white noise variance v.\nARProcess[{a1, …, ap}, Σ] represents a weakly stationary vector AR process with multinormal white noise covariance matrix Σ.\nARProcess[{a1, …, ap}, v, init] represents an AR process with initial data init. \nARProcess[c, …] represents an AR process with a constant c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ARProcess)))
(def ARPublish "ARPublish[expr] publish expr to an AR device.\nARPublish[{expr1, expr2, …}] display expri in a browsable gallery layout." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ARPublish)))
(def ASATriangle "ASATriangle[α, c, β] returns a filled triangle with angles α and β and side length c, and c is adjacent to both angles." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ASATriangle)))
(def AbelianGroup "AbelianGroup[{n1, n2, …}] represents the direct product of the cyclic groups of degrees n1, n2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbelianGroup)))
(def Abort "Abort[] generates an interrupt to abort a computation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Abort)))
(def AbortKernels "AbortKernels[] aborts evaluations running in all parallel subkernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbortKernels)))
(def AbortProtect "AbortProtect[expr] evaluates expr, saving any aborts until the evaluation is complete." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbortProtect)))
(def Above "Above is a symbol that represents the region above an object for purposes of placement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Above)))
(def Abs "Abs[z] gives the absolute value of the real or complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Abs)))
(def AbsArg "AbsArg[z] gives the list {Abs[z], Arg[z]} of the number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsArg)))
(def AbsArgPlot "AbsArgPlot[f, {x, xmin, xmax}] generates a plot of Abs[f] colored by Arg[f] as a function of x∈ from xmin to xmax.\nAbsArgPlot[{f1, f2, …}, {x, xmin, xmax}] plots several functions.\nAbsArgPlot[{…, w[fi], …}, …] plots fi with features defined by the symbolic wrapper w.\nAbsArgPlot[…, {x}∈reg] takes the variable x to be in the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsArgPlot)))
(def AbsoluteCorrelation "AbsoluteCorrelation[v, w] gives the absolute correlation between the vectors v and w.\nAbsoluteCorrelation[a, b] gives the absolute cross-correlation matrix for the matrices a and b.\nAbsoluteCorrelation[a] gives the absolute correlation matrix for the matrix a.\nAbsoluteCorrelation[dist] gives the absolute correlation matrix for the multivariate symbolic distribution dist.\nAbsoluteCorrelation[dist, i, j] gives the (i, j)^th absolute correlation for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteCorrelation)))
(def AbsoluteCorrelationFunction "AbsoluteCorrelationFunction[data, hspec] estimates the absolute correlation function at lags hspec from data.\nAbsoluteCorrelationFunction[proc, hspec] represents the absolute correlation function at lags hspec for the random process proc. \nAbsoluteCorrelationFunction[proc, s, t] represents the absolute correlation function at times s and t for the random process proc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteCorrelationFunction)))
(def AbsoluteCurrentValue "AbsoluteCurrentValue[item] gives the absolute current value of item at a location in the Wolfram System and interface. \nAbsoluteCurrentValue[{item, spec}] gives the absolute current value for the feature of item specified by spec.\nAbsoluteCurrentValue[obj, item] gives the absolute current value of item associated with the object obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteCurrentValue)))
(def AbsoluteDashing "AbsoluteDashing[{d1, d2, …}] is a graphics directive which specifies that lines which follow are to be drawn dashed, with successive segments having absolute lengths d1, d2, … (repeated cyclically). \nAbsoluteDashing[d] is equivalent to AbsoluteDashing[{d, d}]. \nAbsoluteDashing[{d1, d2, …}, offset] offsets the dashes by offset.\nAbsoluteDashing[{d1, d2, …}, offset, capform] sets the CapForm for individual dashes to capform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteDashing)))
(def AbsoluteFileName "AbsoluteFileName[\"name\"] gives the full absolute version of the name for a file in your filesystem." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteFileName)))
(def AbsoluteOptions "AbsoluteOptions[obj] gives the absolute settings of options used by the given object.\nAbsoluteOptions[obj, name] gives the absolute setting for the option name. \nAbsoluteOptions[obj, {name1, name2, …}] gives a list of the absolute settings for the options namei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteOptions)))
(def AbsolutePointSize "AbsolutePointSize[d] is a graphics directive which specifies that points which follow are to be shown if possible as circular regions with absolute diameter d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsolutePointSize)))
(def AbsoluteThickness "AbsoluteThickness[d] is a graphics directive which specifies that lines which follow are to be drawn with absolute thickness d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteThickness)))
(def AbsoluteTime "AbsoluteTime[] gives the total number of seconds since the beginning of January 1, 1900, in your time zone.\nAbsoluteTime[date] gives the absolute time specification corresponding to the given date specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteTime)))
(def AbsoluteTiming "AbsoluteTiming[expr] evaluates expr, returning a list of the absolute number of seconds in real time that have elapsed, together with the result obtained." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AbsoluteTiming)))
(def AcceptanceThreshold "AcceptanceThreshold is an option that specifies the minimum threshold at which a result is considered acceptable." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcceptanceThreshold)))
(def AccountingForm "AccountingForm[expr] prints with all numbers in expr given in standard accounting notation. \nAccountingForm[expr, n] prints with numbers given to n‐digit precision." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AccountingForm)))
(def Accumulate "Accumulate[list] gives a list of the successive accumulated totals of elements in list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Accumulate)))
(def Accuracy "Accuracy[x] gives the effective number of digits to the right of the decimal point in the number x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Accuracy)))
(def AccuracyGoal "AccuracyGoal is an option for various numerical operations which specifies how many effective digits of accuracy should be sought in the final result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AccuracyGoal)))
(def AcousticAbsorbingValue "AcousticAbsorbingValue[pred, vars, pars] represents a time or frequency domain absorbing boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticAbsorbingValue[pred, vars, pars, lkeys] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticAbsorbingValue)))
(def AcousticImpedanceValue "AcousticImpedanceValue[pred, vars, pars] represents a time or frequency domain impedance boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticImpedanceValue[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticImpedanceValue)))
(def AcousticNormalVelocityValue "AcousticNormalVelocityValue[pred, vars, pars] represents a time or frequency domain normal velocity boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticNormalVelocityValue[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticNormalVelocityValue)))
(def AcousticPDEComponent "AcousticPDEComponent[vars, pars] yields an acoustic PDE term component with variables vars and parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticPDEComponent)))
(def AcousticPressureCondition "AcousticPressureCondition[pred, vars, pars] represents a time or frequency domain pressure boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticPressureCondition[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticPressureCondition)))
(def AcousticRadiationValue "AcousticRadiationValue[pred, vars, pars] represents a time or frequency radiation boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticRadiationValue[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticRadiationValue)))
(def AcousticSoundHardValue "AcousticSoundHardValue[pred, vars, pars] represents a time or frequency domain sound hard boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticSoundHardValue[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticSoundHardValue)))
(def AcousticSoundSoftCondition "AcousticSoundSoftCondition[pred, vars, pars] represents a time or frequency domain sound soft boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nAcousticSoundSoftCondition[pred, vars, pars, lkey] represents a time or frequency domain boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcousticSoundSoftCondition)))
(def ActionMenu "ActionMenu[name, {lbl1:>act1, lbl2:>act2, …}] represents an action menu with label name and with items labeled lbli that evaluates the expression acti if the corresponding item is chosen.\nActionMenu[name, {…, lbli{sublbl1:>subact1, sublbl2:>subact2, …}, …}] represents an action menu containing a submenu with label lbli containing items sublbli with actions subacti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActionMenu)))
(def Activate "Activate[expr] replaces all instances of Inactive[f] in expr with f.\nActivate[expr, patt] replaces only instances of Inactive[f] for which f matches the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Activate)))
(def ActivateResult "ActivateResult is an option for TruncateSum and other functions that specifies whether Inactive sums or other expressions should be activated before returning the final result of the computation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActivateResult)))
(def ActiveClassification "ActiveClassification[f, {conf1, conf2, …}] gives an object representing the result of active classification obtained by using the function f to determine classes for the example configurations confi. \nActiveClassification[f, reg] generates configurations within the region specified by reg.\nActiveClassification[f, sampler] generates configurations by applying the function sampler.\nActiveClassification[f, {conf1, conf2, …}nsampler] applies the function nsampler to successively generate configurations starting from one of the confi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActiveClassification)))
(def ActiveClassificationObject "ActiveClassificationObject[…] represents the result of an ActiveClassification process." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActiveClassificationObject)))
(def ActivePrediction "ActivePrediction[f, {conf1, conf2, …}] gives an object representing the result of active prediction obtained by using the function f to determine values for the example configurations confi.\nActivePrediction[f, reg] generates configurations within the region specified by reg.\nActivePrediction[f, sampler] generates configurations by applying the function sampler.\nActivePrediction[f, {conf1, conf2, …}nsampler] applies the function nsampler to successively generate configurations starting from one of the confi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActivePrediction)))
(def ActivePredictionObject "ActivePredictionObject[…] represents the result of an ActivePrediction process." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActivePredictionObject)))
(def ActiveStyle "ActiveStyle is an option for Hyperlink and related constructs that specifies styles to add when the constructs are active, typically as a result of the mouse being over them." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ActiveStyle)))
(def AcyclicGraphQ "AcyclicGraphQ[g] yields True if the graph g is an acyclic graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AcyclicGraphQ)))
(def AddSides "AddSides[rel, x] adds x to each side of the equation or inequality rel.\nAddSides[rel1, rel2] adds the corresponding sides of two equations or inequalities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AddSides)))
(def AddTo "x+=dx adds dx to x and returns the new value of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AddTo)))
(def AddToSearchIndex "AddToSearchIndex[obj, content] adds the specified content to the existing search index object obj. \nAddToSearchIndex[obj, {content1, …}] adds all the contenti to obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AddToSearchIndex)))
(def AddToVectorDatabase "AddToVectorDatabase[db, {vec1, …}] adds a list of vectors veci to the VectorDatabaseObject[…] db.\nAddToVectorDatabase[db, {vec1, …}{val1, …}] adds vector and metadata to the database." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AddToVectorDatabase)))
(def AddUsers "AddUsers[group, {user1, …}] adds the users useri to the permissions group group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AddUsers)))
(def AdjacencyGraph "AdjacencyGraph[amat] gives the graph with adjacency matrix amat.\nAdjacencyGraph[{v1, v2, …}, amat] gives the graph with vertices vi and adjacency matrix amat." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjacencyGraph)))
(def AdjacencyList "AdjacencyList[g, v] gives a list of vertices adjacent to vertex v.\nAdjacencyList[g, patt] gives a list of vertices adjacent to vertices that match the pattern patt.\nAdjacencyList[g, patt, d] gives a list of vertices that are at distance at most d.\nAdjacencyList[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjacencyList)))
(def AdjacencyMatrix "AdjacencyMatrix[g] gives the vertex–vertex adjacency matrix of the graph g.\nAdjacencyMatrix[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjacencyMatrix)))
(def AdjacentMeshCells "AdjacentMeshCells[mr, cellspec, d] gives cells of dimension d adjacent to the cell specified by cellspec in the mesh mr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjacentMeshCells)))
(def Adjugate "Adjugate[m] gives the adjugate of a square matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Adjugate)))
(def AdjustTimeSeriesForecast "AdjustTimeSeriesForecast[tproc, forecast, newdata] adjusts forecast using new observations newdata according to the time series model tproc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjustTimeSeriesForecast)))
(def AdjustmentBox "AdjustmentBox[box, opts] is a low-level box construct which displays with the placement of box adjusted using the options given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjustmentBox)))
(def AdjustmentBoxOptions "AdjustmentBoxOptions is an option that specifies settings for AdjustmentBox objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdjustmentBoxOptions)))
(def AdministrativeDivisionData "AdministrativeDivisionData[entity, property] gives the value of the specified property for the administrative division entity.\nAdministrativeDivisionData[{entity1, entity2, …}, property] gives a list of property values for the specified administrative division names.\nAdministrativeDivisionData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AdministrativeDivisionData)))
(def AffineHalfSpace "AffineHalfSpace[{p1, …, p k+1}, w] represents AffineSpace[{p1, …, p k+1}] extended in the direction w.\nAffineHalfSpace[p, {v1, …, vk}, w] represents AffineSpace[p, {v1, …, vk}] extended in the direction w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AffineHalfSpace)))
(def AffineSpace "AffineSpace[{p1, …, p k+1}] represents the affine space passing through the points pi.\nAffineSpace[p, {v1, …, vk}] represents the affine space passing through p in the directions vi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AffineSpace)))
(def AffineStateSpaceModel "AffineStateSpaceModel[{a, b, c, d}, x] represents the affine state-space model x'(t)a(x(t))+b (x(t)).u(t), y(t)=c(x(t))+d (x(t)).u(t).\nAffineStateSpaceModel[sys] gives an affine state-space model corresponding to the system model sys.\nAffineStateSpaceModel[eqns, {{x1, x10}, …}, {{u1, u10}, …}, {g1, …}, t] gives the affine state-space model obtained by Taylor input linearization about the dependent variable xi at x i0 and input uj at uj 0 of the differential equations eqns with outputs gi and independent variable t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AffineStateSpaceModel)))
(def AffineTransform "AffineTransform[m] gives a TransformationFunction that represents an affine transform that maps r to m.r. \nAffineTransform[{m, v}] gives an affine transform that maps r to m.r+v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AffineTransform)))
(def After "After is a symbol that represents the region after an object for purposes of placement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote After)))
(def AggregatedEntityClass "AggregatedEntityClass[class, \"prop\"->f] represents an entity class containing a single entity with the property prop whose value is the result of applying the function f to the whole specified entity class.\nAggregatedEntityClass[class, {prop1f1, prop2f2, …}] constructs multiple properties propi obtained by applying fi to class.\nAggregatedEntityClass[class, propspec, gprop] forms groups of elements of class according to their values of the property gprop, then generates an entity class with an entity for each of these groups. \nAggregatedEntityClass[class, propspec, \"pname\"->f] forms groups according to the values obtained by applying the entity function f, with the resulting property named pname.\nAggregatedEntityClass[class, propspec, {gspec1, gspec2, …}] forms groups for which the set of values defined by the gspeci is distinct." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AggregatedEntityClass)))
(def AggregationLayer "AggregationLayer[f] represents a layer that aggregates an array of arbitrary rank into a vector, using the function f.\nAggregationLayer[f, n] aggregates an array at level n.\nAggregationLayer[f, n1;;n2] aggregates an array at levels n1 through n2.\nAggregationLayer[f, {n1, n2, …}] aggregates an array at levels n1, n2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AggregationLayer)))
(def AirPressureData "AirPressureData[] gives the most recent measurement for air pressure near the current location.\nAirPressureData[datespec] gives the air pressure value for the specified time near the current location.\nAirPressureData[locationspec] gives the most recent measurement for air pressure near the specified locations.\nAirPressureData[locationspec, datespec] gives the value or values for the specified date and location.\nAirPressureData[{{location1, date1}, {location2, date2}, …}] gives values for all specified locations on the specified dates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AirPressureData)))
(def AirSoundAttenuation "AirSoundAttenuation[spec, frequency] returns the sound attenuation coefficient in moist air for the specified parameters spec for frequency.\nAirSoundAttenuation[spec, frequency, distance] returns the sound attenuation factor for the specified parameters at distance.\nAirSoundAttenuation[spec, frequency, distance, sl] returns the sound level at distance given the source sound level sl.\nAirSoundAttenuation[spec, audio, distance] transforms audio based on the distance from the source." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AirSoundAttenuation)))
(def AirTemperatureData "AirTemperatureData[] gives the most recent measurement for air temperature near the current location.\nAirTemperatureData[datespec] gives the air temperature value for the specified time near the current location.\nAirTemperatureData[locationspec] gives the most recent measurement for air temperature near the specified location.\nAirTemperatureData[locationspec, datespec] gives the value or values for the specified date and location.\nAirTemperatureData[{{location1, date1}, {location2, date2}, …}] gives values for all specified locations on the specified dates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AirTemperatureData)))
(def AircraftData "AircraftData[entity, property] gives the value of the specified property for the aircraft entity.\nAircraftData[{entity1, entity2, …}, property] gives a list of property values for the specified aircraft entities.\nAircraftData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AircraftData)))
(def AirportData "AirportData[entity, property] gives the value of the specified property for the airport entity.\nAirportData[{entity1, entity2, …}, property] gives a list of property values for the specified airport entities.\nAirportData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AirportData)))
(def AiryAi "AiryAi[z] gives the Airy function Ai (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryAi)))
(def AiryAiPrime "AiryAiPrime[z] gives the derivative of the Airy function Ai^′ (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryAiPrime)))
(def AiryAiZero "AiryAiZero[k] represents the k ^th zero of the Airy function Ai (x).\nAiryAiZero[k, x0] represents the k ^th zero less than x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryAiZero)))
(def AiryBi "AiryBi[z] gives the Airy function Bi (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryBi)))
(def AiryBiPrime "AiryBiPrime[z] gives the derivative of the Airy function Bi^′ (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryBiPrime)))
(def AiryBiZero "AiryBiZero[k] represents the k ^th zero of the Airy function Bi (x).\nAiryBiZero[k, x0] represents the k ^th zero less than x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AiryBiZero)))
(def AlgebraicIntegerQ "AlgebraicIntegerQ[a] yields True if a is an algebraic integer, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicIntegerQ)))
(def AlgebraicNumber "AlgebraicNumber[θ, {c0, c1, …, cn}] represents the algebraic number in the field [θ] given by c0+c1 θ +…+cn θ^n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicNumber)))
(def AlgebraicNumberDenominator "AlgebraicNumberDenominator[a] gives the smallest positive integer n such that n a is an algebraic integer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicNumberDenominator)))
(def AlgebraicNumberNorm "AlgebraicNumberNorm[a] gives the norm of the algebraic number a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicNumberNorm)))
(def AlgebraicNumberPolynomial "AlgebraicNumberPolynomial[a, x] gives the polynomial in x corresponding to the AlgebraicNumber object a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicNumberPolynomial)))
(def AlgebraicNumberTrace "AlgebraicNumberTrace[a] gives the trace of the algebraic number a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicNumberTrace)))
(def AlgebraicUnitQ "AlgebraicUnitQ[a] yields True if a is an algebraic unit, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlgebraicUnitQ)))
(def Algebraics "Algebraics represents the domain of algebraic numbers, as in x∈Algebraics." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Algebraics)))
(def Alignment "Alignment is an option which specifies how the contents of a displayed object should be aligned within the available area in the object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Alignment)))
(def AlignmentPoint "AlignmentPoint is an option which specifies how objects should by default be aligned when they appear in Inset." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlignmentPoint)))
(def All "All is a setting used for certain options. In Part and related functions, All specifies all parts at a particular level." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote All)))
(def AllMatch "AllMatch[{e1, e2, …}, form] yields True if ei matches the pattern form for all of the ei.\nAllMatch[expr, form, level] tests parts of expr at level level.\nAllMatch[form] represents an operator form of AllMatch that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllMatch)))
(def AllSameBy "AllSameBy[{e1, e2, …}, f] tests whether all the f[ei] are the same.\nAllSameBy[f] represents an operator form of AllSameBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllSameBy)))
(def AllTrue "AllTrue[{e1, e2, …}, test] yields True if test[ei] is True for all of the ei.\nAllTrue[expr, test, level] tests parts of expr at level level.\nAllTrue[test] represents an operator form of AllTrue that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllTrue)))
(def AllowGroupClose "AllowGroupClose is an option for Cell that specifies whether a cell group can be closed normally." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowGroupClose)))
(def AllowInlineCells "AllowInlineCells is an option for SelectedCells, Cell, and related constructs that specifies whether inline cells are permitted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowInlineCells)))
(def AllowLooseGrammar "AllowLooseGrammar is an option for GrammarRules and related functions that specifies whether grammatical \"fluff\" should automatically be ignored in applying grammar rules." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowLooseGrammar)))
(def AllowReverseGroupClose "AllowReverseGroupClose is an option for Cell that specifies whether a cell group can be reverse closed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowReverseGroupClose)))
(def AllowVersionUpdate "AllowVersionUpdate is an option for PacletInstall and PacletInstallSubmit that specifies whether a newer paclet version should be installed if an older version is already installed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowVersionUpdate)))
(def AllowedCloudExtraParameters "AllowedCloudExtraParameters is an option for APIFunction and related functions that specifies whether parameters that affect overall cloud execution should be accepted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowedCloudExtraParameters)))
(def AllowedCloudParameterExtensions "AllowedCloudParameterExtensions is an option for APIFunction and related functions that specifies what extensions to allow for API or other input parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowedCloudParameterExtensions)))
(def AllowedDimensions "AllowedDimensions is an option for Grid and related functions that specifies the allowed minimum and maximum dimensions of the Grid under interactive editing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowedDimensions)))
(def AllowedFrequencyRange "AllowedFrequencyRange is an option for audio and signal processing functions that specifies the range of frequencies of interest." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowedFrequencyRange)))
(def AllowedHeads "AllowedHeads is an option that specifies the heads of subexpressions into which a function may descend." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AllowedHeads)))
(def AlphaChannel "AlphaChannel[color] returns the opacity of color.\nAlphaChannel[image] returns the alpha channel of image.\nAlphaChannel[video] returns a video containing the alpha channel of the frames in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlphaChannel)))
(def Alphabet "Alphabet[] gives a list of the lowercase letters a through z in the English alphabet.\nAlphabet[type] gives the alphabet for the language or class type.\nAlphabet[type, prop] gives the alphabet defined by prop for the language or class type ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Alphabet)))
(def AlphabeticOrder "AlphabeticOrder[\"string1\", \"string2\"] gives 1 if \"string1\" appears before \"string2\" in alphabetical order, -1 if it is after, and 0 if it is identical. \nAlphabeticOrder[\"string1\", \"string2\", lang] uses an ordering suitable for the language lang.\nAlphabeticOrder[lang] represents an operator form that compares strings when applied to \"string1\", \"string2\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlphabeticOrder)))
(def AlphabeticSort "AlphabeticSort[list] sorts the elements of list into alphabetical order.\nAlphabeticSort[list, lang] sorts using an ordering suitable for the language lang." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlphabeticSort)))
(def AlternatingFactorial "AlternatingFactorial[n] gives the alternating factorial af (n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlternatingFactorial)))
(def AlternatingGroup "AlternatingGroup[n] represents the alternating group of degree n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlternatingGroup)))
(def AlternativeHypothesis "AlternativeHypothesis is an option for hypothesis testing functions like LocationTest that specifies the alternative hypothesis." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AlternativeHypothesis)))
(def Alternatives "p1|p2|… is a pattern object that represents any of the patterns pi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Alternatives)))
(def AltitudeMethod "AltitudeMethod is an option for SunPosition, MoonPosition, and related functions that determines whether to take atmospheric refraction into account when computing altitude." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AltitudeMethod)))
(def AmbientLight "AmbientLight[col] is a three-dimensional graphics directive that specifies the uniform ambient light of color col to use in coloring 3D surfaces." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AmbientLight)))
(def AmbiguityFunction "AmbiguityFunction is an option for SemanticInterpretation, Interpreter, and related functions that specifies how to resolve ambiguities generated during semantic interpretation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AmbiguityFunction)))
(def AmbiguityList "AmbiguityList[{expr1, expr2, …}] represents possible results derived from an ambiguous semantic interpretation.\nAmbiguityList[{expr1, expr2, …}, \"string\"] represents possible results from semantic interpretation of an input string.\nAmbiguityList[{expr1, expr2, …}, \"string\", {assoc1, assoc2, …}] includes a sequence of associations giving details of the interpretations used to obtain the expri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AmbiguityList)))
(def AnatomyData "AnatomyData[entity, property] gives the value of the specified property for the anatomical structure entity.\nAnatomyData[{entity1, entity2, …}, property] gives a list of property values for the specified anatomical structure entities.\nAnatomyData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnatomyData)))
(def AnatomyPlot3D "AnatomyPlot3D[primitives, options] represents a three-dimensional graphical image that works with anatomical entities as well as standard 3D graphics primitives and directives." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnatomyPlot3D)))
(def AnatomySkinStyle "AnatomySkinStyle is an option of AnatomyPlot3D that specifies what style to use for automatically included skin subparts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnatomySkinStyle)))
(def AnatomyStyling "AnatomyStyling[g] is a graphics directive used in AnatomyPlot3D that specifies how anatomy entity‐based graphics objects are to be drawn using the graphics directive or association of directives g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnatomyStyling)))
(def AnchoredSearch "AnchoredSearch is an option for Find and FindList that specifies whether the text searched for must be at the beginning of a record." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnchoredSearch)))
(def And "e1&&e2&&… is the logical AND function. It evaluates its arguments in order, giving False immediately if any of them are False, and True if they are all True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote And)))
(def AndersonDarlingTest "AndersonDarlingTest[data] tests whether data is normally distributed using the Anderson–Darling test.\nAndersonDarlingTest[data, dist] tests whether data is distributed according to dist using the Anderson–Darling test.\nAndersonDarlingTest[data, dist, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AndersonDarlingTest)))
(def AngerJ "AngerJ[ν, z] gives the Anger function Jν (z).\nAngerJ[ν, μ, z] gives the associated Anger function J_ν^μ(z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AngerJ)))
(def AngleBisector "AngleBisector[{q1, p, q2}] gives the bisector of the interior angle at p formed by the triangle with vertex points p, q1 and q2.\nAngleBisector[{q1, p, q2}, \"type\"] gives the angle bisector of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AngleBisector)))
(def AngleBracket "AngleBracket[x, y, …] displays as 〈x, y, …〉." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AngleBracket)))
(def AnglePath "AnglePath[{θ1, θ2, θ3, …}] gives the list of 2D coordinates corresponding to a path that starts at {0, 0}, then takes a series of steps of unit length at successive relative angles θi. \nAnglePath[{{r1, θ1}, {r2, θ2}, {r3, θ3}, …}] takes successive steps of lengths ri. \nAnglePath[θ0, {step1, step2, …}] starts at angle θ0 with respect to the x axis.\nAnglePath[{x, y}, {step1, step2, …}] starts at the point {x, y} with initial angle 0 with respect to the x axis.\nAnglePath[{{x, y}, θ0}, {step1, step2, …}] starts at {x, y} with initial angle θ0 with respect to the x axis.\nAnglePath[{{x, y}, {dx, dy}}, {step1, step2, …}] takes the first step to go from {x, y} to {x+dx, y+dy}.\nAnglePath[init, steps, form] returns at each step the data of the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnglePath)))
(def AnglePath3D "AnglePath3D[{{α1, β1, γ1}, {α2, β2, γ2}, …}] gives the list of 3D coordinates of a path of an object that starts at {0, 0, 0}, then takes a series of steps of unit length, each in the direction of the x axis obtained after successive rotation of the object by the Euler angles αi, βi, γi.\nAnglePath3D[{{α1, β1}, {α2, β2}, …}] assumes the Euler angles γi to be 0.\nAnglePath3D[{mat1, mat2, …}] takes the successive rotations to be specified by the 3D rotation matrices mati. \nAnglePath3D[{{r1, rot1}, {r2, rot2}, …}] takes successive steps of length ri with Euler angles or rotation matrices specified by roti.\nAnglePath3D[{x0, y0, z0}, steps] starts at the point {x0, y0, z0}.\nAnglePath3D[{rot0}, steps] starts in the x axis direction specified by rotating the object according to Euler angles or rotation matrix rot0.\nAnglePath3D[{{x0, y0, z0}, rot0}, steps] starts at point {x0, y0, z0} with the x axis direction specified by rot0.\nAnglePath3D[init, steps, form] returns at each step the data of the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnglePath3D)))
(def AngleVector "AngleVector[θ] gives the list representing the 2D unit vector at angle θ relative to the x axis.\nAngleVector[{r, θ}] gives the list representing the 2D vector of length r at angle θ.\nAngleVector[{x, y}, θ] gives the result of starting from the point {x, y}, then going a unit distance at angle θ.\nAngleVector[{x, y}, {r, θ}] gives the result of starting from the point {x, y}, then going distance r at angle θ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AngleVector)))
(def AngularGauge "AngularGauge[value] draws a gauge showing value in the range 0 to 1.\nAngularGauge[value, {min, max}] draws a gauge showing value in a range of min to max.\nAngularGauge[Dynamic[value], …] allows value to be set interactively using the gauge.\nAngularGauge[{value1, value2, …}, …] draws a gauge showing multiple values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AngularGauge)))
(def Animate "Animate[expr, {u, umin, umax}] generates an animation of expr in which u varies continuously from umin to umax. \nAnimate[expr, {u, umin, umax, du}] takes u to vary in steps du. \nAnimate[expr, {u, {u1, u2, …}}] makes u take on discrete values u1, u2, …. \nAnimate[expr, {u, …}, {v, …}, …] varies all the variables u, v, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Animate)))
(def AnimatedImage "AnimatedImage[{image1, image2, …}] generates an animation whose frames are the successive imagei. \nAnimatedImage[file] represents an animated image from file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimatedImage)))
(def AnimationDirection "AnimationDirection is an option which specifies the direction to run an animation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationDirection)))
(def AnimationRate "AnimationRate is an option for Animate and Animator that specifies at what rate an animation should run, in units per second." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationRate)))
(def AnimationRepetitions "AnimationRepetitions is an option to Animate and related functions that specifies how many times the animation they create runs before stopping." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationRepetitions)))
(def AnimationRunTime "AnimationRunTime is an option to Animator and related functions that indicates how long the animation has been continuously running." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationRunTime)))
(def AnimationRunning "AnimationRunning is an option to Animate and related functions that specifies whether the animation they create is running." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationRunning)))
(def AnimationTimeIndex "AnimationTimeIndex is an option to Animator and related functions that specifies the current time index for the animator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationTimeIndex)))
(def AnimationVideo "AnimationVideo[fexpr, {u, umin, umax}] generates a video of fexpr in which u varies from umin to umax. \nAnimationVideo[fexpr, {u, umin, umax, du}] takes u to vary in steps du. \nAnimationVideo[fexpr, {u, {u1, u2, …}}] makes u take on values u1, u2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnimationVideo)))
(def Animator "Animator[u] represents an object that displays with the value of u being continually increased from 0 to 1 with time. \nAnimator[u, {umin, umax}] makes u vary from umin to umax. \nAnimator[u, {umin, umax, du}] makes u vary in steps du. \nAnimator[u, {umin, umax}, ups] makes the value of u increase at a rate of ups units per second." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Animator)))
(def Annotate "Annotate[obj, keyvalue] sets the annotation keyvalue for the object obj.\nAnnotate[{obj, itemspec}, keyvalue] sets the annotation for the items in obj specified by itemspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Annotate)))
(def Annotation "Annotation[expr, data] represents an expression expr, with annotation data.\nAnnotation[expr, data, \"type\"] specifies the type of annotation being given.\nAnnotation[items, keyvalue] associates keyvalue pairs with items in objects such as Graph, MeshRegion etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Annotation)))
(def AnnotationDelete "AnnotationDelete[obj] deletes all annotations of the object obj.\nAnnotationDelete[{obj, itemspec}] deletes all annotations of the items of obj specified by itemspec.\nAnnotationDelete[spec, key] deletes the annotation key specified by spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnnotationDelete)))
(def AnnotationKeys "AnnotationKeys[obj] lists all annotation keys available for the object obj.\nAnnotationKeys[{obj, itemspec}] lists all annotation keys available for the items specified by itemspec in obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnnotationKeys)))
(def AnnotationRules "AnnotationRules is an option that allows specification of annotations to objects and items in objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnnotationRules)))
(def AnnotationValue "AnnotationValue[obj, key] gives the annotation value associated with key for the object obj.\nAnnotationValue[{obj, itemspec}, key] gives the annotation value associated with key for items specified by itemspec in obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnnotationValue)))
(def Annuity "Annuity[p, t] represents an annuity of fixed payments p made over t periods.\nAnnuity[p, t, q] represents a series of payments occurring at time intervals q.\nAnnuity[{p, {pinitial, pfinal}}, t, q] represents an annuity with the specified initial and final payments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Annuity)))
(def AnnuityDue "AnnuityDue[p, t] represents an annuity due of fixed payments p made over t periods.\nAnnuityDue[p, t, q] represents a series of payments occurring at time intervals q.\nAnnuityDue[{p, {pinitial, pfinal}}, t, q] represents an annuity due with the specified initial and final payments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnnuityDue)))
(def Annulus "Annulus[{x, y}, {rinner, router}] represents an annulus centered at {x, y} with inner radius rinner and outer radius router.\nAnnulus[{x, y}, {rinner, router}, {θ1, θ2}] represents an annulus from angle θ1 to θ2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Annulus)))
(def AnomalyDetection "AnomalyDetection[{example1, example2, …}] generates an AnomalyDetectorFunction[…] based on the examples given.\nAnomalyDetection[LearnedDistribution[…]] generates an anomaly detector based on the given distribution.\nAnomalyDetection[True{example11, example12, …}, False{example21, …}] can be used to indicate which examples should be considered anomalous." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnomalyDetection)))
(def AnomalyDetector "AnomalyDetector is an option for functions such as Classify that specifies an anomaly detector for them to include." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnomalyDetector)))
(def AnomalyDetectorFunction "AnomalyDetectorFunction[…] represents a function generated by AnomalyDetection for detecting whether data is anomalous or not." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnomalyDetectorFunction)))
(def Anonymous "Anonymous represents an option or other value that indicates the absence of a name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Anonymous)))
(def Antialiasing "Antialiasing is an option that specifies whether antialiasing should be done." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Antialiasing)))
(def Antihermitian "Antihermitian[{1, 2}] represents the symmetry of an antihermitian matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Antihermitian)))
(def AntihermitianMatrixQ "AntihermitianMatrixQ[m] gives True if m is explicitly antihermitian, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AntihermitianMatrixQ)))
(def Antisymmetric "Antisymmetric[{s1, …, sn}] represents the symmetry of a tensor that is antisymmetric in the slots si." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Antisymmetric)))
(def AntisymmetricMatrixQ "AntisymmetricMatrixQ[m] gives True if m is explicitly antisymmetric, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AntisymmetricMatrixQ)))
(def Antonyms "Antonyms[\"word\"] returns the antonyms associated with the specified word." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Antonyms)))
(def AnyMatch "AnyMatch[{e1, e2, …}, form] yields True if ei matches the pattern form for any of the ei.\nAnyMatch[expr, form, level] tests parts of expr at level level.\nAnyMatch[form] represents an operator form of AnyMatch that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnyMatch)))
(def AnyOrder "AnyOrder[p1, p2, …] is a grammar rules pattern object that represents a sequence of elements matching p1, p2, … in any order." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnyOrder)))
(def AnySubset "AnySubset[{c1, c2, …}] represents an element in an interpreter or form that accepts any subset of the choices ci. \nAnySubset[{lab1c1, lab2c2, …}] accepts any subset of the labi, yielding the corresponding ci as results.\nAnySubset[EntityClass[\"type\", \"class\"]] accepts any subset of the entities in the specified entity class.\nAnySubset[choices, max] allows at most max choices to be selected.\nAnySubset[choices, {min, max}] allows at least min and at most max choices to be selected." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnySubset)))
(def AnyTrue "AnyTrue[{e1, e2, …}, test] yields True if test[ei] is True for any of the ei.\nAnyTrue[expr, test, level] tests parts of expr at level level.\nAnyTrue[test] represents an operator form of AnyTrue that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AnyTrue)))
(def Apart "Apart[expr] rewrites a rational expression as a sum of terms with minimal denominators. \nApart[expr, var] treats all variables other than var as constants." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Apart)))
(def ApartSquareFree "ApartSquareFree[expr] rewrites a rational expression as a sum of terms whose denominators are powers of square-free polynomials. \nApartSquareFree[expr, var] treats all variables other than var as constants." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ApartSquareFree)))
(def Appearance "Appearance is an option for displayed objects such as Button and Slider that specifies the general type of appearance they should have." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Appearance)))
(def AppearanceElements "AppearanceElements is an option for functions like Manipulate that specifies what elements should be included in the displayed form of the object generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppearanceElements)))
(def AppearanceRules "AppearanceRules is an option for form and page generation functions that specifies the overall appearance of the generated object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppearanceRules)))
(def AppellF1 "AppellF1[a, b1, b2, c, x, y] is the Appell hypergeometric function of two variables F1 (a;b1, b2;c;x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppellF1)))
(def AppellF2 "AppellF2[a, b1, b2, c1, c2, x, y] is the Appell hypergeometric function of two variables F2 (a;b1, b2;c1, c2;x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppellF2)))
(def AppellF3 "AppellF3[a1, a2, b1, b2, c, x, y] is the Appell hypergeometric function of two variables F3 (a;b1, b2;c1, c2;x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppellF3)))
(def AppellF4 "AppellF4[a, b, c1, c2, x, y] is the Appell hypergeometric function of two variables F4 (a;b;c1, c2;x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppellF4)))
(def Append "Append[expr, elem] gives expr with elem appended. \nAppend[elem] represents an operator form of Append that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Append)))
(def AppendLayer "AppendLayer[] represents a net layer that takes an input array and appends another array to it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppendLayer)))
(def AppendTo "AppendTo[x, elem] appends elem to the value of x, and resets x to the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AppendTo)))
(def Application "f∖[Application]g or Application[f, g] represents the formal application of f to g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Application)))
(def Apply "f@@expr or Apply[f, expr] replaces the head of expr by f. \nf@@@expr or Apply[f, expr, {1}] replaces heads at level 1 of expr by f.\nApply[f, expr, levelspec] replaces heads in parts of expr specified by levelspec. \nApply[f] represents an operator form of Apply that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Apply)))
(def ApplyReaction "ApplyReaction[rxn, mols] applies the pattern reaction rxn to the list of molecules mols, returning a single list of products.\nApplyReaction[rxn, mols, n] returns up to n lists of products.\nApplyReaction[rxn, mols, {map1, …}] returns a single set of products, using mapi to map the atoms in the i ^th molecule to the i ^th reactant.\nApplyReaction[rxn] represents an operator form of ApplyReaction that can be applied to a list of molecules." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ApplyReaction)))
(def ApplySides "ApplySides[f, rel] applies f to each side of the equation or inequality rel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ApplySides)))
(def ApplyTo "ApplyTo[x, f] or x//=f computes f[x] and resets x to the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ApplyTo)))
(def ArcCos "ArcCos[z] gives the arc cosine cos^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCos)))
(def ArcCosDegrees "ArcCosDegrees[z] gives the arc cosine in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCosDegrees)))
(def ArcCosh "ArcCosh[z] gives the inverse hyperbolic cosine cosh^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCosh)))
(def ArcCot "ArcCot[z] gives the arc cotangent cot^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCot)))
(def ArcCotDegrees "ArcCotDegrees[z] gives the arc cotangent in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCotDegrees)))
(def ArcCoth "ArcCoth[z] gives the inverse hyperbolic cotangent coth^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCoth)))
(def ArcCsc "ArcCsc[z] gives the arc cosecant csc^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCsc)))
(def ArcCscDegrees "ArcCscDegrees[z] gives the arc cosecant in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCscDegrees)))
(def ArcCsch "ArcCsch[z] gives the inverse hyperbolic cosecant csch^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCsch)))
(def ArcCurvature "ArcCurvature[{x1, …, xn}, t] gives the curvature of the parametrized curve whose Cartesian coordinates xi are functions of t.\nArcCurvature[{x1, …, xn}, t, chart] interprets the xi as coordinates in the specified coordinate chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcCurvature)))
(def ArcLength "ArcLength[reg] gives the length of the one-dimensional region reg.\nArcLength[{x1, …, xn}, {t, tmin, tmax}] gives the length of the parametrized curve whose Cartesian coordinates xi are functions of t.\nArcLength[{x1, …, xn}, {t, tmin, tmax}, chart] interprets the xi as coordinates in the specified coordinate chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcLength)))
(def ArcSec "ArcSec[z] gives the arc secant sec^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSec)))
(def ArcSecDegrees "ArcSecDegrees[z] gives the arc secant in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSecDegrees)))
(def ArcSech "ArcSech[z] gives the inverse hyperbolic secant sech^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSech)))
(def ArcSin "ArcSin[z] gives the arc sine sin^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSin)))
(def ArcSinDegrees "ArcSinDegrees[z] gives the arc sine in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSinDegrees)))
(def ArcSinDistribution "ArcSinDistribution[{xmin, xmax}] represents the arc sine distribution supported between xmin and xmax.\nArcSinDistribution[] represents the arc sine distribution supported between zero and one." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSinDistribution)))
(def ArcSinh "ArcSinh[z] gives the inverse hyperbolic sine sinh^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcSinh)))
(def ArcTan "ArcTan[z] gives the arc tangent tan^-1 (z) of the complex number z. \nArcTan[x, y] gives the arc tangent of y/x, taking into account which quadrant the point (x, y) is in." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcTan)))
(def ArcTanDegrees "ArcTanDegrees[z] gives the arc tangent in degrees of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcTanDegrees)))
(def ArcTanh "ArcTanh[z] gives the inverse hyperbolic tangent tanh^-1 (z) of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArcTanh)))
(def Area "Area[reg] gives the area of the two-dimensional region reg.\nArea[{x1, …, xn}, {s, smin, smax}, {t, tmin, tmax}] gives the area of the parametrized surface whose Cartesian coordinates xi are functions of s and t.\nArea[{x1, …, xn}, {s, smin, smax}, {t, tmin, tmax}, chart] interprets the xi as coordinates in the specified coordinate chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Area)))
(def Arg "Arg[z] gives the argument of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Arg)))
(def ArgMax "ArgMax[f, x] gives a position xmax at which f is maximized.\nArgMax[f, {x, y, …}] gives a position {xmax, ymax, …} at which f is maximized.\nArgMax[{f, cons}, {x, y, …}] gives a position at which f is maximized subject to the constraints cons. \nArgMax[…, x∈rdom] constrains x to be in the region or domain rdom.\nArgMax[…, …, dom] constrains variables to the domain dom, typically Reals or Integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArgMax)))
(def ArgMin "ArgMin[f, x] gives a position xmin at which f is minimized.\nArgMin[f, {x, y, …}] gives a position {xmin, ymin, …} at which f is minimized.\nArgMin[{f, cons}, {x, y, …}] gives a position at which f is minimized subject to the constraints cons. \nArgMin[…, x∈rdom] constrains x to be in the region or domain rdom.\nArgMin[…, …, dom] constrains variables to the domain dom, typically Reals or Integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArgMin)))
(def ArgumentsOptions "ArgumentsOptions[f[args], n] tries to separate args into a list of n positional arguments followed by a list of valid options for f.\nArgumentsOptions[f[args], {min, max}] requires the number of positional arguments to be between min and max.\nArgumentsOptions[f[args], spec, assoc] modifies the behavior based on the information in the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArgumentsOptions)))
(def ArithmeticGeometricMean "ArithmeticGeometricMean[a, b] gives the arithmetic‐geometric mean of a and b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArithmeticGeometricMean)))
(def Around "Around[x, δ] represents an approximate number or quantity with a value around x and an uncertainty δ.\nAround[x, {δ-, δ+}] represents a number or quantity with a value around x and asymmetric uncertainties δ-, δ+.\nAround[dist] gives an approximate number or quantity around the mean of the distribution dist, with an uncertainty corresponding to the standard deviation of the distribution.\nAround[list] gives an approximate object around the mean of the elements of list and with an uncertainty corresponding to their standard deviation.\nAround[s] gives an approximate object derived from the number, interval or string specification s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Around)))
(def AroundReplace "AroundReplace[expr, {s1Around[x1, δ1], s2Around[x2, δ2], …}] propagates uncertainty in expr by replacing all occurrences of si by Around[xi, δi].\nAroundReplace[expr, rules, n] propagates uncertainty in expr using a series expansion to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AroundReplace)))
(def Array "Array[f, n] generates a list of length n, with elements f[i]. \nArray[f, n, r] generates a list using the index origin r.\nArray[f, n, {a, b}] generates a list using n values from a to b.\nArray[f, {n1, n2, …}] generates an n1×n2×… array of nested lists, with elements f[i1, i2, …]. \nArray[f, {n1, n2, …}, {r1, r2, …}] generates a list using the index origins ri (default 1). \nArray[f, {n1, n2, …}, {{a1, b1}, {a2, b2}, …}] generates a list using ni values from ai to bi.\nArray[f, dims, origin, h] uses head h, rather than List, for each level of the array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Array)))
(def ArrayComponents "ArrayComponents[array] gives an array in which all identical elements of array are replaced by an integer index representing the component in which the element lies.\nArrayComponents[array, level] finds the identical elements at the specified level in array\nArrayComponents[array, level, rules] uses a rule or a list of rules for specifying the labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayComponents)))
(def ArrayDepth "ArrayDepth[expr] gives the depth to which expr is a full array, with all the parts at a particular level having the same length." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayDepth)))
(def ArrayDot "ArrayDot[a, b, k] computes the product of arrays a and b obtained by summing up products of terms over the last k dimensions of a and the first k dimensions of b.\nArrayDot[a, b, {{s1, t1}, {s2, t2}, …}] computes the product of arrays a and b obtained by summing up products of terms over the pairs {si, ti} of dimensions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayDot)))
(def ArrayFilter "ArrayFilter[f, array, r] applies f to all range-r blocks in the specified array.\nArrayFilter[f, array, {r1, r2, …}] applies f to blocks with ranges r1, r2, … in successive dimensions.\nArrayFilter[f, array, template] applies f over blocks specified by the position of 1s in the array template." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayFilter)))
(def ArrayFlatten "ArrayFlatten[{{m11, m12, …}, {m21, m22, …}, …}] creates a single flattened matrix from a matrix of matrices m ij. \nArrayFlatten[a, r] flattens out r pairs of levels in the array a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayFlatten)))
(def ArrayMesh "ArrayMesh[array] generates a mesh region from an array of rank d in which each cell has a geometric dimension d and represents a nonzero value of the array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayMesh)))
(def ArrayPad "ArrayPad[array, m] gives an array with m zeros of padding on every side. \nArrayPad[array, m, padding] uses the specified padding.\nArrayPad[array, {m, n}, …] pads with m elements at the beginning and n elements at the end. \nArrayPad[array, {{m1, n1}, {m2, n2}, …}, …] pads with mi, ni elements at level i in array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayPad)))
(def ArrayPlot "ArrayPlot[array] generates a plot in which the values in an array are shown in a discrete array of squares." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayPlot)))
(def ArrayPlot3D "ArrayPlot3D[array] generates a plot in which the values in an array are shown in a discrete array of cubes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayPlot3D)))
(def ArrayQ "ArrayQ[expr] gives True if expr is a full array or a SparseArray object, and gives False otherwise. \nArrayQ[expr, patt] requires expr to be a full array with a depth that matches the pattern patt. \nArrayQ[expr, patt, test] requires also that test yield True when applied to each of the array elements in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayQ)))
(def ArrayReduce "ArrayReduce[f, array, n] reduces dimension n of array by applying f.\nArrayReduce[f, array, n1;;n2] reduces dimensions n1 through n2.\nArrayReduce[f, array, {n1, n2, …}] reduces dimensions n1, n2, etc.\nArrayReduce[f, array, {{n11, n12, …}, {n21, n22, …}, …}] applies f to arrays formed by combining all dimensions nij to make each dimension i." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayReduce)))
(def ArrayResample "ArrayResample[array, {n1, n2, …}] resamples array to have dimensions {n1, n2, …}.\nArrayResample[array, dspec] resamples array according to the dimension specification dspec.\nArrayResample[array, dspec, scheme] specifies resampling scheme, either point or bin based. \nArrayResample[array, dspec, scheme, {{xmin, xmax}, …}] resamples only the data in the specified subrange {{xmin, xmax}, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayResample)))
(def ArrayReshape "ArrayReshape[list, dims] arranges the elements of list into a rectangular array with dimensions dims.\nArrayReshape[list, dims, padding] uses the specified padding if list does not contain enough elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayReshape)))
(def ArrayRules "ArrayRules[SparseArray[…]] gives the rules {pos1val1, pos2val2, …} specifying elements in a sparse array. \nArrayRules[list] gives rules for SparseArray[list]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArrayRules)))
(def ArraySymbol "ArraySymbol[a] represents an array with name a.\nArraySymbol[a, {n1, n2, …}] represents an n1×n2×… array.\nArraySymbol[a, {n1, n2, …}, dom] represents an array with elements in the domain dom.\nArraySymbol[a, {n1, n2, …}, dom, sym] represents an array with the symmetry sym." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ArraySymbol)))
(def Arrays "Arrays[{d1, …, dr}] represents the domain of arrays of rank r and dimensions di.\nArrays[{d1, …, dr}, dom] represents the domain of arrays of dimensions di, with components in the domain dom.\nArrays[{d1, …, dr}, dom, sym] represents the subdomain of arrays with dimensions di and symmetry sym." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Arrays)))
(def Arrow "Arrow[{pt1, pt2}] is a graphics primitive that represents an arrow from pt1 to pt2.\nArrow[{pt1, pt2}, s] represents an arrow with its ends set back from pt1 and pt2 by a distance s. \nArrow[{pt1, pt2}, {s1, s2}] sets back by s1 from pt1 and s2 from pt2. \nArrow[curve, …] represents an arrow following the specified curve." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Arrow)))
(def Arrowheads "Arrowheads[spec] is a graphics directive specifying that arrows that follow should have arrowheads with sizes, positions, and forms specified by spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Arrowheads)))
(def Ask "Ask[\"key\"] is a construct for use inside AskFunction that gives the value associated with key, or interactively asks for it if it is not already known. \nAsk[\"key\"->formspec] uses formspec to define how input should be requested and interpreted.\nAsk[{key1, key2, …}] gives the values associated with all the keyi, interactively asking for any that are needed.\nAsk[{key1->formspec1, key2->formspec2, …}] uses the formspeci to define how input for the keyi should be requested and interpreted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Ask)))
(def AskAppend "AskAppend[\"key\"] is a construct for use inside AskFunction that asks for a new value, appends it to the current value associated with \"key\", and returns the resulting list.\nAskAppend[\"key\"->formspec] uses formspec to define how input should be requested and interpreted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskAppend)))
(def AskConfirm "AskConfirm[\"key\"] is a construct for use inside AskFunction that asks for confirmation of the current value associated with \"key\" and allows this to be either confirmed or changed.\nAskConfirm[\"key\", fun] applies the function fun to determine how to ask for confirmation. \nAskConfirm[\"key\", \"str\"] applies the string \"str\" as a string template to ask for confirmation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskConfirm)))
(def AskDisplay "AskDisplay[expr] is a construct for use inside AskFunction that displays the result of evaluating expr in the context of the AskFunction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskDisplay)))
(def AskFunction "AskFunction[body] evaluates body, interactively asking for values specified by Ask[…] and related constructs. \nAskFunction[{key1spec1, key2spec2, …}, body] specifies how values associated with the keyi should be asked for." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskFunction)))
(def AskState "AskState[] is a construct for use inside AskFunction that returns an association of all values in the current state of the AskFunction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskState)))
(def AskTemplateDisplay "AskTemplateDisplay[fun] is a construct for use inside AskFunction that displays the result of applying fun to the association of the values of all keys encountered so far in the evaluation of the AskFunction.\nAskTemplateDisplay[\"str\"] applies \"str\" as a string template to the association of values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskTemplateDisplay)))
(def AskedQ "AskedQ[\"key\"] is a construct for use inside AskFunction that gives True if a value is currently associated with key, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskedQ)))
(def AskedValue "AskedValue[\"key\"] is a construct for use inside AskFunction that gives the value associated with key, or Missing[…] if none has been provided." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AskedValue)))
(def AspectRatio "AspectRatio is an option for Graphics and related functions that specifies the ratio of height to width for a plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AspectRatio)))
(def Assert "Assert[test] represents the assertion that test is True. If assertions have been enabled, test is evaluated when the assertion is encountered. If test is not True, then an assertion failure is generated.\nAssert[test, tag] specifies a tag that will be used to identify the assertion if it fails." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Assert)))
(def AssessmentFunction "AssessmentFunction[key] represents a tool for assessing whether answers are correct according to the key.\nAssessmentFunction[key, method] uses the specified answer comparison method.\nAssessmentFunction[key, f] uses the function f to compare answers with the key.\nAssessmentFunction[key, comp] performs assessment using the custom assessment defined in the Association comp.\nAssessmentFunction[obj] represents an assessment function that performs assessment using the CloudObject obj. \nAssessmentFunction[{obj, id}] assesses the specified question within the CloudObject obj.\nAssessmentFunction[…][answer] gives an AssessmentResultObject representing the correctness of answer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssessmentFunction)))
(def AssessmentResultObject "AssessmentResultObject[assoc] represents the results of an assessment.\nAssessmentResultObject[{aro1, aro2, …}] represents a collection of many assessments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssessmentResultObject)))
(def AssociateTo "AssociateTo[a, keyval] changes the association a by adding the key-value pair keyval.\nAssociateTo[a, {key1val1, key2val2, …}] adds all key-value pairs keyivali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssociateTo)))
(def Association "Association[key1val1, key2val2, …] or key1val1, key2val2, … represents an association between keys and values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Association)))
(def AssociationFormat "AssociationFormat is an option to TextString and related functions that determines how associations are formatted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssociationFormat)))
(def AssociationMap "AssociationMap[f, {key1, key2, …}] creates the association key1f[key1], key2f[key2], ….\nAssociationMap[f, key1val1, key2val2, …] creates the association f[key1val1], f[key2val2], ….\nAssociationMap[f] represents an operator form of AssociationMap that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssociationMap)))
(def AssociationQ "AssociationQ[expr] gives True if expr is a valid Association object, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssociationQ)))
(def AssociationThread "AssociationThread[{key1, key2, …}{val1, val2, …}] gives the association key1val1, key2val2, ….\nAssociationThread[{key1, key2, …}, {val1, val2, …}] also gives the association key1val1, key2val2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssociationThread)))
(def AssumeDeterministic "AssumeDeterministic is an option for functions such as BayesianMinimization that specifies whether or not the function being considered should be assumed to be deterministic." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AssumeDeterministic)))
(def Assuming "Assuming[assum, expr] evaluates expr with assum appended to $Assumptions, so that assum is included in the default assumptions used by functions such as Refine, Simplify, and Integrate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Assuming)))
(def Assumptions "Assumptions is an option for functions such as Simplify, Refine, and Integrate that specifies default assumptions to be made about symbolic quantities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Assumptions)))
(def AstroAngularSeparation "AstroAngularSeparation[astro1, astro2] gives the angular distance on the celestial sphere between the astronomical objects astro1 and astro2, as observed from your current geo location.\nAstroAngularSeparation[astro1, astro2, observer] gives the angular distance between astro1 and astro2 as perceived by the given observer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroAngularSeparation)))
(def AstroBackground "AstroBackground is an option that specifies the background style of an AstroGraphics map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroBackground)))
(def AstroCenter "AstroCenter is an option for AstroGraphics that specifies the point of the celestial sphere that should appear at the center of the map of the sky." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroCenter)))
(def AstroDistance "AstroDistance[astro] returns the physical distance to the astronomical object astro as currently observed from your geo location.\nAstroDistance[astro, astro0] returns the physical distance to the astronomical object astro as currently observed from astro0.\nAstroDistance[astro, Dated[astro0, date]] returns the physical distance to astro as observed from astro0 on the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroDistance)))
(def AstroGraphics "AstroGraphics[primitives, options] represents a two-dimensional view of space and the celestial sphere." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroGraphics)))
(def AstroGridLines "AstroGridLines is an option for AstroGraphics that specifies the coordinate grid lines to show on the celestial sphere." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroGridLines)))
(def AstroGridLinesStyle "AstroGridLinesStyle is an option for AstroGraphics that specifies how coordinate grid lines should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroGridLinesStyle)))
(def AstroPosition "AstroPosition[{az, alt}] defines a location on the celestial sphere with azimuth az and altitude alt in the current horizontal frame at your geo position.\nAstroPosition[{az, alt, r}] defines a location in celestial space with horizon coordinates az, alt and at distance r from your geo position.\nAstroPosition[coords, frame] uses the given frame, such as \"Equatorial\", \"Horizon\", \"Galactic\", etc. to define the orientation and meaning of the spherical coordinates coords.\nAstroPosition[coords, frame, csys] represents a location in celestial space given by a list of numeric coords referenced to the given frame and using the coordinate system csys, such as \"Cartesian\", \"Cylindrical\", etc.\nAstroPosition[{coords1, coords2, …}, frame, csys] represents an array of celestial locations.\nAstroPosition[entity, frame, csys] returns the position of entity with respect to the given frame and coordinate system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroPosition)))
(def AstroProjection "AstroProjection is an option of AstroGraphics that specifies the cartographic projection to use for the map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroProjection)))
(def AstroRange "AstroRange is an option of AstroGraphics that specifies the included range of coordinates on the celestial sphere." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroRange)))
(def AstroRangePadding "AstroRangePadding is an option of AstroGraphics that specifies the padding to use when extending beyond the original ranges of coordinates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroRangePadding)))
(def AstroReferenceFrame "AstroReferenceFrame is an option of AstroGraphics that specifies the reference frame and setup of the observation corresponding to the sky map returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroReferenceFrame)))
(def AstroRiseSet "AstroRiseSet[astro] returns the dates of the next rising and next setting of the astronomical body astro.\nAstroRiseSet[astro, etype] returns the date of the next event of type etype, such as \"Rise\" or \"UpperCulmination\", for the given body astro, as observed from the current geo location.\nAstroRiseSet[astro, etype, loc] returns the date of the next event of type etype for the given body astro, as observed from location loc.\nAstroRiseSet[astro, etype, loc, date] returns the date of the next event of type etype after the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroRiseSet)))
(def AstroStyling "AstroStyling[\"skystyle\"] specifies the style to render the sky in an AstroGraphics map.\nAstroStyling[{\"skystyle\", param1->val1, param2->val2, …}] modifies the default parameter values of \"skystyle\" as given by the paramivali pairs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroStyling)))
(def AstroSubpoint "AstroSubpoint[astro] returns the geo location on Earth that currently has the given astro at its zenith.\nAstroSubpoint[astro, date] returns the geo location on Earth that has astro on its zenith on the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroSubpoint)))
(def AstroZoomLevel "AstroZoomLevel is an option of AstroGraphics and AstroStyling that specifies the level of resolution at which to render images." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AstroZoomLevel)))
(def Asymptotic "Asymptotic[expr, xx0] gives an asymptotic approximation for expr near x0.\nAsymptotic[expr, {x, x0, n}] gives an asymptotic approximation for expr near x0 to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Asymptotic)))
(def AsymptoticDSolveValue "AsymptoticDSolveValue[eqn, f, xx0] computes an asymptotic approximation to the differential equation eqn for f[x] centered at x0.\nAsymptoticDSolveValue[{eqn1, eqn2, …}, {f1, f2, …}, xx0] computes an asymptotic approximation to a system of differential equations.\nAsymptoticDSolveValue[eqn, f, x, ϵϵ0] computes an asymptotic approximation of f[x, ϵ] for the parameter ϵ centered at ϵ0.\nAsymptoticDSolveValue[eqn, f, …, {ξ, ξ0, n}] computes the asymptotic approximation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticDSolveValue)))
(def AsymptoticEqual "AsymptoticEqual[f, g, xx^*] gives conditions for f(x)≍g(x) or f(x)∈Θ(g(x)) as xx^*.\nAsymptoticEqual[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f(x1, …, xn)≍g(x1, …, xn) or f(x1, …, xn)∈Θ(g(x1, …, xn)) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticEqual)))
(def AsymptoticEquivalent "AsymptoticEquivalent[f, g, xx^*] gives conditions for f(x)∼g(x) as xx^*.\nAsymptoticEquivalent[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f (x1, …, xn) ~g(x1, …, xn) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticEquivalent)))
(def AsymptoticExpectation "AsymptoticExpectation[expr, xdist, aa0] computes an asymptotic approximation for the expectation of expr centered at a0, under the assumption that x follows the probability distribution dist.\nAsymptoticExpectation[expr, {x1, x2, …}dist, aa0] computes an asymptotic approximation for the expectation of expr centered at a0, under the assumption that {x1, x2, …} follows the multivariate distribution dist.\nAsymptoticExpectation[expr, vars, {a, a0, n}] computes the asymptotic expectation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticExpectation)))
(def AsymptoticGreater "AsymptoticGreater[f, g, xx^*] gives conditions for f(x)≻g(x) or f(x)∈ω(g(x)) as xx^*.\nAsymptoticGreater[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f(x1, …, xn)≻g(x1, …, xn) or f(x1, …, xn)∈ω(g(x1, …, xn)) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticGreater)))
(def AsymptoticGreaterEqual "AsymptoticGreaterEqual[f, g, xx^*] gives conditions for f(x)⪰g(x) or f(x)∈Ω(g(x)) as xx^*.\nAsymptoticGreaterEqual[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f(x1, …, xn)⪰g(x1, …, xn) or f(x1, …, xn)∈Ω(g(x1, …, xn)) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticGreaterEqual)))
(def AsymptoticIntegrate "AsymptoticIntegrate[f, x, xx0] computes an asymptotic approximation of the indefinite integral ∫f(x)x for x centered at x0.\nAsymptoticIntegrate[f, {x, a, b}, αα0] computes an asymptotic approximation of the definite integral ∫_a(α)^b(α)f(x, α)x for α centered at α0.\nAsymptoticIntegrate[f, …, {ξ, ξ0, n}] computes the asymptotic approximation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticIntegrate)))
(def AsymptoticLess "AsymptoticLess[f, g, xx^*] gives conditions for f(x)≺g(x) or f(x)∈o(g(x)) as xx^*.\nAsymptoticLess[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f(x1, …, xn)≺g(x1, …, xn) or f(x1, …, xn)∈o(g(x1, …, xn)) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticLess)))
(def AsymptoticLessEqual "AsymptoticLessEqual[f, g, xx^*] gives conditions for f(x)⪯g(x) or f(x)∈O(g(x)) as xx^*.\nAsymptoticLessEqual[f, g, {x1, …, xn}{x_1^*, …, x_n^*}] gives conditions for f(x1, …, xn)⪯g(x1, …, xn) or f(x1, …, xn)∈O(g(x1, …, xn)) as {x1, …, xn}{x_1^*, …, x_n^*}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticLessEqual)))
(def AsymptoticOutputTracker "AsymptoticOutputTracker[sys, {f1, …}, {p1, …}] gives the state feedback control law that causes the outputs of the affine system sys to track the reference signals fi with decay rates pj.\nAsymptoticOutputTracker[{sys, {out1, …}, {in1, …}}, …] specifies outputs outi and control inputs inj to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticOutputTracker)))
(def AsymptoticProbability "AsymptoticProbability[pred, xdist, aa0] computes an asymptotic approximation for the probability of pred centered at a0, under the assumption that x follows the probability distribution dist.\nAsymptoticProbability[pred, {x1, x2, …}dist, aa0] computes an asymptotic approximation for the probability of pred centered at a0, under the assumption that {x1, x2, …} follows the multivariate distribution dist.\nAsymptoticProbability[pred, vars, {a, a0, n}] computes the asymptotic probability to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticProbability)))
(def AsymptoticProduct "AsymptoticProduct[f, x, xx0] computes an asymptotic approximation of the indefinite product ∏_xf(x) for x near x0.\nAsymptoticProduct[f, {x, a, b}, αα0] computes an asymptotic approximation of the definite product ∏_a(α)^b(α)f(x, α) for α near α0.\nAsymptoticProduct[f, …, {ξ, ξ0, n}] computes the asymptotic approximation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticProduct)))
(def AsymptoticRSolveValue "AsymptoticRSolveValue[eqn, f, x∞] computes an asymptotic approximation to the difference equation eqn for f[x] near ∞. \nAsymptoticRSolveValue[{eqn1, eqn2, …}, {f1, f2, …}, x ∞] computes an asymptotic approximation to a system of difference equations.\nAsymptoticRSolveValue[eqn, f, x, ϵϵ0] computes an asymptotic approximation of f[x, ϵ] for the parameter ϵ centered at ϵ0.\nAsymptoticRSolveValue[eqn, f, …, {ξ, ξ0, n}] computes the asymptotic approximation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticRSolveValue)))
(def AsymptoticSolve "AsymptoticSolve[eqn, yb, x->a] computes asymptotic approximations of solutions y[x] of the equation eqn passing through {a, b}.\nAsymptoticSolve[eqn, {y}, x->a] computes asymptotic approximations of solutions y[x] of the equation eqn for x near a.\nAsymptoticSolve[eqns, {y1, y2, …}{b1, b2, …}, {x1, x2, …}{a1, a2, …}] computes asymptotic approximations of solutions {y1[x1, x2, …], y2[x1, x2, …], …} of the system of equations eqns.\nAsymptoticSolve[eqns, …, {{x1, x2, …}, {a1, a2, …}, n}] computes the asymptotic approximation to order n. \nAsymptoticSolve[…, Reals] computes only solutions that are real valued for real argument values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticSolve)))
(def AsymptoticSum "AsymptoticSum[f, x, xx0] computes an asymptotic approximation of the indefinite sum ∑f(x) for x centered at x0.\nAsymptoticSum[f, {x, a, b}, αα0] computes an asymptotic approximation of the definite sum ∑_a(α)^b(α)f(x, α) for α centered at α0.\nAsymptoticSum[f, …, {ξ, ξ0, n}] computes the asymptotic approximation to order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AsymptoticSum)))
(def Asynchronous "Asynchronous is an option for WolframAlpha that determines whether to use the asynchronous features of the Wolfram|Alpha API." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Asynchronous)))
(def Atom "Atom[\"sym\"] represents an atom with atomic symbol \"sym\".\nAtom[\"sym\", name->value, …] represents an atom with atomic symbol \"sym\" and specified properties." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Atom)))
(def AtomCoordinates "AtomCoordinates is an option for Molecule and related functions that specifies the three-dimensional coordinates of the atoms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomCoordinates)))
(def AtomCount "AtomCount[mol] gives the number of atoms in the molecule represented by mol.\nAtomCount[mol, patt] gives the number of atoms in the molecule mol matching the atom pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomCount)))
(def AtomDiagramCoordinates "AtomDiagramCoordinates is an option for Molecule and related functions that specifies the two-dimensional coordinates of the atoms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomDiagramCoordinates)))
(def AtomLabelStyle "AtomLabelStyle is an option for MoleculePlot and MoleculePlot3D that specifies the style to use for atom labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomLabelStyle)))
(def AtomLabels "AtomLabels is an option for MoleculePlot and MoleculePlot3D that specifies what labels and label positions should be used for atoms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomLabels)))
(def AtomList "AtomList[mol] gives the list of atoms in the molecule represented by mol.\nAtomList[mol, patt] gives the list of atoms in the molecule mol matching the atom pattern patt.\nAtomList[mol, patt, \"prop\"] gives the value for the specified property of the atoms matching patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomList)))
(def AtomQ "AtomQ[expr] yields True if expr is an expression which cannot be divided into subexpressions, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AtomQ)))
(def AttachCell "AttachCell[expr] makes expr a cell attached to the current cell being evaluated.\nAttachCell[obj, expr] makes expr a cell attached to the notebook, cell or box object obj.\nAttachCell[obj, expr, pos] specifies that the attached cell should be at position pos relative to obj.\nAttachCell[obj, expr, pos, dist] specifies that the attached cell should be at a distance dist from pos.\nAttachCell[obj, expr, pos, dist, opos] aligns the attached cell so that position opos in expr lies at distance dist from location pos.\nAttachCell[cellobj, expr, \"Inline\"] specifies that the attached cell should be positioned between the bottom of cellobj and its bottom margin." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AttachCell)))
(def AttachedCell "AttachedCell is an option for Cells that indicates whether to find cells that created with AttachCell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AttachedCell)))
(def AttentionLayer "AttentionLayer[] represents a trainable net layer that learns to pay attention to certain portions of its input. \nAttentionLayer[net] specifies a particular net to give scores for portions of the input. \nAttentionLayer[net, opts] includes options for weight normalization, masking and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AttentionLayer)))
(def Attributes "Attributes[symbol] gives the list of attributes for a symbol. \nAttributes[\"symbol\"] gives the attributes for the symbol named \"symbol\" if it exists.\nAttributes[{s1, s2, …}] gives a list of the attributes for each of the si." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Attributes)))
(def Audio "Audio[file] represents audio stored in the given file.\nAudio[url] represents audio stored in the given URL.\nAudio[data] represents audio with samples given by the array data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Audio)))
(def AudioAmplify "AudioAmplify[audio, s] multiplies all samples of audio by a factor s. \nAudioAmplify[video, s] amplifies the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioAmplify)))
(def AudioAnnotate "AudioAnnotate[audio, prop] computes the property prop and adds it as an annotation to audio.\nAudioAnnotate[audio, namespec] adds an annotation with the specified name and values spec to audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioAnnotate)))
(def AudioAnnotationLookup "AudioAnnotationLookup[audio] gives all annotations associated to audio.\nAudioAnnotationLookup[audio, tags] gives the annotations specified by tags.\nAudioAnnotationLookup[audio, tagsselector] gives a selection of annotations using selector.\nAudioAnnotationLookup[audio, tagsselector, format] formats each annotation element according to format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioAnnotationLookup)))
(def AudioBlockMap "AudioBlockMap[f, audio, dur] applies f to non-overlapping partitions of length dur in audio. \nAudioBlockMap[f, audio, {dur, offset}] applies f to partitions with offset offset in audio. \nAudioBlockMap[f, audio, {dur, offset, wfun}] applies f after applying wfun to partitions in audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioBlockMap)))
(def AudioCapture "AudioCapture[] creates a temporary interactive interface for capturing an audio signal.\nAudioCapture[file] captures an audio signal into file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioCapture)))
(def AudioChannelAssignment "AudioChannelAssignment is an option for Audio and related functions that specifies a mapping from audio channels to available speakers of the output audio device." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioChannelAssignment)))
(def AudioChannelCombine "AudioChannelCombine[{audio1, audio2, …}] creates a multichannel audio object by combining the sequence of channels in audioi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioChannelCombine)))
(def AudioChannelMix "AudioChannelMix[audio] mixes channels of audio by averaging and returns a center-panned stereo audio object.\nAudioChannelMix[audio, desttype] mixes audio channels into the specified desttype.\nAudioChannelMix[video, …] mixes audio channels of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioChannelMix)))
(def AudioChannelSeparate "AudioChannelSeparate[audio] gives a list of Audio objects, each of which represents one channel of audio.\nAudioChannelSeparate[audio, channel] returns the specified channel from audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioChannelSeparate)))
(def AudioChannels "AudioChannels[audio] returns the number of channels in the Audio object audio.\nAudioChannels[video] returns the number of channels of the first audio track of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioChannels)))
(def AudioData "AudioData[audio] gives an array of audio samples.\nAudioData[audio, \"type\"] gives an array of audio samples converted to the specified \"type\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioData)))
(def AudioDelay "AudioDelay[audio, delay] creates audio by adding repeated decaying echos to audio spaced by the specified delay.\nAudioDelay[audio, delay, feedback] uses the specified feedback as the amount of signal to preserve during each repetition.\nAudioDelay[audio, delay, feedback, mix] uses mix to control the ratio between original and delayed audio.\nAudioDelay[video, …] add delay to the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioDelay)))
(def AudioDelete "AudioDelete[audio, t] deletes the first t seconds of audio.\nAudioDelete[audio, -t] deletes the last t seconds of audio.\nAudioDelete[audio, {t1, t2}] deletes from time t1 to time t2, returning the remaining audio as a single Audio object.\nAudioDelete[audio, {{t11, t12}, …}] deletes multiple time intervals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioDelete)))
(def AudioDistance "AudioDistance[audio1, audio2] returns a distance measure between audio1 and audio2.\nAudioDistance[video1, video2] returns a distance measure between the audio tracks of video1 and video2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioDistance)))
(def AudioEncoding "AudioEncoding is an option for Export and other functions that specifies the audio encoding to use when creating an audio or a video file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioEncoding)))
(def AudioFade "AudioFade[audio] returns audio in which the beginning and end of audio are faded.\nAudioFade[audio, t] fades the first and last t seconds of audio.\nAudioFade[audio, {t1, t2}] fades t1 seconds at the beginning and t2 seconds at the end.\nAudioFade[video, …] fades the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioFade)))
(def AudioFrequencyShift "AudioFrequencyShift[audio, freq] gives audio by shifting the spectrum of audio by freq.\nAudioFrequencyShift[audio, freq, mix] uses mix to control the ratio between the original and shifted audio.\nAudioFrequencyShift[video, …] shifts the spectrum of the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioFrequencyShift)))
(def AudioGenerator "AudioGenerator[model] generates one second of audio of a given model.\nAudioGenerator[model, t] generates t seconds of audio.\nAudioGenerator[model, t, \"type\"] generates audio samples of the specified \"type\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioGenerator)))
(def AudioIdentify "AudioIdentify[audio] yields the result of attempting to identify what audio is a recording of.\nAudioIdentify[audio, category] restricts the identification to the specified category.\nAudioIdentify[audio, category, n] gives a list of up to n possible identifications.\nAudioIdentify[audio, category, n, \"prop\"] gives the specified property for each identification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioIdentify)))
(def AudioInputDevice "AudioInputDevice is an option for AudioCapture that specifies the device to use for audio recording." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioInputDevice)))
(def AudioInsert "AudioInsert[audio, tnew] inserts the audio signal new at time t.\nAudioInsert[audio, {t1, t2, …}new] inserts the same audio at multiple positions.\nAudioInsert[audio, {t1new1, …}] inserts multiple audio signals at different positions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioInsert)))
(def AudioInstanceQ "AudioInstanceQ[audio, obj] gives True if audio sounds to be an instance of the object obj, and gives False otherwise.\nAudioInstanceQ[audio, obj, cat] assumes that audio is the sound of something in the category cat." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioInstanceQ)))
(def AudioIntervals "AudioIntervals[audio] returns audible intervals of audio.\nAudioIntervals[audio, crit] returns intervals of audio for which the criterion crit is satisfied.\nAudioIntervals[audio, crit, mindur] returns only intervals larger than the given duration mindur.\nAudioIntervals[video, …] returns only intervals from the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioIntervals)))
(def AudioJoin "AudioJoin[audio1, audio2, …] or AudioJoin[{audio1, audio2, …}] concatenates all audioi and returns an audio object.\nAudioJoin[{audio1, t1}, {audio2, t2}, …] inserts ti seconds of silence after each audioi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioJoin)))
(def AudioLabel "AudioLabel is an option for an Audio object that specifies the label to show on the object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioLabel)))
(def AudioLength "AudioLength[audio] returns the number of samples in the Audio object audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioLength)))
(def AudioLocalMeasurements "AudioLocalMeasurements[audio, \"prop\"] computes the property \"prop\" locally for partitions of audio.\nAudioLocalMeasurements[audio, {prop1, prop2, …}] computes several properties \"propi\".\nAudioLocalMeasurements[audio, \"prop\", format] returns the measurements in the specified output format.\nAudioLocalMeasurements[video, …] computes the measurements from the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioLocalMeasurements)))
(def AudioLoudness "AudioLoudness[audio] computes the loudness of audio according to the EBU momentary definition.\nAudioLoudness[audio, def] computes the loudness according to the definition def.\nAudioLoudness[video, …] computes the loudness of the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioLoudness)))
(def AudioMeasurements "AudioMeasurements[audio, \"prop\"] computes the property \"prop\" for the entire audio.\nAudioMeasurements[audio, {prop1, prop2, …}] computes several properties \"propi\".\nAudioMeasurements[audio, \"prop\", format] returns the values in the specified output format.\nAudioMeasurements[{audio1, audio2, …}, …] returns measurements for all audioi.\nAudioMeasurements[video, …] returns measurements for the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioMeasurements)))
(def AudioNormalize "AudioNormalize[audio] normalizes audio so that the maximum absolute value of its samples is 1.\nAudioNormalize[audio, model] normalizes the audio signal based on the specified model.\nAudioNormalize[video] normalizes the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioNormalize)))
(def AudioOutputDevice "AudioOutputDevice is an option for Audio and related functions that specifies the device to use for playback." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioOutputDevice)))
(def AudioOverlay "AudioOverlay[{audio1, audio2, …}] returns an audio object by overlaying all audioi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioOverlay)))
(def AudioPad "AudioPad[audio, t] adds t seconds of silence to the end of audio.\nAudioPad[audio, {t1, t2}] adds t1 seconds of silence to the beginning and t2 seconds to the end of audio.\nAudioPad[audio, tspec, padding] pads using the value or method specified by padding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPad)))
(def AudioPan "AudioPan[audio] returns a center-panned stereo audio object from a mono audio. \nAudioPan[audio, pan] returns a stereo audio object after panning left and right channels using the specified pan.\nAudioPan[video, …] pans the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPan)))
(def AudioPartition "AudioPartition[audio, dur] partitions an audio object into non-overlapping segments of duration dur.\nAudioPartition[audio, dur, offset] generates segments with specified offset." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPartition)))
(def AudioPause "AudioPause[] pauses the playback of all AudioStream objects.\nAudioPause[astream] pauses the playback of the AudioStream object astream.\nAudioPause[audio] pauses the playback for all streams originated by audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPause)))
(def AudioPitchShift "AudioPitchShift[audio, r] applies pitch shifting to audio by the ratio r, shifting every frequency f to r f.\nAudioPitchShift[video, r] applies pitch shifting to the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPitchShift)))
(def AudioPlay "AudioPlay[audio] returns a new AudioStream object from audio and starts the playback.\nAudioPlay[astream] starts playing an AudioStream object astream." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPlay)))
(def AudioPlot "AudioPlot[audio] plots the waveform of audio.\nAudioPlot[{audio1, audio2, …}] plots waveforms of all audioi.\nAudioPlot[video] plots the waveform of the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioPlot)))
(def AudioQ "AudioQ[audio] yields True if audio has the form of a valid Audio object, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioQ)))
(def AudioRecord "AudioRecord[] returns a new AudioStream object and starts to record from the default input audio device.\nAudioRecord[inputdev] records from the input audio device inputdev.\nAudioRecord[astream] starts recording an AudioStream object astream that is connected to an input device." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioRecord)))
(def AudioReplace "AudioReplace[audio, {t1, t2}new] replaces the audio signal between t1 and t2 with the new signal new.\nAudioReplace[audio, {{t11, t12}, …}new] replaces multiple intervals with the same audio new.\nAudioReplace[audio, {{t11, t12}new1, …}] replaces multiple intervals.\nAudioReplace[audio, {t1, t2}new, fitting] uses the specified fitting method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioReplace)))
(def AudioResample "AudioResample[audio, sr] resamples audio to have the sample rate of sr.\nAudioResample[video, sr] resamples the first audio track in video to have the sample rate of sr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioResample)))
(def AudioReverb "AudioReverb[audio] adds reverberation to audio.\nAudioReverb[audio, model] adds reverberation following the room model.\nAudioReverb[audio, model, mix] controls the mix ratio between original and reverberated audio.\nAudioReverb[video, …] adds reverberation to the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioReverb)))
(def AudioReverse "AudioReverse[audio] reverses audio so that the signal is played backward.\nAudioReverse[video] reverses the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioReverse)))
(def AudioSampleRate "AudioSampleRate[audio] returns the sample rate of the Audio object audio.\nAudioSampleRate[video] returns the sample rate of the first audio track of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioSampleRate)))
(def AudioSpectralMap "AudioSpectralMap[f, audio] transforms audio by applying the function f to its short-time Fourier transform.\nAudioSpectralMap[f, {audio1, …}] applies the function f to the list of short-time Fourier transforms of all audioi.\nAudioSpectralMap[f, video] transforms the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioSpectralMap)))
(def AudioSpectralTransformation "AudioSpectralTransformation[f, audio] returns a modified version of audio by applying a time-frequency transformation f to its short-time Fourier transform.\nAudioSpectralTransformation[f, video] transforms the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioSpectralTransformation)))
(def AudioSplit "AudioSplit[audio, t] splits audio at time t.\nAudioSplit[audio, {t1, t2, …}] splits audio at times ti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioSplit)))
(def AudioStop "AudioStop[] stops the playback of all AudioStream objects.\nAudioStop[astream] stops the playback of the AudioStream object astream.\nAudioStop[audio] stops the playback for all streams originated by audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioStop)))
(def AudioStream "AudioStream[source] creates a new AudioStream object from source.\nAudioStream[id] is an object that represents a unique audio stream." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioStream)))
(def AudioStreams "AudioStreams[] returns all existing streams.\nAudioStreams[audio] returns all existing streams that originated from audio.\nAudioStreams[audio, \"prop\"] returns \"prop\" for all streams that originated from audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioStreams)))
(def AudioTimeStretch "AudioTimeStretch[audio, r] applies time stretching to audio by the specified factor r.\nAudioTimeStretch[video, r] applies time stretching to the first audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioTimeStretch)))
(def AudioTrackApply "AudioTrackApply[f, video] applies the function f to the first audio track of the Video object video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioTrackApply)))
(def AudioTrackSelection "AudioTrackSelection is an option that specifies the audio tracks of interest." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioTrackSelection)))
(def AudioTrim "AudioTrim[audio] trims silence from the beginning and end of audio.\nAudioTrim[audio, t] returns the first t seconds of audio.\nAudioTrim[audio, -t] returns the last t seconds of audio.\nAudioTrim[audio, {t1, t2}] returns audio starting at time t1 and ending at time t2 of audio.\nAudioTrim[audio, {{t11, t12}, …}] returns a list of audio for all given intervals {ti1, ti2}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioTrim)))
(def AudioType "AudioType[audio] returns the data type used to represent samples in the Audio object audio." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AudioType)))
(def AugmentedPolyhedron "AugmentedPolyhedron[poly] gives the augmented polyhedron poly by replacing each face by a pyramid. \nAugmentedPolyhedron[poly, h] gives the augmented polyhedron with a pyramid of height h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AugmentedPolyhedron)))
(def AugmentedSymmetricPolynomial "AugmentedSymmetricPolynomial[{r1, r2, …}] represents a formal augmented symmetric polynomial with exponents r1, r2, ….\nAugmentedSymmetricPolynomial[{{r11, …, r 1n}, {r21, …, r 2n}, …}] represents a multivariate formal augmented symmetric polynomial with exponent vectors {r11, …, r 1n}, {r21, …, r 2n}, ….\nAugmentedSymmetricPolynomial[rspec, data] gives the augmented symmetric polynomial in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AugmentedSymmetricPolynomial)))
(def Authentication "Authentication is an option for cloud, web and SSH access functions that allows authentication parameters to be given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Authentication)))
(def AuthenticationDialog "AuthenticationDialog[] initiates a standard dialog for entering username/password authentication information.\nAuthenticationDialog[\"type\"] initiates an authentication dialog of the specified standard type.\nAuthenticationDialog[{key1, key2, …}] initiates an authentication dialog that requests values for the specified keys.\nAuthenticationDialog[arg, func] applies the function func to the dialog's return value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AuthenticationDialog)))
(def AutoAction "AutoAction is an option for objects such as Slider, Locator, and Button that specifies whether they should automatically take action whenever the mouse pointer is over them, even if they are not clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoAction)))
(def AutoCopy "AutoCopy is an option for notebooks and cloud objects that specifies whether to automatically make a copy when the object is opened." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoCopy)))
(def AutoDelete "AutoDelete is an option for boxes that specifies whether a box is automatically deleted when its contents are edited." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoDelete)))
(def AutoIndent "AutoIndent is an option for Style and Cell that specifies what automatic indentation should be done at the beginning of a new line after an explicit return character has been entered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoIndent)))
(def AutoItalicWords "AutoItalicWords is an option for Cell that gives a list of words that should automatically be put in italics when they are entered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoItalicWords)))
(def AutoMultiplicationSymbol "AutoMultiplicationSymbol is an option for objects such as Cell and Notebook that specifies when to automatically display a multiplication symbol between elements separated by whitespace that implies multiplication." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoMultiplicationSymbol)))
(def AutoOperatorRenderings "AutoOperatorRenderings is an option for cells and notebooks that specifies automatic renderings to be used for strings representing operators." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoOperatorRenderings)))
(def AutoRefreshed "AutoRefreshed[expr] represents an expression to be reevaluated every hour and made available in the cloud.\nAutoRefreshed[expr, dt] reevaluates at time interval dt. \nAutoRefreshed[expr, timespec] reevaluates on the schedule specified by timespec.\nAutoRefreshed[expr, timespec, fmt] specifies that the result from evaluating expr should be given in format fmt.\nAutoRefreshed[expr, timespec, {fmt, rform}] specifies that the result should be given as a response of the form rform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoRefreshed)))
(def AutoRemove "AutoRemove is an option specifying whether tasks, generators, cloud objects and related constructs should be removed after they are executed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoRemove)))
(def AutoScroll "AutoScroll is an option to SelectionMove and related functions that specifies whether a notebook should automatically be scrolled to display the current selection." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoScroll)))
(def AutoSpacing "AutoSpacing is an option for Style and Cell that specifies whether spaces between successive characters should be adjusted automatically." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoSpacing)))
(def AutoSubmitting "AutoSubmitting[spec] represents an element of a form that automatically submits the whole form if it is entered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutoSubmitting)))
(def Autocomplete "Autocomplete[{string1, string2, …}, \"string\"] gives a list of the stringi that can complete string.\nAutocomplete[s1w1, s2w2, …, \"string\"] puts the completions in order of decreasing weights wi.\nAutocomplete[{assoc1, assoc2, …}, \"string\"] uses completions specified by the associations associ.\nAutocomplete[comps, \"string\", n] gives the first at most n completions.\nAutocomplete[comps] gives an AutocompletionFunction[…] that can be applied to a string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Autocomplete)))
(def AutocompletionFunction "AutocompletionFunction[…] represents a function to be applied to a string to generate possible completions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutocompletionFunction)))
(def AutocorrelationTest "AutocorrelationTest[data] tests whether the data is autocorrelated.\nAutocorrelationTest[data, k] tests whether the data is autocorrelated up to lag k.\nAutocorrelationTest[data, k, \"property\"] returns the value of \"property\" for a given model." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutocorrelationTest)))
(def Automatic "Automatic represents an option or other value that is to be chosen automatically by a built‐in function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Automatic)))
(def AutorunSequencing "AutorunSequencing is an option for Manipulate that specifies how autorun should use the controls provided." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AutorunSequencing)))
(def Axes "Axes is an option for graphics functions that specifies whether axes should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Axes)))
(def AxesEdge "AxesEdge is an option for three-dimensional graphics functions that specifies on which edges of the bounding box axes should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxesEdge)))
(def AxesLabel "AxesLabel is an option for graphics functions that specifies labels for axes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxesLabel)))
(def AxesOrigin "AxesOrigin is an option for graphics functions that specifies where any axes drawn should cross." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxesOrigin)))
(def AxesStyle "AxesStyle is an option for graphics functions that specifies how axes should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxesStyle)))
(def AxiomaticTheory "AxiomaticTheory[\"theory\"] gives an axiomatic representation of the specified axiomatic theory.\nAxiomaticTheory[{\"theory\", <|op1->s1, op2->s2, …|>}] uses si to represent the operator opi in the theory.\nAxiomaticTheory[theory, \"property\"] gives the specified property of an axiomatic theory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxiomaticTheory)))
(def Axis "Axis is a symbol that represents the axis for purposes of alignment and positioning." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Axis)))
(def AxisLabel "AxisLabel is an option for AxisObject that specifies a label for the axis." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxisLabel)))
(def AxisObject "AxisObject[path] is a Graphics primitive that represents an axis with a quantitative scale along the path path.\nAxisObject[path, scale] uses the scale specified by scale." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxisObject)))
(def AxisStyle "AxisStyle is an option for AxisObject that specifies how to style the path of an axis." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote AxisStyle)))
(def BSplineBasis "BSplineBasis[d, x] gives the zeroth uniform B-spline basis function of degree d at x.\nBSplineBasis[d, n, x] gives the n ^th uniform B-spline basis function of degree d.\nBSplineBasis[{d, {u1, u2, …}}, n, x]  gives the n ^th non-uniform B-spline basis function of degree d with knots at positions ui." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BSplineBasis)))
(def BSplineCurve "BSplineCurve[{pt1, pt2, …}] is a graphics primitive that represents a nonuniform rational B-spline curve with control points pti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BSplineCurve)))
(def BSplineFunction "BSplineFunction[{pt1, pt2, …}] represents a B-spline function for a curve defined by the control points pti.\nBSplineFunction[array] represents a B-spline function for a surface or high-dimensional manifold." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BSplineFunction)))
(def BSplineSurface "BSplineSurface[array] is a graphics primitive that represents a nonuniform rational B-spline surface defined by an array of x, y, z control points." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BSplineSurface)))
(def BabyMonsterGroupB "BabyMonsterGroupB[] represents the sporadic simple baby monster group B." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BabyMonsterGroupB)))
(def Back "Back is a symbol that represents the back of a graphic for purposes of placement and alignment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Back)))
(def Background "Background is an option that specifies what background color to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Background)))
(def Backslash "Backslash[x, y, …] displays as x∖y∖…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Backslash)))
(def Backward "Backward is a symbol that represents the backward direction for purposes of motion and animation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Backward)))
(def Ball "Ball[p] represents the unit ball centered at the point p.\nBall[p, r] represents the ball of radius r centered at the point p.\nBall[{p1, p2, …}, r] represents a collection of balls of radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Ball)))
(def Band "Band[{i, j}] represents the sequence of positions on the diagonal band that starts with {i, j} in a sparse array.\nBand[{imin, jmin, …}, {imax, jmax, …}] represents the positions between {imin, jmin, …} and {imax, jmax, …}.\nBand[{imin, jmin, …}, {imax, jmax, …}, {di, dj, …}] represents positions starting with {imin, jmin, …} and then moving with step {di, dj, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Band)))
(def BandpassFilter "BandpassFilter[data, {ω1, ω2}] applies a bandpass filter with cutoff frequencies ω1 and ω2 to an array of data.\nBandpassFilter[data, {{ω, q}}] uses center frequency ω and quality factor q.\nBandpassFilter[data, spec, n] uses a filter kernel of length n.\nBandpassFilter[data, spec, n, wfun] applies a smoothing window wfun to the filter kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BandpassFilter)))
(def BandstopFilter "BandstopFilter[data, {ω1, ω2}] applies a bandstop filter with cutoff frequencies ω1 and ω2 to an array of data.\nBandstopFilter[data, {{ω, q}}] uses center frequency ω and quality factor q. \nBandstopFilter[data, spec, n] uses a filter kernel of length n.\nBandstopFilter[data, spec, n, wfun] applies a smoothing window wfun to the filter kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BandstopFilter)))
(def BarChart "BarChart[{y1, y2, …, yn}] makes a bar chart with bar lengths y1,  y2, ….\nBarChart[{…, wi[yi, …], …, wj[yj, …], …}] makes a bar chart with bar features defined by the symbolic wrappers wk.\nBarChart[{data1, data2, …}] makes a bar chart from multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarChart)))
(def BarChart3D "BarChart3D[{y1, y2, …}] makes a 3D bar chart with bar lengths y1, y2, … .\nBarChart3D[{…, wi[yi, …], …, wj[yj, …], …}] makes a 3D bar chart with bar features defined by the symbolic wrappers wk.\nBarChart3D[{data1, data2, …}] makes a 3D bar chart from multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarChart3D)))
(def BarLegend "BarLegend[cf] generates a legend that identifies colors from the color function cf with an automatic range of values.\nBarLegend[{cf, {min, max}}] generates a legend that identifies colors from the color function cf with the range of values between min and max.\nBarLegend[cf, contours] generates a legend that identifies color ranges from the color function cf based on the set of contours contours." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarLegend)))
(def BarOrigin "BarOrigin is an option to BarChart and related functions that specifies the origin placement for bars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarOrigin)))
(def BarSpacing "BarSpacing is an option to BarChart and related functions that controls the spacing between bars and groups of bars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarSpacing)))
(def BarabasiAlbertGraphDistribution "BarabasiAlbertGraphDistribution[n, k] represents a Barabasi–Albert graph distribution for n-vertex graphs where a new vertex with k edges is added at each step." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarabasiAlbertGraphDistribution)))
(def BarcodeImage "BarcodeImage[\"string\"] generates a barcode image of \"string\" in the \"QR\" format.\nBarcodeImage[\"string\", format] generates a barcode image of \"string\" in the specified format.\nBarcodeImage[\"string\", format, size] attempts to generate a barcode image of the specified size." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarcodeImage)))
(def BarcodeRecognize "BarcodeRecognize[image] recognizes a barcode in image and returns it as a string.\nBarcodeRecognize[image, \"prop\"] returns the specified property of the barcode.\nBarcodeRecognize[image, \"prop\", format] recognizes barcodes of the specified format only." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarcodeRecognize)))
(def BaringhausHenzeTest "BaringhausHenzeTest[data] tests whether data follows a MultinormalDistribution using the Baringhaus–Henze test.\nBaringhausHenzeTest[data, MultinormalDistribution[μ, Σ]] tests whether data follows the distribution with mean vector μ and covariance matrix Σ.\nBaringhausHenzeTest[data, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaringhausHenzeTest)))
(def BarlowProschanImportance "BarlowProschanImportance[rdist] gives the Barlow–Proschan importances for all components in the ReliabilityDistribution rdist. \nBarlowProschanImportance[fdist] gives the Barlow–Proschan importances for all components in the FailureDistribution fdist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarlowProschanImportance)))
(def BarnesG "BarnesG[z] gives the Barnes G-function G (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BarnesG)))
(def BartlettHannWindow "BartlettHannWindow[x] represents a Bartlett–Hann window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BartlettHannWindow)))
(def BartlettWindow "BartlettWindow[x] represents a Bartlett window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BartlettWindow)))
(def BaseDecode "BaseDecode[\"string\"] decodes the Base64 data contained in a string and returns the result as a byte array.\nBaseDecode[\"string\", \"encoding\"] decodes using the string using the specified encoding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaseDecode)))
(def BaseEncode "BaseEncode[ba] encodes the byte array ba as a Base64 string.\nBaseEncode[ba, \"encoding\"] encodes using the specified encoding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaseEncode)))
(def BaseForm "BaseForm[expr, n] prints with the numbers in expr given in base n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaseForm)))
(def BaseStyle "BaseStyle is an option for formatting and related constructs that specifies the base style to use for them." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaseStyle)))
(def Baseline "Baseline is a symbol that represents the baseline for purposes of alignment and positioning." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Baseline)))
(def BaselinePosition "BaselinePosition is an option that specifies where the baseline of an object is considered to be for purposes of alignment with surrounding text or other expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BaselinePosition)))
(def BasicRecurrentLayer "BasicRecurrentLayer[n] represents a trainable recurrent layer that takes a sequence of vectors and produces a sequence of vectors each of size n.\nBasicRecurrentLayer[n, opts] includes options for initial weights and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BasicRecurrentLayer)))
(def BatchNormalizationLayer "BatchNormalizationLayer[] represents a trainable net layer that normalizes its input data by learning the data mean and variance." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BatchNormalizationLayer)))
(def BatchSize "BatchSize is an option for NetTrain and related functions that specifies the size of a batch of examples to process together." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BatchSize)))
(def BatesDistribution "BatesDistribution[n] represents the distribution of a mean of n random variables uniformly distributed from 0 to 1.\nBatesDistribution[n, {min, max}] represents the distribution of a mean of n random variables uniformly distributed from min to max." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BatesDistribution)))
(def BattleLemarieWavelet "BattleLemarieWavelet[] represents the Battle–Lemarié wavelet of order 3.\nBattleLemarieWavelet[n] represents the Battle–Lemarié wavelet of order n evaluated on equally spaced interval {-10, 10}.\nBattleLemarieWavelet[n, lim] represents the Battle–Lemarié wavelet of order n evaluated on equally spaced interval {-lim, lim}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BattleLemarieWavelet)))
(def BayesianMaximization "BayesianMaximization[f, {conf1, conf2, …}] gives an object representing the result of Bayesian maximization over the function f over the configurations confi.\nBayesianMaximization[f, reg] maximizes over the region represented by the region specification reg.\nBayesianMaximization[f, sampler] maximizes over configurations obtained by applying the function sampler.\nBayesianMaximization[f, {conf1, conf2, …}nsampler] applies the function nsampler to successively generate configurations starting from the confi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BayesianMaximization)))
(def BayesianMaximizationObject "BayesianMaximizationObject[…] represents the result of a Bayesian maximization process." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BayesianMaximizationObject)))
(def BayesianMinimization "BayesianMinimization[f, {conf1, conf2, …}] gives an object representing the result of Bayesian minimization of the function f over the configurations confi. \nBayesianMinimization[f, reg] minimizes over the region represented by the region specification reg.\nBayesianMinimization[f, sampler] minimizes over configurations obtained by applying the function sampler. \nBayesianMinimization[f, {conf1, conf2, …}nsampler] applies the function nsampler to successively generate configurations starting from the confi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BayesianMinimization)))
(def BayesianMinimizationObject "BayesianMinimizationObject[…] represents the result of a Bayesian minimization process." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BayesianMinimizationObject)))
(def Because "Because[x, y] displays as x∵y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Because)))
(def BeckmannDistribution "BeckmannDistribution[μ1, μ2, σ1, σ2] represents the Beckmann distribution with means μ1 and μ2 and standard deviations σ1 and σ2.\nBeckmannDistribution[μ1, μ2, σ1, σ2, ρ] represents the Beckmann distribution with means μ1 and μ2, standard deviations σ1 and σ2, and correlation ρ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BeckmannDistribution)))
(def Beep "Beep[] generates an audible beep when evaluated. \nBeep[\"message\"] beeps and populates the Why the Beep dialog with message." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Beep)))
(def Before "Before is a symbol that represents the region before an object for purposes of placement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Before)))
(def Begin "Begin[\"context`\"] resets the current context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Begin)))
(def BeginDialogPacket "BeginDialogPacket[integer] is a WSTP packet that indicates the start of the Dialog subsession referenced by integer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BeginDialogPacket)))
(def BeginPackage "BeginPackage[\"context`\"] makes context` and System` the only active contexts. \nBeginPackage[\"context`\", {\"need1 `\", \"need2 `\", …}] calls Needs on the needi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BeginPackage)))
(def BellB "BellB[n] gives the Bell number Bn. \nBellB[n, x] gives the Bell polynomial Bn (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BellB)))
(def BellY "BellY[n, k, {x1, …, x n-k+1}] gives the partial Bell polynomial Y n, k(x1, …, x n-k+1).\nBellY[n, k, m] gives the generalized partial Bell polynomial of a matrix m.\nBellY[m] gives the generalized Bell polynomial of a matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BellY)))
(def Below "Below is a symbol that represents the region below an object for purposes of placement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Below)))
(def BenfordDistribution "BenfordDistribution[b] represents a Benford distribution with base parameter b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BenfordDistribution)))
(def BeniniDistribution "BeniniDistribution[α, β, σ] represents a Benini distribution with shape parameters α and β and scale parameter σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BeniniDistribution)))
(def BenktanderGibratDistribution "BenktanderGibratDistribution[a, b] represents a Benktander distribution of type I with parameters a and b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BenktanderGibratDistribution)))
(def BenktanderWeibullDistribution "BenktanderWeibullDistribution[a, b] represents a Benktander distribution of type II with parameters a and b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BenktanderWeibullDistribution)))
(def BernoulliB "BernoulliB[n] gives the Bernoulli number Bn. \nBernoulliB[n, x] gives the Bernoulli polynomial Bn (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BernoulliB)))
(def BernoulliDistribution "BernoulliDistribution[p] represents a Bernoulli distribution with probability parameter p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BernoulliDistribution)))
(def BernoulliGraphDistribution "BernoulliGraphDistribution[n, p] represents a Bernoulli graph distribution for n-vertex graphs with edge probability p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BernoulliGraphDistribution)))
(def BernoulliProcess "BernoulliProcess[p] represents a Bernoulli process with event probability p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BernoulliProcess)))
(def BernsteinBasis "BernsteinBasis[d, n, x] represents the n ^th Bernstein basis function of degree d at x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BernsteinBasis)))
(def BesagL "BesagL[pdata, r] estimates Besag's L function L(r) for point data pdata at radius r.\nBesagL[pproc, r] computes L(r) for the point process pproc.\nBesagL[bdata, r] computes L(r) for binned data bdata. \nBesagL[pspec] generates the function L that can be applied repeatedly to different radii r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesagL)))
(def BesselFilterModel "BesselFilterModel[n] designs a lowpass Bessel filter of order n and cutoff frequency 1.\nBesselFilterModel[{n, ωc}] uses the cutoff frequency ωc.\nBesselFilterModel[{n, ωc}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselFilterModel)))
(def BesselI "BesselI[n, z] gives the modified Bessel function of the first kind In (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselI)))
(def BesselJ "BesselJ[n, z] gives the Bessel function of the first kind Jn (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselJ)))
(def BesselJZero "BesselJZero[n, k] represents the k ^th zero of the Bessel function Jn (x).\nBesselJZero[n, k, x0] represents the k ^th zero greater than x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselJZero)))
(def BesselK "BesselK[n, z] gives the modified Bessel function of the second kind Kn (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselK)))
(def BesselY "BesselY[n, z] gives the Bessel function of the second kind Yn (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselY)))
(def BesselYZero "BesselYZero[n, k] represents the k ^th zero of the Bessel function of the second kind Yn (x).\nBesselYZero[n, k, x0] represents the k ^th zero greater than x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BesselYZero)))
(def Beta "Beta[a, b] gives the Euler beta function Β (a, b). \nBeta[z, a, b] gives the incomplete beta function Βz (a, b)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Beta)))
(def BetaBinomialDistribution "BetaBinomialDistribution[α, β, n] represents a beta binomial mixture distribution with beta distribution parameters α and β, and n binomial trials." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetaBinomialDistribution)))
(def BetaDistribution "BetaDistribution[α, β] represents a continuous beta distribution with shape parameters α and β." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetaDistribution)))
(def BetaNegativeBinomialDistribution "BetaNegativeBinomialDistribution[α, β, n] represents a beta negative binomial mixture distribution with beta distribution parameters α and β and n successful trials." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetaNegativeBinomialDistribution)))
(def BetaPrimeDistribution "BetaPrimeDistribution[p, q] represents a beta prime distribution with shape parameters p and q. \nBetaPrimeDistribution[p, q, β] represents a generalized beta prime distribution with scale parameter β.\nBetaPrimeDistribution[p, q, α, β] represents a generalized beta distribution of the second kind with shape parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetaPrimeDistribution)))
(def BetaRegularized "BetaRegularized[z, a, b] gives the regularized incomplete beta function Iz (a, b)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetaRegularized)))
(def Between "Between[x, {min, max}] is equivalent to min≤x≤max.\nBetween[x, {{min1, max1}, {min2, max2}, …}] is equivalent to min1≤x≤max1||min2≤x≤max2||….\nBetween[range] is an operator form that yields Between[x, range] when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Between)))
(def BetweennessCentrality "BetweennessCentrality[g] gives a list of betweenness centralities for the vertices in the graph g.\nBetweennessCentrality[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BetweennessCentrality)))
(def BeveledPolyhedron "BeveledPolyhedron[poly] gives the beveled polyhedron of poly, by beveling each edge. \nBeveledPolyhedron[poly, l] bevels the polyhedron poly by a length ratio l at its edges." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BeveledPolyhedron)))
(def BezierCurve "BezierCurve[{pt1, pt2, …}] is a graphics primitive that represents a Bézier curve with control points pti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BezierCurve)))
(def BezierFunction "BezierFunction[{pt1, pt2, …}] represents a Bézier function for a curve defined by the control points pti.\nBezierFunction[array] represents a Bézier function for a surface or high-dimensional manifold." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BezierFunction)))
(def BilateralFilter "BilateralFilter[data, σ, μ] applies a bilateral filter of spatial spread σ and pixel value spread μ to data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BilateralFilter)))
(def BilateralHypergeometricPFQ "BilateralHypergeometricPFQ[{a1, …, ap}, {b1, …, bq}, z] is the bilateral hypergeometric function pHq (a;b;z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BilateralHypergeometricPFQ)))
(def BilateralLaplaceTransform "BilateralLaplaceTransform[expr, t, s] gives the bilateral Laplace transform of expr. \nBilateralLaplaceTransform[expr, {t1, t2, …, tn}, {s1, s2, …, sn}] gives the multidimensional bilateral Laplace transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BilateralLaplaceTransform)))
(def BilateralZTransform "BilateralZTransform[expr, n, z] gives the bilateral Z transform of expr.\nBilateralZTransform[expr, {n1, …, nk}, {z1, …, zk}] gives the multidimensional bilateral Z transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BilateralZTransform)))
(def BinCounts "BinCounts[data] counts the number of elements of data whose values lie in successive integer bins.\nBinCounts[data, binspec] counts the number of elements of data whose values lie in successive bins specified by binspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinCounts)))
(def BinLists "BinLists[data] gives lists of the elements of data whose values lie in successive integer bins.\nBinLists[data, binspec] gives lists of the elements of data whose values lie in successive bins specified by binspec.\nBinLists[datainds, …] gives the lists of the labels inds specified by the binning of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinLists)))
(def Binarize "Binarize[image] creates a binary image from image by replacing all values above a globally determined threshold with 1 and others with 0.\nBinarize[image, t] creates a binary image by replacing all values above t with 1 and others with 0.\nBinarize[image, {t1, t2}] creates a binary image by replacing all values in the range t1 through t2 with 1 and others with 0.\nBinarize[image, f] creates a binary image by replacing all channel value lists for which f[v] yields True with 1 and others with 0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Binarize)))
(def BinaryDeserialize "BinaryDeserialize[ByteArray[…]] recovers an expression from a binary representation generated by BinarySerialize.\nBinaryDeserialize[ByteArray[…], h] wraps h around the expression produced before returning it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryDeserialize)))
(def BinaryDistance "BinaryDistance[u, v] gives the binary distance between vectors u and v, equal to 0 if they are identical and 1 otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryDistance)))
(def BinaryFormat "BinaryFormat is an option for OpenRead and related functions that specifies that a stream should be opened in binary format, so that no textual interpretation of newlines or other data is done." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryFormat)))
(def BinaryImageQ "BinaryImageQ[image] yields True if image has the form of a binary Image or Image3D object, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryImageQ)))
(def BinaryRead "BinaryRead[stream] reads one byte of raw binary data from an input stream, and returns an integer from 0 to 255. \nBinaryRead[stream, type] reads an object of the specified type. \nBinaryRead[stream, {type1, type2, …}] reads a sequence of objects of the specified types." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryRead)))
(def BinaryReadList "BinaryReadList[\"file\"] reads all remaining bytes from a file, and returns them as a list of integers from 0 to 255. \nBinaryReadList[\"file\", type] reads objects of the specified type from a file, until the end of the file is reached. The list of objects read is returned. \nBinaryReadList[\"file\", {type1, type2, …}] reads objects with a sequence of types, until the end of the file is reached. \nBinaryReadList[\"file\", types, n] reads only the first n objects of the specified types." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryReadList)))
(def BinarySerialize "BinarySerialize[expr] gives a binary representation of any expression expr as a ByteArray object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinarySerialize)))
(def BinaryWrite "BinaryWrite[channel, b] writes a byte of data, specified as an integer from 0 to 255. \nBinaryWrite[channel, {b1, b2, …}] writes a sequence of bytes. \nBinaryWrite[channel, \"string\"] writes the raw sequence of characters in a string. \nBinaryWrite[channel, ByteArray[…]] writes the contents of a ByteArray object.\nBinaryWrite[channel, x, type] writes an object of the specified type. \nBinaryWrite[channel, {x1, x2, …}, type] writes a sequence of objects of the specified type. \nBinaryWrite[channel, {x1, x2, …}, {type1, type2, …}] writes a sequence of objects with a sequence of types." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinaryWrite)))
(def BinnedVariogramList "BinnedVariogramList[{loc1val1, loc2val2, …}] computes a variogram using binned values. \nBinnedVariogramList[{loc1, loc2, …}{val1, val2, …}] generates the same result.\nBinnedVariogramList[…, spec] allows binning spec to be specified as given in HistogramList." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinnedVariogramList)))
(def Binomial "Binomial[n, m] gives the binomial coefficient (n\nm\n\n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Binomial)))
(def BinomialDistribution "BinomialDistribution[n, p] represents a binomial distribution with n trials and success probability p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinomialDistribution)))
(def BinomialPointProcess "BinomialPointProcess[n, reg] represents a binomial point process with n points in the region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinomialPointProcess)))
(def BinomialProcess "BinomialProcess[p] represents a binomial process with event probability p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinomialProcess)))
(def BinormalDistribution "BinormalDistribution[{μ1, μ2}, {σ1, σ2}, ρ] represents a bivariate normal distribution with mean {μ1, μ2} and covariance matrix {{σ1^2, ρ σ1 σ2}, {ρ σ1 σ2, σ2^2}}.\nBinormalDistribution[{σ1, σ2}, ρ] represents a bivariate normal distribution with zero mean.\nBinormalDistribution[ρ] represents a bivariate normal distribution with zero mean and covariance matrix {{1, ρ }, {ρ, 1}}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BinormalDistribution)))
(def BioMolecule "BioMolecule[…] represents a (typically large) biomolecule consisting of biopolymer chains and associated ligand molecules. \nBioMolecule[id] returns the biomolecule associated with the input identifier id.\nBioMolecule[BioSequence[\"Peptide\", seq]] attempts to return a biomolecule representing a folded version of the input sequence seq.\nBioMolecule[biomolpart] returns a new biomolecule consisting of the part part of biomol." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioMolecule)))
(def BioMoleculeFoldingMethod "BioMoleculeFoldingMethod is an option for BioMolecule to determine how to fold an input peptide sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioMoleculeFoldingMethod)))
(def BioMoleculePlot3D "BioMoleculePlot3D[biomol] creates a three-dimensional graphic of the biomolecule biomol.\nBioMoleculePlot3D[biomolpart] shows only the part part of biomol." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioMoleculePlot3D)))
(def BioMoleculeValue "BioMoleculeValue[biomol, prop] returns the value of the property prop for the BioMolecule biomol.\nBioMoleculeValue[biomolpart, prop] returns the property value association with part of biomol." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioMoleculeValue)))
(def BioSequence "BioSequence[type, \"seq\"] represents the biomolecular sequence of the given type corresponding to a string \"seq\".\nBioSequence[\"seq\"] infers the type (DNA, protein, etc.) from the sequence.\nBioSequence[ent] gives the biomolecular sequence associated with the gene or protein entity ent.\nBioSequence[type, {chem1, chem2, …}] gives the biomolecular sequence with type corresponding to the given list of chemicals.\nBioSequence[type, n] gives a biomolecular sequence of the given type and length n with arbitrary letters.\nBioSequence[type, \"seq\", {bond1, bond2, …}] represents a biomolecular sequence with the given list of bonds.\nBioSequence[\"HybridStrand\", {bioseq1, bioseq2, …}, {bond1, bond2, …}] represents a sequence composed of multiple motif sequences with shared primary linkage.\nBioSequence[{bioseq1, bioseq2, …}, {bond1, bond2, …}] represents a number of sequences linked only by additional bonds." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequence)))
(def BioSequenceBackTranslateList "BioSequenceBackTranslateList[bioseq] gives the generalized back translations of a peptide sequence bioseq.\nBioSequenceBackTranslateList[bioseq, gtt] uses the genetic translation table gtt.\nBioSequenceBackTranslateList[bioseq, gtt, startspec] treats the starting amino acid in bioseq according to the specification startspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceBackTranslateList)))
(def BioSequenceComplement "BioSequenceComplement[bioseq] gives the biological complement of the sequence bioseq." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceComplement)))
(def BioSequenceInstances "BioSequenceInstances[bioseq] expands the possibly degenerate sequence bioseq into all fully specified corresponding sequences.\nBioSequenceInstances[bioseq, n] expands the sequence bioseq into at most n fully specified corresponding sequences." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceInstances)))
(def BioSequenceModify "BioSequenceModify[seq, \"mod\"] gives the result of applying the modification \"mod\" to the sequence seq.\nBioSequenceModify[seq, {\"mod\", params}] specifies the parameters params for \"mod\".\nBioSequenceModify[modspec] represents an operator form of BioSequenceModify that can be applied to a biomolecular sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceModify)))
(def BioSequencePlot "BioSequencePlot[bioseq] creates a two-dimensional schematic diagram of the biomolecular sequence bioseq." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequencePlot)))
(def BioSequenceQ "BioSequenceQ[bioseq] returns True if bioseq is a valid BioSequence expression, and False otherwise.\nBioSequenceQ[bioseq, spec] returns True if bioseq is a valid BioSequence expression matching a specification spec, and False otherwise.\nBioSequenceQ[bioseq, spec1|spec2|...] returns True if bioseq is a valid BioSequence expression matching any of the speci, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceQ)))
(def BioSequenceReverseComplement "BioSequenceReverseComplement[bioseq] biologically complements and reverses the sequence bioseq." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceReverseComplement)))
(def BioSequenceTranscribe "BioSequenceTranscribe[bioseq] transcribes DNA into RNA or inverts the transcription of RNA back to DNA for the sequence bioseq." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceTranscribe)))
(def BioSequenceTranslate "BioSequenceTranslate[bioseq] translates a DNA or RNA sequence bioseq to a peptide sequence.\nBioSequenceTranslate[bioseq, gtt] uses the genetic translation table gtt.\nBioSequenceTranslate[bioseq, gtt, startspec] treats start codons in bioseq according to the specification startspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BioSequenceTranslate)))
(def BiorthogonalSplineWavelet "BiorthogonalSplineWavelet[] represents a biorthogonal spline wavelet of order 4 and dual order 2.\nBiorthogonalSplineWavelet[n, m] represents a biorthogonal spline wavelet of order n and dual order m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BiorthogonalSplineWavelet)))
(def BipartiteGraphQ "BipartiteGraphQ[g] yields True if the graph g is a bipartite graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BipartiteGraphQ)))
(def BiquadraticFilterModel "BiquadraticFilterModel[{ω, q}] creates a lowpass biquadratic filter using the characteristic frequency ω and the quality factor q.\nBiquadraticFilterModel[{\"type\", spec}] creates a filter of a given {\"type\", spec}.\nBiquadraticFilterModel[{\"type\", spec}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BiquadraticFilterModel)))
(def BirnbaumImportance "BirnbaumImportance[rdist, t] gives the Birnbaum importances for all components in the ReliabilityDistribution rdist at time t.\nBirnbaumImportance[fdist, t] gives the Birnbaum importances for all components in the FailureDistribution fdist at time t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BirnbaumImportance)))
(def BirnbaumSaundersDistribution "BirnbaumSaundersDistribution[α, λ] represents the Birnbaum–Saunders distribution with shape parameter α and scale parameter λ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BirnbaumSaundersDistribution)))
(def BitAnd "BitAnd[n1, n2, …] gives the bitwise AND of the integers ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitAnd)))
(def BitClear "BitClear[n, k] sets to 0 the bit corresponding to the coefficient of 2^k in the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitClear)))
(def BitFlip "BitFlip[n, k] flips the bit corresponding to the coefficient of 2^k in the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitFlip)))
(def BitGet "BitGet[n, k] gets the bit corresponding to the coefficient of 2^k in the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitGet)))
(def BitLength "BitLength[n] gives the number of binary bits necessary to represent the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitLength)))
(def BitNot "BitNot[n] gives the bitwise NOT of the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitNot)))
(def BitOr "BitOr[n1, n2, …] gives the bitwise OR of the integers ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitOr)))
(def BitRate "BitRate is an option that specifies an approximate number of bits per second when creating video and audio files." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitRate)))
(def BitSet "BitSet[n, k] sets to 1 the bit corresponding to the coefficient of 2^k in the integer n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitSet)))
(def BitShiftLeft "BitShiftLeft[n, k] shifts the binary bits in the integer n to the left by k places, padding with zeros on the right.\nBitShiftLeft[n] shifts one bit to the left." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitShiftLeft)))
(def BitShiftRight "BitShiftRight[n, k] shifts the binary bits in the integer n to the right by k places, dropping bits that are shifted past the unit's position on the right. \nBitShiftRight[n] shifts one bit to the right." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitShiftRight)))
(def BitXor "BitXor[n1, n2, …] gives the bitwise XOR of the integers ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BitXor)))
(def BiweightLocation "BiweightLocation[list] gives the value of the biweight location estimator of the elements in list.\nBiweightLocation[list, c] gives the value of the biweight location estimator with scaling parameter c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BiweightLocation)))
(def BiweightMidvariance "BiweightMidvariance[list] gives the value of the biweight midvariance of the elements in list.\nBiweightMidvariance[list, c] gives the value of the biweight midvariance with scaling parameter c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BiweightMidvariance)))
(def Black "Black represents the color black in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Black)))
(def BlackmanHarrisWindow "BlackmanHarrisWindow[x] represents a Blackman–Harris window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlackmanHarrisWindow)))
(def BlackmanNuttallWindow "BlackmanNuttallWindow[x] represents a Blackman–Nuttall window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlackmanNuttallWindow)))
(def BlackmanWindow "BlackmanWindow[x] represents a Blackman window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlackmanWindow)))
(def Blank "_or Blank[] is a pattern object that can stand for any Wolfram Language expression. \n_h or Blank[h] can stand for any expression with head h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Blank)))
(def BlankNullSequence "___(three _characters) or BlankNullSequence[] is a pattern object that can stand for any sequence of zero or more Wolfram Language expressions. \n___h or BlankNullSequence[h] can stand for any sequence of expressions, all of which have head h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlankNullSequence)))
(def BlankSequence "__(two _characters) or BlankSequence[] is a pattern object that can stand for any sequence of one or more Wolfram Language expressions. \n__h or BlankSequence[h] can stand for any sequence of one or more expressions, all of which have head h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlankSequence)))
(def Blend "Blend[{col1, col2}, x] gives a color obtained by blending a fraction 1-x of color col1 and x of color col2.\nBlend[{col1, col2, col3, …}, x] linearly interpolates between colors coli as x varies from 0 to 1.\nBlend[{{x1, col1}, {x2, col2}, …}, x] interpolates to give coli when x=xi.\nBlend[{col1, col2, …}, {u1, u2, …}] blends all the coli, using fraction ui of color coli. \nBlend[{image1, image2, …}, …] blends pixel values of 2D or 3D images imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Blend)))
(def Block "Block[{x, y, …}, expr] specifies that expr is to be evaluated with local values for the symbols x, y, …. \nBlock[{x=x0, …}, expr] defines initial local values for x, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Block)))
(def BlockDiagonalMatrix "BlockDiagonalMatrix[{d1, d2, …}] represents the block diagonal matrix with diagonal blocks di as a structured array.\nBlockDiagonalMatrix[mat] converts the block diagonal matrix mat to a structured array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockDiagonalMatrix)))
(def BlockLowerTriangularMatrix "BlockLowerTriangularMatrix[lmat] represents the block lower triangular matrix lmat as a structured array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockLowerTriangularMatrix)))
(def BlockMap "BlockMap[f, list, n] applies f to non-overlapping sublists of length n in list. \nBlockMap[f, list, n, d] applies f to sublists with offset d in list. \nBlockMap[f, list, {n1, n2, …}, …] applies f to blocks of size n1×n2×…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockMap)))
(def BlockRandom "BlockRandom[expr] evaluates expr with all pseudorandom generators localized, so that uses of SeedRandom, RandomInteger, and related functions within the evaluation of expr do not affect subsequent pseudorandom sequences." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockRandom)))
(def BlockUpperTriangularMatrix "BlockUpperTriangularMatrix[umat] represents the block upper triangular matrix umat as a structured array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockUpperTriangularMatrix)))
(def BlockchainAddressData "BlockchainAddressData[\"address\"] gives available information connected with the specified address on the default blockchain.\nBlockchainAddressData[assoc] gives available information connected with properties matching the specification in assoc.\nBlockchainAddressData[addressSpec, prop] gives the specified property of the blockchain address." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainAddressData)))
(def BlockchainBase "BlockchainBase is an option for various blockchain functions that specifies which blockchain to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainBase)))
(def BlockchainBlockData "BlockchainBlockData[\"hash\"] gives information about the block with the specified hash on the blockchain specified by $BlockchainBase.\nBlockchainBlockData[n] gives information about block n on the blockchain.\nBlockchainBlockData[-n] gives information about the block n elements from the end of the blockchain.\nBlockchainBlockData[bspec, prop] gives the specified property of the block." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainBlockData)))
(def BlockchainContractValue "BlockchainContractValue[caddr] gets the result obtained from a Wolfram expression contract at blockchain address caddr.\nBlockchainContractValue[caddr, prop] gets the property prop of the result obtained from a Wolfram expression contract with address caddr.\nBlockchainContractValue[caddr, func] calls the function func of a contract with address caddr. \nBlockchainContractValue[caddr, assoc] calls a contract with address caddr with the properties defined in Association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainContractValue)))
(def BlockchainData "BlockchainData[] gives information about the blockchain specified by $BlockchainBase.\nBlockchainData[property] gives the value of the specified property of the blockchain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainData)))
(def BlockchainGet "BlockchainGet[id] retrieves data from the Wolfram blockchain for the transaction with the specified ID." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainGet)))
(def BlockchainKeyEncode "BlockchainKeyEncode[key, form] encodes a private or public key in the specified blockchain format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainKeyEncode)))
(def BlockchainPut "BlockchainPut[expr] adds expr to the Wolfram blockchain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainPut)))
(def BlockchainTokenData "BlockchainTokenData[\"name\"] gives information about the use of tokens with the specified name on a blockchain.\nBlockchainTokenData[\"sym\"] gives information about tokens with symbol sym.\nBlockchainTokenData[\"address\"] gives information about tokens associated with the specified address.\nBlockchainTokenData[assoc] gives information about tokens with properties matching the specification in assoc.\nBlockchainTokenData[tokenspec, prop] gives the specified property of token usage." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainTokenData)))
(def BlockchainTransaction "BlockchainTransaction[assoc] represents a blockchain transaction built from the components in the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainTransaction)))
(def BlockchainTransactionData "BlockchainTransactionData[txid] gives information about the blockchain transaction with ID txid on the blockchain specified by $BlockchainBase.\nBlockchainTransactionData[txid, prop] gives the specified property of the transaction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainTransactionData)))
(def BlockchainTransactionSign "BlockchainTransactionSign[obj, key] digitally signs a blockchain transaction using the specified private key.\nBlockchainTransactionSign[obj, {key1, key2, …}] digitally signs a transaction using all the keys keyi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainTransactionSign)))
(def BlockchainTransactionSubmit "BlockchainTransactionSubmit[obj] submits the transaction specified in the BlockchainTransaction object obj to a blockchain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlockchainTransactionSubmit)))
(def BlomqvistBeta "BlomqvistBeta[v1, v2] gives Blomqvist's medial correlation coefficient β for the vectors v1 and v2.\nBlomqvistBeta[m] gives Blomqvist's medial correlation coefficient β for the matrix m.\nBlomqvistBeta[m1, m2] gives Blomqvist's medial correlation coefficient β for the matrices m1 and m2.\nBlomqvistBeta[dist] gives the medial correlation coefficient matrix for the multivariate symbolic distribution dist.\nBlomqvistBeta[dist, i, j] gives the (i, j)^th medial correlation coefficient for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlomqvistBeta)))
(def BlomqvistBetaTest "BlomqvistBetaTest[v1, v2] tests whether the vectors v1 and v2 are independent.\nBlomqvistBetaTest[m1, m2] tests whether the matrices m1 and m2 are independent.\nBlomqvistBetaTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BlomqvistBetaTest)))
(def Blue "Blue represents the color blue in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Blue)))
(def Blur "Blur[image] gives a blurred version of image.\nBlur[image, r] gives a version of image blurred over pixel radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Blur)))
(def Blurring "Blurring[r] is a two‐dimensional directive specifying that graphics objects are to be drawn with a blur effect of radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Blurring)))
(def BodePlot "BodePlot[lsys] generates a Bode plot of a linear time-invariant system lsys.\nBodePlot[lsys, {ωmin, ωmax}] plots for the frequency range ωmin to ωmax.\nBodePlot[expr, {ω, ωmin, ωmax}] plots expr using the variable ω." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BodePlot)))
(def BohmanWindow "BohmanWindow[x] represents a Bohman window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BohmanWindow)))
(def Bold "Bold represents a bold font weight." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Bold)))
(def Bond "Bond[{idi, idj}] represents a single chemical bond between atoms with indices idi and idj.\nBond[{idi, idj}, type] represents a chemical bond of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Bond)))
(def BondCount "BondCount[mol] gives the number of bonds in the molecule mol.\nBondCount[mol, patt] gives the number of bonds in the molecule mol matching the bond pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BondCount)))
(def BondLabelStyle "BondLabelStyle is an option for MoleculePlot and MoleculePlot3D that specifies the style to use for bond labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BondLabelStyle)))
(def BondLabels "BondLabels is an option for MoleculePlot and MoleculePlot3D that specifies what labels and label positions should be used for bonds." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BondLabels)))
(def BondList "BondList[mol] gives the list of bonds in the molecule mol.\nBondList[mol, patt] gives the list of bonds in the molecule mol matching the atom pattern patt.\nBondList[mol, patt, \"prop\"] gives the value for the specified property of the bonds matching patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BondList)))
(def BondQ "BondQ[m, bond] gives True if bond is a bond in the molecule m, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BondQ)))
(def Bookmarks "Bookmarks is an option for Manipulate and related functions that gives a list of bookmark settings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Bookmarks)))
(def Boole "Boole[expr] yields 1 if expr is True and 0 if it is False." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Boole)))
(def BooleanConsecutiveFunction "BooleanConsecutiveFunction[k, n] represents a Boolean function of n variables that gives True if k consecutive variables are True.\nBooleanConsecutiveFunction[{k, True}, n] treats the variable list as cyclic.\nBooleanConsecutiveFunction[{k1, k2, …, kd}, {n1, n2, …, nd}] represents a Boolean function of n1 n2 ⋯ nd variables that gives True if all variables in a k1k2…kd block of the n1n2…nd variable array are True.\nBooleanConsecutiveFunction[{{k1, k2, …, kd}, {c1, c2, …, cd}}, {n1, n2, …, nd}] treats the i ^th level of the variable array as cyclic if ci is True. \nBooleanConsecutiveFunction[spec, {a1, a2, …}] gives the Boolean expression in variables ai corresponding to the Boolean consecutive function specified by spec.\nBooleanConsecutiveFunction[spec, {a1, a2, …}, form] gives the Boolean expression in the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanConsecutiveFunction)))
(def BooleanConvert "BooleanConvert[expr] converts the Boolean expression expr to disjunctive normal form.\nBooleanConvert[expr, form] converts the Boolean expression expr to the specified form.\nBooleanConvert[expr, form, cond] finds an expression in the specified form that is equivalent to expr when cond is true." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanConvert)))
(def BooleanCountingFunction "BooleanCountingFunction[kmax, n] represents a Boolean function of n variables that gives True if at most kmax variables are True.\nBooleanCountingFunction[{k}, n] represents a function of n variables that gives True if exactly k variables are True.\nBooleanCountingFunction[{kmin, kmax}, n] represents a function that gives True if between kmin and kmax variables are True.\nBooleanCountingFunction[{{k1, k2, …}}, n] represents a function that gives True if exactly ki variables are True.\nBooleanCountingFunction[spec, {a1, a2, …}] gives the Boolean expression in variables ai corresponding to the Boolean counting function specified by spec.\nBooleanCountingFunction[spec, {a1, a2, …}, form] gives the Boolean expression in the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanCountingFunction)))
(def BooleanFunction "BooleanFunction[k, n] represents the k ^th Boolean function in n variables.\nBooleanFunction[values] represents the Boolean function corresponding to the specified vector of truth values.\nBooleanFunction[{{i11, i12, …}o1, …}] represents the Boolean function defined by the specified mapping from inputs to outputs.\nBooleanFunction[spec, {a1, a2, …}] gives the Boolean expression in variables ai corresponding to the Boolean function specified by spec.\nBooleanFunction[spec, {a1, a2, …}, form] gives the Boolean expression in the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanFunction)))
(def BooleanGraph "BooleanGraph[bfunc, g1, …, gn] gives the Boolean graph defined by the Boolean function bfunc on the graphs g1, …, gn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanGraph)))
(def BooleanMaxterms "BooleanMaxterms[k, n] represents the k ^th maxterm in n variables.\nBooleanMaxterms[{k1, k2, …}, n] represents the conjunction of the maxterms ki.\nBooleanMaxterms[{{u1, …, un}, {v1, …}, …}] represents the conjunction of maxterms given by the exponent vectors ui, vi, ….\nBooleanMaxterms[spec, {a1, a2, …}] gives the Boolean expression in variables ai corresponding to the maxterms function specified by spec.\nBooleanMaxterms[spec, {a, a2, …}, form] gives the Boolean expression in the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanMaxterms)))
(def BooleanMinimize "BooleanMinimize[expr] finds a minimal-length disjunctive normal form representation of expr.\nBooleanMinimize[expr, form] finds a minimal-length representation for expr in the specified form.\nBooleanMinimize[expr, form, cond] finds a minimal-length expression in the specified form that is equivalent to expr when cond is true." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanMinimize)))
(def BooleanMinterms "BooleanMinterms[k, n] represents the k ^th minterm in n variables.\nBooleanMinterms[{k1, k2, …}, n] represents the disjunction of the minterms ki.\nBooleanMinterms[{{u1, …, un}, {v1, …}, …}] represents the disjunction of minterms given by the exponent vectors ui, vi, ….\nBooleanMinterms[spec, {a1, a2, …}] gives the Boolean expression in variables ai corresponding to the minterms function specified by spec.\nBooleanMinterms[spec, {a, a2, …}, form] gives the Boolean expression in the form specified by form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanMinterms)))
(def BooleanQ "BooleanQ[expr] returns True if expr is either True or False." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanQ)))
(def BooleanRegion "BooleanRegion[bfunc, {reg1, reg2, …}] represents the Boolean combination bfunc of regions reg1, reg2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanRegion)))
(def BooleanStrings "BooleanStrings is an option to TextString and related functions that determines what strings correspond to the Wolfram Language symbols True and False." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanStrings)))
(def BooleanTable "BooleanTable[bf] gives a list of truth values for all possible combinations of variable values supplied to the Boolean function bf.\nBooleanTable[expr, {a1, a2, …}] gives a list of the truth values of the Boolean expression expr for all possible combinations of values of the ai.\nBooleanTable[expr, {a1, a2, …}, {b1, …}, …] gives a nested table of truth values of expr with the outermost level giving possible combinations of the ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanTable)))
(def BooleanVariables "BooleanVariables[expr] gives a list of the Boolean variables in the Boolean expression expr.\nBooleanVariables[bf] gives the number of Boolean variables in the BooleanFunction object bf." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BooleanVariables)))
(def Booleans "Booleans represents the domain of Booleans, as in x∈Booleans." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Booleans)))
(def BorderDimensions "BorderDimensions[image] gives the pixel width of uniform borders of image in the form {{left, right}, {bottom, top}}.\nBorderDimensions[image, t] finds borders whose pixels vary by an amount less than t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BorderDimensions)))
(def BorelTannerDistribution "BorelTannerDistribution[α, n] represents a Borel–Tanner distribution with shape parameters α and n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BorelTannerDistribution)))
(def Bottom "Bottom is a symbol that represents the bottom for purposes of alignment and positioning." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Bottom)))
(def BottomHatTransform "BottomHatTransform[image, ker] gives the morphological bottom-hat transform of image with respect to structuring element ker.\nBottomHatTransform[image, r] gives the bottom-hat transform with respect to a range-r square.\nBottomHatTransform[data, …] applies a bottom-hat transform to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BottomHatTransform)))
(def BoundaryDiscretizeGraphics "BoundaryDiscretizeGraphics[g] discretizes a 2D or 3D graphic g into a BoundaryMeshRegion.\nBoundaryDiscretizeGraphics[g, patt] discretizes only the elements in g that match the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryDiscretizeGraphics)))
(def BoundaryDiscretizeRegion "BoundaryDiscretizeRegion[reg] discretizes the region reg into a BoundaryMeshRegion.\nBoundaryDiscretizeRegion[reg, {{xmin, xmax}, …}] restricts to the bounds [xmin, xmax]×⋯." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryDiscretizeRegion)))
(def BoundaryMesh "BoundaryMesh[mreg] gives a BoundaryMeshRegion from a MeshRegion mreg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryMesh)))
(def BoundaryMeshRegion "BoundaryMeshRegion[{p1, p2, …}, {bcell1[{i1, …}], bcell2[{j1, …}], …}] yields a mesh with boundary cells bcellj, where coordinates given as integer i are taken to be pi, where the cells together represent a closed curve, surface, etc.\nBoundaryMeshRegion[…, {…, wi[bcelli[…]], …}] yields a mesh with cell properties defined by the symbolic wrapper wi.\nBoundaryMeshRegion[…, boundary1, boundary2, …] yields a mesh from multiple boundaries boundaryi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryMeshRegion)))
(def BoundaryMeshRegionQ "BoundaryMeshRegionQ[reg] yields True if the region reg is a valid BoundaryMeshRegion object and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryMeshRegionQ)))
(def BoundaryStyle "BoundaryStyle is an option for plotting functions that specifies the style in which boundaries of regions should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundaryStyle)))
(def BoundedRegionQ "BoundedRegionQ[reg] gives True if reg is a bounded region and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundedRegionQ)))
(def BoundingRegion "BoundingRegion[{pt1, pt2, …}] gives the minimal axis-aligned bounding box for the points pt1, pt2, ….\nBoundingRegion[{pt1, pt2, …}, form] gives a bounding region of type form. \nBoundingRegion[reg, form] gives a bounding region for the region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoundingRegion)))
(def BoxData "BoxData[boxes] is a low-level representation of the contents of a typesetting cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxData)))
(def BoxMatrix "BoxMatrix[r] gives a (2 r+1)×(2r+1) matrix of 1s.\nBoxMatrix[r, w] gives a (2 r+1)×(2r+1) block of 1s centered in a w×w matrix of 0s.\nBoxMatrix[{r1, r2, …}, …] gives a (2 r1+1)× (2 r2+1) ×… array of 1s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxMatrix)))
(def BoxObject "BoxObject[id] is an object that represents a box structure in an open notebook in the front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxObject)))
(def BoxRatios "BoxRatios is an option for Graphics3D that gives the ratios of side lengths for the bounding box of the three‐dimensional picture." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxRatios)))
(def BoxStyle "BoxStyle is an option for three-dimensional graphics functions that specifies how the bounding box should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxStyle)))
(def BoxWhiskerChart "BoxWhiskerChart[{x1, x2, …}] makes a box‐and‐whisker chart for the values xi.\nBoxWhiskerChart[{x1, x2, …}, bwspec] makes a chart with box‐and‐whisker symbol specification bwspec.\nBoxWhiskerChart[{data1, data2, …}, …] makes a chart with box‐and‐whisker symbol for each datai.\nBoxWhiskerChart[{{data1, data2, …}, …}, …] makes a box‐and‐whisker chart from multiple groups of datasets {data1, data2, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BoxWhiskerChart)))
(def Boxed "Boxed is an option for Graphics3D that specifies whether to draw the edges of the bounding box in a three‐dimensional picture." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Boxed)))
(def Boxes "Boxes is a symbol that represents typeset boxes in InputField and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Boxes)))
(def Bra "Bra[{b1, b2, …}] displays as 〈b1, b2, …|." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Bra)))
(def BraKet "BraKet[{b1, b2, …}, {k1, k2, …}] displays as 〈b1, b2, …k1, k2, …〉." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BraKet)))
(def BracketingBar "BracketingBar[x, y, …] displays as x, y, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BracketingBar)))
(def BrayCurtisDistance "BrayCurtisDistance[u, v] gives the Bray–Curtis distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BrayCurtisDistance)))
(def BreadthFirstScan "BreadthFirstScan[g, s, {event1f1, event2f2, …}] performs a breadth-first scan (bfs) of the graph g starting at the vertex s and evaluates fi whenever \"eventi\" occurs.\nBreadthFirstScan[g, {event1->f1, event2->f2, …}] performs a breadth-first scan of the whole graph g.\nBreadthFirstScan[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BreadthFirstScan)))
(def Break "Break[] exits the nearest enclosing Do, For, Until or While." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Break)))
(def BridgeData "BridgeData[entity, property] gives the value of the specified property for the bridge entity.\nBridgeData[{entity1, entity2, …}, property] gives a list of property values for the specified bridge entities.\nBridgeData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BridgeData)))
(def BrightnessEqualize "BrightnessEqualize[image] adjusts the brightness across image, correcting uneven illumination.\nBrightnessEqualize[image, flatfield] uses the correction model given by flatfield, which models the variation in brightness across image.\nBrightnessEqualize[image, flatfield, darkfield] uses the dark environment model given by darkfield." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BrightnessEqualize)))
(def BroadcastStationData "BroadcastStationData[entity, property] gives the value of the specified property for the broadcast station entity.\nBroadcastStationData[{entity1, entity2, …}, property] gives a list of property values for the specified broadcast station entities.\nBroadcastStationData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BroadcastStationData)))
(def Brown "Brown represents the color brown in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Brown)))
(def BrownForsytheTest "BrownForsytheTest[data] tests whether the variance of data is 1. \nBrownForsytheTest[{data1, data2, …}] tests whether the variances of data1, data2, … are equal.\nBrownForsytheTest[dspec, σ_0^2] tests a dispersion measure against σ_0^2.\nBrownForsytheTest[dspec, σ_0^2, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BrownForsytheTest)))
(def BrownianBridgeProcess "BrownianBridgeProcess[σ, {t1, a}, {t2, b}] represents the Brownian bridge process from value a at time t1 to value b at time t2 with volatility σ.\nBrownianBridgeProcess[{t1, a}, {t2, b}]  represents the standard Brownian bridge process from value a at time t1 to value b at time t2.\nBrownianBridgeProcess[t1, t2]  represents the standard Brownian bridge process pinned at 0 at times t1 and t2.\nBrownianBridgeProcess[] represents the standard Brownian bridge process pinned at 0 at time 0 and at time 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BrownianBridgeProcess)))
(def BubbleChart "BubbleChart[{{x1, y1, z1}, {x2, y2, z2}, …}] makes a bubble chart with bubbles at positions {xi, yi} with sizes zi.\nBubbleChart[{…, wi[{xi, yi, zi}, …], …, wj[{xj, yj, zj}, …], …}] makes a bubble chart with bubble features defined by the symbolic wrappers wk.\nBubbleChart[{data1, data2, …}] makes a bubble chart from multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BubbleChart)))
(def BubbleChart3D "BubbleChart3D[{{x1, y1, z1, u1}, {x2, y2, z2, u2}, …}] makes a 3D bubble chart with bubbles at positions {xi, yi, zi} with sizes ui.\nBubbleChart3D[{…, wi[{xi, yi, zi, ui}, …], …, wj[{xj, yj, zj, uj}, …], …}] makes a 3D bubble chart with bubble features defined by the symbolic wrappers wk.\nBubbleChart3D[{data1, data2, …}] makes a 3D bubble chart from multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BubbleChart3D)))
(def BubbleScale "BubbleScale is an option to BubbleChart and related functions that specifies how the scale of each bubble should be determined from the value of each data element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BubbleScale)))
(def BubbleSizes "BubbleSizes is an option to BubbleChart and related functions that specifies the range of sizes used for bubbles." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BubbleSizes)))
(def BuckyballGraph "BuckyballGraph[] gives the buckyball graph.\nBuckyballGraph[n] gives the order‐n buckyball graph.\nBuckyballGraph[n, \"class\"] gives the order‐n buckyball graph of class \"class\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BuckyballGraph)))
(def BuildCompiledComponent "BuildCompiledComponent[comp] builds the compiled component comp.\nBuildCompiledComponent[comp, dest] builds the compiled component comp, placing the result in dest." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BuildCompiledComponent)))
(def BuildingData "BuildingData[entity, property] gives the value of the specified property for the building entity.\nBuildingData[{entity1, entity2, …}, property] gives a list of property values for the specified building entities.\nBuildingData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BuildingData)))
(def BulletGauge "BulletGauge[value, reference, {min, max}] draws a bullet gauge showing value and reference in a range of min to max.\nBulletGauge[value, reference, {min, m1, m2, …, max}] draws a bullet gauge with performance regions split at the mi.\nBulletGauge[{v1, v2, …}, …] draws a bullet gauge with multiple values v1, v2, ….\nBulletGauge[values, {r1, r2, …}, …] draws a bullet gauge with multiple references r1, r2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BulletGauge)))
(def BusinessDayQ "BusinessDayQ[date] returns True if the date is a business day and returns False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote BusinessDayQ)))
(def ButterflyGraph "ButterflyGraph[n] gives the order-n butterfly graph. \nButterflyGraph[n, b] gives the base-b order-n butterfly graph." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButterflyGraph)))
(def ButterworthFilterModel "ButterworthFilterModel[n] creates a lowpass Butterworth filter of order n and cutoff frequency of 1.\nButterworthFilterModel[{n, ωc}] uses the cutoff frequency ωc.\nButterworthFilterModel[{\"type\", spec}] creates a filter of a given \"type\" using the specified parameters spec. \nButterworthFilterModel[{\"type\", spec}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButterworthFilterModel)))
(def Button "Button[label, action] represents a button that is labeled with label, and evaluates action whenever it is clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Button)))
(def ButtonBar "ButtonBar[{lbl1:>act1, lbl2:>act2, …}] represents a bar of buttons with labels lbli that perform actions acti when pressed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonBar)))
(def ButtonBox "ButtonBox[boxes] is a low-level box construct that represents a button in a notebook expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonBox)))
(def ButtonBoxOptions "ButtonBoxOptions is an option that specifies settings for ButtonBox." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonBoxOptions)))
(def ButtonData "ButtonData is an option for the low-level function ButtonBox that specifies the second argument to give to the ButtonFunction for the button when the button is active and is clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonData)))
(def ButtonFunction "ButtonFunction is an option for the low-level function ButtonBox that specifies the function to execute when the button is active and is clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonFunction)))
(def ButtonMinHeight "ButtonMinHeight is an option for the low-level function ButtonBox that specifies the minimum total height in units of font size that should be allowed for the button." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonMinHeight)))
(def ButtonNotebook "ButtonNotebook[] gives the notebook, if any, that contains the button which initiated the current evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonNotebook)))
(def ButtonSource "ButtonSource is an option for the low-level function ButtonBox that specifies the first argument to give to the ButtonFunction for the button when the button is active and is clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ButtonSource)))
(def Byte "Byte represents a single byte of data in Read." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Byte)))
(def ByteArray "ByteArray[{b1, b2, …}] constructs a ByteArray object containing the byte values bi.\nByteArray[\"string\"] constructs a ByteArray object by extracting byte values from a Base64-encoded string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteArray)))
(def ByteArrayFormat "ByteArrayFormat[ba] attempts to determine what ImportByteArray format could be used to import the ByteArray object ba." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteArrayFormat)))
(def ByteArrayFormatQ "ByteArrayFormatQ[ba, \"fmt\"] gives True if the ByteArray object ba might be imported as format \"fmt\" and gives False otherwise.\nByteArrayFormatQ[ba, {fmt1, fmt2, …}] gives True if ba might be imported as one of \"fmti\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteArrayFormatQ)))
(def ByteArrayQ "ByteArrayQ[expr] gives True if expr is a valid ByteArray object, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteArrayQ)))
(def ByteArrayToString "ByteArrayToString[ba] returns a string by decoding the data in the byte array ba, assuming UTF-8 encoding.\nByteArrayToString[ba, \"encoding\"] interprets the data in the specified character encoding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteArrayToString)))
(def ByteCount "ByteCount[expr] gives the number of bytes used internally by the Wolfram System to store expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteCount)))
(def ByteOrdering "ByteOrdering is an option for BinaryRead, BinaryWrite, and related functions that specifies what ordering of bytes should be assumed for your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ByteOrdering)))
(def C "C[i] is the default form for the i ^th parameter or constant generated in representing the results of various symbolic computations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote C)))
(def CDF "CDF[dist, x] gives the cumulative distribution function for the distribution dist evaluated at x.\nCDF[dist, {x1, x2, …}] gives the multivariate cumulative distribution function for the distribution dist evaluated at {x1, x2, …}.\nCDF[dist] gives the CDF as a pure function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CDF)))
(def CDFDeploy "CDFDeploy[\"file.cdf\", expr] deploys expr in a form that can be played by Wolfram Player.\nCDFDeploy[\"file.cdf\", notebook] deploys a notebook.\nCDFDeploy[\"file.cdf\", NotebookSelection[notebook]] deploys the current selection in notebook.\nCDFDeploy[\"outfile.cdf\", \"infile.nb\"] deploys the notebook \"infile.nb\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CDFDeploy)))
(def CDFWavelet "CDFWavelet[] represents a Cohen–Daubechies–Feauveau wavelet of type \"9/7\". \nCDFWavelet[\"type\"] represents a Cohen–Daubechies–Feauveau wavelet of type \"type\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CDFWavelet)))
(def CForm "CForm[expr] prints as a C language version of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CForm)))
(def CMYKColor "CMYKColor[c, m, y, k] represents a color in the CMYK color space with cyan, magenta, yellow and black components.\nCMYKColor[c, m, y, k, a] specifies opacity a. \nCMYKColor[\"string\"] returns a color from an HTML color name etc.\nCMYKColor[color] returns the CMYK representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CMYKColor)))
(def CSGRegion "CSGRegion[{reg1, reg2, …}] represents the solid region corresponding to the union of solid regions reg1, reg2, ….\nCSGRegion[\"op\", {reg1, reg2, …}] represents the solid region corresponding to the Boolean combination \"op\" of regions reg1, reg2, ….\nCSGRegion[\"op\", {…, wi[regi], …}] represents the solid region defined by regions regi transformed by a geometric transformation wi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CSGRegion)))
(def CSGRegionQ "CSGRegionQ[reg] yields True if the region reg is a valid CSGRegion object and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CSGRegionQ)))
(def CSGRegionTree "CSGRegionTree[reg] gives the tree expression representing the CSG region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CSGRegionTree)))
(def CTCLossLayer "CTCLossLayer[] represents a net layer that computes the connectionist temporal classification loss by comparing a sequence of class probability vectors with a sequence of indices representing the target classes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CTCLossLayer)))
(def CachePersistence "CachePersistence is an option for CloudObject and related cloud functions that specifies the time duration for which a response is cached by a client or on the server." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CachePersistence)))
(def CalendarConvert "CalendarConvert[date, calendar] converts the date object date to the specified calendar type calendar.\nCalendarConvert[date] converts to the default calendar type.\nCalendarConvert[{date1, …, daten}, calendar] converts date1 through daten to the specified calendar." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalendarConvert)))
(def CalendarData "CalendarData[cal] gives the default parameters associated with the date calendar cal.\nCalendarData[country] gives available holiday calendars for the stock exchanges in the country entity.\nCalendarData[cal, param] gives the value of the specified parameter param for calendar cal." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalendarData)))
(def CalendarType "CalendarType is an option that determines the calendar system in which all dates are to be interpreted and output." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalendarType)))
(def CalibratedSystemModel "CalibratedSystemModel[…] represents the symbolic calibrated system model obtained from SystemModelCalibrate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalibratedSystemModel)))
(def CallPacket "CallPacket[integer, list] is a WSTP packet encapsulating a request to invoke the external function numbered integer with the arguments contained in list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CallPacket)))
(def Callout "Callout[data, expr] displays expr in a plot as a callout pointing to data.\nCallout[data, expr, pos] displays a callout with expr at a position specified by pos.\nCallout[data, expr, pos, apos] displays a callout anchored at a position specified by apos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Callout)))
(def CalloutMarker "CalloutMarker is an option for Callout that specifies what marker to draw at the end of the leader in a callout." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalloutMarker)))
(def CalloutStyle "CalloutStyle is an option for Callout that specifies what style to use for callouts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CalloutStyle)))
(def CanberraDistance "CanberraDistance[u, v] gives the Canberra distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanberraDistance)))
(def Cancel "Cancel[expr] cancels out common factors in the numerator and denominator of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cancel)))
(def CancelButton "CancelButton[] represents a Cancel button in a dialog that closes the dialog window when clicked.\nCancelButton[action] represents a button labeled Cancel that evaluates action when clicked.\nCancelButton[label, action] uses label as the label for the button." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CancelButton)))
(def CandlestickChart "CandlestickChart[{{date1, {open1, high1, low1, close1}}, …}] makes a chart with candles representing open, high, low, and close prices for each date. \nCandlestickChart[{\"name\", daterange}] makes a candlestick chart for the financial entity \"name\" over the date range daterange." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CandlestickChart)))
(def CanonicalGraph "CanonicalGraph[g] gives a canonical form of the graph g.\nCanonicalGraph[{vw, …}] uses rules vw to specify the graph." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalGraph)))
(def CanonicalName "CanonicalName[entity] gives the canonical name for the entity specified by entity.\nCanonicalName[{entity1, …, entityn}] gives the canonical name for entity1 through entityn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalName)))
(def CanonicalWarpingCorrespondence "CanonicalWarpingCorrespondence[s1, s2] gives the canonical time warping (CTW) correspondence between sequences s1 and s2.\nCanonicalWarpingCorrespondence[s1, s2, warp] uses warp as initial warping correspondence.\nCanonicalWarpingCorrespondence[s1, s2, warp, win] uses a window win for local search." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalWarpingCorrespondence)))
(def CanonicalWarpingDistance "CanonicalWarpingDistance[s1, s2] gives the canonical time warping (CTW) distance between sequences s1 and s2.\nCanonicalWarpingDistance[s1, s2, init] uses init as the initial correspondence between the two sequences.\nCanonicalWarpingDistance[s1, s2, init, win] uses a window win for local search." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalWarpingDistance)))
(def CanonicalizePolygon "CanonicalizePolygon[poly] gives a canonical representation of the polygon poly with shared coordinates and with inner and outer boundaries.\nCanonicalizePolygon[poly, \"filter\"] gives a canonical representation of poly with the specified filter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalizePolygon)))
(def CanonicalizePolyhedron "CanonicalizePolyhedron[poly] gives a canonical representation of the polyhedron poly with shared coordinates and with inner and outer boundaries." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalizePolyhedron)))
(def CanonicalizeRegion "CanonicalizeRegion[reg] gives a canonical representation of the region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CanonicalizeRegion)))
(def CantorMesh "CantorMesh[n] gives a mesh region representing the n ^th-step Cantor set. \nCantorMesh[n, d] gives the n ^th-step Cantor set in dimension d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CantorMesh)))
(def CantorStaircase "CantorStaircase[x] gives the Cantor staircase function FC (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CantorStaircase)))
(def Canvas "Canvas[] represents an empty canvas in the current notebook in which you can do free-form drawing.\nCanvas[graphic] represents a canvas that initially contains the specified 2D graphic." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Canvas)))
(def Cap "Cap[x, y, …] displays as x⌢y⌢…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cap)))
(def CapForm "CapForm[type] is a graphics primitive that specifies what type of caps should be used at the ends of lines, tubes, and related primitives." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CapForm)))
(def CapitalDifferentialD "CapitalDifferentialD[x] displays as x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CapitalDifferentialD)))
(def Capitalize "Capitalize[string] yields a string in which the first character has been made uppercase.\nCapitalize[string, scheme] gives a string capitalized using the specified capitalization scheme." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Capitalize)))
(def CapsuleShape "CapsuleShape[{{x1, y1, z1}, {x2, y2, z2}}, r] represents the filled capsule between points {xi, yi, zi} and radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CapsuleShape)))
(def CaptureRunning "CaptureRunning is an option for signal acquisition functions that specifies whether to immediately start the capture." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CaptureRunning)))
(def CaputoD "CaputoD[f, {x, α}] gives the Caputo fractional differintegral (^C)0D_x^αf(x) of the function f (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CaputoD)))
(def CarlemanLinearize "CarlemanLinearize[sys, spec] Carleman linearizes the nonlinear state-space model sys according to spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlemanLinearize)))
(def CarlsonRC "CarlsonRC[x, y] gives the Carlson's elliptic integral RC (x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRC)))
(def CarlsonRD "CarlsonRD[x, y, z] gives the Carlson's elliptic integral RD (x, y, z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRD)))
(def CarlsonRE "CarlsonRE[x, y] gives the Carlson's elliptic integral RE (x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRE)))
(def CarlsonRF "CarlsonRF[x, y, z] gives the Carlson's elliptic integral RF (x, y, z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRF)))
(def CarlsonRG "CarlsonRG[x, y, z] gives the Carlson's elliptic integral RG (x, y, z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRG)))
(def CarlsonRJ "CarlsonRJ[x, y, z, ρ] gives Carlson's elliptic integral RJ (x, y, z, ρ)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRJ)))
(def CarlsonRK "CarlsonRK[x, y] gives the Carlson's elliptic integral RK (x, y)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRK)))
(def CarlsonRM "CarlsonRM[x, y, ρ] gives Carlson's elliptic integral RM (x, y, ρ)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarlsonRM)))
(def CarmichaelLambda "CarmichaelLambda[n] gives the Carmichael function λ (n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CarmichaelLambda)))
(def CaseOrdering "CaseOrdering is an option for AlphabeticSort and related functions that specifies how upper versus lower case should be sorted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CaseOrdering)))
(def CaseSensitive "CaseSensitive[patt] represents a string pattern that requires matching typographical case, even with the overall option setting IgnoreCase->True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CaseSensitive)))
(def Cases "Cases[{e1, e2, …}, pattern] gives a list of the ei that match the pattern. \nCases[{e1, …}, patternrhs] gives a list of the values of rhs corresponding to the ei that match the pattern. \nCases[expr, pattern, levelspec] gives a list of all parts of expr on levels specified by levelspec that match the pattern. \nCases[expr, patternrhs, levelspec] gives the values of rhs that match the pattern. \nCases[expr, pattern, levelspec, n] gives the first n parts in expr that match the pattern. \nCases[pattern] represents an operator form of Cases that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cases)))
(def Cashflow "Cashflow[{c0, c1, …, cn}] represents a series of cash flows occurring at unit time intervals.\nCashflow[{c0, c1, …, cn}, q] represents cash flows occurring at time intervals q.\nCashflow[{{time1, c1}, {time2, c2}, …}] represents cash flows occurring at the specified times." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cashflow)))
(def Casoratian "Casoratian[{y1, y2, …}, n] gives the Casoratian determinant for the sequences y1, y2, … depending on n.\nCasoratian[eqn, y, n] gives the Casoratian determinant for the basis of the solutions of the linear difference equation eqn involving y[n+m]. \nCasoratian[eqns, {y1, y2, …}, n] gives the Casoratian determinant for the system of linear difference equations eqns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Casoratian)))
(def Cast "Cast[val, type] converts val to the type type, for use in compiled code.\nCast[val, type, method] uses the specified casting method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cast)))
(def Catalan "Catalan is Catalan's constant, with numerical value ≃0.915966." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Catalan)))
(def CatalanNumber "CatalanNumber[n] gives the n ^th Catalan number Cn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CatalanNumber)))
(def Catch "Catch[expr] returns the argument of the first Throw generated in the evaluation of expr. \nCatch[expr, form] returns value from the first Throw[value, tag] for which form matches tag. \nCatch[expr, form, f] returns f[value, tag]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Catch)))
(def CategoricalDistribution "CategoricalDistribution[{c1, c2, …}] represents a uniform categorical distribution over classes c1, c2, etc.\nCategoricalDistribution[{c1, c2, …}, {w1, w2, …}] represents a categorical distribution over classes ci with weights wi.\nCategoricalDistribution[{{a1, a2, …}, {b1, b2, …}, …}] represents a uniform multivariate categorical distribution over domain {a1, a2, …}×{b1, b2, …}×….\nCategoricalDistribution[domain, weights] uses the array weights to define probabilities over each element of the domain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CategoricalDistribution)))
(def Catenate "Catenate[{list1, list2, …}] yields a single list with all elements from the listi in order. \nCatenate[{assoc1, assoc2, …}] yields a list of all values in order appearing in the associations associ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Catenate)))
(def CatenateLayer "CatenateLayer[] represents a net layer that takes a list of input arrays and catenates them.\nCatenateLayer[n] represents a net layer that takes a list of input arrays and catenates them at level n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CatenateLayer)))
(def CauchyDistribution "CauchyDistribution[a, b] represents a Cauchy distribution with location parameter a and scale parameter b.\nCauchyDistribution[] represents a Cauchy distribution with location parameter 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CauchyDistribution)))
(def CauchyMatrix "CauchyMatrix[x, y] represents the Cauchy matrix given by the generating vectors x and y as a structured array.\nCauchyMatrix[x] is equivalent to CauchyMatrix[x, x].\nCauchyMatrix[cmat] converts a Cauchy matrix cmat to a structured array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CauchyMatrix)))
(def CauchyPointProcess "CauchyPointProcess[μ, λ, b, d] represents a Cauchy cluster point process with density μ, cluster mean λ and scale parameter b in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CauchyPointProcess)))
(def CauchyWindow "CauchyWindow[x] represents a Cauchy window function of x.\nCauchyWindow[x, α] uses the parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CauchyWindow)))
(def CayleyGraph "CayleyGraph[group] returns a Cayley graph representation of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CayleyGraph)))
(def Ceiling "Ceiling[x] gives the smallest integer greater than or equal to x. \nCeiling[x, a] gives the smallest multiple of a greater than or equal to x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Ceiling)))
(def CelestialSystem "CelestialSystem is an option for SunPosition, MoonPosition, and related functions that specifies the coordinate system to use for the results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CelestialSystem)))
(def Cell "Cell[contents] is the low-level representation of a cell inside a Wolfram System notebook. \nCell[contents, \"style\"] represents a cell in the specified style.\nCell[contents, style1, style2, …] represents a cell with multiple styles applied to it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cell)))
(def CellAutoOverwrite "CellAutoOverwrite is an option for Cell which specifies whether an output cell should be overwritten by new output when the preceding input cell is evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellAutoOverwrite)))
(def CellBaseline "CellBaseline is an option for Cell which specifies where the baseline of the cell should be assumed to be when it appears inside another cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellBaseline)))
(def CellBracketOptions "CellBracketOptions is an option for cells that specifies settings for cell brackets." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellBracketOptions)))
(def CellChangeTimes "CellChangeTimes is an option to Cell that specifies when changes were made to the cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellChangeTimes)))
(def CellContext "CellContext is an option for Cell which specifies the context to use for the evaluation of the contents of the cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellContext)))
(def CellDingbat "CellDingbat is an option for Cell which specifies what dingbat to use to emphasize a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellDingbat)))
(def CellDingbatMargin "CellDingbatMargin is an option for Cell that specifies the absolute margin in printer's points between the dingbat and the left cell frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellDingbatMargin)))
(def CellDynamicExpression "CellDynamicExpression is an option for cells that specifies an expression to be dynamically updated whenever the cell is visible on screen." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellDynamicExpression)))
(def CellEditDuplicate "CellEditDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before actually applying any changes in its contents that you request." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellEditDuplicate)))
(def CellEpilog "CellEpilog is an option for Cell which gives an expression to evaluate after each ordinary evaluation of the contents of the cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellEpilog)))
(def CellEvaluationDuplicate "CellEvaluationDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before performing any evaluation of its contents that you request." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellEvaluationDuplicate)))
(def CellEvaluationFunction "CellEvaluationFunction is an option for Cell that gives a function to be applied to every expression from the cell that is sent to the kernel for ordinary evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellEvaluationFunction)))
(def CellEventActions "CellEventActions is an option for Cell that gives a list of actions to perform when specified events occur in connection with a cell in a notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellEventActions)))
(def CellFrame "CellFrame is an option for Cell that specifies whether a frame should be drawn around a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellFrame)))
(def CellFrameColor "CellFrameColor is an option that specifies the color of the frame around a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellFrameColor)))
(def CellFrameLabelMargins "CellFrameLabelMargins is an option for cells that specifies the absolute margins in printer's points between a cell's frame and the labels around the frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellFrameLabelMargins)))
(def CellFrameLabels "CellFrameLabels is an option that specifies the labels associated with the frame around a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellFrameLabels)))
(def CellFrameMargins "CellFrameMargins is an option for Cell that specifies the absolute margins in printer’s points to leave inside a frame that is drawn around a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellFrameMargins)))
(def CellGroup "CellGroup[{cell1, cell2, …}] gives an open group of cells that can appear in a Wolfram System notebook.\nCellGroup[{cell1, cell2, …}, 1] gives a cell group in which only the first cell is open.\nCellGroup[{cell1, cell2, …}, -1] gives a cell group in which only the last cell is open.\nCellGroup[{cell1, cell2, …}, {i1, i2, …}] gives a cell group in which cells i1, i2, … are open." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellGroup)))
(def CellGroupData "CellGroupData[{cell1, cell2, …}] is a low-level construct that represents an open group of cells in a notebook. \nCellGroupData[{cell1, cell2, …}, status] represents a cell group that is open or closed according to the value of status.\nCellGroupData[{cell1, cell2, …}, {i1, i2, …}] represents a cell group with cells at positions i1, i2, … open." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellGroupData)))
(def CellGrouping "CellGrouping is a notebook option that specifies how cells in the notebook should be assembled into groups." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellGrouping)))
(def CellID "CellID is an option for Cell that specifies a unique ID number for a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellID)))
(def CellLabel "CellLabel is an option for Cell which gives the label to use for a particular cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellLabel)))
(def CellLabelAutoDelete "CellLabelAutoDelete is an option for Cell which specifies whether a label for the cell should be automatically deleted if the contents of the cell are modified or the notebook containing the cell is saved in a file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellLabelAutoDelete)))
(def CellLabelStyle "CellLabelStyle is an option for Cell that specifies the style to use in displaying cell labels marking inputs and outputs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellLabelStyle)))
(def CellLabelTemplate "CellLabelTemplate is an option for Cell that specifies string templates to use for formatting the default labels used for marking inputs and outputs" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellLabelTemplate)))
(def CellMargins "CellMargins is an option for Cell that specifies the absolute margins in printer's points to leave around a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellMargins)))
(def CellObject "CellObject[id] is an object that represents a cell in an open notebook in the front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellObject)))
(def CellOpen "CellOpen is an option for Cell that specifies whether the contents of a cell should be explicitly displayed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellOpen)))
(def CellPrint "CellPrint[expr] inserts expr as a complete cell in the current notebook just below the cell being evaluated. \nCellPrint[{expr1, expr2, …}] inserts a sequence of cells." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellPrint)))
(def CellProlog "CellProlog is an option to Cell that gives an expression to evaluate before each ordinary evaluation of the contents of the cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellProlog)))
(def CellStyle "CellStyle is a setting for functions such as NotebookFind and Cells that specifies the name of a cell style to search for in a notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellStyle)))
(def CellStyleImportRules "CellStyleImportRules is an option for NotebookImport specifying how to import cells with given cell style names." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellStyleImportRules)))
(def CellTags "CellTags is an option for Cell that gives a list of tags to associate with a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellTags)))
(def Cells "Cells[] returns a list of CellObject expressions corresponding to cells in the current notebook.\nCells[obj] returns the list of CellObject expressions in obj.\nCells[NotebookSelection[notebook]] returns the list of CellObject expressions for currently selected cells." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cells)))
(def CellularAutomaton "CellularAutomaton[rule, init, t] generates a list representing the evolution of the cellular automaton with the specified rule from initial condition init for t steps. \nCellularAutomaton[rule, init] gives the result of evolving init for one step. \nCellularAutomaton[rule, init, {tspec, xspec, …}] gives only those parts of the evolution specified by tspec, xspec, etc. \nCellularAutomaton[rule, init, {t, All, …}] includes at each step all cells that could be affected over the course of t steps. \nCellularAutomaton[rule] is an operator form of CellularAutomaton that represents one step of evolution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CellularAutomaton)))
(def CensoredDistribution "CensoredDistribution[{xmin, xmax}, dist] represents the distribution of values that come from dist and are censored to be between xmin and xmax.\nCensoredDistribution[{{xmin, xmax}, {ymin, ymax}, …}, dist] represents the distribution of values that come from the multivariate distribution dist and are censored to be between xmin and xmax, ymin and ymax, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CensoredDistribution)))
(def Censoring "Censoring[t, c] represents a censored event time t with censoring c.\nCensoring[{t1, t2, …}, c] represents a vector of censored event times ti with censoring c.\nCensoring[{t1, t2, …}, {c1, c2, …}] represents a vector of event times ti with corresponding censoring ci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Censoring)))
(def Center "Center is a symbol that represents the center for purposes of alignment and positioning." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Center)))
(def CenterArray "CenterArray[a, n] creates a list of length n with the elements of a at the center and zeros elsewhere.\nCenterArray[a, {n1, n2, …}] creates an n1×n2×… array with the array a at the center and zeros elsewhere.\nCenterArray[a, nspec, pad] uses pad instead of zero for the background.\nCenterArray[nspec] creates an array with a single 1 at the center and zeros elsewhere." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CenterArray)))
(def CenterDot "CenterDot[x, y, …] displays as x·y·…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CenterDot)))
(def CenteredInterval "CenteredInterval[x, dx] for real numbers x and dx gives a centered interval that contains the real interval {a∈|x-dx≤a≤x+dx}.\nCenteredInterval[x+ y, dx+ dy] gives a centered interval that contains the complex rectangle {a+ b∈|x-dx≤a≤x+dx∧y-dy≤b≤y+dy}.\nCenteredInterval[c] for an approximate number c gives a centered interval that contains all values within the error bounds of c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CenteredInterval)))
(def CentralFeature "CentralFeature[{x1, x2, …}] gives the central feature of the elements xi.\nCentralFeature[{x1v1, x2v2, …}] gives the vi corresponding to the central feature xi.\nCentralFeature[data] gives the central feature for several different forms of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CentralFeature)))
(def CentralMoment "CentralMoment[data, r] gives the order r  central moment Overscript[μ, ~]r of data.\nCentralMoment[data, {r1, …, rm}] gives the order {r1, …, rm} multivariate central moment Overscript[μ, ~]r1, …, rm of data.\nCentralMoment[dist, …] gives the central moment of the distribution dist.\nCentralMoment[r] represents the order r  formal central moment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CentralMoment)))
(def CentralMomentGeneratingFunction "CentralMomentGeneratingFunction[dist, t] gives the central moment-generating function for the distribution dist as a function of the variable t. \nCentralMomentGeneratingFunction[dist, {t1, t2, …}] gives the central moment-generating function for the multivariate distribution dist as a function of the variables t1, t2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CentralMomentGeneratingFunction)))
(def Cepstrogram "Cepstrogram[data] plots the array of power cepstra computed on each partition of data.\nCepstrogram[data, n] uses partitions of length n.\nCepstrogram[data, n, d] uses partitions with offset d.\nCepstrogram[data, n, d, wfun] applies a smoothing window wfun to each partition.\nCepstrogram[data, n, d, wfun, m] pads partitions with zeros to length m prior to the computation of the transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cepstrogram)))
(def CepstrogramArray "CepstrogramArray[data] computes an array of cepstra on data.\nCepstrogramArray[data, n] uses partitions of length n.\nCepstrogramArray[data, n, d] uses partitions with offset d.\nCepstrogramArray[data, n, d, wfun] applies a smoothing window wfun to each partition.\nCepstrogramArray[data, n, d, wfun, m] pads partitions with zeros to length m prior to the computation of the transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CepstrogramArray)))
(def CepstrumArray "CepstrumArray[data] computes the power cepstrum of data.\nCepstrumArray[data, type] computes the specified type of cepstrum of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CepstrumArray)))
(def ChampernowneNumber "ChampernowneNumber[b] gives the base-b Champernowne number Cb.\nChampernowneNumber[] gives the base-10 Champernowne number." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChampernowneNumber)))
(def ChanVeseBinarize "ChanVeseBinarize[image] finds a two-level segmentation of image by computing optimal contours around regions of consistent intensity in image.\nChanVeseBinarize[image, marker] uses marker to create an initial contour.\nChanVeseBinarize[image, marker, {μ, ν, λ1, λ2}] specify the Chan–Vese weights μ, ν, λ1, and λ2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChanVeseBinarize)))
(def ChannelBase "ChannelBase is an option specifying the base URL of the server to use for brokering channel communications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelBase)))
(def ChannelBrokerAction "ChannelBrokerAction is an option specifying the action to execute on the channel broker server in addition to routing a message." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelBrokerAction)))
(def ChannelHistoryLength "ChannelHistoryLength is an option to ChannelListen that specifies the maximum number of messages to cache in the channel listener object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelHistoryLength)))
(def ChannelListen "ChannelListen[channel] starts listening on the specified channel.\nChannelListen[channel, func] applies func to the association corresponding to each message received on the channel.\nChannelListen[channel, None] stores each message received on the channel, without applying any function.\nChannelListen[url] listens on the specified URL, storing messages received, without requiring an explicit channel to exist on the channel broker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelListen)))
(def ChannelListener "ChannelListener[…] represents a channel listener created by ChannelListen." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelListener)))
(def ChannelListeners "ChannelListeners[] gives a list of currently active channel listeners." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelListeners)))
(def ChannelObject "ChannelObject[] gives a new anonymous channel specification.\nRowBox[{\"ChannelObject\", \"[\", \"\"mqtts://… \"\",\"]\"}] represents a channel specified by a given URL.\nChannelObject[\"relpath\"] represents a channel for the currently authenticated user at a relative path.\nChannelObject[\"id:path\"] represents a channel for the user with the specified Wolfram ID at the given path.\nChannelObject[\"/abspath\"] represents a channel at an absolute path on the channel broker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelObject)))
(def ChannelReceiverFunction "ChannelReceiverFunction[fun] represents a channel receiver function that applies fun to any channel message it receives." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelReceiverFunction)))
(def ChannelSend "ChannelSend[channel, msg] sends the specified message msg to the specified channel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelSend)))
(def ChannelSubscribers "ChannelSubscribers[channel] gives a list of users currently subscribed to the specified channel.\nChannelSubscribers[{channel1, channel2, …}] gives a list of subscribed users for each of the channels channeli." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChannelSubscribers)))
(def Character "Character represents a single character in Read." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Character)))
(def CharacterCounts "CharacterCounts[\"string\"] gives an association whose keys are the distinct characters in string, and whose values give the number of times those characters appear in string.\nCharacterCounts[\"string\", n] gives counts of the distinct n-grams consisting of runs of n characters in string.\nCharacterCounts[{string1, string2, …}, …] gives the counts for each of the stringi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacterCounts)))
(def CharacterEncoding "CharacterEncoding is an option for input and output functions which specifies what raw character encoding should be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacterEncoding)))
(def CharacterName "CharacterName[\"c\"] gives the name of the character c.\nCharacterName[n] gives the name of the character with character code n.\nCharacterName[c, \"type\"] gives a name of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacterName)))
(def CharacterNormalize "CharacterNormalize[\"text\", form] converts the characters in text to the specified normalization form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacterNormalize)))
(def CharacterRange "CharacterRange[c1, c2] yields a list of the characters in the range from \"c1\" to \"c2\". \nCharacterRange[n1, n2] yields a list of the characters with character codes in the range n1 to n2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacterRange)))
(def CharacteristicFunction "CharacteristicFunction[dist, t] gives the characteristic function for the distribution dist as a function of the variable t.\nCharacteristicFunction[dist, {t1, t2, …}] gives the characteristic function for the multivariate distribution dist as a function of the variables t1, t2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacteristicFunction)))
(def CharacteristicPolynomial "CharacteristicPolynomial[m, x] gives the characteristic polynomial for the matrix m. \nCharacteristicPolynomial[{m, a}, x] gives the generalized characteristic polynomial with respect to a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CharacteristicPolynomial)))
(def Characters "Characters[\"string\"] gives a list of the characters in a string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Characters)))
(def ChartBaseStyle "ChartBaseStyle is an option for charting functions that specifies the base style for all chart elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartBaseStyle)))
(def ChartElementFunction "ChartElementFunction is an option for charting functions such as BarChart that gives a function to use to generate the primitives for rendering each chart element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartElementFunction)))
(def ChartElements "ChartElements is an option to charting functions such as BarChart that specifies the graphics to use as the basis for bars or other chart elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartElements)))
(def ChartLabels "ChartLabels is an option for charting functions that specifies what labels should be used for chart elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartLabels)))
(def ChartLayout "ChartLayout is an option to charting functions that specifies the overall layout to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartLayout)))
(def ChartLegends "ChartLegends is an option for charting functions that specifies what legends should be used for chart elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartLegends)))
(def ChartStyle "ChartStyle is an option for charting functions that specifies styles in which chart elements should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChartStyle)))
(def ChatEvaluate "ChatEvaluate[chat, prompt] appends prompt and its follow-up to the ChatObject chat.\nChatEvaluate[prompt] represents an operator form of ChatEvaluate that can be applied to a ChatObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChatEvaluate)))
(def ChatObject "ChatObject[] represents an ongoing conversation with a remote service.\nChatObject[init] creates a new chat using the initialization parameters init.\nChatObject[…][prop] extracts the property prop from the object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChatObject)))
(def Chebyshev1FilterModel "Chebyshev1FilterModel[n] creates a lowpass Chebyshev type 1 filter of order n.\nChebyshev1FilterModel[{n, ωc}] uses the cutoff frequency ωc.\nChebyshev1FilterModel[{\"type\", spec}] creates a filter of a given \"type\" using the specified parameters spec. \nChebyshev1FilterModel[{\"type\", spec}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Chebyshev1FilterModel)))
(def Chebyshev2FilterModel "Chebyshev2FilterModel[n] creates a lowpass Chebyshev type 2 filter of order n.\nChebyshev2FilterModel[{n, ωc}] uses the cutoff frequency ωc.\nChebyshev2FilterModel[{\"type\", spec}] uses the full filter specification {\"type\", spec}.\nChebyshev2FilterModel[{\"type\", spec}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Chebyshev2FilterModel)))
(def ChebyshevT "ChebyshevT[n, x] gives the Chebyshev polynomial of the first kind Tn (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChebyshevT)))
(def ChebyshevU "ChebyshevU[n, x] gives the Chebyshev polynomial of the second kind Un (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChebyshevU)))
(def Check "Check[expr, failexpr] evaluates expr, and returns the result, unless messages were generated, in which case it evaluates and returns failexpr. \nCheck[expr, failexpr, {s1::t1, s2::t2, …}] checks only for the specified messages. \nCheck[expr, failexpr, \"name\"] checks only for messages in the named message group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Check)))
(def CheckAbort "CheckAbort[expr, failexpr] evaluates expr, returning failexpr if an abort occurs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CheckAbort)))
(def CheckArguments "CheckArguments[f[args], n] gives True if args consists of exactly n positional arguments followed by valid options for f, and False otherwise.\nCheckArguments[f[args], {min, max}] requires the number of positional arguments to be between min and max.\nCheckArguments[f[args], spec, assoc] modifies the behavior based on the information in the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CheckArguments)))
(def Checkbox "Checkbox[x] represents a checkbox with setting x, displayed as  when x is True and  when x is False. \nCheckbox[Dynamic[x]] takes the setting to be the dynamically updated current value of x, with the value of x being toggled if the checkbox is clicked. \nCheckbox[x, {val1, val2}] represents a checkbox that toggles between values val1 and val2 and displays as  and , respectively. \nCheckbox[x, {val1, val2, val3, …}] represents a checkbox that cycles through values vali and displays as  for all vali with i>2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Checkbox)))
(def CheckboxBar "CheckboxBar[x, {val1, val2, …}] represents a checkbox bar with setting x and with checkboxes for values vali to include in the list x.\nCheckboxBar[Dynamic[x], {val1, val2, …}] takes the setting to be the dynamically updated current value of x, with the values in the list x being reset every time a checkbox is clicked.\nCheckboxBar[x, {val1lbl1, val2lbl2, …}] represents a checkbox bar in which the checkbox associated with value vali has label lbli." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CheckboxBar)))
(def ChemicalConvert "ChemicalConvert[cheminst, targetunit] converts the quantity in the specified instance cheminst to targetunit.\nChemicalConvert[cheminst] converts to SI base units." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChemicalConvert)))
(def ChemicalData "ChemicalData[\"name\", \"property\"] gives the value of the specified property for the chemical \"name\".\nChemicalData[\"name\"] gives a structure diagram for the chemical with the specified name.\nChemicalData[\"class\"] gives a list of available chemicals in the specified class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChemicalData)))
(def ChemicalFormula "ChemicalFormula[elem1n1, elem2n2, …|>] represents a chemical species with ni atoms of the element elemi.\nChemicalFormula[chem] returns the chemical formula corresponding to the given input.\nChemicalFormula[…, qual1val1, qual2val2 …|>] represents a species whose qualifiers quali have values vali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChemicalFormula)))
(def ChemicalInstance "ChemicalInstance[chemical, <|qual1val1, qual2val2, |>] represents a chemical whose qualifiers quali have values of vali.\nChemicalInstance[chemical, quantity] represents a chemical quantified by quantity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChemicalInstance)))
(def ChemicalReaction "ChemicalReaction[reactantsproducts] represents a chemical reaction between the given reactants and products." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChemicalReaction)))
(def ChessboardDistance "ChessboardDistance[u, v] gives the chessboard, Chebyshev, or sup norm distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChessboardDistance)))
(def ChiDistribution "ChiDistribution[ν] represents a χ distribution with ν degrees of freedom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChiDistribution)))
(def ChiSquareDistribution "ChiSquareDistribution[ν] represents a χ^2 distribution with ν degrees of freedom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChiSquareDistribution)))
(def ChineseRemainder "ChineseRemainder[{r1, r2, …}, {m1, m2, …}] gives the smallest x with x≥0 that satisfies all the integer congruences x mod miri mod mi.\nChineseRemainder[{r1, r2, …}, {m1, m2, …}, d] gives the smallest x with x≥d that satisfies all the integer congruences x mod miri mod mi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChineseRemainder)))
(def ChoiceButtons "ChoiceButtons[] represents a pair of OK and Cancel buttons that close a dialog.\nChoiceButtons[{actok, actcancel}] represents OK and Cancel buttons that evaluate the corresponding acti when clicked.\nChoiceButtons[{lblok, lblcancel}, {actok, actcancel}] uses the lbli to label the buttons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChoiceButtons)))
(def ChoiceDialog "ChoiceDialog[expr] puts up a standard choice dialog that displays expr together with OK and Cancel buttons, and returns True if OK is clicked and False if Cancel is clicked.\nChoiceDialog[expr, {lbl1val1, lbl2val2, …}] includes buttons with labels lbli, and returns the corresponding vali for the button clicked." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChoiceDialog)))
(def CholeskyDecomposition "CholeskyDecomposition[m] gives the Cholesky decomposition of a matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CholeskyDecomposition)))
(def Chop "Chop[expr] replaces approximate real numbers in expr that are close to zero by the exact integer 0. \nChop[expr, delta] replaces numbers smaller in absolute magnitude than delta by 0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Chop)))
(def ChromaticPolynomial "ChromaticPolynomial[g, k] gives the chromatic polynomial of the graph g.\nChromaticPolynomial[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChromaticPolynomial)))
(def ChromaticityPlot "ChromaticityPlot[colspace] plots a 2D slice of the color space colspace. \nChromaticityPlot[color] plots the specific color.\nChromaticityPlot[{col1, col2, …}] plots multiple colors and color spaces.\nChromaticityPlot[image] plots the pixels of image as individual colors.\nChromaticityPlot[…, refcolspace] uses the reference color space refcolspace." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChromaticityPlot)))
(def ChromaticityPlot3D "ChromaticityPlot3D[colspace] returns a 3D gamut of the color space colspace.\nChromaticityPlot3D[color] plots the specific color.\nChromaticityPlot3D[image] plots the pixels of image as individual colors.\nChromaticityPlot3D[{input1, input2, …}] plots multiple colors, color spaces and images.\nChromaticityPlot3D[…, refcolspace] uses the reference color space refcolspace." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ChromaticityPlot3D)))
(def Circle "Circle[{x, y}, r] represents a circle of radius r centered at {x, y}.\nCircle[{x, y}] gives a circle of radius 1. \nCircle[{x, y}, {rx, ry}] gives an axis-aligned ellipse with semiaxes lengths rx and ry.\nCircle[{x, y}, …, {θ1, θ2}] gives a circular or ellipse arc from angle θ1 to θ2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Circle)))
(def CircleDot "CircleDot[x, y, …] displays as x⊙y⊙…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircleDot)))
(def CircleMinus "CircleMinus[x, y] displays as x⊖y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircleMinus)))
(def CirclePlus "CirclePlus[x, y, …] displays as x⊕y⊕…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CirclePlus)))
(def CirclePoints "CirclePoints[n] gives the positions of n points equally spaced around the unit circle.\nCirclePoints[r, n] gives the positions of n points equally spaced around a circle of radius r.\nCirclePoints[{r, θ1}, n] starts at angle θ1 with respect to the x axis.\nCirclePoints[{x, y}, rspec, n] centers the circle at {x, y}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CirclePoints)))
(def CircleThrough "CircleThrough[{p1, p2, …}] represents a circle passing through the points pi.\nCircleThrough[{p1, p2, …}, q] represents a circle with center q.\nCircleThrough[{p1, p2, …}, q, r] represents a circle with radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircleThrough)))
(def CircleTimes "CircleTimes[x] displays as ⊗x.\nCircleTimes[x, y, …] displays as x⊗y⊗…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircleTimes)))
(def CirculantGraph "CirculantGraph[n, j] gives the circulant graph Cn(j) with n vertices and jump j.\nCirculantGraph[n, {j1, j2, …}] gives the circulant graph Cn(j1, j2, …) with n vertices and jumps j1, j2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CirculantGraph)))
(def CircularArcThrough "CircularArcThrough[{p1, p2, …}] represents a circular arc passing through the points pi.\nCircularArcThrough[{p1, p2, …}, q] represents a circular arc with center q.\nCircularArcThrough[{p1, p2, …}, q, r] represents a circular arc with radius r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularArcThrough)))
(def CircularOrthogonalMatrixDistribution "CircularOrthogonalMatrixDistribution[n] represents a circular orthogonal matrix distribution with matrix dimensions {n, n}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularOrthogonalMatrixDistribution)))
(def CircularQuaternionMatrixDistribution "CircularQuaternionMatrixDistribution[n] represents a circular quaternion matrix distribution with matrix dimensions {2 n, 2 n} over the field of complex numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularQuaternionMatrixDistribution)))
(def CircularRealMatrixDistribution "CircularRealMatrixDistribution[n] represents a circular real matrix distribution with matrix dimensions {n, n}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularRealMatrixDistribution)))
(def CircularSymplecticMatrixDistribution "CircularSymplecticMatrixDistribution[n] represents a circular symplectic matrix distribution with matrix dimensions {2 n, 2 n} over the field of complex numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularSymplecticMatrixDistribution)))
(def CircularUnitaryMatrixDistribution "CircularUnitaryMatrixDistribution[n] represents a circular unitary matrix distribution with matrix dimensions {n, n}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircularUnitaryMatrixDistribution)))
(def CircumscribedBall "CircumscribedBall[{p1, p2, …}] gives a ball with minimal radius that encloses the points p1, p2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CircumscribedBall)))
(def Circumsphere "Circumsphere[{p1, …, p n+1}] gives the sphere that circumscribes the points pi in ^n.\nCircumsphere[poly] gives the circumsphere of a polyhedron or polygon poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Circumsphere)))
(def CityData "CityData[name, \"property\"] gives the value of the specified property for the city with the specified name.\nCityData[name] gives a list of the full specifications of cities whose names are consistent with name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CityData)))
(def ClassPriors "ClassPriors is an option for Classify and related functions that specifies explicit prior probabilities to assume for output classes, independent of anything deduced from the training set." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClassPriors)))
(def ClassifierFunction "ClassifierFunction[…] represents a function generated by Classify that classifies data into classes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClassifierFunction)))
(def ClassifierMeasurements "ClassifierMeasurements[classifier, testset, prop] gives measurements associated with property prop when classifier is evaluated on testset.\nClassifierMeasurements[classifier, testset] yields a measurement report that can be applied to any property.\nClassifierMeasurements[data, …] uses classifications data instead of a classifier.\nClassifierMeasurements[…, {prop1, prop2, …}] gives properties prop1, prop2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClassifierMeasurements)))
(def ClassifierMeasurementsObject "ClassifierMeasurementsObject[…] represents an object generated by ClassifierMeasurements that can be applied to properties." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClassifierMeasurementsObject)))
(def Classify "Classify[{in1class1, in2class2, …}] generates a ClassifierFunction that attempts to predict classi from the example ini.\nClassify[data, input] attempts to predict the output associated with input from the training examples given.\nClassify[data, input, prop] computes the specified property prop relative to the prediction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Classify)))
(def Clear "Clear[s1, s2, …] clears values and definitions for the symbols si. \nClear[patt1, patt2, …] clears values and definitions for all symbols whose names textually match any of the arbitrary string patterns patti.\nClear[{spec1, spec2, …}] clears values and definitions for any symbols that are equal to or whose names match any of the speci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Clear)))
(def ClearAll "ClearAll[s1, s2, …] clears all values, definitions, attributes, defaults, options and messages for the symbols si.\nClearAll[patt1, patt2, …] clears all symbols whose names textually match any of the arbitrary string patterns patti.\nClearAll[{spec1, spec, …}] clears any symbols that are equal to or whose names match any of the speci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearAll)))
(def ClearAttributes "ClearAttributes[symbol, attr] removes attr from the list of attributes of the symbol symbol. \nClearAttributes[\"symbol\", attr] removes attr from the attributes of the symbol named \"symbol\" if it exists.\nClearAttributes[s, {attr1, attr2, …}] removes several attributes at a time.\nClearAttributes[{s1, s2, …}, attrs] removes attributes from several symbols at a time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearAttributes)))
(def ClearCookies "ClearCookies[domain] clears all persistent and session cookies associated with the specified domain.\nClearCookies[assoc] clears all cookies whose attributes match the specification in the association assoc.\nClearCookies[All] clears all persistent and session cookies for all domains." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearCookies)))
(def ClearDistributedDefinitions "ClearDistributedDefinitions[s1, s2, …] clears all previously distributed definitions of symbols si on all parallel kernels.\nClearDistributedDefinitions[] clears all previously distributed definitions of all symbols." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearDistributedDefinitions)))
(def ClearPermissions "ClearPermissions[obj, class] clears permissions for the specified class of users for the cloud object obj. \nClearPermissions[class] clears permissions for the cloud object corresponding to the current document." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearPermissions)))
(def ClearSystemCache "ClearSystemCache[] clears internal system caches of stored results.\nClearSystemCache[type] clears only caches of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClearSystemCache)))
(def ClebschGordan "ClebschGordan[{j1, m1}, {j2, m2}, {j, m}] gives the Clebsch–Gordan coefficient for the decomposition of j, m〉 in terms of j1, m1〉j2, m2〉." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClebschGordan)))
(def ClickPane "ClickPane[image, func] represents a clickable pane that displays as image and applies func to the x, y coordinates of each click within the pane.\nClickPane[image, {{xmin, ymin}, {xmax, ymax}}, func] specifies the range of coordinates to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClickPane)))
(def ClickToCopy "ClickToCopy[expr] represents a button that copies expr whenever it is clicked.\nClickToCopy[label, expr] displays with label on the button." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClickToCopy)))
(def ClickToCopyEnabled "ClickToCopyEnabled is an option for Cell that specifies whether to show a click-to-copy overlay when hovering over a cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClickToCopyEnabled)))
(def Clip "Clip[x] gives x clipped to be between -1 and +1. \nClip[x, {min, max}] gives x for min≤x≤max, min for x<min and max for x>max. \nClip[x, {min, max}, {vmin, vmax}] gives vmin for x<min and vmax for x>max." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Clip)))
(def ClipPlanes "ClipPlanes is an option to Graphics3D that specifies a list of clipping planes that can cut away portions of a 3D scene from the resulting view." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClipPlanes)))
(def ClipPlanesStyle "ClipPlanesStyle is an option to Graphics3D that specifies how clipping planes defined with the ClipPlanes option should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClipPlanesStyle)))
(def ClipRange "ClipRange is an option to Raster3D that specifies a rectangular region that is cut away from the resulting view." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClipRange)))
(def ClippingStyle "ClippingStyle is an option for plotting functions that specifies the style of what should be drawn when curves or surfaces would extend beyond the plot range." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClippingStyle)))
(def Clock "Clock[] represents a clock variable whose value cycles continuously from 0 to 1 once per second when it appears inside a dynamically updated object such as a Dynamic. \nClock[t] cycles from 0 to t every t seconds.\nClock[vmax, t] cycles from 0 to vmax every t seconds.\nClock[{vmin, vmax}, t] cycles through the range vmin to vmax every t seconds.\nClock[{vmin, vmax}] cycles through the range vmin to vmax over the course of vmax-vmin seconds.\nClock[{vmin, vmax, dv}] cycles from vmin to vmax in steps of dv, spending dv seconds at each value.\nClock[{vmin, vmax, dv}, t] cycles from vmin to vmax in steps dv every t seconds.\nClock[vals, t, n] goes through the cycle only n times, then always yields only the maximum value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Clock)))
(def ClockGauge "ClockGauge[] draws an analog clock face showing the local time with hours, minutes, and seconds.\nClockGauge[time] draws an analog clock face showing the time corresponding to an AbsoluteTime, DateObject, or TimeObject specification.\nClockGauge[{h, m, s}] draws an analog clock face showing hour h, minute m, and seconds s.\nClockGauge[{y, m, d, h, m, s}] draws an analog clock face showing the time corresponding to the date list in a DateList specification.\nClockGauge[\"string\"] draws an analog clock face showing the time DateList[\"string\"]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClockGauge)))
(def Close "Close[obj] closes a stream or socket." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Close)))
(def CloseKernels "CloseKernels[] terminates all parallel kernels from the list ParallelKernels[].\nCloseKernels[k] terminates the kernel k.\nCloseKernels[{k1, k2, …}] terminates the kernels k1, k2, ….\nCloseKernels[\"prop\"] terminates kernels that satisfy the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloseKernels)))
(def ClosenessCentrality "ClosenessCentrality[g] gives a list of closeness centralities for the vertices in the graph g.\nClosenessCentrality[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClosenessCentrality)))
(def Closing "Closing[image, ker] gives the morphological closing of image with respect to the structuring element ker.\nClosing[image, r] gives the closing with respect to a range-r square.\nClosing[data, …] applies closing to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Closing)))
(def CloudAccountData "CloudAccountData[] gives data associated with the cloud account currently being used.\nCloudAccountData[\"prop\"] gives the property prop associated with the cloud account being used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudAccountData)))
(def CloudBase "CloudBase is an option specifying the base URI of the server to use for cloud operations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudBase)))
(def CloudConnect "CloudConnect[userid, password] authenticates to the Wolfram Cloud using the specified cloud user ID and password.\nCloudConnect[userid] shows a dialog to input the password.\nCloudConnect[] shows a dialog to input both the cloud user ID and the password." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudConnect)))
(def CloudDeploy "CloudDeploy[expr] deploys expr to a new anonymous cloud object.\nCloudDeploy[expr, location] deploys expr to a cloud object at the specified location relative to the user's current cloud directory. \nCloudDeploy[expr, CloudObject[…]] deploys expr to the specified cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudDeploy)))
(def CloudDirectory "CloudDirectory[] gives a CloudObject representing the current working directory used for cloud objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudDirectory)))
(def CloudDisconnect "CloudDisconnect[] disconnects a non-cloud instance of the Wolfram Language from the Wolfram Cloud." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudDisconnect)))
(def CloudEvaluate "CloudEvaluate[expr] evaluates expr in the cloud and returns the result.\nCloudEvaluate[expr, h] wraps the head h around the result before returning it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudEvaluate)))
(def CloudExport "CloudExport[expr, \"format\"] exports expr to a new anonymous cloud object in the specified format.\nCloudExport[expr, \"format\", \"uri\"] exports to a cloud object at a given URI.\nCloudExport[expr, \"format\", CloudObject[\"uri\"]] exports to a given cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudExport)))
(def CloudExpression "CloudExpression[\"name\"] represents an expression whose value is persistently stored in the cloud.\nCloudExpression[\"http://…\"], CloudExpression[\"https://…\"] represents a cloud expression with a given URI.\nCloudExpression[base, part1, part2, …] represents the part of a cloud expression specified by the parti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudExpression)))
(def CloudExpressions "CloudExpressions[] gives a list of named cloud expressions owned by you. \nCloudExpressions[None] gives a list of anonymous cloud expressions owned by you.\nCloudExpressions[All] gives a list of all cloud expressions owned by you." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudExpressions)))
(def CloudFunction "CloudFunction[fun] represents a pure function that evaluates fun[args] in the cloud.\nCloudFunction[CloudObject[…]] represents a function that applies the contents of the specified cloud object.\nCloudFunction[f, h] wraps the head h around the result of the function before returning it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudFunction)))
(def CloudGet "CloudGet[\"uri\"] reads in a cloud object at a given URI, evaluating each expression in it and returning the last one.\nCloudGet[CloudObject[\"uri\"]] reads in a given cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudGet)))
(def CloudImport "CloudImport[\"uri\"] imports from a cloud object at a given URI.\nCloudImport[\"uri\", elements] imports the specified elements of a cloud object.\nCloudImport[CloudObject[\"uri\"]] imports from a given cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudImport)))
(def CloudLoggingData "CloudLoggingData[] gives summary logging data for all your cloud objects.\nCloudLoggingData[category] gives summary logging data for all your cloud objects of a particular category.\nCloudLoggingData[obj] gives summary logging data for the cloud object obj.\nCloudLoggingData[{obj1, …}] gives aggregated summary logging data for all the objects obji.\nCloudLoggingData[objs, period] gives summary logging data for the specified period.\nCloudLoggingData[objs, period, elems] gives logging data elements specified by elems." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudLoggingData)))
(def CloudObject "CloudObject[] represents a new anonymous cloud object.\nCloudObject[\"http://…\"], CloudObject[\"https://…\"] represents a cloud object with a given URI.\nCloudObject[\"user:user/path\"] represents a cloud object of a given user with a given path.\nCloudObject[\"uuid:uuid\"] represents a cloud object identified by a given UUID.\nCloudObject[\"/abspath\"] represents a cloud object of the currently authenticated user at an absolute path.\nCloudObject[\"relpath\"] represents a cloud object of the currently authenticated user at a relative path.\nCloudObject[\"relpath\", base] represents a cloud object with a path relative to the base path base." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudObject)))
(def CloudObjectNameFormat "CloudObjectNameFormat is an option for CloudObject and related objects that determines how the name portion of the URL for the object should be formatted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudObjectNameFormat)))
(def CloudObjectURLType "CloudObjectURLType is an option for CloudObject and related objects that specifies the base type of URL to generate for the object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudObjectURLType)))
(def CloudObjects "CloudObjects[] gives a list of cloud objects in your current cloud directory.\nCloudObjects[dir] gives a list of cloud objects in the cloud directory dir.\nCloudObjects[None] gives a list of all unnamed cloud objects owned by you.\nCloudObjects[dir, type] gives a list of cloud objects of the specified type in the cloud directory dir.\nCloudObjects[assoc] gives a list of cloud objects matching the filters defined by the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudObjects)))
(def CloudPublish "CloudPublish[] makes a public copy in the cloud of the current document.\nCloudPublish[obj] makes a public copy of the cloud object obj.\nCloudPublish[expr] deploys an expression to the cloud and makes it public.\nCloudPublish[content, location] publishes to the specified location relative to the user's current cloud directory. \nCloudPublish[content, CloudObject[…]] publishes to the specified cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudPublish)))
(def CloudPut "CloudPut[expr] writes expr to a new anonymous cloud object.\nCloudPut[expr, \"uri\"] writes expr to a cloud object at a given URI.\nCloudPut[expr, CloudObject[\"uri\"]] writes expr to a given cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudPut)))
(def CloudRenderingMethod "CloudRenderingMethod is an option for Cell and Notebook that specifies how to render cells in the cloud." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudRenderingMethod)))
(def CloudSave "CloudSave[symbol] saves definitions associated with the specified symbol to a new anonymous cloud object.\nCloudSave[\"form\"] saves definitions associated with all symbols whose names match the string pattern \"form\". \nCloudSave[\"context\"] saves definitions associated with all symbols in the specified context. \nCloudSave[{object1, object2, …}] saves definitions associated with several objects. \nCloudSave[symspec, \"uri\"] appends definitions associated with symspec to the cloud object at the given URI.\nCloudSave[symspec, CloudObject[\"uri\"]] appends definitions to the given cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudSave)))
(def CloudShare "CloudShare[user] shares the current cloud document with the specified user.\nCloudShare[{user1, user2, …}] shares the current document with all the users useri.\nCloudShare[obj, users] shares the cloud object obj with the specified users." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudShare)))
(def CloudSubmit "CloudSubmit[expr] submits expr for immediate asynchronous cloud evaluation. \nCloudSubmit[ScheduledTask[expr, spec]] submits a task to evaluate expr in the cloud on the schedule defined by spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudSubmit)))
(def CloudSymbol "CloudSymbol[\"name\"] represents a symbol whose value is persistently stored in the cloud.\nCloudSymbol[obj] represents a persistent symbol corresponding to the cloud object obj.\nCloudSymbol[\"uri\"] represents a cloud symbol located at a given URI." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudSymbol)))
(def CloudUnshare "CloudUnshare[obj] cancels sharing of the cloud object obj with everyone.\nCloudUnshare[obj, users] cancels sharing with the specified list of users." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CloudUnshare)))
(def ClusterClassify "ClusterClassify[data] generates a ClassifierFunction[…] by partitioning data into clusters of similar elements.\nClusterClassify[data, n] generates a ClassifierFunction[…] with n clusters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClusterClassify)))
(def ClusterDissimilarityFunction "ClusterDissimilarityFunction is an option for ClusteringTree and Dendrogram that specifies the intercluster dissimilarity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClusterDissimilarityFunction)))
(def ClusteringComponents "ClusteringComponents[array] gives an array in which each element at the lowest level of array is replaced by an integer index representing the cluster in which the element lies.\nClusteringComponents[array, n] finds n clusters.\nClusteringComponents[array, n, level] finds clusters at the specified level in array.\nClusteringComponents[image] finds clusters of pixels with similar values in image.\nClusteringComponents[image, n] finds n clusters in image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClusteringComponents)))
(def ClusteringMeasurements "ClusteringMeasurements[{{e1, e2, …}, …}, meas] returns the measurement meas for the clustered examples ei.\nClusteringMeasurements[clusters, gt, meas] assumes the ground truth clustering gt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClusteringMeasurements)))
(def ClusteringTree "ClusteringTree[{e1, e2, …}] constructs a weighted tree from the hierarchical clustering of the elements e1, e2, ….\nClusteringTree[{e1v1, e2v2, …}] represents ei with vi in the constructed graph.\nClusteringTree[{e1, e2, …}{v1, v2, …}] represents ei with vi in the constructed graph.\nClusteringTree[label1e1, label2e 2…] represents ei using labels labeli in the constructed graph.\nClusteringTree[data, h] constructs a weighted tree from the hierarchical clustering of data by joining subclusters at distance less than h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ClusteringTree)))
(def CodeAssistOptions "CodeAssistOptions is an option for cells that specifies settings for controlling code input assistance features, including autocompletion, function template insertion, and mouseover behaviors for code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CodeAssistOptions)))
(def Coefficient "Coefficient[expr, form] gives the coefficient of form in the polynomial expr. \nCoefficient[expr, form, n] gives the coefficient of form^n in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Coefficient)))
(def CoefficientArrays "CoefficientArrays[polys, vars] gives the arrays of coefficients of the variables vars in the polynomials polys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoefficientArrays)))
(def CoefficientList "CoefficientList[poly, var] gives a list of coefficients of powers of var in poly, starting with power 0. \nCoefficientList[poly, {var1, var2, …}] gives an array of coefficients of the vari. \nCoefficientList[poly, {var1, var2, …}, {dim1, dim2, …}] gives an array of dimensions {dim1, dim2, …}, truncating or padding with zeros as needed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoefficientList)))
(def CoefficientRules "CoefficientRules[poly, {x1, x2, …}] gives the list {{e11, e12, …}c1, {e21, …}c2, …} of exponent vectors and coefficients for the monomials in poly with respect to the xi.\nCoefficientRules[poly, {x1, x2, …}, order] gives the result with the monomial ordering specified by order." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoefficientRules)))
(def CoifletWavelet "CoifletWavelet[] represents a Coiflet wavelet of order 2.\nCoifletWavelet[n] represents a Coiflet wavelet of order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoifletWavelet)))
(def Collect "Collect[expr, x] collects together terms involving the same powers of objects matching x. \nCollect[expr, {x1, x2, …}] successively collects together terms that involve the same powers of objects matching x1, then x2, …. \nCollect[expr, var, h] applies h to the expression that forms the coefficient of each term obtained." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Collect)))
(def CollinearPoints "CollinearPoints[{p1, p2, p3, …, pn}] tests whether the points p1, p2, p3, …, pn are collinear." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CollinearPoints)))
(def Colon "Colon[x, y, …] displays as x∶y∶…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Colon)))
(def ColorBalance "ColorBalance[image] adjusts the colors in image to achieve a balance that simulates the effect of neutral lighting.\nColorBalance[image, ref] adjusts colors in image so that the reference color specified by ref is mapped to white. \nColorBalance[image, reftarget] maps the reference color ref to target." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorBalance)))
(def ColorCombine "ColorCombine[{image1, image2, …}] creates a multichannel image by combining the sequence of channels in the imagei. \nColorCombine[{image1, image2, …}, colorspace] combines images that represent the color components specified by colorspace." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorCombine)))
(def ColorConvert "ColorConvert[color, colspace] converts the color space of a color to the specified color space colspace.\nColorConvert[image, colspace] converts the color space of image.\nColorConvert[{expr1, …}, colspace] converts the color space of a list of colors and images." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorConvert)))
(def ColorCoverage "ColorCoverage is an option for DominantColors that specifies the minimum image coverage that each color cluster should have." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorCoverage)))
(def ColorData "ColorData[\"scheme\"] gives a function that generates colors in the named color scheme when applied to parameter values. \nColorData[\"scheme\", \"property\"] gives the specified property of a color scheme.\nColorData[\"collection\"] gives a list of color schemes in a named collection.\nColorData[] gives a list of named collections of color schemes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorData)))
(def ColorDataFunction "ColorDataFunction[range, …] is a function that represents a color scheme." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorDataFunction)))
(def ColorDetect "ColorDetect[image, cspec] returns a mask image representing regions in image with colors within the specified color region." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorDetect)))
(def ColorDistance "ColorDistance[c1, c2] gives the approximate perceptual distance between color directives c1 and c2.\nColorDistance[list, c] gives color distances between elements of list and c.\nColorDistance[list1, list2] gives color distances between corresponding elements of list1 and list2.\nColorDistance[image, c] gives an image whose pixel values are color distance between pixels in image and the color c.\nColorDistance[image1, image2] yields an image giving the pixelwise color distance between image1 and image2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorDistance)))
(def ColorFunction "ColorFunction is an option for graphics functions that specifies a function to apply to determine colors of elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorFunction)))
(def ColorFunctionBinning "ColorFunctionBinning is an option for plotting functions that divides values into a limited set of bins for styling." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorFunctionBinning)))
(def ColorFunctionScaling "ColorFunctionScaling is an option for graphics functions that specifies whether arguments supplied to a color function should be scaled to lie between 0 and 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorFunctionScaling)))
(def ColorNegate "ColorNegate[color] gives the negative of a color.\nColorNegate[image] gives the negative of image, in which all colors have been negated.\nColorNegate[video] negates every frame of a video.\nColorNegate[{expr1, …}] gives a list of negative images or colors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorNegate)))
(def ColorProfileData "ColorProfileData[<>, \"Description\"\"desc\", \"DeviceColorSpace\"\"device\", \"IndependentColorSpace\"\"ics\"] represents an ICC color profile that can convert between the independent color space \"ics\" and the device-dependent color space \"device\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorProfileData)))
(def ColorQ "ColorQ[color] yields True if color is a valid color directive and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorQ)))
(def ColorQuantize "ColorQuantize[image] gives an approximation to image by quantizing to distinct colors.\nColorQuantize[image, n] uses at most n distinct colors.\nColorQuantize[image, {col1, …, coln}] represents an image using only the n specified colors coli." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorQuantize)))
(def ColorReplace "ColorReplace[image, color] finds regions in image whose pixel values are similar to color and replaces them with transparent pixels.\nColorReplace[image, colorreplacement] replaces all pixels with the specified replacement color.\nColorReplace[image, colorreplacement, d] replaces all pixels whose values are within a distance d from color.\nColorReplace[image, {color1replacement1, …}, {d1, …}] does multiple color replacements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorReplace)))
(def ColorRules "ColorRules is an option that specifies how colors of cells should be determined from values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorRules)))
(def ColorSeparate "ColorSeparate[image] gives a list of single-channel images corresponding to each of the color channels in image.\nColorSeparate[image, colorspace] gives a list of images corresponding to the components of colorspace.\nColorSeparate[image, channel] returns a single-channel image containing the specified channel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorSeparate)))
(def ColorSetter "ColorSetter[color] represents a color setter which displays as a swatch of the specified color and when clicked brings up a system color picker dialog.\nColorSetter[Dynamic[color]] uses the dynamically updated current value of color, with the value of color being reset if the color is modified.\nColorSetter[] gives a color setter with initial color gray." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorSetter)))
(def ColorSlider "ColorSlider[color] represents a color slider currently set to the color corresponding to color.\nColorSlider[Dynamic[color]] uses the dynamically updated current value of color, with the value of color being reset if the color is modified.\nColorSlider[] represents a color slider with an initial gray color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorSlider)))
(def ColorSpace "ColorSpace is an option for Image and related functions that specifies the color space to which color values refer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorSpace)))
(def ColorToneMapping "ColorToneMapping[image] applies a tone mapping to color values in image so as to make variations of luminance visible even in small intervals of the dynamic range. \nColorToneMapping[image, c] maps colors by compressing the overall range of luminance values by a factor c.\nColorToneMapping[image, range] applies a mapping only to colors whose initial luminance lies in the specified range.\nColorToneMapping[image, {range, c}] takes the specified range of colors and compresses their overall luminance values by a factor c.\nColorToneMapping[image, {{range1, c1}, {range2, c2}, …}] uses different compression factors ci for different ranges rangei. \nColorToneMapping[image, spec, s] uses the color compensation factor s to correct for saturation distortion introduced during tone mapping." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorToneMapping)))
(def Colorize "Colorize[m] generates an image from an integer matrix m, using colors for positive integers and black for non-positive integers.\nColorize[image] replaces intensity values in image with pseudocolor values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Colorize)))
(def ColorsNear "ColorsNear[color] represents a region around color.\nColorsNear[color, d] represents a region with maximum distance d around color.\nColorsNear[color, d, dfun] uses the specified color distance function dfun." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColorsNear)))
(def Column "Column[{expr1, expr2, …}] is an object that formats with the expri arranged in a column, with expr1 above expr2, etc. \nColumn[list, alignment] aligns each element horizontally in the specified way. \nColumn[list, alignment, spacing] leaves the specified number of x-heights of spacing between successive elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Column)))
(def ColumnAlignments "ColumnAlignments is an option for the low-level function GridBox that specifies how entries in each column should be aligned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColumnAlignments)))
(def ColumnLines "ColumnLines is an option for the low-level function GridBox which specifies whether lines should be drawn between adjacent columns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColumnLines)))
(def ColumnSpacings "ColumnSpacings is an option for the low-level function GridBox which specifies the spaces in ems that should be inserted between adjacent columns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColumnSpacings)))
(def ColumnWidths "ColumnWidths is an option for the low-level function GridBox which specifies the widths to use for columns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColumnWidths)))
(def ColumnsEqual "ColumnsEqual is an option for the low-level function GridBox which specifies whether all columns in the grid should be assigned equal width." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ColumnsEqual)))
(def Comap "Comap[{f1, f2, …}, x] gives {f1[x], f2[x], …}.\nComap[fs, x, levelspec] applies parts of fs specified by levelspec to x.\nComap[fs] represents an operator form of Comap that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Comap)))
(def ComapApply "ComapApply[{f1, f2, …}, expr] gives {Apply[f1, expr], Apply[f2, expr], …}.\nComapApply[fs] represents an operator form of ComapApply that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComapApply)))
(def CombinatorB "CombinatorB represents the B combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorB)))
(def CombinatorC "CombinatorC represents the C combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorC)))
(def CombinatorI "CombinatorI represents the I combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorI)))
(def CombinatorK "CombinatorK represents the K combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorK)))
(def CombinatorS "CombinatorS represents the S combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorS)))
(def CombinatorW "CombinatorW represents the W combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorW)))
(def CombinatorY "CombinatorY represents the Y combinator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinatorY)))
(def CombinedEntityClass "CombinedEntityClass[class1, class2, prop] represents a class of entities obtained by combining the properties of those pairs of entities from class1 and class2 for which the value of the property prop is the same for the two entities in the pair.\nCombinedEntityClass[class1, class2, prop1prop2] combines pairs of entities from class1 and class2 for which the value of prop1 of the entity from class1 is the same as the value of prop2 for the entity from class2. \nCombinedEntityClass[class1, class2, {pspeca, pspecb, …}] combines pairs of entities for which all the property specifications pspeck agree.\nCombinedEntityClass[class1, class2, f] combines pairs of entities for which the application of the entity function f yields True. \nCombinedEntityClass[class1, class2, spec, \"jspec\"] uses \"jspec\" to determine when to allow entities with missing properties to be included." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinedEntityClass)))
(def CombinerFunction "CombinerFunction is an option for template functions that specifies how fragments should be assembled to give the result of applying a template." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CombinerFunction)))
(def CometData "CometData[entity, property] gives the value of the specified property for the comet entity.\nCometData[{entity1, entity2, …}, property] gives a list of property values for the specified comet entities.\nCometData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CometData)))
(def CommonName "CommonName[entity] gives the common name for the entity specified by entity.\nCommonName[{entity1, …, entityn}] gives the common name for entity1 through entityn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommonName)))
(def CommonUnits "CommonUnits[{quantity1, quantity2, …, quantityn}] converts quantity1 through quantityn to common units across compatible dimensions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommonUnits)))
(def Commonest "Commonest[list] gives a list of the elements that are the most common in list.\nCommonest[list, n] gives a list of the n most common elements in list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Commonest)))
(def CommonestFilter "CommonestFilter[data, r] filters data by replacing every value with the most common value in its range-r neighborhood.\nCommonestFilter[data, {r1, r2, …}] uses ri for filtering the i ^th dimension in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommonestFilter)))
(def CommunityBoundaryStyle "CommunityBoundaryStyle is an option to CommunityGraphPlot that specifies how to style community boundaries." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommunityBoundaryStyle)))
(def CommunityGraphPlot "CommunityGraphPlot[g] generates a plot showing the community structure of the graph g.\nCommunityGraphPlot[g, {{v i1, v i2, …}, …}] generates a plot for the graph g with communities {v i1, v i2, …}, ….\nCommunityGraphPlot[g, {…, wj[{v i1, …}], …}] generates a plot with highlighting features defined by the symbol wrappers wj.\nCommunityGraphPlot[{v i1v j1, v i2v j2, …}, …] generates a plot for a graph in which vertex vik is connected to vertex vjk.\nCommunityGraphPlot[m, …] generates a plot for a graph represented by the adjacency matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommunityGraphPlot)))
(def CommunityLabels "CommunityLabels is an option to CommunityGraphPlot that controls what labels and placement to use for communities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommunityLabels)))
(def CommunityRegionStyle "CommunityRegionStyle is an option to CommunityGraphPlot that specifies how to style community regions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CommunityRegionStyle)))
(def CompanyData "CompanyData[entity, property] gives the value of the specified property for the company entity.\nCompanyData[{entity1, entity2, …}, property] gives a list of property values for the specified company entities.\nCompanyData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompanyData)))
(def CompatibleUnitQ "CompatibleUnitQ[quantity1, quantity2] returns True if quantity1 and quantity2 have compatible units, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompatibleUnitQ)))
(def CompilationOptions "CompilationOptions is an option for Compile that specifies settings for the compilation process." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilationOptions)))
(def CompilationTarget "CompilationTarget is an option for Compile that specifies the target runtime for the compiled function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilationTarget)))
(def Compile "Compile[{x1, x2, …}, expr] creates a compiled function that evaluates expr assuming numerical values of the xi. \nCompile[{{x1, t1}, …}, expr] assumes that xi is of a type that matches ti. \nCompile[{{x1, t1, n1}, …}, expr] assumes that xi is a rank ni array of objects, each of a type that matches ti. \nCompile[vars, expr, {{p1, pt1}, …}] assumes that subexpressions in expr that match pi are of types that match pti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Compile)))
(def Compiled "Compiled is an option for various numerical and plotting functions which specifies whether the expressions they work with should automatically be compiled." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Compiled)))
(def CompiledCodeFunction "CompiledCodeFunction[…] is a function created by FunctionCompile that contains compiled code that is run when the CompiledCodeFunction is applied to suitable arguments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledCodeFunction)))
(def CompiledComponent "CompiledComponent[name] represents a compiled component." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledComponent)))
(def CompiledComponentRawInterface "CompiledComponentRawInterface[comp] represents the raw interface of a compiled component." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledComponentRawInterface)))
(def CompiledExpressionDeclaration "CompiledExpressionDeclaration[h, n] represents a type for expressions of the form h[x1, x2, …, xn], suitable for use in compiled code.\nCompiledExpressionDeclaration[h, {t1, t2, …}] represents a type for expressions of the form h[x1, x2, …, xn], with xi having the type ti.\nCompiledExpressionDeclaration[h\"name\", …] names the declared type \"name\".\nCompiledExpressionDeclaration[h->\"name\"::[v1, v2, …], {t1, t2, …}] represents a parameterized type with parameters labeled by v1, v2, ….\nCompiledExpressionDeclaration[h\"name\"::[v1, v2, …], cond, {t1, t2, …}] asserts the condition cond on the type parameters.\nCompiledExpressionDeclaration[…, test] represents a type for any expression expr on which the compilable function test returns True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledExpressionDeclaration)))
(def CompiledFunction "CompiledFunction[args…] represents compiled code for evaluating a compiled function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledFunction)))
(def CompiledLayer "CompiledLayer[func] represents a net layer whose computation is defined by the compilable function func.\nCompiledLayer[func, gradientfunc] specifies a gradient propagating function allowing the layer to be used in NetTrain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompiledLayer)))
(def CompilerCallback "CompilerCallback[\"name\"] is a function that, if defined in a compiler environment, is automatically called by the Wolfram Compiler." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerCallback)))
(def CompilerEnvironment "CompilerEnvironment is an option for FunctionCompile and related functions that allows definitions to be included in the compilation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerEnvironment)))
(def CompilerEnvironmentAppendTo "CompilerEnvironmentAppendTo[{def1, def2, …}] appends declarations to $CompilerEnvironment.\nCompilerEnvironmentAppendTo[env, {def1, def2, …}] appends declarations to CompilerEnvironmentObject env." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerEnvironmentAppendTo)))
(def CompilerEnvironmentObject "CompilerEnvironmentObject represents a collection of definitions that can be included in compilations by FunctionCompile and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerEnvironmentObject)))
(def CompilerInformation "CompilerInformation[fun] gives compiler-specific information about the function fun.\nCompilerInformation[ty] gives compiler-specific information about the type ty.\nCompilerInformation[] returns all functions and types known to the compiler." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerInformation)))
(def CompilerOptions "CompilerOptions is an option for FunctionCompile and related functions that allows options for the compilation pipeline to be specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerOptions)))
(def CompilerRuntimeErrorAction "CompilerRuntimeErrorAction is an option for FunctionCompile that determines what should happen when an unrecoverable error takes place while computing with low-level code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompilerRuntimeErrorAction)))
(def Complement "Complement[eall, e1, e2, …] gives the elements in eall that are not in any of the ei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Complement)))
(def ComplementedEntityClass "ComplementedEntityClass[classall, class1, …] represents an entity class containing all the entities in classall that are not in any of the classi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplementedEntityClass)))
(def CompleteGraph "CompleteGraph[n] gives the complete graph with n vertices Kn.\nCompleteGraph[{n1, n2, …, nk}] gives the complete k-partite graph with n1+n2+⋯+nk vertices K n1, n2, …, nk." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompleteGraph)))
(def CompleteGraphQ "CompleteGraphQ[g] yields True if the graph g is a complete graph, and False otherwise.\nCompleteGraphQ[g, vlist] yields True if the subgraph induced by vlist is a complete graph, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompleteGraphQ)))
(def CompleteIntegral "CompleteIntegral[pde, u, {x1, …, xn}] gives a complete integral u for the first-order partial differential equation pde, with independent variables {x1, …, xn}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompleteIntegral)))
(def CompleteKaryTree "CompleteKaryTree[n] gives the complete binary tree with n levels.\nCompleteKaryTree[n, k] gives the complete k-ary tree with n levels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompleteKaryTree)))
(def Complex "Complex is the head used for complex numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Complex)))
(def ComplexArrayPlot "ComplexArrayPlot[array] generates a plot in which complex values zij in an array array are shown in a discrete array of squares with Arg[zij] indicated by color and Abs[zij] by shading." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexArrayPlot)))
(def ComplexContourPlot "ComplexContourPlot[f, {z, zmin, zmax}] generates a filled contour plot of f as a function of z. \nComplexContourPlot[{f1, f2, …}, {z, zmin, zmax}] generates contour lines for f1, f2, …. \nComplexContourPlot[f==g, {z, zmin, zmax}] plots contour lines for which f=g.\nComplexContourPlot[{f1==g1, f2==g2, …}, {z, zmin, zmax}] plots contour lines for each of f1g1, f2=g2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexContourPlot)))
(def ComplexExpand "ComplexExpand[expr] expands expr assuming that all variables are real. \nComplexExpand[expr, {x1, x2, …}] expands expr assuming that variables matching any of the xi are complex." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexExpand)))
(def ComplexInfinity "ComplexInfinity represents a quantity with infinite magnitude, but undetermined complex phase." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexInfinity)))
(def ComplexListPlot "ComplexListPlot[{z1, z2, …}] plots complex numbers z1, z2, … as points in the complex plane.\nComplexListPlot[{data1, data2, …}] plots data from all datai.\nComplexListPlot[{…, w[datai, …], …}] plots datai with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexListPlot)))
(def ComplexPlot "ComplexPlot[f, {z, zmin, zmax}] generates a plot of Arg[f] over the complex rectangle with corners zmin and zmax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexPlot)))
(def ComplexPlot3D "ComplexPlot3D[f, {z, zmin, zmax}] generates a 3D plot of Abs[f] colored by Arg[f] over the complex rectangle with corners zmin and zmax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexPlot3D)))
(def ComplexRegionPlot "ComplexRegionPlot[pred, {z, zmin, zmax}] makes a plot showing the region in the complex plane for which pred is True.\nComplexRegionPlot[{pred1, pred2, …}, {z, zmin, zmax}] plots regions given by the multiple predicates predi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexRegionPlot)))
(def ComplexStreamPlot "ComplexStreamPlot[f, {z, zmin, zmax}] generates a streamline plot of the vector field {Re[f], Im[f]} over the complex rectangle with corners zmin and zmax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexStreamPlot)))
(def ComplexVectorPlot "ComplexVectorPlot[f, {z, zmin, zmax}] generates a vector plot of the vector field {Re[f], Im[f]} over the complex rectangle with corners zmin and zmax.\nComplexVectorPlot[{f1, f2, …}, {z, zmin, zmax}] plots several vector fields." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexVectorPlot)))
(def Complexes "Complexes represents the domain of complex numbers, as in x∈Complexes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Complexes)))
(def ComplexityFunction "ComplexityFunction is an option for Simplify and other functions which gives a function to rank the complexity of different forms of an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComplexityFunction)))
(def ComponentMeasurements "ComponentMeasurements[{image, lmat}, \"prop\"] computes the property \"prop\" for components of image indicated by the label matrix lmat.\nComponentMeasurements[image, \"prop\"] computes the property \"prop\" for connected components of image. \nComponentMeasurements[…, \"prop\", crit] only returns measurements for components that satisfy the criterion crit.\nComponentMeasurements[…, \"prop\", crit, format] formats the result according to the output specification format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComponentMeasurements)))
(def ComposeList "ComposeList[{f1, f2, …}, x] generates a list of the form {x, f1[x], f2[f1[x]], …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComposeList)))
(def ComposeSeries "ComposeSeries[series1, series2, …] composes several power series." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComposeSeries)))
(def CompositeQ "CompositeQ[n] yields True if n is a composite number, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompositeQ)))
(def Composition "Composition[f1, f2, f3, …] represents a composition of the functions f1, f2, f3, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Composition)))
(def CompoundElement "CompoundElement[{spec1, spec2, …}] represents a form or interpreter specification for a list of fields or inputs that gives a list of results.\nCompoundElement[key1spec1, key2spec2, …] represents a form or interpreter specification that gives an association of results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompoundElement)))
(def CompoundExpression "expr1;expr2;… evaluates the expri in turn, giving the last one as the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompoundExpression)))
(def CompoundPoissonDistribution "CompoundPoissonDistribution[λ, dist] represents a compound Poisson distribution with rate parameter λ and jump size distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompoundPoissonDistribution)))
(def CompoundPoissonProcess "CompoundPoissonProcess[λ, jdist] represents a compound Poisson process with rate parameter λ and jump size distribution jdist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompoundPoissonProcess)))
(def CompoundRenewalProcess "CompoundRenewalProcess[rdist, jdist] represents a compound renewal process with renewal-time distribution rdist and jump size distribution jdist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompoundRenewalProcess)))
(def Compress "Compress[expr] gives a compressed representation of expr as a string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Compress)))
(def CompressionLevel "CompressionLevel is an option for Export and CreateArchive that specifies the amount of compression to use when compressing data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CompressionLevel)))
(def ComputeUncertainty "ComputeUncertainty is an option for ClassifierMeasurements, LearnedDistribution and other functions to specify if numeric results should be returned along with their uncertainty." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ComputeUncertainty)))
(def ConcaveHullMesh "ConcaveHullMesh[{p1, p2, …}] gives the concave hull mesh from the points p1, p2, ….\nConcaveHullMesh[{p1, p2, …}, α] gives the concave hull mesh of the specified parameter α.\nConcaveHullMesh[{p1, p2, …}, α, d] gives the concave hull mesh of cells of dimension d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConcaveHullMesh)))
(def Condition "patt/;test is a pattern which matches only if the evaluation of test yields True. \nlhs:>rhs/;test represents a rule which applies only if the evaluation of test yields True. \nlhs:=rhs/;test is a definition to be used only if test yields True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Condition)))
(def ConditionalExpression "ConditionalExpression[expr, cond] is a symbolic construct that represents the expression expr when the condition cond is True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConditionalExpression)))
(def Conditioned "Conditioned[expr, cond] or exprcond represents expr conditioned by the predicate cond." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Conditioned)))
(def Cone "Cone[{{x1, y1, z1}, {x2, y2, z2}}, r] represents a cone with a base of radius r centered at (x1, y1, z1) and a tip at (x2, y2, z2). \nCone[{{x1, y1, z1}, {x2, y2, z2}}] represents a cone with a base of radius 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cone)))
(def ConfidenceLevel "ConfidenceLevel is an option for LinearModelFit and other fitting functions that specifies the level to use in various confidence and prediction intervals and bands." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfidenceLevel)))
(def ConfidenceRange "ConfidenceRange is an option for SurvivalModelFit and other functions that specifies the range over which simultaneous confidence intervals and bands are computed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfidenceRange)))
(def ConfidenceTransform "ConfidenceTransform is an option for functions such as SurvivalModelFit that specifies the transformation used for confidence intervals and bands." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfidenceTransform)))
(def Confirm "Confirm[expr] confirms that expr is not considered a failure, otherwise throwing an error to the nearest surrounding Enclose. \nConfirm[expr, info] evaluates info and includes its value in the thrown error if expr is not confirmed.\nConfirm[expr, info, tag] uses the specified tag for any thrown errors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Confirm)))
(def ConfirmAssert "ConfirmAssert[test] confirms that test is True, otherwise throwing an error to the nearest surrounding Enclose.\nConfirmAssert[test, info] evaluates info and includes its value in the thrown error if test is not True.\nConfirmAssert[test, info, tag] uses the specified tag for any thrown errors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfirmAssert)))
(def ConfirmBy "ConfirmBy[expr, f] confirms that f[expr] returns True, otherwise throwing an error to the nearest surrounding Enclose.\nConfirmBy[expr, f, info] evaluates info and includes its value in the thrown error if expr is not confirmed.\nConfirmBy[expr, f, info, tag] uses the specified tag for any thrown errors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfirmBy)))
(def ConfirmMatch "ConfirmMatch[expr, form] confirms that expr matches the pattern form, otherwise throwing an error to the nearest surrounding Enclose.\nConfirmMatch[expr, form, info] evaluates info and includes its value in the thrown error if expr is not confirmed.\nConfirmMatch[expr, form, info, tag] uses the specified tag for any thrown errors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfirmMatch)))
(def ConfirmQuiet "ConfirmQuiet[expr] confirms that no messages are generated during the evaluation of expr, otherwise quieting them and throwing an error to the nearest surrounding Enclose.\nConfirmQuiet[expr, s::t] tests only for the specified message.\nConfirmQuiet[expr, {s1::t1, s2::t2, …}] tests only for the specified list of messages.\nConfirmQuiet[expr, \"group\"] tests only for messages in the named message group.\nConfirmQuiet[expr, mspec, info] evaluates info and includes its value in the thrown error if expr is not confirmed.\nConfirmQuiet[expr, mspec, info, tag] uses the specified tag for any thrown errors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConfirmQuiet)))
(def ConformAudio "ConformAudio[{audio1, audio2, …}] returns a list of audio objects where all audioi are made to have conforming properties, including duration, data type, and number of channels.\nConformAudio[{audio1, audio2, …}, spec] returns all audio objects of the specified spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConformAudio)))
(def ConformDates "ConformDates[dates] returns a list of dates where all dates are made to have conforming properties, including calendar, time zone and granularity.\nConformDates[dates, rdate] returns all dates in a form consistent with the reference date rdate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConformDates)))
(def ConformImages "ConformImages[{image1, image2, …}] returns a list of images where all imagei are made to have conforming properties, including dimensions, data type, color space, and interleaving.\nConformImages[{image1, image2, …}, spec] returns all images of the specified spec.\nConformImages[{image1, image2, …}, spec, fitting] resizes images using the specified fitting method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConformImages)))
(def ConformationMethod "ConformationMethod is an option for VideoJoin and others that specifies how to conform frames of different videos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConformationMethod)))
(def Congruent "Congruent[x, y, …] displays as x≡y≡…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Congruent)))
(def ConicGradientFilling "ConicGradientFilling[{col1, col2, …, coln}] is a two-dimensional graphics directive specifying that faces of polygons and other filled graphics objects are to be drawn using a progressive transition between colors coli along a circle.\nConicGradientFilling[{θ1, θ2, …, θn}{col1, col2, …, coln}] uses the colors coli at angles θi.\nConicGradientFilling[{θ1, θ2, …, θn}{col1, col2, …, coln}, {x, y}] rotates from the center point {x, y}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConicGradientFilling)))
(def ConicHullRegion "ConicHullRegion[{p1, …, p m+1}] represents the m-dimensional affine hull region passing through points pi. \nConicHullRegion[p, {v1, …, vm}] represents the m-dimensional affine hull region passing through the point p and parallel to vi. \nConicHullRegion[{p1, …, p m+1}, {w1, …, wn}] represents the m-dimensional affine hull plus the conic hull generated by the vectors wj.\nConicHullRegion[p, {v1, …, vm}, {w1, …, wn}] represents the m-dimensional affine hull plus the conic hull generated by the vectors wj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConicHullRegion)))
(def ConicOptimization "ConicOptimization[f, cons, vars] finds values of variables vars that minimize the linear objective f subject to conic constraints cons.\nConicOptimization[…, \"prop\"] specifies what solution property \"prop\" should be returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConicOptimization)))
(def Conjugate "Conjugate[z] or z gives the complex conjugate of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Conjugate)))
(def ConjugateTranspose "ConjugateTranspose[m] or m^ gives the conjugate transpose of m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConjugateTranspose)))
(def Conjunction "Conjunction[expr, {a1, a2, …}] gives the conjunction of expr over all choices of the Boolean variables ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Conjunction)))
(def ConnectLibraryCallbackFunction "ConnectLibraryCallbackFunction[mname, cf] connects a CompiledFunction cf with the library callback manager with name mname." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectLibraryCallbackFunction)))
(def ConnectSystemModelComponents "ConnectSystemModelComponents[{\"c1 \"∈comp1, …}, {\"c1.a\"->\"c2.b\", …}] creates a system model by connecting connector \"a\" of component \"c1\" with connector \"b\" of component \"c2\" etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectSystemModelComponents)))
(def ConnectSystemModelController "ConnectSystemModelController[model, controller] connects the system model model with a controller according to the controller data controller." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectSystemModelController)))
(def ConnectedComponents "ConnectedComponents[g] gives the connected components of the graph g.\nConnectedComponents[g, {v1, v2, …}] gives the connected components that include at least one of the vertices v1, v2, … .\nConnectedComponents[g, patt] gives the connected components that include a vertex that matches the pattern patt.\nConnectedComponents[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedComponents)))
(def ConnectedGraphComponents "ConnectedGraphComponents[g] gives the connected components of the graph g.\nConnectedGraphComponents[g, {v1, v2, …}] gives the connected components that include at least one of the vertices v1, v2, … .\nConnectedGraphComponents[g, patt] gives the connected components that include a vertex that matches the pattern patt.\nConnectedGraphComponents[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedGraphComponents)))
(def ConnectedGraphQ "ConnectedGraphQ[g] yields True if the graph g is connected, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedGraphQ)))
(def ConnectedMeshComponents "ConnectedMeshComponents[mr] gives a list {c1, c2, …} of disjoint path connected meshed regions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedMeshComponents)))
(def ConnectedMoleculeComponents "ConnectedMoleculeComponents[mol] gives the connected components of the molecule mol." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedMoleculeComponents)))
(def ConnectedMoleculeQ "ConnectedMoleculeQ[mol] returns True if the atoms in mol form are connected by bonds, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectedMoleculeQ)))
(def ConnectionSettings "ConnectionSettings is an option for URLRead and related functions to specify advanced connection settings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnectionSettings)))
(def ConnesWindow "ConnesWindow[x] represents a Connes window function of x.\nConnesWindow[x, α] uses the parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConnesWindow)))
(def ConoverTest "ConoverTest[{data1, data2, …}] tests whether the variances of data1, data2, … are equal.\nConoverTest[dspec, σ_0^2] tests a dispersion measure against σ_0^2.\nConoverTest[dspec, σ_0^2, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConoverTest)))
(def ConservativeConvectionPDETerm "ConservativeConvectionPDETerm[vars, α] represents a conservative convection term ∇{x1, …, xn}·(-α u) with conservative convection coefficient α and model variables vars.\nConservativeConvectionPDETerm[vars, α, pars] uses model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConservativeConvectionPDETerm)))
(def Constant "Constant is an attribute that indicates zero derivative of a symbol with respect to all parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Constant)))
(def ConstantArray "ConstantArray[c, n] generates a list of n copies of the element c.\nConstantArray[c, {n1, n2, …}] generates an n1n2… array of nested lists containing copies of the element c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConstantArray)))
(def ConstantImage "ConstantImage[val, size] gives an image of the specified size with constant pixel values of val.\nConstantImage[val, size, \"type\"] gives an image converted to the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConstantImage)))
(def ConstantRegionQ "ConstantRegionQ[reg] gives True if the reg is a constant region and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConstantRegionQ)))
(def ConstantVideo "ConstantVideo[image] generates a one-second video with a constant frame image.\nConstantVideo[image, dur] generates a video for the duration dur." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConstantVideo)))
(def Constants "Constants is an option for Dt which gives a list of objects to be taken as constants." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Constants)))
(def ConstellationData "ConstellationData[entity, property] gives the value of the specified property for the constellation entity.\nConstellationData[{entity1, entity2, …}, property] gives a list of property values for the specified constellation entities.\nConstellationData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConstellationData)))
(def Construct "Construct[f, x] gives f[x].\nConstruct[f, x1, …, xn] gives f[x1, …, xn]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Construct)))
(def Containing "Containing[\"outer\", \"inner\"] represents an object of type outer containing objects of type inner." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Containing)))
(def ContainsAll "ContainsAll[list1, list2] yields True if list1 contains all of the elements of list2.\nContainsAll[list2] is an operator form that yields True when the object to which it is applied contains all of the elements of list2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContainsAll)))
(def ContainsAny "ContainsAny[list1, list2] yields True if list1 contains any of the elements of list2.\nContainsAny[list2] is an operator form that yields True when the object to which it is applied contains any of the elements in list2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContainsAny)))
(def ContainsExactly "ContainsExactly[list1, list2] yields True if list1 contains exactly the same elements as list2.\nContainsExactly[list2] is an operator form that yields True when the object to which it is applied contains exactly the same elements as list2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContainsExactly)))
(def ContainsNone "ContainsNone[list1, list2] yields True if list1 contains none of the elements in list2.\nContainsNone[list2] is an operator form that yields True when the object to which it is applied contains none of the elements of list2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContainsNone)))
(def ContainsOnly "ContainsOnly[list1, list2] yields True if list1 contains only elements that appear in list2.\nContainsOnly[list2] is an operator form that yields True when the object to which it is applied contains only elements that appear in list2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContainsOnly)))
(def ContentDetectorFunction "ContentDetectorFunction[…] represents a function generated by TrainImageContentDetector or TrainTextContentDetector that localizes and classifies contents in a piece of text or an image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentDetectorFunction)))
(def ContentFieldOptions "ContentFieldOptions is an option for CreateSearchIndex and related functions that allows options to be specified for handling different fields in content that is being indexed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentFieldOptions)))
(def ContentLocationFunction "ContentLocationFunction is an option to CreateSearchIndex and related functions that specifies how to determine locations to be used for hyperlinks and related constructs in the resulting index." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentLocationFunction)))
(def ContentObject "ContentObject[\"string\"] gives a content object whose content is string.\nContentObject[File[…]] gives a content object whose content is stored in the specified file.\nContentObject[name1val1, name2val2, …] gives a content object with a sequence of fields with names namei and values vali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentObject)))
(def ContentPadding "ContentPadding is an option for objects that can be displayed with frames that specifies whether the vertical margins should shrink wrap tightly around the contents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentPadding)))
(def ContentSelectable "ContentSelectable is an option to constructs such as Inset, Graphics, and GraphicsGroup that specifies whether and how content within them should be selectable." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentSelectable)))
(def ContentSize "ContentSize is an option for Manipulate and other functions that specifies the size of the content area to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContentSize)))
(def Context "Context[] gives the current context. \nContext[symbol] gives the context in which a symbol appears. \nContext[\"symbol\"] gives the context in which the symbol named \"symbol\" appears if it exists." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Context)))
(def ContextToFileName "ContextToFileName[\"context\"] gives the string specifying the file name that is by convention associated with a particular context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContextToFileName)))
(def Contexts "Contexts[] gives a list of all contexts. \nContexts[\"string\"] gives a list of the contexts that match the string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Contexts)))
(def Continue "Continue[] goes to the next iteration of the nearest enclosing Do, For, Until or While in a procedural program." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Continue)))
(def ContinuedFraction "ContinuedFraction[x, n] generates a list of the first n terms in the continued fraction representation of x. \nContinuedFraction[x] generates a list of all terms that can be obtained given the precision of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuedFraction)))
(def ContinuedFractionK "ContinuedFractionK[f, g, {i, imin, imax}] represents the continued fraction Κ _i=imin^imaxf/g.\nContinuedFractionK[g, {i, imin, imax}] represents the continued fraction Κ _i=imin^imax1/g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuedFractionK)))
(def ContinuousAction "ContinuousAction is an option for Manipulate, Slider, and related functions that specifies whether action should be taken continuously while controls are being moved." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousAction)))
(def ContinuousMarkovProcess "ContinuousMarkovProcess[i0, q] represents a continuous-time finite-state Markov process with transition rate matrix q and initial state i0.\nContinuousMarkovProcess[p0, q] represents a Markov process with initial state probability vector p0.\nContinuousMarkovProcess[…, m, μ] represents a Markov process with transition matrix m and transition rates μ.\nContinuousMarkovProcess[…, g] represents a Markov process transition rate matrix from the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousMarkovProcess)))
(def ContinuousTask "ContinuousTask[expr] represents a task in which expr is continuously reevaluated.\nContinuousTask[expr, end] represents a task in which expr is continuously reevaluated until the time specified by end.\nContinuousTask[expr, tspan] represents a task in which expr is continuously reevaluated over the time span tspan." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousTask)))
(def ContinuousTimeModelQ "ContinuousTimeModelQ[lsys] gives True if lsys is a continuous-time systems model, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousTimeModelQ)))
(def ContinuousWaveletData "ContinuousWaveletData[{{oct1, voc1}->coef1, …}, wave] yields a continuous wavelet data object with wavelet coefficients coefi corresponding to octave and voice {octi, voci} and wavelet wave." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousWaveletData)))
(def ContinuousWaveletTransform "ContinuousWaveletTransform[{x1, x2, …}] gives the continuous wavelet transform of a list of values xi.\nContinuousWaveletTransform[data, wave] gives the continuous wavelet transform using the wavelet wave.\nContinuousWaveletTransform[data, wave, {noct, nvoc}] gives the continuous wavelet transform using noct octaves with nvoc voices per octave.\nContinuousWaveletTransform[sound, …] gives the continuous wavelet transform of sampled sound." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContinuousWaveletTransform)))
(def ContourDetect "ContourDetect[image] gives a binary image in which white pixels correspond to the zeros and zero crossings in image.\nContourDetect[image, delta] treats values in image that are smaller in absolute value than delta as zero.\nContourDetect[array, …] gives a binary sparse array in which 1 corresponds to zeros and zero crossings in array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourDetect)))
(def ContourIntegrate "ContourIntegrate[f, z∈cont] gives the integral of f along the contour defined by cont in the complex plane." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourIntegrate)))
(def ContourLabels "ContourLabels is an option for contour plots that specifies how to label contours." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourLabels)))
(def ContourPlot "ContourPlot[f, {x, xmin, xmax}, {y, ymin, ymax}] generates a contour plot of f as a function of x and y. \nContourPlot[f==g, {x, xmin, xmax}, {y, ymin, ymax}] plots contour lines for which f=g. \nContourPlot[{f1==g1, f2==g2, …}, {x, xmin, xmax}, {y, ymin, ymax}] plots several contour lines. \nContourPlot[…, {x, y}∈reg] takes the variables {x, y} to be in the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourPlot)))
(def ContourPlot3D "ContourPlot3D[f, {x, xmin, xmax}, {y, ymin, ymax}, {z, zmin, zmax}] produces a three-dimensional contour plot of f as a function of x, y, and z. \nContourPlot3D[f==g, {x, xmin, xmax}, {y, ymin, ymax}, {z, zmin, zmax}] plots the contour surface for which f=g. \nContourPlot3D[…, {x, y, z}∈reg] takes the variables {x, y, z} to be in the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourPlot3D)))
(def ContourShading "ContourShading is an option for contour plots that specifies how the regions between contour lines should be shaded." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourShading)))
(def ContourStyle "ContourStyle is an option for contour plots that specifies the style in which contour lines or surfaces should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContourStyle)))
(def Contours "Contours is an option for contour plots that specifies the contours to draw." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Contours)))
(def ContraharmonicMean "ContraharmonicMean[list] gives the contraharmonic mean of the values in list.\nContraharmonicMean[list, p] gives the order p Lehmer contraharmonic mean." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContraharmonicMean)))
(def ContrastiveLossLayer "ContrastiveLossLayer[] represents a loss layer that computes a loss based on a distance metric and a target that specifies whether the distance should be minimized or maximized.\nContrastiveLossLayer[margin] specifies a distance above which the loss is zero for True targets." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ContrastiveLossLayer)))
(def Control "Control[{u, dom}] represents an interactive control for the variable u in the domain dom, with the type of control chosen to be appropriate for the domain specified.\nControl[{{u, uinit}, dom}] represents a control with initial value uinit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Control)))
(def ControlActive "ControlActive[act, norm] evaluates to act if a control that affects act is actively being used, and to norm otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControlActive)))
(def ControlPlacement "ControlPlacement is an option for Manipulate, TabView, and other control objects that specifies where controls should be placed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControlPlacement)))
(def ControlType "ControlType is an option for Manipulate and related functions that specifies what type of controls should be displayed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControlType)))
(def ControllabilityGramian "ControllabilityGramian[ssm] gives the controllability Gramian of the state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllabilityGramian)))
(def ControllabilityMatrix "ControllabilityMatrix[ssm] gives the controllability matrix of the state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllabilityMatrix)))
(def ControllableDecomposition "ControllableDecomposition[sys] yields the controllable subsystem of the state-space model sys.\nControllableDecomposition[sys, {z1, …}] specifies the new state variables zi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllableDecomposition)))
(def ControllableModelQ "ControllableModelQ[sys] yields True if the state-space model sys is controllable, and False otherwise.\nControllableModelQ[{sys, sub}] yields True if the subsystem sub is controllable." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllableModelQ)))
(def ControllerInformation "ControllerInformation[] gives dynamically updated information on currently connected controller devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerInformation)))
(def ControllerLinking "ControllerLinking is an option for Manipulate, Graphics3D, Plot3D, and related functions that specifies whether to allow interactive control by external controllers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerLinking)))
(def ControllerManipulate "ControllerManipulate[expr, {u, umin, umax}] generates a version of expr set up to allow interactive manipulation of the value of u using an external controller device.\nControllerManipulate[expr, {u, umin, umax, du}] allows the value of u to vary between umin and umax in steps du. \nControllerManipulate[expr, {{u, uinit}, umin, umax, …}] takes the initial value of u to be uinit. \nControllerManipulate[expr, {u, {u1, u2, …}}] allows u to take on discrete values u1, u2, …. \nControllerManipulate[expr, {u, …}, {v, …}, …] allows each of the u, v, … to be manipulated by the external controller device. \nControllerManipulate[expr, cu{u, …}, cv{v, …}, …] links the parameters to the specified controllers on the external controller device." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerManipulate)))
(def ControllerMethod "ControllerMethod is an option for Manipulate, Graphics3D, Plot3D, and related functions that specifies the default way that controls on an external controller device should apply." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerMethod)))
(def ControllerPath "ControllerPath is an option that gives a list of external controllers or classes of controllers to try for functions such as ControllerState, Manipulate, and Graphics3D." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerPath)))
(def ControllerState "ControllerState[\"c\"] gives the state of the control c for the first connected controller device on which it is supported.\nControllerState[{\"c1\", \"c2\", …}] gives the states of several controls.\nControllerState[id, \"c\"] gives the state of control c for controller devices with the specified identifier.\nControllerState[id, {\"c1\", \"c2\", …}] gives the states of several controls for several controller devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControllerState)))
(def ControlsRendering "ControlsRendering is a Style option that specifies how controls should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ControlsRendering)))
(def ConvectionPDETerm "ConvectionPDETerm[vars, β] represents a convection term β·∇{x1, …, xn}u with convection coefficient β and model variables vars.\nConvectionPDETerm[vars, β, pars] uses model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvectionPDETerm)))
(def Convergents "Convergents[list] gives a list of the convergents corresponding to the continued fraction terms list.\nConvergents[x, n] gives the first n convergents for a number x.\nConvergents[x] gives if possible all convergents leading to the number x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Convergents)))
(def ConversionRules "ConversionRules is an option for Cell that can be set to a list of rules specifying how the contents of the cell are to be converted to external formats." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConversionRules)))
(def ConvexHullMesh "ConvexHullMesh[{p1, p2, …}] gives a BoundaryMeshRegion representing the convex hull from the points p1, p2, ….\nConvexHullMesh[mreg] gives the convex hull of the mesh region mreg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexHullMesh)))
(def ConvexHullRegion "ConvexHullRegion[{p1, p2, …}] gives the convex hull from the points p1, p2, ….\nConvexHullRegion[reg] gives the convex hull of the region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexHullRegion)))
(def ConvexOptimization "ConvexOptimization[f, cons, vars] finds values of variables vars that minimize the convex objective function f subject to convex constraints cons.\nConvexOptimization[…, \"prop\"] specifies what solution property \"prop\" should be returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexOptimization)))
(def ConvexPolygonQ "ConvexPolygonQ[poly] gives True if the polygon poly is convex, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexPolygonQ)))
(def ConvexPolyhedronQ "ConvexPolyhedronQ[poly] gives True if the polyhedron poly is convex, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexPolyhedronQ)))
(def ConvexRegionQ "ConvexRegionQ[reg] gives True if reg is a convex region and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvexRegionQ)))
(def ConvolutionLayer "ConvolutionLayer[n, s] represents a trainable convolutional net layer having n output channels and using kernels of size s to compute the convolution.\nConvolutionLayer[n, {s}] represents a layer performing one-dimensional convolutions with kernels of size s.\nConvolutionLayer[n, {h, w}] represents a layer performing two-dimensional convolutions with kernels of size h×w.\nConvolutionLayer[n, {h, w, d}] represents a three-dimensional convolutions with kernels of size h×w×d.\nConvolutionLayer[n, kernel, opts] includes options for padding and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConvolutionLayer)))
(def Convolve "Convolve[f, g, x, y] gives the convolution with respect to x of the expressions f and g.\nConvolve[f, g, {x1, x2, …}, {y1, y2, …}] gives the multidimensional convolution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Convolve)))
(def ConwayGroupCo1 "ConwayGroupCo1[] represents the sporadic simple Conway group Co1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConwayGroupCo1)))
(def ConwayGroupCo2 "ConwayGroupCo2[] represents the sporadic simple Conway group Co2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConwayGroupCo2)))
(def ConwayGroupCo3 "ConwayGroupCo3[] represents the sporadic simple Conway group Co3." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ConwayGroupCo3)))
(def CookieFunction "CookieFunction is an option for URLRead, HTTPRequest, and related functions that gives a function to apply to each cookie received when an HTTP response is received." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CookieFunction)))
(def CoordinateBoundingBox "CoordinateBoundingBox[coords] gives the corners {{xmin, ymin, …}, {xmax, ymax, …}} of the bounding box of the region defined by coords.\nCoordinateBoundingBox[coords, δ] pads the region by δ in each direction.\nCoordinateBoundingBox[coords, Scaled[s]] pads by the scaled amount s in each direction.\nCoordinateBoundingBox[coords, {p1, p2, …}] pads by p1, p2, … in successive dimensions. \nCoordinateBoundingBox[coords, {{p 1min, p 1max}, {p 2min, p 2max}, …}] gives {{xmin-p 1min, ymin-p 2min, …}, {xmax+p 1max, ymax+p 2max, …}, …}" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateBoundingBox)))
(def CoordinateBoundingBoxArray "CoordinateBoundingBoxArray[{{xmin, ymin, …}, {xmax, ymax, …}}] generates an array of {x, y, …} coordinates with integer steps in each dimension.\nCoordinateBoundingBoxArray[{min, max}, d] uses step d in each dimension.\nCoordinateBoundingBoxArray[{min, max}, {dx, dy, …}] uses steps dx, dy, … in successive dimensions.\nCoordinateBoundingBoxArray[{min, max}, Into[n]] divides into n equal steps in each dimension.\nCoordinateBoundingBoxArray[{min, max}, steps, offsets] specifies offsets to use for each coordinate point.\nCoordinateBoundingBoxArray[{min, max}, steps, offsets, k] expands the array by k elements in every direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateBoundingBoxArray)))
(def CoordinateBounds "CoordinateBounds[coords] gives a list {{xmin, xmax}, {ymin, ymax}, …} of the bounds in each dimension of the region defined by coords. \nCoordinateBounds[coords, δ] pads the ranges of coordinates by ±δ in each dimension.\nCoordinateBounds[coords, Scaled[s]] pads by the scaled amount s in each dimension.\nCoordinateBounds[coords, {p1, p2, …}] pads by p1, p2, … in successive dimensions.\nCoordinateBounds[coords, {{p 1min, p 1max}, {p 2min, p 2max}, …}] gives {{xmin-p 1min, xmax+p 1max}, {ymin-p 2min, ymax+p 2max}, …}" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateBounds)))
(def CoordinateBoundsArray "CoordinateBoundsArray[{{xmin, xmax}, {ymin, ymax}, …}] generates an array of {x, y, …} coordinates with integer steps in each dimension.\nCoordinateBoundsArray[{xrange, yrange, …}, d] uses step d in each dimension.\nCoordinateBoundsArray[{xrange, yrange, …}, {dx, dy, …}] uses steps dx, dy, … in successive dimensions.\nCoordinateBoundsArray[{xrange, yrange, …}, Into[n]] divides into n equal steps in each dimension.\nCoordinateBoundsArray[{xrange, yrange, …}, steps, offsets] specifies offsets to use for each coordinate point.\nCoordinateBoundsArray[{xrange, yrange, …}, steps, offsets, k] expands the array by k elements in every direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateBoundsArray)))
(def CoordinateChartData "CoordinateChartData[chart, property] gives the value of the specified property for chart.\nCoordinateChartData[chart, property, {x1, x2, …, xn}] gives the value of the specified property for chart evaluated at the point {x1, x2, …, xn}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateChartData)))
(def CoordinateTransform "CoordinateTransform[t, pt] performs the coordinate transformation t on the point pt.\nCoordinateTransform[t, {pt1, pt2, …}] transforms several points." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateTransform)))
(def CoordinateTransformData "CoordinateTransformData[t, property] gives the value of the specified property for the coordinate transformation t.\nCoordinateTransformData[t, property, {x1, x2, …, xn}] gives the value of the property evaluated at the point {x1, x2, …, xn}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinateTransformData)))
(def CoordinatesToolOptions "CoordinatesToolOptions is an option for Graphics that gives values of options associated with the Get Coordinates tool." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoordinatesToolOptions)))
(def CoplanarPoints "CoplanarPoints[{p1, p2, p3, p4, …, pn}] tests whether the points p1, p2, p3, p4, …, pn are coplanar." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoplanarPoints)))
(def CoprimeQ "CoprimeQ[n1, n2] yields True if n1 and n2 are relatively prime, and yields False otherwise. \nCoprimeQ[n1, n2, …] yields True if all pairs of the ni are relatively prime, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoprimeQ)))
(def Coproduct "Coproduct[x, y, …] displays as x∐y∐…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Coproduct)))
(def CopulaDistribution "CopulaDistribution[ker, {dist1, dist2, …}] represents a copula distribution with kernel distribution ker and marginal distributions dist1, dist2, … ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopulaDistribution)))
(def CopyDatabin "CopyDatabin[bin] creates a copy of a databin.\nCopyDatabin[bin, options] creates a copy with the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopyDatabin)))
(def CopyDirectory "CopyDirectory[dir1, dir2] copies the directory dir1 to dir2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopyDirectory)))
(def CopyFile "CopyFile[file1, file2] copies from the local, remote or cloud file file1 to the local, remote or cloud file file2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopyFile)))
(def CopyFunction "CopyFunction is an option for TemplateBox that specifies how the box is to be copied." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopyFunction)))
(def CopyToClipboard "CopyToClipboard[expr] replaces the contents of the clipboard with expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CopyToClipboard)))
(def Copyable "Copyable is an option for Cell that specifies whether a cell can be copied interactively using the front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Copyable)))
(def CoreNilpotentDecomposition "CoreNilpotentDecomposition[m] yields the core-nilpotent decomposition of a square matrix m.\nCoreNilpotentDecomposition[m, format] returns the core-nilpotent decomposition according to the specified format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoreNilpotentDecomposition)))
(def CornerFilter "CornerFilter[image] computes a measure for the presence of a corner for each pixel in image and returns the result as an intensity image.\nCornerFilter[image, r] detects corners at a pixel range r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CornerFilter)))
(def CornerNeighbors "CornerNeighbors is an option for various array and image processing functions that specifies whether diagonally adjacent corners should be considered neighbors of particular elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CornerNeighbors)))
(def Correlation "Correlation[v, w] gives the correlation between the vectors v and w.\nCorrelation[a, b] gives the cross-correlation matrix for the matrices a and b.\nCorrelation[a] gives the auto-correlation matrix for observations in matrix a.\nCorrelation[dist] gives the correlation matrix for the multivariate symbolic distribution dist.\nCorrelation[dist, i, j] gives the (i, j)^th correlation for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Correlation)))
(def CorrelationDistance "CorrelationDistance[u, v] gives the correlation coefficient distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CorrelationDistance)))
(def CorrelationFunction "CorrelationFunction[data, hspec] estimates the correlation function at lags hspec from data.\nCorrelationFunction[proc, hspec] represents the correlation function at lags hspec for the random process proc. \nCorrelationFunction[proc, s, t] represents the correlation function at times s and t for the random process proc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CorrelationFunction)))
(def CorrelationTest "CorrelationTest[{{x1, y1}, {x2, y2}, …}] tests whether the correlation coefficient for a bivariate population is zero.\nCorrelationTest[{{x1, y1}, {x2, y2}, …}, ρ0] tests whether the correlation coefficient is ρ0.\nCorrelationTest[{{x1, y1}, {x2, y2}, …}, {{u1, v1}, {u2, v2}, …}] tests whether the correlation coefficients for two populations are equal.\nCorrelationTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CorrelationTest)))
(def Cos "Cos[z] gives the cosine of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cos)))
(def CosDegrees "CosDegrees[θ] gives the cosine of θ degrees." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CosDegrees)))
(def CosIntegral "CosIntegral[z] gives the cosine integral function Ci (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CosIntegral)))
(def Cosh "Cosh[z] gives the hyperbolic cosine of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cosh)))
(def CoshIntegral "CoshIntegral[z] gives the hyperbolic cosine integral Chi (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoshIntegral)))
(def CosineDistance "CosineDistance[u, v] gives the angular cosine distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CosineDistance)))
(def CosineWindow "CosineWindow[x] represents a cosine window function of x.\nCosineWindow[x, α] uses the exponent α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CosineWindow)))
(def Cot "Cot[z] gives the cotangent of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cot)))
(def CotDegrees "CotDegrees[θ] gives the cotangent of θ degrees." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CotDegrees)))
(def Coth "Coth[z] gives the hyperbolic cotangent of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Coth)))
(def CoulombF "CoulombF[l, η, r] gives the regular Coulomb wavefunction Fl (η, r)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoulombF)))
(def CoulombG "CoulombG[l, η, r] gives the irregular Coulomb wavefunction Gl (η, r)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoulombG)))
(def CoulombH1 "CoulombH1[l, η, r] gives the outgoing irregular Coulomb wavefunction H _l^(+)(η, r)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoulombH1)))
(def CoulombH2 "CoulombH2[l, η, r] gives the incoming irregular Coulomb wavefunction H _l^(-)(η, r)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoulombH2)))
(def Count "Count[list, pattern] gives the number of elements in list that match pattern. \nCount[expr, pattern, levelspec] gives the total number of subexpressions matching pattern that appear at the levels in expr specified by levelspec. \nCount[pattern] represents an operator form of Count that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Count)))
(def CountDistinct "CountDistinct[list] gives the number of distinct elements that appear in list.\nCountDistinct[list, test] applies test to pairs of elements to determine whether they should be considered equivalent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CountDistinct)))
(def CountDistinctBy "CountDistinctBy[{e1, e2, …}, f] gives the number of distinct values of f[ei] that occur.\nCountDistinctBy[f] represents an operator form of CountDistinctBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CountDistinctBy)))
(def CountRoots "CountRoots[f, x] gives the number of real roots of the univariate function f in x.\nCountRoots[f, {x, a, b}] gives the number of roots between a and b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CountRoots)))
(def CountryData "CountryData[\"tag\", property] gives the value of the specified property for the country, country-like entity, or group of countries specified by \"tag\".\nCountryData[\"tag\", {property, …, dates}] gives time series for certain economic and other properties." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CountryData)))
(def Counts "Counts[list] gives an association whose keys are the distinct elements of list, and whose values give the number of times those elements appear in list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Counts)))
(def CountsBy "CountsBy[{e1, e2, …}, f] gives an association whose keys are the distinct values of the f[ei], and whose values give the number of times these f[ei] values appear.\nCountsBy[f] represents an operator form of CountsBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CountsBy)))
(def Covariance "Covariance[v, w] gives the covariance between the vectors v and w.\nCovariance[a, b] gives the cross-covariance matrix for the matrices a and b.\nCovariance[a] gives the auto-covariance matrix for observations in matrix a.\nCovariance[dist] gives the auto-covariance matrix for the multivariate symbolic distribution dist.\nCovariance[dist, i, j] gives the (i, j)^th covariance for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Covariance)))
(def CovarianceEstimatorFunction "CovarianceEstimatorFunction is an option for generalized linear model fitting functions that specifies the estimator for the parameter covariance matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CovarianceEstimatorFunction)))
(def CovarianceFunction "CovarianceFunction[data, hspec] estimates the covariance function at lags hspec from data.\nCovarianceFunction[proc, hspec] represents the covariance function at lags hspec for the random process proc. \nCovarianceFunction[proc, s, t] represents the covariance function at times s and t for the random process proc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CovarianceFunction)))
(def CoxIngersollRossProcess "CoxIngersollRossProcess[μ, σ, θ, x0] represents a Cox–Ingersoll–Ross process with long‐term mean μ, volatility σ, speed of adjustment θ, and initial condition x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoxIngersollRossProcess)))
(def CoxModel "CoxModel[…] represents the symbolic proportional hazards model obtained from CoxModelFit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoxModel)))
(def CoxModelFit "CoxModelFit[{e1, …, en}] constructs a model of the baseline hazard h0(t) for events times ei.\nCoxModelFit[{{{ξ11, …, ξ 1p}, …, {ξ n 1, …, ξnp}}, {e1, …, en}}, {f1, …, fm}, {x1, …, xp}] constructs a Cox model of the form h0(t) exp(β1 f1+…+βm fm), where the fi depend on the xk." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoxModelFit)))
(def CoxianDistribution "CoxianDistribution[{α1, …, α m-1}, {λ1, …, λm}] represent an m-phase Coxian distribution with phase probabilities αi and rates λi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CoxianDistribution)))
(def CramerVonMisesTest "CramerVonMisesTest[data] tests whether data is normally distributed using the Cramér–von Mises test.\nCramerVonMisesTest[data, dist] tests whether data is distributed according to dist using the Cramér–von Mises test.\nCramerVonMisesTest[data, dist, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CramerVonMisesTest)))
(def CreateArchive "CreateArchive[source] creates a compressed archive in the current directory from source.\nCreateArchive[source, path] creates a compressed archive in the directory or file specified by path." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateArchive)))
(def CreateCellID "CreateCellID is an option for Notebook that specifies whether to assign a CellID to cells created in the notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateCellID)))
(def CreateChannel "CreateChannel[] creates a new channel for channel communication, with a generated name.\nCreateChannel[\"path\"] creates a channel with the specified path relative to the home area of the currently authenticated user.\nCreateChannel[object] creates a channel based on the given ChannelObject specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateChannel)))
(def CreateCloudExpression "CreateCloudExpression[value] creates a new anonymous cloud expression that stores the specified initial value.\nCreateCloudExpression[value, \"name\"] creates a new cloud expression with the specified name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateCloudExpression)))
(def CreateCompilerEnvironment "CreateCompilerEnvironment[] creates a compiler environment that can be used in FunctionCompile and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateCompilerEnvironment)))
(def CreateDataStructure "CreateDataStructure[\"type\", arg1, arg2, …] creates a data structure with the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDataStructure)))
(def CreateDataSystemModel "CreateDataSystemModel[{v1, v2, …}] creates a SystemModel generating a signal of values vi. \nCreateDataSystemModel[{{t1, v1}, …}] creates a model for the time-value pairs {ti, vi}.\nCreateDataSystemModel[obj] creates a model for the TimeSeries or InterpolatingFunction obj. \nCreateDataSystemModel[fun, tmin, tmax] creates a model with samples from the function fun between tmin and tmax.\nCreateDataSystemModel[data, \"dspec\"] creates a model with data specification \"dspec\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDataSystemModel)))
(def CreateDatabin "CreateDatabin[] creates a databin in the Wolfram Data Drop and returns the corresponding Databin object.\nCreateDatabin[options] creates a databin with the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDatabin)))
(def CreateDialog "CreateDialog[expr] creates a dialog notebook containing expr and opens it in the front end.\nCreateDialog[expr, obj] replaces the notebook represented by the notebook object obj with the one obtained from expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDialog)))
(def CreateDirectory "CreateDirectory[\"dir\"] creates a directory with name dir. \nCreateDirectory[] creates a directory in the default area for temporary directories on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDirectory)))
(def CreateDocument "CreateDocument[] creates an empty document notebook and opens it in the front end.\nCreateDocument[expr] creates and opens a document notebook containing the expression expr.\nCreateDocument[{expr1, expr2, …}] creates and opens a document notebook consisting of a sequence of cells containing the expri.\nCreateDocument[expr, obj] replaces the notebook represented by the notebook object obj with the one obtained from expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateDocument)))
(def CreateFile "CreateFile[\"file\"] creates a file with name file. \nCreateFile[] creates a file in the default area for temporary files on your computer system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateFile)))
(def CreateForeignCallback "CreateForeignCallback[f, type] creates a foreign callback with the specified type that can be called from external libraries." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateForeignCallback)))
(def CreateIntermediateDirectories "CreateIntermediateDirectories is an option for CreateDirectory and related functions that specifies whether to create intermediate directories in a directory path specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateIntermediateDirectories)))
(def CreateLicenseEntitlement "CreateLicenseEntitlement[settings] creates an on-demand license entitlement using settings.\nCreateLicenseEntitlement[] creates an on-demand license entitlement using the default settings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateLicenseEntitlement)))
(def CreateManagedLibraryExpression "CreateManagedLibraryExpression[mname, f] creates a managed library expression by applying f to a positive integer ID associated with a registered manager with name mname." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateManagedLibraryExpression)))
(def CreateManagedObject "CreateManagedObject[expr, f] creates a managed object that evaluates f[expr] when it is no longer referenced." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateManagedObject)))
(def CreateNotebook "CreateNotebook[] creates a generic empty notebook and opens it in the front end.\nCreateNotebook[\"type\"] creates an empty notebook of the specified type and opens it in the front end.\nCreateNotebook[\"type\", obj] replaces the notebook represented by the notebook object obj by a version converted to be of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateNotebook)))
(def CreatePacletArchive "CreatePacletArchive[source] creates a paclet archive file from source.\nCreatePacletArchive[source, destdir] creates a paclet archive file from source and places it in destdir." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreatePacletArchive)))
(def CreatePalette "CreatePalette[expr] creates a palette notebook containing expr, and opens it in the front end.\nCreatePalette[{expr1, expr2, …}] creates and opens a palette notebook consisting of a sequence of cells containing the expri.\nCreatePalette[expr, obj] replaces the notebook represented by the notebook object obj with the one obtained from expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreatePalette)))
(def CreatePermissionsGroup "CreatePermissionsGroup[\"name\"] creates a permissions group with the specified name.\nCreatePermissionsGroup[\"name\", {user1, user2, …}] creates a permissions group consisting of the specified initial users." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreatePermissionsGroup)))
(def CreateSearchIndex "CreateSearchIndex[dir] creates a search index from all files in the directory dir and its subdirectories.\nCreateSearchIndex[{source1, source2, …}] creates a search index from all sources sourcei.\nCreateSearchIndex[sources, \"name\"] gives the search index the specified name.\nCreateSearchIndex[] creates an empty search index, which can be added to with AddToSearchIndex." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateSearchIndex)))
(def CreateSemanticSearchIndex "CreateSemanticSearchIndex[source] creates a search index from the data in source.\nCreateSemanticSearchIndex[source, \"name\"] gives the search index the specified name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateSemanticSearchIndex)))
(def CreateSystemModel "CreateSystemModel[sys] creates a Modelica SystemModel from the systems model sys. \nCreateSystemModel[eqns, t] creates a model for the system equations eqns with independent variable t.\nCreateSystemModel[…, tspec] creates a model with type specification tspec for variables and parameters.\nCreateSystemModel[…, spec] creates a model with spec for parameter values, initial values and model relations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateSystemModel)))
(def CreateTypeInstance "CreateTypeInstance[type, arg1, arg2, …] creates an instance of a type in compiled code.\nCreateTypeInstance[productType, field1x1, field2x2, …|>] creates an instance of a product type and initializes its fields." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateTypeInstance)))
(def CreateUUID "CreateUUID[] creates a random, universally unique UUID string.\nCreateUUID[\"base\"] appends a UUID string to the specified base string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateUUID)))
(def CreateVectorDatabase "CreateVectorDatabase[] creates a new empty vector database.\nCreateVectorDatabase[{vec1, …}] initializes the database with the collection of vectors veci.\nCreateVectorDatabase[{vec1, …}{val1, …}] associates the value vali to the vector veci.\nCreateVectorDatabase[data, name] gives the vector database the specified name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateVectorDatabase)))
(def CreateWindow "CreateWindow[] creates an empty window in the front end.\nCreateWindow[expr] creates a window displaying the notebook expression expr, and opens it in the front end.\nCreateWindow[expr, obj] replaces the notebook represented by the notebook object obj with the one obtained from expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CreateWindow)))
(def CriterionFunction "CriterionFunction is an option in functions such as ClusterClassify that specifies the criterion to use to select a method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CriterionFunction)))
(def CriticalSection "CriticalSection[var, expr] acquires the lock var for parallel computation, evaluates expr, then releases the lock var.\nCriticalSection[{var1, var2, …}, expr] locks all variables vari simultaneously." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CriticalSection)))
(def CriticalityFailureImportance "CriticalityFailureImportance[rdist, t] gives the criticality failure importances for all components in the ReliabilityDistribution rdist at time t.\nCriticalityFailureImportance[fdist, t] gives the criticality failure importances for all components in the FailureDistribution fdist at time t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CriticalityFailureImportance)))
(def CriticalitySuccessImportance "CriticalitySuccessImportance[rdist, t] gives the criticality success importances for all components in the ReliabilityDistribution rdist at time t.\nCriticalitySuccessImportance[fdist, t] gives the criticality success importances for all components in the FailureDistribution fdist at time t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CriticalitySuccessImportance)))
(def Cross "Cross[a, b] gives the vector cross product of a and b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cross)))
(def CrossEntropyLossLayer "CrossEntropyLossLayer[\"Index\"] represents a net layer that computes the cross-entropy loss by comparing input class probability vectors with indices representing the target class.\nCrossEntropyLossLayer[\"Probabilities\"] represents a net layer that computes the cross-entropy loss by comparing input class probability vectors with target class probability vectors.\nCrossEntropyLossLayer[\"Binary\"] represents a net layer that computes the binary cross-entropy loss by comparing input probability scalars with target probability scalars, where each probability represents a binary choice." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CrossEntropyLossLayer)))
(def CrossMatrix "CrossMatrix[r] gives a matrix whose elements are 1 in a centered cross-shaped region that extends r positions along each index direction, and are 0 otherwise.\nCrossMatrix[r, w] gives a w×w matrix containing a cross-shaped region of 1s.\nCrossMatrix[{r1, r2, …}, …] yields an array whose elements are 1 in a centered cross-shaped region that extends ri positions in the i ^th index direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CrossMatrix)))
(def CrossingCount "CrossingCount[contour, p] gives a count of the number of times a ray starting from the point p crosses the closed curve contour." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CrossingCount)))
(def CrossingDetect "CrossingDetect[image] gives a binary image in which white pixels correspond to the zero crossings in image.\nCrossingDetect[image, delta] treats values in image that are smaller in absolute value than delta as zero.\nCrossingDetect[array, …] gives a binary sparse array in which 1 corresponds to zero crossings in array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CrossingDetect)))
(def CrossingPolygon "CrossingPolygon[{p1, p2, …, pn}] gives a Polygon representing all points for which a ray from the point in any direction in the plane crosses the line segments {p1, p2}, …, {p n-1, pn}, {pn, p1} an odd number of times.\nCrossingPolygon[{{p11, p12, …}, {p21, p22, …}, …}] gives a Polygon from the line segments {p11, p12}, …, {p21, p22}, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CrossingPolygon)))
(def Csc "Csc[z] gives the cosecant of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Csc)))
(def CscDegrees "CscDegrees[θ] gives the cosecant of θ degrees." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CscDegrees)))
(def Csch "Csch[z] gives the hyperbolic cosecant of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Csch)))
(def Cube "Cube[] represents a regular cube centered at the origin with unit edge length.\nCube[l] represents a cube with edge length l.\nCube[{θ, ϕ}, …] represents a cube rotated by an angle θ with respect to the z axis and angle ϕ with respect to the y axis.\nCube[{x, y, z}, …] represents a cube centered at {x, y, z}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cube)))
(def CubeRoot "CubeRoot[x] gives the real-valued cube root of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CubeRoot)))
(def Cubics "Cubics is an option for functions that involve solving algebraic equations, that specifies whether explicit forms for solutions to cubic equations should be given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cubics)))
(def Cuboid "Cuboid[pmin] represents a unit hypercube with its lower corner at pmin.\nCuboid[pmin, pmax] represents an axis-aligned filled cuboid with lower corner pmin and upper corner pmax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cuboid)))
(def Cumulant "Cumulant[data, r] gives the r ^th cumulant κr of data.\nCumulant[data, {r1, …, rm} ] gives the multivariate cumulant of order {r1, …, rm} κ r1, …, rm of data.\nCumulant[dist, r] gives the r ^th cumulant of the distribution dist.\nCumulant[r] represents the r ^th formal cumulant." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cumulant)))
(def CumulantGeneratingFunction "CumulantGeneratingFunction[dist, t] gives the cumulant-generating function for the distribution dist as a function of the variable t. \nCumulantGeneratingFunction[dist, {t1, t2, …}] gives the cumulant-generating function for the multivariate distribution dist as a function of the variables t1, t2, … ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CumulantGeneratingFunction)))
(def CumulativeFeatureImpactPlot "CumulativeFeatureImpactPlot[model, data] plots the cumulative impact of the value of each feature in data on the result of model.\nCumulativeFeatureImpactPlot[model] estimates the feature impacts using synthetic data.\nCumulativeFeatureImpactPlot[modelfname, …] plots only the impact of the specified feature fname.\nCumulativeFeatureImpactPlot[modelfnameclass, …] plots only the impact on the classification class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CumulativeFeatureImpactPlot)))
(def Cup "Cup[x, y, …] displays as x⌣y⌣…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cup)))
(def CupCap "CupCap[x, y, …] displays as x≍y≍…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CupCap)))
(def Curl "Curl[{f1, f2}, {x1, x2}] gives the curl ∂f2/∂x1-∂f1/∂x2.\nCurl[{f1, f2, f3}, {x1, x2, x3}] gives the curl (∂f3/∂x2-∂f2/∂x3, ∂f1/∂x3-∂f3/∂x1, ∂f2/∂x1-∂f1/∂x2).\nCurl[f, {x1, …, xn}] gives the curl of the n×n×…×n array f with respect to the n -dimensional vector {x1, …, xn}.\nCurl[f, x, chart] gives the curl in the coordinates chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Curl)))
(def CurrencyConvert "CurrencyConvert[quantity, target] attempts to convert the specified currency quantity to the specified target currency.\nCurrencyConvert[quantity, target, date] converts to the target currency for the historical date specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrencyConvert)))
(def CurrentDate "CurrentDate[gran] gives the current date of the specified granularity type gran.\nCurrentDate[date, gran] gives the date of the given granularity that includes the specified date.\nCurrentDate[] gives the instant corresponding to the current date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrentDate)))
(def CurrentImage "CurrentImage[] returns the current image captured from a connected camera.\nCurrentImage[n] returns n sequential image frames as a list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrentImage)))
(def CurrentNotebookImage "CurrentNotebookImage[nb] returns an image captured from the portion of the notebook nb that appears on your screen.\nCurrentNotebookImage[] returns an image captured from the notebook in which the function is evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrentNotebookImage)))
(def CurrentScreenImage "CurrentScreenImage[] returns an image captured from all current display screens on your computer. \nCurrentScreenImage[n] returns an image captured from display screen n.\nCurrentScreenImage[{{xmin, ymin}, {xmax, ymax}}] returns the specified rectangle from the image of all current display screens." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrentScreenImage)))
(def CurrentValue "CurrentValue[item] gives the current value of item at a location in the Wolfram System and interface. \nCurrentValue[{item, spec}] gives the current value for the feature of item specified by spec.\nCurrentValue[obj, item] gives the current value of item associated with the object obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurrentValue)))
(def CurryApplied "CurryApplied[f, n] represents an operator form of the function f of n arguments so that CurryApplied[f, n][x1]…[xn] is equivalent to f[x1, …, xn].\nCurryApplied[n] represents an operator form of CurryApplied that can be applied to a function to represent an operator form with n arguments.\nCurryApplied[f, {i1, …, in}] represents an operator form of the function f of n arguments so that CurryApplied[f, {i1, …, in}][x1]…[xn] is equivalent to f[x i1, …, x in].\nCurryApplied[f, k{i1, …, in}] represents an operator form that takes k arguments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurryApplied)))
(def CurvatureFlowFilter "CurvatureFlowFilter[image] applies a mean curvature flow filter to image.\nCurvatureFlowFilter[image, t] specifies the amount of curvature flow time t to be applied.\nCurvatureFlowFilter[image, t, k] applies the curvature flow with a modified conductance term parametrized by k." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurvatureFlowFilter)))
(def CurveClosed "CurveClosed is an option for JoinedCurve that specifies whether individual curve components should be closed curves." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CurveClosed)))
(def Cyan "Cyan represents the color cyan in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cyan)))
(def CycleGraph "CycleGraph[n] gives the cycle graph with n vertices Cn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CycleGraph)))
(def CycleIndexPolynomial "CycleIndexPolynomial[perm, {x1, …, xn}] constructs the cycle index monomial of the permutation perm in the variables xi.\nCycleIndexPolynomial[group, {x1, …, xn}] constructs the cycle index polynomial of group in the variables xi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CycleIndexPolynomial)))
(def Cycles "Cycles[{cyc1, cyc2, …}] represents a permutation with disjoint cycles cyci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cycles)))
(def CyclicGroup "CyclicGroup[n] represents the cyclic group of degree n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CyclicGroup)))
(def Cyclotomic "Cyclotomic[n, x] gives the n ^th cyclotomic polynomial in x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cyclotomic)))
(def Cylinder "Cylinder[{{x1, y1, z1}, {x2, y2, z2}}, r] represents a cylinder of radius r around the line from (x1, y1, z1) to (x2, y2, z2). \nCylinder[{{x1, y1, z1}, {x2, y2, z2}}] represents a cylinder of radius 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Cylinder)))
(def CylindricalDecomposition "CylindricalDecomposition[expr, {x1, x2, …}] finds a decomposition of the region represented by the statement expr into cylindrical parts whose directions correspond to the successive xi. \nCylindricalDecomposition[expr, {x1, x2, …}, op] finds a decomposition of the result of applying the topological operation op to the region represented by the statement expr.\nCylindricalDecomposition[expr, {x1, x2, …}, \"Function\"] represents the result as CylindricalDecompositionFunction[…][x1, x2, …] that can be efficiently used in further computation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CylindricalDecomposition)))
(def CylindricalDecompositionFunction "CylindricalDecompositionFunction[data][x1, x2, …] represents a cylindrical algebraic formula in x1, x2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote CylindricalDecompositionFunction)))
(def D "D[f, x] gives the partial derivative ∂f/∂x. \nD[f, {x, n}] gives the multiple derivative ∂^nf/∂x^n.\nD[f, x, y, …] gives the partial derivative ⋯ (∂/∂y)(∂/∂x) f.\nD[f, {x, n}, {y, m}, …] gives the multiple partial derivative ⋯ (∂^m/∂y^m)(∂^n/∂x^n) f.\nD[f, {{x1, x2, …}}] for a scalar f gives the vector derivative (∂f/∂x1, ∂f/∂x2, …). \nD[f, {array}] gives an array derivative." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote D)))
(def DEigensystem "DEigensystem[ℒ[u[x, y, …]], u, {x, y, …}∈Ω, n] gives the n smallest magnitude eigenvalues and eigenfunctions for the linear differential operator ℒ over the region Ω.\nDEigensystem[eqns, u, t, {x, y, …}∈Ω, n] gives the eigenvalues and eigenfunctions for solutions u of the time-dependent differential equations eqns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DEigensystem)))
(def DEigenvalues "DEigenvalues[ℒ[u[x, y, …], u, {x, y, …}∈Ω, n] gives the n smallest magnitude eigenvalues for the linear differential operator ℒ over the region Ω.\nDEigenvalues[eqns, u, t, {x, y, …}∈Ω, n] gives the eigenvalues for solutions u of the time-dependent differential equations eqns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DEigenvalues)))
(def DFixedPoints "DFixedPoints[eqn, x[t], t] gives the fixed points for a differential equation.\nDFixedPoints[{eqn1, eqn2, …}, {x1[t], x2[t], …}, t] gives the fixed points for a system of differential equations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DFixedPoints)))
(def DGaussianWavelet "DGaussianWavelet[] represents a derivative of Gaussian wavelet of derivative order 2.\nDGaussianWavelet[n] represents a derivative of Gaussian wavelet of derivative order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DGaussianWavelet)))
(def DMSList "DMSList[θ] converts an angle θ given in decimal degrees to a DMS list {degree, minute, second}.\nDMSList[\"dms\"] converts a DMS string to a DMS list {degree, minute, second}.\nDMSList[\"latlon\"] converts a latitude-longitude string to a pair of DMS lists.\nDMSList[GeoPosition[…]] converts GeoPosition data to a pair or array of pairs of DMS lists." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DMSList)))
(def DMSString "DMSString[θ] converts an angle θ given in decimal degrees to a degrees-minutes-seconds string.\nDMSString[{ϕ, λ}] converts latitude and longitude given in decimal degrees to a DMS latitude-longitude string.\nDMSString[{d, m, s}] converts a DMS list to a DMS string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DMSString)))
(def DSolve "DSolve[eqn] solves a differential equation eqn.\nDSolve[eqn, u, x] solves a differential equation for the function u, with independent variable x. \nDSolve[eqn, u, {x, xmin, xmax}] solves a differential equation for x between xmin and xmax.\nDSolve[{eqn1, eqn2, …}, {u1, u2, …}, …] solves a list of differential equations. \nDSolve[eqn, u, {x1, x2, …}] solves a partial differential equation. \nDSolve[eqn, u, {x1, x2, …}∈Ω] solves the partial differential equation eqn over the region Ω." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DSolve)))
(def DSolveChangeVariables "DSolveChangeVariables[dsolve, u, t, trans] changes the solution function in dsolve to u(t) using the transformation trans.\nDSolveChangeVariables[dsolve, {u1, u2, …}, t, trans] changes the solution functions in the system to {u1(t), …, un(t)}.\nDSolveChangeVariables[dsolve, u, {t1, …, tn}, trans] changes the solution function in the partial differential equation to u (t1, …, tn)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DSolveChangeVariables)))
(def DSolveValue "DSolveValue[eqn, expr, x] gives the value of expr determined by a symbolic solution to the ordinary differential equation eqn with independent variable x. \nDSolveValue[eqn, expr, {x, xmin, xmax}] uses a symbolic solution for x between xmin and xmax.\nDSolveValue[{eqn1, eqn2, …}, expr, …] uses a symbolic solution for a list of differential equations. \nDSolveValue[eqn, expr, {x1, x2, …}] uses a solution for the partial differential equation eqn. \nDSolveValue[eqn, expr, {x1, x2, …}∈Ω] uses a solution of the partial differential equation eqn over the region Ω." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DSolveValue)))
(def DStabilityConditions "DStabilityConditions[eqn, x[t], t] gives the fixed points and stability conditions for a differential equation.\nDStabilityConditions[{eqn1, eqn2, …}, {x1[t], x2[t], …}, t] gives the fixed points and stability conditions for a system of differential equations.\nDStabilityConditions[{eqn1, eqn2, …}, {x1[t], x2[t], …}, t, {pnt1, pnt2, …}] gives the stability conditions for the given fixed points." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DStabilityConditions)))
(def DagumDistribution "DagumDistribution[p, a, b] represents a Dagum distribution with shape parameters p and a and scale parameter b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DagumDistribution)))
(def DamData "DamData[entity, property] gives the value of the specified property for the dam entity.\nDamData[{entity1, entity2, …}, property] gives a list of property values for the specified dam entities.\nDamData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DamData)))
(def DamerauLevenshteinDistance "DamerauLevenshteinDistance[u, v] gives the Damerau–Levenshtein distance between strings or vectors u and v.\nDamerauLevenshteinDistance[u, v] gives the Damerau–Levenshtein distance between strings, vectors or biomolecular sequences u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DamerauLevenshteinDistance)))
(def Darker "Darker[color] represents a darker version of the specified color. \nDarker[color, f] represents a version of the specified color darkened by a fraction f. \nDarker[image, …] gives a darker version of an image.\nDarker[video, …] gives a version of a video with darker frames." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Darker)))
(def Dashed "Dashed is a graphics directive specifying that lines that follow should be drawn dashed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dashed)))
(def Dashing "Dashing[{r1, r2, …}] is a two-dimensional graphics directive specifying that lines that follow are to be drawn dashed, with successive segments of lengths r1, r2, … (repeated cyclically). The ri are given as a fraction of the total width of the graph. \nDashing[r] is equivalent to Dashing[{r, r}].\nDashing[{r1, r2, …}, offset] offsets the dashes by offset.\nDashing[{r1, r2, …}, offset, capform] sets the CapForm for individual dashes to capform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dashing)))
(def DataDistribution "DataDistribution[ddist, …] represents a probability distribution of type ddist, estimated from a set of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DataDistribution)))
(def DataRange "DataRange is an option for functions such as ListPlot and ListDensityPlot that specifies what range of actual coordinates the data should be assumed to occupy." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DataRange)))
(def DataReversed "DataReversed is an option for ArrayPlot and related functions that specifies whether data should be plotted in reverse order." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DataReversed)))
(def DataStructure "DataStructure[\"type\", data] represents a data structure." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DataStructure)))
(def DataStructureQ "DataStructureQ[ds] yields True if ds is a valid data structure and False otherwise.\nDataStructureQ[ds, type] yields True if ds is a valid data structure of the specified type and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DataStructureQ)))
(def DatabaseConnect "DatabaseConnect[db] activates a connection to the database db." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabaseConnect)))
(def DatabaseDisconnect "DatabaseDisconnect[db] deactivates a connection to the database db." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabaseDisconnect)))
(def DatabaseReference "DatabaseReference[File[\"filename\"]] represents a reference to a local file-based SQL database.\nDatabaseReference[URL[\"url\"]] represents a reference to a server-based SQL database.\nDatabaseReference[assoc] represents a fully specified reference to any SQL database." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabaseReference)))
(def Databin "Databin[\"id\"] represents a databin in the Wolfram Data Drop.\nDatabin[\"id\", n] represents the first n entries in a databin.\nDatabin[\"id\", -n] represents the most recent n entries in a databin.\nDatabin[\"id\", {m, n}] represents entries m through n in a databin, with negative numbers counting from the end.\nDatabin[\"id\", {m, n, s}] represents entries m through n with step s.\nDatabin[\"id\", time] represents entries going back for the quantity of time specified by time.\nDatabin[\"id\", date] represents the entries in a databin from the specified date to now.\nDatabin[\"id\", {date1, date2}] represents the entries in a databin from date1 to date2.\nDatabin[\"id\", range, {key1, key2, …}] represents only elements with keys keyi within each entry in a databin." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Databin)))
(def DatabinAdd "DatabinAdd[bin, data] adds the specified data to a databin." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabinAdd)))
(def DatabinSubmit "DatabinSubmit[bin, data] submits the specified data to be added to the databin bin asynchronously." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabinSubmit)))
(def DatabinUpload "DatabinUpload[bin, {entry1, entry2, …}] bulk uploads all the entries entryi to a databin.\nDatabinUpload[bin, EventSeries[…]] bulk uploads all entries in an event series to a databin." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatabinUpload)))
(def Databins "Databins[] gives a list of databins associated with the currently connected user." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Databins)))
(def Dataset "Dataset[data] represents a structured dataset based on a hierarchy of lists and associations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dataset)))
(def DatasetTheme "DatasetTheme is an option for Dataset that specifies an overall theme for a dataset and its elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatasetTheme)))
(def DateBounds "DateBounds[{date1, date2, …}] gives the earliest and latest of the datei.\nDateBounds[tseries] gives the first and last dates in the time series tseries.\nDateBounds[bin] gives the first and last time stamps in the databin bin.\nDateBounds[interval] gives the start and end dates of the date interval interval.\nDateBounds[interval, gran] gives the endpoints of interval in the specified granularity gran." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateBounds)))
(def DateDifference "DateDifference[date1, date2] gives the number of days from date1 to date2.\nDateDifference[date1, date2, \"unit\"] gives the difference between date1 and date2 in the specified unit.\nDateDifference[date1, date2, {\"unit1\", \"unit2\", …}] gives the difference as a list with elements corresponding to the successive \"uniti\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateDifference)))
(def DateDistribution "DateDistribution[dist, dunit, dorig] represents a distribution dist of dates with date scale unit dunit and date origin dorig." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateDistribution)))
(def DateFormat "DateFormat is an option that determines the date formatting of dates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateFormat)))
(def DateFunction "DateFunction is an option for DateListPlot and TemporalData that specifies how dates given as input should be interpreted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateFunction)))
(def DateGranularity "DateGranularity is an option that determines the calendar granularity of generated dates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateGranularity)))
(def DateHistogram "DateHistogram[{date1, date2, …}] plots a histogram of the dates datei.\nDateHistogram[{date1, date2, …}, bspec] plots a histogram with bin width specification bspec.\nDateHistogram[{date1, date2, …}, bspec, hspec] plots a histogram with bin heights computed according to the specification hspec.\nDateHistogram[{data1, data2, …}] plots histograms for multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateHistogram)))
(def DateInterval "DateInterval[{start, end}] represents the continuous interval of time between start and end.\nDateInterval[{start, end}, gran] represents an interval of dates with calendar granularity gran.\nDateInterval[{{start1, end1}, {start2, end2}, …}] represents the union of intervals start1 to end1, start2 to end2, ….\nDateInterval[gdate] gives the date interval from the initial to final instants of the granular date object gdate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateInterval)))
(def DateList "DateList[] gives the current local date and time in the form {year, month, day, hour, minute, second}. \nDateList[date] gives a date list corresponding to the given date specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateList)))
(def DateListLogPlot "DateListLogPlot[{{date1, y1}, {date2, y2}, …}] makes a log plot with values yi at a sequence of dates.\nDateListLogPlot[{y1, y2, …}, datespec] makes a log plot with dates at equal intervals specified by datespec.\nDateListLogPlot[tseries] plots the time series tseries.\nDateListLogPlot[{data1, data2, …}] plots data from all the datai.\nDateListLogPlot[{…, w[datai], …}] plots datai with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateListLogPlot)))
(def DateListPlot "DateListPlot[{{date1, y1}, {date2, y2}, …, {daten, yn}}] plots points with values yi at a sequence of dates.\nDateListPlot[{y1, y2, …, yn}, datespec] plots points with dates at equal intervals specified by datespec.\nDateListPlot[tseries] plots the time series tseries.\nDateListPlot[{data1, data2, …}] plots data from all the datai.\nDateListPlot[{…, w[datai], …}] plots datai with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateListPlot)))
(def DateListStepPlot "DateListStepPlot[{{date1, y1}, {date2, y2}, …}] plots the values yi in steps at a sequence of dates.\nDateListStepPlot[{y1, y2, …}, datespec] plots the values yi in steps with dates at equal intervals specified by datespec.\nDateListStepPlot[tseries] plots the time series tseries.\nDateListStepPlot[{data1, data2, …}] plots data from all the datai.\nDateListStepPlot[…, step] plots using steps specified by step.\nDateListStepPlot[{…, w[datai], …}] plots data datai with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateListStepPlot)))
(def DateObject "DateObject[] gives the current local date.\nDateObject[date] gives a date object corresponding to the given date specification.\nDateObject[rdate, gran] gives the date object of calendar granularity gran that includes the reference date rdate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateObject)))
(def DateObjectQ "DateObjectQ[expr] gives True if expr is a DateObject with valid arguments, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateObjectQ)))
(def DateOverlapsQ "DateOverlapsQ[date1, date2] returns True if the calendar dates date1 and date2 overlap, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateOverlapsQ)))
(def DatePattern "DatePattern[{\"e1\", \"e2\", …}] represents the characters of a date with elements of type \"ei\" in StringExpression.\nDatePattern[{\"e1\", \"e2\", …}, sep] allows separators that match the string expression sep." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatePattern)))
(def DatePlus "DatePlus[date, n] gives the date n days after date.\nDatePlus[date, {n, step}] gives the date n calendar steps after date.\nDatePlus[date, {{n1, step1}, {n2, step2}, …}] gives a date offset by ni steps of each specified size. \nDatePlus[n] gives the date n days after the current date.\nDatePlus[offset] gives the date with the specified offset from the current date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatePlus)))
(def DateRange "DateRange[date1, date2] gives all dates in the range from date1 to date2.\nDateRange[date1, date2, increment] gives the dates in the range from date1 to date2 that are increment apart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateRange)))
(def DateReduction "DateReduction is an option for DateHistogram that specifies the length for cyclic periods of time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateReduction)))
(def DateScale "DateScale[] represents the canonical mapping of continuous dates and times to a quantitative scale." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateScale)))
(def DateSelect "DateSelect[list, crit] picks out all dates datei of a list for which crit[datei] is True.\nDateSelect[int, crit] returns all dates within the DateInterval int for which crit[datei] is True.\nDateSelect[crit] represents an operator form of DateSelect that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateSelect)))
(def DateString "DateString[] gives a string representing the complete current local date and time. \nDateString[date] gives a string corresponding to the given date specification.\nDateString[{\"elem1\", \"elem2\", …}] concatenates the specified elements in the order given.\nDateString[date, fmt] gives elements specified by the date format fmt for the date or time specification date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateString)))
(def DateTicksFormat "DateTicksFormat is an option for DateListPlot which specifies how date tick labels should be formatted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateTicksFormat)))
(def DateValue "DateValue[\"elem\"] gives the specified element of the current date and time.\nDateValue[{elem1, elem2, …}] gives a list of the specified elements of the current date and time.\nDateValue[date, elem] gives the specified element of the specified date.\nDateValue[date, elem, form] gives the result in the specified form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateValue)))
(def DateWithinQ "DateWithinQ[date1, date2] returns True if the calendar date date2 is entirely contained within date1, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DateWithinQ)))
(def Dated "Dated[obj, year] represents the object obj associated with a particular year.\nDated[obj, date] represents the object obj associated with a date.\nDated[obj, All] represents the object obj for all dates where information is available about it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dated)))
(def DatedUnit "DatedUnit[unit, date] represents the specified unit at a specific date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DatedUnit)))
(def DaubechiesWavelet "DaubechiesWavelet[] represents a Daubechies wavelet of order 2. \nDaubechiesWavelet[n] represents a Daubechies wavelet of order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DaubechiesWavelet)))
(def DavisDistribution "DavisDistribution[b, n, μ] represents a Davis distribution with scale parameter b, shape parameter n, and location parameter μ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DavisDistribution)))
(def DawsonF "DawsonF[z] gives the Dawson integral F (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DawsonF)))
(def DayCount "DayCount[date1, date2] gives the number of days from date1 to date2.\nDayCount[date1, date2, daytype] gives the number of days of the specified daytype from date1 to date2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayCount)))
(def DayCountConvention "DayCountConvention is an option that specifies the day count convention used by DateDifference." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayCountConvention)))
(def DayHemisphere "DayHemisphere[] is a two-dimensional GeoGraphics primitive that represents the half of the Earth that is currently in daylight. \nDayHemisphere[datespec] represents the daylight half of the Earth for the specified date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayHemisphere)))
(def DayMatchQ "DayMatchQ[date, daytype] returns True if the date matches the daytype specification and returns False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayMatchQ)))
(def DayName "DayName[] gives the current day of the week.\nDayName[date] gives the day of the week for the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayName)))
(def DayNightTerminator "DayNightTerminator[] is a one-dimensional GeoGraphics primitive that represents the separation line between the halves of the Earth currently in daytime and nighttime.\nDayNightTerminator[datespec] represents the separation line between day and night for the specified date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayNightTerminator)))
(def DayPlus "DayPlus[date, n] gives the date n days away from date.\nDayPlus[date, n, daytype] gives the date that is n days of daytype away from date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayPlus)))
(def DayRange "DayRange[date1, date2] gives the dates in the range from date1 to date2.\nDayRange[date1, date2, daytype] gives the dates in the range from date1 to date2 that are of the specified daytype." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayRange)))
(def DayRound "DayRound[date, daytype] rounds date to the nearest day of daytype, using the next-day rounding convention.\nDayRound[date, daytype, rounding] rounds date to the nearest day of daytype, using rounding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DayRound)))
(def DaylightQ "DaylightQ[] gives True if it is currently daylight from the user's location.\nDaylightQ[datespec] gives True if it is daylight from the user's location on the specified datespec.\nDaylightQ[locationspec] gives True if it is currently daylight from the specified locationspec.\nDaylightQ[locationspec, datespec] gives True if it is daylight from the specified locationspec on the specified datespec.\nDaylightQ[{{location1, date1}, {location2, date2}, …}] gives True if it is daylight from the specified locations and dates.\nDaylightQ[locationspec, datespec, inclusionspec] gives True if it is daylight from the specified locationspec on the specified datespec taking inclusionspec into account." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DaylightQ)))
(def DeBruijnGraph "DeBruijnGraph[m, n] gives the n-dimensional De Bruijn graph with m symbols.\nDeBruijnGraph[m, n, type] gives the De Bruijn graph with connectivity given by type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeBruijnGraph)))
(def DeBruijnSequence "DeBruijnSequence[list, n] gives a de Bruijn sequence on the elements in list taken n at a time.\nDeBruijnSequence[k, n] gives a de Bruijn sequence on the elements 0, …, k-1.\nDeBruijnSequence[\"string\", n] gives a de Bruijn sequence on the characters in \"string\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeBruijnSequence)))
(def Decapitalize "Decapitalize[string] yields a string in which the first character has been made lowercase." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Decapitalize)))
(def DecimalForm "DecimalForm[expr] prints with approximate real numbers in expr always given in decimal form, without scientific notation.\nDecimalForm[expr, n] prints with approximate real numbers given in decimal form to n-digit precision.\nDecimalForm[expr, {n, f}] prints with approximate real numbers having n digits, with f digits to the right of the decimal point." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DecimalForm)))
(def DeclareCompiledComponent "DeclareCompiledComponent[\"name\", decls] adds declarations decls to compiled component \"name\".\nDeclareCompiledComponent[\"name\", field->spec] adds the specification spec to the specified field in the compiled component \"name\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeclareCompiledComponent)))
(def DeclarePackage "DeclarePackage[\"context`\", {\"name1\", \"name2\", …}] declares that Needs[\"context`\"] should automatically be executed if a symbol with any of the specified names is ever used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeclarePackage)))
(def Decompose "Decompose[poly, x] decomposes a polynomial, if possible, into a composition of simpler polynomials." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Decompose)))
(def DeconvolutionLayer "DeconvolutionLayer[n, sz] represents a trainable deconvolutional net layer having n output channels and using kernels of size sz to compute the deconvolution.\nDeconvolutionLayer[n, {s}] represents a layer performing one-dimensional deconvolutions with kernels of size s.\nDeconvolutionLayer[n, {h, w}] represents a layer performing two-dimensional deconvolutions with kernels of size h×w.\nDeconvolutionLayer[n, kernel, opts] includes options for initial kernels and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeconvolutionLayer)))
(def Decrement "x-- decreases the value of x by 1, returning the old value of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Decrement)))
(def Decrypt "Decrypt[\"password\", enc] attempts to decrypt the encrypted object enc using the specified password.\nDecrypt[keyspec, enc] attempts to decrypt using the cryptographic key specification keyspec.\nDecrypt[obj] interactively requests a password with which to try to decrypt obj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Decrypt)))
(def DecryptFile "DecryptFile[\"password\", file] generates a decrypted version of a file, using the specified password.\nDecryptFile[\"password\", source, target] generates a decrypted version of source, putting the result in target.\nDecryptFile[keyspec, source, …] decrypts using the cryptographic key specification keyspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DecryptFile)))
(def DedekindEta "DedekindEta[τ] gives the Dedekind eta modular elliptic function η (τ)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DedekindEta)))
(def DeepSpaceProbeData "DeepSpaceProbeData[entity, property] gives the value of the specified property for the deep space probe entity.\nDeepSpaceProbeData[{entity1, entity2, …}, property] gives a list of property values for the specified deep space probe entities.\nDeepSpaceProbeData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeepSpaceProbeData)))
(def Default "Default[f] gives the default value for arguments of the function f obtained with a _. pattern object. \nDefault[f, i] gives the default value to use when _. appears as the i ^th argument of f. \nDefault[f, i, n] gives the default value for the i ^th argument out of a total of n arguments. \nDefault[f, …]=val defines default values for arguments of f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Default)))
(def DefaultAxesStyle "DefaultAxesStyle is a low-level option for graphics functions that specifies the default style to use in displaying axes and axes-like constructs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultAxesStyle)))
(def DefaultBaseStyle "DefaultBaseStyle is a low-level option for formatting and related constructs that specifies a default base style to use before BaseStyle." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultBaseStyle)))
(def DefaultBoxStyle "DefaultBoxStyle is a low-level option for three-dimensional graphics functions that specifies the default style to use in rendering the bounding box." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultBoxStyle)))
(def DefaultButton "DefaultButton[] represents an OK button that closes a dialog, and is the default when Enter is pressed in the dialog.\nDefaultButton[action] represents a button that is labeled OK, and whose action is to evaluate action.\nDefaultButton[label, action] uses label as the label for the button." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultButton)))
(def DefaultDiffStyle "DefaultDiffStyle is a low-level option for Diff and related functions that specifies the default styles to use when viewing changes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultDiffStyle)))
(def DefaultDuplicateCellStyle "DefaultDuplicateCellStyle is a notebook option that specifies the default style to use for cells created by automatic duplication of other cells in the notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultDuplicateCellStyle)))
(def DefaultDuration "DefaultDuration is an option to Animate and related functions that specifies the default total duration of the animation in seconds." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultDuration)))
(def DefaultElement "DefaultElement is an option for Grid and related constructs which specifies what to insert when a new element is interactively created." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultElement)))
(def DefaultFaceGridsStyle "DefaultFaceGridsStyle is a low-level option for 3D graphics functions that specifies the default style to use in rendering face grids." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultFaceGridsStyle)))
(def DefaultFieldHintStyle "DefaultFieldHintStyle is a low-level option for InputField that specifies the default style to use for displaying the field hint." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultFieldHintStyle)))
(def DefaultFontProperties "DefaultFontProperties is a global option that allows overriding properties of specified font families." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultFontProperties)))
(def DefaultFrameStyle "DefaultFrameStyle is a low-level option for graphics and related constructs that specifies the default style to use in displaying their frames." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultFrameStyle)))
(def DefaultFrameTicksStyle "DefaultFrameTicksStyle is a low-level option for 2D graphics functions that specifies the default style to use in rendering frame ticks." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultFrameTicksStyle)))
(def DefaultGridLinesStyle "DefaultGridLinesStyle is a low-level option for 2D graphics functions that specifies the default style to use in rendering grid lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultGridLinesStyle)))
(def DefaultLabelStyle "DefaultLabelStyle is a low-level option for formatting and related constructs that specifies the default style to use in displaying their label-like elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultLabelStyle)))
(def DefaultMenuStyle "DefaultMenuStyle is a low-level option for menu-generating constructs that specifies the default style to use for displaying menu items." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultMenuStyle)))
(def DefaultNaturalLanguage "DefaultNaturalLanguage is an option for character selections that specifies the language used when checking the spelling of a word in a human natural language selection." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultNaturalLanguage)))
(def DefaultNewCellStyle "DefaultNewCellStyle is a notebook option which specifies the default style to use for new cells created in the notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultNewCellStyle)))
(def DefaultOptions "DefaultOptions is a style option that allows default options to be specified for particular formatting and related constructs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultOptions)))
(def DefaultPrintPrecision "DefaultPrintPrecision is an option for NumberForm, DecimalForm and related functions that specifies the default number of digits of precision with which to print machine numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultPrintPrecision)))
(def DefaultTicksStyle "DefaultTicksStyle is a low-level option for graphics functions that specifies the default style to use in rendering ticks." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultTicksStyle)))
(def DefaultTooltipStyle "DefaultTooltipStyle is a low-level option for tooltips that specifies the default style to use in displaying their elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultTooltipStyle)))
(def DefaultValues "DefaultValues[f] gives a list of transformation rules corresponding to default values of f.\nDefaultValues[\"symbol\"] gives a list of transformation rules corresponding to all default values defined for the symbol named \"symbol\" if it exists." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefaultValues)))
(def Defer "Defer[expr] yields an object that displays as the unevaluated form of expr, but that is evaluated if it is explicitly given as Wolfram Language input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Defer)))
(def DefineInputStreamMethod "DefineInputStreamMethod[\"name\", {fname1->function1, fname2->function2, … }] defines a custom input stream method with the specified name, allowing the Wolfram Language to call the stream functions fnamei for opening and reading from an input stream." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefineInputStreamMethod)))
(def DefineOutputStreamMethod "DefineOutputStreamMethod[\"name\", {fname1->function1, fname2->function2, … }] defines a custom output stream method with the specified name, allowing the Wolfram Language to call the stream functions for opening and writing to an output stream." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefineOutputStreamMethod)))
(def DefineResourceFunction "DefineResourceFunction[f] defines a resource function that can be applied to arguments to give the same result as f[…].\nDefineResourceFunction[f, name] uses name as the name of the resource function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DefineResourceFunction)))
(def Definition "Definition[symbol] prints as the definitions given for a symbol.\nDefinition[\"symbol\"] prints as the definitions given for the symbol named \"symbol\" if it exists.\nDefinition[patt] prints as the definitions given for the symbols whose names textually match the arbitrary string pattern patt.\nDefinition[{spec1, spec2, …}] prints as the definitions given for the symbols that are equal to or or whose names match any of the speci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Definition)))
(def Degree "Degree gives the number of radians in one degree. It has a numerical value of π/180." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Degree)))
(def DegreeCentrality "DegreeCentrality[g] gives a list of vertex degrees for the vertices in the underlying simple graph of g.\nDegreeCentrality[g, \"In\"] gives a list of vertex in-degrees.\nDegreeCentrality[g, \"Out\"] gives a list of vertex out-degrees.\nDegreeCentrality[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DegreeCentrality)))
(def DegreeGraphDistribution "DegreeGraphDistribution[dlist] represents a degree graph distribution with vertex degree dlist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DegreeGraphDistribution)))
(def Deinitialization "Deinitialization is an option for Dynamic, DynamicModule, Manipulate, and related constructs that specifies an expression to be evaluated when the construct can no longer be displayed or used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Deinitialization)))
(def Del "Del[x] displays as ∇x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Del)))
(def DelaunayMesh "DelaunayMesh[{p1, p2, …}] gives a MeshRegion representing the Delaunay mesh from the points p1, p2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DelaunayMesh)))
(def Delayed "Delayed[expr] represents an expression whose evaluation is delayed until its value is externally requested.\nDelayed[expr, fmt] specifies that the result from evaluating expr should be given in format fmt.\nDelayed[expr, {fmt, rform}] specifies that the result should be given as a response of the form rform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Delayed)))
(def Deletable "Deletable is an option for Cell that specifies whether the cell can be deleted interactively using the front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Deletable)))
(def Delete "Delete[expr, n] deletes the element at position n in expr. If n is negative, the position is counted from the end. \nDelete[expr, {i, j, …}] deletes the part at position {i, j, …}. \nDelete[expr, {{i1, j1, …}, {i2, j2, …}, …}] deletes parts at several positions. \nDelete[pos] represents an operator form of Delete that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Delete)))
(def DeleteAdjacentDuplicates "DeleteAdjacentDuplicates[list] deletes all duplicates in runs of identical elements in list.\nDeleteAdjacentDuplicates[list, test] applies test to pairs of consecutive elements to determine whether they should be considered duplicates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteAdjacentDuplicates)))
(def DeleteAnomalies "DeleteAnomalies[{example1, example2, …}] gives a list in which examplei that are considered anomalous have been dropped.\nDeleteAnomalies[fun, data] drops anomalies in data using the given AnomalyDetectorFunction[…] or LearnedDistribution[…]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteAnomalies)))
(def DeleteBorderComponents "DeleteBorderComponents[image] replaces connected components adjacent to the border in a binary image image with background pixels.\nDeleteBorderComponents[m] replaces components adjacent to the border in a label matrix m with 0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteBorderComponents)))
(def DeleteCases "DeleteCases[expr, pattern] removes all elements of expr that match pattern. \nDeleteCases[expr, pattern, levelspec] removes all parts of expr on levels specified by levelspec that match pattern. \nDeleteCases[expr, pattern, levelspec, n] removes the first n parts of expr that match pattern. \nDeleteCases[pattern] represents an operator form of DeleteCases that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteCases)))
(def DeleteChannel "DeleteChannel[channel] deletes the specified channel from the channel broker server.\nDeleteChannel[{channel1, channel2, …}] deletes all the channeli.\nDeleteChannel[All] deletes all channels owned by the currently authenticated user." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteChannel)))
(def DeleteCloudExpression "DeleteCloudExpression[\"name\"] deletes the cloud expression identified by \"name\".\nDeleteCloudExpression[ce] deletes the cloud expression ce." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteCloudExpression)))
(def DeleteContents "DeleteContents is an option for DeleteDirectory that specifies whether the contents of directories should automatically be deleted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteContents)))
(def DeleteDirectory "DeleteDirectory[\"dir\"] deletes the specified directory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteDirectory)))
(def DeleteDuplicates "DeleteDuplicates[list] deletes all duplicates from list.\nDeleteDuplicates[list, test] applies test to pairs of elements to determine whether they should be considered duplicates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteDuplicates)))
(def DeleteDuplicatesBy "DeleteDuplicatesBy[{e1, e2, …}, f] deletes those ei that yield duplicates in the list {f[e1], f[e2], …}.\nDeleteDuplicatesBy[f] represents an operator form of DeleteDuplicatesBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteDuplicatesBy)))
(def DeleteElements "DeleteElements[list, {e1, e2, …}] removes all instances of elements ei from list.\nDeleteElements[list, n{e1, e2, …}] removes up to n instances of each ei from list.\nDeleteElements[list, {n1, n2, …}{e1, e2, …}] removes up to ni instances of ei from list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteElements)))
(def DeleteFile "DeleteFile[\"file\"] deletes a file. \nDeleteFile[{\"file1\", \"file2\", …}] deletes a list of files." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteFile)))
(def DeleteMissing "DeleteMissing[list] drops elements with head Missing from a list.\nDeleteMissing[assoc] drops elements whose values have head Missing from the association assoc.\nDeleteMissing[expr, n] applies DeleteMissing to any lists or associations that occur within the first n levels of expr.\nDeleteMissing[expr, n, d] considers an element at level n to be missing if Missing occurs within the first d levels of the element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteMissing)))
(def DeleteObject "DeleteObject[obj] deletes the object obj.\nDeleteObject[{obj1, obj2, …}] deletes all the obji." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteObject)))
(def DeletePermissionsKey "DeletePermissionsKey[key] deletes a permissions key, rendering it invalid.\nDeletePermissionsKey[{key1, key2, …}] deletes several permissions keys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeletePermissionsKey)))
(def DeleteSearchIndex "DeleteSearchIndex[obj] deletes the search index represented by the search index object obj.\nDeleteSearchIndex[\"name\"] deletes the search index with the specified name in the SearchIndices[] list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteSearchIndex)))
(def DeleteSmallComponents "DeleteSmallComponents[image] replaces small connected components in a binary image image with background pixels.\nDeleteSmallComponents[m] replaces positive integers in a label matrix m with 0 if their tally is small.\nDeleteSmallComponents[…, n] replaces components consisting of n or fewer elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteSmallComponents)))
(def DeleteStopwords "DeleteStopwords[list] deletes stopwords from a list of words.\nDeleteStopwords[\"string\"] deletes stopwords from a string.\nDeleteStopwords[{string1, string2, …}] deletes stopwords from a list of strings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeleteStopwords)))
(def DelimitedSequence "DelimitedSequence[form] represents a delimited sequence of elements of the specified form in Interpreter and related functions.\nDelimitedSequence[form, sep] assumes a separator that matches sep.\nDelimitedSequence[form, {left, sep, right}] assumes left and right delimiters matching left and right, respectively." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DelimitedSequence)))
(def Delimiter "Delimiter represents a delimiter to be displayed in objects such as PopupMenu, Manipulate, and FormObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Delimiter)))
(def DelimiterAutoMatching "DelimiterAutoMatching is an option for cells and notebooks that specifies whether matching delimiters are automatically inserted when typing Wolfram Language code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DelimiterAutoMatching)))
(def DelimiterFlashTime "DelimiterFlashTime is an option for cells and notebooks that specifies how long in seconds a delimiter should flash when its matching delimiter is entered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DelimiterFlashTime)))
(def Delimiters "Delimiters is an option to various functions that specifies what delimiters to use or look for." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Delimiters)))
(def DeliveryFunction "DeliveryFunction is an option that specifies how material such as documents generated by DocumentGenerator should be delivered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeliveryFunction)))
(def Dendrogram "Dendrogram[{e1, e2, …}] constructs a dendrogram from the hierarchical clustering of the elements e1, e2, ….\nDendrogram[{e1v1, e2v2, …}] represents ei with vi in the constructed dendrogram.\nDendrogram[{e1, e2, …}{v1, v2, …}] represents ei with vi in the constructed dendrogram.\nDendrogram[label1e1, label2e2, …] represents ei using labels labeli in the constructed dendrogram.\nDendrogram[data, orientation] constructs an oriented dendrogram according to orientation.\nDendrogram[tree] constructs the dendrogram corresponding to weighted tree tree." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dendrogram)))
(def Denominator "Denominator[expr] gives the denominator of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Denominator)))
(def DensityHistogram "DensityHistogram[{{x1, y1}, {x2, y2}, …}] plots a density histogram of the values {xi, yi}.\nDensityHistogram[{{x1, y1}, {x2, y2}, …}, bspec] plots a density histogram with bins specified by bspec.\nDensityHistogram[{{x1, y1}, {x2, y2}, …}, bspec, hspec] plots a density histogram with bin densities computed according to the specification hspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DensityHistogram)))
(def DensityPlot "DensityPlot[f, {x, xmin, xmax}, {y, ymin, ymax}] makes a density plot of f as a function of x and y. \nDensityPlot[f, {x, y}∈reg] takes the variables {x, y} to be in the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DensityPlot)))
(def DensityPlot3D "DensityPlot3D[f, {x, xmin, xmax}, {y, ymin, ymax}, {z, zmin, zmax}] makes a density plot of f as a function of x, y, and z.\nDensityPlot3D[f, {x, y, z}∈reg] takes the variables to be in the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DensityPlot3D)))
(def DependentVariables "DependentVariables is an option for NDSolve and other functions that specifies the list of all objects that should be considered as dependent variables in equations that have been supplied." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DependentVariables)))
(def Deploy "Deploy[expr] yields a deployed version of expr in which elements such as Slider, InputField, Locator and Button are active, but general editing and selection is disabled." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Deploy)))
(def Deployed "Deployed is an option for displayed objects, cells, and notebooks that specifies whether their contents should be considered deployed, so that elements such as Slider, InputField, Locator, and Button are active, but general editing and selection is disabled." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Deployed)))
(def Depth "Depth[expr] gives the maximum number of indices needed to specify any part of expr, plus 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Depth)))
(def DepthFirstScan "DepthFirstScan[g, s, {event1f1, event2f2, …}] performs a depth-first scan of the graph g starting at the vertex s and evaluates fi whenever \"eventi\" occurs.\nDepthFirstScan[g, {event1->f1, event2->f2, …}] performs a depth-first scan of the whole graph g.\nDepthFirstScan[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DepthFirstScan)))
(def Derivative "f' represents the derivative of a function f of one argument. \nDerivative[n1, n2, …][f] is the general form, representing a function obtained from f by differentiating n1 times with respect to the first argument, n2 times with respect to the second argument, and so on." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Derivative)))
(def DerivativeFilter "DerivativeFilter[data, {n1, n2, …}] computes the ni ^th derivative of data at level i.\nDerivativeFilter[data, {n1, n2, …}, σ] computes the derivative at a Gaussian scale of standard deviation σ.\nDerivativeFilter[data, {der1, der2, …}, …] computes several derivatives der1, der2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DerivativeFilter)))
(def DerivativePDETerm "DerivativePDETerm[vars, γ] represents a load derivative term ∇{x1, …, xn}·(γ) with load derivative coefficient γ and model variables vars.\nDerivativePDETerm[vars, γ, pars] uses model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DerivativePDETerm)))
(def DerivedKey "DerivedKey[assoc] represents a derived key generated by GenerateDerivedKey." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DerivedKey)))
(def DescriptorStateSpace "DescriptorStateSpace is an option to StateSpaceModel and StateSpaceTransform that specifies whether to use descriptor or standard representation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DescriptorStateSpace)))
(def DesignMatrix "DesignMatrix[{{x11, x12, …, y1}, {x21, x22, …, y2}, …}, {f1, f2, …}, {x1, x2, …}] constructs the design matrix for the linear model β0+β1 f1+β2 f2+…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DesignMatrix)))
(def Det "Det[m] gives the determinant of the square matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Det)))
(def DeviceClose "DeviceClose[device] closes the connection to a device and frees related resources." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceClose)))
(def DeviceConfigure "DeviceConfigure[device, config] configures the specified device according to config." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceConfigure)))
(def DeviceExecute "DeviceExecute[device, \"command\"] executes the specified command on a device.\nDeviceExecute[device, \"command\", params] executes the command with the parameters params." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceExecute)))
(def DeviceExecuteAsynchronous "DeviceExecuteAsynchronous[device, \"command\", fun] initiates asynchronous execution of the specified command on a device, calling the handler function fun when an event occurs.\nDeviceExecuteAsynchronous[device, \"command\", params, fun] executes the command with the parameters params." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceExecuteAsynchronous)))
(def DeviceObject "DeviceObject[…] represents a device that can be accessed in a Wolfram Language session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceObject)))
(def DeviceOpen "DeviceOpen[\"devclass\"] opens a connection to the first available device in the class specified by \"devclass\".\nDeviceOpen[\"devclass\", spec] opens a connection to the particular device defined by spec.\nDeviceOpen[device] opens a connection to an existing device specified by a DeviceObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceOpen)))
(def DeviceRead "DeviceRead[devobj] reads a single default item from the open device corresponding to the specified DeviceObject.\nDeviceRead[\"devclass\"] reads from the default device in the class \"devclass\".\nDeviceRead[device, param] reads the parameter param from the specified device.\nDeviceRead[device, {param1, param2, …}] reads the list of parameters parami from the specified device." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceRead)))
(def DeviceReadBuffer "DeviceReadBuffer[device] reads the complete contents of the buffer on a device.\nDeviceReadBuffer[device, n] reads n elements from the buffer.\nDeviceReadBuffer[device, crit] reads elements from the buffer until the device-specific criterion crit is met.\nDeviceReadBuffer[device, crit, param] reads elements associated with the parameter param. \nDeviceReadBuffer[device, crit, {param1, param2, …}] reads elements associated with the parami." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceReadBuffer)))
(def DeviceReadLatest "DeviceReadLatest[device] returns the most recently collected default item from a device.\nDeviceReadLatest[device, n] returns a list of the n most recently collected items.\nDeviceReadLatest[device, n, param] returns the n most recently collected values of param.\nDeviceReadLatest[device, n, {param1, param2, …}] returns a list of the most recently collected values of the parami." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceReadLatest)))
(def DeviceReadList "DeviceReadList[device, n] reads from the specified device n times, returning a list of the results.\nDeviceReadList[device, n, param] reads the parameter param.\nDeviceReadList[device, n, {param1, param2, …}] reads the list of parameters parami." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceReadList)))
(def DeviceReadTimeSeries "DeviceReadTimeSeries[device, {t, dt}] repeatedly reads default items from the specified device at interval dt for a total time t, returning a time series of the resulting values.\nDeviceReadTimeSeries[device, {t, dt}, param] repeatedly reads the parameter param and returns a time series of its values.\nDeviceReadTimeSeries[device, {t, dt}, {param1, param2, …}] repeatedly reads the parami and returns a time series of their values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceReadTimeSeries)))
(def DeviceStreams "DeviceStreams[device] gives a list of all open streams associated with a device.\nDeviceStreams[device, patt] gives a list of streams whose names match the string pattern patt.\nDeviceStreams[device, {patt1, patt2, …}] gives a list of streams whose names match any of the patti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceStreams)))
(def DeviceWrite "DeviceWrite[device, val] writes the value val to the specified device.\nDeviceWrite[device, {val1, val2, …}] writes the sequence of values vali to the specified device.\nDeviceWrite[device, paramval] writes val as the value of the parameter param.\nDeviceWrite[device, {param1val1, param2val2, …}] writes values of several parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceWrite)))
(def DeviceWriteBuffer "DeviceWriteBuffer[device, vals] fills the buffer on a device with the values vals.\nDeviceWriteBuffer[device, paramvals] fills the buffer associated with the parameter param with the values vals.\nDeviceWriteBuffer[device, {param1vals1, param2vals2, …}] fills the buffers associated with the parami with the corresponding values vals i ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DeviceWriteBuffer)))
(def Devices "Devices[] gives a list of registered devices on a particular system.\nDevices[form] gives a list of devices in classes whose names match the string pattern form.\nDevices[{form1, form2, …}] gives a list of devices in classes whose names match any of the formi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Devices)))
(def Diagonal "Diagonal[m] gives the list of elements on the leading diagonal of the matrix m.\nDiagonal[m, k] gives the elements on the k ^th diagonal of m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Diagonal)))
(def DiagonalMatrix "DiagonalMatrix[list] gives a matrix with the elements of list on the leading diagonal, and zero elsewhere. \nDiagonalMatrix[list, k] gives a matrix with the elements of list on the k ^th diagonal.\nDiagonalMatrix[list, k, n] pads with zeros to create an n×n matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiagonalMatrix)))
(def DiagonalMatrixQ "DiagonalMatrixQ[m] gives True if m is diagonal, and False otherwise.\nDiagonalMatrixQ[m, k] gives True if m has nonzero elements only on the k ^th diagonal, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiagonalMatrixQ)))
(def DiagonalizableMatrixQ "DiagonalizableMatrixQ[m] gives True if m is diagonalizable, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiagonalizableMatrixQ)))
(def Dialog "Dialog[] initiates a dialog. \nDialog[expr] initiates a dialog with expr as the current value of %." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dialog)))
(def DialogInput "DialogInput[expr] interactively puts up expr as a dialog notebook, waits until a DialogReturn[e] is evaluated from within it, and then returns the result e. \nDialogInput[{x=x0, y=y0, …}, expr] sets up local variables x, y, … in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DialogInput)))
(def DialogNotebook "DialogNotebook[{cell1, cell2, …}] represents a dialog notebook that can be manipulated by the Wolfram System front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DialogNotebook)))
(def DialogProlog "DialogProlog is an option for Dialog that can give an expression to evaluate before the dialog starts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DialogProlog)))
(def DialogReturn "DialogReturn[expr] closes a dialog window, returning the expression expr from the dialog.\nDialogReturn[] closes a dialog window, returning Null." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DialogReturn)))
(def DialogSymbols "DialogSymbols is an option for Dialog that gives a list of symbols whose values should be localized in the dialog." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DialogSymbols)))
(def Diamond "Diamond[x, y, …] displays as x⋄y⋄…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Diamond)))
(def DiamondMatrix "DiamondMatrix[r] gives a matrix whose elements are 1 in a diamond-shaped region that extends r index positions to each side, and are 0 otherwise.\nDiamondMatrix[r, w] gives a w×w matrix containing a diamond-shaped region of 1s.\nDiamondMatrix[{r1, r2, …}, …] yields an array whose elements are 1 in a diamond-shaped region that extends ri index positions in the i ^th direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiamondMatrix)))
(def DiceDissimilarity "DiceDissimilarity[x, y] gives the Dice dissimilarity between Boolean vectors x and y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiceDissimilarity)))
(def DictionaryLookup "DictionaryLookup[patt] finds all words in an English dictionary that match the string pattern patt.\nDictionaryLookup[patt, n] gives only the first n words found.\nDictionaryLookup[{\"lang\", patt}] finds words in the language specified by lang." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DictionaryLookup)))
(def DictionaryWordQ "DictionaryWordQ[\"word\"] tests whether \"word\" is a recognized dictionary word." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DictionaryWordQ)))
(def Diff "Diff[first, second] returns a representation of the diffs between first and second.\nDiff[first, second, format] represents the diffs in the indicated format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Diff)))
(def Diff3 "Diff3[ancestor, first, second] attempts to resolve two different sets of edits from a common ancestor.\nDiff3[ancestor, first, second, format] represents the diffs in the indicated format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Diff3)))
(def DiffAlignmentMethod "DiffAlignmentMethod is an option to Diff and related functions that specifies how to align cells when comparing notebooks." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffAlignmentMethod)))
(def DiffApply "DiffApply[diffobj, expr] returns the result of applying the given DiffObject to the expression expr.\nDiffApply[diffobj, expr, File[\"file\"]] writes the result of changing expr to file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffApply)))
(def DiffGranularity "DiffGranularity is an option to Diff and related functions that indicates with what granularity to compare the given expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffGranularity)))
(def DiffIgnore "DiffIgnore is an option to Diff and related functions that specifies what elements to ignore when computing diffs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffIgnore)))
(def DiffIncludeMatches "DiffIncludeMatches is an option for Diff and related functions that specifies whether to include matching data in the resulting DiffObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffIncludeMatches)))
(def DiffInputFunction "DiffInputFunction is an option for Diff and related functions that specifies how the input expressions should be preprocessed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffInputFunction)))
(def DiffObject "DiffObject[v, type, data] represents a sequence of diffs for transforming objects of the indicated type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffObject)))
(def DiffStyle "DiffStyle is an option for Diff and related functions that specifies styles to use when viewing changes." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffStyle)))
(def DifferenceDelta "DifferenceDelta[f, i] gives the discrete difference if=f(i+1)-f (i).\nDifferenceDelta[f, {i, n}] gives the multiple difference _i^nf.\nDifferenceDelta[f, {i, n, h}] gives the multiple difference with step h.\nDifferenceDelta[f, i, j, …] computes the partial difference with respect to i, j, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferenceDelta)))
(def DifferenceQuotient "DifferenceQuotient[f, {x, h}]  gives the difference quotient (f(x+h)-f(x))/h.\nDifferenceQuotient[f, {x, n, h}] gives a multiple difference quotient with step h.\nDifferenceQuotient[f, {x1, n1, h1}, {x2, n2, h2}, …] computes the partial difference quotient with respect to x1, x2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferenceQuotient)))
(def DifferenceRoot "DifferenceRoot[lde][k] gives the holonomic sequence h(k), specified by the linear difference equation lde[h, k].\nDifferenceRoot[lde] represents a pure holonomic sequence h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferenceRoot)))
(def DifferenceRootReduce "DifferenceRootReduce[expr, n] attempts to reduce expr to a single DifferenceRoot object as a function of n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferenceRootReduce)))
(def Differences "Differences[list] gives the successive differences of elements in list. \nDifferences[list, n] gives the n ^th differences of list. \nDifferences[list, n, s] gives the differences of elements step s apart.\nDifferences[list, {n1, n2, …}] gives the successive nk ^th differences at level k in a nested list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Differences)))
(def DifferentialD "DifferentialD[x] displays as x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferentialD)))
(def DifferentialRoot "DifferentialRoot[lde][x] gives the holonomic function h(x), specified by the linear differential equation lde[h, x].\nDifferentialRoot[lde] represents a pure holonomic function h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferentialRoot)))
(def DifferentialRootReduce "DifferentialRootReduce[expr, x] attempts to reduce expr to a single DifferentialRoot object as a function of x.\nDifferentialRootReduce[expr, {x, x0}] takes the initial conditions to be specified at x=x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferentialRootReduce)))
(def DifferentiatorFilter "DifferentiatorFilter[data, ωc] applies a differentiator filter with a cutoff frequency ωc to an array of data.\nDifferentiatorFilter[data, ωc, n] uses a filter kernel of length n.\nDifferentiatorFilter[data, ωc, n, wfun] applies a smoothing window wfun to the filter kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DifferentiatorFilter)))
(def DiffusionPDETerm "DiffusionPDETerm[vars] represents a diffusion term ∇{x1, …, xn}·(-∇{x1, …, xn}u) with model variables vars.\nDiffusionPDETerm[vars, c] represents a diffusion term ∇{x1, …, xn}·(-c∇{x1, …, xn}u) with diffusion coefficient c.\nDiffusionPDETerm[vars, c, pars] uses model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiffusionPDETerm)))
(def DiggleGatesPointProcess "DiggleGatesPointProcess[μ, ρ, d] represents a Diggle–Gates point process with constant intensity μ and interaction radius ρ in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiggleGatesPointProcess)))
(def DiggleGrattonPointProcess "DiggleGrattonPointProcess[μ, κ, δ, ρ, d] represents a Diggle–Gratton point process with constant intensity μ, interaction parameter κ, hard-core interaction radius δ and interaction radius ρ in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiggleGrattonPointProcess)))
(def DigitBlock "DigitBlock is an option for NumberForm and related functions that specifies the maximum length of blocks of digits between breaks." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitBlock)))
(def DigitCharacter "DigitCharacter represents a digit character 0–9 in StringExpression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitCharacter)))
(def DigitCount "DigitCount[n, b, d] gives the number of d digits in the base-b representation of n. \nDigitCount[n, b] gives a list of the numbers of 1, 2, …, b-1, 0 digits in the base-b representation of n. \nDigitCount[n] gives a list of the numbers of 1, 2, …, 9, 0 digits in the base-10 representation of n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitCount)))
(def DigitQ "DigitQ[string] yields True if all the characters in the string are digits in the range 0 through 9, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitQ)))
(def DigitSum "DigitSum[n] gives the sum of the decimal digits in the integer n.\nDigitSum[n, b] gives the sum of the base b digits in the integer n.\nDigitSum[n, b, k] gives the sum of the first k base b digits in the integer n.\nDigitSum[n, b, -k] gives the sum of the last k base b digits in the integer n.\nDigitSum[n, MixedRadix[blist]] uses the mixed radix with list of bases blist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitSum)))
(def DigitalSignature "DigitalSignature[assoc] represents a digital signature object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DigitalSignature)))
(def DihedralAngle "DihedralAngle[{p1, p2}, {v, w}] gives the angle between two half-planes bounded by the line through p1 and p2 and extended in the direction v and w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DihedralAngle)))
(def DihedralGroup "DihedralGroup[n] represents the dihedral group of order 2n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DihedralGroup)))
(def Dilation "Dilation[image, ker] gives the morphological dilation of image with respect to the structuring element ker.\nDilation[image, r] gives the dilation with respect to a range-r square.\nDilation[data, …] applies dilation to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dilation)))
(def DimensionReduce "DimensionReduce[{example1, example2, …}] projects the examples examplei to a lower-dimensional approximating manifold.\nDimensionReduce[examples, n] projects onto an approximating manifold in n-dimensional space." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DimensionReduce)))
(def DimensionReducerFunction "DimensionReducerFunction[…] represents a function generated by DimensionReduction that projects data onto a lower-dimensional approximating manifold." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DimensionReducerFunction)))
(def DimensionReduction "DimensionReduction[{example1, example2, …}] generates a DimensionReducerFunction[…] that projects from the space defined by the examplei to a lower-dimensional approximating manifold.\nDimensionReduction[examples, n] generates a DimensionReducerFunction[…] for an n-dimensional approximating manifold. \nDimensionReduction[examples, n, props] generates the specified properties of the dimensionality reduction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DimensionReduction)))
(def DimensionalCombinations "DimensionalCombinations[{pq1, pq2, …}] returns the possible combinations of the list of physical quantities pqi that are dimensionless.\nDimensionalCombinations[{pq1, pq2, …}, dim] returns the possible combinations of the list of physical quantities pqi that match the dimensions of physical quantity dim." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DimensionalCombinations)))
(def DimensionalMeshComponents "DimensionalMeshComponents[mr] gives a list {r0, r1, …} of regions such that rd has dimension d for a mesh region mr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DimensionalMeshComponents)))
(def Dimensions "Dimensions[expr] gives a list of the dimensions of expr. \nDimensions[expr, n] gives a list of the dimensions of expr down to level n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dimensions)))
(def DiracComb "DiracComb[x] represents the Dirac comb function (x) giving a delta function at every integer point. \nDiracComb[x1, x2, …] represents the multidimensional Dirac comb function  (x1, x2, …)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiracComb)))
(def DiracDelta "DiracDelta[x] represents the Dirac delta function δ (x). \nDiracDelta[x1, x2, …] represents the multidimensional Dirac delta function δ (x1, x2, …)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiracDelta)))
(def DirectedEdge "DirectedEdge[u, v] or uv represents a directed edge from u to v.\nDirectedEdge[u, v, t] or uOverscript[, t]v represents a directed edge from u to v with tag t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectedEdge)))
(def DirectedEdges "DirectedEdges is an option for Graph, GraphPlot, and related functions that specifies whether edges should be taken to be directed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectedEdges)))
(def DirectedGraph "DirectedGraph[g] gives a directed graph from the undirected graph g.\nDirectedGraph[g, conv] gives a directed graph using the conversion conv.\nDirectedGraph[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectedGraph)))
(def DirectedGraphQ "DirectedGraphQ[g] yields True if the graph g is a directed graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectedGraphQ)))
(def DirectedInfinity "DirectedInfinity[] represents an infinite numerical quantity whose direction in the complex plane is unknown. \nDirectedInfinity[z] represents an infinite numerical quantity that is a positive real multiple of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectedInfinity)))
(def Direction "Direction is an option for Limit and related functions that specifies the direction in which the limit is taken." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Direction)))
(def DirectionalLight "DirectionalLight[col, pt] is a three–dimensional graphics directive that specifies the directional light of color col from the point pt to the center of the bounding box to use in coloring 3D surfaces.\nDirectionalLight[col, {pt1, pt2}] uses a directional light along the vector from pt1 to pt2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectionalLight)))
(def Directive "Directive[g1, g2, …] represents a single graphics directive composed of the directives g1, g2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Directive)))
(def Directory "Directory[] gives the current working directory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Directory)))
(def DirectoryName "DirectoryName[\"name\"] extracts the directory name from the specification for a file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectoryName)))
(def DirectoryQ "DirectoryQ[\"name\"] gives True if the directory with the specified name exists, and gives False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectoryQ)))
(def DirectoryStack "DirectoryStack[] gives the directory stack that represents the sequence of current directories used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirectoryStack)))
(def DirichletBeta "DirichletBeta[s] gives the Dirichlet beta function β (s)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletBeta)))
(def DirichletCharacter "DirichletCharacter[k, j, n] gives the Dirichlet character χ k, j(n) with modulus k and index j." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletCharacter)))
(def DirichletCondition "DirichletCondition[beqn, pred] represents a Dirichlet boundary condition given by equation beqn, satisfied on the part of the boundary of the region given to NDSolve and related functions where pred is True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletCondition)))
(def DirichletConvolve "DirichletConvolve[f, g, n, m] gives the Dirichlet convolution of the expressions f and g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletConvolve)))
(def DirichletDistribution "DirichletDistribution[{α1, …, α k+1}] represents a Dirichlet distribution of dimension k with shape parameters αi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletDistribution)))
(def DirichletEta "DirichletEta[s] gives the Dirichlet eta function η (s)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletEta)))
(def DirichletL "DirichletL[k, j, s] gives the Dirichlet L-function L(χ, s) for the Dirichlet character χ(n) with modulus k and index j." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletL)))
(def DirichletLambda "DirichletLambda[s] gives the Dirichlet lambda function λ (s)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletLambda)))
(def DirichletTransform "DirichletTransform[expr, n, s] gives the Dirichlet transform of expr with respect to n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletTransform)))
(def DirichletWindow "DirichletWindow[x] represents a Dirichlet window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DirichletWindow)))
(def DisableFormatting "DisableFormatting[expr] is a form that disables the formatting of expr when it appears inside held expressions, but gives expr as soon as evaluation occurs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisableFormatting)))
(def DiscreteAsymptotic "DiscreteAsymptotic[expr, n∞] gives an asymptotic approximation for expr as n tends to infinity over the integers.\nDiscreteAsymptotic[expr, {n, ∞, m}] gives an asymptotic series approximation for expr to order m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteAsymptotic)))
(def DiscreteChirpZTransform "DiscreteChirpZTransform[list] gives the chirp Z transform of list.\nDiscreteChirpZTransform[list, n] returns a length n chirp Z transform.\nDiscreteChirpZTransform[list, n, w] uses a spiral path on the complex z plane defined by w.\nDiscreteChirpZTransform[list, n, w, a] uses a as the complex starting point.\nDiscreteChirpZTransform[list, {n1, n2, …}, {w1, w2, …}, {a1, a2, …}] gives the multidimensional chirp Z transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteChirpZTransform)))
(def DiscreteConvolve "DiscreteConvolve[f, g, n, m] gives the convolution with respect to n of the expressions f and g. \nDiscreteConvolve[f, g, {n1, n2, …}, {m1, m2, …}] gives the multidimensional convolution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteConvolve)))
(def DiscreteDelta "DiscreteDelta[n1, n2, …] gives the discrete delta function δ(n1, n2, …), equal to 1 if all the ni are zero, and 0 otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteDelta)))
(def DiscreteHadamardTransform "DiscreteHadamardTransform[list] gives the discrete Hadamard transform of list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteHadamardTransform)))
(def DiscreteIndicator "DiscreteIndicator[x, x1, {u1, u2, …}] yields the discrete indicator function, equal to 1 if x=x1 and, otherwise, to 0 if x=ui for some i." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteIndicator)))
(def DiscreteInputOutputModel "DiscreteInputOutputModel[{g0, g1, …, g n-1}, u] represents a discrete-time model with input u and output y=gi(u) at sampling instant i.\nDiscreteInputOutputModel[{g0, g1, …, g n-1}, u, y] can be used to specify outputs gi(u, y) that also depend on the output variables y.\nDiscreteInputOutputModel[…, {{u1, {…, u10}}, …}, {{y1, {…, y10}}, …}] specifies input and output values for each signal for instants k<=0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteInputOutputModel)))
(def DiscreteLQEstimatorGains "DiscreteLQEstimatorGains[ssm, {w, v}, τ] gives the optimal discrete-time estimator gain matrix with sampling period τ for the continuous-time StateSpaceModel ssm, with process and measurement noise covariance matrices w and v.\nDiscreteLQEstimatorGains[{ssm, sensors}, {w, v}, τ] specifies sensors as the noisy measurements of ssm.\nDiscreteLQEstimatorGains[{ssm, sensors, dinputs}, {w, v}, τ] specifies dinputs as the deterministic inputs of ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteLQEstimatorGains)))
(def DiscreteLQRegulatorGains "DiscreteLQRegulatorGains[sspec, wts, τ] gives the discrete-time state feedback gains with sampling period τ for the continuous-time system specification sspec that minimizes a cost function with weights wts.\nDiscreteLQRegulatorGains[…, \"prop\"] gives the value of the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteLQRegulatorGains)))
(def DiscreteLimit "DiscreteLimit[f, k∞] gives the limit k∞f(k) for the sequence f as k tends to infinity over the integers.\nDiscreteLimit[f, {k1k_1^*, …, knk_n^*}] gives the nested limit _k1k_1^*⋯ _knk_n^*f(k1, …, kn) over the integers.\nDiscreteLimit[f, {k1, …, kn}{k_1^*, …, k_n^*}] gives the multivariate limit _{k1, …, kn}{k_1^*, …, k_n^*}f(k1, …, kn) over the integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteLimit)))
(def DiscreteLyapunovSolve "DiscreteLyapunovSolve[a, c] finds the numeric solution x of the discrete matrix equation a.x.a-xc.\nDiscreteLyapunovSolve[a, b, c] solves a.x.b-xc.\nDiscreteLyapunovSolve[{a, d}, c] solves a.x.a-d.x.dc.\nDiscreteLyapunovSolve[{a, d}, {b, e}, c] solves a.x.b-d.x.ec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteLyapunovSolve)))
(def DiscreteMarkovProcess "DiscreteMarkovProcess[i0, m] represents a discrete-time, finite-state Markov process with transition matrix m and initial state i0.\nDiscreteMarkovProcess[p0, m] represents a Markov process with initial state probability vector p0.\nDiscreteMarkovProcess[…, g] represents a Markov process with transition matrix from the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteMarkovProcess)))
(def DiscreteMaxLimit "DiscreteMaxLimit[f, k∞] gives the max limit k∞f(k) of the sequence f as k tends to ∞ over the integers.\nDiscreteMaxLimit[f, {k1k_1^*, …, knk_n^*}] gives the nested max limit _k1k_1^*⋯ _knk_n^*f(k1, …, kn) over the integers.\nDiscreteMaxLimit[f, {k1, …, kn}{k_1^*, …, k_n^*}] gives the multivariate max limit _{k1, …, kn}{k_1^*, …, k_n^*}f(k1, …, kn) over the integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteMaxLimit)))
(def DiscreteMinLimit "DiscreteMinLimit[f, k∞] gives the min limit k∞f(k) of the sequence f as k tends to ∞ over the integers.\nDiscreteMinLimit[f, {k1k_1^*, …, knk_n^*}] gives the nested min limit _k1k_1^*⋯ _knk_n^*f(k1, …, kn) over the integers.\nDiscreteMinLimit[f, {k1, …, kn}{k_1^*, …, k_n^*}] gives the multivariate min limit _{k1, …, kn}{k_1^*, …, k_n^*}f(k1, …, kn) over the integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteMinLimit)))
(def DiscretePlot "DiscretePlot[f, {n, nmax}] generates a plot of f as a function of n when n=1, …, nmax.\nDiscretePlot[f, {n, nmin, nmax}] generates a plot when n runs from nmin to nmax.\nDiscretePlot[f, {n, nmin, nmax, dn}] uses steps dn. \nDiscretePlot[f, {n, {n1, …, nm}}] uses the successive values n1, …, nm.\nDiscretePlot[{f1, f2, …}, …] plots the values of all the fi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscretePlot)))
(def DiscretePlot3D "DiscretePlot3D[f, {i, imin, imax}, {j, jmin, jmax}] generates a plot of f when i runs from imin to imax and j runs from jmin to jmax.\nDiscretePlot3D[f, {i, imin, imax, di}, {j, jmin, jmax, dj}] uses steps di and dj.\nDiscretePlot3D[f, {i, {i1, …, im}}, {j, {j1, …, jn}}] uses successive i values i1, …, jm and j values j1, …, jn. \nDiscretePlot3D[{f1, f2, …}, …, …] plots the values of all the fk." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscretePlot3D)))
(def DiscreteRatio "DiscreteRatio[f, i] gives the discrete ratio ((f(i+1))/(f(i))).\nDiscreteRatio[f, {i, n}] gives the multiple discrete ratio.\nDiscreteRatio[f, {i, n, h}] gives the multiple discrete ratio with step h. \nDiscreteRatio[f, i, j, …] computes the partial difference ratio with respect to i, j, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteRatio)))
(def DiscreteRiccatiSolve "DiscreteRiccatiSolve[{a, b}, {q, r}] gives the matrix x that is the stabilizing solution of the discrete algebraic Riccati equation a^†.x.a-x-a^†.x.b.(r+b^†.x.b)^-1.b^†.x.a+q0.\nDiscreteRiccatiSolve[{a, b}, {q, r, p}] solves a^†.x.a-x-(a^†.x.b+p).(r+b^†.x.b)^-1.(b^†.x.a+p^†)+q0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteRiccatiSolve)))
(def DiscreteShift "DiscreteShift[f, i] gives the discrete shift i(f(i))f (i+1). \nDiscreteShift[f, {i, n}] gives the multiple shift _i^n f.\nDiscreteShift[f, {i, n, h}] gives the multiple shift of step h.\nDiscreteShift[f, i, j, …] computes partial shifts with respect to i, j, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteShift)))
(def DiscreteTimeModelQ "DiscreteTimeModelQ[lsys] gives True if lsys is a discrete-time systems model, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteTimeModelQ)))
(def DiscreteUniformDistribution "DiscreteUniformDistribution[{imin, imax}] represents a discrete uniform distribution over the integers from imin to imax.\nDiscreteUniformDistribution[{{imin, imax}, {jmin, jmax}, …}] represents a multivariate discrete uniform distribution over integers within the box {{imin, imax}, {jmin, jmax}, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteUniformDistribution)))
(def DiscreteVariables "DiscreteVariables is an option for NDSolve and other functions that specifies variables that only change at discrete times in a temporal integration." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteVariables)))
(def DiscreteWaveletData "DiscreteWaveletData[{wind1coef1, …}, wave, wtrans] yields a discrete wavelet data object with wavelet coefficients coefi corresponding to wavelet index windi, wavelet wave, and wavelet transform wtrans.\nDiscreteWaveletData[{wind1coef1, …}, wave, wtrans, {d1, …}] yields a discrete wavelet data object assuming data dimensions {d1, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteWaveletData)))
(def DiscreteWaveletPacketTransform "DiscreteWaveletPacketTransform[data] gives the discrete wavelet packet transform (DWPT) of an array of data.\nDiscreteWaveletPacketTransform[data, wave] gives the discrete wavelet packet transform using the wavelet wave.\nDiscreteWaveletPacketTransform[data, wave, r] gives the discrete wavelet packet transform using r levels of refinement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteWaveletPacketTransform)))
(def DiscreteWaveletTransform "DiscreteWaveletTransform[data] gives the discrete wavelet transform (DWT) of an array of data.\nDiscreteWaveletTransform[data, wave] gives the discrete wavelet transform using the wavelet wave.\nDiscreteWaveletTransform[data, wave, r] gives the discrete wavelet transform using r levels of refinement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscreteWaveletTransform)))
(def DiscretizeGraphics "DiscretizeGraphics[g] discretizes a 2D or 3D graphic g into a MeshRegion.\nDiscretizeGraphics[g, patt] discretizes only the elements in g that match the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscretizeGraphics)))
(def DiscretizeRegion "DiscretizeRegion[reg] discretizes a region reg into a MeshRegion.\nDiscretizeRegion[reg, {{xmin, xmax}, …}] restricts to the bounds [xmin, xmax]×⋯." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiscretizeRegion)))
(def Discriminant "Discriminant[poly, var] computes the discriminant of the polynomial poly with respect to the variable var.\nDiscriminant[poly, var, Modulusp] computes the discriminant modulo p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Discriminant)))
(def DisjointQ "DisjointQ[list1, list2] yields True if list1 and list2 do not share any common elements, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisjointQ)))
(def Disjunction "Disjunction[expr, {a1, a2, …}] gives the disjunction of expr over all choices of the Boolean variables ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Disjunction)))
(def Disk "Disk[{x, y}, r] represents a disk of radius r centered at {x, y}.\nDisk[{x, y}] gives a disk of radius 1. \nDisk[{x, y}, {rx, ry}] gives an axis-aligned elliptical disk with semiaxes lengths rx and ry.\nDisk[{x, y}, …, {θ1, θ2}] gives a sector of a disk from angle θ1 to θ2.\nDisk[{{x1, y1}, {x2, y2}, …}, …] gives multiple identical disks centered at the given coordinates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Disk)))
(def DiskMatrix "DiskMatrix[r] gives a matrix whose elements are 1 in a disk-shaped region of radius r, and are otherwise 0.\nDiskMatrix[r, w] gives a w×w matrix containing a disk of 1s with radius r.\nDiskMatrix[{r1, r2, …}, …] yields an array whose elements are 1 in an ellipsoidal region with semiaxis ri in the i ^th index direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiskMatrix)))
(def DiskSegment "DiskSegment[{x, y}, r, {θ1, θ2}] represents the disk segment from angle θ1 to θ2 in a disk centered at {x, y} of radius r.\nDiskSegment[{x, y}, {rx, ry}, {θ1, θ2}] represents the ellipse segment from angle θ1 to θ2 in an axis-aligned ellipse with semiaxes lengths rx and ry." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DiskSegment)))
(def Dispatch "Dispatch[{lhs1rhs1, lhs2rhs2, …}] generates an optimized dispatch table representation of a list of rules. The object produced by Dispatch can be used to give the rules in expr/.rules." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dispatch)))
(def DispersionEstimatorFunction "DispersionEstimatorFunction is an option for generalized linear model fitting functions that specifies the estimator for the dispersion parameter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DispersionEstimatorFunction)))
(def DisplayAllSteps "DisplayAllSteps is an option to Animate and related functions that specifies whether all frames should be displayed in an animation, even if to do so would slow the animation down." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisplayAllSteps)))
(def DisplayEndPacket "DisplayEndPacket[] is a WSTP packet that indicates the end of a series of expressions relating to a postscript graphic." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisplayEndPacket)))
(def DisplayForm "DisplayForm[expr] prints with low-level boxes inside expr shown in explicit two-dimensional or other form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisplayForm)))
(def DisplayFunction "DisplayFunction is an option for graphics and sound functions that specifies a function to apply to graphics and sound objects before returning them." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisplayFunction)))
(def DisplayPacket "DisplayPacket[] is a WSTP packet that indicates the beginning of a series of expressions related to a PostScript graphic." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DisplayPacket)))
(def DistanceFunction "DistanceFunction is an option for functions such as Nearest that specifies the distance value to assume between any two specified points." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistanceFunction)))
(def DistanceMatrix "DistanceMatrix[{u1, u2, …}] gives the matrix of distances between each pair of elements ui, uj. \nDistanceMatrix[{u1, u2, …}, {v1, v2, …}] gives the matrix of distances between each pair of elements ui, vj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistanceMatrix)))
(def DistanceTransform "DistanceTransform[image] gives the distance transform of image, in which the value of each pixel is replaced by its distance to the nearest background pixel.\nDistanceTransform[image, t] treats values above t as foreground." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistanceTransform)))
(def Distribute "Distribute[f[x1, x2, …]] distributes f over Plus appearing in any of the xi. \nDistribute[expr, g] distributes over g. \nDistribute[expr, g, f] performs the distribution only if the head of expr is f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Distribute)))
(def DistributeDefinitions "DistributeDefinitions[s1, s2, …] distributes all definitions for the symbols si to all parallel kernels.\nDistributeDefinitions[\"context`\"] distributes definitions for all symbols in the specified context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributeDefinitions)))
(def Distributed "Distributed[x, dist] or xdist asserts that the random variable x is distributed according to the probability distribution dist.\nDistributed[{x1, x2, …}, dist] or {x1, x2, …}dist asserts that the random vector {x1, x2, …} is distributed according to the multivariate probability distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Distributed)))
(def DistributedContexts "DistributedContexts is an option for various parallel computing functions that specifies which definitions for symbols appearing in an expression should be distributed to all parallel kernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributedContexts)))
(def DistributionChart "DistributionChart[{data1, data2, …}] makes a distribution chart with a distribution symbol for each datai.\nDistributionChart[{…, wi[datai, …], …, wj[dataj, …], …}] makes a distribution chart with symbol features defined by the symbolic wrappers wk.\nDistributionChart[{{data1, data2, …}, …}] makes a distribution chart from multiple groups of datasets {data1, data2, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributionChart)))
(def DistributionFitTest "DistributionFitTest[data] tests whether data is normally distributed. \nDistributionFitTest[data, dist] tests whether data is distributed according to dist. \nDistributionFitTest[data, dist, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributionFitTest)))
(def DistributionParameterAssumptions "DistributionParameterAssumptions[dist] gives a logical expression for assumptions on parameters in the symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributionParameterAssumptions)))
(def DistributionParameterQ "DistributionParameterQ[dist] yields True if dist is a valid distribution, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DistributionParameterQ)))
(def Dithering "Dithering is an option for ColorQuantize that specifies whether or not to apply dithering while quantizing the pixel values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dithering)))
(def Div "Div[{f1, …, fn}, {x1, …, xn}] gives the divergence ∂f1/∂x1+…+∂fn/∂xn.\nDiv[{f1, …, fn}, {x1, …, xn}, chart] gives the divergence in the coordinates chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Div)))
(def Divide "x/y or Divide[x, y] is equivalent to x y^-1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Divide)))
(def DivideBy "x/=c divides x by c and returns the new value of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DivideBy)))
(def DivideSides "DivideSides[rel, x] divides each side of the equation or inequality rel by x.\nDivideSides[rel1, rel2] divides the corresponding sides of two equations or inequalities.\nDivideSides[rel] divides each side of rel by the right-hand side, producing a 1 right-hand side." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DivideSides)))
(def Dividers "Dividers is an option for Grid and related constructs that specifies where and how to draw divider lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dividers)))
(def Divisible "Divisible[n, m] yields True if n is divisible by m, and yields False if it is not." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Divisible)))
(def DivisorSigma "DivisorSigma[k, n] gives the divisor function σk (n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DivisorSigma)))
(def DivisorSum "DivisorSum[n, form] represents the sum of form[i] for all i that divide n.\nDivisorSum[n, form, cond] includes only those divisors for which cond[i] gives True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DivisorSum)))
(def Divisors "Divisors[n] gives a list of the integers that divide n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Divisors)))
(def Do "Do[expr, n] evaluates expr n times. \nDo[expr, {i, imax}] evaluates expr with the variable i successively taking on the values 1 through imax (in steps of 1). \nDo[expr, {i, imin, imax}] starts with i=imin. \nDo[expr, {i, imin, imax, di}] uses steps di. \nDo[expr, {i, {i1, i2, …}}] uses the successive values i1, i2, ….\nDo[expr, {i, imin, imax}, {j, jmin, jmax}, …] evaluates expr looping over different values of j etc. for each i." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Do)))
(def DockedCell "DockedCell is an option for Cells that indicates whether to find cells created by DockedCells." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DockedCell)))
(def DockedCells "DockedCells is an option for notebooks that gives a list of cells that are to be displayed \"docked\" at the top of the notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DockedCells)))
(def DocumentGenerator "DocumentGenerator[template, timespec] represents a document generator with template template to be evaluated on the schedule defined by timespec.\nDocumentGenerator[template, driver, timespec] takes parameters for filling the template from driver." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DocumentGenerator)))
(def DocumentGeneratorInformation "DocumentGeneratorInformation[cloudobj] returns the properties of the DocumentGenerator cloudobj.\nDocumentGeneratorInformation[cloudobj, property] returns the value of the property property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DocumentGeneratorInformation)))
(def DocumentGenerators "DocumentGenerators[] returns a list of CloudObject expressions that represent currently deployed document generators." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DocumentGenerators)))
(def DocumentNotebook "DocumentNotebook[{cell1, cell2, …}] represents a complete document notebook in the Wolfram System front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DocumentNotebook)))
(def DocumentWeightingRules "DocumentWeightingRules is an option for TextSearch and related functions that allows the specification of weights for documents based on the values of fields in the search index." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DocumentWeightingRules)))
(def Dodecahedron "Dodecahedron[] represents a regular dodecahedron centered at the origin with unit edge length.\nDodecahedron[l] represents a dodecahedron with edge length l.\nDodecahedron[{θ, ϕ}, …] represents a dodecahedron rotated by an angle θ with respect to the z axis and angle ϕ with respect to the y axis.\nDodecahedron[{x, y, z}, …] represents a dodecahedron centered at {x, y, z}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dodecahedron)))
(def DominantColors "DominantColors[image] returns dominant colors in image.\nDominantColors[image, n] returns at most n dominant colors in image.\nDominantColors[image, n, prop] returns the specified property prop for the regions that belong to the same dominant color.\nDominantColors[image, n, prop, format] returns the output in the specified format.\nDominantColors[{image1, image2, …}, …] returns dominant colors in each imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DominantColors)))
(def DominatorTreeGraph "DominatorTreeGraph[g, v] gives the dominator tree of the directed graph g from the root vertex v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DominatorTreeGraph)))
(def DominatorVertexList "DominatorVertexList[g, v] gives the list of immediate dominators of the directed graph g from the root vertex v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DominatorVertexList)))
(def Dot "a.b.c or Dot[a, b, c] gives products of vectors, matrices, and tensors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dot)))
(def DotDashed "DotDashed is a graphics directive specifying that lines that follow should be drawn dot-dashed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DotDashed)))
(def DotEqual "DotEqual[x, y, …] displays as x≐y≐…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DotEqual)))
(def DotLayer "DotLayer[] represents a net layer that takes the dot product of two or more arrays.\nDotLayer[{spec1, spec2, …}] uses given transpose specifications for the respective inputs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DotLayer)))
(def Dotted "Dotted is a graphics directive specifying that lines that follow should be drawn dotted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dotted)))
(def DoubleBracketingBar "DoubleBracketingBar[x, y, …] displays as x, y, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleBracketingBar)))
(def DoubleDownArrow "DoubleDownArrow[x, y, …] displays as x⇓y…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleDownArrow)))
(def DoubleLeftArrow "DoubleLeftArrow[x, y, …] displays as x⇐y⇐…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLeftArrow)))
(def DoubleLeftRightArrow "DoubleLeftRightArrow[x, y, …] displays as x⇔y⇔…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLeftRightArrow)))
(def DoubleLeftTee "DoubleLeftTee[x, y] displays as x⫤y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLeftTee)))
(def DoubleLongLeftArrow "DoubleLongLeftArrow[x, y, …] displays as x⟸y⟸…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLongLeftArrow)))
(def DoubleLongLeftRightArrow "DoubleLongLeftRightArrow[x, y, …] displays as x⟺y⟺…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLongLeftRightArrow)))
(def DoubleLongRightArrow "DoubleLongRightArrow[x, y, …] displays as x⟹y⟹…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleLongRightArrow)))
(def DoubleRightArrow "DoubleRightArrow[x, y, …] displays as x⇒y⇒…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleRightArrow)))
(def DoubleRightTee "DoubleRightTee[x, y] displays as x⊨y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleRightTee)))
(def DoubleUpArrow "DoubleUpArrow[x, y, …] displays as x⇑y⇑…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleUpArrow)))
(def DoubleUpDownArrow "DoubleUpDownArrow[x, y, …] displays as x⇕y⇕…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleUpDownArrow)))
(def DoubleVerticalBar "DoubleVerticalBar[x, y, …] displays as x∥y∥…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DoubleVerticalBar)))
(def DownArrow "DownArrow[x, y, …] displays as x↓y↓…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownArrow)))
(def DownArrowBar "DownArrowBar[x, y, …] displays as x⤓y⤓…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownArrowBar)))
(def DownArrowUpArrow "DownArrowUpArrow[x, y, …] displays as x⇵y⇵…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownArrowUpArrow)))
(def DownLeftRightVector "DownLeftRightVector[x, y, …] displays as x⥐y⥐…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownLeftRightVector)))
(def DownLeftTeeVector "DownLeftTeeVector[x, y, …] displays as x⥞y⥞…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownLeftTeeVector)))
(def DownLeftVector "DownLeftVector[x, y, …] displays as x↽y↽…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownLeftVector)))
(def DownLeftVectorBar "DownLeftVectorBar[x, y, …] displays as x⥖y⥖…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownLeftVectorBar)))
(def DownRightTeeVector "DownRightTeeVector[x, y, …] displays as x⥟y⥟…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownRightTeeVector)))
(def DownRightVector "DownRightVector[x, y, …] displays as x⇁y⇁…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownRightVector)))
(def DownRightVectorBar "DownRightVectorBar[x, y, …] displays as x⥗y⥗…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownRightVectorBar)))
(def DownTee "DownTee[x, y] displays as x⊤y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownTee)))
(def DownTeeArrow "DownTeeArrow[x, y, …] displays as x↧y↧…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownTeeArrow)))
(def DownValues "DownValues[f] gives a list of transformation rules corresponding to all downvalues (values for f[…]) defined for the symbol f. \nDownValues[\"symbol\"] gives a list of transformation rules corresponding to all downvalues defined for the symbol named \"symbol\" if it exists." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownValues)))
(def DownValuesFunction "DownValuesFunction[sym] represents a function that uses definitions attached to sym when compiling." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DownValuesFunction)))
(def Downsample "Downsample[array, n] returns a downsampled version of the array by sampling every n ^th element.\nDownsample[array, n, offset] starts sampling from the element at position offset.\nDownsample[image, …] downsamples an image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Downsample)))
(def DrazinInverse "DrazinInverse[m] finds the Drazin generalized inverse m^D of a square matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DrazinInverse)))
(def Drop "Drop[list, n] gives list with its first n elements dropped. \nDrop[list, -n] gives list with its last n elements dropped. \nDrop[list, {n}] gives list with its n ^th element dropped. \nDrop[list, {m, n}] gives list with elements m through n dropped. \nDrop[list, {m, n, s}] gives list with elements m through n in steps of s dropped. \nDrop[list, seq1, seq2, …] gives a nested list in which elements specified by seqi have been dropped at level i in list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Drop)))
(def DropShadowing "DropShadowing[] is a two‐dimensional directive specifying that graphics objects are to be drawn with an additional blurred offset image.\nDropShadowing[{dx, dy}] uses an absolute offset {dx, dy}.\nDropShadowing[{dx, dy}, r] applies a blur effect with radius r.\nDropShadowing[{dx, dy}, r, col] uses the specified color col for the blurred offset image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DropShadowing)))
(def DropoutLayer "DropoutLayer[] represents a net layer that sets its input elements to zero with probability 0.5 during training.\nDropoutLayer[p] sets its input elements to zero with probability p during training." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DropoutLayer)))
(def Dt "Dt[f, x] gives the total derivative d f/dx. \nDt[f] gives the total differential df. \nDt[f, {x, n}] gives the multiple derivative d^n f/dx^n. \nDt[f, x1, x2, …] gives d/dx1 d/dx2 … f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dt)))
(def DualPlanarGraph "DualPlanarGraph[g] gives the dual of the planar graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DualPlanarGraph)))
(def DualPolyhedron "DualPolyhedron[poly] gives the dual polyhedron of the polyhedron poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DualPolyhedron)))
(def DualSystemsModel "DualSystemsModel[ssm] gives the dual of the state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DualSystemsModel)))
(def DumpSave "DumpSave[\"file.mx\", symbol] writes definitions associated with a symbol to a file in internal Wolfram System format. \nDumpSave[\"file.mx\", \"context`\"] writes out definitions associated with all symbols in the specified context. \nDumpSave[\"file.mx\", {object1, object2, …}] writes out definitions for several symbols or contexts. \nDumpSave[\"package`\", objects] chooses the name of the output file based on the computer system used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DumpSave)))
(def DuplicateFreeQ "DuplicateFreeQ[list] gives True if list has no duplicates, and False otherwise.\nDuplicateFreeQ[list, test] applies test to pairs of elements to determine whether they should be considered duplicates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DuplicateFreeQ)))
(def Duration "Duration[expr] returns the duration of expr.\nDuration[expr, unit] returns the result in the specified unit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Duration)))
(def Dynamic "Dynamic[expr] represents an object that displays as the dynamically updated current value of expr. If the displayed form of Dynamic[expr] is interactively changed or edited, an assignment expr=val is done to give expr the new value val that corresponds to the displayed form. \nDynamic[expr, None] does not allow interactive changing or editing. \nDynamic[expr, f] continually evaluates f[val, expr] during interactive changing or editing of val. \nDynamic[expr, {f, fend}] also evaluates fend[val, expr] when interactive changing or editing is complete. \nDynamic[expr, {fstart, f, fend}] also evaluates fstart[val, expr] when interactive changing or editing begins." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Dynamic)))
(def DynamicEvaluationTimeout "DynamicEvaluationTimeout is an option for displayed objects, cells, and notebooks that specifies the timeout in seconds for any Dynamic computations they contain." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicEvaluationTimeout)))
(def DynamicGeoGraphics "DynamicGeoGraphics[primitives, options] represents a dynamic, interactive, two-dimensional geographical image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicGeoGraphics)))
(def DynamicImage "DynamicImage[image] displays a dynamic version of image, supporting panning, zooming, etc.\nDynamicImage[file] displays a dynamic version of the image stored in file. \nDynamicImage[url] displays a dynamic version of the image stored in url." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicImage)))
(def DynamicModule "DynamicModule[{x, y, …}, expr] represents an object which maintains the same local instance of the symbols x, y, … in the course of all evaluations of Dynamic objects in expr. Symbols specified in a DynamicModule will by default have their values maintained even across Wolfram System sessions. \nDynamicModule[{x=x0, y=y0, …}, expr] specifies initial values for x, y, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicModule)))
(def DynamicModuleBox "DynamicModuleBox[{x, y, …}, expr] is a low-level construct that represents a DynamicModule with localized symbols x, y, ….\nDynamicModuleBox[{x=x0, y=y0, …}, expr] specifies values for x, y, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicModuleBox)))
(def DynamicModuleBoxOptions "DynamicModuleBoxOptions{opt1val1, opt2val2, …} is an option that specifies settings for DynamicModuleBox objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicModuleBoxOptions)))
(def DynamicModuleValues "DynamicModuleValues is an option for DynamicModule that stores downvalues of local symbols." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicModuleValues)))
(def DynamicSetting "DynamicSetting[e] represents an object which displays as e, but is interpreted as the dynamically updated current value of Setting[e] if supplied as Wolfram Language input.\nDynamicSetting[f, e] displays as e, but is interpreted as f[e] if supplied as input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicSetting)))
(def DynamicUpdating "DynamicUpdating is an option for displayed objects, cells and notebooks that specifies whether dynamic objects and option values in their contents will update." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicUpdating)))
(def DynamicWrapper "DynamicWrapper[e, expr] represents an object that displays as e, but dynamically updates the expression expr whenever that object is visible on screen." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote DynamicWrapper)))
(def E "E is the exponential constant  (base of natural logarithms), with numerical value ≃2.71828." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote E)))
(def EarthImpactData "EarthImpactData[entity, property] gives the value of the specified property for the earth impact crater entity.\nEarthImpactData[{entity1, entity2, …}, property] gives a list of property values for the specified earth impact crater names.\nEarthImpactData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EarthImpactData)))
(def EarthquakeData "EarthquakeData[loc] gives all earthquake properties for the location corresponding to loc.\nEarthquakeData[loc, mag] restricts earthquakes returned to the magnitude range mag. \nEarthquakeData[loc, mag, {start, end}] gives earthquake data within the magnitude range mag during the time interval start to end.\nEarthquakeData[loc, mag, {start, end}, property] gives a time series for the specific earthquake property for earthquakes within the magnitude range mag during the time interval start to end.\nEarthquakeData[entity, property] returns data for a specific earthquake." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EarthquakeData)))
(def EccentricityCentrality "EccentricityCentrality[g] gives a list of eccentricity centralities for the vertices in the graph g.\nEccentricityCentrality[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EccentricityCentrality)))
(def Echo "Echo[expr] prints expr and returns expr.\nEcho[expr, label] prints expr prepending label and returns expr.\nEcho[expr, label, f] prints f[expr] prepending label and returns expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Echo)))
(def EchoEvaluation "EchoEvaluation[expr] prints expr before evaluation, then prints the result after evaluation and returns that result.\nEchoEvaluation[expr, label] prepends label when printing expr before and after evaluation.\nEchoEvaluation[expr, label1label2] prepends label1 before evaluation and label2 after evaluation.\nEchoEvaluation[expr, labels, f] prints expr before evaluation, then evaluates expr to the result res and prints f[res].\nEchoEvaluation[expr, labels, gf] prints g[expr] before evaluating expr and then f[res] after evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EchoEvaluation)))
(def EchoFunction "EchoFunction[f][expr] prints f[expr] and returns expr.\nEchoFunction[label, f][expr] prints f[expr] prepending label and returns expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EchoFunction)))
(def EchoLabel "EchoLabel[label][expr] prints expr prepending label and returns expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EchoLabel)))
(def EchoTiming "EchoTiming[expr] evaluates expr, prints the time in seconds used and returns the result of the evaluation.\nEchoTiming[expr, label] prints the timing, prepending label." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EchoTiming)))
(def EclipseType "EclipseType is an option for SolarEclipse and LunarEclipse that specifies the type of eclipse being queried for." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EclipseType)))
(def EdgeAdd "EdgeAdd[g, e] makes a graph by adding the edge e to the graph g.\nEdgeAdd[g, {e1, e2, …}] adds a collection of edges to g.\nEdgeAdd[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeAdd)))
(def EdgeBetweennessCentrality "EdgeBetweennessCentrality[g] gives a list of betweenness centralities for the edges in the graph g.\nEdgeBetweennessCentrality[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeBetweennessCentrality)))
(def EdgeCapacity "EdgeCapacity is an option and annotation for Graph and related functions that specifies an edge capacity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeCapacity)))
(def EdgeChromaticNumber "EdgeChromaticNumber[g] gives the chromatic number for the edges of the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeChromaticNumber)))
(def EdgeConnectivity "EdgeConnectivity[g] gives the edge connectivity of the graph g.\nEdgeConnectivity[g, s, t] gives the s-t edge connectivity of the graph g.\nEdgeConnectivity[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeConnectivity)))
(def EdgeContract "EdgeContract[g, e] contracts the edge e of the graph g.\nEdgeContract[g, {e1, e2, …}] contracts a collection of edges e1, e2, ….\nEdgeContract[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeContract)))
(def EdgeCost "EdgeCost is an option and annotation for Graph and related functions that specifies an edge cost." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeCost)))
(def EdgeCount "EdgeCount[g] gives a count of the number of edges in the graph g.\nEdgeCount[g, patt] gives a count of the number of edges that match the pattern patt.\nEdgeCount[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeCount)))
(def EdgeCoverQ "EdgeCoverQ[g, elist] yields True if the edge list elist is an edge cover of the graph g and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeCoverQ)))
(def EdgeCycleMatrix "EdgeCycleMatrix[g] gives the edge cycle matrix of a graph g.\nEdgeCycleMatrix[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeCycleMatrix)))
(def EdgeDelete "EdgeDelete[g, e] makes a graph by deleting the edge e from the graph g.\nEdgeDelete[g, {e1, e2, …}] deletes a collection of edges from g.\nEdgeDelete[g, patt] deletes all edges that match the pattern patt.\nEdgeDelete[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeDelete)))
(def EdgeDetect "EdgeDetect[image] finds edges in image and returns the result as a binary image.\nEdgeDetect[image, r] finds edges at the scale of the specified pixel range r.\nEdgeDetect[image, r, t] uses a threshold t for selecting image edges." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeDetect)))
(def EdgeForm "EdgeForm[g] is a graphics directive that specifies that edges of polygons and other filled graphics objects are to be drawn using the graphics directive or list of directives g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeForm)))
(def EdgeIndex "EdgeIndex[g, e] gives the integer index for the edge e in the graph g.\nEdgeIndex[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeIndex)))
(def EdgeLabelStyle "EdgeLabelStyle is an option and property for Graph and related functions that specifies the style to use for edge labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeLabelStyle)))
(def EdgeLabels "EdgeLabels is an option and annotation for Graph and related functions that specifies what labels and label positions should be used for edges." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeLabels)))
(def EdgeList "EdgeList[g] gives the list of edges for the graph g.\nEdgeList[g, patt] gives a list of edges that match the pattern patt.\nEdgeList[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeList)))
(def EdgeQ "EdgeQ[g, e] yields True if e is an edge in the graph g and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeQ)))
(def EdgeRules "EdgeRules[g] gives the list of edge rules for the graph g.\nEdgeRules[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeRules)))
(def EdgeShapeFunction "EdgeShapeFunction is an option and annotation for Graph and related functions that specifies a function to use to generate primitives for rendering each edge." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeShapeFunction)))
(def EdgeStyle "EdgeStyle is an option and annotation for Graph and related functions that specifies what style to use for edges." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeStyle)))
(def EdgeTaggedGraph "EdgeTaggedGraph[{e1, e2, …}] yields a graph with edges ej tagged with unique tags.\nEdgeTaggedGraph[{e1, e2, …}{t1, t2, …}] yields a graph with edges ej tagged with tj.\nEdgeTaggedGraph[{v1, v2, …}, {e1, e2, …}{t1, t2, …}] yields a graph with vertices vi and edges ej tagged with tj.\nEdgeTaggedGraph[{…, wi[vi], …}, {…, wj[ej], …}{t1, t2, …}] yields a graph with vertex and edge annotations defined by the symbolic wrappers wk." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeTaggedGraph)))
(def EdgeTaggedGraphQ "EdgeTaggedGraphQ[g] yields True if the graph g has edges tagged and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeTaggedGraphQ)))
(def EdgeTags "EdgeTags[g] gives the list of tags for all edges in the graph g.\nEdgeTags[g, {u, v}] gives the list of tags for edges between u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeTags)))
(def EdgeTransitiveGraphQ "EdgeTransitiveGraphQ[g] yields True if the graph g is a edge-transitive graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeTransitiveGraphQ)))
(def EdgeValueRange "EdgeValueRange is an option for GeoGraphValuePlot that specifies the range of edge values to include in a plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeValueRange)))
(def EdgeValueSizes "EdgeValueSizes is an option for GeoGraphValuePlot that specifies the thicknesses used to show edge values in a plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeValueSizes)))
(def EdgeWeight "EdgeWeight is an option and annotation for Graph and related functions that specifies an edge weight." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeWeight)))
(def EdgeWeightedGraphQ "EdgeWeightedGraphQ[g] yields True if the graph g is an edge-weighted graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EdgeWeightedGraphQ)))
(def EditDistance "EditDistance[u, v] gives the edit or Levenshtein distance between strings or vectors u and v.\nEditDistance[u, v] gives the edit or Levenshtein distance between strings, vectors or biomolecular sequences u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EditDistance)))
(def Editable "Editable is an option for displayed objects, cells, and notebooks that specifies whether their contents can be edited interactively using the front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Editable)))
(def EffectiveInterest "EffectiveInterest[r, q] gives the effective interest rate corresponding to interest specification r, compounded at time intervals q." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EffectiveInterest)))
(def Eigensystem "Eigensystem[m] gives a list {values, vectors} of the eigenvalues and eigenvectors of the square matrix m. \nEigensystem[{m, a}] gives the generalized eigenvalues and eigenvectors of m with respect to a. \nEigensystem[m, k] gives the eigenvalues and eigenvectors for the first k eigenvalues of m. \nEigensystem[{m, a}, k] gives the first k generalized eigenvalues and eigenvectors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Eigensystem)))
(def Eigenvalues "Eigenvalues[m] gives a list of the eigenvalues of the square matrix m. \nEigenvalues[{m, a}] gives the generalized eigenvalues of m with respect to a. \nEigenvalues[m, k] gives the first k eigenvalues of m. \nEigenvalues[{m, a}, k] gives the first k generalized eigenvalues." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Eigenvalues)))
(def EigenvectorCentrality "EigenvectorCentrality[g] gives a list of eigenvector centralities for the vertices in the graph g.\nEigenvectorCentrality[g, \"In\"] gives a list of in-centralities for a directed graph g.\nEigenvectorCentrality[g, \"Out\"] gives a list of out-centralities for a directed graph g.\nEigenvectorCentrality[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EigenvectorCentrality)))
(def Eigenvectors "Eigenvectors[m] gives a list of the eigenvectors of the square matrix m. \nEigenvectors[{m, a}] gives the generalized eigenvectors of m with respect to a. \nEigenvectors[m, k] gives the first k eigenvectors of m. \nEigenvectors[{m, a}, k] gives the first k generalized eigenvectors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Eigenvectors)))
(def ElectricCurrentDensityValue "ElectricCurrentDensityValue[pred, vars, pars] represents a current density boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nElectricCurrentDensityValue[pred, vars, pars, lkey] represents a current density boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectricCurrentDensityValue)))
(def ElectricCurrentPDEComponent "ElectricCurrentPDEComponent[vars, pars] yields an electric current PDE term with variables vars and parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectricCurrentPDEComponent)))
(def ElectricFluxDensityValue "ElectricFluxDensityValue[pred, vars, pars] represents an electric flux density boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nElectricFluxDensityValue[pred, vars, pars, lkey] represents an electric flux density boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectricFluxDensityValue)))
(def ElectricPotentialCondition "ElectricPotentialCondition[pred, vars, pars] represents an electric potential surface boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nElectricPotentialCondition[pred, vars, pars, lkey] represents an electric potential surface boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectricPotentialCondition)))
(def ElectricSymmetryValue "ElectricSymmetryValue[pred, vars, pars] represents an electric symmetry boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nElectricSymmetryValue[pred, vars, pars, lkey] represents an electric symmetry boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectricSymmetryValue)))
(def ElectrostaticPDEComponent "ElectrostaticPDEComponent[vars, pars] yields an electrostatic PDE term with variables vars and parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElectrostaticPDEComponent)))
(def Element "Element[x, dom] or x∈dom asserts that x is an element of the domain dom. \nElement[x, reg] or x∈reg asserts that x is an element of the region reg.\nElement[x1|x2|…, dom] asserts that all the xi are elements of dom. \nElement[patt, dom] asserts that any expression matching the pattern patt is an element of dom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Element)))
(def ElementData "ElementData[\"name\", \"property\"] gives the value of the specified property for the chemical element \"name\".\nElementData[n, \"property\"] gives the specified property for the n ^th chemical element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElementData)))
(def ElementwiseLayer "ElementwiseLayer[f] represents a net layer that applies a unary function f to every element of the input array.\nElementwiseLayer[\"name\"] applies the function specified by \"name\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElementwiseLayer)))
(def ElidedForms "ElidedForms is an option to TextString and related functions that specifies which expressions should be elided." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ElidedForms)))
(def Eliminate "Eliminate[eqns, vars] eliminates variables between a set of simultaneous equations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Eliminate)))
(def Ellipsoid "Ellipsoid[p, {r1, …}] represents an axis-aligned ellipsoid centered at the point p and with semiaxes lengths ri.\nEllipsoid[p, Σ] represents an ellipsoid centered at p and weight matrix Σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Ellipsoid)))
(def EllipticE "EllipticE[m] gives the complete elliptic integral E (m). \nEllipticE[ϕ, m] gives the elliptic integral of the second kind E (ϕm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticE)))
(def EllipticExp "EllipticExp[u, {a, b}] is the inverse for EllipticLog. It produces a list {x, y} such that u==EllipticLog[{x, y}, {a, b}]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticExp)))
(def EllipticExpPrime "EllipticExpPrime[u, {a, b}] gives the derivative of EllipticExp[u, {a, b}] with respect to u." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticExpPrime)))
(def EllipticF "EllipticF[ϕ, m] gives the elliptic integral of the first kind F (ϕm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticF)))
(def EllipticFilterModel "EllipticFilterModel[n] designs a lowpass elliptic filter of order n.\nEllipticFilterModel[{n, ωc}] uses the cutoff frequency ωc.\nEllipticFilterModel[{\"type\", spec}] designs an elliptic filter of the specified type \"type\", using the spec.\nEllipticFilterModel[{\"type\", spec}, var] expresses the model in terms of the variable var." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticFilterModel)))
(def EllipticK "EllipticK[m] gives the complete elliptic integral of the first kind K (m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticK)))
(def EllipticLog "EllipticLog[{x, y}, {a, b}] gives the generalized logarithm associated with the elliptic curve y^2=x^3+a x^2+b x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticLog)))
(def EllipticNomeQ "EllipticNomeQ[m] gives the nome q corresponding to the parameter m in an elliptic function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticNomeQ)))
(def EllipticPi "EllipticPi[n, m] gives the complete elliptic integral of the third kind Π (nm). \nEllipticPi[n, ϕ, m] gives the incomplete elliptic integral Π (n;ϕm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticPi)))
(def EllipticTheta "EllipticTheta[a, u, q] gives the theta function ϑa(u, q) (a=1, …, 4).\nEllipticTheta[a, q] gives the theta constant ϑa(q)ϑa (0, q)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticTheta)))
(def EllipticThetaPrime "EllipticThetaPrime[a, u, q] gives the derivative with respect to u of the theta function ϑa(u, q) (a=1, …, 4).\nEllipticThetaPrime[a, q] gives the theta constant ϑ_a^′(0, q)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EllipticThetaPrime)))
(def EmbedCode "EmbedCode[obj] generates the code necessary to embed the object obj on a webpage.\nEmbedCode[obj, \"dest\"] generates code for an external environment or language of type \"dest\".\nEmbedCode[obj, \"dest\", dir] saves the generated code as files in the directory dir.\nEmbedCode[obj, \"dest\", loc] saves the generated code as a file archive in the file location loc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbedCode)))
(def EmbeddedHTML "EmbeddedHTML[\"string\"] is an object that formats as a web frame containing the HTML content \"string\". \nEmbeddedHTML[URL[\"url\"]] formats as a rendering of the webpage corresponding to the specified URL.\nEmbeddedHTML[CloudObject[…]] formats as a web rendering of the specified cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbeddedHTML)))
(def EmbeddedSQLEntityClass "EmbeddedSQLEntityClass[string, props] represents a verbatim SQL query to be interpreted as an entity class with properties given by props.\nEmbeddedSQLEntityClass[template, props, args] represents an SQL query string template with arguments provided by args." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbeddedSQLEntityClass)))
(def EmbeddedSQLExpression "EmbeddedSQLExpression[string] represents an SQL expression to be evaluated verbatim within an EntityFunction object.\nEmbeddedSQLExpression[template, args] represents an SQL expression string template with arguments provided by args." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbeddedSQLExpression)))
(def EmbeddedService "EmbeddedService[service] is an object that formats as a web frame containing content from the specified external service." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbeddedService)))
(def EmbeddingLayer "EmbeddingLayer[size, n] represents a trainable net layer that embeds integers between 1 and n into a continuous vector space of dimension size.\nEmbeddingLayer[size] leaves the n to be inferred from context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmbeddingLayer)))
(def EmitSound "EmitSound[snd] emits the sound snd when evaluated. \nEmitSound[{snd1, snd2, …}] emits each of the sounds sndi in sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmitSound)))
(def EmpiricalDistribution "EmpiricalDistribution[{x1, x2, …}] represents an empirical distribution based on the data values xi.\nEmpiricalDistribution[{{x1, y1, …}, {x2, y2, …}, …}] represents a multivariate empirical distribution based on the data values {xi, yi, …}.\nEmpiricalDistribution[{w1, w2, …}{d1, d2, …}] represents an empirical distribution where data values di occur with weights wi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmpiricalDistribution)))
(def EmptyGraphQ "EmptyGraphQ[g] yields True if g is an empty graph and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmptyGraphQ)))
(def EmptyRegion "EmptyRegion[n] represents the empty subset of ^n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmptyRegion)))
(def EmptySpaceF "EmptySpaceF[pdata, r] estimates the empty space function F(r) for point data pdata at radius r.\nEmptySpaceF[pproc, r] computes F(r) for point process pproc.\nEmptySpaceF[bdata, r] computes F(r) for binned data bdata. \nEmptySpaceF[pspec] generates the function F that can be applied repeatedly to different radii r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EmptySpaceF)))
(def Enabled "Enabled is an option for objects such as Slider that specifies whether the objects should be enabled for interactive manipulation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Enabled)))
(def Enclose "Enclose[expr] attempts to evaluate expr and return the result, but stops if it catches an error and returns a failure object. \nEnclose[expr, f] applies f to any failure object generated.\nEnclose[expr, \"prop\"] gives the property prop of any failure object generated. \nEnclose[expr, handler, form] only catches errors with explicitly specified tags matching form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Enclose)))
(def Encode "Encode[\"source\", \"dest\"] writes an encoded version of the file source to the file dest. \n<<dest decodes the file before reading its contents. \nEncode[\"source\", \"dest\", \"key\"] produces an encoded file that must be read in using Get[\"dest\", \"key\"]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Encode)))
(def Encrypt "Encrypt[\"password\", expr] encrypts expr using the specified password, to give an encrypted object.\nEncrypt[keyspec, expr] encrypts expr using the cryptographic key specification keyspec.\nEncrypt[expr] interactively requests a password with which to encrypt expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Encrypt)))
(def EncryptFile "EncryptFile[\"password\", file] generates an encrypted version of a file, using the specified password.\nEncryptFile[\"password\", source, target] generates an encrypted version of source, putting the result in target.\nEncryptFile[keyspec, source, …] encrypts using the cryptographic key specification keyspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EncryptFile)))
(def EncryptedObject "EncryptedObject[assoc] represents encrypted data generated by Encrypt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EncryptedObject)))
(def End "End[] returns the present context, and reverts to the previous one." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote End)))
(def EndDialogPacket "EndDialogPacket[integer] is a WSTP packet indicating the end of the Dialog subsession referenced by integer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndDialogPacket)))
(def EndOfBuffer "EndOfBuffer is a symbol that represents the end of currently available data in the buffer for a process or stream." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndOfBuffer)))
(def EndOfFile "EndOfFile is a symbol returned by Read when it reaches the end of a file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndOfFile)))
(def EndOfLine "EndOfLine represents the end of a line in a string for purposes of matching in StringExpression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndOfLine)))
(def EndOfString "EndOfString represents the end of a string for purposes of matching in StringExpression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndOfString)))
(def EndPackage "EndPackage[] restores $Context and $ContextPath to their values before the preceding BeginPackage, and prepends the current context to the list $ContextPath." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EndPackage)))
(def EngineeringForm "EngineeringForm[expr] prints with all real numbers in expr given in engineering notation. \nEngineeringForm[expr, n] prints with numbers given to n‐digit precision." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EngineeringForm)))
(def EnterExpressionPacket "EnterExpressionPacket[expr] is a WSTP packet that requests the evaluation of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EnterExpressionPacket)))
(def EnterTextPacket "EnterTextPacket[string] is a WSTP packet that requests the parsing and evaluation of string as an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EnterTextPacket)))
(def Entity "Entity[\"type\", name] represents an entity of the specified type, identified by name.\nEntity[cspec, name] represents an entity from the computed class, specified by cspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Entity)))
(def EntityClass "EntityClass[type, name] represents a class of entities of the specified type identified by name.\nEntityClass[type, {property1vspec1, property2vspec2, …}] represents an implicitly defined entity class containing entities of the specified type for which the properties propertyi conform to the value selector vspeci.\nEntityClass[cspec, psel] represents an entity class with members specified by cspec, selected by the property selector psel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityClass)))
(def EntityClassList "EntityClassList[\"type\"] gives a list of entity classes for the specified type of entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityClassList)))
(def EntityCopies "EntityCopies[entity, n] represents n copies of entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityCopies)))
(def EntityFunction "EntityFunction[x, body] is a function with a single formal parameter x, to be used in EntityValue and related functions.\nEntityFunction[{x1, x2, …}, body] is an EntityFunction with a list of formal parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityFunction)))
(def EntityGroup "EntityGroup[{entity1, entity2, …}] represents a group of entities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityGroup)))
(def EntityInstance "EntityInstance[entity, qualval] represents an entity whose qualifier qual has value val.\nEntityInstance[entity, {qual1val1, qual2val2, …}] represents an entity whose qualifiers quali have values vali.\nEntityInstance[entity, quantity] represents an entity qualified by quantity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityInstance)))
(def EntityList "EntityList[class] gives a list of entities in the specified entity class. \nEntityList[\"type\"] gives a list of entities of the specified type.\nEntityList[class, simplify] gives a list of entities; simplify determines whether to reduce entities to the simplest possible type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityList)))
(def EntityPrefetch "EntityPrefetch[\"type\"] fetches cacheable values associated with all entities of the specified type.\nEntityPrefetch[EntityProperty[\"type\", \"prop\"]] fetches all values for the specified property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityPrefetch)))
(def EntityProperties "EntityProperties[type] lists properties associated with entity type type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityProperties)))
(def EntityProperty "EntityProperty[type, pname] represents a property identified by pname for use in EntityValue.\nEntityProperty[class, pname] represents a property introduced by the computed entity class class.\nEntityProperty[type, pname, {qual1val1, qual2val2, …}] represents a property modified by the qualifier rules qualivali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityProperty)))
(def EntityPropertyClass "EntityPropertyClass[type, pcname] represents a class of properties identified by the name pcname." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityPropertyClass)))
(def EntityRegister "EntityRegister[estore] registers the entities in the entity store estore so that they can be accessed directly using Entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityRegister)))
(def EntityStore "EntityStore[\"type\"] represents an empty entity store for entities of type \"type\".\nEntityStore[\"type\"->data] represents an entity store for entities of type \"type\" with properties and values defined by data.\nEntityStore[{tspec1, tspec2, …}] represents an entity store for entities of multiple types.\nEntityStore[RelationalDatabase[…]] constructs an entity store from the schema of an external database.\nEntityStore[{tspec1, tspec2, ...}, dbspec] constructs an entity store by mapping table names in the database specified by dbspec to types as specified by the tspeci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityStore)))
(def EntityStores "EntityStores[] gives a list of all registered entity stores that are accessed when Entity is used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityStores)))
(def EntityType "EntityType[\"type\"] represents an entity type with the specified name.\nEntityType[\"type\"->child1->child2->…] represents a child entity type of \"type\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityType)))
(def EntityTypeName "EntityTypeName[entity] gives the name of the entity type of entity.\nEntityTypeName[{entity1, …, entityn}] gives the name of the entity type for entity1 through entityn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityTypeName)))
(def EntityUnregister "EntityUnregister[\"type\"] unregisters all entities in the first entity store that defines entities of the specified type.\nEntityUnregister[store] unregisters all entities in the specified entity store." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityUnregister)))
(def EntityValue "EntityValue[entity, property] gives the value of the specified property for the given entity.\nEntityValue[{entity1, entity2, …}, property] gives the list of values of the specified property for each of the entityi.\nEntityValue[class, property] gives the list of values of the specified property for all entities in the specified class.\nEntityValue[entity, {property1, property2, …}] gives the list of values of the propertyi for the specified entity.\nEntityValue[ents, {property1, property2, …}] gives the list of values of the propertyi for each of the entities represented by ents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntityValue)))
(def Entropy "Entropy[list] gives the base  information entropy of the values in list.\nEntropy[k, list] gives the base k information entropy." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Entropy)))
(def EntropyFilter "EntropyFilter[data, r] filters data by replacing every value by the entropy value in its range-r neighborhood.\nEntropyFilter[data, {r1, r2, …}] uses ri for filtering the i ^th dimension in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EntropyFilter)))
(def Environment "Environment[\"var\"] gives the value of an operating system environment variable." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Environment)))
(def Epilog "Epilog is an option for graphics functions that gives a list of graphics primitives to be rendered after the main part of the graphics is rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Epilog)))
(def EpilogFunction "EpilogFunction is an option for DocumentGenerator allowing arbitrary code to be executed after a document is generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EpilogFunction)))
(def Equal "lhs==rhs returns True if lhs and rhs are identical." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Equal)))
(def EqualTilde "EqualTilde[x, y, …] displays as x≂y≂…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EqualTilde)))
(def EqualTo "EqualTo[y] is an operator form that yields x==y when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EqualTo)))
(def Equilibrium "Equilibrium[x, y, …] displays as x⇌y⇌…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Equilibrium)))
(def EquirippleFilterKernel "EquirippleFilterKernel[{{{ω L1, ω R1}, {ω L2, ω R2}, …}, {a1, a2, …}}, n] creates a finite impulse response (FIR) filter kernel of length n with an equiripple amplitude response, given the specified left and right band edge frequencies {ωLi, ωRi} and amplitudes ai.\nEquirippleFilterKernel[{{{ω L1, ω R1}, {ω L2, ω R2}, …}, {a1, a2, …}, {w1, …}}, n] uses relative weights wi for each frequency band.\nEquirippleFilterKernel[{\"type\", {{{ω L1, ω R1}, …}, …}}, n] creates a filter of the specified \"type\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EquirippleFilterKernel)))
(def Equivalent "Equivalent[e1, e2, …] represents the logical equivalence e1⇔e2⇔…, giving True when all of the ei are the same." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Equivalent)))
(def Erf "Erf[z] gives the error function erf (z). \nErf[z0, z1] gives the generalized error function erf(z1)-erf (z0)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Erf)))
(def Erfc "Erfc[z] gives the complementary error function erfc (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Erfc)))
(def Erfi "Erfi[z] gives the imaginary error function erf (iz)/i." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Erfi)))
(def ErlangB "ErlangB[c, a] computes the Erlang B loss probability for an M/M/c/c queue." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ErlangB)))
(def ErlangC "ErlangC[c, a] computes the Erlang C probability for nonzero waiting time in an M/M/c queue." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ErlangC)))
(def ErlangDistribution "ErlangDistribution[k, λ] represents the Erlang distribution with shape parameter k and rate λ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ErlangDistribution)))
(def Erosion "Erosion[image, ker] gives the morphological erosion of image with respect to the structuring element ker.\nErosion[image, r] gives the erosion with respect to a range-r square.\nErosion[data, …] applies erosion to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Erosion)))
(def ErrorBox "ErrorBox[boxes] is a low-level box construct that represents boxes that cannot be interpreted in input or output." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ErrorBox)))
(def EscapeRadius "EscapeRadius is an option to MandelbrotSetPlot that specifies the criterion to use to decide that a point is not in the Mandelbrot set." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EscapeRadius)))
(def EstimatedBackground "EstimatedBackground[data] estimates the background of data.\nEstimatedBackground[data, σ] tries to preserve peaks up to scale σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedBackground)))
(def EstimatedDistribution "EstimatedDistribution[data, dist] estimates the parametric distribution dist from data.\nEstimatedDistribution[data, dist, {{p, p0}, {q, q0}, …}] estimates the parameters p, q, … with starting values p0, q0, ….\nEstimatedDistribution[data, dist, idist] estimates distribution dist with starting values taken from the instantiated distribution idist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedDistribution)))
(def EstimatedPointNormals "EstimatedPointNormals[{p1, p2, …}] estimates normal vectors for the points p1, p2, ….\nEstimatedPointNormals[mreg] estimates normals vectors for the vertices of the mesh region mreg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedPointNormals)))
(def EstimatedPointProcess "EstimatedPointProcess[pdata, pproc] estimates the parametric point process pproc from point data pdata.\nEstimatedPointProcess[pdata, pproc, {{p, p0}, {q, q0}, …}] estimates the parameters p, q, … with starting values p0, q0, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedPointProcess)))
(def EstimatedProcess "EstimatedProcess[data, proc] estimates the parametric process proc from data.\nEstimatedProcess[data, proc, {{p, p0}, {q, q0}, …}] estimates the parameters p, q, … with starting values p0, q0, ….\nEstimatedProcess[data, proc, iproc] estimates process proc with starting values taken from the instantiated process iproc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedProcess)))
(def EstimatedVariogramModel "EstimatedVariogramModel[{loc1val1, loc2val2, …}] estimates the best variogram function from values vali given at locations loci.\nEstimatedVariogramModel[{loc1, loc2, …}{val1, val2, …}] generates the same result. \nEstimatedVariogramModel[…, \"model\"] estimates the best parameters of the variogram function specified by \"model\". \nEstimatedVariogramModel[…, {\"model\", params}] estimates the non-numeric parameters in params." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatedVariogramModel)))
(def EstimatorGains "EstimatorGains[ssm, {p1, p2, …, pn}] gives the estimator gain matrix for the StateSpaceModel ssm, such that the poles of the estimator are pi.\nEstimatorGains[{ssm, {out1, …}}, …] specifies the measured outputs outi to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatorGains)))
(def EstimatorRegulator "EstimatorRegulator[sspec, {l, κ}] gives the output feedback controller with estimator and regulator gains l and κ for the system specification sspec.\nEstimatorRegulator[…, \"prop\"] gives the value of the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EstimatorRegulator)))
(def EuclideanDistance "EuclideanDistance[u, v] gives the Euclidean distance between vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EuclideanDistance)))
(def EulerAngles "EulerAngles[r] gives Euler angles {α, β, γ} corresponding to the rotation matrix r.\nEulerAngles[r, {a, b, c}] gives Euler angles {α, β, γ} with rotation order {a, b, c}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerAngles)))
(def EulerCharacteristic "EulerCharacteristic[poly] gives the Euler characteristic of a poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerCharacteristic)))
(def EulerE "EulerE[n] gives the Euler number En. \nEulerE[n, x] gives the Euler polynomial En (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerE)))
(def EulerGamma "EulerGamma is Euler’s constant γ, with numerical value ≃0.577216." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerGamma)))
(def EulerMatrix "EulerMatrix[{α, β, γ}] gives the Euler 3D rotation matrix formed by rotating by α around the current z axis, then by β around the current y axis, and then by γ around the current z axis. \nEulerMatrix[{α, β, γ}, {a, b, c}] gives the Euler 3D rotation matrix corresponding, first rotating by α around the current a axis, then by β around the current b axis, and finally by γ around the current c axis." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerMatrix)))
(def EulerPhi "EulerPhi[n] gives the Euler totient function ϕ (n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerPhi)))
(def EulerianGraphQ "EulerianGraphQ[g] yields True if the graph g is Eulerian, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EulerianGraphQ)))
(def Evaluatable "Evaluatable is an option for Cell that specifies whether a cell should be used as input to be evaluated by the Wolfram Language kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Evaluatable)))
(def Evaluate "Evaluate[expr] causes expr to be evaluated even if it appears as the argument of a function whose attributes specify that it should be held unevaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Evaluate)))
(def EvaluatePacket "EvaluatePacket[expr] is a WSTP packet requesting evaluation of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluatePacket)))
(def EvaluationBox "EvaluationBox[] returns a BoxObject corresponding to the box structure in which this function is being evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationBox)))
(def EvaluationCell "EvaluationCell[] returns a CellObject corresponding to the cell in which this function is being evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationCell)))
(def EvaluationData "EvaluationData[expr] gives an association containing the result of evaluating expr and metadata about the process of doing so." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationData)))
(def EvaluationElements "EvaluationElements is an option for NotebookEvaluate that determines which cells to evaluate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationElements)))
(def EvaluationEnvironment "EvaluationEnvironment is an option for functions such as InitializationValue and InitializationObjects that specifies the environment in which an initialization is intended to be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationEnvironment)))
(def EvaluationMonitor "EvaluationMonitor is an option for various numerical computation and plotting functions that gives an expression to evaluate whenever functions derived from the input are evaluated numerically." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationMonitor)))
(def EvaluationNotebook "EvaluationNotebook[] gives the notebook in which this function is being evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationNotebook)))
(def EvaluationObject "EvaluationObject[expr, …] represents an expression submitted for evaluation on any available parallel kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationObject)))
(def EvaluationPrivileges "EvaluationPrivileges is an option for CloudObject and related cloud functions that specifies what other files and cloud objects can be accessed by evaluations associated with the cloud object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluationPrivileges)))
(def Evaluator "Evaluator is an option for objects such as Button, Dynamic, and Cell that gives the name of the kernel to use to evaluate their contents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Evaluator)))
(def EvaluatorNames "EvaluatorNames is a global option that specifies the kernels that are currently configured to perform evaluations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvaluatorNames)))
(def EvenQ "EvenQ[expr] gives True if expr is an even integer, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EvenQ)))
(def EventData "EventData[{e1, e2, …}] represents event data with explicitly specified censoring ei.\nEventData[{e1, e2, …}, {ci1, ci2, …}] represents event data ei with censoring indicators cii.\nEventData[{e1, e2, …}, {cc1, cc2, …}] represents event data ei with censoring counts cci.\nEventData[{e1, e2, …}, cspec, {tr1, tr2, …}] represents event data with censoring and truncation tri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EventData)))
(def EventHandler "EventHandler[expr, {event1:>action1, event2:>action2, …}] displays as expr, evaluating actioni whenever \"eventi\" occurs in connection with expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EventHandler)))
(def EventLabels "EventLabels is an option to CandlestickChart, KagiChart, and similar functions that specifies events to labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EventLabels)))
(def EventSeries "EventSeries[{{t1, v1}, {t2, v2}…}] represents a series of events given as time-value pairs {ti, vi}.\nEventSeries[{v1, v2, …}, tspec] represents a series of events with values vi at times specified by tspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote EventSeries)))
(def ExactBlackmanWindow "ExactBlackmanWindow[x] represents an exact Blackman window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExactBlackmanWindow)))
(def ExactNumberQ "ExactNumberQ[expr] returns True if expr is an exact real or complex number, and returns False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExactNumberQ)))
(def ExampleData "ExampleData[\"type\"] gives a list of names of examples of the specified type.\nExampleData[{\"type\", \"name\"}] gives the default form of the named example of the specified type.\nExampleData[{\"type\", \"name\"}, \"elem\"] gives the specified element or property of an example." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExampleData)))
(def Except "Except[c] is a pattern object which represents any expression except one that matches c. \nExcept[c, p] represents any expression that matches p but not c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Except)))
(def ExcludePods "ExcludePods is an option to WolframAlpha that specifies pod IDs to exclude from the results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExcludePods)))
(def ExcludedContexts "ExcludedContexts is an option for FullDefinition, Manipulate and related symbols that gives contexts whose symbols will not have the definitions recursively saved." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExcludedContexts)))
(def ExcludedForms "ExcludedForms is an option that gives a list of patterns for expressions that should be excluded from an operation performed by a particular function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExcludedForms)))
(def ExcludedLines "ExcludedLines is an option for SemanticImport and related functions that specifies which lines should be ignored for further processing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExcludedLines)))
(def ExcludedPhysicalQuantities "ExcludedPhysicalQuantities is an option for FormulaLookup that specifies physical quantities that should be not used by the formulas returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExcludedPhysicalQuantities)))
(def Exclusions "Exclusions is an option that specifies where to exclude in regions used by functions like Plot, Plot3D, and NIntegrate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Exclusions)))
(def ExclusionsStyle "ExclusionsStyle is an option to plotting functions that specifies how to render subregions excluded according to Exclusions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExclusionsStyle)))
(def Exists "Exists[x, expr] represents the statement that there exists a value of x for which expr is True. \nExists[x, cond, expr] states that there exists an x satisfying the condition cond for which expr is True. \nExists[{x1, x2, …}, expr] states that there exist values for all the xi for which expr is True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Exists)))
(def Exit "Exit[] terminates a Wolfram Language kernel session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Exit)))
(def ExoplanetData "ExoplanetData[entity, property] gives the value of the specified property for the exoplanet entity.\nExoplanetData[{entity1, entity2, …}, property] gives a list of property values for the specified exoplanet entities.\nExoplanetData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExoplanetData)))
(def Exp "Exp[z] gives the exponential of z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Exp)))
(def ExpGammaDistribution "ExpGammaDistribution[κ, θ, μ] represents an exp-gamma distribution with shape parameter κ, scale parameter θ, and location parameter μ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpGammaDistribution)))
(def ExpIntegralE "ExpIntegralE[n, z] gives the exponential integral function En (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpIntegralE)))
(def ExpIntegralEi "ExpIntegralEi[z] gives the exponential integral function Ei (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpIntegralEi)))
(def ExpToTrig "ExpToTrig[expr] converts exponentials in expr to trigonometric functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpToTrig)))
(def Expand "Expand[expr] expands out products and positive integer powers in expr. \nExpand[expr, patt] leaves unexpanded any parts of expr that are free of the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Expand)))
(def ExpandAll "ExpandAll[expr] expands out all products and integer powers in any part of expr. \nExpandAll[expr, patt] avoids expanding parts of expr that do not contain terms matching the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpandAll)))
(def ExpandDenominator "ExpandDenominator[expr] expands out products and powers that appear as denominators in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpandDenominator)))
(def ExpandFileName "ExpandFileName[\"name\"] textually expands name to have the form of an absolute file name for your operating system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpandFileName)))
(def ExpandNumerator "ExpandNumerator[expr] expands out products and powers that appear in the numerator of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpandNumerator)))
(def Expectation "Expectation[expr, xdist] gives the expectation of expr under the assumption that x follows the probability distribution dist. \nExpectation[expr, xdata] gives the expectation of expr under the assumption that x follows the probability distribution given by data.\nExpectation[expr, {x1, x2, …}dist] gives the expectation of expr under the assumption that {x1, x2, …} follows the multivariate distribution dist. \nExpectation[expr, {x1dist1, x2dist2, …}] gives the expectation of expr under the assumption that x1, x2, … are independent and follow the distributions dist1, dist2, …. \nExpectation[exprpred, …] gives the conditional expectation of expr given pred." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Expectation)))
(def ExpirationDate "ExpirationDate is an option for various functions that specifies when a persistent value should be treated as expired." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpirationDate)))
(def Exponent "Exponent[expr, form] gives the maximum power with which form appears in the expanded form of expr. \nExponent[expr, form, h] applies h to the set of exponents with which form appears in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Exponent)))
(def ExponentFunction "ExponentFunction is an option for NumberForm and related functions that determines the exponent to use in printing approximate real numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentFunction)))
(def ExponentStep "ExponentStep is an option for NumberForm and related functions that determines in what steps exponents are taken to increase when scientific notation is used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentStep)))
(def ExponentialDistribution "ExponentialDistribution[λ] represents an exponential distribution with scale inversely proportional to parameter λ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentialDistribution)))
(def ExponentialFamily "ExponentialFamily is an option for GeneralizedLinearModelFit that specifies the exponential family for the model." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentialFamily)))
(def ExponentialGeneratingFunction "ExponentialGeneratingFunction[expr, n, x] gives the exponential generating function in x for the sequence whose n ^th term is given by the expression expr.\nExponentialGeneratingFunction[expr, {n1, n2, …}, {x1, x2, …}] gives the multidimensional exponential generating function in x1, x2, … whose n1, n2, … term is given by expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentialGeneratingFunction)))
(def ExponentialMovingAverage "ExponentialMovingAverage[list, α] gives the exponential moving average of list with smoothing constant α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentialMovingAverage)))
(def ExponentialPowerDistribution "ExponentialPowerDistribution[κ, μ, σ] represents an exponential power distribution with shape parameter κ, location parameter μ, and scale parameter σ.\nExponentialPowerDistribution[κ] represents an exponential power distribution with location parameter 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExponentialPowerDistribution)))
(def Export "Export[\"dest.ext\", expr] exports data to a file, converting it to the format corresponding to the file extension ext. \nExport[dest, expr, \"fmt\"] exports data in the specified format \"fmt\".\nExport[dest, exprs, elements] exports data by treating exprs as elements.\nExport[dest, exprs, elements, options] uses the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Export)))
(def ExportByteArray "ExportByteArray[expr, \"format\"] generates a ByteArray object corresponding to expr exported in the specified format. \nExportByteArray[exprs, elems] generates a ByteArray object by treating exprs as elements specified by elems." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExportByteArray)))
(def ExportForm "ExportForm[expr, \"fmt\"] specifies that expr should be exported in the specified format in functions like CloudDeploy and in external results from APIFunction and FormFunction.\nExportForm[expr, {\"fmt\", \"type\"}] specifies that when expr is exported, it should be tagged as having the specified MIME type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExportForm)))
(def ExportString "ExportString[expr, \"format\"] generates a string corresponding to expr exported in the specified format. \nExportString[rules, {\"format\", \"Rules\"}] gives explicit rules for different elements of the data to be exported. \nExportString[exprs, elems] generates a string by treating exprs as elements specified by elems." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExportString)))
(def Expression "Expression is a symbol that represents an ordinary Wolfram Language expression in Read and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Expression)))
(def ExpressionCell "ExpressionCell[expr] gives an expression cell that can appear in a Wolfram System notebook.\nExpressionCell[expr, \"style\"] gives an expression cell with the specified style.\nExpressionCell[expr, style1, style2, …] gives an expression cell with multiple styles applied to it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpressionCell)))
(def ExpressionGraph "ExpressionGraph[expr] gives the tree graph with different levels at different depths. \nExpressionGraph[expr, n] gives the tree graph only down to level n.\nExpressionGraph[expr, n, form] gives a tree graph in which subexpressions that match form are leaves." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpressionGraph)))
(def ExpressionTree "ExpressionTree[expr] gives a Tree object from the structure of the expression expr.\nExpressionTree[expr, struct] gives a Tree object from the expression expr with data and subtrees as specified by struct." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpressionTree)))
(def ExpressionUUID "ExpressionUUID is an option for Cell and Notebook that holds the assigned unique UUID string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExpressionUUID)))
(def ExtendedEntityClass "ExtendedEntityClass[class, \"name\"->f] represents an entity class derived from class by adding a new computed property \"name\" whose value for each entity is obtained by applying the entity function f.\nExtendedEntityClass[class, {name1->f1, name2->f2, …}] adds the properties namei defined by the functions fi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtendedEntityClass)))
(def ExtendedGCD "ExtendedGCD[n1, n2, …] gives the extended greatest common divisor of the integers ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtendedGCD)))
(def Extension "Extension is an option for various polynomial and algebraic functions that specifies generators for the algebraic number field to be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Extension)))
(def ExtentElementFunction "ExtentElementFunction is an option to DiscretePlot and DiscretePlot3D that gives a function to use to generate the primitives for rendering each extent element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtentElementFunction)))
(def ExtentMarkers "ExtentMarkers is an option to DiscretePlot and DiscretePlot3D that specifies markers to draw at extent boundaries." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtentMarkers)))
(def ExtentSize "ExtentSize is an option to DiscretePlot and DiscretePlot3D that specifies how far to extend out from each plot point." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtentSize)))
(def ExternalBundle "ExternalBundle[{name1obj1, name2obj2, …}] represents a bundle of resources to be externally deployed as named URLs, functions, etc. \nExternalBundle[{name11{name1…, …}, …}] represents a nested bundle of resources." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalBundle)))
(def ExternalEvaluate "ExternalEvaluate[\"sys\", \"cmd\"] evaluates the command cmd in the external evaluator sys, returning an expression corresponding to the output.\nExternalEvaluate[{\"sys\", opts}, \"cmd\"] uses the options opts for the external evaluator.\nExternalEvaluate[assoc, \"cmd\"] evaluates cmd using the external evaluator specified by assoc.\nExternalEvaluate[session, \"cmd\"] evaluates cmd in the specified running ExternalSessionObject.\nExternalEvaluate[sys\"type\", …] returns output converted to the specified type. \nExternalEvaluate[spec, obj] evaluates the content of the specified ExternalObject, ExternalOperation, File, URL or CloudObject.\nExternalEvaluate[spec, assoc] evaluates the command specified by assoc.\nExternalEvaluate[spec, {cmd1, cmd2, …}] evaluates the list of commands cmdi.\nExternalEvaluate[DatabaseReference[ref], \"cmd\"] evaluates cmd using the database specified by ref.\nExternalEvaluate[spec] represents an operator form of ExternalEvaluate that can be applied to a command or object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalEvaluate)))
(def ExternalFunction "ExternalFunction[sys, \"f\"] represents an external function named \"f\" defined in the external evaluator sys.\nExternalFunction[session, \"f\"] represents an external function \"f\" in the specified ExternalSessionObject.\nExternalFunction[sys, \"code\"] represents an external function defined by the code fragment \"code\".\nExternalFunction[obj, \"method\"] represents a method bound to the ExternalObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalFunction)))
(def ExternalIdentifier "ExternalIdentifier[\"type\", id] represents a resource identified by id in the external identifier system \"type\".\nExternalIdentifier[\"type\", id, meta] includes the metadata given by the association meta to this instance of the external identifier object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalIdentifier)))
(def ExternalObject "ExternalObject[…] represents an external object bound to an ExternalSessionObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalObject)))
(def ExternalOperation "ExternalOperation[\"Eval\", \"code\"] represents an external evaluation of \"code\".\nExternalOperation[\"Eval\", \"code\", assoc] represents an external evaluation of \"code\" with parameters given by assoc.\nExternalOperation[\"Call\", func, arg1, arg2, …] calls the function func with the given arguments arg1, arg2, ….\nExternalOperation[\"GetAttribute\", obj, \"attr\"] gets the attribute \"attr\" of obj.\nExternalOperation[\"SetAttribute\", obj, \"attr\", val] sets the attribute \"attr\" of obj to the given value val.\nExternalOperation[\"Cast\", obj, \"type\"] casts obj to the given \"type\".\nExternalOperation[\"op\", arg1, arg2, …] represents the external operation named \"op\" using arguments arg1, arg2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalOperation)))
(def ExternalOptions "ExternalOptions is an option for EmbedCode and related functions that gives options specific to the external environment or language used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalOptions)))
(def ExternalSessionObject "ExternalSessionObject[…] represents an external session started by StartExternalSession for use with ExternalEvaluate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalSessionObject)))
(def ExternalSessions "ExternalSessions[] gives the list of currently active external evaluator sessions.\nExternalSessions[sys] gives the list of sessions associated with the system sys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalSessions)))
(def ExternalStorageBase "ExternalStorageBase is an option for various external storage functions that specifies which external storage service to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStorageBase)))
(def ExternalStorageDownload "ExternalStorageDownload[location] downloads content from the specified location.\nExternalStorageDownload[location, dest] downloads content from the specified location to a local destination file or directory dest.\nExternalStorageDownload[locationdest] downloads content from the specified locations to a local destination file or directory dest.\nExternalStorageDownload[{location1, location2, …}, dest] downloads content from the specified locations to local destination dest.\nExternalStorageDownload[{location1, location2, …}dest] downloads content from the specified locations to local destination dest.\nExternalStorageDownload[{location1dest1, location2dest2, …}] downloads content from the specified locations to local destinations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStorageDownload)))
(def ExternalStorageGet "ExternalStorageGet[ExternalStorageObject[…]] reads in an expression stored at an external storage specified by the ExternalStorageObject.\nExternalStorageGet[location] reads in an expression stored at location in an external storage specified by $ExternalStorageBase." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStorageGet)))
(def ExternalStorageObject "ExternalStorageObject[location] represents a file stored in an external location.\nExternalStorageObject[assoc] represents a file stored in an external service specified by the components of the association assoc.\nExternalStorageObject[location, assoc] represents a file stored in an external location with additional elements given by assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStorageObject)))
(def ExternalStoragePut "ExternalStoragePut[expr] writes expr to an external storage specified by $ExternalStorageBase.\nExternalStoragePut[expr, path] writes expr to a specific path in an external storage specified by $ExternalStorageBase.\nExternalStoragePut[expr, ExternalStorageObject[...]] writes expr to the service and path represented by an ExternalStorageObject." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStoragePut)))
(def ExternalStorageUpload "ExternalStorageUpload[file] uploads file to an external storage specified by $ExternalStorageBase.\nExternalStorageUpload[file, dest] uploads file to a specific destination dest for external storage services that support it.\nExternalStorageUpload[filedest] uploads file to a specific destination dest for external storage services that support it. \nExternalStorageUpload[{file1, file2, …}, dest] uploads a list of files to a specific destination dest for external storage services that support it.\nExternalStorageUpload[{file1, file2, …}dest] uploads a list of files to a specific destination dest for external storage services that support it.\nExternalStorageUpload[{file1dest1, file2dest2, …}] uploads a list of files to specific destinations for external storage services that support it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalStorageUpload)))
(def ExternalTypeSignature "ExternalTypeSignature is an option for EmbedCode that gives rules specifying the mapping to external types in an embedded code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalTypeSignature)))
(def ExternalValue "ExternalValue[sys, \"sym\"] gives the value of \"sym\" in external evaluator sys. \nExternalValue[session, \"sym\"] gives the value of \"sym\" in the specified external session." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExternalValue)))
(def Extract "Extract[expr, pos] extracts the part of expr at the position specified by pos. \nExtract[expr, {pos1, pos2, …}] extracts a list of parts of expr. \nExtract[expr, pos, h] extracts parts of expr, wrapping each of them with head h before evaluation. \nExtract[pos] represents an operator form of Extract that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Extract)))
(def ExtractArchive "ExtractArchive[source] expands an archive file, saving its content into the current directory.\nExtractArchive[source, dir] saves the content of an archive file into directory dir.\nExtractArchive[source, dir, pattern] extracts only files whose names match pattern." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtractArchive)))
(def ExtractLayer "ExtractLayer[] represents a net layer that takes an array and a position specification as inputs and extracts the specified parts from the array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtractLayer)))
(def ExtractPacletArchive "ExtractPacletArchive[file] extracts the contents of the paclet archive file into the directory in which file resides.\nExtractPacletArchive[file, destdir] extracts the contents of the paclet archive file into destdir." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtractPacletArchive)))
(def ExtremeValueDistribution "ExtremeValueDistribution[α, β] represents an extreme value distribution with location parameter α and scale parameter β.\nExtremeValueDistribution[] represents an extreme value distribution with location parameter 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ExtremeValueDistribution)))
(def FARIMAProcess "FARIMAProcess[{a1, …, ap}, d, {b1, …, bq}, v] represents an autoregressive fractionally integrated moving-average process y(t) such that its d ^th difference is an ARMAProcess[{a1, …, ap}, {b1, …, bq, v].\nFARIMAProcess[{a1, …, ap}, d, {b1, …, bq}, Σ] represents a vector autoregressive fractionally integrated moving-average process (y1(t), … , yn(t)) such that its (d, …, d)^th difference is a vector ARMAProcess.\nFARIMAProcess[{a1, …, ap}, {d1, …, dn}, {b1, …, bq}, Σ] represents a vector autoregressive fractionally integrated moving-average process (y1(t), … , yn(t)) such that its (d1, …, dn)^th difference is a vector ARMAProcess." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FARIMAProcess)))
(def FRatioDistribution "FRatioDistribution[n, m] represents an F-ratio distribution with n numerator and m denominator degrees of freedom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FRatioDistribution)))
(def FaceAlign "FaceAlign[image] attempts to find faces in image and align them.\nFaceAlign[image, fref] gives aligned faces according to the face reference fref. \nFaceAlign[image, fref, size] gives aligned faces of the specified size.\nFaceAlign[{image1, image2, …}, …] gives a list of aligned faces for all imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FaceAlign)))
(def FaceForm "FaceForm[g] is a graphics directive which specifies that faces of polygons and other filled graphics objects are to be drawn using the graphics directive or list of directives g. \nFaceForm[g, gback] specifies that the front faces of three-dimensional polygons should be drawn with directives g, and the backs with directives gback." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FaceForm)))
(def FaceGrids "FaceGrids is an option for three-dimensional graphics functions that specifies grid lines to draw on the faces of the bounding box." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FaceGrids)))
(def FaceGridsStyle "FaceGridsStyle is an option for 3D graphics functions that specifies how face grids should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FaceGridsStyle)))
(def FaceRecognize "FaceRecognize[{example1name1, example2name2, …}] generates a ClassifierFunction[…] based on the face examples and names given.\nFaceRecognize[{example1, example2, …}{name1, name2, …}] also generates a ClassifierFunction[…] based on the examples and names given.\nFaceRecognize[name1{example11, …}, name2{example21, …}, …] uses an association of names with their examples.\nFaceRecognize[training, image] attempts to find faces present in an image and classify them with the given training set. \nFaceRecognize[training, image, prop] returns the specified property prop." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FaceRecognize)))
(def FacialFeatures "FacialFeatures[image] returns a minimal summary of facial features for all detected faces in image.\nFacialFeatures[image, features] returns the specified facial features." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FacialFeatures)))
(def Factor "Factor[poly] factors a polynomial over the integers. \nFactor[poly, Modulusp] factors a polynomial modulo the prime p. \nFactor[poly, Extension{a1, a2, …}] factors a polynomial allowing coefficients that are rational combinations of the algebraic numbers ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Factor)))
(def FactorInteger "FactorInteger[n] gives a list of the prime factors of the integer n, together with their exponents. \nFactorInteger[n, k] does partial factorization, pulling out at most k distinct factors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorInteger)))
(def FactorList "FactorList[poly] gives a list of the factors of a polynomial, together with their exponents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorList)))
(def FactorSquareFree "FactorSquareFree[poly] pulls out any multiple factors in a polynomial." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorSquareFree)))
(def FactorSquareFreeList "FactorSquareFreeList[poly] gives a list of square‐free factors of a polynomial, together with their exponents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorSquareFreeList)))
(def FactorTerms "FactorTerms[poly] pulls out any overall numerical factor in poly. \nFactorTerms[poly, x] pulls out any overall factor in poly that does not depend on x. \nFactorTerms[poly, {x1, x2, …}] pulls out any overall factor in poly that does not depend on any of the xi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorTerms)))
(def FactorTermsList "FactorTermsList[poly] gives a list in which the first element is the overall numerical factor in poly, and the second element is the polynomial with the overall factor removed.\nFactorTermsList[poly, {x1, x2, …}] gives a list of factors of poly. The first element in the list is the overall numerical factor. The second element is a factor that does not depend on any of the xi. Subsequent elements are factors which depend on progressively more of the xi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorTermsList)))
(def Factorial "n! gives the factorial of n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Factorial)))
(def Factorial2 "n!! gives the double factorial of n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Factorial2)))
(def FactorialMoment "FactorialMoment[data, r] gives the order r  factorial moment Overscript[μ, _]r of data.\nFactorialMoment[data, {r1, …, rm}] gives the order {r1, …, rm} multivariate factorial moment Overscript[μ, _]r1, …, rm of data.\nFactorialMoment[dist, …] gives the factorial moment of the distribution dist.\nFactorialMoment[r] represents the order r  formal factorial moment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorialMoment)))
(def FactorialMomentGeneratingFunction "FactorialMomentGeneratingFunction[dist, t] gives the factorial moment-generating function for the distribution dist as a function of the variable t. \nFactorialMomentGeneratingFunction[dist, {t1, t2, …}] gives the factorial moment-generating function for the multivariate distribution dist as a function of the variables t1, t2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorialMomentGeneratingFunction)))
(def FactorialPower "FactorialPower[x, n] gives the factorial power x^(n). \nFactorialPower[x, n, h] gives the step-h factorial power x^(n, h)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FactorialPower)))
(def Failure "Failure[\"tag\", assoc] represents a failure of a type indicated by tag, with details given by the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Failure)))
(def FailureAction "FailureAction is an option to Query and related functions that determines what should happen when a failure or message is generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FailureAction)))
(def FailureDistribution "FailureDistribution[bexpr, {{x1, dist1}, {x2, dist2}, …}] represents the failure distribution for a system with events xi having reliability distribution disti where the top event occurs when the Boolean expression bexpr is True and event xi has occurred when xi is True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FailureDistribution)))
(def FailureQ "FailureQ[expr] gives True if expr has head Failure or is equal to $Failed or $Aborted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FailureQ)))
(def False "False is the symbol for the Boolean value false." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote False)))
(def FareySequence "FareySequence[n] generates the Farey sequence of order n.\nFareySequence[n, k] gives the k ^th element of the Farey sequence of order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FareySequence)))
(def FeatureDistance "FeatureDistance[example1, example2, extractor] gives the distance between example1 and example2 in the feature space defined by extractor.\nFeatureDistance[extractor] represents an operator form of FeatureDistance that can be applied to a pair of examples." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureDistance)))
(def FeatureExtract "FeatureExtract[{example1, example2, …}] extracts features for each of the examplei using a feature extractor trained on all the examplei.\nFeatureExtract[examples, extractor] extracts features using the specified feature extractor method.\nFeatureExtract[examples, {extractor1, extractor2, …}] extracts features by applying the extractori in sequence.\nFeatureExtract[examples, specext] uses the extractor methods specified by ext on parts of examples specified by spec. \nFeatureExtract[examples, {spec1ext1, spec2ext2, …}] uses the extractor methods exti on parts of examples specified by the speci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureExtract)))
(def FeatureExtraction "FeatureExtraction[{example1, example2, …}] generates a FeatureExtractorFunction[…] trained from the examples given.\nFeatureExtraction[examples, extractor] uses the specified feature extractor method.\nFeatureExtraction[examples, {extractor1, extractor2, …}] applies the extractori in sequence to generate a feature extractor.\nFeatureExtraction[examples, specext] uses the extractor methods specified by ext on parts of examples specified by spec. \nFeatureExtraction[examples, {spec1ext1, spec2ext2, …}] uses the extractor methods exti on parts of examples specified by the speci.\nFeatureExtraction[examples, extractor, props] gives the feature extraction properties specified by props." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureExtraction)))
(def FeatureExtractor "FeatureExtractor is an option for functions such as Classify that specifies how features should be extracted." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureExtractor)))
(def FeatureExtractorFunction "FeatureExtractorFunction[…] represents a feature extractor function generated by FeatureExtraction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureExtractorFunction)))
(def FeatureImpactPlot "FeatureImpactPlot[model, data] plots the impact of the value of each feature in data on the result of model.\nFeatureImpactPlot[model] estimates the feature impacts using synthetic data.\nFeatureImpactPlot[modelfname, …] plots only the impact of the specified feature fname.\nFeatureImpactPlot[modelfnameclass, …] plots only the impact on the classification class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureImpactPlot)))
(def FeatureNames "FeatureNames is an option for machine learning functions such as Classify or Predict that specifies names to use for elements of input data given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureNames)))
(def FeatureNearest "FeatureNearest[{elem1, elem2, …}, x] gives the list of elemi to which x is nearest in a computed feature space.\nFeatureNearest[{elem1v1, elem2v2, …}, x] gives the vi corresponding to the elemi to which x is nearest.\nFeatureNearest[{elem1, elem2, …}{v1, v2, …}, x] gives the same result.\nFeatureNearest[{elem1, elem2, …}prop, x] gives the property prop for the elemi to which x is nearest.\nFeatureNearest[data, {x1, x2, …}] effectively gives {FeatureNearest[data, x1], FeatureNearest[data, x2], …}.\nFeatureNearest[data, x, n] gives the n nearest elemi to x.\nFeatureNearest[data] generates a NearestFunction[…] that can be applied repeatedly to different x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureNearest)))
(def FeatureSpacePlot "FeatureSpacePlot[{example1, example2, …}] plots features extracted from the examplei as a scatter plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureSpacePlot)))
(def FeatureSpacePlot3D "FeatureSpacePlot3D[{example1, example2, …}] plots features extracted from the examplei as a scatter 3D plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureSpacePlot3D)))
(def FeatureTypes "FeatureTypes is an option for machine learning functions such as Classify or Predict that specifies what feature types to assume for elements of input data given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureTypes)))
(def FeatureValueDependencyPlot "FeatureValueDependencyPlot[model, data] plots the dependency of the result of model on the value of a particular feature in data.\nFeatureValueDependencyPlot[model] estimates the feature value dependency using synthetic data.\nFeatureValueDependencyPlot[modelfname, …] plots only the dependency on the specified feature fname.\nFeatureValueDependencyPlot[modelfnameclass, …] plots only the dependency on the classification class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureValueDependencyPlot)))
(def FeatureValueImpactPlot "FeatureValueImpactPlot[model, data] plots the impact of the value of a given feature in data on the result of model.\nFeatureValueImpactPlot[model] estimates the feature value impact using synthetic data.\nFeatureValueImpactPlot[modelfname, …] plots only the impact of the specified feature fname.\nFeatureValueImpactPlot[modelfnameclass, …] plots only the impact on the classification class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeatureValueImpactPlot)))
(def FeedbackLinearize "FeedbackLinearize[asys] input-output linearizes the AffineStateSpaceModel asys by state transformation and feedback.\nFeedbackLinearize[asys, {z, v}] specifies the new states z and the new control inputs v.\nFeedbackLinearize[asys, {z, v}, \"prop\"] computes the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeedbackLinearize)))
(def FeedbackSector "FeedbackSector is an option to NyquistPlot that specifies the sector limits of the nonlinearity in the feedback." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeedbackSector)))
(def FeedbackSectorStyle "FeedbackSectorStyle is an option to NyquistPlot that specifies the style in which graphics of FeedbackSector should be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeedbackSectorStyle)))
(def FeedbackType "FeedbackType is an option for some control system functions that specifies the feedback type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FeedbackType)))
(def FetalGrowthData "FetalGrowthData[age] returns the values for all properties of fetal development for the specified age of the fetus.\nFetalGrowthData[age, property] returns the value for a property of fetal development for the specified age.\nFetalGrowthData[age, index] returns the values for all properties of fetal development at the specified age and percentile.\nFetalGrowthData[age, property, index] returns the value for a property at the specified age and percentile." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FetalGrowthData)))
(def Fibonacci "Fibonacci[n] gives the Fibonacci number Fn. \nFibonacci[n, x] gives the Fibonacci polynomial Fn (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Fibonacci)))
(def Fibonorial "Fibonorial[n] gives the fibonorial n!F." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Fibonorial)))
(def FieldCompletionFunction "FieldCompletionFunction is an option for InputField that specifies a function to apply to the input field's contents to generate a list of completions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FieldCompletionFunction)))
(def FieldHint "FieldHint is an option for InputField that specifies contents to display when the input field is empty." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FieldHint)))
(def FieldHintStyle "FieldHintStyle is an option for InputField that specifies the style to use for displaying the field hint." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FieldHintStyle)))
(def FieldMasked "FieldMasked is an option to InputField that determines whether to mask user input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FieldMasked)))
(def FieldSize "FieldSize is an option for InputField, PopupMenu, and related functions that specifies the size of the field allowed for input or contents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FieldSize)))
(def File "File[\"path\"] is a symbolic representation of a location in the local file system." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote File)))
(def FileBaseName "FileBaseName[\"file\"] gives the base name for a file without its extension." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileBaseName)))
(def FileByteCount "FileByteCount[file] gives the number of bytes in a file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileByteCount)))
(def FileConvert "FileConvert[source\"dest.ext\"] converts the contents of source to the format defined by the extension ext and writes the result to the file dest.ext. \nFileConvert[source, \"format\"] writes the result to the filename defined by source, but with an extension defined by the specified format.\nFileConvert[source\"dest.ext\", format1format2] takes the contents of source to be in the specified format \"format1\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileConvert)))
(def FileDate "FileDate[\"file\"] gives the date and time at which a file was last modified. \nFileDate[\"file\", \"type\"] gives information on the specified type of date associated with a file." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileDate)))
(def FileExistsQ "FileExistsQ[\"name\"] gives True if the file with the specified name exists, and gives False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileExistsQ)))
(def FileExtension "FileExtension[\"file\"] gives the file extension for a file name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileExtension)))
(def FileFormat "FileFormat[source] attempts to determine what Import format could be used to import the file corresponding to source. \nFileFormat[source, {fmt1, fmt2, …}] returns the first \"fmti\" that can be used to import source." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileFormat)))
(def FileFormatProperties "FileFormatProperties[\"fmt\"] returns an association of properties for the specified format \"fmt\".\nFileFormatProperties[\"fmt\", \"prop\"] returns the property \"prop\" for the format \"fmt\".\nFileFormatProperties[\"fmt\", {prop1, prop2, …}] returns multiple properties." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileFormatProperties)))
(def FileFormatQ "FileFormatQ[source, \"fmt\"] gives True if the file corresponding to source might be imported as format \"fmt\" and gives False otherwise.\nFileFormatQ[source, {fmt1, fmt2, …}] gives True if source might be imported as one of \"fmti\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileFormatQ)))
(def FileHash "FileHash[file] gives an integer hash code for the contents of the specified file.\nFileHash[file, \"type\"] gives an integer hash of the specified type.\nFileHash[file, \"type\", \"format\"] gives a hash code in the specified format.\nFileHash[{file, range}, …] gives the hash code for the specified range of bytes.\nFileHash[{filespec1, filespec2, …}, …] gives the hash codes for a list of files." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileHash)))
(def FileNameDepth "FileNameDepth[\"name\"] gives the number of path elements in the file name \"file\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameDepth)))
(def FileNameDrop "FileNameDrop[\"name\", n] drops the first n path elements in the file name \"name\".\nFileNameDrop[\"name\", -n] drops the last n path elements in the file name \"name\".\nFileNameDrop[\"name\", {m, n}] drops elements m through n in the file name \"name\".\nFileNameDrop[\"name\"] drops the last path element in the file name \"name\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameDrop)))
(def FileNameForms "FileNameForms is an option that specifies the pattern for file names to be selected by a function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameForms)))
(def FileNameJoin "FileNameJoin[{name1, name2, …}] joins the namei together into a file name suitable for your current operating system. \nFileNameJoin[{CloudObject[…], name2, …}] joins the namei to the path in the specified cloud object. \nFileNameJoin[{LocalObject[…], name2, …}] joins the namei to the path in the specified local object.\nFileNameJoin[name1, name2, …] is equivalent to FileNameJoin[{name1, name2, …}]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameJoin)))
(def FileNameSetter "FileNameSetter[name] represents a file name setter which displays as a Browse button and when clicked brings up a system file opening dialog, starting from the location corresponding to name. \nFileNameSetter[Dynamic[name]] uses the dynamically updated current value of name, with the value of name being reset if a different file is chosen.\nFileNameSetter[name, \"Save\"] brings up a file saving dialog.\nFileNameSetter[name, \"spec\", {type1->{patt11, patt12, …}, type2->{…}, …}] looks for files of types typei with names matching the file patterns pattij." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameSetter)))
(def FileNameSplit "FileNameSplit[\"name\"] splits a file name into a list of parts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameSplit)))
(def FileNameTake "FileNameTake[\"name\"] gives the last path element in the file name \"name\".\nFileNameTake[\"name\", n] gives the first n path elements in the file name \"name\".\nFileNameTake[\"name\", -n] gives the last n path elements in the file name \"name\".\nFileNameTake[\"name\", {m, n}] gives elements m through n in the file name \"name\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameTake)))
(def FileNameToFormatList "FileNameToFormatList[] returns lists of file formats corresponding to all registered file name patterns.\nFileNameToFormatList[\"file\"] returns a list of file formats that matches the file name \"file\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNameToFormatList)))
(def FileNames "FileNames[] lists all files in the current working directory. \nFileNames[form] lists all files in the current working directory whose names match the string pattern form. \nFileNames[{form1, form2, …}] lists all files whose names match any of the formi. \nFileNames[All, dir] lists all files in the directory dir.\nFileNames[forms, {dir1, dir2, …}] lists files with names matching forms in any of the directories diri. \nFileNames[forms, dirs, n] includes files that are in subdirectories up to n levels down." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileNames)))
(def FilePrint "FilePrint[\"file\"] prints out the raw textual contents of file.\nFilePrint[\"file\", n] prints out the first n raw textual lines of file.\nFilePrint[\"file\", -n] prints out the last n raw textual lines of file.\nFilePrint[\"file\", m;;n] prints out lines m through n of file.\nFilePrint[\"file\", m;;n;;s] prints out lines m through n of file in steps of s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilePrint)))
(def FileSize "FileSize[file] gives the size of a file as a quantity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileSize)))
(def FileSystemMap "FileSystemMap[f, root] gives an association whose keys are the names of files in root, and whose values are the results of applying f to the full names of these files. \nFileSystemMap[f, root, n] gives a nested association in which subdirectories down to level n are represented by an association.\nFileSystemMap[f, root, {m, n}] gives a nested association including files in subdirectories from level m down through n.\nFileSystemMap[f, root, lev, r] combines levels to give a nested output association with r levels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileSystemMap)))
(def FileSystemScan "FileSystemScan[f, root] evaluates f on all files contained in root.\nFileSystemScan[f, root, n] restricts the operation to directories at level n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileSystemScan)))
(def FileSystemTree "FileSystemTree[root] gives a tree whose keys are the names of files in root, and whose data is the full names of these files.\nFileSystemTree[root, levelspec] gives a tree in which files on levels specified by levelspec are represented by a subtree.\nFileSystemTree[root, levelspec, r] combines levels to give a tree with maximum level r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileSystemTree)))
(def FileTemplate "FileTemplate[\"file\"] yields a TemplateObject expression that represents a file template to be applied using functions like TemplateApply.\nFileTemplate[src] uses File[…], URL[…], or CloudObject[…] as the specification for the file location.\nFileTemplate[form, args] yields a TemplateObject with arguments, suitable for cloud deployment or other evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileTemplate)))
(def FileTemplateApply "FileTemplateApply[template] applies a template, evaluating all template elements it contains, and then writes the result to a temporary file, whose name is returned.\nFileTemplateApply[template, args] applies a template, using args to fill its slots, and then writes the result to a temporary file.\nFileTemplateApply[template, output] applies a template, writing the results to the file represented by output.\nFileTemplateApply[template, args, output] applies a template, using args to fill its slots, and then writes the result to the file represented by output." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileTemplateApply)))
(def FileType "FileType[\"file\"] gives the type of a file, typically File, Directory, or None." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FileType)))
(def FilledCurve "FilledCurve[{segment1, segment2, …}] represents a filled curve consisting of segment1 followed by segment2 etc. \nFilledCurve[{component1, component2, …}] represents a list of separate filled component curves component1, component2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilledCurve)))
(def FilledPolarCurve "FilledPolarCurve[r, θ] gives a filled polar curve with radius r as a function of angle θ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilledPolarCurve)))
(def FilledTorus "FilledTorus[{x, y, z}, {rinner, router}] represents a filled torus centered at {x, y, z} with inner radius rinner and outer radius router." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilledTorus)))
(def Filling "Filling is an option for ListPlot, Plot, Plot3D, and related functions that specifies what filling to add under points, curves, and surfaces." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Filling)))
(def FillingStyle "FillingStyle is an option for ListPlot, Plot, Plot3D, and related functions that specifies the default style of filling to be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FillingStyle)))
(def FillingTransform "FillingTransform[image] gives a version of image with all extended minima filled.\nFillingTransform[image, marker] fills extended minima in regions where at least one corresponding element of marker is nonzero.\nFillingTransform[image, h] fills only extended minima of depth h or less." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FillingTransform)))
(def FilterRules "FilterRules[rules, patt] filters the list rules by picking out only those rules whose left-hand sides match patt.\nFilterRules[rules, {patt1, patt2, …}] picks out rules whose left-hand sides match any of the patti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilterRules)))
(def FilteredEntityClass "FilteredEntityClass[class, f] represents a class of entities where only entities for which the EntityFunction object f yields True are kept.\nFilteredEntityClass[class, prop] represents a class of entities where only entities for which the property prop is True are kept." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FilteredEntityClass)))
(def FinancialBond "FinancialBond[params, ambientparams] gives the value of a financial bond instrument.\nFinancialBond[params, ambientparams, prop] computes the specified property prop." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FinancialBond)))
(def FinancialData "FinancialData[\"name\"] gives the last known price or value for the financial entity specified by \"name\".\nFinancialData[\"name\", start] gives a list of dates and daily closing values for \"name\" from start until the current date.\nFinancialData[\"name\", {start, end}] gives a list of dates and daily closing values for dates from start to end.\nFinancialData[\"name\", {start, end, period}] gives a list of dates and prices for the specified periods lying between start and end.\nFinancialData[\"name\", \"prop\"] gives the value of the specified property for the financial entity \"name\". \nFinancialData[\"name\", \"prop\", {start, end, …}] gives a list of dates and values of a property for a sequence of dates or periods." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FinancialData)))
(def FinancialDerivative "FinancialDerivative[instrument, params, ambientparams] gives the value of the specified financial instrument.\nFinancialDerivative[instrument, params, ambientparams, prop] computes the specified property prop." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FinancialDerivative)))
(def FinancialIndicator "FinancialIndicator[\"ind\", par1, par2, …] represents a financial indicator \"ind\" with parameters par1, par2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FinancialIndicator)))
(def Find "Find[stream, \"text\"] finds the first line in an input stream that contains the specified string. \nFind[stream, {\"text1\", \"text2\", …}] finds the first line that contains any of the specified strings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Find)))
(def FindAnomalies "FindAnomalies[{example1, example2, …}] gives a list of the examplei that are considered anomalous with respect to the other examples.\nFindAnomalies[examples, prop] gives the specified property related to the anomaly computation.\nFindAnomalies[examples, {prop1, prop2, …}] gives the properties propi.\nFindAnomalies[fun, data] finds anomalies in data using the given AnomalyDetectorFunction[…] or LearnedDistribution[…].\nFindAnomalies[fun, data, props] gives properties related to the anomaly computation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindAnomalies)))
(def FindArgMax "FindArgMax[f, x] gives the position xmax of a local maximum of f.\nFindArgMax[f, {x, x0}] gives the position xmax of a local maximum of f, found by a search starting from the point x=x0. \nFindArgMax[f, {{x, x0}, {y, y0}, …}] gives the position {xmax, ymax, …} of a local maximum of a function of several variables. \nFindArgMax[{f, cons}, {{x, x0}, {y, y0}, …}] gives the position of a local maximum subject to the constraints cons.\nFindArgMax[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindArgMax)))
(def FindArgMin "FindArgMin[f, x] gives the position xmin of a local minimum of f.\nFindArgMin[f, {x, x0}] gives the position xmin of a local minimum of f, found by a search starting from the point x=x0. \nFindArgMin[f, {{x, x0}, {y, y0}, …}] gives the position {xmin, ymin, …} of a local minimum of a function of several variables. \nFindArgMin[{f, cons}, {{x, x0}, {y, y0}, …}] gives the position of a local minimum subject to the constraints cons.\nFindArgMin[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindArgMin)))
(def FindChannels "FindChannels[] gives a list of channels in your home area on the channel broker server.\nFindChannels[None] gives a list of your unnamed channels.\nFindChannels[All] gives a list of all channels owned by you.\nFindChannels[form] gives a list of channels in your home area whose names match the string pattern form.\nFindChannels[\"/abspath\"] gives a list of channels whose names match the string pattern \"\\\"/\\!\\(\\*StyleBox[\\\"abspath\\\", \\\"TI\\\"]\\)\\\"\".\nFindChannels[\"mqtts://…\"] gives a list of channels whose names match the specified pattern representing a URL." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindChannels)))
(def FindClique "FindClique[g] finds a largest clique in the graph g.\nFindClique[g, n] finds a clique containing at most n vertices.\nFindClique[g, {n}] finds a clique containing exactly n vertices.\nFindClique[g, {nmin, nmax}] finds a clique containing between nmin and nmax vertices.\nFindClique[g, nspec, s] finds at most s cliques.\nFindClique[{g, v}, …] finds cliques that include the vertex v only.\nFindClique[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindClique)))
(def FindClusters "FindClusters[{e1, e2, …}] partitions the ei into clusters of similar elements. \nFindClusters[{e1v1, e2v2, …}] returns the vi corresponding to the ei in each cluster.\nFindClusters[data, n] partitions data into n clusters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindClusters)))
(def FindCookies "FindCookies[] gives a list of all currently set cookies.\nFindCookies[domain] gives a list of cookies associated with the specified domain.\nFindCookies[assoc] gives a list of cookies whose attributes match the specification in the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindCookies)))
(def FindCurvePath "FindCurvePath[{{x1, y1}, {x2, y2}, …}] gives an ordering of the {xi, yi} that corresponds to one or more smooth curves." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindCurvePath)))
(def FindCycle "FindCycle[g] finds a cycle in the graph g.\nFindCycle[g, k] finds a cycle of length at most k in the graph g.\nFindCycle[g, {k}] finds a cycle of length exactly k.\nFindCycle[g, {kmin, kmax}] finds a cycle of length between kmin and kmax.\nFindCycle[g, kspec, s] finds at most s cycles.\nFindCycle[{g, v}, …] finds cycles that include the vertex v.\nFindCycle[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindCycle)))
(def FindDevices "FindDevices[] searches for available devices on your computer system.\nFindDevices[form] gives a list of devices in classes whose names match the string pattern form.\nFindDevices[{form1, form2, …}] gives a list of devices in classes whose names match any of the formi.\nFindDevices[forms, n] returns at most n devices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindDevices)))
(def FindDistribution "FindDistribution[data] finds a simple functional form to fit the distribution of data.\nFindDistribution[data, n] finds up to n best distributions.\nFindDistribution[data, n, prop] returns up to n best distributions associated with property prop.\nFindDistribution[data, n, {prop1, prop2, …}] returns up to n best distributions associated with properties prop1, prop2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindDistribution)))
(def FindDistributionParameters "FindDistributionParameters[data, dist] finds the parameter estimates for the distribution dist from data.\nFindDistributionParameters[data, dist, {{p, p0}, {q, q0}, …}] finds the parameters p, q, … with starting values p0, q0, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindDistributionParameters)))
(def FindDivisions "FindDivisions[{xmin, xmax}, n] finds a list of about n \"nice\" numbers that divide the interval around xmin to xmax into equally spaced parts. \nFindDivisions[{xmin, xmax, dx}, n] makes the parts always have lengths that are integer multiples of dx. \nFindDivisions[{xmin, xmax}, {n1, n2, …}] finds successive subdivisions into about n1, n2, … parts. \nFindDivisions[{xmin, xmax, {dx1, dx2, …}}, {n1, n2, …}] uses spacings that are forced to be multiples of dx1, dx2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindDivisions)))
(def FindEdgeColoring "FindEdgeColoring[g] finds a coloring with minimal size for the edges in the graph g.\nFindEdgeColoring[g, {c1, c2, …}] finds a coloring {c1, c2, …, ck} for the edges in the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEdgeColoring)))
(def FindEdgeCover "FindEdgeCover[g] finds an edge cover of the graph g with a minimum number of edges.\nFindEdgeCover[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEdgeCover)))
(def FindEdgeCut "FindEdgeCut[g] finds a smallest edge cut of the graph g.\nFindEdgeCut[g, s, t] finds a smallest s-t edge cut of the graph g.\nFindEdgeCut[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEdgeCut)))
(def FindEdgeIndependentPaths "FindEdgeIndependentPaths[g, s, t, k] finds at most k edge-independent paths from vertex s to vertex t in the graph g.\nFindEdgeIndependentPaths[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEdgeIndependentPaths)))
(def FindEquationalProof "FindEquationalProof[thm, axms] tries to find an equational proof of the symbolic theorem thm using the axioms axms.\nFindEquationalProof[thm, \"theory\"] tries to find a proof of thm using the specified named axiomatic theory." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEquationalProof)))
(def FindEulerianCycle "FindEulerianCycle[g] finds an Eulerian cycle in the graph g.\nFindEulerianCycle[g, k] finds at most k Eulerian cycles.\nFindEulerianCycle[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindEulerianCycle)))
(def FindExternalEvaluators "FindExternalEvaluators[] finds installed external evaluators that can be used with ExternalEvaluate, returning a dataset of the results found.\nFindExternalEvaluators[\"sys\"] finds only external evaluators for language or system sys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindExternalEvaluators)))
(def FindFaces "FindFaces[image] attempts to find human faces in image and returns a list of bounding boxes.\nFindFaces[image, prop] returns the specified property prop for each detected face.\nFindFaces[image, crit, prop] finds faces that satisfy the criterion crit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindFaces)))
(def FindFile "FindFile[name] finds the file with the specified name that would be loaded by Get[name] and related functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindFile)))
(def FindFit "FindFit[data, expr, pars, vars] finds numerical values of the parameters pars that make expr give a best fit to data as a function of vars. \nFindFit[data, {expr, cons}, pars, vars] finds a best fit subject to the parameter constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindFit)))
(def FindFormula "FindFormula[data] finds a pure function that approximates data.\nFindFormula[data, x] finds a symbolic function of the variable x that approximates data.\nFindFormula[data, x, n] finds up to n functions that approximate data.\nFindFormula[data, x, n, prop] returns up to n best functions associated with property prop.\nFindFormula[data, x, n, {prop1, prop2, …}] returns up to n best functions associated with properties prop1, prop2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindFormula)))
(def FindFundamentalCycles "FindFundamentalCycles[g] finds fundamental cycles of the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindFundamentalCycles)))
(def FindGeneratingFunction "FindGeneratingFunction[{a0, a1, …}, x] attempts to find a simple generating function in x whose n ^th series coefficient is an.\nFindGeneratingFunction[{{n0, a0}, {n1, a1}, …}, x] attempts to find a simple generating function whose ni ^th series coefficient is ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGeneratingFunction)))
(def FindGeoLocation "FindGeoLocation[] attempts to find the current geo location of your computer.\nFindGeoLocation[\"ip\"] gives an estimate of the geo location associated with the IP address given.\nFindGeoLocation[\"address\"] attempts to find the geo location associated with the street address given.\nFindGeoLocation[entity] gives the geo location associated with the specified entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGeoLocation)))
(def FindGeometricConjectures "FindGeometricConjectures[scene] finds conjectures that appear to hold for the GeometricScene object scene and adds these conjectures to the scene object.\nFindGeometricConjectures[{scene1, scene2, …}] finds conjectures that appear to hold for all instances scenei of a geometric scene and returns a combined scene with the conjectures added.\nFindGeometricConjectures[scenes, patt] adds only conjectures that match the pattern patt.\nFindGeometricConjectures[scenes, patt, n] adds only up to n conjectures." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGeometricConjectures)))
(def FindGeometricTransform "FindGeometricTransform[pts1, pts2] finds a geometric transformation that aligns positions specified by pts2 with pts1, returning the alignment error together with the transformation function.\nFindGeometricTransform[ref, {pts1, pts2, …}] finds geometric transformations that align each of the ptsi with ref. \nFindGeometricTransform[{pts1, pts2, …}] finds geometric transformations that align each of the ptsi with pts1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGeometricTransform)))
(def FindGraphCommunities "FindGraphCommunities[g] finds communities in the graph g.\nFindGraphCommunities[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGraphCommunities)))
(def FindGraphIsomorphism "FindGraphIsomorphism[g1, g2] finds an isomorphism that maps the graph g1 to g2 by renaming vertices.\nFindGraphIsomorphism[g1, g2, n] finds at most n isomorphisms. \nFindGraphIsomorphism[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGraphIsomorphism)))
(def FindGraphPartition "FindGraphPartition[g] gives a partition of vertices of the graph g.\nFindGraphPartition[g, k] gives a partition of vertices into k approximately equal-size parts.\nFindGraphPartition[g, {n1, …, nk}] gives a partition of vertices into parts with sizes n1, …, nk.\nFindGraphPartition[g, {α1, …, αk}] gives a partition of vertices into parts with approximate size proportions α1, …, αk.\nFindGraphPartition[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindGraphPartition)))
(def FindHamiltonianCycle "FindHamiltonianCycle[g] finds a Hamiltonian cycle in the graph g.\nFindHamiltonianCycle[g, k] finds at most k Hamiltonian cycles.\nFindHamiltonianCycle[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindHamiltonianCycle)))
(def FindHamiltonianPath "FindHamiltonianPath[g] finds a Hamiltonian path in the graph g with the smallest total length.\nFindHamiltonianPath[g, s, t] finds a Hamiltonian path with the smallest total length from s to t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindHamiltonianPath)))
(def FindHiddenMarkovStates "FindHiddenMarkovStates[data, hmm] finds the most likely hidden states of the HiddenMarkovProcess hmm corresponding to the emissions data.\nFindHiddenMarkovStates[data, hmm, crit] uses the given criterion crit to find the hidden states." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindHiddenMarkovStates)))
(def FindImageShapes "FindImageShapes[image, \"model\"] obtains graphic primitives of shapes in an image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindImageShapes)))
(def FindImageText "FindImageText[image] detects text in image and returns a single bounding box.\nFindImageText[image, level] returns a list of bounding boxes at the specified structural level.\nFindImageText[image, level, prop] returns prop for text at the given level." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindImageText)))
(def FindIndependentEdgeSet "FindIndependentEdgeSet[g] finds an independent edge set of the graph g with a maximum number of edges.\nFindIndependentEdgeSet[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindIndependentEdgeSet)))
(def FindIndependentVertexSet "FindIndependentVertexSet[g] finds an independent vertex set of the graph g with a maximum number of vertices.\nFindIndependentVertexSet[g, n] finds an independent vertex set with at most n vertices.\nFindIndependentVertexSet[g, {n}] finds an independent vertex set with exactly n vertices.\nFindIndependentVertexSet[g, {nmin, nmax}] finds an independent vertex set containing between nmin and nmax vertices.\nFindIndependentVertexSet[g, nspec, s] finds at most s independent vertex sets.\nFindIndependentVertexSet[{g, v}, …] finds independent sets that include the vertex v only.\nFindIndependentVertexSet[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindIndependentVertexSet)))
(def FindInstance "FindInstance[expr, vars] finds an instance of vars that makes the statement expr be True. \nFindInstance[expr, vars, dom] finds an instance over the domain dom. Common choices of dom are Complexes, Reals, Integers, and Booleans. \nFindInstance[expr, vars, dom, n] finds n instances." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindInstance)))
(def FindIntegerNullVector "FindIntegerNullVector[{x1, x2, …, xn}] finds a list of integers ai such that a1 x1+a2 x2+⋯+an xn0. \nFindIntegerNullVector[{x1, x2, …, xn}, d] finds a list of integers ai with {a1, …, an}≤d such that a1 x1+a2 x2+⋯+an xn0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindIntegerNullVector)))
(def FindIsomers "FindIsomers[chem] returns a list of molecules with the same chemical formula as chem.\nFindIsomers[chem, form] finds isomers of chem and returns them in the given form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindIsomers)))
(def FindIsomorphicSubgraph "FindIsomorphicSubgraph[g1, g2] finds a subgraph of g1 that is isomorphic to g2.\nFindIsomorphicSubgraph[g1, g2, n] finds at most n subgraphs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindIsomorphicSubgraph)))
(def FindKClan "FindKClan[g, k] finds a largest k-clan in the graph g.\nFindKClan[g, k, n] finds a k-clan containing at most n vertices.\nFindKClan[g, k, {n}] finds a k-clan containing exactly n vertices.\nFindKClan[g, k, {nmin, nmax}] finds a k-clan containing between nmin and nmax vertices.\nFindKClan[g, k, nspec, s] finds at most s k-clans.\nFindKClan[{g, v}, k, …] finds k-clans that include the vertex v only.\nFindKClan[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindKClan)))
(def FindKClique "FindKClique[g, k] finds a largest k-clique in the graph g.\nFindKClique[g, k, n] finds a k-clique containing at most n vertices.\nFindKClique[g, k, {n}] finds a k-clique containing exactly n vertices.\nFindKClique[g, k, {nmin, nmax}] finds a k-clique containing between nmin and nmax vertices.\nFindKClique[g, k, nspec, s] finds at most s k-cliques.\nFindKClique[{g, v}, k, …] finds k-cliques that include the vertex v only.\nFindKClique[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindKClique)))
(def FindKClub "FindKClub[g, k] finds a largest k-club in the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindKClub)))
(def FindKPlex "FindKPlex[g, k] finds a largest k-plex in the graph g.\nFindKPlex[g, k, n] finds a k-plex containing at most n vertices.\nFindKPlex[g, k, {n}] finds a k-plex containing exactly n vertices.\nFindKPlex[g, k, {nmin, nmax}] finds a k-plex containing between nmin and nmax vertices.\nFindKPlex[g, k, nspec, s] finds at most s k-plexes.\nFindKPlex[{g, v}, k, …] finds k-plexes that include the vertex v only.\nFindKPlex[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindKPlex)))
(def FindLibrary "FindLibrary[lib] finds a dynamic library that can be loaded by LibraryFunctionLoad." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindLibrary)))
(def FindLinearRecurrence "FindLinearRecurrence[list] finds if possible the minimal linear recurrence that generates list.\nFindLinearRecurrence[list, d] finds if possible the linear recurrence of maximum order d that generates list." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindLinearRecurrence)))
(def FindList "FindList[\"file\", \"text\"] gives a list of lines in the file that contain the specified string. \nFindList[\"file\", {\"text1\", \"text2\", …}] gives a list of all lines that contain any of the specified strings. \nFindList[{\"file1\", …}, …] gives a list of lines containing the specified strings in any of the filei. \nFindList[files, text, n] includes only the first n lines found." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindList)))
(def FindMatchingColor "FindMatchingColor[image, color] returns a color similar to the color that is present in image.\nFindMatchingColor[image, {color1, color2, …}] returns a list of colors matching each colori.\nFindMatchingColor[{image1, image2, …}, {color1, color2, …}] returns lists of matching colors for all imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMatchingColor)))
(def FindMaxValue "FindMaxValue[f, x] gives the value at a local maximum of f.\nFindMaxValue[f, {x, x0}] gives the value at a local maximum of f, found by a search starting from the point x=x0. \nFindMaxValue[f, {{x, x0}, {y, y0}, …}] gives the value at a local maximum of a function of several variables. \nFindMaxValue[{f, cons}, {{x, x0}, {y, y0}, …}] gives the value at a local maximum subject to the constraints cons.\nFindMaxValue[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMaxValue)))
(def FindMaximum "FindMaximum[f, x] searches for a local maximum in f, starting from an automatically selected point.\nFindMaximum[f, {x, x0}] searches for a local maximum in f, starting from the point x=x0. \nFindMaximum[f, {{x, x0}, {y, y0}, …}] searches for a local maximum in a function of several variables. \nFindMaximum[{f, cons}, {{x, x0}, {y, y0}, …}] searches for a local maximum subject to the constraints cons.\nFindMaximum[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMaximum)))
(def FindMaximumCut "FindMaximumCut[g] gives the maximum cut of the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMaximumCut)))
(def FindMaximumFlow "FindMaximumFlow[g, s, t] finds the maximum flow between source vertex s and target vertex t in a graph g.\nFindMaximumFlow[m, s, t] finds the maximum flow between vertex indices s and t in a graph with edge capacity matrix m.\nFindMaximumFlow[data, {s1, …}, {t1, …}] finds the maximum flow between multi-sources s1, … and multi-targets t1, ….\nFindMaximumFlow[data, source, target, \"property\"] returns the value of \"property\".\nFindMaximumFlow[{v->w, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMaximumFlow)))
(def FindMeshDefects "FindMeshDefects[mreg] finds defects in the mesh region mreg.\nFindMeshDefects[mreg, {def1, …}] finds only the specified type of defects def1, ….\nFindMeshDefects[mreg, defects, format] formats the results according to format specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMeshDefects)))
(def FindMinValue "FindMinValue[f, x] gives the value at a local minimum of f.\nFindMinValue[f, {x, x0}] gives the value at a local minimum of f, found by a search starting from the point x=x0. \nFindMinValue[f, {{x, x0}, {y, y0}, …}] gives the value at a local minimum of a function of several variables. \nFindMinValue[{f, cons}, {{x, x0}, {y, y0}, …}] gives the value at a local minimum subject to the constraints cons.\nFindMinValue[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMinValue)))
(def FindMinimum "FindMinimum[f, x] searches for a local minimum in f, starting from an automatically selected point.\nFindMinimum[f, {x, x0}] searches for a local minimum in f, starting from the point x=x0. \nFindMinimum[f, {{x, x0}, {y, y0}, …}] searches for a local minimum in a function of several variables. \nFindMinimum[{f, cons}, {{x, x0}, {y, y0}, …}] searches for a local minimum subject to the constraints cons.\nFindMinimum[{f, cons}, {x, y, …}] starts from a point within the region defined by the constraints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMinimum)))
(def FindMinimumCostFlow "FindMinimumCostFlow[g, {sd1, sd2, …}] finds the minimum cost flow in the graph g with sd1, sd2, … vertex supplies or demands.\nFindMinimumCostFlow[g, s, t] finds the minimum cost maximum flow between source vertex s and target vertex t in a graph g.\nFindMinimumCostFlow[g, s, t, d] finds the minimum cost flow between source s and target t, with the required flow d.\nFindMinimumCostFlow[m, …] finds the minimum cost flow in a graph with cost matrix m.\nFindMinimumCostFlow[data, …, \"property\"] returns the value of \"property\".\nFindMinimumCostFlow[{v->w, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMinimumCostFlow)))
(def FindMinimumCut "FindMinimumCut[g] gives the minimum cut of the graph g.\nFindMinimumCut[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMinimumCut)))
(def FindMoleculeSubstructure "FindMoleculeSubstructure[mol, patt] finds a mapping between the atom indices in mol and an occurrence of patt in mol.\nFindMoleculeSubstructure[mol, patt, All] finds all occurrences of patt in mol and returns all mappings.\nFindMoleculeSubstructure[mol, patt, n] finds at most n mappings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindMoleculeSubstructure)))
(def FindPath "FindPath[g, s, t] finds a path between vertex s and vertex t in the graph g.\nFindPath[g, s, t, k] finds a path of length at most k between vertex s and vertex t in the graph g.\nFindPath[g, s, t, {k}] finds a path of length exactly k.\nFindPath[g, s, t, {kmin, kmax}] finds a path of length between kmin and kmax.\nFindPath[g, s, t, kspec, n] finds at most n paths.\nFindPath[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPath)))
(def FindPeaks "FindPeaks[list] gives positions and values of the detected peaks in list.\nFindPeaks[list, σ] finds peaks that survive Gaussian blurring up to scale σ.\nFindPeaks[list, σ, s] finds peaks with minimum sharpness s.\nFindPeaks[list, σ, s, t] finds only peaks with values greater than t.\nFindPeaks[list, σ, {s, σs}, {t, σt}] uses different scales for thresholding sharpness and value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPeaks)))
(def FindPermutation "FindPermutation[expr] gives a permutation that produces expr by permuting Sort[expr].\nFindPermutation[expr1, expr2] gives a permutation that converts expr1 to expr2 for two expressions that differ only in the order of their arguments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPermutation)))
(def FindPlanarColoring "FindPlanarColoring[g] finds a coloring with minimal size for the faces of the planar graph g.\nFindPlanarColoring[g, {c1, c2, …}] finds a coloring {c1, c2, …, ck} for the faces in the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPlanarColoring)))
(def FindPointProcessParameters "FindPointProcessParameters[pdata, pproc] estimates the parameters of the point process pproc from point data pdata.\nFindPointProcessParameters[pdata, pproc, {{p, p0}, {q, q0}, …}] estimates the parameters p, q, … with starting values p0, q0, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPointProcessParameters)))
(def FindPostmanTour "FindPostmanTour[g] finds a Chinese postman tour in the graph g of minimal length.\nFindPostmanTour[g, k] finds at most k Chinese postman tours. \nFindPostmanTour[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindPostmanTour)))
(def FindProcessParameters "FindProcessParameters[data, proc] finds the parameter estimates for the process proc from data.\nFindProcessParameters[data, proc, {{p, p0}, {q, q0}, …}] finds the parameters p, q, … with starting values p0, q0, … ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindProcessParameters)))
(def FindRegionTransform "FindRegionTransform[reg1, reg2] gives the transformation function that maps the region reg1 to the region reg2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindRegionTransform)))
(def FindRepeat "FindRepeat[list] finds the minimal sublist or subarray that repeats to give list.\nFindRepeat[list, n] requires that the sublist be repeated at least n times in list.\nFindRepeat[list, {n1, n2, …}] requires ni to repeat at level i in list.\nFindRepeat[\"string\"] finds the minimal substring that repeats to give string.\nFindRepeat[\"string\", n] requires that the substring be repeated at least n times." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindRepeat)))
(def FindRoot "FindRoot[f, {x, x0}] searches for a numerical root of f, starting from the point x=x0.\nFindRoot[lhs==rhs, {x, x0}] searches for a numerical solution to the equation lhs==rhs. \nFindRoot[{f1, f2, …}, {{x, x0}, {y, y0}, …}] searches for a simultaneous numerical root of all the fi.\nFindRoot[{eqn1, eqn2, …}, {{x, x0}, {y, y0}, …}] searches for a numerical solution to the simultaneous equations eqni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindRoot)))
(def FindSequenceFunction "FindSequenceFunction[{a1, a2, a3, …}] attempts to find a simple function that yields the sequence an when given successive integer arguments.\nFindSequenceFunction[{{n1, a1}, {n2, a2}, …}] attempts to find a simple function that yields ai when given argument ni.\nFindSequenceFunction[n1a1, n2a2, …] gives a function that yields ai when given argument ni.\nFindSequenceFunction[{n1a1, n2a2, …}] gives a function that yields ai when given argument ni.\nFindSequenceFunction[list, n] gives the function applied to n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindSequenceFunction)))
(def FindSettings "FindSettings is a global option that specifies settings for the Find dialog box." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindSettings)))
(def FindShortestPath "FindShortestPath[g, s, t] finds the shortest path from source vertex s to target vertex t in the graph g.\nFindShortestPath[g, s, All] generates a ShortestPathFunction[…] that can be applied repeatedly to different t.\nFindShortestPath[g, All, t] generates a ShortestPathFunction[…] that can be applied repeatedly to different s.\nFindShortestPath[g, All, All] generates a ShortestPathFunction[…] that can be applied to different s and t.\nFindShortestPath[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindShortestPath)))
(def FindShortestTour "FindShortestTour[{v1, v2, …}] attempts to find an ordering of the vi that minimizes the total distance on a tour that visits all the vi once.\nFindShortestTour[graph] attempts to find an ordering of the vertices in graph that minimizes the total length when visiting each vertex once.\nFindShortestTour[{v1, v2, …}, j, k] finds an ordering of the vi that minimizes the total distance on a path from vj to vk.\nFindShortestTour[graph, s, t] finds an ordering of the vertices that minimizes the total length on a path from s to t.\nFindShortestTour[{vw, …}, …] uses rules vw to specify the graph g. \nFindShortestTour[dataprop, …] gives the property prop for data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindShortestTour)))
(def FindSpanningTree "FindSpanningTree[{v1, v2, …, vn}] finds a spanning tree that minimizes the total distance between the vi.\nFindSpanningTree[g] finds a spanning tree of the graph g that minimizes the total distances between vertices.\nFindSpanningTree[{g, v}, …] finds a spanning tree of the connected component of g that includes the vertex v. \nFindSpanningTree[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindSpanningTree)))
(def FindSubgraphIsomorphism "FindSubgraphIsomorphism[g1, g2] finds a subgraph isomorphism that maps the graph g1 to a subgraph of g2 by renaming vertices.\nFindSubgraphIsomorphism[g1, g2, n] finds at most n subgraph isomorphisms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindSubgraphIsomorphism)))
(def FindSystemModelEquilibrium "FindSystemModelEquilibrium[model] searches for an equilibrium to the model model.\nFindSystemModelEquilibrium[model, {{{x1, x10}, …}, {{u1, u10}, …}, {{y1, y10}, …}}] searches for an equilibrium, starting from the points xi=x i0, ui=u i0 and yi=y i0.\nFindSystemModelEquilibrium[model, {x1v1, …}, …] searches for an equilibrium, with variable xi constrained to have the value vi etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindSystemModelEquilibrium)))
(def FindTextualAnswer "FindTextualAnswer[text, \"question\"] gives the substring of text that best appears to answer question.\nFindTextualAnswer[text, \"question\", n] gives a list of up to n answers that appear most probable.\nFindTextualAnswer[text, \"question\", n, prop] gives the specified property for each answer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindTextualAnswer)))
(def FindThreshold "FindThreshold[image] finds a global threshold value that partitions the intensity values in image into two intervals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindThreshold)))
(def FindTransientRepeat "FindTransientRepeat[list, n] returns a pair of lists {transient, repeat} where the elements of repeat occur successively at least n times after the elements of the transient part of list.\nFindTransientRepeat[string, n] returns a pair of strings {transient, repeat}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindTransientRepeat)))
(def FindVertexColoring "FindVertexColoring[g] finds a coloring with minimal size for the vertices in the graph g. \nFindVertexColoring[g, {c1, c2, …}] finds a coloring {c1, c2, …, ck} for the vertices in the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindVertexColoring)))
(def FindVertexCover "FindVertexCover[g] finds a vertex cover of the graph g with a minimum number of vertices.\nFindVertexCover[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindVertexCover)))
(def FindVertexCut "FindVertexCut[g] finds a smallest vertex cut of the graph g.\nFindVertexCut[g, s, t] finds a smallest s-t vertex cut of the graph g.\nFindVertexCut[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindVertexCut)))
(def FindVertexIndependentPaths "FindVertexIndependentPaths[g, s, t, k] finds at most k vertex-independent paths from vertex s to vertex t in the graph g.\nFindVertexIndependentPaths[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FindVertexIndependentPaths)))
(def FinishDynamic "FinishDynamic[] finishes updating and displaying all currently visible Dynamic objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FinishDynamic)))
(def FiniteAbelianGroupCount "FiniteAbelianGroupCount[n] gives the number of finite Abelian groups of order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteAbelianGroupCount)))
(def FiniteField "FiniteField[p, d] gives a finite field with p^d elements.\nFiniteField[p, f] gives the finite field p[α]/〈f(α)〉, where f(α) is an irreducible polynomial in p[α].\nFiniteField[p, …, rep] uses field element representation rep, either \"Polynomial\" or \"Exponential\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteField)))
(def FiniteFieldElement "FiniteFieldElement[ff, ind] gives the element of the finite field ff with index ind.\nFiniteFieldElement[ff, {c0, c1, c2, …}] gives the element c0+c1 θ+c2 θ^2+… of the finite field ff, where θ is the field generator of ff." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldElement)))
(def FiniteFieldElementNorm "FiniteFieldElementNorm[a] gives the absolute norm of the finite field element a.\nFiniteFieldElementNorm[a, k] gives the norm of a relative to the p^k-element subfield of the ambient field of a.\nFiniteFieldElementNorm[a, emb] gives the norm of a relative to the finite field embedding emb." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldElementNorm)))
(def FiniteFieldElementPrimitiveQ "FiniteFieldElementPrimitiveQ[a] tests whether a is a primitive element of its ambient field." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldElementPrimitiveQ)))
(def FiniteFieldElementTrace "FiniteFieldElementTrace[a] gives the absolute trace of the finite field element a.\nFiniteFieldElementTrace[a, k] gives the trace of a relative to the p^k-element subfield of the ambient field of a.\nFiniteFieldElementTrace[a, emb] gives the trace of a relative to the finite field embedding emb." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldElementTrace)))
(def FiniteFieldEmbedding "FiniteFieldEmbedding[ff1, ff2] gives an embedding of the finite field ff1 in the finite field ff2.\nFiniteFieldEmbedding[e1e2] represents the embedding of the ambient field of e1 in the ambient field of e2, which maps e1 to e2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldEmbedding)))
(def FiniteFieldIndex "FiniteFieldIndex[u] gives the index of the FiniteFieldElement object u." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteFieldIndex)))
(def FiniteGroupCount "FiniteGroupCount[n] gives the number of finite groups of order n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteGroupCount)))
(def FiniteGroupData "FiniteGroupData[name, \"property\"] gives the value of the specified property for the finite group specified by name.\nFiniteGroupData[\"class\"] gives a list of finite groups in the specified class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FiniteGroupData)))
(def First "First[expr] gives the first element in expr. \nFirst[expr, def] gives the first element if it exists, or def otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote First)))
(def FirstCase "FirstCase[{e1, e2, …}, pattern] gives the first ei to match pattern, or Missing[\"NotFound\"] if none matching pattern is found. \nFirstCase[{e1, …}, patternrhs] gives the value of rhs corresponding to the first ei to match pattern.\nFirstCase[expr, pattern, default] gives default if no element matching pattern is found. \nFirstCase[expr, pattern, default, levelspec] finds only objects that appear on levels specified by levelspec. \nFirstCase[pattern] represents an operator form of FirstCase that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FirstCase)))
(def FirstPassageTimeDistribution "FirstPassageTimeDistribution[mproc, f] represents the distribution of times for the Markov process mproc to pass from the initial state to final states f for the first time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FirstPassageTimeDistribution)))
(def FirstPosition "FirstPosition[expr, pattern] gives the position of the first element in expr that matches pattern, or Missing[\"NotFound\"] if no such element is found.\nFirstPosition[expr, pattern, default] gives default if no element matching pattern is found.\nFirstPosition[expr, pattern, default, levelspec] finds only objects that appear on levels specified by levelspec. \nFirstPosition[pattern] represents an operator form of FirstPosition that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FirstPosition)))
(def FischerGroupFi22 "FischerGroupFi22[] represents the sporadic simple Fischer group Fi22." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FischerGroupFi22)))
(def FischerGroupFi23 "FischerGroupFi23[] represents the sporadic simple Fischer group Fi23." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FischerGroupFi23)))
(def FischerGroupFi24Prime "FischerGroupFi24Prime[] represents the sporadic simple Fischer group Fi_24^′." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FischerGroupFi24Prime)))
(def FisherHypergeometricDistribution "FisherHypergeometricDistribution[n, nsucc, ntot, w] represents a Fisher noncentral hypergeometric distribution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FisherHypergeometricDistribution)))
(def FisherRatioTest "FisherRatioTest[data] tests whether the variance of data is 1. \nFisherRatioTest[{data1, data2}] tests whether the variances of data1 and data2 are equal.\nFisherRatioTest[dspec, σ_0^2] tests a dispersion measure against σ_0^2.\nFisherRatioTest[dspec, σ_0^2, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FisherRatioTest)))
(def FisherZDistribution "FisherZDistribution[n, m] represents a Fisher z distribution with n numerator and m denominator degrees of freedom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FisherZDistribution)))
(def Fit "Fit[data, {f1, …, fn}, {x, y, …}] finds a fit a1⁢f1+…+an⁢fn to a list of data for functions f1, …, fn of variables {x, y, …}. \nFit[{m, v}] finds a fit vector a that minimizes ||m.a-v|| for a design matrix m.\nFit[…, \"prop\"] specifies what fit property prop should be returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Fit)))
(def FitRegularization "FitRegularization is an option for Fit and FindFit that specifies a regularization for fitting a model." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FitRegularization)))
(def FittedModel "FittedModel[…] represents the symbolic fitted model obtained from functions like LinearModelFit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FittedModel)))
(def FixedOrder "FixedOrder[p1, p2, …] is a grammar rules pattern object that represents a sequence of elements matching p1, p2, …, in the fixed order given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FixedOrder)))
(def FixedPoint "FixedPoint[f, expr] starts with expr, then applies f repeatedly until the result no longer changes.\nFixedPoint[f, expr, n] stops after at most n steps." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FixedPoint)))
(def FixedPointList "FixedPointList[f, expr] generates a list giving the results of applying f repeatedly, starting with expr, until the results no longer change.\nFixedPointList[f, expr, n] stops after at most n steps." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FixedPointList)))
(def Flat "Flat is an attribute that can be assigned to a symbol f to indicate that all expressions involving nested functions f should be flattened out. This property is accounted for in pattern matching." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Flat)))
(def FlatShading "FlatShading[] is a three-dimensional graphics directive that specifies that faces of polygons and other filled graphics objects are to be drawn to reflect as a flat surface.\nFlatShading[d] uses the attenuation factor d for the diffuse light.\nFlatShading[d, a] uses the attenuation factor a for the ambient light." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlatShading)))
(def FlatTopWindow "FlatTopWindow[x] represents an exact flat top window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlatTopWindow)))
(def Flatten "Flatten[list] flattens out nested lists. \nFlatten[list, n] flattens to level n. \nFlatten[list, n, h] flattens subexpressions with head h. \nFlatten[list, {{s11, s12, …}, {s21, s22, …}, …}] flattens list by combining all levels sij to make each level i in the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Flatten)))
(def FlattenAt "FlattenAt[list, n] flattens out a sublist that appears as the n^th element of list. If n is negative, the position is counted from the end. \nFlattenAt[expr, {i, j, …}] flattens out the part of expr at position {i, j, …}. \nFlattenAt[expr, {{i1, j1, …}, {i2, j2, …}, …}] flattens out parts of expr at several positions.\nFlattenAt[pos] represents an operator form of FlattenAt that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlattenAt)))
(def FlattenLayer "FlattenLayer[] represents a net layer that flattens any input array into a vector.\nFlattenLayer[n] represents a net layer that flattens its input to level n.\nFlattenLayer[{{s11, s12, …}, {s21, s22, …}, …}] represents a net layer that flattens its input by combining all levels sij to make each level i in the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlattenLayer)))
(def FlightData "FlightData[spec, options] returns a subset of properties for a flight or selection of flights with specifications spec.\nFlightData[spec, prop, options] returns the value of the property prop for specifications spec.\nFlightData[spec, prop, datespec, options] returns the value of the property prop for a specific time or time range datespec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlightData)))
(def FlipView "FlipView[{expr1, expr2}] represents an object which flips between displaying expr1 and expr2 each time it is clicked.\nFlipView[{expr1, expr2, …}] cyclically flips through successive expri.\nFlipView[{expr1, expr2, …}, i] makes expri be the object currently displayed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlipView)))
(def Floor "Floor[x] gives the greatest integer less than or equal to x. \nFloor[x, a] gives the greatest multiple of a less than or equal to x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Floor)))
(def FlowPolynomial "FlowPolynomial[g, k] gives the flow polynomial of the graph g.\nFlowPolynomial[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FlowPolynomial)))
(def FluidFlowPDEComponent "FluidFlowPDEComponent[vars, pars] yields a flow PDE term with variables vars and parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FluidFlowPDEComponent)))
(def Fold "Fold[f, x, list] gives the last element of FoldList[f, x, list].\nFold[f, list] is equivalent to Fold[f, First[list], Rest[list]].\nFold[f] represents an operator form of Fold that can be applied to expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Fold)))
(def FoldList "FoldList[f, x, {a, b, …}] gives {x, f[x, a], f[f[x, a], b], …}. \nFoldList[f, {a, b, c, …}] gives {a, f[a, b], f[f[a, b], c], …}.\nFoldList[f] represents an operator form of FoldList that can be applied to expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoldList)))
(def FoldPair "FoldPair[f, y0, list] gives the last element of FoldPairList[f, y0, list].\nFoldPair[f, y0, list, g] gives the last element of FoldPairList[f, y0, list, g].\nFoldPair[f, {a0, a1, a2, …}] is equivalent to FoldPair[f, a0, {a1, a2, …}]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoldPair)))
(def FoldPairList "FoldPairList[f, y0, {a1, a2, …}] gives the list of successive xi obtained by applying f to pairs of the form {y i-1, ai}, where at each step f returns {xi, yi}.\nFoldPairList[f, y0, list, g] gives the list of successive values of g[{xi, yi}].\nFoldPairList[f, {a0, a1, a2, …}] is equivalent to FoldPairList[f, a0, {a1, a2, …}]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoldPairList)))
(def FoldWhile "FoldWhile[f, x, {a1, a2, …}, test] returns the first expression f[… f[f[x, a1], a2]…, ak] to which applying test does not yield True.\nFoldWhile[f, list, test] is equivalent to FoldWhile[f, First[list], Rest[list], test].\nFoldWhile[f, x, {a1, a2, …}, test, m] supplies the most recent m results as arguments for test at each step.\nFoldWhile[f, x, {a1, a2, …}, test, All] supplies all results so far as arguments for test at each step. \nFoldWhile[f, x, {a1, a2, …}, test, m, n] returns the result after applying f an extra n times after test fails.\nFoldWhile[f, x, {a1, a2, …}, test, m, -n] returns the result found when f had been applied n fewer times.\nFoldWhile[f, test] represents an operator form of FoldWhile that can be applied to expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoldWhile)))
(def FoldWhileList "FoldWhileList[f, x, {a1, a2, …}, test] returns {x, f[x, a1], f[f[x, a1], a2], …}, repeatedly applying f with subsequent values ai until applying test to the result does not yield True.\nFoldWhileList[f, list, test] is equivalent to FoldWhileList[f, First[list], Rest[list], test].\nFoldWhileList[f, x, {a1, a2, …}, test, m] supplies the most recent m results as arguments for test at each step.\nFoldWhileList[f, x, {a1, a2, …}, test, All] supplies all results so far as arguments for test at each step.\nFoldWhileList[f, x, {a1, a2, …}, test, m, n] returns n additional results by applying f an extra n times after test fails.\nFoldWhileList[f, x, {a1, a2, …}, test, m, -n] returns n fewer results.\nFoldWhileList[f, test] represents an operator form of FoldWhileList that can be applied to expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoldWhileList)))
(def FollowRedirects "FollowRedirects is an option for URLRead and related functions that specifies whether to follow HTTP redirects when retrieving a URL." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FollowRedirects)))
(def FontColor "FontColor is an option for Style, Cell, and related constructs that specifies the default color in which to render text." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontColor)))
(def FontFamily "FontFamily is an option for Style and Cell that specifies the font family in which text should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontFamily)))
(def FontSize "FontSize is an option for Style and Cell that specifies the default size in printer's points of the font in which to render text." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontSize)))
(def FontSlant "FontSlant is an option for Style, Cell, and related constructs that specifies how slanted characters in text should be." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontSlant)))
(def FontSubstitutions "FontSubstitutions is a global option that gives a list of substitutions to try for font family names." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontSubstitutions)))
(def FontTracking "FontTracking is an option for Style and Cell that specifies how condensed or expanded you want the font in which text is rendered to be." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontTracking)))
(def FontVariations "FontVariations is an option for Style, Cell, and related constructs that specifies what font variations should be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontVariations)))
(def FontWeight "FontWeight is an option for Style, Cell, and related constructs that specifies how heavy the characters in a font should be." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FontWeight)))
(def For "For[start, test, incr, body] executes start, then repeatedly evaluates body and incr until test fails to give True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote For)))
(def ForAll "ForAll[x, expr] represents the statement that expr is True for all values of x. \nForAll[x, cond, expr] states that expr is True for all x satisfying the condition cond. \nForAll[{x1, x2, …}, expr] states that expr is True for all values of all the xi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForAll)))
(def ForAllType "ForAllType[x, type] represents a type parameterized by x.\nForAllType[x, cond, type] represents a type satisfying cond.\nForAllType[{x1, x1, …}, cond, type] represents a type with multiple parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForAllType)))
(def ForceVersionInstall "ForceVersionInstall is an option to PacletInstall and PacletInstallSubmit that specifies whether an older version of a paclet is allowed to be installed if a newer version is already installed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForceVersionInstall)))
(def ForeignCallback "ForeignCallback[…] represents a foreign callback that can be called from external libraries." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForeignCallback)))
(def ForeignFunction "ForeignFunction[args] represents a function that has been loaded from a library." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForeignFunction)))
(def ForeignFunctionLoad "ForeignFunctionLoad[lib, fun, {argtype1, argtype2, …}rettype] loads the function fun with the specified argument and output types from the library lib.\nForeignFunctionLoad[ptr, {argtype1, argtype2, …}rettype] creates a foreign function from the function pointer ptr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForeignFunctionLoad)))
(def ForeignPointerLookup "ForeignPointerLookup[lib, fun] returns the pointer to the function fun in the library lib." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForeignPointerLookup)))
(def FormBox "FormBox[boxes, form] is a low-level box construct which displays as boxes but specifies that rules associated with form should be used to interpret boxes on input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormBox)))
(def FormBoxOptions "FormBoxOptions is an option for cells that specifies settings for FormBox objects within the cell." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormBoxOptions)))
(def FormControl "FormControl[assoc, struct] represents an editable form in a notebook, with structure specified by struct and current values specified by assoc.\nFormControl[Dynamic[x], struct] represents a form in a notebook in which current values are given by the dynamically updated value of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormControl)))
(def FormFunction "FormFunction[formspec, func] represents an active form that, when submitted, applies func to the values obtained from the form specified by formspec.\nFormFunction[{name1type1, …}, func] represents an active form with fields named namei interpreted as types typei.\nFormFunction[{{name1, label1}type1, …}, func] uses labeli as the label for the field named namei.\nFormFunction[{namespec1type1default1, …}, func] uses defaulti as the default for the field specified by namespeci.\nFormFunction[formspec, func, fmt] specifies that in the cloud, the result from applying func should be returned in format fmt.\nFormFunction[{formspec1, formspec2, …}, func, …] represents a multipage form, in which the successive formspeci can be functions that are applied to the values obtained so far." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormFunction)))
(def FormLayoutFunction "FormLayoutFunction is an option for FormObject and FormFunction that can be used to specify how to lay out a form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormLayoutFunction)))
(def FormObject "FormObject[{name1type1, name2type2, …}] represents a form with fields having names namei that take data of type typei.\nFormObject[{{name1, label1}type1, …}] uses labeli as the label for the field named namei.\nFormObject[{name1assoc1, …, objj, …}] uses full specification associ for a field, and objj as part of the layout of the form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormObject)))
(def FormPage "FormPage[formspec, func] represents an active page that takes input from a form and generates results on the same page by applying func to the values obtained from the form whose structure is defined by formspec.\nFormPage[{name1type1, …}, func] represents an active form page with fields named namei interpreted as types typei.\nFormPage[{{name1, label1}type1, …}, func] uses labeli as the label for the field named namei.\nFormPage[{namespec1type1default1, …}, func] uses defaulti as the default for the field specified by namespeci.\nFormPage[formspec, func, form] lays out the page according to the layout specification form.\nFormPage[formspec, func, initformresform] uses initform as the initial layout specification and resform as the layout specification for result pages." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormPage)))
(def FormProtectionMethod "FormProtectionMethod is an option for form generation functions that specifies what method to use for protecting the form against spam and other undesired submissions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormProtectionMethod)))
(def Format "Format[expr] prints as the formatted form of expr. Assigning values to Format[expr] defines print forms for expressions. \nFormat[expr, form] gives a format for the specified form of output." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Format)))
(def FormatType "FormatType is an option for output streams, graphics, and functions such as Text that specifies the default format type to use when outputting expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormatType)))
(def FormulaData "FormulaData[name] gives the equations for the formula name.\nFormulaData[name, {var1quantity1, var2quantity2, …}] solves or simplifies equations using the specified values quantityi for the variables vari.\nFormulaData[name, \"property\"] gives the value of the specified property for the formula name." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormulaData)))
(def FormulaLookup "FormulaLookup[\"query\"] gives a list of the full names of formulas whose names are consistent with \"query\".\nFormulaLookup[\"query\", n] returns at most n results.\nFormulaLookup[\"class\"] returns the names of all formulas within that class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FormulaLookup)))
(def FortranForm "FortranForm[expr] prints as a Fortran language version of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FortranForm)))
(def Forward "Forward is a symbol that represents the forward direction for purposes of motion and animation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Forward)))
(def ForwardBackward "ForwardBackward is a symbol that represents alternate forward and backward motion or animation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForwardBackward)))
(def ForwardCloudCredentials "ForwardCloudCredentials is an option for remote evaluation and submission functions that specifies whether Wolfram Cloud credentials from the local session should be copied into remote sessions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ForwardCloudCredentials)))
(def Fourier "Fourier[list] finds the discrete Fourier transform of a list of complex numbers.\nFourier[list, {p1, p2, …}] returns the specified positions of the discrete Fourier transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Fourier)))
(def FourierCoefficient "FourierCoefficient[expr, t, n] gives the n ^th coefficient in the Fourier series expansion of expr.\nFourierCoefficient[expr, {t1, t2, …}, {n1, n2, …}] gives a multidimensional Fourier coefficient." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierCoefficient)))
(def FourierCosCoefficient "FourierCosCoefficient[expr, t, n] gives the n ^th coefficient in the Fourier cosine series expansion of expr.\nFourierCosCoefficient[expr, {t1, t2, …}, {n1, n2, …}] gives a multidimensional Fourier cosine coefficient." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierCosCoefficient)))
(def FourierCosSeries "FourierCosSeries[expr, t, n] gives the n ^th-order Fourier cosine series expansion of expr in t.\nFourierCosSeries[expr, {t1, t2, …}, {n1, n2, …}] gives the multidimensional Fourier cosine series of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierCosSeries)))
(def FourierCosTransform "FourierCosTransform[expr, t, ω] gives the symbolic Fourier cosine transform of expr. \nFourierCosTransform[expr, {t1, t2, …}, {ω1, ω2, …}] gives the multidimensional Fourier cosine transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierCosTransform)))
(def FourierDCT "FourierDCT[list] finds the Fourier discrete cosine transform of a list of real numbers.\nFourierDCT[list, m] finds the Fourier discrete cosine transform of type m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierDCT)))
(def FourierDCTFilter "FourierDCTFilter[image, t] reduces noise in image by locally thresholding the discrete cosine transforms of overlapping subimages, using the hard threshold t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierDCTFilter)))
(def FourierDCTMatrix "FourierDCTMatrix[n] returns an n×n discrete cosine transform matrix of type 2.\nFourierDCTMatrix[n, m] returns an n×n discrete cosine transform matrix of type m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierDCTMatrix)))
(def FourierDST "FourierDST[list] finds the Fourier discrete sine transform of a list of real numbers.\nFourierDST[list, m] finds the Fourier discrete sine transform of type m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierDST)))
(def FourierDSTMatrix "FourierDSTMatrix[n] returns an n×n discrete sine transform matrix of type 2.\nFourierDSTMatrix[n, m] returns an n×n discrete sine transform matrix of type m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierDSTMatrix)))
(def FourierMatrix "FourierMatrix[n] returns an n×n Fourier matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierMatrix)))
(def FourierParameters "FourierParameters is an option to Fourier and related functions that specifies the conventions to use in computing Fourier transforms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierParameters)))
(def FourierSequenceTransform "FourierSequenceTransform[expr, n, ω] gives the Fourier sequence transform of expr.\nFourierSequenceTransform[expr, {n1, n2, …}, {ω1, ω2, …}] gives the multidimensional Fourier sequence transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierSequenceTransform)))
(def FourierSeries "FourierSeries[expr, t, n] gives the n ^th-order Fourier series expansion of expr in t. \nFourierSeries[expr, {t1, t2, …}, {n1, n2, …}] gives the multidimensional Fourier series." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierSeries)))
(def FourierSinCoefficient "FourierSinCoefficient[expr, t, n] gives the n ^th coefficient in the Fourier sine series expansion of expr.\nFourierSinCoefficient[expr, {t1, t2, …}, {n1, n2, …}] gives a multidimensional Fourier sine coefficient." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierSinCoefficient)))
(def FourierSinSeries "FourierSinSeries[expr, t, n] gives the n ^th-order Fourier sine series expansion of expr in t.\nFourierSinSeries[expr, {t1, t2, …}, {n1, n2, …}] gives the multidimensional Fourier sine series of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierSinSeries)))
(def FourierSinTransform "FourierSinTransform[expr, t, ω] gives the symbolic Fourier sine transform of expr. \nFourierSinTransform[expr, {t1, t2, …}, {ω1, ω2, …}] gives the multidimensional Fourier sine transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierSinTransform)))
(def FourierTransform "FourierTransform[expr, t, ω] gives the symbolic Fourier transform of expr. \nFourierTransform[expr, {t1, t2, …}, {ω1, ω2, …}] gives the multidimensional Fourier transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierTransform)))
(def FourierTrigSeries "FourierTrigSeries[expr, t, n] gives the n ^th-order Fourier trigonometric series expansion of expr in t.\nFourierTrigSeries[expr, {t1, t2, …}, {n1, n2, …}] gives the multidimensional Fourier trigonometric series of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FourierTrigSeries)))
(def FoxH "FoxH[{{{a1, α1}, …, {an, αn}}, {{a n+1, α n+1}, …, {ap, αp}}}, {{{b1, β1}, …, {bm, βm}}, {{b m+1, β m+1}, …, {bq, βq}}}, z] is the Fox H-function H _p, q^m, n(z(a1, α1), …, (ap, αp)\n(b1, β1), …, (bq, βq)\n\n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoxH)))
(def FoxHReduce "FoxHReduce[expr, x] attempts to reduce expr to a single FoxH object as a function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FoxHReduce)))
(def FractionBox "FractionBox[x, y] is a low-level formatting construct that represents x/y in notebook expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionBox)))
(def FractionBoxOptions "FractionBoxOptions is an option that specifies settings for FractionBox objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionBoxOptions)))
(def FractionalBrownianMotionProcess "FractionalBrownianMotionProcess[μ, σ, h] represents fractional Brownian motion process with drift μ, volatility σ, and Hurst index h.\nFractionalBrownianMotionProcess[h] represents fractional Brownian motion process with drift 0, volatility 1, and Hurst index h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionalBrownianMotionProcess)))
(def FractionalD "FractionalD[f, {x, α}] gives the Riemann–Liouville fractional derivative 0D_x^αf(x) of order α of the function f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionalD)))
(def FractionalGaussianNoiseProcess "FractionalGaussianNoiseProcess[μ, σ, h] represents a fractional Gaussian noise process with drift μ, volatility σ, and Hurst index h.\nFractionalGaussianNoiseProcess[h] represents a fractional Gaussian noise process with drift 0, volatility 1, and Hurst index h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionalGaussianNoiseProcess)))
(def FractionalPart "FractionalPart[x] gives the fractional part of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FractionalPart)))
(def Frame "Frame is an option for Graphics, Grid, and other constructs that specifies whether to include a frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Frame)))
(def FrameBox "FrameBox[box] is a low-level box construct that represents box with a frame drawn around it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameBox)))
(def FrameBoxOptions "FrameBoxOptions is an option that specifies default settings for FrameBox objects." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameBoxOptions)))
(def FrameLabel "FrameLabel is an option for Graphics, Manipulate, and related functions that specifies labels to be placed on the edges of a frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameLabel)))
(def FrameListVideo "FrameListVideo[{image1, image2, …}] generates a video containing frames image1, image2, etc.\nFrameListVideo[files] generates a video from existing image files." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameListVideo)))
(def FrameMargins "FrameMargins is an option for objects that can be displayed with frames which specifies the absolute margins in printer's points to leave inside the frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameMargins)))
(def FrameRate "FrameRate is an option to specify the number of frames per second." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameRate)))
(def FrameStyle "FrameStyle is an option for Graphics, Grid, and other constructs that specifies the style in which to draw frames." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameStyle)))
(def FrameTicks "FrameTicks is an option for 2D graphics functions that specifies tick marks for the edges of a frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameTicks)))
(def FrameTicksStyle "FrameTicksStyle is an option for 2D graphics functions that specifies how frame ticks should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrameTicksStyle)))
(def Framed "Framed[expr] displays a framed version of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Framed)))
(def FrechetDistribution "FrechetDistribution[α, β] represents the Fréchet distribution with shape parameter α and scale parameter β.\nFrechetDistribution[α, β, μ] represents the Fréchet distribution with shape parameter α, scale parameter β, and location parameter μ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrechetDistribution)))
(def FreeQ "FreeQ[expr, form] yields True if no subexpression in expr matches form, and yields False otherwise. \nFreeQ[expr, form, levelspec] tests only those parts of expr on levels specified by levelspec. \nFreeQ[form] represents an operator form of FreeQ that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FreeQ)))
(def FreeformEvaluate "FreeformEvaluate[\"query\"] or =[query] interprets query using Wolfram|Alpha and computes the result.\nFreeformEvaluate[\"query\", h] interprets query and wraps the result of interpretation in the head h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FreeformEvaluate)))
(def FrenetSerretSystem "FrenetSerretSystem[{x1, …, xn}, t] gives the generalized curvatures and Frenet–Serret basis for the parametric curve xi[t].\nFrenetSerretSystem[{x1, …, xn}, t, chart] interprets the xi as coordinates in the specified coordinate chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrenetSerretSystem)))
(def FrequencySamplingFilterKernel "FrequencySamplingFilterKernel[{a1, …, ak}] creates a finite impulse response (FIR) filter kernel using a frequency sampling method from amplitude values ai.\nFrequencySamplingFilterKernel[{a1, …, ak}, m] creates an FIR filter kernel of type m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrequencySamplingFilterKernel)))
(def FresnelC "FresnelC[z] gives the Fresnel integral C (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FresnelC)))
(def FresnelF "FresnelF[z] gives the Fresnel auxiliary function F (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FresnelF)))
(def FresnelG "FresnelG[z] gives the Fresnel auxiliary function G (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FresnelG)))
(def FresnelS "FresnelS[z] gives the Fresnel integral S (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FresnelS)))
(def Friday "Friday is a day of the week." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Friday)))
(def FrobeniusAutomorphism "FrobeniusAutomorphism[a] gives the value of the Frobenius automorphism at the finite field element a.\nFrobeniusAutomorphism[a, k] gives the value of the k^th functional power of the Frobenius automorphism at a." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrobeniusAutomorphism)))
(def FrobeniusNumber "FrobeniusNumber[{a1, …, an}] gives the Frobenius number of a1, …, an." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrobeniusNumber)))
(def FrobeniusSolve "FrobeniusSolve[{a1, …, an}, b] gives a list of all solutions of the Frobenius equation a1 x1+…+an xnb.\nFrobeniusSolve[{a1, …, an}, b, m] gives at most m solutions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrobeniusSolve)))
(def FromAbsoluteTime "FromAbsoluteTime[time] gives a date object corresponding to an absolute time specification as given by AbsoluteTime." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromAbsoluteTime)))
(def FromCharacterCode "FromCharacterCode[n] gives a string consisting of the character with integer code n. \nFromCharacterCode[{n1, n2, …}] gives a string consisting of the sequence of characters with codes ni. \nFromCharacterCode[{{n11, n12, …}, {n21, …}, …}] gives a list of strings. \nFromCharacterCode[codes, \"encoding\"] uses the specified character encoding." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromCharacterCode)))
(def FromCoefficientRules "FromCoefficientRules[list, {x1, x2, …}] constructs a polynomial from a list of rules for exponent vectors and coefficients." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromCoefficientRules)))
(def FromContinuedFraction "FromContinuedFraction[list] reconstructs a number from the list of its continued fraction terms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromContinuedFraction)))
(def FromDMS "FromDMS[{d, m, s}] converts from degrees, minutes, and seconds to decimal degrees. \nFromDMS[\"dms\"] converts from a DMS string to decimal degrees.\nFromDMS[\"latlon\"] converts from a latitude-longitude string to latitude and longitude in decimal degrees." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromDMS)))
(def FromDateString "FromDateString[\"string\"] gives a date object corresponding to the date represented by \"string\".\nFromDateString[\"string\", {e1, e2, …}] gives the date object obtained by extracting elements \"ei\" from \"string\".\nFromDateString[\"string\", fmt] gives the date object obtained using the date format fmt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromDateString)))
(def FromDigits "FromDigits[list] constructs an integer from the list of its decimal digits. \nFromDigits[list, b] takes the digits to be given in base b. \nFromDigits[list, MixedRadix[blist]] uses the mixed radix with list of bases blist. \nFromDigits[\"string\"] constructs an integer from a string of digits.\nFromDigits[\"string\", \"Roman\"] constructs an integer from Roman numerals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromDigits)))
(def FromEntity "FromEntity[entity] returns a Wolfram Language object corresponding to an entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromEntity)))
(def FromFiniteField "FromFiniteField[a, ff] converts the element a of the prime subfield of the finite field ff to an integer.\nFromFiniteField[expr, ff, t] converts the elements of the finite field ff in the coefficients of the rational expression expr to polynomials in t, where t represents the field generator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromFiniteField)))
(def FromFiniteFieldIndex "FromFiniteFieldIndex[ind, ff] gives the element of the finite field ff with index ind." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromFiniteFieldIndex)))
(def FromJulianDate "FromJulianDate[jd] gives a date object corresponding to the Julian date jd.\nFromJulianDate[\"type\", jd] gives a date object corresponding to the specified Julian date variant." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromJulianDate)))
(def FromLetterNumber "FromLetterNumber[n] gives the lowercase letter at position n in the English alphabet.\nFromLetterNumber[n, alpha] gives the letter at position n in the alphabet specified by alpha." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromLetterNumber)))
(def FromLunationNumber "FromLunationNumber[ln] returns the date corresponding to the lunation number ln.\nFromLunationNumber[scheme, ln] returns the date corresponding to the lunation number in the given counting scheme." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromLunationNumber)))
(def FromPolarCoordinates "FromPolarCoordinates[{r, θ}] gives the {x, y} Cartesian coordinates corresponding to the polar coordinates {r, θ}. \nFromPolarCoordinates[{r, θ1, …, θ n-2, ϕ}] gives the coordinates corresponding to the hyperspherical coordinates {r, θ1, …, θ n-2, ϕ}" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromPolarCoordinates)))
(def FromRawPointer "FromRawPointer[p] returns the value referred to by the pointer p for use in compiled code.\nFromRawPointer[array, offset] returns the value of a C array at an offset." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromRawPointer)))
(def FromRomanNumeral "FromRomanNumeral[\"string\"] gives the integer corresponding to the Roman numeral \"string\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromRomanNumeral)))
(def FromSphericalCoordinates "FromSphericalCoordinates[{r, θ, ϕ}] gives the {x, y, z} Cartesian coordinates corresponding to the spherical coordinates {r, θ, ϕ}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromSphericalCoordinates)))
(def FromUnixTime "FromUnixTime[time] gives a date object corresponding to a UnixTime specification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FromUnixTime)))
(def Front "Front is a symbol that represents the front of a graphic for purposes of placement and alignment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Front)))
(def FrontEndDynamicExpression "FrontEndDynamicExpression is a global front end option that specifies an expression to be dynamically updated whenever the front end is running." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrontEndDynamicExpression)))
(def FrontEndEventActions "FrontEndEventActions is an option for the notebook front end that gives a list of actions to perform when specified user-interface events occur." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrontEndEventActions)))
(def FrontEndExecute "FrontEndExecute[expr] sends expr to be executed by the Wolfram System front end." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrontEndExecute)))
(def FrontEndToken "FrontEndToken[\"cmd\"] is an object that represents a front end command token, typically corresponding to a front end menu item, to be executed by FrontEndExecute. \nFrontEndToken[nb, \"cmd\"] represents a command that targets the specified notebook. \nFrontEndToken[nb, \"cmd\", param] represents a command with a parameter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrontEndToken)))
(def FrontEndTokenExecute "FrontEndTokenExecute[\"cmd\"] executes the specified front end command token, typically corresponding to a front end menu item." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FrontEndTokenExecute)))
(def Full "Full is a setting used for certain options, typically indicating that a full range of values should be included." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Full)))
(def FullDefinition "FullDefinition[symbol] prints as the definitions given for symbol, and all symbols on which these depend.\nFullDefinition[\"symbol\"] prints as the definitions given for the symbol named \"symbol\" if it exists, and all symbols on which these depend.\nFullDefinition[patt] prints as the definitions given for the symbols whose names textually match the arbitrary string pattern patt, and all symbols on which these depend.\nFullDefinition[{spec1, spec2, …}] prints as the definitions given for the symbols that are equal to or whose names match any of the speci, and all symbols on which these depend." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullDefinition)))
(def FullForm "FullForm[expr] prints as the full form of expr, with no special syntax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullForm)))
(def FullGraphics "FullGraphics[g] takes a graphics object, and generates a new one in which objects specified by graphics options are given as explicit lists of graphics primitives." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullGraphics)))
(def FullInformationOutputRegulator "FullInformationOutputRegulator[sys, rspec] gives the full state information output regulator for sys using specification rspec. \nFullInformationOutputRegulator[{sys, {out1, …}, {in1, …}}, …] specifies the regulated outputs outi and the controlled inputs inj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullInformationOutputRegulator)))
(def FullMoon "FullMoon[] gives the date of the next full moon.\nFullMoon[date] gives the date of the first full moon after the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullMoon)))
(def FullRegion "FullRegion[n] represents the full region ^n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullRegion)))
(def FullSimplify "FullSimplify[expr] tries a wide range of transformations on expr involving elementary and special functions and returns the simplest form it finds. \nFullSimplify[expr, assum] does simplification using assumptions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FullSimplify)))
(def Function "body& or Function[body] is a pure (or \"anonymous\") function. The formal parameters are # (or #1), #2, etc. \nx|->body or xbody or Function[x, body] is a pure function with a single formal parameter x. \n{x1, x2, …}|->body or {x1, x2, …}body or Function[{x1, x2, …}, body] is a pure function with a list of formal parameters. \nFunction[params, body, attrs] is a pure function that is treated as having attributes attrs for purposes of evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Function)))
(def FunctionAnalytic "FunctionAnalytic[f, x] tests whether f(x) is an analytic function for x∈Reals.\nFunctionAnalytic[f, x, dom] tests whether f(x) is an analytic function for x∈dom.\nFunctionAnalytic[{f1, f2, …}, {x1, x2, …}, dom] tests whether f1(x1, x2, …), f2(x1, x2, …), … are analytic functions for x1, x2, …∈dom.\nFunctionAnalytic[{funs, cons}, xvars, dom] tests whether funs(xvars) are analytic functions for xvars in an open set containing the solutions of the constraints cons over the domain dom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionAnalytic)))
(def FunctionBijective "FunctionBijective[f, x] tests whether f(x)y has exactly one solution x∈Reals for each y∈Reals.\nFunctionBijective[f, x, dom] tests whether f(x)y has exactly one solution x∈dom for each y∈dom.\nFunctionBijective[{f1, f2, …}, {x1, x2, …}, dom] tests whether f1(x1, x2, …)y1, f2(x1, x2, …)y2, … has exactly one solution x1, x2, …∈dom for each y1, y2, …∈dom.\nFunctionBijective[{funs, xcons, ycons}, xvars, yvars, dom] tests whether funs(xvars)yvars has exactly one solution with xvars∈dom restricted by the constraints xcons for each yvars∈dom restricted by the constraints ycons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionBijective)))
(def FunctionCompile "FunctionCompile[f] generates a compiled code function from a pure function.\nFunctionCompile[{f1, f2, …}] generates a list of compiled code functions from a list of pure functions.\nFunctionCompile[k1f1, k2f2, …] generates an association of compiled code functions from an association of Wolfram Language functions.\nFunctionCompile[defs, fspec] uses the local auxiliary definitions defs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionCompile)))
(def FunctionCompileExport "FunctionCompileExport[\"file.ext\", fspec] exports a compiled version of functions fspec in the format specified by the file extension ext.\nFunctionCompileExport[path, defs, fspec] exports a compiled version of fspec using local auxiliary definitions defs.\nFunctionCompileExport[path, fspec, \"format\"] exports in the specified format.\nFunctionCompileExport[path, defs, fspec, \"format\"] exports a compiled version using local auxiliary definitions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionCompileExport)))
(def FunctionCompileExportByteArray "FunctionCompileExportByteArray[fspec] gives a byte array of binary LLVM code obtained by compiling the function specification fspec.\nFunctionCompileExportByteArray[defs, fspec] uses the auxiliary definitions defs for compilation.\nFunctionCompileExportByteArray[fspec, \"format\"] gives a byte array of binary code in the specified format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionCompileExportByteArray)))
(def FunctionCompileExportLibrary "FunctionCompileExportLibrary[file, fspec] exports a compiled version of function specification fspec as a shared library suitable for external use.\nFunctionCompileExportLibrary[file, defs, fspec] uses the auxiliary definitions defs for compilation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionCompileExportLibrary)))
(def FunctionCompileExportString "FunctionCompileExportString[fspec] gives a string of textual LLVM code obtained by compiling the function specification fspec.\nFunctionCompileExportString[defs, fspec] uses the auxiliary definitions defs for compilation.\nFunctionCompileExportString[fspec, \"format\"] gives a string of textual code in the specified format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionCompileExportString)))
(def FunctionContinuous "FunctionContinuous[f, x] tests whether f(x) is a real-valued continuous function for x∈Reals.\nFunctionContinuous[f, x, dom] tests whether f(x) is a continuous function for x∈dom.\nFunctionContinuous[{f1, f2, …}, {x1, x2, …}, dom] tests whether f1(x1, x2, …), f2(x1, x2, …), … are continuous functions for x1, x2, …∈dom.\nFunctionContinuous[{funs, cons}, xvars, dom] tests whether funs(xvars) are continuous functions for xvars∈dom restricted by the constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionContinuous)))
(def FunctionConvexity "FunctionConvexity[f, {x1, x2, …}] finds the convexity of the function f with variables x1, x2, … over the reals.\nFunctionConvexity[{f, cons}, {x1, x2, …}] finds the convexity when variables are restricted by the constraints cons representing a convex region." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionConvexity)))
(def FunctionDeclaration "FunctionDeclaration[name, typedfun] declares name to be a typed function suitable for use in a compiler environment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionDeclaration)))
(def FunctionDiscontinuities "FunctionDiscontinuities[f, x] finds the discontinuities of f(x) for x∈Reals. \nFunctionDiscontinuities[f, x, dom] finds the discontinuities of f(x) for x∈dom.\nFunctionDiscontinuities[{f1, f2, …}, {x1, x2, …}, dom] finds the discontinuities of f1(x1, x2, …), f2(x1, x2, …), … for x1, x2, …∈dom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionDiscontinuities)))
(def FunctionDomain "FunctionDomain[f, x] finds the largest domain of definition of the real function f of the variable x. \nFunctionDomain[f, x, dom] considers f to be a function with arguments and values in the domain dom.\nFunctionDomain[funs, vars, dom] finds the largest domain of definition of the mapping funs of the variables vars. \nFunctionDomain[{funs, cons}, vars, dom] finds the domain of funs with the values of vars restricted by constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionDomain)))
(def FunctionExpand "FunctionExpand[expr] tries to expand out special and certain other functions in expr, when possible reducing compound arguments to simpler ones. \nFunctionExpand[expr, assum] expands using assumptions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionExpand)))
(def FunctionInjective "FunctionInjective[f, x] tests whether f(x)y has at most one solution x∈Reals for each y.\nFunctionInjective[f, x, dom] tests whether f(x)y has at most one solution x∈dom. \nFunctionInjective[{f1, f2, …}, {x1, x2, …}, dom] tests whether f1(x1, x2, …)y1, f2(x1, x2, …)y2, … has at most one solution x1, x2, …∈dom.\nFunctionInjective[{funs, xcons, ycons}, xvars, yvars, dom] tests whether funs(xvars)yvars has at most one solution with xvars∈dom restricted by the constraints xcons for each yvars∈dom restricted by the constraints ycons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionInjective)))
(def FunctionInterpolation "FunctionInterpolation[expr, {x, xmin, xmax}] evaluates expr with x running from xmin to xmax and constructs an InterpolatingFunction object which represents an approximate function corresponding to the result. \nFunctionInterpolation[expr, {x, xmin, xmax}, {y, ymin, ymax}, …] constructs an InterpolatingFunction object with several arguments." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionInterpolation)))
(def FunctionLayer "FunctionLayer[f] represents a net layer that applies function f to its input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionLayer)))
(def FunctionMeromorphic "FunctionMeromorphic[f, x] tests whether f(x) is a meromorphic function of x.\nFunctionMeromorphic[f, {x1, x2, …}] tests whether f1(x1, x2, …) is a meromorphic function of x1, x2, ….\nFunctionMeromorphic[{f1, f2, …}, {x1, x2, …}] tests whether f1(x1, x2, …), f2(x1, x2, …), … are meromorphic functions for x1, x2, ….\nFunctionMeromorphic[{funs, cons}, xvars] tests whether funs(xvars) are meromorphic functions for xvars in an open set containing the solutions of the constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionMeromorphic)))
(def FunctionMonotonicity "FunctionMonotonicity[f, x] finds the monotonicity of the function f with the variable x over the reals.\nFunctionMonotonicity[f, x, dom] finds the monotonicity of f when x is restricted to the domain dom.\nFunctionMonotonicity[{f, cons}, x, dom] gives the monotonicity of f when x is restricted by the constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionMonotonicity)))
(def FunctionPeriod "FunctionPeriod[f, x] gives a period p of the function f over the reals such that f(x+p)f (x).\nFunctionPeriod[f, x, dom] gives a period with x restricted to the domain dom.\nFunctionPeriod[{f1, f2, …}, {x1, x2, …}, …] gives periods {p1, p2, …} for {x1, x2, …} such that f(x1+p1, x2+p2, …)f (x1, x2, …)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionPeriod)))
(def FunctionPoles "FunctionPoles[f, x] finds the poles of the meromorphic function f with the variable x.\nFunctionPoles[{f, cons}, x] gives the poles of f when x is restricted by the constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionPoles)))
(def FunctionRange "FunctionRange[f, x, y] finds the range of the real function f of the variable x returning the result in terms of y.\nFunctionRange[f, x, y, dom] considers f to be a function with arguments and values in the domain dom.\nFunctionRange[funs, xvars, yvars, dom] finds the range of the mapping funs of the variables xvars returning the result in terms of yvars.\nFunctionRange[{funs, cons}, xvars, yvars, dom] finds the range of the mapping funs with the values of xvars restricted by constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionRange)))
(def FunctionSign "FunctionSign[f, {x1, x2, …}] finds the real sign of the function f with variables x1, x2, … over the reals.\nFunctionSign[f, {x1, x2, …}, dom] finds the real sign with variables restricted to the domain dom. \nFunctionSign[{f, cons}, {x1, x2, …}, dom] gives the sign when variables are restricted by the constraints cons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionSign)))
(def FunctionSingularities "FunctionSingularities[f, x] finds the singularities of f(x) for x∈Reals. \nFunctionSingularities[f, x, dom] finds the singularities of f(x) for x∈dom.\nFunctionSingularities[{f1, f2, …}, {x1, x2, …}, dom] finds the singularities of f1(x1, x2, …), f2(x1, x2, …), … for x1, x2, …∈dom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionSingularities)))
(def FunctionSpace "FunctionSpace is an option for FindSequenceFunction and related functions that specifies the space of functions to consider for representations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionSpace)))
(def FunctionSurjective "FunctionSurjective[f, x] tests whether f(x)y has at least one solution x∈ for each y∈Reals.\nFunctionSurjective[f, x, dom] tests whether f(x)y has at least one solution x∈dom for each y∈dom.\nFunctionSurjective[{f1, f2, …}, {x1, x2, …}, dom] tests whether f1(x1, x2, …)y1, f2(x1, x2, …)y2, … has at least one solution x1, x2, …∈dom for each y1, y2, …∈dom.\nFunctionSurjective[{funs, xcons, ycons}, xvars, yvars, dom] tests whether funs(xvars)yvars has at least one solution with xvars∈dom restricted by the constraints xcons for each yvars∈dom restricted by the constraints ycons." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FunctionSurjective)))
(def FussellVeselyImportance "FussellVeselyImportance[rdist, t] gives the Fussell–Vesely importances for all components in the ReliabilityDistribution rdist at time t.\nFussellVeselyImportance[fdist, t] gives the Fussell–Vesely importances for all components in the FailureDistribution fdist at time t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote FussellVeselyImportance)))
(def GARCHProcess "GARCHProcess[κ, {α1, …, αq}, {β1, …, βp}] represents a generalized autoregressive conditionally heteroscedastic process of orders p and q, driven by a standard white noise.\nGARCHProcess[κ, {α1, …, αq}, {β1, …, βp}, init] represents a GARCH process with initial data init." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GARCHProcess)))
(def GCD "GCD[n1, n2, …] gives the greatest common divisor of the ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GCD)))
(def GaborFilter "GaborFilter[data, r, k] filters data by convolving with a Gabor kernel of pixel radius r and wave vector k.\nGaborFilter[data, r, k, ϕ] uses a Gabor kernel with phase shift ϕ.\nGaborFilter[data, {r, σ}, …]  uses a Gabor kernel with radius r  and standard deviation σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaborFilter)))
(def GaborMatrix "GaborMatrix[r, k] gives a matrix that corresponds to the real part of a Gabor kernel of radius r and wave vector k.\nGaborMatrix[r, k, ϕ] uses phase shift ϕ.\nGaborMatrix[{r, σ}, …] uses the specified standard deviation σ.\nGaborMatrix[{{r1, r2, …}}, …] gives an array corresponding to a Gabor kernel with radius ri in the i ^th index direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaborMatrix)))
(def GaborWavelet "GaborWavelet[] represents a Gabor wavelet of frequency 6.\nGaborWavelet[w] represents a Gabor wavelet of frequency w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaborWavelet)))
(def GainMargins "GainMargins[lsys] gives the gain margins of the linear time-invariant system lsys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GainMargins)))
(def GainPhaseMargins "GainPhaseMargins[lsys] gives the gain and phase margins of the linear time-invariant system lsys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GainPhaseMargins)))
(def GalaxyData "GalaxyData[entity, property] gives the value of the specified property for the galaxy entity.\nGalaxyData[{entity1, entity2, …}, property] gives a list of property values for the specified galaxy entities.\nGalaxyData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GalaxyData)))
(def GalleryView "GalleryView[{expr1, expr2, …}] represents an object in which the expri are displayed in a browsable gallery layout.\nGalleryView[{assoc1, assoc2, …}] uses each of the associations associ to define the display of an item in the gallery." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GalleryView)))
(def Gamma "Gamma[z] is the Euler gamma function Γ (z). \nGamma[a, z] is the incomplete gamma function Γ (a, z). \nGamma[a, z0, z1] is the generalized incomplete gamma function Γ(a, z0)-Γ (a, z1)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Gamma)))
(def GammaDistribution "GammaDistribution[α, β] represents a gamma distribution with shape parameter α and scale parameter β.\nGammaDistribution[α, β, γ, μ] represents a generalized gamma distribution with shape parameters α and γ, scale parameter β, and location parameter μ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GammaDistribution)))
(def GammaRegularized "GammaRegularized[a, z] is the regularized incomplete gamma function Q (a, z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GammaRegularized)))
(def GapPenalty "GapPenalty is an option for SequenceAlignment and related functions that gives the additional cost associated with each gap corresponding to a run of insertions or deletions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GapPenalty)))
(def GatedRecurrentLayer "GatedRecurrentLayer[n] represents a trainable recurrent layer that takes a sequence of vectors and produces a sequence of vectors each of size n.\nGatedRecurrentLayer[n, opts] includes options for initial weights and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GatedRecurrentLayer)))
(def Gather "Gather[list] gathers the elements of list into sublists of identical elements.\nGather[list, test] applies test to pairs of elements to determine if they should be considered identical." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Gather)))
(def GatherBy "GatherBy[list, f] gathers into sublists each set of elements in list that gives the same value when f is applied.\nGatherBy[list, {f1, f2, …}] gathers list into nested sublists using fi at level i." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GatherBy)))
(def GaugeFaceElementFunction "GaugeFaceElementFunction is an option for gauge functions that gives a function to use to generate the primitives for rendering the gauge face." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeFaceElementFunction)))
(def GaugeFaceStyle "GaugeFaceStyle is an option for gauge functions that specifies the style in which the face is to be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeFaceStyle)))
(def GaugeFrameElementFunction "GaugeFrameElementFunction is an option for gauge functions that gives a function to generate the primitives for rendering the gauge frame." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeFrameElementFunction)))
(def GaugeFrameSize "GaugeFrameSize is an option for gauge functions that controls the size of the frame around the gauge." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeFrameSize)))
(def GaugeFrameStyle "GaugeFrameStyle is an option for gauge functions that specifies the style in which the frame is to be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeFrameStyle)))
(def GaugeLabels "GaugeLabels is an option for gauge functions that specifies labels to be placed on the gauge." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeLabels)))
(def GaugeMarkers "GaugeMarkers is an option for gauge functions that specifies what markers to draw to mark the values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeMarkers)))
(def GaugeStyle "GaugeStyle is an option for gauge functions that specifies styles in which the markers are to be drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaugeStyle)))
(def GaussianFilter "GaussianFilter[data, r] filters data by convolving with a Gaussian kernel of radius r.\nGaussianFilter[data, r, {n1, n2, …}] convolves data with a kernel formed from the ni ^th derivatives of the discrete Gaussian.\nGaussianFilter[data, {r, σ}, …]  uses a Gaussian kernel with radius r and standard deviation σ.\nGaussianFilter[data, {{r1, r2, …}, …}] uses radius ri at level i in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianFilter)))
(def GaussianIntegers "GaussianIntegers is an option for FactorInteger, PrimeQ, Factor, and related functions that specifies whether factorization should be done over Gaussian integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianIntegers)))
(def GaussianMatrix "GaussianMatrix[r] gives a matrix that corresponds to a Gaussian kernel of radius r. \nGaussianMatrix[{r, σ}] gives a matrix corresponding to a Gaussian kernel with radius r and standard deviation σ.\nGaussianMatrix[r, {n1, n2}] gives a matrix formed from the n1 ^th derivative of the Gaussian with respect to rows and the n2 ^th derivative with respect to columns.\nGaussianMatrix[r, {{n11, n12}, {n21, n22}, …}] gives a matrix formed from the sums of the n i1 and n i2 derivatives.\nGaussianMatrix[{{r1, r2, …}, σ}, …] gives an array corresponding to a Gaussian kernel with radius ri in the i ^th index direction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianMatrix)))
(def GaussianOrthogonalMatrixDistribution "GaussianOrthogonalMatrixDistribution[σ, n] represents a Gaussian orthogonal matrix distribution with matrix dimensions {n, n} and scale parameter σ.\nGaussianOrthogonalMatrixDistribution[n] represents a Gaussian orthogonal matrix distribution with unit scale parameter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianOrthogonalMatrixDistribution)))
(def GaussianSymplecticMatrixDistribution "GaussianSymplecticMatrixDistribution[σ, n] represents a Gaussian symplectic matrix distribution with matrix dimensions {2 n, 2 n} over the field of complex numbers and scale parameter σ.\nGaussianSymplecticMatrixDistribution[n] represents a Gaussian symplectic matrix distribution with unit scale parameter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianSymplecticMatrixDistribution)))
(def GaussianUnitaryMatrixDistribution "GaussianUnitaryMatrixDistribution[σ, n] represents a Gaussian unitary matrix distribution with matrix dimensions {n, n} and scale parameter σ.\nGaussianUnitaryMatrixDistribution[n] represents a Gaussian unitary matrix distribution with unit scale parameter." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianUnitaryMatrixDistribution)))
(def GaussianWindow "GaussianWindow[x] represents a Gaussian window function of x.\nGaussianWindow[x, σ] uses standard deviation σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GaussianWindow)))
(def GegenbauerC "GegenbauerC[n, m, x] gives the Gegenbauer polynomial C _n^(m)(x). \nGegenbauerC[n, x] gives the renormalized form Underscript[\"lim\", m0]\nSubsuperscriptBox[\"C\", \nTemplateArgBox[\"n\"], \nRowBox[{\"(\", \nTemplateArgBox[\"m\"], \")\"}]](\nTemplateArgBox[\"x\"])/m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GegenbauerC)))
(def General "General is a symbol to which general system messages are attached." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote General)))
(def GeneralizedLinearModelFit "GeneralizedLinearModelFit[{{x1, y1}, {x2, y2}, …}, {f1, f2, …}, x] constructs a generalized linear model of the form g^-1 (β0+β1 f1+β2 f2+…) that fits the yi for each xi.\nGeneralizedLinearModelFit[data, {f1, f2, …}, {x1, x2, …}] constructs a generalized linear model of the form g^-1 (β0+β1 f1+β2 f2+…) where the fi depend on the variables xk.\nGeneralizedLinearModelFit[{m, v}] constructs a generalized linear model from the design matrix m and response vector v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneralizedLinearModelFit)))
(def GenerateAsymmetricKeyPair "GenerateAsymmetricKeyPair[] randomly generates a PrivateKey and corresponding PublicKey object for use with public-key cryptographic functions.\nGenerateAsymmetricKeyPair[type] randomly generates private and public keys of the specified type.\nGenerateAsymmetricKeyPair[opts] randomly generates keys using the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateAsymmetricKeyPair)))
(def GenerateConditions "GenerateConditions is an option for Integrate, Sum, and similar functions that specifies whether explicit conditions on parameters should be generated in the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateConditions)))
(def GenerateDerivedKey "GenerateDerivedKey[password] generates a DerivedKey object from the password given.\nGenerateDerivedKey[password, salt] generates a DerivedKey object from the password and salt given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateDerivedKey)))
(def GenerateDigitalSignature "GenerateDigitalSignature[expr, key] generates a digital signature for expr using the specified private key.\nGenerateDigitalSignature[key] represents an operator form of GenerateDigitalSignature that can be applied to expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateDigitalSignature)))
(def GenerateDocument "GenerateDocument[nb] generates a document by evaluating all template elements in the notebook nb.\nGenerateDocument[nb, args] generates a document using args to fill template slots.\nGenerateDocument[nb, output] writes the generated document in the output file represented by output.\nGenerateDocument[nb, args, output] uses args to fill template slots and puts the result in output." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateDocument)))
(def GenerateFileSignature "GenerateFileSignature[\"file\", key] generates a digital signature of file using the specified private key.\nGenerateFileSignature[{\"file\", range}, key] generates a digital signature of the specified range of bytes in the file.\nGenerateFileSignature[{{file1, range1}, {file2, range2}, …}, key] generates digital signatures for each specified filei and rangei.\nGenerateFileSignature[key] represents an operator form of GenerateFileSignature that can be applied to files." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateFileSignature)))
(def GenerateHTTPResponse "GenerateHTTPResponse[expr] gives the HTTPResponse object that is generated when a cloud object containing expr is requested on the web.\nGenerateHTTPResponse[expr, req] gives the response for the HTTP request specified by req." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateHTTPResponse)))
(def GenerateLLMToolResponse "GenerateLLMToolResponse[tool, req] gives the LLMToolResponse generated by executing tool on the LLMToolRequest req.\nGenerateLLMToolResponse[{tool1, tool2, …}, req] picks a tool based on req.\nGenerateLLMToolResponse[config, req] uses the tools from an LLMConfiguration." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateLLMToolResponse)))
(def GenerateSecuredAuthenticationKey "GenerateSecuredAuthenticationKey[] generates a new anonymous SecuredAuthenticationKey owned by the current user ID.\nGenerateSecuredAuthenticationKey[\"name\"] generates a new SecuredAuthenticationKey with the specified name owned by the current user ID.\nGenerateSecuredAuthenticationKey[SecuredAuthenticationKey[…]] generates a new set of credentials for an existing SecuredAuthenticationKey." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateSecuredAuthenticationKey)))
(def GenerateSymmetricKey "GenerateSymmetricKey[] randomly generates a SymmetricKey object suitable for use with cryptographic functions.\nGenerateSymmetricKey[\"password\"] derives a SymmetricKey object from the password string given.\nGenerateSymmetricKey[bytes] generates a SymmetricKey object using the byte array or list of bytes directly as the key.\nGenerateSymmetricKey[DerivedKey[…]] generates a symmetric key object with a key given by the DerivedKey object.\nGenerateSymmetricKey[opts] randomly generates a symmetric key using the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenerateSymmetricKey)))
(def GeneratedAssetFormat "GeneratedAssetFormat is an option for functions like VideoGenerator that specifies the format of the resulting asset." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedAssetFormat)))
(def GeneratedAssetLocation "GeneratedAssetLocation is an option for functions like VideoGenerator that specifies the location of the resulting asset." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedAssetLocation)))
(def GeneratedCell "GeneratedCell is an option for Cell that indicates whether the cell was generated from the kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedCell)))
(def GeneratedDocumentBinding "GeneratedDocumentBinding is an option for supplying parameters to a DocumentGenerator during manual evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedDocumentBinding)))
(def GeneratedParameters "GeneratedParameters is an option that specifies how parameters generated to represent the results of various symbolic operations should be named." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedParameters)))
(def GeneratedQuantityMagnitudes "GeneratedQuantityMagnitudes is an option that specifies how quantities generated to represent the quantity multiplier results in NondimensionalizationTransform should be named." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratedQuantityMagnitudes)))
(def GeneratingFunction "GeneratingFunction[expr, n, x] gives the generating function in x for the sequence whose n ^th series coefficient is given by the expression expr.\nGeneratingFunction[expr, {n1, …, nm}, {x1, …, xm}] gives the multidimensional generating function in x1, …, xm whose n1, … , nm coefficient is given by expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratingFunction)))
(def GeneratorDescription "GeneratorDescription is an option for providing a textual description for a DocumentGenerator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratorDescription)))
(def GeneratorHistoryLength "GeneratorHistoryLength is an option for document generators controlling the number of runs archived in the cloud." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratorHistoryLength)))
(def GeneratorOutputType "GeneratorOutputType is an option controlling the file format of documents produced by a DocumentGenerator." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeneratorOutputType)))
(def GenericCylindricalDecomposition "GenericCylindricalDecomposition[ineqs, {x1, x2, …}] finds the full-dimensional part of the decomposition of the region represented by the inequalities ineqs into cylindrical parts whose directions correspond to the successive xi, together with any hypersurfaces containing the rest of the region." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenericCylindricalDecomposition)))
(def GenomeData "GenomeData[\"gene\"] gives the DNA sequence for the specified gene on the reference human genome.\nGenomeData[\"gene\", \"property\"] gives the value of the specified property for the human gene gene.\nGenomeData[{\"chr\", {n1, n2}}] gives the sequence from positions n1 to n2 on chromosome chr in the reference human genome." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenomeData)))
(def GenomeLookup "GenomeLookup[\"seq\"] returns the positions of exact matches for the DNA sequence seq on the reference human genome.\nGenomeLookup[\"seq\", n] returns at most n matches." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GenomeLookup)))
(def GeoAntipode "GeoAntipode[loc] gives the antipodal position of location loc.\nGeoAntipode[g] gives the antipodal primitive of the geo primitive g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoAntipode)))
(def GeoArea "GeoArea[g] gives the area of the geo region g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoArea)))
(def GeoArraySize "GeoArraySize is an option for geographic data functions that determines the dimensions of the array generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoArraySize)))
(def GeoBackground "GeoBackground is an option that specifies the background style of a GeoGraphics object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBackground)))
(def GeoBoundary "GeoBoundary[g] returns the boundary line of the geo region g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBoundary)))
(def GeoBoundingBox "GeoBoundingBox[g] gives the geo positions that define the bounding rectangle enclosing the geo region g.\nGeoBoundingBox[g, δ] pads the region on all sides by an amount δ.\nGeoBoundingBox[g, Scaled[s]] pads by a fractional amount s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBoundingBox)))
(def GeoBounds "GeoBounds[g] gives the ranges of latitudes and longitudes in the geo region g.\nGeoBounds[g, δ] pads ranges of latitudes and longitudes by ±δ.\nGeoBounds[g, Scaled[s]] pads range of latitudes and longitudes by a scaled amount s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBounds)))
(def GeoBoundsRegion "GeoBoundsRegion[{{latmin, latmax}, {lonmin, lonmax}}] is a two-dimensional GeoGraphics primitive that represents a geo region bounded by parallels latmin, latmax and meridians lonmin, lonmax on the surface of the Earth.\nGeoBoundsRegion[g] represents the latitude-longitude bounding box of the geo region g.\nGeoBoundsRegion[g, δ] pads the ranges of latitudes and longitudes by ±δ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBoundsRegion)))
(def GeoBoundsRegionBoundary "GeoBoundsRegionBoundary[{{latmin, latmax}, {lonmin, lonmax}}] is a one-dimensional GeoGraphics primitive that represents the boundary of the region between parallels latmin, latmax and meridians lonmin, lonmax on the surface of the Earth.\nGeoBoundsRegionBoundary[g] represents the boundary of the latitude-longitude bounding box of the geo region g.\nGeoBoundsRegionBoundary[g, δ] pads the ranges of latitudes and longitudes by ±δ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBoundsRegionBoundary)))
(def GeoBubbleChart "GeoBubbleChart[{reg1val1, reg2val2, …}] makes a geo bubble chart with bubbles centered at the geographic regions regi with sizes vali.\nGeoBubbleChart[regionsvalues] uses a collection of regions regi from regions with corresponding sizes vali from values.\nGeoBubbleChart[{data1, data2, …}] plots data from all the datai.\nGeoBubbleChart[{…, w[datai], …}] plots datai with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoBubbleChart)))
(def GeoCenter "GeoCenter is an option for GeoGraphics that specifies the coordinates of the point that should appear at the geographic center of the final map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoCenter)))
(def GeoCircle "GeoCircle[loc, r] is a two-dimensional GeoGraphics primitive that represents a circle of radius r centered at the location loc on the surface of the Earth.\nGeoCircle[loc, r, {α1, α2}] represents a sector of a circle from bearing α1 to bearing α2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoCircle)))
(def GeoContourPlot "GeoContourPlot[{loc1val1, loc2val2, …}] makes a geo contour plot from values vali defined at specified locations loci.\nGeoContourPlot[locsvals] uses a collection of locations locs with corresponding values vals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoContourPlot)))
(def GeoDensityPlot "GeoDensityPlot[{loc1val1, loc2val2, …}] makes a geo density plot with colors at the location loci determined by the value vali.\nGeoDensityPlot[locsvals] uses a collection of locations locs with corresponding values vals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDensityPlot)))
(def GeoDestination "GeoDestination[loc, {d, α}] gives the end position of the geodesic of length d starting from loc with azimuthal direction α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDestination)))
(def GeoDirection "GeoDirection[{lat1, lon1}, {lat2, lon2}] gives the azimuthal direction from one latitude-longitude position on the Earth to another.\nGeoDirection[loc1, loc2] gives the azimuthal direction between locations specified by position objects or geographic entities." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDirection)))
(def GeoDisk "GeoDisk[loc, r]  is a two-dimensional GeoGraphics primitive that represents a filled disk of radius r centered at the location loc on the surface of the Earth.\nGeoDisk[loc, r, {α1, α2}] gives a sector of a disk from bearing α1 to bearing α2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDisk)))
(def GeoDisplacement "GeoDisplacement[{dist, α}] represents a geodesic displacement of length dist and initial bearing α from a geo location.\nGeoDisplacement[{dist, α}, pathtype] represents a displacement of length dist and initial bearing α along a path of type pathtype.\nGeoDisplacement[loc1, loc2, pathtype] returns the displacement needed to reach loc2 from loc1 along a path of type pathtype." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDisplacement)))
(def GeoDistance "GeoDistance[{lat1, lon1}, {lat2, lon2}] gives the geodesic distance between latitude-longitude positions on the Earth.\nGeoDistance[loc1, loc2] gives the distance between locations specified by position objects or geographical entities.\nGeoDistance[{loc1, …, locn}] gives the total distance from loc1 to locn through all the intermediate loci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDistance)))
(def GeoDistanceList "GeoDistanceList[{loc1, loc2, …, locn}] returns the list of geodesic distances between consecutive pairs of locations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoDistanceList)))
(def GeoElevationData "GeoElevationData[] gives the elevation above sea level at $GeoLocation.\nGeoElevationData[loc] gives the elevation at the geographic location loc.\nGeoElevationData[{loc1, loc2}] gives an array of elevation values within the bounding box given by {loc1, loc2}.\nGeoElevationData[GeoPosition[{{lat1, lon1}, {lat2, lon2}, …}]] gives the list of elevations at the positions {lati, loni}.\nGeoElevationData[loc, etype] gives the elevation of type etype for the location loc.\nGeoElevationData[loc, etype, format] gives the elevation in the specified format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoElevationData)))
(def GeoEntities "GeoEntities[reg, enttype] gives a list of the geographic entities of type enttype contained in the extended region reg.\nGeoEntities[reg] gives a list of the geographic regions of any type contained in reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoEntities)))
(def GeoGraphPlot "GeoGraphPlot[{e1, e2, …}] generates a plot of the geographic graph with edges ei.\nGeoGraphPlot[{v1, v2, …}, {e1, e2, …}] generates a plot with vertices vi and edges ej.\nGeoGraphPlot[{v iv j, …}] uses rules vivj to specify the graph.\nGeoGraphPlot[g] displays the graph g with vertices at geographic locations on a map.\nGeoGraphPlot[{…, w[ei], …}] plots ei with features defined by the symbolic wrapper w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGraphPlot)))
(def GeoGraphValuePlot "GeoGraphValuePlot[{{src1, dest1, flow1}, {src2, dest2, flow2}, …, {srcn, destn, flown}}] plots the flows between geo locations.\nGeoGraphValuePlot[{{e1, val1}, {e2, val2}, …}] plots the values vali for the edges ei.\nGeoGraphValuePlot[g] plots the flow for a graph g with associated edge weights." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGraphValuePlot)))
(def GeoGraphics "GeoGraphics[primitives, options] represents a two-dimensional geographical image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGraphics)))
(def GeoGridDirectionDifference "GeoGridDirectionDifference[proj, loc, β] gives the difference between the angle from north to direction β on the geo grid obtained with projection proj and the actual angle from north to direction β at location loc.\nGeoGridDirectionDifference[proj, loc, αβ] gives the difference between projected and unprojected angles from direction α to direction β." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridDirectionDifference)))
(def GeoGridLines "GeoGridLines is an option for GeoGraphics that specifies what parallels and meridians to show." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridLines)))
(def GeoGridLinesStyle "GeoGridLinesStyle is an option for GeoGraphics that specifies how parallels and meridians should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridLinesStyle)))
(def GeoGridPosition "GeoGridPosition[{x, y}, proj] represents a point {x, y} in a planimetric cartographic grid using the projection proj.\nGeoGridPosition[{x, y, h}, proj] represents a point {x, y, h} in a cartographic grid with height h with respect to the reference ellipsoid.\nGeoGridPosition[{{x1, y1}, {x2, y2}, …}, proj] represents an array of cartographic grid positions.\nGeoGridPosition[{x, y, h}, proj, datum] represents a point in a cartographic grid obtained by projection from data in the given datum.\nGeoGridPosition[entity, proj] returns the cartographic grid position of the specified geographical entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridPosition)))
(def GeoGridRange "GeoGridRange is an option for geographic functions that specifies the range of projected coordinates to include." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridRange)))
(def GeoGridRangePadding "GeoGridRangePadding is an option for geographic functions that specifies how much to extend the projected coordinate ranges determined by GeoGridRange." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridRangePadding)))
(def GeoGridUnitArea "GeoGridUnitArea[proj, loc] gives the actual geo area corresponding to a unit area on the geo grid obtained with projection proj, evaluated in the limit of small geo regions around location loc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridUnitArea)))
(def GeoGridUnitDistance "GeoGridUnitDistance[proj, loc, α] gives the actual geo distance corresponding to a unit distance on the geo grid obtained with projection proj, evaluated in the limit of small displacement from location loc in direction α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridUnitDistance)))
(def GeoGridVector "GeoGridVector[loc{vx, vy}, proj] represents a horizontal two-dimensional vector of components vx, vy in the orthonormal frame of the coordinates of the geo projection proj, at geo location loc.\nGeoGridVector[loc{vx, vy, vz}, proj] represents a three-dimensional vector of horizontal components vx, vy and vertical component vz at geo location loc.\nGeoGridVector[{loc1, loc2, …}{vec1, vec2, …}, proj] represents a collection of vectors veci at respective geo locations loci.\nGeoGridVector[{loc1vec1, loc2vec2, …}, proj] represents the same collection of vectors.\nGeoGridVector[vec, proj] represents a geo vector whose associated location has been implicitly specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGridVector)))
(def GeoGroup "GeoGroup[geoobjects] represents a list of geographic objects to be treated as a single object for certain operations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoGroup)))
(def GeoHemisphere "GeoHemisphere[] is a two-dimensional GeoGraphics primitive that represents the half of the Earth centered at your current geo location.\nGeoHemisphere[loc] represents the half of the Earth centered at the location loc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoHemisphere)))
(def GeoHemisphereBoundary "GeoHemisphereBoundary[] is a one-dimensional GeoGraphics primitive that represents the boundary line of a hemisphere of the Earth centered at the current geo location.\nGeoHemisphereBoundary[loc] represents the boundary line of a hemisphere centered at the location loc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoHemisphereBoundary)))
(def GeoHistogram "GeoHistogram[locs] plots a density histogram of the geographic locations locs.\nGeoHistogram[locs, bspec] plots a density histogram with bins specified by bspec.\nGeoHistogram[locs, bspec, hspec] plots a density histogram with bin densities computed according to the specification hspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoHistogram)))
(def GeoIdentify "GeoIdentify[enttype] identifies the geographic entities of the type enttype in which the current geo location is contained.\nGeoIdentify[enttype, loc] identifies the entities in which the location loc is contained.\nGeoIdentify[] identifies the entities of any type in which the current geo location is contained." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoIdentify)))
(def GeoImage "GeoImage[reg] gives a satellite image of the geo region reg.\nGeoImage[reg, mapstyle] gives an image of the geo region reg with style mapstyle." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoImage)))
(def GeoLabels "GeoLabels is an option for GeoListPlot and GeoRegionValuePlot that specifies whether and how to add labels to the locations in the first argument." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoLabels)))
(def GeoLength "GeoLength[g] gives the length of the geo path g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoLength)))
(def GeoListPlot "GeoListPlot[{loc1, loc2, …}] generates a map on which the locations loci are indicated.\nGeoListPlot[{list1, list2, …}]  generates a map showing several lists of locations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoListPlot)))
(def GeoLocation "GeoLocation is an option for Interpreter and related functions that specifies the location to assume for semantic interpretation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoLocation)))
(def GeoMarker "GeoMarker[] is a GeoGraphics primitive that represents a marker at the current $GeoLocation.\nGeoMarker[loc] is a GeoGraphics primitive that represents a marker at the location loc.\nGeoMarker[{loc1, loc2, …}] is a GeoGraphics primitive that represents markers at locations loci.\nGeoMarker[loc, marker] is a GeoGraphics primitive that represents a custom marker at the location loc.\nGeoMarker[{loc1, loc2, …}, marker] is a GeoGraphics primitive that represents custom markers at locations loci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoMarker)))
(def GeoModel "GeoModel is an option for GeoGraphics that specifies the reference body or model for it for the purposes of geodetic computations and map drawing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoModel)))
(def GeoNearest "GeoNearest[enttype, loc] returns the geographic entity of type enttype closest to the geo location loc.\nGeoNearest[{reg1, reg2, …, regn}, loc] returns the nearest of the regi.\nGeoNearest[{reg1val1, reg2val2, …, regnvaln}, loc] returns the vali corresponding to the nearest regi.\nGeoNearest[{reg1, reg2, …, regn}{val1, val2, …, valn}, loc] returns the same result.\nGeoNearest[{reg1, reg2, …, regn}Automatic, loc] takes the vali to be successive integers i. \nGeoNearest[spec, loc, n] returns n nearest values.\nGeoNearest[spec, loc, {n, r}] returns up to n matches within a radius r of loc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoNearest)))
(def GeoOrientationData "GeoOrientationData[date, prop] gives the value of the property prop about the orientation of the Earth on the given date.\nGeoOrientationData[date, prop, \"variant\"] gives the specified variant of the property prop on the given date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoOrientationData)))
(def GeoPath "GeoPath[{loc1, loc2}, pathtype] is a GeoGraphics primitive that represents a path of type pathtype between locations loc1 and loc2.\nGeoPath[{loc1, loc2, …}, pathtype] represents a path formed by joining paths of type pathtype between consecutive locations loci.\nGeoPath[{loc1, d, α}, pathtype] represents a path moving from location loc1 a distance d with initial bearing α.\nGeoPath[{{loc11, loc12, …}, {loc21, …}, …}, pathtype] represents a disjoint collection of paths of type pathtype." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoPath)))
(def GeoPolygon "GeoPolygon[{loc1, …, locn}] is a GeoGraphics primitive that represents a filled polygon whose boundary is formed by geodesic segments between locations loci and loc i+1.\nGeoPolygon[{loc1, …, locn}{{q1, …, qm}, …}] represents a geo polygon with holes {q1, …, qm}, ….\nGeoPolygon[{poly1, poly2, …}] represents a collection of polygons polyi.\nGeoPolygon[{poly1, poly2, …}, sideness] specifies which of the two sides of each boundary polyi is in the interior of the geo polygon.\nGeoPolygon[polys, sideness, pathtype] represents a geo polygon whose boundary is formed by geo paths of type pathtype." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoPolygon)))
(def GeoPosition "GeoPosition[{lat, lon}] represents a geodetic position with latitude lat and longitude lon.\nGeoPosition[{lat, lon, h}] represents a geodetic position with height h relative to the reference ellipsoid.\nGeoPosition[{lat, lon, h}, datum] represents a geodetic position referring to the specified datum.\nGeoPosition[{{lat1, lon1}, {lat2, lon2}, …}, datum] represents an array of geodetic positions.\nGeoPosition[entity] returns the geodetic position of the specified geographical entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoPosition)))
(def GeoPositionENU "GeoPositionENU[{east, north, up}, p]  represents a position with local Cartesian coordinates {east, north, up} in a reference system centered at the position p.\nGeoPositionENU[{{e1, n1, u1}, {e2, n2, u2}, …}, p] represents an array of positions.\nGeoPositionENU[entity, p] returns the Cartesian position with respect to p of the specified geographical entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoPositionENU)))
(def GeoPositionXYZ "GeoPositionXYZ[{x, y, z}] represents a position in a Cartesian geocentric coordinate system.\nGeoPositionXYZ[{x, y, z}, datum] represents a point referred to the specified datum.\nGeoPositionXYZ[{{x1, y1, z1}, {x2, y2, z2}, …}, datum] represents an array of points in a Cartesian geocentric coordinate system.\nGeoPositionXYZ[entity] returns the Cartesian geocentric position of the given geographical entity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoPositionXYZ)))
(def GeoProjection "GeoProjection is an option for GeoGraphics that specifies the cartographic projection to use for the map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoProjection)))
(def GeoProjectionData "GeoProjectionData[\"projection\", \"property\"] gives the value of the specified property for the specified cartographic projection.\nGeoProjectionData[\"projection\"] gives the complete options for the default form of the specified projection." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoProjectionData)))
(def GeoRange "GeoRange is an option for geographic functions that specifies the range of latitude and longitude to include." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoRange)))
(def GeoRangePadding "GeoRangePadding is an option for GeoGraphics that specifies what padding to use when extending beyond the original ranges of latitude and longitude." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoRangePadding)))
(def GeoRegionValuePlot "GeoRegionValuePlot[{reg1val1, reg2val2, …}] generates a plot in which the geographic regions regi are colored according to the values vali.\nGeoRegionValuePlot[regionsvalues] uses a collection of regions regi from regions with corresponding values vali from values.\nGeoRegionValuePlot[regionprop] generates a plot in which the geographic subdivisions in region are colored according to the values EntityValue[…, prop].\nGeoRegionValuePlot[data] generates a plot using the data available in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoRegionValuePlot)))
(def GeoResolution "GeoResolution is an option for geographic functions that specifies an average distance between neighboring pixels in the resulting map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoResolution)))
(def GeoScaleBar "GeoScaleBar is an option for GeoGraphics that determines what scale to show on the map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoScaleBar)))
(def GeoServer "GeoServer is an option for GeoGraphics, GeoStyling and GeoImage that specifies the URL address of a geo server and connection parameters to download map tiles and geo elevation data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoServer)))
(def GeoSmoothHistogram "GeoSmoothHistogram[locs] plots a smooth kernel histogram of the geo locations locs.\nGeoSmoothHistogram[locs, espec] plots a smooth kernel histogram with estimator specification espec.\nGeoSmoothHistogram[locs, espec, dfun] plots the distribution function dfun." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoSmoothHistogram)))
(def GeoStreamPlot "GeoStreamPlot[vecs] generates a stream plot from the field of geo vectors vecs.\nGeoStreamPlot[{vecs1, vecs2, …}] generates a separate set of streams for each vecsi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoStreamPlot)))
(def GeoStyling "GeoStyling[mapstyle] displays faces of polygons and other filled geo objects using mapstyle.\nGeoStyling[mapstyle, directive] uses mapstyle with the given graphics directive applied." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoStyling)))
(def GeoStylingImageFunction "GeoStylingImageFunction is an option for specifying an image effect to apply to a geo style." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoStylingImageFunction)))
(def GeoVariant "GeoVariant[obj, qual] represents a geographic object obj with qualifier qual." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVariant)))
(def GeoVector "GeoVector[loc{m, α}] represents a horizontal two-dimensional vector of magnitude m and bearing α at geo location loc.\nGeoVector[loc{m, α, w}] represents a three-dimensional vector of horizontal modulus m, bearing α and vertical component w at geo location loc.\nGeoVector[{loc1, loc2, …}{vec1, vec2, …}] represents a collection of vectors veci at respective geo locations loci.\nGeoVector[{loc1vec1, loc2vec2, …}] represents the same collection of vectors.\nGeoVector[vec] represents a geo vector whose associated location has been implicitly specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVector)))
(def GeoVectorENU "GeoVectorENU[loc{ve, vn}] represents a horizontal two-dimensional vector of components ve and vn in an orthonormal frame tangent to the Earth at geo location loc.\nGeoVectorENU[loc{ve, vn, vu}] represents a three-dimensional vector of horizontal components ve and vn, and vertical component vu at geo location loc. \nGeoVectorENU[{loc1, loc2, …}{vec1, vec2, …}] represents a collection of vectors veci at respective geo locations loci.\nGeoVectorENU[{loc1vec1, loc2vec2, …}] represents the same collection of vectors.\nGeoVectorENU[vec] represents a geo vector whose associated location has been implicitly specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVectorENU)))
(def GeoVectorPlot "GeoVectorPlot[vecs] generates a vector plot from the field of geo vectors vecs.\nGeoVectorPlot[{vecs1, vecs2, …}] generates a separate set of vectors for each vecsi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVectorPlot)))
(def GeoVectorXYZ "GeoVectorXYZ[loc{vX, vY, vZ}] represents a three-dimensional vector of Cartesian components vX, vY, vZ in an orthonormal frame parallel to the geocentric frame, at location loc.\nGeoVectorXYZ[{loc1, loc2, …}{vec1, vec2, …}] represents a collection of vectors veci at respective geo locations loci.\nGeoVectorXYZ[{loc1vec1, loc2vec2, …}] represents the same collection of vectors.\nGeoVectorXYZ[vec] represents a geo vector whose associated location has been implicitly specified." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVectorXYZ)))
(def GeoVisibleRegion "GeoVisibleRegion[{lat, lon, h}] is a two-dimensional GeoGraphics primitive that represents the region on the surface of the Earth visible from the point of coordinates lat, lon and height h above the reference ellipsoid.\nGeoVisibleRegion[pos] represents the region visible from the position pos.\nGeoVisibleRegion[{pos1, pos2, …}] represents the collection of regions visible from the positions posi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVisibleRegion)))
(def GeoVisibleRegionBoundary "GeoVisibleRegionBoundary[{lat, lon, h}] is a one-dimensional GeoGraphics primitive that represents the boundary of the region on the surface of the Earth visible from the point of coordinates lat, lon and height h above the reference ellipsoid.\nGeoVisibleRegionBoundary[pos] represents the boundary of the region visible from the position pos.\nGeoVisibleRegionBoundary[{pos1, pos2, …}] represents the collection of boundaries of the regions visible from the positions posi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoVisibleRegionBoundary)))
(def GeoWithinQ "GeoWithinQ[reg, loc] returns True if the location loc is contained within the region reg, and False otherwise.\nGeoWithinQ[reg] represents an operator form of GeoWithinQ that can be applied to a location." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoWithinQ)))
(def GeoZoomLevel "GeoZoomLevel is an option for specifying the resolution at which to render a map." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeoZoomLevel)))
(def GeodesicClosing "GeodesicClosing[image, ker] gives the geodesic closing of image with respect to the structuring element ker.\nGeodesicClosing[image, r] gives the geodesic closing with respect to a range r square.\nGeodesicClosing[data, …] applies geodesic closing to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesicClosing)))
(def GeodesicDilation "GeodesicDilation[marker, mask] gives the fixed point of the geodesic dilation of the marker constrained by the mask." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesicDilation)))
(def GeodesicErosion "GeodesicErosion[marker, mask] gives the fixed point of the geodesic erosion of the marker constrained by the mask." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesicErosion)))
(def GeodesicOpening "GeodesicOpening[image, ker] gives the geodesic opening of image with respect to the structuring element ker.\nGeodesicOpening[image, r] gives the geodesic opening with respect to a range r square.\nGeodesicOpening[data, …] applies geodesic opening to an array of data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesicOpening)))
(def GeodesicPolyhedron "GeodesicPolyhedron[n] gives the order‐n geodesic polyhedron.\nGeodesicPolyhedron[\"poly\", n] gives the order‐n geodesic polyhedron based on the polyhedron \"poly\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesicPolyhedron)))
(def GeodesyData "GeodesyData[\"name\", \"property\"] gives the value of the specified property for a named geodetic datum or reference ellipsoid.\nGeodesyData[{a, b}, \"property\"] gives the value of the property for the ellipsoid with semimajor axis a and semiminor axis b.\nGeodesyData[obj, {\"property\", coords}] gives the value of the property at the specified coordinates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeodesyData)))
(def GeogravityModelData "GeogravityModelData[] returns the gravitational field data for the current location.\nGeogravityModelData[locationspec] returns the gravitational field data for a location.\nGeogravityModelData[locationspec, component] returns the component of the gravitational field." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeogravityModelData)))
(def GeologicalPeriodData "GeologicalPeriodData[entity, property] gives the value of the specified property for the geological period entity.\nGeologicalPeriodData[{entity1, entity2, …}, property] gives a list of property values for the specified period name entities.\nGeologicalPeriodData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeologicalPeriodData)))
(def GeomagneticModelData "GeomagneticModelData[] returns the current magnetic field data for the current location.\nGeomagneticModelData[locationspec] returns the current magnetic field data for a location.\nGeomagneticModelData[datespec] returns the magnetic field data for the specified time for the current location.\nGeomagneticModelData[locationspec, datespec] returns the magnetic field data for the specified time and location.\nGeomagneticModelData[locationspec, datespec, component] returns the component of the magnetic field for the specified time and location." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeomagneticModelData)))
(def GeometricAssertion "GeometricAssertion[obj, prop] represents the assertion that the geometric object obj satisfies prop.\nGeometricAssertion[{obj1, obj2, …}, prop] represents the assertion that the obji satisfy prop.\nGeometricAssertion[objs, prop1, prop2, …] represents the assertion that objs satisfies each of the propi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricAssertion)))
(def GeometricBrownianMotionProcess "GeometricBrownianMotionProcess[μ, σ, x0] represents a geometric Brownian motion process with drift μ, volatility σ, and initial value x0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricBrownianMotionProcess)))
(def GeometricDistribution "GeometricDistribution[p] represents a geometric distribution with probability parameter p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricDistribution)))
(def GeometricMean "GeometricMean[data] gives the geometric mean of the values in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricMean)))
(def GeometricMeanFilter "GeometricMeanFilter[data, r] filters data by replacing every value by the geometric mean value in its range-r neighborhood.\nGeometricMeanFilter[data, {r1, r2, …}] uses ri for filtering the i ^th dimension in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricMeanFilter)))
(def GeometricOptimization "GeometricOptimization[f, cons, vars] finds positive values of variables vars that minimize the posynomial objective subject to posynomial constraints cons.\nGeometricOptimization[{a0, b0}, {{a1, b1}, …}, {aeq, beq}] finds the positive vector x=^y that minimizes ∑_j=1^k0^(a 0j.y+b 0j) subject to inequality constraints ∑_j=1^ki ^(a ij.y+b ij)≤ 1, i=1, …, s and linear equality constraints a eq.y+b eq=0.\nGeometricOptimization[…, \"prop\"]  specifies what solution property \"prop\" should be returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricOptimization)))
(def GeometricScene "GeometricScene[{p1, p2, …}, {hyp1, hyp2, …}] represents an abstract 2D geometric scene defined by the hypotheses hypi in terms of the symbolic points pi.\nGeometricScene[{{p1, p2, …}, {k1, k2, …}}, hyps] represents a scene whose hypotheses depend on the symbolic scalar quantities ki.\nGeometricScene[{{p1{x1, y1}, …}, {k1v1, …}}, hyps] represents a specific instance with explicit values for all points and scalar quantities.\nGeometricScene[params, hyps, {con1, con2, …}] represents a scene together with some conclusions coni about it.\nGeometricScene[{{{p1{x1, y1}, …}, {k1v1, …}}, …}, hyps] represents a collection of specific instances of the same scene.\nGeometricScene[{scene1, scene2, …}] combines several scene instances into one scene object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricScene)))
(def GeometricSolveValues "GeometricSolveValues[scene, expr] solves for the symbolic geometric quantity expr defined by the GeometricScene object scene.\nGeometricSolveValues[scene, {expr1, expr2, …}] returns a list containing the solutions of scene for expr1, expr2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricSolveValues)))
(def GeometricStep "GeometricStep[{hyp1, hyp2, …}] gives a symbolic representation of a step in the definition of a geometric scene, in which the hypotheses hypi are introduced. \nGeometricStep[hyps, label] labels the step with label when displaying an instance of the geometric scene." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricStep)))
(def GeometricStylingRules "GeometricStylingRules is an option to GeometricScene that specifies how to style structures in GeometricScene." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricStylingRules)))
(def GeometricTest "GeometricTest[obj, prop] tests whether the geometric object obj satisfies prop.\nGeometricTest[{obj1, obj2, …}, prop] tests whether the obji satisfy prop.\nGeometricTest[objs, prop1, prop2, …] tests whether objs satisfy each of the propi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricTest)))
(def GeometricTransformation "GeometricTransformation[g, tfun] represents the result of applying the transformation function tfun to the geometric objects corresponding to the primitives g.\nGeometricTransformation[g, m] transforms geometric objects in g by effectively replacing every point r by m.r. \nGeometricTransformation[g, {m, v}] effectively replaces every point r by m.r+v.\nGeometricTransformation[g, {t1, t2, …}] represents multiple copies of g transformed by a collection of transformations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GeometricTransformation)))
(def GestureHandler "GestureHandler[expr, {gesture1fun1, gesture2fun2, …}] displays as expr, evaluating funi[value, velocity] whenever \"gesturei\" occurs within the screen space occupied by expr.\nGestureHandler[expr, {\"gesture\":>{fun, funend}, …}] evaluates fun as updates are received for \"gesture\", followed by funend[value, velocity] when the gesture ends.\nGestureHandler[expr, {\"gesture\":>{funstart, fun, funend}, …}] also evaluates fstart[value, velocity] when \"gesture\" begins." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GestureHandler)))
(def Get "<<name reads in a file, evaluating each expression in it and returning the last one. \nGet[stream] reads from a stream, evaluating each expression in it and returning the last one.\nGet[\"file\", \"key\"] reads a file that has been encoded using Encode[\"source\", \"file\", \"key\"]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Get)))
(def GetEnvironment "GetEnvironment[\"var\"] gives the setting corresponding to the variable \"var\" in the operating system environment.\nGetEnvironment[{var1, var2, …}] gives a list of rules, corresponding to specified environment variables.\nGetEnvironment[] gives information about all existing settings in the operating system environment." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GetEnvironment)))
(def GibbsPointProcess "GibbsPointProcess[{\"PairPotential\", μ, ϕ}, d] represents a Gibbs point process with density μ and pair-potential function ϕ in ^d.\nGibbsPointProcess[{\"PairInteraction\", μ, h}, d] represents a Gibbs point process with density μ and pair-interaction function h in ^d.\nGibbsPointProcess[{\"Papangelou\", λ^*}, d] represents a Gibbs point process with Papangelou conditional density λ^* in ^d.\nGibbsPointProcess[{\"Density\", f}, d] represents a Gibbs point process with density function proportional to f in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GibbsPointProcess)))
(def Glaisher "Glaisher is Glaisher's constant with numerical value ≃1.28243." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Glaisher)))
(def GlobalClusteringCoefficient "GlobalClusteringCoefficient[g] gives the global clustering coefficient of the graph g.\nGlobalClusteringCoefficient[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GlobalClusteringCoefficient)))
(def Glow "Glow[col] is a graphics directive which specifies that surfaces of 3D graphics objects that follow are to be taken to glow with color col. \nGlow[] specifies that there is no glow." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Glow)))
(def GoldenAngle "GoldenAngle is the golden angle (3-Sqrt[5]) π, with numerical value ≃137.5°." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GoldenAngle)))
(def GoldenRatio "GoldenRatio is the golden ratio ϕ1/2 (Sqrt[5]+1), with numerical value ≃1.61803." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GoldenRatio)))
(def GompertzMakehamDistribution "GompertzMakehamDistribution[λ, ξ] represents a Gompertz distribution with scale parameter λ and frailty parameter ξ.\nGompertzMakehamDistribution[λ, ξ, θ, α] represents a Gompertz–Makeham distribution with parameters λ, ξ, θ, and α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GompertzMakehamDistribution)))
(def GoochShading "GoochShading[] is a three-dimensional graphics directive specifying that surfaces that follow are to be drawn with a warm color facing toward the light and a cool color facing away.\nGoochShading[col] uses cool and warm colors obtained by blending col with slate Blue and Orange.\nGoochShading[{ccol, wcol}] uses the cool color ccol and the warm color wcol.\nGoochShading[{w1, w2}{ccol, wcol}] uses the colors ccol and wcol weighted by the wi.\nGoochShading[\"scheme\"] uses the specified gradient color scheme in ColorData." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GoochShading)))
(def GoodmanKruskalGamma "GoodmanKruskalGamma[v1, v2] gives the Goodman–Kruskal γ coefficient for the vectors v1 and v2.\nGoodmanKruskalGamma[m] gives the Goodman–Kruskal γ coefficients for the matrix m.\nGoodmanKruskalGamma[m1, m2] gives the Goodman–Kruskal γ coefficients for the matrices m1 and m2.\nGoodmanKruskalGamma[dist] gives the γ coefficient matrix for the multivariate symbolic distribution dist.\nGoodmanKruskalGamma[dist, i, j] gives the (i, j)^th γ coefficient for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GoodmanKruskalGamma)))
(def GoodmanKruskalGammaTest "GoodmanKruskalGammaTest[v1, v2] tests whether the vectors v1 and v2 are independent.\nGoodmanKruskalGammaTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GoodmanKruskalGammaTest)))
(def Goto "Goto[tag] scans for Label[tag], and transfers control to that point." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Goto)))
(def GouraudShading "GouraudShading[] is a three‐dimensional graphics directive that specifies that faces of polygons and other filled graphics objects are to be drawn to reflect as a smooth surface using a normal‐vector average shading.\nGouraudShading[d] uses the attenuation factor d for the diffuse light.\nGouraudShading[d, s] uses the attenuation factor s for the specular light.\nGouraudShading[d, s, a] uses the attenuation factor a for the ambient light." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GouraudShading)))
(def Grad "Grad[f, {x1, …, xn}] gives the gradient (∂f/∂x1, …, ∂f/∂xn).\nGrad[f, {x1, …, xn}, chart] gives the gradient in the coordinates chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Grad)))
(def Gradient "Gradient is an option for FindMinimum and related functions that specifies the gradient vector to assume for the function being extremized." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Gradient)))
(def GradientFilter "GradientFilter[data, r] gives the magnitude of the gradient of data, computed using discrete derivatives of a Gaussian of sample radius r.\nGradientFilter[data, {r, σ}] uses a Gaussian with standard deviation σ.\nGradientFilter[data, {{r1, r2, …}, …}] uses a Gaussian with radius ri at level i in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GradientFilter)))
(def GradientFittedMesh "GradientFittedMesh[{p1, p2, …}] gives a MeshRegion whose gradient best fits the normals at points p1, p2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GradientFittedMesh)))
(def GradientOrientationFilter "GradientOrientationFilter[data, r] gives the local orientation parallel to the gradient of data, computed using discrete derivatives of a Gaussian of pixel radius r, returning values between -π/2 and π/2.\nGradientOrientationFilter[data, {r, σ}] uses a Gaussian with standard deviation σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GradientOrientationFilter)))
(def GrammarApply "GrammarApply[grammar, input] attempts to parse input according to the grammar defined by grammar." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GrammarApply)))
(def GrammarRules "GrammarRules[rules] represents grammar rules to be deployed to a cloud object that implements the grammar in a form suitable for use with functions like GrammarApply and Interpreter.\nGrammarRules[rules, defs] uses grammar definitions defs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GrammarRules)))
(def GrammarToken "GrammarToken[form] is a grammar rules pattern object that represents any input of the specified form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GrammarToken)))
(def Graph "Graph[{e1, e2, …}] yields a graph with edges ej.\nGraph[{v1, v2, …}, {e1, e2, …}] yields the graph with vertices vi and edges ej. \nGraph[{…, wi[vi, …], …}, {…, wj[ej, …], …}] yields a graph with vertex and edge properties defined by the symbolic wrappers wk.\nGraph[data] yields a graph from data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Graph)))
(def Graph3D "Graph3D[g] creates a graph with vertices and edges from the graph g and represented as a 3D plot.\nGraph3D[{e1, e2, …}] creates a graph with edges ej and represented as a 3D plot.\nGraph3D[{v1, v2, …}, {e1, e2, …}] creates a graph with vertices vi and edges ej." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Graph3D)))
(def GraphAssortativity "GraphAssortativity[g] gives the assortativity coefficient of a graph g using vertex degrees.\nGraphAssortativity[g, \"prop\"] gives the assortativity coefficient of the graph g using vertex property \"prop\".\nGraphAssortativity[g, {{v i1, v i2, …}, …}] gives the assortativity coefficient of the graph g with respect to the vertex partition {{v i1, v i2, …}, …}.\nGraphAssortativity[g, {v1, v2, …}{x1, x2, …}] gives the assortativity coefficient of the graph g using data {x1, x2, …} for vertices {v1, v2, …}.\nGraphAssortativity[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphAssortativity)))
(def GraphAutomorphismGroup "GraphAutomorphismGroup[g] gives the automorphism group of a graph g.\nGraphAutomorphismGroup[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphAutomorphismGroup)))
(def GraphCenter "GraphCenter[g] gives the set of vertices with minimum eccentricity in the graph g.\nGraphCenter[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphCenter)))
(def GraphComplement "GraphComplement[g] gives the graph complement of the graph g.\nGraphComplement[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphComplement)))
(def GraphData "GraphData[name] gives a graph with the specified name.\nGraphData[entity] gives the graph corresponding to the graph entity.\nGraphData[entity, property] gives the value of the property for the specified graph entity.\nGraphData[class] gives a list of available named graphs in the specified graph class.\nGraphData[n] gives a list of available named graphs with n vertices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphData)))
(def GraphDensity "GraphDensity[g] gives the graph density of the graph g.\nGraphDensity[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDensity)))
(def GraphDiameter "GraphDiameter[g] gives the greatest distance between any pair of vertices in the graph g.\nGraphDiameter[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDiameter)))
(def GraphDifference "GraphDifference[g1, g2] gives the graph difference of the graphs g1 and g2.\nGraphDifference[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDifference)))
(def GraphDisjointUnion "GraphDisjointUnion[g1, g2] gives the graph disjoint union of the graphs g1 and g2.\nGraphDisjointUnion[g1, g2, …] gives the disjoint union of g1, g2, ….\nGraphDisjointUnion[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDisjointUnion)))
(def GraphDistance "GraphDistance[g, s, t] gives the distance from source vertex s to target vertex t in the graph g.\nGraphDistance[g, s] gives the distance from s to all vertices of the graph g.\nGraphDistance[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDistance)))
(def GraphDistanceMatrix "GraphDistanceMatrix[g] gives the matrix of distances between vertices for the graph g.\nGraphDistanceMatrix[g, d] gives the matrix of distances between vertices of maximal distance d in the graph g.\nGraphDistanceMatrix[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphDistanceMatrix)))
(def GraphEmbedding "GraphEmbedding[g] gives coordinates of the vertices of the graph g.\nGraphEmbedding[g, \"emb\"] gives coordinates of the vertices of the graph g using the embedding \"emb\".\nGraphEmbedding[g, \"emb\", dim] gives coordinates in dimension dim of the vertices of the graph g using the embedding \"emb\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphEmbedding)))
(def GraphHighlight "GraphHighlight is an option to Graph and related objects that specifies graph elements to highlight." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphHighlight)))
(def GraphHighlightStyle "GraphHighlightStyle is an option to Graph and related objects that specifies styles to use for highlighted graph elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphHighlightStyle)))
(def GraphHub "GraphHub[g] gives the set of vertices with maximum vertex degree in the underlying simple graph of g.\nGraphHub[g, \"In\"] gives the set of vertices with maximum vertex in-degree.\nGraphHub[g, \"Out\"] gives the set of vertices with maximum vertex out-degree.\nGraphHub[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphHub)))
(def GraphIntersection "GraphIntersection[g1, g2] gives the graph intersection of the graphs g1 and g2.\nGraphIntersection[g1, g2, …] gives the graph intersection of g1, g2, … .\nGraphIntersection[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphIntersection)))
(def GraphJoin "GraphJoin[g1, g2] gives the graph join of the graphs g1 and g2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphJoin)))
(def GraphLayerStyle "GraphLayerStyle is an option for LayeredGraphPlot3D and related functions that specifies the style in which to draw a layer on the plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphLayerStyle)))
(def GraphLayers "GraphLayers is an option for LayeredGraphPlot3D and related functions that specifies layers to draw on the plot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphLayers)))
(def GraphLayout "GraphLayout is an option to Graph and related functions that specifies what layout to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphLayout)))
(def GraphLinkEfficiency "GraphLinkEfficiency[g] gives the link efficiency of the graph g.\nGraphLinkEfficiency[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphLinkEfficiency)))
(def GraphPeriphery "GraphPeriphery[g] gives vertices that are maximally distant to at least one vertex in the graph g.\nGraphPeriphery[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphPeriphery)))
(def GraphPlot "GraphPlot[g] generates a plot of the graph g.\nGraphPlot[{e1, e2, …}] generates a plot of the graph with edges ei.\nGraphPlot[{…, w[ei], …}] plots ei with features defined by the symbolic wrapper w.\nGraphPlot[{v i1v j1, …}] uses rules vikvjk to specify the graph g.\nGraphPlot[m] uses the adjacency matrix m to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphPlot)))
(def GraphPlot3D "GraphPlot3D[g] generates a 3D plot of the graph g.\nGraphPlot3D[{e1, e2, …}] generates a 3D plot of the graph with edges ei.\nGraphPlot3D[{…, w[ei], …}] plots ei with features defined by the symbolic wrapper w.\nGraphPlot3D[{v i1v j1, …}] uses rules vikvjk to specify the graph g.\nGraphPlot3D[m] uses the adjacency matrix m to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphPlot3D)))
(def GraphPower "GraphPower[g, n] gives the graph-n ^th power of the graph g.\nGraphPower[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphPower)))
(def GraphProduct "GraphProduct[g1, g2] gives the Cartesian product of the graphs g1 and g2.\nGraphProduct[g1, g2, \"op\"] gives the product of type \"op\" for the graphs g1 and g2" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphProduct)))
(def GraphPropertyDistribution "GraphPropertyDistribution[expr, xgdist] represents the distribution of the property expr where the random variable x follows the graph distribution gdist.\nGraphPropertyDistribution[expr, {x1gdist1, x2gdist2, …}] represents the distribution where x1, x2, … are independent and follow the graph distributions gdist1, gdist2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphPropertyDistribution)))
(def GraphQ "GraphQ[g] yields True if g is a valid Graph object and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphQ)))
(def GraphRadius "GraphRadius[g] gives the minimum eccentricity of the vertices in the graph g.\nGraphRadius[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphRadius)))
(def GraphReciprocity "GraphReciprocity[g] gives the reciprocity of a graph g.\nGraphReciprocity[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphReciprocity)))
(def GraphSum "GraphSum[g1, g2] gives the graph sum of the graphs g1 and g2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphSum)))
(def GraphTree "GraphTree[g] constructs a tree from the tree graph g.\nGraphTree[g, root] specifies what vertex to use as the root.\nGraphTree[g, root, h] applies h to each vertex to get the corresponding data and ordering of subtrees." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphTree)))
(def GraphTriangleCount "GraphTriangleCount[g] gives the number of triangles in the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphTriangleCount)))
(def GraphUnion "GraphUnion[g1, g2] gives the graph union of the graphs g1 and g2.\nGraphUnion[g1, g2, …] gives the graph union of g1, g2, ….\nGraphUnion[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphUnion)))
(def Graphics "Graphics[primitives, options] represents a two-dimensional graphical image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Graphics)))
(def Graphics3D "Graphics3D[primitives, options] represents a three-dimensional graphical image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Graphics3D)))
(def GraphicsColumn "GraphicsColumn[{g1, g2, …}] generates a graphic in which the gi are laid out in a column, with g1 above g2, etc. \nGraphicsColumn[list, alignment] aligns each element horizontally in the specified way. \nGraphicsColumn[list, alignment, spacing] leaves the specified spacing between successive elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphicsColumn)))
(def GraphicsComplex "GraphicsComplex[{pt1, pt2, …}, data] represents a graphics complex in which coordinates given as integers i in graphics primitives in data are taken to be pti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphicsComplex)))
(def GraphicsGrid "GraphicsGrid[{{g11, g12, …}, …}] generates a graphic in which the gij are laid out in a two-dimensional grid." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphicsGrid)))
(def GraphicsGroup "GraphicsGroup[{g1, g2, …}] represents a collection of graphics objects grouped together for purposes of interactive selection in a notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphicsGroup)))
(def GraphicsRow "GraphicsRow[{g1, g2, …}] generates a graphic in which the gi are laid out in a row.\nGraphicsRow[list, spacing] leaves the specified spacing between successive elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GraphicsRow)))
(def Gray "Gray represents the color gray in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Gray)))
(def GrayLevel "GrayLevel[g] represents a color in the grayscale color space with gray level g.\nGrayLevel[g, a] specifies opacity a. \nGrayLevel[\"string\"] returns a color from an HTML color name etc.\nGrayLevel[color] returns the grayscale representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GrayLevel)))
(def Greater "x>y yields True if x is determined to be greater than y. \nx1>x2>x3 yields True if the xi form a strictly decreasing sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Greater)))
(def GreaterEqual "x>=y or x≥y yields True if x is determined to be greater than or equal to y. \nx1≥x2≥x3 yields True if the xi form a nonincreasing sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterEqual)))
(def GreaterEqualLess "GreaterEqualLess[x, y, …] displays as x⋛y⋛…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterEqualLess)))
(def GreaterEqualThan "GreaterEqualThan[y] is an operator form that yields x≥y when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterEqualThan)))
(def GreaterFullEqual "GreaterFullEqual[x, y, …] displays as x≧y≧…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterFullEqual)))
(def GreaterGreater "GreaterGreater[x, y, …] displays as x≫y≫…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterGreater)))
(def GreaterLess "GreaterLess[x, y, …] displays as x≷y≷…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterLess)))
(def GreaterSlantEqual "GreaterSlantEqual[x, y, …] displays as x⩾y⩾…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterSlantEqual)))
(def GreaterThan "GreaterThan[y] is an operator form that yields x>y when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterThan)))
(def GreaterTilde "GreaterTilde[x, y, …] displays as x≳y≳…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreaterTilde)))
(def Green "Green represents the color green in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Green)))
(def GreenFunction "GreenFunction[{ℒ[u[x]], ℬ[u[x]]}, u, {x, xmin, xmax}, y] gives a Green's function for the linear differential operator ℒ with boundary conditions ℬ in the range xmin to xmax. \nGreenFunction[{ℒ[u[x1, x2, …]], ℬ[u[x1, x2, …]]}, u, {x1, x2, …}∈Ω, {y1, y2, …}] gives a Green's function for the linear partial differential operator ℒ over the region Ω.\nGreenFunction[{ℒ[u[x, t]], ℬ[u[x, t]]}, u, {x, xmin, xmax}, t, {y, τ}] gives a Green's function for the linear time-dependent operator ℒ in the range xmin to xmax.\nGreenFunction[{ℒ[u[x1, …, t]], ℬ[u[x1, …, t]]}, u, {x1, …}∈Ω, t, {y1, …, τ}] gives a Green's function for the linear time-dependent operator ℒ over the region Ω." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GreenFunction)))
(def Grid "Grid[{{expr11, expr12, …}, {expr21, expr22, …}, …}] is an object that formats with the exprij arranged in a two-dimensional grid." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Grid)))
(def GridBox "GridBox[{{box11, box12, …}, {box21, box22, …}, …}] is a low-level box construct that represents a two-dimensional grid of boxes or strings in notebook expressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridBox)))
(def GridDefaultElement "GridDefaultElement is an option for the low-level function GridBox that specifies what to insert when a new element is created interactively in a GridBox." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridDefaultElement)))
(def GridGraph "GridGraph[{m, n}] gives the grid graph with m×n vertices G m, n.\nGridGraph[{n1, n2, …, nk}] gives the k-dimensional grid graph with n1×n2×⋯×nk vertices G n1, n2, …, nk." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridGraph)))
(def GridLines "GridLines is an option for two-dimensional graphics functions that specifies grid lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridLines)))
(def GridLinesStyle "GridLinesStyle is an option for 2D graphics functions that specifies how grid lines should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridLinesStyle)))
(def GridVideo "GridVideo[{v1, v2, …}] creates a video in which each frame is a grid of frames of all vi at the corresponding time.\nGridVideo[{{v11, v12, …}, …}] uses the array position of each video vij to create the video grid." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GridVideo)))
(def GroebnerBasis "GroebnerBasis[{poly1, poly2, …}, {x1, x2, …}] gives a list of polynomials that form a Gröbner basis for the set of polynomials polyi. \nGroebnerBasis[{poly1, poly2, …}, {x1, x2, …}, {y1, y2, …}] finds a Gröbner basis in which the yi have been eliminated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroebnerBasis)))
(def GroupActionBase "GroupActionBase is an option to specify a base for a group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupActionBase)))
(def GroupBy "GroupBy[{elem1, elem2, …}, f] gives an association that groups the elemi into lists associated with distinct keys f[elemi].\nGroupBy[{elem1, elem2, …}, fkfv] groups the fv[elemi] according to the fk[elemi].\nGroupBy[{elem1, elem2, …}, {fs1, fs2, …}] groups into nested associations using fsi at level i.\nGroupBy[{elem1, elem2, …}, spec, red] applies the function red to reduce lists of values that are generated.\nGroupBy[spec] represents an operator form of GroupBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupBy)))
(def GroupCentralizer "GroupCentralizer[group, g] returns the centralizer of the element g in group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupCentralizer)))
(def GroupElementFromWord "GroupElementFromWord[group, w] returns the element of group determined by the word w in the generators of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupElementFromWord)))
(def GroupElementPosition "GroupElementPosition[group, g] returns the position of the element g in the list of elements of group.\nGroupElementPosition[group, {g1, …, gn}] returns the list of positions of the elements g1, …, gn in group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupElementPosition)))
(def GroupElementQ "GroupElementQ[group, g] returns True if the object g is an element of group and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupElementQ)))
(def GroupElementToWord "GroupElementToWord[group, g] decomposes the group element g as a product of generators of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupElementToWord)))
(def GroupElements "GroupElements[group] returns the list of all elements of group.\nGroupElements[group, {r1, …, rk}] returns the elements numbered r1, …, rk in group in the standard order." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupElements)))
(def GroupGenerators "GroupGenerators[group] returns a list of generators of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupGenerators)))
(def GroupMultiplicationTable "GroupMultiplicationTable[group] gives the multiplication table of group as an array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupMultiplicationTable)))
(def GroupOrbits "GroupOrbits[group, {p1, …}] returns the orbits of the points pi under the action of the elements of group.\nGroupOrbits[group, {p1, …}, f] finds the orbits under the group action given by a function f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupOrbits)))
(def GroupOrder "GroupOrder[group] returns the number of elements of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupOrder)))
(def GroupPageBreakWithin "GroupPageBreakWithin is an option for Cell that specifies whether a page break should be allowed within the group of cells if the notebook that contains the group is printed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupPageBreakWithin)))
(def GroupSetwiseStabilizer "GroupSetwiseStabilizer[group, {p1, …, pn}] returns the subgroup of group for which the images of the points pi are still in the list {p1, …, pn}.\nGroupSetwiseStabilizer[group, {p1, …, pn}, f] returns the setwise stabilizer subgroup under the action given by the function f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupSetwiseStabilizer)))
(def GroupStabilizer "GroupStabilizer[group, {p1, …, pn}] returns the subgroup of elements of group that move none of the points p1, …, pn.\nGroupStabilizer[group, {p1, …, pn}, f] returns the stabilizer subgroup under the action given by the function f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupStabilizer)))
(def GroupStabilizerChain "GroupStabilizerChain[group] returns a list of successive stabilizers in group of the points in a base of group." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GroupStabilizerChain)))
(def Groupings "Groupings[n, k] gives a list of all possible groupings of 1, …, n taken k at a time. \nGroupings[{a1, …, an}, k] gives all possible groupings of a1, …, an taken k at a time.\nGroupings[{{a1, a2, …}, {b1, b2, …}, …}, k] gives the combination of all possible groupings of each of the lists ai, bi, … taken k at a time.\nGroupings[aspec, fk] gives all possible groupings of aspec taken k at a time with the function f applied at each level. \nGroupings[aspec, {f1k1, f2k2, …}] gives all possible groupings in which the function fi is applied to ki elements. \nGroupings[aspec, {{f1k1, m1}, {f2k2, m2}, …}] allows at most mi occurrences in a given grouping of fi applied to ki elements.\nGroupings[aspec, kspec, h] wraps the function h around each grouping generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Groupings)))
(def GrowCutComponents "GrowCutComponents[image, {marker1, marker2, …}] creates a segmentation from image by growing each markeri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GrowCutComponents)))
(def Gudermannian "Gudermannian[z] gives the Gudermannian function gd (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Gudermannian)))
(def GuidedFilter "GuidedFilter[image, guide, r, ϵ] filters image using the guide image guide over range-r neighborhoods with pixel-value regularizer ϵ.\nGuidedFilter[image, r, ϵ] filters image so as to reduce noise, using image as the guide." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GuidedFilter)))
(def GumbelDistribution "GumbelDistribution[α, β] represents a Gumbel distribution with location parameter α and scale parameter β.\nGumbelDistribution[] represents a Gumbel distribution with location parameter 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote GumbelDistribution)))
(def HITSCentrality "HITSCentrality[g] gives a list of authority and hub centralities for the vertices in the graph g.\nHITSCentrality[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HITSCentrality)))
(def HTTPErrorResponse "HTTPErrorResponse[code] is an object that represents an error response to an HTTP request, with specified error code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HTTPErrorResponse)))
(def HTTPRedirect "HTTPRedirect[uri] represents an HTTP redirect to the specified uri.\nHTTPRedirect[uri, metadata] represents an HTTP redirect to uri with the specified metadata." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HTTPRedirect)))
(def HTTPRequest "HTTPRequest[url] represents an HTTP request for the specified URL.\nHTTPRequest[assoc] represents an HTTP request built from the components in the association assoc. \nHTTPRequest[url, assoc] represents an HTTP request for the specified URL with additional elements such as headers given by assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HTTPRequest)))
(def HTTPRequestData "HTTPRequestData[\"prop\"] gives the value of the specified property of the current HTTP request.\nHTTPRequestData[] gives an association with values of properties of the current HTTP request." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HTTPRequestData)))
(def HTTPResponse "HTTPResponse[body] is an object that represents a successful response to an HTTP request, with the specified body and default metadata.\nHTTPResponse[body, metadata] represents a response to an HTTP request, including the specified body and metadata." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HTTPResponse)))
(def HaarWavelet "HaarWavelet[] represents a Haar wavelet." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HaarWavelet)))
(def HadamardMatrix "HadamardMatrix[n] returns an n×n Hadamard matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HadamardMatrix)))
(def HalfLine "HalfLine[{p1, p2}] represents the half-line from the point p1 through p2. \nHalfLine[p, v] represents the half-line from the point p in the direction v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HalfLine)))
(def HalfNormalDistribution "HalfNormalDistribution[θ] represents a half-normal distribution with scale inversely proportional to parameter θ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HalfNormalDistribution)))
(def HalfPlane "HalfPlane[{p1, p2}, w] represents the half-plane bounded by the line through p1 and p2 and extended in the direction w.\nHalfPlane[p, v, w] represents the half-plane bounded by the line through p along v and extended in the direction w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HalfPlane)))
(def HalfSpace "HalfSpace[n, p] represents the half-space of points x such that n.(x-p)≤0.\nHalfSpace[n, c] represents the half-space of points x such that n.x≤c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HalfSpace)))
(def HalftoneShading "HalftoneShading[] is a three-dimensional graphics directive specifying that surfaces that follow are to be drawn with a base pattern of dots.\nHalftoneShading[d] uses the density d of shading.\nHalftoneShading[col] uses dots with the specified color col.\nHalftoneShading[\"shape\"] uses the specified \"shape\" as base pattern. \nHalftoneShading[d, col, \"shape\"] uses a fixed pattern of \"shape\" with the specified color col and density d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HalftoneShading)))
(def Haloing "Haloing[] is a two‐dimensional directive specifying that graphics objects are to be drawn with a halo.\nHaloing[col] uses the specified color col for the halo.\nHaloing[col, w] uses the specified width w for the halo.\nHaloing[col, w, r] applies a blur effect with radius r to the halo." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Haloing)))
(def HamiltonianGraphQ "HamiltonianGraphQ[g] yields True if the graph g is Hamiltonian, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HamiltonianGraphQ)))
(def HammingDistance "HammingDistance[u, v] gives the Hamming distance between strings or vectors u and v.\nHammingDistance[u, v] gives the Hamming distance between strings, vectors or biomolecular sequences u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HammingDistance)))
(def HammingWindow "HammingWindow[x] represents a Hamming window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HammingWindow)))
(def HandlerFunctions "HandlerFunctions is an option that specifies functions to apply when events are generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HandlerFunctions)))
(def HandlerFunctionsKeys "HandlerFunctionsKeys is an option that specifies the content of associations to which to apply handler functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HandlerFunctionsKeys)))
(def HankelH1 "HankelH1[n, z] gives the Hankel function of the first kind H _n^(1)(z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HankelH1)))
(def HankelH2 "HankelH2[n, z] gives the Hankel function of the second kind H _n^(2)(z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HankelH2)))
(def HankelMatrix "HankelMatrix[n] gives the n×n Hankel matrix with first row and first column being successive integers.\nHankelMatrix[{c1, c2, …, cn}] gives the Hankel matrix whose first column consists of entries c1, c2, ….\nHankelMatrix[{c1, c2, …, cm}, {r1, r2, …, rn}] gives the Hankel matrix with entries ci down the first column, and ri across the last row." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HankelMatrix)))
(def HankelTransform "HankelTransform[expr, r, s] gives the Hankel transform of order 0 for expr.\nHankelTransform[expr, r, s, ν] gives the Hankel transform of order ν for expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HankelTransform)))
(def HannPoissonWindow "HannPoissonWindow[x] represents a Hann–Poisson window function of x.\nHannPoissonWindow[x, α] uses the parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HannPoissonWindow)))
(def HannWindow "HannWindow[x] represents a Hann window function of x.\nHannWindow[x, α] uses the parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HannWindow)))
(def HaradaNortonGroupHN "HaradaNortonGroupHN[] represents the sporadic simple Harada–Norton group HN." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HaradaNortonGroupHN)))
(def HararyGraph "HararyGraph[k, n] generates the minimal k-connected graph on n vertices H k, n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HararyGraph)))
(def HardcorePointProcess "HardcorePointProcess[μ, rh, d] represents a hard-core point process with constant intensity μ and hard-core radius rh in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HardcorePointProcess)))
(def HarmonicMean "HarmonicMean[data] gives the harmonic mean of the values in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HarmonicMean)))
(def HarmonicMeanFilter "HarmonicMeanFilter[data, r] filters data by replacing every value by the harmonic mean value in its range-r neighborhood.\nHarmonicMeanFilter[data, {r1, r2, …}] uses ri for filtering the i ^th dimension in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HarmonicMeanFilter)))
(def HarmonicNumber "HarmonicNumber[n] gives the n ^th harmonic number Hn.\nHarmonicNumber[n, r] gives the harmonic number H _n^(r) of order r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HarmonicNumber)))
(def Hash "Hash[expr] gives an integer hash code for the expression expr.\nHash[expr, type] gives an integer hash digest of the specified type for expr.\nHash[expr, type, \"format\"] gives a hash code in the specified format." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hash)))
(def HatchFilling "HatchFilling[] is a two-dimensional graphics directive that specifies that faces of polygons and other filled graphics objects are to be drawn using closely spaced parallel lines. \nHatchFilling[\"name\"] uses the specified line hatching \"name\".\nHatchFilling[θ] draws parallel lines with an angle θ.\nHatchFilling[θ, r] draws parallel lines with absolute thickness r. \nHatchFilling[θ, r, d] draws parallel lines with gaps of absolute thickness d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HatchFilling)))
(def HatchShading "HatchShading[] is a three-dimensional graphics directive specifying that objects that follow are to be drawn with closely spaced parallel lines.\nHatchShading[d] uses the density d of shading.\nHatchShading[col] uses lines with the specified color col. \nHatchShading[d, col] uses lines with the specified color col and density d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HatchShading)))
(def Haversine "Haversine[z] gives the haversine function hav (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Haversine)))
(def HazardFunction "HazardFunction[dist, x] gives the hazard function for the distribution dist evaluated at x.\nHazardFunction[dist, {x1, x2, …}] gives the multivariate hazard function for the distribution dist evaluated at {x1, x2, …}.\nHazardFunction[dist] gives the hazard function as a pure function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HazardFunction)))
(def Head "Head[expr] gives the head of expr. \nHead[expr, h] wraps the result with h." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Head)))
(def HeaderAlignment "HeaderAlignment is an option for Dataset that specifies how the contents of a header should be aligned within the available area in the header." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderAlignment)))
(def HeaderBackground "HeaderBackground is an option for Dataset that specifies what background color to use for row and column headers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderBackground)))
(def HeaderDisplayFunction "HeaderDisplayFunction is an option for Dataset that specifies a function to apply to headers before displaying them." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderDisplayFunction)))
(def HeaderLines "HeaderLines is an option for SemanticImport and related functions that specifies how many of the initial rows should be considered part of a column header." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderLines)))
(def HeaderSize "HeaderSize is an option for Dataset that specifies the widths and heights of headers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderSize)))
(def HeaderStyle "HeaderStyle is an option for Dataset that specifies the style to use for headers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeaderStyle)))
(def Heads "Heads is an option for functions which use level specifications that specifies whether heads of expressions should be included." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Heads)))
(def HeatFluxValue "HeatFluxValue[pred, vars, pars] represents a thermal heat flux boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatFluxValue[pred, vars, pars, lkey] represents a thermal heat flux boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatFluxValue)))
(def HeatInsulationValue "HeatInsulationValue[pred, vars, pars] represents a thermal insulation boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatInsulationValue[pred, vars, pars, lkey] represents a thermal insulation boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatInsulationValue)))
(def HeatOutflowValue "HeatOutflowValue[pred, vars, pars] represents a thermal outflow boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatOutflowValue[pred, vars, pars, lkey] represents a thermal outflow boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatOutflowValue)))
(def HeatRadiationValue "HeatRadiationValue[pred, vars, pars] represents a thermal radiation boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatRadiationValue[pred, vars, pars, lkey] represents a thermal radiation boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatRadiationValue)))
(def HeatSymmetryValue "HeatSymmetryValue[pred, vars, pars] represents a thermal symmetry boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatSymmetryValue[pred, vars, pars, lkey] represents a thermal symmetry boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatSymmetryValue)))
(def HeatTemperatureCondition "HeatTemperatureCondition[pred, vars, pars] represents a thermal surface boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatTemperatureCondition[pred, vars, pars, lkey] represents a thermal surface boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatTemperatureCondition)))
(def HeatTransferPDEComponent "HeatTransferPDEComponent[vars, pars] yields a heat transfer PDE term with variables vars and parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatTransferPDEComponent)))
(def HeatTransferValue "HeatTransferValue[pred, vars, pars] represents a thermal transfer boundary condition for PDEs with predicate pred indicating where it applies, with model variables vars and global parameters pars.\nHeatTransferValue[pred, vars, pars, lkey] represents a thermal transfer boundary condition with local parameters specified in pars[lkey]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeatTransferValue)))
(def HeavisideLambda "HeavisideLambda[x] represents the triangle distribution Λ(x) which is nonzero for x<1.\nHeavisideLambda[x1, x2, …] represents the multidimensional triangle distribution Λ(x1, x2, …) which is nonzero for xi<1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeavisideLambda)))
(def HeavisidePi "HeavisidePi[x] represents the box distribution Π(x), equal to 1 for x<1/2 and 0 for x>(1/2).\nHeavisidePi[x1, x2, …] represents the multidimensional box distribution Π(x1, x2, …) which is 1 if all xi<1/2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeavisidePi)))
(def HeavisideTheta "HeavisideTheta[x] represents the Heaviside theta function θ(x), equal to 0 for x<0 and 1 for x>0. \nHeavisideTheta[x1, x2, …] represents the multidimensional Heaviside theta function, which is 1 only if all of the xi are positive." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeavisideTheta)))
(def HeldGroupHe "HeldGroupHe[] represents the sporadic simple Held group He." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeldGroupHe)))
(def HelmholtzPDEComponent "HelmholtzPDEComponent[vars, pars] yields a Helmholtz PDE term ∇^2{x1, …, xn}u+k^2 u with model variables vars and model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HelmholtzPDEComponent)))
(def Here "Here represents the current deduced geo location." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Here)))
(def HermiteDecomposition "HermiteDecomposition[m] gives the Hermite normal form decomposition of an integer matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HermiteDecomposition)))
(def HermiteH "HermiteH[n, x] gives the Hermite polynomial Hn (x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HermiteH)))
(def Hermitian "Hermitian[{1, 2}] represents the symmetry of a Hermitian matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hermitian)))
(def HermitianMatrix "HermitianMatrix[hmat] converts the Hermitian matrix hmat to a structured array." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HermitianMatrix)))
(def HermitianMatrixQ "HermitianMatrixQ[m] gives True if m is explicitly Hermitian, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HermitianMatrixQ)))
(def HessenbergDecomposition "HessenbergDecomposition[m] gives the Hessenberg decomposition of a numerical matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HessenbergDecomposition)))
(def HeunB "HeunB[q, α, γ, δ, ϵ, z] gives the bi-confluent Heun function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunB)))
(def HeunBPrime "HeunBPrime[q, α, γ, δ, ϵ, z] gives the z-derivative of the HeunB function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunBPrime)))
(def HeunC "HeunC[q, α, γ, δ, ϵ, z] gives the confluent Heun function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunC)))
(def HeunCPrime "HeunCPrime[q, α, γ, δ, ϵ, z] gives the z-derivative of the HeunC function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunCPrime)))
(def HeunD "HeunD[q, α, γ, δ, ϵ, z] gives the double-confluent Heun function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunD)))
(def HeunDPrime "HeunDPrime[q, α, γ, δ, ϵ, z] gives the z-derivative of the HeunD function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunDPrime)))
(def HeunG "HeunG[a, q, α, β, γ, δ, z] gives the general Heun function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunG)))
(def HeunGPrime "HeunGPrime[a, q, α, β, γ, δ, z] gives the z-derivative of the HeunG function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunGPrime)))
(def HeunT "HeunT[q, α, γ, δ, ϵ, z] gives the tri-confluent Heun function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunT)))
(def HeunTPrime "HeunTPrime[q, α, γ, δ, ϵ, z] gives the z-derivative of the HeunT function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HeunTPrime)))
(def HexadecimalCharacter "HexadecimalCharacter represents a hexadecimal digit character 0–9, a–f, A–F in StringExpression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HexadecimalCharacter)))
(def Hexahedron "Hexahedron[{p1, p2, …, p8}] represents a filled hexahedron with corners p1, p2, …, p8.\nHexahedron[{{p 1, 1, p 1, 2, …, p 1, 8}, {p 2, 1, …}, …}] represents a collection of hexahedra." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hexahedron)))
(def HiddenItems "HiddenItems is an option for Dataset that specifies which items to hide." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HiddenItems)))
(def HiddenMarkovProcess "HiddenMarkovProcess[i0, m, em] represents a discrete-time, finite-state hidden Markov process with transition matrix m, emission matrix em, and initial hidden state i0.\nHiddenMarkovProcess[…, m, {dist1, …}] represents a hidden Markov process with emission distributions disti.\nHiddenMarkovProcess[p0, m, …] represents a hidden Markov process with initial hidden state probability vector p0." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HiddenMarkovProcess)))
(def HighlightGraph "HighlightGraph[g, {a1, a2, …}] highlights the ai that can be vertices, edges, or subgraphs of g.\nHighlightGraph[g, {…, wj[aj], …}] highlights using the symbolic wrappers wj.\nHighlightGraph[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HighlightGraph)))
(def HighlightImage "HighlightImage[image, roi] highlights the specified region of interest roi in image.\nHighlightImage[image, {roi1, roi2, …}] highlights several regions of interest roii.\nHighlightImage[image, {…, w[roii], …}] highlights using a feature defined by the symbolic wrapper w.\nHighlightImage[image, fg, bgstyle] applies the styling bgstyle to the complement of all the regions of interest." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HighlightImage)))
(def HighlightMesh "HighlightMesh[mr, {cellspec1, cellspec2, …}] highlights the cells specified by cellspeci in the mesh region mr.\nHighlightMesh[mr, {…, wj[cellspecj], …}] highlights using the symbolic wrappers wj." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HighlightMesh)))
(def Highlighted "Highlighted[expr] displays a highlighted version of expr.\nHighlighted[expr, effect] uses the effect effect to highlight plot elements representing expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Highlighted)))
(def HighpassFilter "HighpassFilter[data, ωc] applies a highpass filter with a cutoff frequency ωc to an array of data.\nHighpassFilter[data, ωc, n] uses a filter kernel of length n.\nHighpassFilter[data, ωc, n, wfun] applies a smoothing window wfun to the filter kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HighpassFilter)))
(def HigmanSimsGroupHS "HigmanSimsGroupHS[] represents the sporadic simple Higman–Sims group HS." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HigmanSimsGroupHS)))
(def HilbertCurve "HilbertCurve[n] gives the line segments representing the n ^th-step Hilbert curve.\nHilbertCurve[n, d] gives the n ^th-step Hilbert curve in dimension d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HilbertCurve)))
(def HilbertFilter "HilbertFilter[data, ωc] applies a Hilbert filter with a cutoff frequency ωc to an array of data.\nHilbertFilter[data, ωc, n] uses a filter kernel of length n.\nHilbertFilter[data, ωc, n, wfun] applies a smoothing window wfun to the filter kernel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HilbertFilter)))
(def HilbertMatrix "HilbertMatrix[n] gives the n×n Hilbert matrix with elements of the form 1/(i+j-1).\nHilbertMatrix[{m, n}] gives the m×n Hilbert matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HilbertMatrix)))
(def Histogram "Histogram[{x1, x2, …}] plots a histogram of the values xi.\nHistogram[{x1, x2, …}, bspec] plots a histogram with bin width specification bspec.\nHistogram[{x1, x2, …}, bspec, hspec] plots a histogram with bin heights computed according to the specification hspec.\nHistogram[{data1, data2, …}, …] plots histograms for multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Histogram)))
(def Histogram3D "Histogram3D[{{x1, y1}, {x2, y2}, …}] plots a 3D histogram of the values {xi, yi}.\nHistogram3D[{{x1, y1}, {x2, y2}, …}, bspec] plots a 3D histogram with bins specified by bspec.\nHistogram3D[{{x1, y1}, {x2, y2}, …}, bspec, hspec] plots a 3D histogram with bin heights computed according to the specification hspec.\nHistogram3D[{data1, data2, …}] plots 3D histograms for multiple datasets datai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Histogram3D)))
(def HistogramDistribution "HistogramDistribution[{x1, x2, …}] represents the probability distribution corresponding to a histogram of the data values xi.\nHistogramDistribution[{{x1, y1, …}, {x2, y2, …}, …}] represents a multivariate histogram distribution based on data values {xi, yi, …}.\nHistogramDistribution[…, bspec] represents a histogram distribution with bins specified by bspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistogramDistribution)))
(def HistogramList "HistogramList[{x1, x2, …}] gives a list of bins and histogram heights of the values xi.\nHistogramList[{{x1, y1, …}, {x2, y2, …}, …}] gives a list of bins and histogram heights of the values {xi, yi, …}.\nHistogramList[…, bspec] gives a list of bins and histogram heights with bins specified by bspec.\nHistogramList[…, bspec, hspec] gives a list of bins and histogram heights with bin heights computed according to the specification hspec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistogramList)))
(def HistogramPointDensity "HistogramPointDensity[pdata] estimates the histogram point density function μ(x) for point data pdata. \nHistogramPointDensity[pdata, bspec] estimates the histogram point density function μ(x) with histogram bins specified by bspec.\nHistogramPointDensity[bdata, …, …] estimates the histogram point density function μ(x) for binned data bdata. \nHistogramPointDensity[pproc, …, …] computes the histogram point density function μ(x) for the point process pproc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistogramPointDensity)))
(def HistogramTransform "HistogramTransform[image] transforms pixel values of image so that its histogram is nearly flat.\nHistogramTransform[image, ref] modifies pixel values of image so that its histogram would have nearly the same distribution as ref.\nHistogramTransform[image, ref, n] uses n equally spaced quantiles.\nHistogramTransform[{x1, x2, …}, …] transforms values xi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistogramTransform)))
(def HistogramTransformInterpolation "HistogramTransformInterpolation[{x1, x2, …}] finds a function f so that the transformed values f(xi) are distributed nearly uniformly.\nHistogramTransformInterpolation[{x1, x2, …}, ref] finds f so that f(xi) are distributed with distribution ref.\nHistogramTransformInterpolation[{x1, x2, …}, ref, n] finds a function with n equally spaced quantiles.\nHistogramTransformInterpolation[image, …] finds a function that reshapes the histogram of image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistogramTransformInterpolation)))
(def HistoricalPeriodData "HistoricalPeriodData[entity, property] gives the value of the specified property for the historical period entity.\nHistoricalPeriodData[{entity1, entity2, …}, property] gives a list of property values for the specified historical period entities.\nHistoricalPeriodData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HistoricalPeriodData)))
(def HitMissTransform "HitMissTransform[image, ker] gives the hit-or-miss transform of image with respect to the composite structuring element ker.\nHitMissTransform[image, {ker1, ker2, …}] gives the union of the hit-or-miss transforms for all the structuring elements keri.\nHitMissTransform[image, {ker1, ker2, …}, t] treats values above t as foreground." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HitMissTransform)))
(def HjorthDistribution "HjorthDistribution[m, s, f] represents the Hjorth distribution with location parameter m, scale parameter s, and shape parameter f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HjorthDistribution)))
(def HodgeDual "HodgeDual[tensor] gives the Hodge dual of the tensor\nHodgeDual[tensor, dim] dualizes tensor in the slots with dimension dim\nHodgeDual[tensor, dim, slots] dualizes tensor in the given slots." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HodgeDual)))
(def HoeffdingD "HoeffdingD[v1, v2] gives Hoeffding's dependence measure  for the vectors v1 and v2.\nHoeffdingD[m] gives Hoeffding's dependence measure  for the matrix m.\nHoeffdingD[m1, m2] gives Hoeffding's dependence measure  for the matrices m1 and m2.\nHoeffdingD[dist] gives Hoeffding's  matrix for the multivariate symbolic distribution dist.\nHoeffdingD[dist, i, j] gives the (i, j)^th element of  for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoeffdingD)))
(def HoeffdingDTest "HoeffdingDTest[v1, v2] tests whether the vectors v1 and v2 are independent.\nHoeffdingDTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoeffdingDTest)))
(def Hold "Hold[expr] maintains expr in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hold)))
(def HoldAll "HoldAll is an attribute that specifies that all arguments to a function are to be maintained in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldAll)))
(def HoldAllComplete "HoldAllComplete is an attribute which specifies that all arguments to a function are not to be modified or looked at in any way in the process of evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldAllComplete)))
(def HoldComplete "HoldComplete[expr] shields expr completely from the standard Wolfram Language evaluation process, preventing even upvalues associated with expr from being used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldComplete)))
(def HoldFirst "HoldFirst is an attribute that specifies that the first argument to a function is to be maintained in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldFirst)))
(def HoldForm "HoldForm[expr] prints as the expression expr, with expr maintained in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldForm)))
(def HoldPattern "HoldPattern[expr] is equivalent to expr for pattern matching, but maintains expr in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldPattern)))
(def HoldRest "HoldRest is an attribute which specifies that all but the first argument to a function are to be maintained in an unevaluated form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoldRest)))
(def HolderModel "HolderModel[] represents the single-input, single-output model of a zero-order hold.\nHolderModel[specs] represents a holder with specifications specs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HolderModel)))
(def HolidayCalendar "HolidayCalendar is an option that specifies the holiday calendar schedule in business day functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HolidayCalendar)))
(def HorizontalGauge "HorizontalGauge[value] draws a linear gauge showing value in a range of 0 to 1.\nHorizontalGauge[value, {min, max}] draws a linear gauge showing value in a range of min to max.\nHorizontalGauge[Dynamic[value], …] allows value to be set interactively using the gauge.\nHorizontalGauge[{value1, value2, …}, …] draws a gauge showing multiple values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HorizontalGauge)))
(def HornerForm "HornerForm[poly] puts the polynomial poly in Horner form.\nHornerForm[poly, vars] puts poly in Horner form with respect to the variable or variable list vars.\nHornerForm[poly1/poly2] puts the rational function poly1/poly2 in Horner form by nesting poly1 and poly2.\nHornerForm[poly1/poly2, vars1, vars2] puts poly1/poly2 in Horner form using the variables or variable lists vars1 and vars2 for poly1 and poly2, respectively." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HornerForm)))
(def HostLookup "HostLookup[name] gives the IP address for the host with the specified name.\nHostLookup[address] gives the host name for the host at the specified IP address.\nHostLookup[spec, prop] gives a specified property of the host.\nHostLookup[spec, All] gives an association of properties found for the host." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HostLookup)))
(def HotellingTSquareDistribution "HotellingTSquareDistribution[p, m] represents Hotelling's T^2 distribution with dimensionality parameter p and m degrees of freedom." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HotellingTSquareDistribution)))
(def HoytDistribution "HoytDistribution[q, ω] represents a Hoyt distribution with shape parameter q and spread parameter ω." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HoytDistribution)))
(def Hue "Hue[h] represents a color in the HSB color space with hue h. \nHue[h, s, b] specifies colors in terms of hue, saturation and brightness. \nHue[h, s, b, a] specifies opacity a. \nHue[\"string\"] returns a color from an HTML color name etc.\nHue[color] returns the HSB representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hue)))
(def HumanGrowthData "HumanGrowthData[spec] returns the range of values within one standard deviation of the mean for all properties of human growth at the specification spec.\nHumanGrowthData[spec, property] returns the range of values within one standard deviation of the mean of a property for the specification spec.\nHumanGrowthData[spec, index] returns the values for all properties of human growth for spec at the specified percentile.\nHumanGrowthData[spec, property, index] returns the value at a specific index of a property for spec at the specified percentile.\nHumanGrowthData[spec, property, quantity] returns the percentile and probability density for a specific value quantity of the property at spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HumanGrowthData)))
(def HumpDownHump "HumpDownHump[x, y, …] displays as x≎y≎…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HumpDownHump)))
(def HumpEqual "HumpEqual[x, y, …] displays as x≏y≏…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HumpEqual)))
(def HurwitzLerchPhi "HurwitzLerchPhi[z, s, a] gives the Hurwitz–Lerch transcendent Φ (z, s, a)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HurwitzLerchPhi)))
(def HurwitzZeta "HurwitzZeta[s, a] gives the Hurwitz zeta function ζ (s, a)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HurwitzZeta)))
(def HyperbolicDistribution "HyperbolicDistribution[α, β, δ, μ] represents a hyperbolic distribution with location parameter μ, scale parameter δ, shape parameter α, and skewness parameter β.\nHyperbolicDistribution[λ, α, β, δ, μ] represents a generalized hyperbolic distribution with shape parameter λ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HyperbolicDistribution)))
(def HypercubeGraph "HypercubeGraph[n] gives the n-dimensional hypercube graph Qn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypercubeGraph)))
(def HyperexponentialDistribution "HyperexponentialDistribution[{α1, …, αm}, {λ1, …, λm}] represents an m-phase hyperexponential distribution with phase probabilities αi and rates λi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HyperexponentialDistribution)))
(def Hyperfactorial "Hyperfactorial[n] gives the hyperfactorial function H (n)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hyperfactorial)))
(def Hypergeometric0F1 "Hypergeometric0F1[a, z] is the confluent hypergeometric function 0F1(;a;z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric0F1)))
(def Hypergeometric0F1Regularized "Hypergeometric0F1Regularized[a, z] is the regularized confluent hypergeometric function 0F1(;a;z)/Γ(a)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric0F1Regularized)))
(def Hypergeometric1F1 "Hypergeometric1F1[a, b, z] is the Kummer confluent hypergeometric function 1F1(a;b;z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric1F1)))
(def Hypergeometric1F1Regularized "Hypergeometric1F1Regularized[a, b, z] is the regularized confluent hypergeometric function 1F1(a;b;z)/Γ(b)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric1F1Regularized)))
(def Hypergeometric2F1 "Hypergeometric2F1[a, b, c, z] is the hypergeometric function 2F1(a, b;c;z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric2F1)))
(def Hypergeometric2F1Regularized "Hypergeometric2F1Regularized[a, b, c, z] is the regularized hypergeometric function 2F1(a, b;c;z)/Γ(c)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hypergeometric2F1Regularized)))
(def HypergeometricDistribution "HypergeometricDistribution[n, nsucc, ntot] represents a hypergeometric distribution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypergeometricDistribution)))
(def HypergeometricPFQ "HypergeometricPFQ[{a1, …, ap}, {b1, …, bq}, z] is the generalized hypergeometric function pFq (a;b;z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypergeometricPFQ)))
(def HypergeometricPFQRegularized "HypergeometricPFQRegularized[{a1, …, ap}, {b1, …, bq}, z] is the regularized generalized hypergeometric function pFq (a;b;z)/(Γ(b1)… Γ(bq))." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypergeometricPFQRegularized)))
(def HypergeometricU "HypergeometricU[a, b, z] is the Tricomi confluent hypergeometric function U (a, b, z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypergeometricU)))
(def Hyperlink "Hyperlink[uri] represents a hyperlink that jumps to the specified URI when clicked. \nHyperlink[label, uri] represents a hyperlink to be displayed as label." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hyperlink)))
(def HyperlinkAction "HyperlinkAction is an option for Hyperlink that controls the behavior of following links in cloud notebooks." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HyperlinkAction)))
(def Hyperplane "Hyperplane[n, p] represents the hyperplane with normal n passing through the point p.\nHyperplane[n, c] represents the hyperplane with normal n given by the points x that satisfy n.xc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hyperplane)))
(def Hyphenation "Hyphenation is an option for Cell that specifies whether to allow hyphenation for words of text." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Hyphenation)))
(def HypoexponentialDistribution "HypoexponentialDistribution[{λ1, …, λm}] represents an m-phase hypoexponential distribution with rates λ1, …, λm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypoexponentialDistribution)))
(def HypothesisTestData "HypothesisTestData[…] represents hypothesis test data such as generated by DistributionFitTest, AndersonDarlingTest, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote HypothesisTestData)))
(def I "I represents the imaginary unit Sqrt[-1]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote I)))
(def IPAddress "IPAddress[\"address\"] is a symbolic representation of an IPv4 or IPv6 IP address." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IPAddress)))
(def IconData "IconData[type, value] generates an icon of the specified type assuming the value given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IconData)))
(def IconRules "IconRules is an option for CloudObject and related objects that specifies icons to use in different environments to represent an object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IconRules)))
(def Iconize "Iconize[expr] gives an iconized form that can be used to stand in for expr in notebook input.\nIconize[expr, \"name\"] displays with the specified name in the icon." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Iconize)))
(def Icosahedron "Icosahedron[] represents a regular icosahedron centered at the origin with unit edge length.\nIcosahedron[l] represents an icosahedron with edge length l.\nIcosahedron[{θ, ϕ}, …] represents an icosahedron rotated by an angle θ with respect to the z axis and angle ϕ with respect to the y axis.\nIcosahedron[{x, y, z}, …] represents an icosahedron centered at {x, y, z}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Icosahedron)))
(def Identity "Identity[expr] gives expr (the identity operation)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Identity)))
(def IdentityMatrix "IdentityMatrix[n] gives the nn identity matrix. \nIdentityMatrix[{m, n}] gives the mn identity matrix." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IdentityMatrix)))
(def If "If[condition, t, f] gives t if condition evaluates to True, and f if it evaluates to False. \nIf[condition, t, f, u] gives u if condition evaluates to neither True nor False." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote If)))
(def IfCompiled "IfCompiled[comp, uncomp] gives comp when compiled and uncomp when evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IfCompiled)))
(def IgnoreCase "IgnoreCase is an option for string manipulation and searching functions that specifies whether lowercase and uppercase letters should be treated as equivalent." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnoreCase)))
(def IgnoreDiacritics "IgnoreDiacritics is an option for string, grammar, and related functions that specifies whether diacritics should be ignored in strings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnoreDiacritics)))
(def IgnoreIsotopes "IgnoreIsotopes is an option for MoleculeMatchQ that determines whether isotopes should be ignored for pattern matching." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnoreIsotopes)))
(def IgnorePunctuation "IgnorePunctuation is an option for AlphabeticSort and related functions that specifies whether to consider punctuation in determining sorting order." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnorePunctuation)))
(def IgnoreStereochemistry "IgnoreStereochemistry is an option for MoleculeMatchQ that determines whether stereochemistry should be ignored for pattern matching." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnoreStereochemistry)))
(def IgnoringInactive "IgnoringInactive[patt] is a pattern object that, for purposes of pattern matching, ignores occurrences of Inactive in both patt and the expression being matched." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IgnoringInactive)))
(def Im "Im[z] gives the imaginary part of the complex number z." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Im)))
(def Image "Image[data] represents a raster image with pixel values given by the array data.\nImage[graphics] creates a raster image from a graphics object. \nImage[obj, options] gives an image that uses the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Image)))
(def Image3D "Image3D[data] represents a 3D image with pixel values given by the array data.\nImage3D[{image1, image2, …}] creates a 3D image from a list of 2D images.\nImage3D[obj, \"type\"] creates a 3D image of the specified data type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Image3D)))
(def Image3DProjection "Image3DProjection[image] takes a 3D image and returns a 2D image of maximum projection onto the x-y plane.\nImage3DProjection[image, dir] performs a projection in the direction specified by dir.\nImage3DProjection[image, dir, mode] specifies the projection mode." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Image3DProjection)))
(def Image3DSlices "Image3DSlices[image] gives a list of 2D images corresponding to the slices in the Image3D object image.\nImage3DSlices[image, n] gives the n ^th slice as a 2D image.\nImage3DSlices[image, {s1, s2, …}] extracts the specified slices si.\nImage3DSlices[image, sm;;sn] extracts slices sm through sn.\nImage3DSlices[image, …, d] takes slices in dimension d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Image3DSlices)))
(def ImageAccumulate "ImageAccumulate[image] gives an image in which each pixel represents a sum of all pixels below and to the left of that pixel in image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAccumulate)))
(def ImageAdd "ImageAdd[image, x] adds an amount x to each channel value in image.\nImageAdd[image1, image2] gives an image in which each pixel is the sum of the corresponding pixels in image1 and image2.\nImageAdd[image, expr1, expr2, …] adds all expri to image, where each expri can be either an image, a number, or a color value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAdd)))
(def ImageAdjust "ImageAdjust[image] adjusts the levels in image, rescaling them to cover the range 0 to 1.\nImageAdjust[image, corr] adjusts the image according to the correction specification corr.\nImageAdjust[image, corr, {inmin, inmax}] first rescales so that the range of input values inmin to inmax is mapped to 0 to 1.\nImageAdjust[image, corr, {inmin, inmax}, {outmin, outmax}] rescales so that the range of input values inmin to inmax is mapped to outmin to outmax." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAdjust)))
(def ImageAlign "ImageAlign[ref, image] returns a version of image that is aligned with the reference image ref.\nImageAlign[ref, {image1, …, imagen}] gives the result of aligning each of the imagei with the reference image ref.\nImageAlign[{image1, …, imagen}] uses image1 as the reference image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAlign)))
(def ImageApply "ImageApply[f, image] applies the function f to the list of channel values for each pixel in image.\nImageApply[f, {image1, image2, …}] applies f to the sequence of corresponding pixel values taken from each imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageApply)))
(def ImageApplyIndexed "ImageApplyIndexed[f, image] applies the function f to the list of channel values for each pixel in image, giving the row and column index of each pixel as a second argument to f.\nImageApplyIndexed[f, {image1, image2, …}] applies f to the sequence of corresponding pixel values taken from each imagei, giving the corresponding row and column index of pixels as the last argument to f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageApplyIndexed)))
(def ImageAspectRatio "ImageAspectRatio[image] gives the ratio of height to width for image.\nImageAspectRatio[video] gives the aspect ratio of video frames." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAspectRatio)))
(def ImageAssemble "ImageAssemble[{{im11, …, im 1n}, …, {im m1, …, immn}}] assembles a single image from an array of images.\nImageAssemble[{{im11, …, im 1n}, …, {im m1, …, immn}}, fitting] assembles images using the fitting method." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAssemble)))
(def ImageAugmentationLayer "ImageAugmentationLayer[{h, w}] represents a net layer that applies random image transformations to produce images of height h and width w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageAugmentationLayer)))
(def ImageBoundingBoxes "ImageBoundingBoxes[image] gives an association of lists of bounding boxes for each identified category of objects in image.\nImageBoundingBoxes[image, category] gives a list of bounding boxes for subimages identified as an instance of the specified category." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageBoundingBoxes)))
(def ImageCapture "ImageCapture[] opens a graphical user interface for capturing images from connected cameras." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCapture)))
(def ImageCaptureFunction "ImageCaptureFunction is an option for ImageCapture that specifies the function to apply to images acquired by the imaging device." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCaptureFunction)))
(def ImageCases "ImageCases[image] gives an association of lists of subimages for each identified category of objects in image.\nImageCases[image, category] gives a list of subimages identified as an instance of the specified category.\nImageCases[image, categoryprop] gives the specified property prop for each identified subimage.\nImageCases[image, {category1, category2, …}] gives an association with lists of subimages identified as being instances of each of the categoryi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCases)))
(def ImageChannels "ImageChannels[image] gives the number of channels present in the data for the Image or Image3D object image.\nImageChannels[video] gives the number of channels present in frames of a video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageChannels)))
(def ImageClip "ImageClip[image] clips all channel values in image to lie in the default range.\nImageClip[image, {min, max}] clips channel values to lie in the range from min to max.\nImageClip[image, {min, max}, {vmin, vmax}] gives vmin for values below min and vmax for values above max." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageClip)))
(def ImageCollage "ImageCollage[{image1, image2, …}] creates a collage of images imagei.\nImageCollage[{w1image1, w2image2, …}] creates a collage of images imagei based on their corresponding weights wi.\nImageCollage[image1w1, image2w2, …] also creates a collage of images imagei based on their corresponding weights wi.\nImageCollage[{w1, w2, …}{image1, image2, …}] also creates a collage of images imagei based on their corresponding weights wi.\nImageCollage[{{image1, w1}, {image2, w2}, …}] also creates a collage of images imagei based on their corresponding weights wi.\nImageCollage[…, fitting] uses the fitting method to create the collage.\nImageCollage[…, fitting, size] creates a collage of the specified size." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCollage)))
(def ImageColorSpace "ImageColorSpace[image] gives the name of the color space of image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageColorSpace)))
(def ImageCompose "ImageCompose[image, overlay] gives the result of overlaying overlay onto image. \nImageCompose[image, {overlay, α}] gives the result of alpha blending overlay into image using blending fraction α.\nImageCompose[image, overlay, pos] places the center of overlay at position pos in image.\nImageCompose[image, overlay, pos, opos] places the point opos in overlay at position pos in image.\nImageCompose[image, overlay, pos, opos, {fi, fo, mode}] uses the compositing fractions fk and the specified compositing mode." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCompose)))
(def ImageContainsQ "ImageContainsQ[image, category] returns True if an instance of the specified category is detected in image.\nImageContainsQ[image, {category1, category2, …}] returns True if at least one instance of each of the categoryi is detected in image.\nImageContainsQ[image, category1|category2|…] returns True if image contains an instance of at least one of categoryi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageContainsQ)))
(def ImageContents "ImageContents[image] gives a dataset of identified entities in image.\nImageContents[image, category] gives a dataset that only contains entities in the specified category.\nImageContents[image, category, prop] includes the properties prop for each identified object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageContents)))
(def ImageConvolve "ImageConvolve[image, ker] gives the convolution of image with kernel ker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageConvolve)))
(def ImageCooccurrence "ImageCooccurrence[image, n] gives the n×n co-occurrence matrix for image.\nImageCooccurrence[image, n, ker] computes a co-occurrence matrix for arbitrary spatial relationships specified by a kernel ker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCooccurrence)))
(def ImageCorners "ImageCorners[image] finds corners in image and returns their coordinates.\nImageCorners[image, r] finds corners at a pixel range r.\nImageCorners[image, r, t] uses a threshold t for selecting corners.\nImageCorners[image, r, t, d] returns corners that are at least d+1 pixels apart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCorners)))
(def ImageCorrelate "ImageCorrelate[image, ker] gives the correlation of image with kernel ker.\nImageCorrelate[image, ker, f] computes a generalized correlation in which the function f is used in place of Dot." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCorrelate)))
(def ImageCorrespondingPoints "ImageCorrespondingPoints[image1, image2] finds a set of matching interest points in image1 and image2 and returns their pixel coordinates." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCorrespondingPoints)))
(def ImageCrop "ImageCrop[image] crops image by removing borders of uniform color. \nImageCrop[image, size] crops image based on the size specification size.\nImageCrop[image, size, spec] crops image by removing pixels from sides specified by spec.\nImageCrop[video, …] crops frames of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageCrop)))
(def ImageData "ImageData[image] gives the array of pixel values in an Image or Image3D object image.\nImageData[image, \"type\"] gives the array of pixel values converted to the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageData)))
(def ImageDeconvolve "ImageDeconvolve[image, ker] gives a deconvolution of image using kernel ker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDeconvolve)))
(def ImageDemosaic "ImageDemosaic[image, cfa] reconstructs a color image using the specified color filter array cfa.\nImageDemosaic[image, {\"cfa\", {row, col}}] aligns the top-left pixel of the pattern with the {row, col} pixel of image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDemosaic)))
(def ImageDifference "ImageDifference[image1, image2] gives an image in which each pixel is the absolute difference of the corresponding pixels in image1 and image2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDifference)))
(def ImageDimensions "ImageDimensions[image] gives the pixel dimensions of an Image or Image3D object image.\nImageDimensions[video] gives the pixel dimensions of the first video track of the Video object video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDimensions)))
(def ImageDisplacements "ImageDisplacements[{image1, image2, …, imagen}] gives estimated horizontal and vertical displacements between consecutive images.\nImageDisplacements[{image1, image2, …, imagen}, flow] uses flow as an initial estimate for displacement between image1 and image2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDisplacements)))
(def ImageDistance "ImageDistance[image1, image2] returns a distance measure between image1 and image2. \nImageDistance[image1, image2, pos] places the center of image2 at position pos in image1.\nImageDistance[image1, image2, pos1, pos2] places the point pos2 of image2 at position pos1 in image1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageDistance)))
(def ImageEffect "ImageEffect[image, \"effect\"] applies the specified image effect to image.\nImageEffect[image, {\"effect\", params}] uses parameters params.\nImageEffect[video, …] applies the image effect to frames of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageEffect)))
(def ImageExposureCombine "ImageExposureCombine[{image1, image2, …}] combines differently exposed images imagei of the same scene into a single image with overall good exposure.\nImageExposureCombine[{image1, image2, …}, mode] creates a low or a high dynamic range image based on the specified mode." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageExposureCombine)))
(def ImageFeatureTrack "ImageFeatureTrack[{image1, image2, …, imagen}] tracks features from image1 through imagen.\nImageFeatureTrack[{image1, image2, …, imagen}, pts] tracks features starting from the initial set of points pts in image1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFeatureTrack)))
(def ImageFileApply "ImageFileApply[f, inputfile, outputfile] applies the function f to the list of channel values for each pixel of the image stored in inputfile and stores the result in outputfile." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFileApply)))
(def ImageFileFilter "ImageFileFilter[f, inputfile, r, outputfile] applies the function f to the range r neighborhood of each pixel in each channel of the image stored in inputfile and stores the result in outputfile." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFileFilter)))
(def ImageFileScan "ImageFileScan[f, inputfile] applies the function f to the list of channel values for each pixel of the image stored in inputfile." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFileScan)))
(def ImageFilter "ImageFilter[f, image, r] applies the function f to the range-r neighborhood of each pixel in each channel of image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFilter)))
(def ImageFocusCombine "ImageFocusCombine[{image1, image2, …}] combines differently focused images imagei of the same scene to obtain a single well-focused image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFocusCombine)))
(def ImageForestingComponents "ImageForestingComponents[image] finds a segmentation of image, returning an integer matrix in which positive integers label different components.\nImageForestingComponents[image, marker] tries to find a segmentation into components that include pixels indicated by marker.\nImageForestingComponents[image, marker, r] finds components that are connected at a pixel scale given by r." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageForestingComponents)))
(def ImageFormattingWidth "ImageFormattingWidth is an option that specifies the target width at which to wrap when formatting an object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageFormattingWidth)))
(def ImageForwardTransformation "ImageForwardTransformation[image, f] gives an image in which each pixel at position f[{x, y}] corresponds to the position {x, y} in image.\nImageForwardTransformation[image, f, size] gives an image of the specified size.\nImageForwardTransformation[video, …] transforms frames of a video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageForwardTransformation)))
(def ImageGraphics "ImageGraphics[image] returns the content of image in the form of scalable vector graphics.\nImageGraphics[image, n] uses up to n colors for the vector graphics.\nImageGraphics[image, colors] creates vector graphics containing the specified colors." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageGraphics)))
(def ImageHistogram "ImageHistogram[image] plots a histogram of the pixel levels for each channel in image.\nImageHistogram[image, bspec] uses bin specification bspec.\nImageHistogram[image, bspec, range] plots the histogram of the pixel values in the given range." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageHistogram)))
(def ImageIdentify "ImageIdentify[image] yields the result of attempting to identify what image is a picture of. \nImageIdentify[image, category] restricts the identification of image to objects within the specified category.\nImageIdentify[image, category, n] gives a list of up to n possible identifications.\nImageIdentify[image, category, n, \"prop\"] gives the specified property for each identification." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageIdentify)))
(def ImageInstanceQ "ImageInstanceQ[image, obj] gives True if image appears to be an instance of the object obj, and gives False otherwise.\nImageInstanceQ[image, obj, cat] assumes that the image is of something in the category cat." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageInstanceQ)))
(def ImageKeypoints "ImageKeypoints[image] finds key features in image and returns their coordinates.\nImageKeypoints[image, prop] gives the specified property prop for each keypoint." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageKeypoints)))
(def ImageLabels "ImageLabels is an option for image highlighting that specifies what labels to use for each highlighted feature." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageLabels)))
(def ImageLegends "ImageLegends is an option for image highlighting that specifies what legends to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageLegends)))
(def ImageLevels "ImageLevels[image] gives a list of pixel values and counts for each channel in image. \nImageLevels[image, bspec] bins pixel values using bin specification bspec.\nImageLevels[image, bspec, range] gives counts for bins in the given range." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageLevels)))
(def ImageLines "ImageLines[image] finds line segments in image and returns the coordinates of their endpoints.\nImageLines[image, t] uses the threshold t for selecting image lines.\nImageLines[image, t, d] uses the parameter d to control the distinctness of the detected lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageLines)))
(def ImageMargins "ImageMargins is an option that specifies the absolute margins to leave around the image displayed for an object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageMargins)))
(def ImageMarker "ImageMarker[pos] is a HighlightImage specification that represents a marker at position pos.\nImageMarker[pos, marker] represents a custom marker at position pos.\nImageMarker[{pos1, pos2, …}, …] represents multiple marker positions posi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageMarker)))
(def ImageMeasurements "ImageMeasurements[image, \"prop\"] returns the value of property \"prop\" for the entire image.\nImageMeasurements[image, \"prop\", format] returns the values in the specified output format.\nImageMeasurements[{image1, image2, …}, …] returns measurements for all imagei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageMeasurements)))
(def ImageMesh "ImageMesh[image] returns the foreground region in image as a BoundaryMeshRegion object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageMesh)))
(def ImageMultiply "ImageMultiply[image, x] multiplies each channel value in image by a factor x.\nImageMultiply[image1, image2] gives an image in which each pixel is the product of the corresponding pixels in image1 and image2.\nImageMultiply[image, expr1, expr2, …] multiplies all expri with image, where each expri can be either an image, a number, or a color value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageMultiply)))
(def ImagePad "ImagePad[image, m] pads image on all sides with m background pixels.\nImagePad[image, m, padding] pads image on all sides using the value or method specified by padding.\nImagePad[image, {{left, right}, {bottom, top}}, …] pads image with the specified numbers of pixels on each side.\nImagePad[image, {{left, right}, {front, back}, {bottom, top}}, …] pads a 3D image with the specified numbers of pixels.\nImagePad[video, …] pads frames of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePad)))
(def ImagePadding "ImagePadding is an option for graphics functions that specifies what absolute extra padding should be left for extended objects such as thick lines and annotations such as tick and axis labels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePadding)))
(def ImagePartition "ImagePartition[image, s] partitions an image into an array of ss-pixel subimages.\nImagePartition[image, {w, h}] partitions an image into an array of subimages of pixel width w and pixel height h.\nImagePartition[image, {w, h}, {dw, dh}] uses pixel offsets dw and dh." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePartition)))
(def ImagePeriodogram "ImagePeriodogram[image] shows the squared magnitude of the discrete Fourier transform (power spectrum) of image.\nImagePeriodogram[image, n] shows the average of power spectra of non-overlapping partitions of size n×n.\nImagePeriodogram[image, n, d] uses partitions with offset d.\nImagePeriodogram[image, n, d, wfun] applies a smoothing window wfun to each partition.\nImagePeriodogram[image, n, d, wfun, m] pads partitions with zeros to length m prior to the computation of the transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePeriodogram)))
(def ImagePerspectiveTransformation "ImagePerspectiveTransformation[image, m] applies a linear fractional transform specified by a matrix m to the positions of each pixel in image.\nImagePerspectiveTransformation[image, tf] uses the TransformationFunction given by tf.\nImagePerspectiveTransformation[image, …, size] gives an image of the specified size.\nImagePerspectiveTransformation[video, …] transforms frames of a video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePerspectiveTransformation)))
(def ImagePosition "ImagePosition[image] gives an association of image positions for each identified category of objects in image.\nImagePosition[image, obj] gives a list of image positions for subimages identified as instances of the specified category." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePosition)))
(def ImagePreviewFunction "ImagePreviewFunction is an option for CurrentImage and similar functions that specifies the function to apply to images before being displayed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePreviewFunction)))
(def ImagePyramid "ImagePyramid[image] creates a Gaussian image pyramid formed from image.\nImagePyramid[image, pyrtype] returns a Gaussian or Laplacian pyramid depending of the specified pyrtype.\nImagePyramid[image, pyrtype, n] returns up to n levels of the pyramid.\nImagePyramid[image, pyrtype, {size}] returns pyramid levels down to image dimensions given by size.\nImagePyramid[image, pyrtype, n, s] returns a pyramid with successive levels downsampled by factor s." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePyramid)))
(def ImagePyramidApply "ImagePyramidApply[f, pyr] applies f to all images in the ImagePyramid object pyr.\nImagePyramidApply[f, {pyr1, pyr2, …}] applies f to the sequence of corresponding levels taken from each pyri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagePyramidApply)))
(def ImageQ "ImageQ[image] yields True if image has the form of a valid Image or Image3D object, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageQ)))
(def ImageRecolor "ImageRecolor[image, regioncolor] recolors pixels in image specified by region using the specified color.\nImageRecolor[image, {region1color1, …}] recolors multiple regions.\nImageRecolor[video, …] recolors frames of a video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageRecolor)))
(def ImageReflect "ImageReflect[image] reverses image by top-bottom mirror reflection. \nImageReflect[image, side] reverses image by reflecting it so that the specified side goes to the opposite side.\nImageReflect[image, side1side2] reflects image so that side1 is interchanged with side2.\nImageReflect[video, …] reflects frames of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageReflect)))
(def ImageResize "ImageResize[image, width] gives a resized version of image that is width pixels wide.\nImageResize[image, {size}] gives a resized version of image with a maximum pixel width or height given by size.\nImageResize[image, {width, height}] gives a resized version of image that has exactly the specified pixel width and height.\nImageResize[video, …] gives a video in which every frame is resized.\nImageResize[image, {width, depth, height}] gives a resized version of a 3D image with the specified dimensions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageResize)))
(def ImageResolution "ImageResolution is an option for Export, Rasterize, and related functions that specifies at what resolution bitmap images should be rendered." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageResolution)))
(def ImageRestyle "ImageRestyle[image, sample] attempts to restyle image so as to follow the graphical style of sample. \nImageRestyle[image, wsample] uses restyle weighting w. \nImageRestyle[image, {sample1, …}] attempts to restyle image using a blend of the graphical styles of the samplei.\nImageRestyle[image, {w1sample1, …}] uses weightings wi for the samplei." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageRestyle)))
(def ImageRotate "ImageRotate[image] rotates image by 90° about its center in the x-y plane. \nImageRotate[image, θ] rotates image by θ radians.\nImageRotate[image, {θ, w}] rotates a 3D image around the 3D vector w.\nImageRotate[image, …, size] gives an image of the specified size.\nImageRotate[video, …] rotate frames of video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageRotate)))
(def ImageSaliencyFilter "ImageSaliencyFilter[image] returns a saliency map for image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSaliencyFilter)))
(def ImageScaled "ImageScaled[{x, y}] gives the position of a graphical object in terms of coordinates scaled to run from 0 to 1 across the whole image region in each direction. \nImageScaled[{dx, dy}, {x0, y0}] gives a position obtained by starting at ordinary coordinates {x0, y0}, then moving by an image‐scaled offset {dx, dy}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageScaled)))
(def ImageScan "ImageScan[f, image] evaluates f applied to each pixel of image in turn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageScan)))
(def ImageSegmentationComponents "ImageSegmentationComponents[image] performs a global segmentation of image and returns a label matrix of components.\nImageSegmentationComponents[image, spec] segments an image into components based on the given spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSegmentationComponents)))
(def ImageSegmentationFilter "ImageSegmentationFilter[image, marker] segments part of image specified by marker and returns an image mask." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSegmentationFilter)))
(def ImageSize "ImageSize is an option that specifies the overall size of an image to display for an object." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSize)))
(def ImageSizeAction "ImageSizeAction is an option for Pane and related constructs that specifies what to do if the specified ImageSize setting does not match the size of the contents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSizeAction)))
(def ImageSizeMultipliers "ImageSizeMultipliers is an option that specifies how much smaller to render graphics that appear within other constructs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSizeMultipliers)))
(def ImageStitch "ImageStitch[{image1, image2, …}] gives a composed image from an unordered list of imagei.\nImageStitch[{{image11, image12, …}, {image21, image22, …}, …}] returns a stitched image from a matrix of images imageij, according to their array position.\nImageStitch[images, canvas] projects the stitched image onto the geometry specified by canvas." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageStitch)))
(def ImageSubtract "ImageSubtract[image, x] subtracts a constant amount x from each channel value in image.\nImageSubtract[image1, image2] gives an image in which each pixel is obtained by subtracting the values of the corresponding pixels in image1 and image2.\nImageSubtract[image, expr1, expr2, …] subtracts all expri from image, where each expri can be either an image, a number, or a color value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSubtract)))
(def ImageSynthesize "ImageSynthesize[text] generates an image based on the textual description text.\nImageSynthesize[image] generates a new image based on image.\nImageSynthesize[spec, n] generates n images based on the specification spec." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageSynthesize)))
(def ImageTake "ImageTake[image, n] gives an image consisting of the first n rows of image.\nImageTake[image, -n] gives an image consisting of the last n rows of image.\nImageTake[image, {row1, row2}] gives rows row1 through row2.\nImageTake[image, {row1, row2}, {col1, col2}] gives the image that spans row1 to row2 and col1 to col2.\nImageTake[video, …] returns a video in which every frame consists of the specified region of interest.\nImageTake[image3d, {slice1, slice2}, {row1, row2}, {col1, col2}] gives the 3D image consisting of the specified slices, rows, and columns." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageTake)))
(def ImageTransformation "ImageTransformation[image, f] gives an image in which each pixel at position p corresponds to the position f[p] in image.\nImageTransformation[image, f, size] gives an image of the specified size.\nImageTransformation[video, …] transforms frames of a video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageTransformation)))
(def ImageTrim "ImageTrim[image, roi] gives the smallest subimage of image that includes the specified region of interest roi.\nImageTrim[image, roi, r] adds a margin of size r back to the resulting image.\nImageTrim[image, {roi1, roi2, …}, …] extracts multiple subimages specified by roii from image.\nImageTrim[video, …] extracts the subimages from video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageTrim)))
(def ImageType "ImageType[image] gives the underlying type of values used for each pixel element in the Image or Image3D object image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageType)))
(def ImageValue "ImageValue[image, pos] gives the interpolated value of image at position pos.\nImageValue[image, pos, \"type\"] gives the value converted to the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageValue)))
(def ImageValuePositions "ImageValuePositions[image, val] returns a list of pixel positions in image that exactly match the value val.\nImageValuePositions[image, val, d] returns all pixel positions that have values within a distance d from val." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageValuePositions)))
(def ImageVectorscopePlot "ImageVectorscopePlot[image] plots the chrominance of image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageVectorscopePlot)))
(def ImageWaveformPlot "ImageWaveformPlot[image] plots the waveform of image.\nImageWaveformPlot[image, colorspace] plots the waveform of image in colorspace.\nImageWaveformPlot[image, channel] plots the waveform for the specified channel." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImageWaveformPlot)))
(def ImagingDevice "ImagingDevice is an option to specify what device to use for capturing images." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImagingDevice)))
(def ImplicitD "ImplicitD[eqn, y, x] gives the partial derivative ∂y/∂x, assuming that the variable y represents an implicit function defined by the equation eqn.\nImplicitD[f, eqn, y, x] gives the partial derivative ∂f/∂x, assuming that the variable y represents an implicit function defined by the equation eqn.\nImplicitD[f, {eqn1, …, eqnk}, {y1, …, yk}, x] gives the partial derivative ∂f/∂x, assuming that the variables y1, …, yk represent implicit functions defined by the system of equations eqn1∧…∧eqnk.\nImplicitD[f, eqns, ys, {x, n}] gives the multiple derivative ∂^nf/∂x^n.\nImplicitD[f, eqns, ys, x1, x2, …] gives the partial derivative ⋯ (∂/∂x2)(∂/∂x1) f.\nImplicitD[f, eqns, ys, {x1, n1}, {x2, n2}, …] gives the multiple partial derivative ⋯ (∂^n2/∂x2^n2)(∂^n1/∂x1^n1) f.\nImplicitD[f, eqns, ys, {{x1, x2, …}}] for a scalar f gives the vector derivative (∂f/∂x1, ∂f/∂x2, …). \nImplicitD[f, eqns, ys, {array}] gives an array derivative." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImplicitD)))
(def ImplicitRegion "ImplicitRegion[cond, {x1, …, xn}] represents a region in ^n that satisfies the conditions cond. \nImplicitRegion[cond, {{x1, a1, b1}, …}] represents a region in ^n that satisfies the conditions cond as well as a1≤x1≤b1 etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImplicitRegion)))
(def Implies "Implies[p, q] represents the logical implication p⇒q." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Implies)))
(def Import "Import[source] imports data from source, returning a Wolfram Language representation of it.\nImport[source, \"fmt\"] takes the file to be in the specified format \"fmt\".\nImport[source, elements] imports the specified elements from a file.\nImport[source, …, options] uses the specified options." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Import)))
(def ImportByteArray "ImportByteArray[ba, \"format\"] imports data in the specified format from a ByteArray object.\nImportByteArray[ba, elements] imports the specified elements.\nImportByteArray[ba] attempts to determine the format automatically." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImportByteArray)))
(def ImportOptions "ImportOptions is an option for Interpreter and related functions that specifies what options should be used in importing data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImportOptions)))
(def ImportString "ImportString[\"data\", \"format\"] imports data in the specified format from a string. \nImportString[\"data\", elements] imports the specified elements.\nImportString[\"data\"] attempts to determine the format of the string from its contents." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImportString)))
(def ImportedObject "ImportedObject[…] represents a piece of imported data that has no special representation in the Wolfram Language." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImportedObject)))
(def ImprovementImportance "ImprovementImportance[rdist, t] gives the improvement importances for all components in the ReliabilityDistribution rdist at time t.\nImprovementImportance[fdist, t] gives the improvement importances for all components in the FailureDistribution fdist at time t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ImprovementImportance)))
(def In "In[n] is a global object that is assigned to have a delayed value of the n ^th input line." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote In)))
(def InString "InString[n] is a global object that is assigned to be the text of the n ^th input line." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InString)))
(def Inactivate "Inactivate[expr] replaces all instances of f with Inactive[f] for symbols f used as heads in expr.\nInactivate[expr, patt] inactivates all symbols in expr that match the pattern patt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inactivate)))
(def Inactive "Inactive[f] is an inactive form of f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inactive)))
(def IncidenceGraph "IncidenceGraph[m] gives the graph with incidence matrix m.\nIncidenceGraph[{v1, v2, …}, m] gives the graph with vertices vi and incidence matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncidenceGraph)))
(def IncidenceList "IncidenceList[g, v] gives a list of edges incident to vertex v.\nIncidenceList[g, patt] gives a list of edges incident to vertices that match the pattern patt.\nIncidenceList[g, patt, d] gives a list of incident edges d steps away.\nIncidenceList[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncidenceList)))
(def IncidenceMatrix "IncidenceMatrix[g] gives the vertex-edge incidence matrix of the graph g.\nIncidenceMatrix[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncidenceMatrix)))
(def IncludeAromaticBonds "IncludeAromaticBonds is an option for Molecule that specifies whether aromatic bonds should be detected and labeled." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeAromaticBonds)))
(def IncludeConstantBasis "IncludeConstantBasis is an option for LinearModelFit and other fitting functions that specifies whether a constant term should be included if not explicitly given in the list of basis functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeConstantBasis)))
(def IncludeDefinitions "IncludeDefinitions is an option for cloud and other functions that specifies whether current definitions relevant for the evaluation of an expression should be explicitly included when the expression is deployed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeDefinitions)))
(def IncludeDirectories "IncludeDirectories is an option that specifies whether directories are included in evaluations." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeDirectories)))
(def IncludeGeneratorTasks "IncludeGeneratorTasks is an option controlling the scope of scheduled task listings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeGeneratorTasks)))
(def IncludeHydrogens "IncludeHydrogens is an option that specifies whether hydrogen atoms should be explicitly included in the results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeHydrogens)))
(def IncludeInflections "IncludeInflections is an option for linguistic functions that specifies whether inflected forms of words should be included in results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeInflections)))
(def IncludeMetaInformation "IncludeMetaInformation is an option for Import, Thumbnail, and other functions to specify what types of metadata to include." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeMetaInformation)))
(def IncludePods "IncludePods is an option for WolframAlpha that determines specific pod IDs to include in the results." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludePods)))
(def IncludeQuantities "IncludeQuantities is an option for DimensionalCombinations for additional quantities to include in the result." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeQuantities)))
(def IncludeRelatedTables "IncludeRelatedTables is an option for RelationalDatabase that specifies whether to include tables specified in foreign keys." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeRelatedTables)))
(def IncludeSingularSolutions "IncludeSingularSolutions is an option for DSolve that specifies whether singular solutions should be returned along with the general solution for a nonlinear ordinary differential equation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeSingularSolutions)))
(def IncludeWindowTimes "IncludeWindowTimes is an option to TimeSeriesWindow that specifies whether the endpoints in the time window should be included." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludeWindowTimes)))
(def IncludedContexts "IncludedContexts is an option for FullDefinition, Manipulate and related symbols that gives contexts whose symbols will have their definitions recursively saved." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IncludedContexts)))
(def Increment "x++ increases the value of x by 1, returning the old value of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Increment)))
(def IndefiniteMatrixQ "IndefiniteMatrixQ[m] gives True if m is explicitly indefinite, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndefiniteMatrixQ)))
(def IndependenceTest "IndependenceTest[v1, v2] tests whether the vectors v1 and v2 are independent.\nIndependenceTest[m1, m2] tests whether the matrices m1 and m2 are independent.\nIndependenceTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependenceTest)))
(def IndependentEdgeSetQ "IndependentEdgeSetQ[g, elist] yields True if the edge list elist is an independent edge set of the graph g, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependentEdgeSetQ)))
(def IndependentPhysicalQuantity "IndependentPhysicalQuantity[string] represents a physical quantity string with no relationship to other physical quantities used in QuantityVariable." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependentPhysicalQuantity)))
(def IndependentUnit "IndependentUnit[string] represents a unit string with no relationship to other units within a Quantity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependentUnit)))
(def IndependentUnitDimension "IndependentUnitDimension[dim] represents the base dimension dim associated with an independent physical quantity or unit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependentUnitDimension)))
(def IndependentVertexSetQ "IndependentVertexSetQ[g, vlist] yields True if the vertex list vlist is an independent vertex set in the graph g, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndependentVertexSetQ)))
(def Indeterminate "Indeterminate is a symbol that represents a numerical quantity whose magnitude cannot be determined." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Indeterminate)))
(def IndeterminateThreshold "IndeterminateThreshold is an option for Classify, Predict, and related functions that specifies below what probability or probability density a result should be considered indeterminate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndeterminateThreshold)))
(def IndexEdgeTaggedGraph "IndexEdgeTaggedGraph[g] sets tags of edges in the graph g to their edge indices.\nIndexEdgeTaggedGraph[g, r] sets tags of edges to r, r+1, …" (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndexEdgeTaggedGraph)))
(def IndexGraph "IndexGraph[g] replaces the vertices of the graph g by its vertex indices.\nIndexGraph[g, r] replaces the vertices with integers r,  r+1, ….\nIndexGraph[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IndexGraph)))
(def Indexed "Indexed[expr, i] represents the component of expr with index i and formats as expri.\nIndexed[expr, {i, j, …}] represents the component with indices i, j, … and formats as expr i, j, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Indexed)))
(def InertEvaluate "InertEvaluate[inertExpr] evaluates an \"InertExpression\", returning a new \"InertExpression\" in compiled code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InertEvaluate)))
(def InertExpression "InertExpression[expr] creates an inert expression in compiled code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InertExpression)))
(def InexactNumberQ "InexactNumberQ[expr] returns True if expr is an inexact real or complex number, and returns False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InexactNumberQ)))
(def InfiniteFuture "InfiniteFuture returns a DateObject expression representing infinite future in time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InfiniteFuture)))
(def InfiniteLine "InfiniteLine[{p1, p2}] represents the infinite straight line passing through the points p1 and p2. \nInfiniteLine[p, v] represents the infinite straight line passing through the point p in the direction v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InfiniteLine)))
(def InfiniteLineThrough "InfiniteLineThrough[{p1, p2, …}] gives an infinite line passing through the points pi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InfiniteLineThrough)))
(def InfinitePast "InfinitePast returns a DateObject expression representing infinite past in time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InfinitePast)))
(def InfinitePlane "InfinitePlane[{p1, p2, p3}] represents the plane passing through the points p1, p2, and p3.\nInfinitePlane[p, {v1, v2}] represents the plane passing through the point p in the directions v1 and v2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InfinitePlane)))
(def Infinity "Infinity or ∞ is a symbol that represents a positive infinite quantity." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Infinity)))
(def Infix "Infix[f[e1, e2, …]] prints with f[e1, e2, …] given in default infix form: e1~f~e2~f~e3…. \nInfix[expr, h] prints with arguments separated by h: e1 h e2 h e3 …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Infix)))
(def InflationAdjust "InflationAdjust[quantity, targetdate] attempts to adjust the specified quantity purchasing power to targetdate.\nInflationAdjust[quantity] uses the current year as targetdate.\nInflationAdjust[quantity, targetunit] converts the currency to targetunit after adjusting to the current year.\nInflationAdjust[timeseries, targetdate] attempts to adjust the specified timeseries data purchasing power to targetdate." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InflationAdjust)))
(def InflationMethod "InflationMethod is an option for InflationAdjust that specifies what time series data is to be used for adjustment in time." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InflationMethod)))
(def Information "Information[expr] gives information about the expression expr. \nInformation[expr, prop] gives the value of the property prop for expr.\nInformation[{expr1, expr2, …}, …] gives information about all of the expri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Information)))
(def InheritScope "InheritScope is an option for DynamicModule that specifies whether to attempt to bind variables referenced in the DynamicModule to a parent DynamicModule instance." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InheritScope)))
(def Inherited "Inherited represents an option value to be inherited from an enclosing style, cell, or notebook." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inherited)))
(def InhomogeneousPoissonPointProcess "InhomogeneousPoissonPointProcess[μ, d] represents an inhomogeneous Poisson point process with density function μ:^d> in ^d." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InhomogeneousPoissonPointProcess)))
(def InhomogeneousPoissonProcess "InhomogeneousPoissonProcess[λ[t], t] represents an inhomogeneous Poisson process with intensity λ[t] given as a function of t." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InhomogeneousPoissonProcess)))
(def InitialEvaluationHistory "InitialEvaluationHistory is an option for functions such as BayesianMinimization that gives an initial set of configurations and values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitialEvaluationHistory)))
(def InitialSeeding "InitialSeeding is an option for NDSolve and other functions that specifies equations that specify initial seeding values for variables that may be used by iterative algorithms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitialSeeding)))
(def Initialization "Initialization is an option for notebooks, cells, Dynamic, DynamicModule, Manipulate and related constructs that specifies an expression to be evaluated when the construct is first displayed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Initialization)))
(def InitializationCell "InitializationCell is an option for Cell that specifies whether the cell should be tagged to be evaluated by the Wolfram Language kernel immediately before the first evaluation performed by the user after the notebook is opened." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitializationCell)))
(def InitializationObject "InitializationObject[sym, loc] gives the persistent object where InitializationValue[sym, loc] is stored.\nInitializationObject[\"context`name\", loc] gives the persistent object where the initialization value for the symbol with the specified complete name is stored." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitializationObject)))
(def InitializationObjects "InitializationObjects[] gives the list of all persistent initialization objects in all locations in $PersistencePath.\nInitializationObjects[\"patt\"] gives all persistent initialization objects for symbols matching the string pattern \"patt\".\nInitializationObjects[\"patt\", loc] gives all matching persistent initialization objects in the persistence location loc.\nInitializationObjects[\"patt\", {loc1, …}] gives all matching persistent initialization objects in all the loci." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitializationObjects)))
(def InitializationValue "InitializationValue[sym] represents the settable persistent value with which the symbol sym will be initialized.\nInitializationValue[\"context`name\"] represents the settable initialization value for the symbol with the specified complete name.\nInitializationValue[sym, {loc1, …}] specifies the persistence locations to search for a possible initialization value." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InitializationValue)))
(def Initialize "Initialize[sym] initializes the symbol sym from persistent values on the default persistence path.\nInitialize[sym, {loc1, …}] initializes the symbol sym from persistent values on the persistence path {loc1, …}.\nInitialize[\"patt\"] initializes all variables matching the string pattern \"patt\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Initialize)))
(def Inner "Inner[f, list1, list2, g] is a generalization of Dot in which f plays the role of multiplication and g of addition." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inner)))
(def InnerPolygon "InnerPolygon[poly] gives the inner polygon of the polygon poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InnerPolygon)))
(def InnerPolyhedron "InnerPolyhedron[poly] gives the inner polyhedron of the polyhedron poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InnerPolyhedron)))
(def Inpaint "Inpaint[image, region] retouches parts of image that correspond to nonzero elements in region." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inpaint)))
(def Input "Input[] interactively reads in one Wolfram Language expression. \nInput[prompt] requests input, displaying prompt as a \"prompt\".\nInput[prompt, init] in a notebook front end uses init as the initial contents of the input field." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Input)))
(def InputAliases "InputAliases is an option for cells and notebooks which specifies additional Esc name Esc aliases to be allowed on input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputAliases)))
(def InputAssumptions "InputAssumptions is an option for WolframAlpha that specifies assumptions for current query input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputAssumptions)))
(def InputAutoReplacements "InputAutoReplacements is an option for cells and notebooks which specifies strings of characters that should be replaced immediately on input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputAutoReplacements)))
(def InputField "InputField[] represents a blank editable input field. \nInputField[x] represents an editable input field that currently contains the expression x. \nInputField[Dynamic[x]] takes the contents of the input field to be the dynamically updated current value of x, with the value of x being reset if new contents are entered. \nInputField[x, String] represents an input field whose contents are taken to be a string. \nInputField[x, Number] represents an input field whose contents are taken to be a number. \nInputField[x, type] represents an input field whose contents are taken to be of the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputField)))
(def InputForm "InputForm[expr] prints as a version of expr suitable for input to the Wolfram Language." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputForm)))
(def InputNamePacket "InputNamePacket[string] is a WSTP packet that contains in string the name to be assigned to the next input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputNamePacket)))
(def InputNotebook "InputNotebook[] gives the current notebook into which keyboard input in the front end will be directed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputNotebook)))
(def InputOutputResponse "InputOutputResponse[sys, u, tspec] gives the response of the input-output model sys with input signals u and temporal specification tspec.\nInputOutputResponse[sys, …, \"prop\"] gives the value of property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputOutputResponse)))
(def InputOutputResponseData "InputOutputResponseData[…] represents response data generated by InputOutputResponse." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputOutputResponseData)))
(def InputPacket "InputPacket[] is a WSTP packet that indicates a prompt for input as generated by Input." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputPacket)))
(def InputPorts "InputPorts is an option to specify the number, names or shapes of input ports for some neural net layers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputPorts)))
(def InputStream "InputStream[\"name\", n] is an object that represents an input stream for functions such as Read and Find." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputStream)))
(def InputString "InputString[] interactively reads in a character string. \nInputString[prompt] requests input, displaying prompt as a \"prompt\". \nInputString[prompt, init] in a notebook front end uses init as the initial contents of the input field." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputString)))
(def InputStringPacket "InputStringPacket[] is a WSTP packet that requests input in string form." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InputStringPacket)))
(def InscribedBall "InscribedBall[{p1, p2, …}] gives the largest ball that lies inside the convex hull of the points p1, p2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InscribedBall)))
(def Insert "Insert[list, elem, n] inserts elem at position n in list. If n is negative, the position is counted from the end. \nInsert[expr, elem, {i, j, …}] inserts elem at position {i, j, …} in expr. \nInsert[expr, elem, {{i1, j1, …}, {i2, j2, …}, …}] inserts elem at several positions. \nInsert[elem, pos] represents an operator form of Insert that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Insert)))
(def InsertLinebreaks "InsertLinebreaks[\"string\"] inserts newline characters into string to make a string in which no line is longer than 78 characters.\nInsertLinebreaks[\"string\", n] inserts newline characters to make no line longer than n characters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InsertLinebreaks)))
(def InsertResults "InsertResults is an option for NotebookEvaluate that determines whether to place the results of evaluation in the notebook being evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InsertResults)))
(def InsertionFunction "InsertionFunction is an option for template functions that specifies how expressions are to be processed before they are inserted when the template is applied." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InsertionFunction)))
(def Inset "Inset[obj] represents an object obj inset in a graphic. \nInset[obj, pos] specifies that the inset should be placed at position pos in the graphic. \nInset[obj, pos, opos] aligns the inset so that position opos in the object lies at position pos in the enclosing graphic. \nInset[obj, pos, opos, size] specifies the size of the inset in the coordinate system of the enclosing graphic. \nInset[obj, pos, opos, size, dirs] specifies that the axes of the inset should be oriented in directions dirs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inset)))
(def Insphere "Insphere[{p1, …, p n+1}] gives the sphere that can be inscribed in the simplex defined by points pi in ^n.\nInsphere[poly] gives the insphere of a polyhedron or polygon poly." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Insphere)))
(def Install "Install[\"name\"] starts a WSTP-compatible external program and installs Wolfram Language definitions to call functions in it." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Install)))
(def InstallService "InstallService[\"url\"] installs the web service operations in the WSDL description at the URL given.\nInstallService[\"url\", \"context`\"] installs web service operations, creating functions in the specified context." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InstallService)))
(def Integer "Integer is the head used for integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Integer)))
(def IntegerDigits "IntegerDigits[n] gives a list of the decimal digits in the integer n. \nIntegerDigits[n, b] gives a list of the base b digits in the integer n. \nIntegerDigits[n, b, len] pads the list on the left with zeros to give a list of length len. \nIntegerDigits[n, MixedRadix[blist]] uses the mixed radix with list of bases blist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerDigits)))
(def IntegerExponent "IntegerExponent[n, b] gives the highest power of b that divides n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerExponent)))
(def IntegerLength "IntegerLength[n] gives the number of digits in the base 10 representation of the integer n.\nIntegerLength[n, b] gives the number of digits in the base b representation of n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerLength)))
(def IntegerName "IntegerName[n] gives a string containing the full English name of the integer n.\nIntegerName[n, qualifier] gives a string conforming to the given qualifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerName)))
(def IntegerPart "IntegerPart[x] gives the integer part of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerPart)))
(def IntegerPartitions "IntegerPartitions[n] gives a list of all possible ways to partition the integer n into smaller integers. \nIntegerPartitions[n, k] gives partitions into at most k integers. \nIntegerPartitions[n, {k}] gives partitions into exactly k integers. \nIntegerPartitions[n, {kmin, kmax}] gives partitions into between kmin and kmax integers. \nIntegerPartitions[n, kspec, {s1, s2, …}] gives partitions involving only the si. \nIntegerPartitions[n, kspec, sspec, m] limits the result to the first m partitions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerPartitions)))
(def IntegerQ "IntegerQ[expr] gives True if expr is an integer, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerQ)))
(def IntegerReverse "IntegerReverse[n] gives the integer whose digits are reversed with respect to those of the integer n.\nIntegerReverse[n, b] gives the integer whose digits in base b are reversed with respect to those of n.\nIntegerReverse[n, b, len] gives the integer with reversed digits after padding n with zeros on the left to have len digits." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerReverse)))
(def IntegerString "IntegerString[n] gives a string consisting of the decimal digits in the integer n. \nIntegerString[n, b] gives a string consisting of the base-b digits in the integer n. \nIntegerString[n, b, len] pads the string on the left with zero digits to give a string of length len. \nIntegerString[n, MixedRadix[blist]] uses the mixed radix with a list of bases blist.\nIntegerString[n, \"numsys\"] gives the numeral form of n based on the numeric system defined by \"numsys\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegerString)))
(def Integers "Integers represents the domain of integers, as in x∈Integers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Integers)))
(def Integrate "Integrate[f, x] gives the indefinite integral ∫f dx. \nIntegrate[f, {x, xmin, xmax}] gives the definite integral ∫_xmin^xmax f dx. \nIntegrate[f, {x, xmin, xmax}, {y, ymin, ymax}, …] gives the multiple integral ∫_xmin^xmaxdx ∫_ymin^ymaxdy … f. \nIntegrate[f, {x, y, …}∈reg] integrates over the geometric region reg." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Integrate)))
(def IntegrateChangeVariables "IntegrateChangeVariables[integral, u, trans] changes the variable in integral to the new variable u using the transformation trans. \nIntegrateChangeVariables[integral, {u, v, …}, trans] changes the variables to the new variables u, v, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntegrateChangeVariables)))
(def Interactive "Interactive is an option that specifies whether a function should create a user prompt when mimicking an action that would have created a user prompt if invoked manually." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interactive)))
(def InteractiveTradingChart "InteractiveTradingChart[{{date1, {open1, high1, low1, close1, volume1}}, …}] makes a chart showing prices and volume for each date. \nInteractiveTradingChart[{\"name\", daterange}] makes a financial chart for the financial entity \"name\" over the daterange. \nInteractiveTradingChart[{…}, {ind1, ind2, …}] makes a financial chart with indicators ind1, ind2, … ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InteractiveTradingChart)))
(def InterfaceSwitched "InterfaceSwitched[size1expr1, size2expr2, …|>] is a construct that behaves as if it were expri when it is in an interface environment with width sizei.\nInterfaceSwitched[\"param\", <|key1->expr1, key2->expr2, …|>] behaves as if it were expri when the value of the interface parameter param corresponds to keyi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterfaceSwitched)))
(def Interleaving "Interleaving is an option for Image and related functions that specifies whether data corresponding to different channels in an object such as an image should be interleaved." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interleaving)))
(def IntermediateTest "IntermediateTest[input] creates an intermediate test to determine whether input evaluates to True.\nIntermediateTest[input, expected] creates an intermediate test to determine whether input evaluates to expected.\nIntermediateTest[input, expected, messages] creates an intermediate test that is expected to generate the list of message names messages." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntermediateTest)))
(def InternallyBalancedDecomposition "InternallyBalancedDecomposition[ssm] yields the internally balanced decomposition of the state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InternallyBalancedDecomposition)))
(def InterpolatingFunction "InterpolatingFunction[domain, table] represents an approximate function whose values are found by interpolation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpolatingFunction)))
(def InterpolatingPolynomial "InterpolatingPolynomial[{f1, f2, …}, x] constructs an interpolating polynomial in x which reproduces the function values fi at successive integer values 1, 2, … of x. \nInterpolatingPolynomial[{{x1, f1}, {x2, f2}, …}, x] constructs an interpolating polynomial for the function values fi corresponding to x values xi.\nInterpolatingPolynomial[{{{x1, y1, …}, f1}, {{x2, y2, …}, f2}, …}, {x, y, …}] constructs a multidimensional interpolating polynomial in the variables x, y, ….\nInterpolatingPolynomial[{{{x1, …}, f1, df1, …}, …}, {x, …}] constructs an interpolating polynomial that reproduces derivatives as well as function values." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpolatingPolynomial)))
(def Interpolation "Interpolation[{f1, f2, …}] constructs an interpolation of the function values fi, assumed to correspond to x values 1, 2, … . \nInterpolation[{{x1, f1}, {x2, f2}, …}] constructs an interpolation of the function values fi corresponding to x values xi.\nInterpolation[{{{x1, y1, …}, f1}, {{x2, y2, …}, f2}, …}] constructs an interpolation of multidimensional data.\nInterpolation[{{{x1, …}, f1, df1, …}, …}] constructs an interpolation that reproduces derivatives as well as function values.\nInterpolation[data, x] find an interpolation of data at the point x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interpolation)))
(def InterpolationOrder "InterpolationOrder is an option for Interpolation, as well as ListLinePlot, ListPlot3D, ListContourPlot, and related functions, that specifies what order of interpolation to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpolationOrder)))
(def InterpolationPoints "InterpolationPoints is an option to SmoothKernelDistribution and FunctionInterpolation that specifies the initial number of interpolation points to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpolationPoints)))
(def Interpretation "Interpretation[e, expr] represents an object that displays as e, but is interpreted as the unevaluated form of expr if supplied as input. \nInterpretation[{x=x0, y=y0, …}, e, expr] allows local variables x, y, … in e and expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interpretation)))
(def InterpretationBox "InterpretationBox[boxes, expr] is a low-level box construct that displays as boxes but is interpreted on input as expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpretationBox)))
(def InterpretationBoxOptions "InterpretationBoxOptions is an option for selections that specifies settings for InterpretationBox constructs." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpretationBoxOptions)))
(def InterpretationFunction "InterpretationFunction is an option for TemplateBox that specifies how the box is to be evaluated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterpretationFunction)))
(def Interpreter "Interpreter[form] represents an interpreter object that can be applied to an input to try to interpret it as an object of the specified form. \nInterpreter[form, test] returns the interpreted object only if applying test to it yields True; otherwise it returns a Failure object.\nInterpreter[form, test, fail] returns the result of applying the function fail if the test fails." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interpreter)))
(def InterquartileRange "InterquartileRange[data] gives the difference between the upper and lower quartiles Overscript[q, ^]3/4-Overscript[q, ^]1/4 for the elements in data.\nInterquartileRange[data, {{a, b}, {c, d}}] uses the quantile definition specified by parameters a, b, c, d.\nInterquartileRange[dist] gives the difference between the upper and lower quartiles q 3/4-q 1/4 for the distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InterquartileRange)))
(def Interrupt "Interrupt[] generates an interrupt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interrupt)))
(def IntersectedEntityClass "IntersectedEntityClass[class1, class2, …] represents an entity class containing all the entities common to all classi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntersectedEntityClass)))
(def IntersectingQ "IntersectingQ[list1, list2] yields True if list1 and list2 have at least one element in common, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntersectingQ)))
(def Intersection "Intersection[list1, list2, …] gives a sorted list of the elements common to all the listi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Intersection)))
(def Interval "Interval[{min, max}] represents the range of values between min and max. \nInterval[{min1, max1}, {min2, max2}, …] represents the union of the ranges min1 to max1, min2 to max2, …." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Interval)))
(def IntervalIntersection "IntervalIntersection[interval1, interval2, …] gives the interval representing all points common to each of the intervali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalIntersection)))
(def IntervalMarkers "IntervalMarkers is an option for plotting functions such as ListPlot and BarChart that specifies how to represent uncertainty intervals." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalMarkers)))
(def IntervalMarkersStyle "IntervalMarkersStyle is an option for plotting functions that specifies styles in which uncertainty intervals are drawn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalMarkersStyle)))
(def IntervalMemberQ "IntervalMemberQ[interval, x] gives True if the number x lies within the specified interval, and False otherwise. \nIntervalMemberQ[interval1, interval2] gives True if interval2 is completely contained within interval1. \nIntervalMemberQ[interval] represents an operator form of IntervalMemberQ that can be applied to a number." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalMemberQ)))
(def IntervalSlider "IntervalSlider[{xmin, xmax}] represents a slider with setting {xmin, xmax} in the range 0 to 1.\nIntervalSlider[Dynamic[int]] takes the setting to be the dynamically updated current value of int, with the value of int being reset if the slider is moved.\nIntervalSlider[int, {min, max}] represents a slider with range min to max.\nIntervalSlider[int, {min, max, dx}] represents a slider that jumps in steps dx." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalSlider)))
(def IntervalUnion "IntervalUnion[interval1, interval2, …] gives an interval containing the set of all points in any of the intervali." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IntervalUnion)))
(def Inverse "Inverse[m] gives the inverse of a square matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Inverse)))
(def InverseBetaRegularized "InverseBetaRegularized[s, a, b] gives the inverse of the regularized incomplete beta function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseBetaRegularized)))
(def InverseBilateralLaplaceTransform "InverseBilateralLaplaceTransform[expr, s, t] gives the inverse bilateral Laplace transform of expr. \nInverseBilateralLaplaceTransform[expr, {s1, s2, …, sn}, {t1, t2, …, tn}] gives the multidimensional inverse bilateral Laplace transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseBilateralLaplaceTransform)))
(def InverseBilateralZTransform "InverseBilateralZTransform[expr, z, n] gives the inverse bilateral Z transform of expr.\nInverseBilateralZTransform[expr, {z1, …, zk}, {n1, …, nk}] gives the multidimensional inverse bilateral Z transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseBilateralZTransform)))
(def InverseCDF "InverseCDF[dist, q] gives the inverse of the cumulative distribution function for the distribution dist as a function of the variable q." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseCDF)))
(def InverseChiSquareDistribution "InverseChiSquareDistribution[ν] represents an inverse χ^2 distribution with ν degrees of freedom.\nInverseChiSquareDistribution[ν, ξ] represents a scaled inverse χ^2 distribution with ν degrees of freedom and scale ξ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseChiSquareDistribution)))
(def InverseContinuousWaveletTransform "InverseContinuousWaveletTransform[cwd] gives the inverse continuous wavelet transform of a ContinuousWaveletData object cwd. \nInverseContinuousWaveletTransform[cwd, wave] gives the inverse transform using the wavelet wave.\nInverseContinuousWaveletTransform[cwd, wave, octvoc] gives the inverse transform from the wavelet coefficients specified by octvoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseContinuousWaveletTransform)))
(def InverseDistanceTransform "InverseDistanceTransform[image] gives the inverse distance transform of image, returning the result as a binary image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseDistanceTransform)))
(def InverseEllipticNomeQ "InverseEllipticNomeQ[q] gives the parameter m corresponding to the nome q in an elliptic function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseEllipticNomeQ)))
(def InverseErf "InverseErf[s] gives the inverse error function obtained as the solution for z in s=erf (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseErf)))
(def InverseErfc "InverseErfc[s] gives the inverse complementary error function obtained as the solution for z in s=erfc (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseErfc)))
(def InverseFourier "InverseFourier[list] finds the discrete inverse Fourier transform of a list of complex numbers.\nInverseFourier[list, {p1, p2, …}] returns the specified positions of the discrete inverse Fourier transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFourier)))
(def InverseFourierCosTransform "InverseFourierCosTransform[expr, ω, t] gives the symbolic inverse Fourier cosine transform of expr. \nInverseFourierCosTransform[expr, {ω1, ω2, …}, {t1, t2, …}] gives the multidimensional inverse Fourier cosine transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFourierCosTransform)))
(def InverseFourierSequenceTransform "InverseFourierSequenceTransform[expr, ω, n] gives the inverse discrete-time Fourier transform of expr.\nInverseFourierSequenceTransform[expr, {ω1, ω2, …}, {n1, n2, …}] gives the multidimensional inverse Fourier sequence transform." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFourierSequenceTransform)))
(def InverseFourierSinTransform "InverseFourierSinTransform[expr, ω, t] gives the symbolic inverse Fourier sine transform of expr. \nInverseFourierSinTransform[expr, {ω1, ω2, …}, {t1, t2, …}] gives the multidimensional inverse Fourier sine transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFourierSinTransform)))
(def InverseFourierTransform "InverseFourierTransform[expr, ω, t] gives the symbolic inverse Fourier transform of expr. \nInverseFourierTransform[expr, {ω1, ω2, …}, {t1, t2, …}] gives the multidimensional inverse Fourier transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFourierTransform)))
(def InverseFunction "InverseFunction[f] represents the inverse of the function f, defined so that InverseFunction[f][y] gives the value of x for which f[x] is equal to y. \nInverseFunction[f, n, tot] represents the inverse with respect to the n ^th argument when there are tot arguments in all." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFunction)))
(def InverseFunctions "InverseFunctions is an option for Solve and related functions that specifies whether inverse functions should be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseFunctions)))
(def InverseGammaDistribution "InverseGammaDistribution[α, β] represents an inverse gamma distribution with shape parameter α and scale parameter β.\nInverseGammaDistribution[α, β, γ, μ] represents a generalized inverse gamma distribution with shape parameters α and γ, scale parameter β, and location parameter μ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseGammaDistribution)))
(def InverseGammaRegularized "InverseGammaRegularized[a, s] gives the inverse of the regularized incomplete gamma function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseGammaRegularized)))
(def InverseGaussianDistribution "InverseGaussianDistribution[μ, λ] represents an inverse Gaussian distribution with mean μ and scale parameter λ.\nInverseGaussianDistribution[μ, λ, θ] represents a generalized inverse Gaussian distribution with parameters μ, λ, and θ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseGaussianDistribution)))
(def InverseGudermannian "InverseGudermannian[z] gives the inverse Gudermannian function gd^-1 (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseGudermannian)))
(def InverseHankelTransform "InverseHankelTransform[expr, s, r] gives the inverse Hankel transform of order 0 for expr.\nInverseHankelTransform[expr, s, r, ν] gives the inverse Hankel transform of order ν for expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseHankelTransform)))
(def InverseHaversine "InverseHaversine[z] gives the inverse haversine function hav^-1 (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseHaversine)))
(def InverseImagePyramid "InverseImagePyramid[pyr] reconstructs an image from an ImagePyramid object pyr.\nInverseImagePyramid[pyr, pyrtype] assumes the specified pyramid type pyrtype.\nInverseImagePyramid[pyr, pyrtype, n] reconstructs up to pyramid level n.\nInverseImagePyramid[pyr, pyrtype, {size}] reconstructs up to the smallest pyramid level larger than the specified size." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseImagePyramid)))
(def InverseJacobiCD "InverseJacobiCD[v, m] gives the inverse Jacobi elliptic function cd^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiCD)))
(def InverseJacobiCN "InverseJacobiCN[v, m] gives the inverse Jacobi elliptic function cn^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiCN)))
(def InverseJacobiCS "InverseJacobiCS[v, m] gives the inverse Jacobi elliptic function cs^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiCS)))
(def InverseJacobiDC "InverseJacobiDC[v, m] gives the inverse Jacobi elliptic function dc^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiDC)))
(def InverseJacobiDN "InverseJacobiDN[v, m] gives the inverse Jacobi elliptic function dn^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiDN)))
(def InverseJacobiDS "InverseJacobiDS[v, m] gives the inverse Jacobi elliptic function ds^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiDS)))
(def InverseJacobiNC "InverseJacobiNC[v, m] gives the inverse Jacobi elliptic function nc^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiNC)))
(def InverseJacobiND "InverseJacobiND[v, m] gives the inverse Jacobi elliptic function nd^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiND)))
(def InverseJacobiNS "InverseJacobiNS[v, m] gives the inverse Jacobi elliptic function ns^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiNS)))
(def InverseJacobiSC "InverseJacobiSC[v, m] gives the inverse Jacobi elliptic function sc^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiSC)))
(def InverseJacobiSD "InverseJacobiSD[v, m] gives the inverse Jacobi elliptic function sd^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiSD)))
(def InverseJacobiSN "InverseJacobiSN[v, m] gives the inverse Jacobi elliptic function sn^-1 (vm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseJacobiSN)))
(def InverseLaplaceTransform "InverseLaplaceTransform[F[s], s, t] gives the symbolic inverse Laplace transform of F[s] in the variable s as f[t] in the variable t. \nInverseLaplaceTransform[F[s], s, Overscript[t, ^]] gives the numeric inverse Laplace transform at the numerical value Overscript[t, ^].\nInverseLaplaceTransform[F[s1, …, sn], {s1, s2, …}, {t1, t2, …}] gives the multidimensional inverse Laplace transform of F[s1, …, sn]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseLaplaceTransform)))
(def InverseMellinTransform "InverseMellinTransform[expr, s, x] gives the inverse Mellin transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseMellinTransform)))
(def InversePermutation "InversePermutation[perm] returns the inverse of permutation perm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InversePermutation)))
(def InverseRadon "InverseRadon[image] gives the inverse discrete Radon transform of image.\nInverseRadon[image, {w, h}] specifies the width w and the height h of the resulting image." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseRadon)))
(def InverseRadonTransform "InverseRadonTransform[expr, {p, ϕ}, {x, y}] gives the inverse Radon transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseRadonTransform)))
(def InverseSeries "InverseSeries[s] takes the series s, and gives a series for the inverse of the function represented by s. \nInverseSeries[s, x] uses the variable x in the inverse series." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseSeries)))
(def InverseShortTimeFourier "InverseShortTimeFourier[input] reconstructs the signal from short-time Fourier data.\nInverseShortTimeFourier[input, n] assumes the spectrogram data was computed with partitions of length n.\nInverseShortTimeFourier[input, n, d] assumes partitions with offset d.\nInverseShortTimeFourier[input, n, d, wfun] assumes a smoothing window wfun was applied to each partition." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseShortTimeFourier)))
(def InverseSpectrogram "InverseSpectrogram[data] reconstructs the signal from the magnitude spectrogram data.\nInverseSpectrogram[img] reconstructs the signal, assuming that the image img is the magnitude spectrogram.\nInverseSpectrogram[input, n] assumes the spectrogram data was computed with partitions of length n.\nInverseSpectrogram[input, n, d] assumes partitions with offset d.\nInverseSpectrogram[input, n, d, wfun] assumes a smoothing window wfun was applied to each partition." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseSpectrogram)))
(def InverseSurvivalFunction "InverseSurvivalFunction[dist, q] gives the inverse of the survival function for the distribution dist as a function of the variable q." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseSurvivalFunction)))
(def InverseTransformedRegion "InverseTransformedRegion[reg, f, n] represents the inverse transformed region {p∈^n|f(p)∈reg}, where reg is a region and f is a function." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseTransformedRegion)))
(def InverseWaveletTransform "InverseWaveletTransform[dwd] gives the inverse wavelet transform of a DiscreteWaveletData object dwd.\nInverseWaveletTransform[dwd, wave] gives the inverse transform using the wavelet wave.\nInverseWaveletTransform[dwd, wave, wind] gives the inverse transform from the wavelet coefficients specified by wind." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseWaveletTransform)))
(def InverseWeierstrassP "InverseWeierstrassP[p, {g2, g3}] gives a value of u for which the Weierstrass function ℘(u;g2, g3) is equal to p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseWeierstrassP)))
(def InverseWishartMatrixDistribution "InverseWishartMatrixDistribution[ν, Σ] represents an inverse Wishart matrix distribution with ν degrees of freedom and covariance matrix Σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseWishartMatrixDistribution)))
(def InverseZTransform "InverseZTransform[expr, z, n] gives the inverse Z transform of expr. \nInverseZTransform[expr, {z1, …, zm}, {n1, …, nm}] gives the multiple inverse Z transform of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote InverseZTransform)))
(def Invisible "Invisible[expr] displays as space that is the same size as the formatted version of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Invisible)))
(def IrreduciblePolynomialQ "IrreduciblePolynomialQ[poly] tests whether poly is an irreducible polynomial over the rationals.\nIrreduciblePolynomialQ[poly, Modulusp] tests whether poly is irreducible modulo a prime p.\nIrreduciblePolynomialQ[poly, Extension{a1, a2, …}] tests whether poly is irreducible over the field extension generated by the algebraic numbers ai.\nIrreduciblePolynomialQ[poly, ExtensionAll] tests whether poly is absolutely irreducible over the complex numbers." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IrreduciblePolynomialQ)))
(def IslandData "IslandData[entity, property] gives the value of the specified property for the island entity.\nIslandData[{entity1, entity2, …}, property] gives a list of property values for the specified island entities.\nIslandData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IslandData)))
(def IsolatingInterval "IsolatingInterval[a] gives a rational isolating interval for the algebraic number a.\nIsolatingInterval[a, dx] gives an isolating interval of width at most dx." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IsolatingInterval)))
(def IsomorphicGraphQ "IsomorphicGraphQ[g1, g2] yields True if the graphs g1 and g2 are isomorphic, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IsomorphicGraphQ)))
(def IsomorphicSubgraphQ "IsomorphicSubgraphQ[g1, g2] yields True if the graph g1 is isomorphic to a subgraph of the graph g2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IsomorphicSubgraphQ)))
(def IsotopeData "IsotopeData[{Z, A}, \"property\"] gives the value of the specified property for the isotope with atomic number Z and mass number A.\nIsotopeData[\"name\", \"property\"] gives the value of the property for the named isotope." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote IsotopeData)))
(def Italic "Italic represents an italic font slant." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Italic)))
(def Item "Item[expr, options] represents an item within constructs such as Grid, Overlay, and Manipulate that displays with expr as the content, and with the specified options applied to the region containing expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Item)))
(def ItemAspectRatio "ItemAspectRatio is an option for GraphicsGrid which specifies the ratio of height to width for the regions in which items are placed in the graphics grid." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ItemAspectRatio)))
(def ItemDisplayFunction "ItemDisplayFunction is an option for Dataset that specifies a function to apply to items before displaying them." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ItemDisplayFunction)))
(def ItemSize "ItemSize is an option for Grid, Column, and related constructs that specifies the sizes to allow for items." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ItemSize)))
(def ItemStyle "ItemStyle is an option for Dataset, Grid and related constructs that specifies styles to use for items." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ItemStyle)))
(def ItoProcess "ItoProcess[{a, b}, x, t] represents an Ito process x(t), where x(t)a(t, x(t))t+b (t, x(t)).w(t).\nItoProcess[{a, b, c}, x, t] represents an Ito process y(t)c(t, x(t)), where x(t)a(t, x(t))t+b (t, x(t)).w(t) .\nItoProcess[…, {x, x0}, {t, t0}] uses initial condition x(t0)x0.\nItoProcess[…, …, …, Σ] uses a Wiener process w(t), with covariance Σ.\nItoProcess[proc] converts proc to a standard Ito process whenever possible. \nItoProcess[sdeqns, expr, x, t, wdproc] represents an Ito process specified by a stochastic differential equation sdeqns, output expression expr, with state x and time t, driven by w following the process dproc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote ItoProcess)))
(def JaccardDissimilarity "JaccardDissimilarity[u, v] gives the Jaccard dissimilarity between Boolean vectors u and v." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JaccardDissimilarity)))
(def JacobiAmplitude "JacobiAmplitude[u, m] gives the amplitude am(um) for Jacobi elliptic functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiAmplitude)))
(def JacobiCD "JacobiCD[u, m] gives the Jacobi elliptic function cd (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiCD)))
(def JacobiCN "JacobiCN[u, m] gives the Jacobi elliptic function cn (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiCN)))
(def JacobiCS "JacobiCS[u, m] gives the Jacobi elliptic function cs (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiCS)))
(def JacobiDC "JacobiDC[u, m] gives the Jacobi elliptic function dc (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiDC)))
(def JacobiDN "JacobiDN[u, m] gives the Jacobi elliptic function dn (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiDN)))
(def JacobiDS "JacobiDS[u, m] gives the Jacobi elliptic function ds (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiDS)))
(def JacobiEpsilon "JacobiEpsilon[u, m] gives the Jacobi epsilon function ℰ (um)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiEpsilon)))
(def JacobiNC "JacobiNC[u, m] gives the Jacobi elliptic function nc (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiNC)))
(def JacobiND "JacobiND[u, m] gives the Jacobi elliptic function nd (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiND)))
(def JacobiNS "JacobiNS[u, m] gives the Jacobi elliptic function ns (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiNS)))
(def JacobiP "JacobiP[n, a, b, x] gives the Jacobi polynomial P _n^(a, b)(x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiP)))
(def JacobiSC "JacobiSC[u, m] gives the Jacobi elliptic function sc (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiSC)))
(def JacobiSD "JacobiSD[u, m] gives the Jacobi elliptic function sd (u|m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiSD)))
(def JacobiSN "JacobiSN[u, m] gives the Jacobi elliptic function sn (um)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiSN)))
(def JacobiSymbol "JacobiSymbol[n, m] gives the Jacobi symbol (n/m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiSymbol)))
(def JacobiZN "JacobiZN[u, m] gives the Jacobi zeta function zn (um)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiZN)))
(def JacobiZeta "JacobiZeta[ϕ, m] gives the Jacobi zeta function Ζ (ϕm)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JacobiZeta)))
(def JankoGroupJ1 "JankoGroupJ1[] represents the sporadic simple Janko group J1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JankoGroupJ1)))
(def JankoGroupJ2 "JankoGroupJ2[] represents the sporadic simple Janko group J2." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JankoGroupJ2)))
(def JankoGroupJ3 "JankoGroupJ3[] represents the sporadic simple Janko group J3." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JankoGroupJ3)))
(def JankoGroupJ4 "JankoGroupJ4[] represents the sporadic simple Janko group J4." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JankoGroupJ4)))
(def JarqueBeraALMTest "JarqueBeraALMTest[data] tests whether data is normally distributed using the Jarque–Bera ALM test.\nJarqueBeraALMTest[data, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JarqueBeraALMTest)))
(def JohnsonDistribution "JohnsonDistribution[\"SB\", γ, δ, μ, σ] represents a bounded Johnson distribution with shape parameters γ, δ, location parameter μ, and scale parameter σ.\nJohnsonDistribution[\"SL\", γ, δ, μ, σ] represents a semi-bounded Johnson distribution.\nJohnsonDistribution[\"SU\", γ, δ, μ, σ] represents an unbounded Johnson distribution.\nJohnsonDistribution[\"SN\", γ, δ, μ, σ] represents a normal Johnson distribution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JohnsonDistribution)))
(def Join "Join[list1, list2, …] concatenates lists or other expressions that share the same head.\nJoin[list1, list2, …, n] joins the objects at level n in each of the listi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Join)))
(def JoinAcross "JoinAcross[{a1, a2, …}, {b1, b2, …}, key] gives a list of associations obtained by joining those pairs of associations ai and bj in which the values associated with key are the same. \nJoinAcross[{a1, a2, …}, {b1, b2, …}, {key1, key2, …}] joins pairs of associations only when the values associated with all keys keyi are the same.\nJoinAcross[{a1, a2, …}, {b1, b2, …}, keyakeyb] joins pairs of associations ai, bj in which the values associated with keya in the ai are the same as those associated with keyb in the bj.\nJoinAcross[{a1, a2, …}, {b1, b2, …}, {key a1key b1, …}] joins pairs of associations in which pairs of corresponding values agree.\nJoinAcross[alist, blist, keyspec, \"joinspec\"] uses joinspec to determine when to allow associations that contain missing elements to be generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JoinAcross)))
(def JoinForm "JoinForm[type] is a graphics directive that specifies what type of joins should be used to connect segments of lines, tubes, edges, and related primitives." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JoinForm)))
(def Joined "Joined is an option for ListPlot and related functions that specifies whether points in each dataset should be joined into a line, or should be plotted as separate points." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Joined)))
(def JoinedCurve "JoinedCurve[{segment1, segment2, …}] represents a curve consisting of segment1 followed by segment2 etc. \nJoinedCurve[{component1, component2, …}] represents a list of separate component curves component1, component2, etc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JoinedCurve)))
(def JordanDecomposition "JordanDecomposition[m] yields the Jordan decomposition of a square matrix m. The result is a list {s, j} where s is a similarity matrix and j is the Jordan canonical form of m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JordanDecomposition)))
(def JordanModelDecomposition "JordanModelDecomposition[ssm] yields the Jordan decomposition of the state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JordanModelDecomposition)))
(def JuliaSetBoettcher "JuliaSetBoettcher[c, z] gives the Böttcher coordinate of z with respect to the quadratic Julia set Jc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JuliaSetBoettcher)))
(def JuliaSetIterationCount "JuliaSetIterationCount[f, z, p] returns the number of iterations, beginning with the complex number zp, of the function f(z) needed to determine whether p is in the Julia set of f.\nJuliaSetIterationCount[c, p] returns the number of iterations, beginning with the complex number zp, of the function f(z)z^2+c needed to determine whether p is in the Julia set of f(z)z^2+c.\nJuliaSetIterationCount[f, z, {p1, p2, …}] returns a list of the number of iterations required to determine whether each member of {p1, p2, …} is in the Julia set of f.\nJuliaSetIterationCount[c, {p1, p2, …}] returns a list of the number of iterations required to determine whether each member of {p1, p2, …} is in the Julia set of f(z)z^2+c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JuliaSetIterationCount)))
(def JuliaSetPlot "JuliaSetPlot[f, z] plots the Julia set of the rational function f of the variable z.\nJuliaSetPlot[c] plots the Julia set of the function f(z)z^2+c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JuliaSetPlot)))
(def JuliaSetPoints "JuliaSetPoints[f, z] returns a list of coordinates approximating the real and imaginary parts of the complex numbers in the Julia set of the rational function f of the variable z.\nJuliaSetPoints[c] returns a list of coordinates of points approximating the Julia set of the function f(z)z^2+c." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JuliaSetPoints)))
(def JulianDate "JulianDate[] gives the current number of days since noon on November 24, 4714 BCE in the GMT time zone. \nJulianDate[date] gives the number of days for the specified date.\nJulianDate[\"type\"] gives the Julian date variant of the specified type.\nJulianDate[\"type\", date] gives the variant for the specified date." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote JulianDate)))
(def KCoreComponents "KCoreComponents[g, k] gives the k-core components of the underlying simple graph of g.\nKCoreComponents[g, k, \"In\"] gives the k-core components with vertex in-degrees at least k.\nKCoreComponents[g, k, \"Out\"] gives the k-core components with vertex out-degrees at least k.\nKCoreComponents[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KCoreComponents)))
(def KDistribution "KDistribution[ν, w] represents a K distribution with shape parameters ν and w." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KDistribution)))
(def KEdgeConnectedComponents "KEdgeConnectedComponents[g, k] gives the k-edge-connected components of the graph g.\nKEdgeConnectedComponents[g, k, {v1, v2, …}] gives the k-edge-connected components that include at least one of the vertices v1, v2, ….\nKEdgeConnectedComponents[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KEdgeConnectedComponents)))
(def KEdgeConnectedGraphQ "KEdgeConnectedGraphQ[g, k] yields True if the graph g is k-edge-connected and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KEdgeConnectedGraphQ)))
(def KVertexConnectedComponents "KVertexConnectedComponents[g, k] gives the k-vertex-connected components of the graph g.\nKVertexConnectedComponents[g, k, {v1, v2, …}] gives the k-vertex-connected components that include at least one of the vertices v1, v2, … ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KVertexConnectedComponents)))
(def KVertexConnectedGraphQ "KVertexConnectedGraphQ[g, k] yields True if the graph g is k-vertex-connected and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KVertexConnectedGraphQ)))
(def KagiChart "KagiChart[{{date1, p1}, {date2, p2}, …}] makes a Kagi chart with prices pi at date datei.\nKagiChart[{\"name\", daterange}] makes a Kagi chart of closing prices for the financial entity \"name\" over the date range daterange.\nKagiChart[{…}, rt] makes a Kagi chart with reversal threshold rt." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KagiChart)))
(def KaiserBesselWindow "KaiserBesselWindow[x] represents a Kaiser–Bessel window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KaiserBesselWindow)))
(def KaiserWindow "KaiserWindow[x] represents a Kaiser window function of x.\nKaiserWindow[x, α] uses the parameter α." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KaiserWindow)))
(def KalmanEstimator "KalmanEstimator[ssm, {w, v}] constructs the Kalman estimator for the StateSpaceModel ssm with process and measurement noise covariance matrices w and v. \nKalmanEstimator[ssm, {w, v, h}] includes the cross-covariance matrix h.\nKalmanEstimator[{ssm, sensors}, {…}] specifies sensors as the noisy measurements of ssm.\nKalmanEstimator[{ssm, sensors, dinputs}, {…}] specifies dinputs as the deterministic inputs of ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KalmanEstimator)))
(def KalmanFilter "KalmanFilter[tproc, data] filters data using the time series model given by tproc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KalmanFilter)))
(def KarhunenLoeveDecomposition "KarhunenLoeveDecomposition[{a1, a2, …}] gives the Karhunen–Loeve transform {{b1, b2, …}, m} of the numerical arrays {a1, a2, …}, where m.aibi. \nKarhunenLoeveDecomposition[{b1, b2, …}, m] uses the inverse of the matrix m for transforming bi to ai." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KarhunenLoeveDecomposition)))
(def KaryTree "KaryTree[n] gives a binary tree with n vertices.\nKaryTree[n, k] gives a k-ary tree with n vertices." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KaryTree)))
(def KatzCentrality "KatzCentrality[g, α] gives a list of Katz centralities for the vertices in the graph g and weight α.\nKatzCentrality[g, α, β] gives a list of Katz centralities using weight α and initial centralities β.\nKatzCentrality[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KatzCentrality)))
(def KeepExistingVersion "KeepExistingVersion is an option for PacletInstall and PacletInstallSubmit that specifies whether an older version of a paclet should remain installed when a newer one gets installed." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeepExistingVersion)))
(def KelvinBei "KelvinBei[z] gives the Kelvin function bei (z).\nKelvinBei[n, z] gives the Kelvin function bein (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KelvinBei)))
(def KelvinBer "KelvinBer[z] gives the Kelvin function ber (z).\nKelvinBer[n, z] gives the Kelvin function bern (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KelvinBer)))
(def KelvinKei "KelvinKei[z] gives the Kelvin function kei (z).\nKelvinKei[n, z] gives the Kelvin function kein (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KelvinKei)))
(def KelvinKer "KelvinKer[z] gives the Kelvin function ker (z).\nKelvinKer[n, z] gives the Kelvin function kern (z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KelvinKer)))
(def KendallTau "KendallTau[v1, v2] gives Kendall's rank correlation coefficient τ for the vectors v1 and v2.\nKendallTau[m] gives Kendall's rank correlation coefficients τ for the matrix m.\nKendallTau[m1, m2] gives Kendall's rank correlation coefficients τ for the matrices m1 and m2.\nKendallTau[dist] gives Kendall's rank correlation matrix for the multivariate symbolic distribution dist.\nKendallTau[dist, i, j] gives the (i, j)^th Kendall rank correlation for the multivariate symbolic distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KendallTau)))
(def KendallTauTest "KendallTauTest[v1, v2] tests whether the vectors v1 and v2 are independent.\nKendallTauTest[m1, m2] tests whether the matrices m1 and m2 are independent.\nKendallTauTest[…, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KendallTauTest)))
(def KernelConfiguration "KernelConfiguration[spec] specifies a kernel that can be used for RemoteEvaluate or LaunchKernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelConfiguration)))
(def KernelConfigurationEdit "KernelConfigurationEdit[kernelspec] gives a dialog for editing the properties of a new kernel specification based on kernelspec.\nKernelConfigurationEdit[] prompts for the type of kernel to edit." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelConfigurationEdit)))
(def KernelEvaluate "KernelEvaluate[expr] evaluates expr in the Wolfram Language kernel, even when called from compiled code.\nKernelEvaluate[x, expr] captures the value of the compiled variable x for use in the evaluation of expr. \nKernelEvaluate[{x1, x2, …}, expr] captures the values of the xi for use in the evaluation of expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelEvaluate)))
(def KernelFunction "KernelFunction[f] represents a function to be evaluated in the Wolfram Language kernel, even when called from compiled code." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelFunction)))
(def KernelMixtureDistribution "KernelMixtureDistribution[{x1, x2, …}] represents a kernel mixture distribution based on the data values xi.\nKernelMixtureDistribution[{{x1, y1, …}, {x2, y2, …}, …}] represents a multivariate kernel mixture distribution based on data values {xi, yi, …}.\nKernelMixtureDistribution[…, bw] represents a kernel mixture distribution with bandwidth bw.\nKernelMixtureDistribution[…, bw, ker] represents a kernel mixture distribution with bandwidth bw and smoothing kernel ker." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelMixtureDistribution)))
(def KernelObject "KernelObject[n, name, …] represents a kernel available for parallel computing." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KernelObject)))
(def Ket "Ket[{k1, k2, …}] displays as |k1, k2, …〉." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Ket)))
(def Key "Key[key] represents a key used to access a value in an association.\nKey[key][assoc] extracts the value corresponding to key in the association assoc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Key)))
(def KeyCollisionFunction "KeyCollisionFunction is an option for JoinAcross that specifies how to handle pairs of elements that are not being joined but nevertheless have the same key." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyCollisionFunction)))
(def KeyComplement "KeyComplement[{assocall, assoc1, assoc2, …}] generates an association in which only elements whose keys appear in assocall but not in any of the associ are retained." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyComplement)))
(def KeyDrop "KeyDrop[assoc, {key1, key2, …}] yields an association from which elements with keys keyi have been dropped. \nKeyDrop[{assoc1, assoc2, …}, keys] gives a list of associations.\nKeyDrop[keys] represents an operator form of KeyDrop that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyDrop)))
(def KeyDropFrom "KeyDropFrom[a, key] changes the association a by dropping the element with the specified key.\nKeyDropFrom[a, {key1, key2, …}] drops the elements with keys keyi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyDropFrom)))
(def KeyExistsQ "KeyExistsQ[assoc, key] returns True if the specified key exists in the association assoc, and False otherwise.\nKeyExistsQ[key] represents an operator form of KeyExistsQ that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyExistsQ)))
(def KeyFreeQ "KeyFreeQ[assoc, form] yields True if no key in the association assoc matches form, and yields False otherwise.\nKeyFreeQ[form] represents an operator form of KeyFreeQ that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyFreeQ)))
(def KeyIntersection "KeyIntersection[{assoc1, assoc2, …}] generates a list of associations in which only elements whose keys appear in all the associ are retained." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyIntersection)))
(def KeyMap "KeyMap[f, key1val1, key2val2, …] maps f over the keys in an association, giving f[key1]val1, f[key2]val2, ….\nKeyMap[f] represents an operator form of KeyMap that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyMap)))
(def KeyMemberQ "KeyMemberQ[assoc, form] yields True if a key in the association assoc matches form, and False otherwise.\nKeyMemberQ[form] represents an operator form of KeyMemberQ that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyMemberQ)))
(def KeySelect "KeySelect[assoc, crit] selects elements in the association assoc for which crit applied to their keys is True.\nKeySelect[crit] represents an operator form of KeySelect that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeySelect)))
(def KeySort "KeySort[assoc] orders the elements of an association by sorting its keys.\nKeySort[assoc, p] orders the elements of an association using the ordering function p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeySort)))
(def KeySortBy "KeySortBy[assoc, f] sorts the elements of an association in the order defined by applying f to each of their keys.\nKeySortBy[f] represents an operator form of KeySortBy that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeySortBy)))
(def KeyTake "KeyTake[assoc, {key1, key2, …}] yields an association containing only the elements with keys keyi.\nKeyTake[{assoc1, assoc2, …}, keys] gives a list of associations.\nKeyTake[{key1, key2, …}] represents an operator form of KeyTake that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyTake)))
(def KeyUnion "KeyUnion[{assoc1, assoc2, …}] generates a list of associations in which each association has the union of the keys of the associ, padding by inserting values of Missing[…] if necessary.\nKeyUnion[{assoc1, assoc2, …}, f] uses f[key] as the value associated with a missing key." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyUnion)))
(def KeyValueMap "KeyValueMap[f, key1val1, key2val2, …] gives the list {f[key1, val1], f[key2, val2], …}.\nKeyValueMap[f] represents an operator form of KeyValueMap that can be applied to an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyValueMap)))
(def KeyValuePattern "KeyValuePattern[{patt1, …}] is a pattern object that represents an association or list of rules that includes elements matching each of the patti." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyValuePattern)))
(def KeyframeActions "KeyframeActions is an option for Manipulate and related functions that gives a list of times and control settings." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeyframeActions)))
(def KeypointStrength "KeypointStrength is an option for ImageKeypoints and related functions to specify a minimum strength of detected keypoints." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KeypointStrength)))
(def Keys "Keys[key1val1, key2val2, …] gives a list of the keys keyi in an association.\nKeys[{key1val1, key2val2, …}] gives a list of the keyi in a list of rules.\nKeys[expr, h] gives a list of keys in expr, wrapping each of them with head h before evaluation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Keys)))
(def Khinchin "Khinchin is Khinchin's constant, with numerical value ≃2.68545." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Khinchin)))
(def KillProcess "KillProcess[proc] kills the external process represented by the ProcessObject proc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KillProcess)))
(def KirchhoffGraph "KirchhoffGraph[kmat] gives the graph with Kirchhoff matrix kmat.\nKirchhoffGraph[{v1, v2, …}, kmat] gives the graph with vertices vi and Kirchhoff matrix kmat." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KirchhoffGraph)))
(def KirchhoffMatrix "KirchhoffMatrix[g] gives the Kirchhoff matrix of the graph g.\nKirchhoffMatrix[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KirchhoffMatrix)))
(def KleinInvariantJ "KleinInvariantJ[τ] gives the Klein invariant modular elliptic function J (τ)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KleinInvariantJ)))
(def KnapsackSolve "KnapsackSolve[{cost1, cost2, …}, maxtotalcost] solves the knapsack problem of finding the maximum number of items associated with each of the costi, subject to the constraint that the total cost is not larger than maxtotalcost.\nKnapsackSolve[{{payoff1, cost1}, {payoff2, cost2}, …}, maxtotalcost] finds a number of items that maximizes the total payoff, while satisfying the constraint on the total cost.\nKnapsackSolve[{{payoff1, cost1, maxcount1}, …}, maxtotalcost] allows at most maxcounti copies of item i.\nKnapsackSolve[items, {maxtotalpayoff, maxtotalcost}] finds a result that gives a total payoff not larger than maxtotalpayoff.\nKnapsackSolve[items, {maxtotalpayoff, maxtotalcost, maxtotalcount}] adds the constraint of having no more than maxtotalcount items in total. \nKnapsackSolve[label1itemspec1, …, maxtotals] labels each type of item and gives the result as an association." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KnapsackSolve)))
(def KnightTourGraph "KnightTourGraph[m, n] gives a Knight's tour graph on an mn chessboard." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KnightTourGraph)))
(def KnotData "KnotData[knot, \"property\"] gives the specified property for a knot.\nKnotData[knot] gives an image of the knot.\nKnotData[\"class\"] gives a list of knots in the specified class." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KnotData)))
(def KnownUnitQ "KnownUnitQ[expr] returns True if expr is a canonical unit, and False otherwise.\nKnownUnitQ[expr, dims] gives True if expr is a canonical unit with physical dimensions dims, and False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KnownUnitQ)))
(def KochCurve "KochCurve[n] gives the line segments representing the n ^th-step Koch curve.\nKochCurve[n, {θ1, θ2, …}] takes a series of steps of unit length at successive relative angles θi. \nKochCurve[n, {{r1, θ1}, {r2, θ2}, …}] takes successive steps of lengths proportional to ri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KochCurve)))
(def KolmogorovSmirnovTest "KolmogorovSmirnovTest[data] tests whether data is normally distributed using the Kolmogorov–Smirnov test.\nKolmogorovSmirnovTest[data, dist] tests whether data is distributed according to dist using the Kolmogorov–Smirnov test.\nKolmogorovSmirnovTest[data, dist, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KolmogorovSmirnovTest)))
(def KroneckerDelta "KroneckerDelta[n1, n2, …] gives the Kronecker delta δ n1 n2 …, equal to 1 if all the ni are equal, and 0 otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KroneckerDelta)))
(def KroneckerModelDecomposition "KroneckerModelDecomposition[ssm] yields the Kronecker decomposition of a descriptor state-space model ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KroneckerModelDecomposition)))
(def KroneckerProduct "KroneckerProduct[m1, m2, …] constructs the Kronecker product of the arrays mi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KroneckerProduct)))
(def KroneckerSymbol "KroneckerSymbol[n, m] gives the Kronecker symbol (n/m)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KroneckerSymbol)))
(def KuiperTest "KuiperTest[data] tests whether data is normally distributed using the Kuiper test.\nKuiperTest[data, dist] tests whether data is distributed according to dist using the Kuiper test.\nKuiperTest[data, dist, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KuiperTest)))
(def KumaraswamyDistribution "KumaraswamyDistribution[α, β] represents a Kumaraswamy distribution with shape parameters α and β." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KumaraswamyDistribution)))
(def Kurtosis "Kurtosis[data] gives the coefficient of kurtosis for the elements in data.\nKurtosis[dist] gives the coefficient of kurtosis for the distribution dist." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Kurtosis)))
(def KuwaharaFilter "KuwaharaFilter[data, r] computes for each element p in data the variance of the values in the four (r+1)×(r+1) squares that have p as a corner, and replaces p with the mean of the values of the square with least variance." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote KuwaharaFilter)))
(def LABColor "LABColor[l, a, b] represents a color in the CIELAB color space with lightness l and color components a and b. \nLABColor[l, a, b, α] specifies opacity α. \nLABColor[\"string\"] returns a color from an HTML color name etc.\nLABColor[color] returns the CIELAB representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LABColor)))
(def LCHColor "LCHColor[l, c, h] represents a color in the LCH color space with lightness l, chroma c and hue h.\nLCHColor[l, c, h, a] specifies opacity a. \nLCHColor[\"string\"] returns a color from an HTML color name etc.\nLCHColor[color] returns the LCH representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LCHColor)))
(def LCM "LCM[n1, n2, …] gives the least common multiple of the ni." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LCM)))
(def LLMConfiguration "LLMConfiguration[…] represents a configuration for an LLM.\nLLMConfiguration[propval] creates a configuration based on $LLMEvaluator with the specified property set to val.\nLLMConfiguration[<|prop1->val1, prop2->val2, ...|>] specifies several properties and values.\nLLMConfiguration[LLMConfiguration[…], propspec] creates a configuration based on an existing configuration." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMConfiguration)))
(def LLMEvaluator "LLMEvaluator is an option for functions such as LLMSynthesize that specifies the LLM configuration." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMEvaluator)))
(def LLMExampleFunction "LLMExampleFunction[{in1out1, in2out2, …}] creates an LLMFunction from few-shot examples.\nLLMExampleFunction[{in1, in2, …}{out1, out2, …}] generates the same result.\nLLMExampleFunction[{header, training}] prefaces the prompt with header.\nLLMExampleFunction[prompting, form] includes the interpreter form to apply to the response." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMExampleFunction)))
(def LLMFunction "LLMFunction[prompt] represents a template for a large language model (LLM) prompt.\nLLMFunction[{prompt1, prompt2, …}] represents a combination of multiple prompts.\nLLMFunction[prompt, form] includes the interpreter form to apply to the response.\nLLMFunction[…][params] give the LLM service response for prompt applied to parameters params." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMFunction)))
(def LLMPrompt "LLMPrompt[\"name\"] gives the TemplateObject for the specified large language model prompt.\nLLMPrompt[resource] retrieves the TemplateObject for the specified resource.\nLLMPrompt[…, params] gives the TemplateObject with slots filled in by params.\nLLMPrompt[…][p1, p2, …] applies a template with numbered slots to parameter values pi.\nLLMPrompt[…][key1p1, key2p2] applies a template with named slots to parameter data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMPrompt)))
(def LLMPromptGenerator "LLMPromptGenerator[f] represents a prompt generator that uses the function f.\nLLMPromptGenerator[f, inputspec] provides the specified inputspec to f." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMPromptGenerator)))
(def LLMResourceFunction "LLMResourceFunction[\"name\"] retrieves an LLMFunction with the specified name.\nLLMResourceFunction[loc] imports an LLMFunction from the specified location.\nLLMResourceFunction[…][params] applies the specified LLMFunction to the parameters params." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMResourceFunction)))
(def LLMResourceTool "LLMResourceTool[name] gives the TemplateObject for the specified large language model tool.\nLLMResourceTool[resource] retrieves the TemplateObject for the specified resource.\nLLMResourceTool[…, key1p1, key2p2, …] gives the TemplateObject with slots filled in by parameters.\nLLMResourceTool[…][key1p1, key2p2, …|>] creates an LLMTool by applying the template to parameter data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMResourceTool)))
(def LLMSynthesize "LLMSynthesize[prompt] generates text according to the input prompt.\nLLMSynthesize[{prompt1, …}] combines multiple prompti together.\nLLMSynthesize[…, prop] returns the specified property of the generated text." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMSynthesize)))
(def LLMTool "LLMTool[\"name\", params, fun] represents a tool for use by an LLM enabling it to run fun on parameters described by params.\nLLMTool[{\"name\", \"description\"}, params, fun] uses a description to prompt the LLM." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMTool)))
(def LLMToolRequest "LLMToolRequest[…] represents a tool request made by an LLM.\nLLMToolRequest[\"tool\", {name1->val1, name2->val2, …}] represents a request to \"tool\" with the specified parameter values.\nLLMToolRequest[\"tool\", params, str] annotates a request with the request string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMToolRequest)))
(def LLMToolResponse "LLMToolResponse[…] represents a response to an LLM tool request." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LLMToolResponse)))
(def LQEstimatorGains "LQEstimatorGains[ssm, {w, v}] gives the optimal estimator gain matrix for the StateSpaceModel ssm, with process and measurement noise covariance matrices w and v.\nLQEstimatorGains[ssm, {w, v, h}] includes the cross-covariance matrix h.\nLQEstimatorGains[{ssm, sensors}, {…}] specifies sensors as the noisy measurements of ssm.\nLQEstimatorGains[{ssm, sensors, dinputs}, {…}] specifies dinputs as the deterministic inputs of ssm." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LQEstimatorGains)))
(def LQGRegulator "LQGRegulator[sspec, cvs, wts] gives the optimal output feedback controller for the stochastic system specification sspec with noise covariance matrices cvs that minimizes a cost function with weights wts.\nLQGRegulator[…, \"prop\"] gives the value of the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LQGRegulator)))
(def LQOutputRegulatorGains "LQOutputRegulatorGains[sspec, wts] gives the state feedback gains for the system specification sspec that minimizes an output cost function with weights wts.\nLQOutputRegulatorGains[…, \"prop\"] gives the value of the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LQOutputRegulatorGains)))
(def LQRegulatorGains "LQRegulatorGains[sspec, wts] gives the state feedback gains for the system specification sspec that minimizes a cost function with weights wts.\nLQRegulatorGains[…, \"prop\"] gives the value of the property \"prop\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LQRegulatorGains)))
(def LUDecomposition "LUDecomposition[m] generates a representation of the LU decomposition of a square matrix m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LUDecomposition)))
(def LUVColor "LUVColor[l, u, v] represents a color in the LUV color space with lightness l and color components u and v.\nLUVColor[l, u, v, a] specifies opacity a. \nLUVColor[\"string\"] returns a color from an HTML color name etc.\nLUVColor[color] returns the LUV representation of color." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LUVColor)))
(def Label "Label[tag] represents a point in a compound expression to which control can be transferred using Goto." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Label)))
(def LabelStyle "LabelStyle is an option for formatting and related constructs that specifies the style to use in displaying their label-like elements." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LabelStyle)))
(def LabelVisibility "LabelVisibility is an option for Callout and Labeled in plotting functions that determines which labels are shown." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LabelVisibility)))
(def Labeled "Labeled[expr, lbl] displays expr labeled with lbl. \nLabeled[expr, lbl, pos] places lbl at a position specified by pos. \nLabeled[expr, {lbl1, lbl2, …}, {pos1, …}] places the lbli at positions posi. \nLabeled[expr, {lbl1, lbl2, lbl3, lbl4}, All] places the lbli at the bottom, left, top, and right, respectively." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Labeled)))
(def LabelingFunction "LabelingFunction is an option for data visualization functions to automatically label elements of a visualization." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LabelingFunction)))
(def LabelingSize "LabelingSize is an option to visualization functions that specifies the size to be used for labels and callouts." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LabelingSize)))
(def LaguerreL "LaguerreL[n, x] gives the Laguerre polynomial Ln (x). \nLaguerreL[n, a, x] gives the generalized Laguerre polynomial L_n^a(x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaguerreL)))
(def LakeData "LakeData[entity, property] gives the value of the specified property for the lake entity.\nLakeData[{entity1, entity2, …}, property] gives a list of property values for the specified lake entities.\nLakeData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LakeData)))
(def LambdaComponents "LambdaComponents[g] gives the lambda components of the graph g.\nLambdaComponents[g, {v1, v2, …}] gives the lambda components that include at least one of the vertices {v1, v2, …}.\nLambdaComponents[{vw, …}, …] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LambdaComponents)))
(def LameC "LameC[ν, j, z, m] gives the j ^th Lamé function Ec _ν^(j)(zm) of order ν with elliptic parameter m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameC)))
(def LameCPrime "LameCPrime[ν, j, z, m] gives the z-derivative of the j ^th Lamé function Ec _ν^(j)(zm) of order ν with elliptic parameter m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameCPrime)))
(def LameEigenvalueA "LameEigenvalueA[ν, j, m] gives the j ^th Lamé eigenvalue a _ν^(j)(m) of order ν with elliptic parameter m for the function LameC[ν, j, z, m]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameEigenvalueA)))
(def LameEigenvalueB "LameEigenvalueB[ν, j, m] gives the j ^th Lamé eigenvalue b _ν^(j)(m) of order ν with elliptic parameter m for the Lamé function LameS[ν, j, z, m]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameEigenvalueB)))
(def LameS "LameS[ν, j, z, m] gives the j ^th Lamé function Es _ν^(j)(zm) of order ν with elliptic parameter m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameS)))
(def LameSPrime "LameSPrime[ν, j, z, m] gives the z-derivative of the j ^th Lamé function Es _ν^(j)(zm) of order ν with elliptic parameter m." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LameSPrime)))
(def LaminaData "LaminaData[entity, property] gives the value of the specified property for the lamina entity.\nLaminaData[{entity1, entity2, …}, property] gives a list of property values for the specified lamina entities.\nLaminaData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaminaData)))
(def LanczosWindow "LanczosWindow[x] represents a Lanczos window function of x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LanczosWindow)))
(def LandauDistribution "LandauDistribution[μ, σ] represents a Landau distribution with location parameter μ and scale parameter σ.\nLandauDistribution[] represents a Landau distribution with location parameter 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LandauDistribution)))
(def Language "Language is an option that specifies the language to use." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Language)))
(def LanguageCategory "LanguageCategory is an option for Cell that determines in what category of language the contents of the cell should be assumed to be for purposes of spell checking and hyphenation." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LanguageCategory)))
(def LanguageData "LanguageData[entity, property] gives the value of the specified property for the language entity.\nLanguageData[{entity1, entity2, …}, property] gives a list of property values for the specified language entities.\nLanguageData[entity, property, annotation] gives the specified annotation associated with the given property." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LanguageData)))
(def LanguageIdentify "LanguageIdentify[\"string\"] attempts to determine what human language text in string is in, predominantly.\nLanguageIdentify[audio] performs language identification in audio recording audio.\nLanguageIdentify[video] performs language identification of the audio track in video." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LanguageIdentify)))
(def LaplaceDistribution "LaplaceDistribution[μ, β] represents a Laplace double-exponential distribution with mean μ and scale parameter β.\nLaplaceDistribution[] represents a Laplace double-exponential distribution with mean 0 and scale parameter 1." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaplaceDistribution)))
(def LaplaceTransform "LaplaceTransform[f[t], t, s] gives the symbolic Laplace transform of f[t] in the variable t and returns a transform F[s] in the variable s.\nLaplaceTransform[f[t], t, Overscript[s, ^]] gives the numeric Laplace transform at the numerical value Overscript[s, ^].\nLaplaceTransform[f[t1, …, tn], {t1, …, tn}, {s1, …, sn}] gives the multidimensional Laplace transform of f[t1, …, tn]." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaplaceTransform)))
(def Laplacian "Laplacian[f, {x1, …, xn}] gives the Laplacian ∂^2f/∂x1^2+…+∂^2f/∂xn^2.\nLaplacian[f, {x1, …, xn}, chart] gives the Laplacian in the given coordinates chart." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Laplacian)))
(def LaplacianFilter "LaplacianFilter[data, r] convolves data with a radius-r Laplacian kernel.\nLaplacianFilter[data, {r1, r2, …}] uses radius ri at level i in data." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaplacianFilter)))
(def LaplacianGaussianFilter "LaplacianGaussianFilter[data, r] convolves data with a Laplacian of Gaussian kernel of pixel radius r.\nLaplacianGaussianFilter[data, {r, σ}]  convolves data with a Laplacian of Gaussian kernel of radius r and standard deviation σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaplacianGaussianFilter)))
(def LaplacianPDETerm "LaplacianPDETerm[vars] represents a Laplacian term ∇^2{x1, …, xn}u with model variables vars.\nLaplacianPDETerm[vars, pars] uses model parameters pars." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaplacianPDETerm)))
(def Large "Large is a style or option setting that specifies that objects should be large." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Large)))
(def Larger "Larger is a style or option setting that specifies that objects should be larger." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Larger)))
(def Last "Last[expr] gives the last element in expr. \nLast[expr, def] gives the last element if there are any elements, or def otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Last)))
(def Latitude "Latitude[pos] gives the latitude in degrees of a geographic position specified by pos.\nLatitude[pos, datum] gives the latitude referring to the specified geodetic datum." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Latitude)))
(def LatitudeLongitude "LatitudeLongitude[pos] gives a list of the latitude and longitude in degrees of a geographic position specified by pos.\nLatitudeLongitude[pos, datum] gives the latitude and longitude referring to the specified geodetic datum." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LatitudeLongitude)))
(def LatticeData "LatticeData[lattice, \"property\"] gives the specified property for a lattice.\nLatticeData[n] gives a list of named lattices of dimension n." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LatticeData)))
(def LatticeReduce "LatticeReduce[{v1, v2, …}] gives a reduced basis for the set of vectors vi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LatticeReduce)))
(def LaunchKernels "LaunchKernels[] launches all currently configured parallel subkernels.\nLaunchKernels[n] launches n local subkernels on the current computer.\nLaunchKernels[ker] launches the kernel specified by ker.\nLaunchKernels[{ker1, ker2, …}] launches the kernels keri." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LaunchKernels)))
(def LayerSizeFunction "LayerSizeFunction is an option for TreePlot that gives a function to specify the relative height to allow for each layer." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LayerSizeFunction)))
(def LayeredGraph "LayeredGraph[g] creates a graph with vertices and edges from the graph g represented as a layered plot.\nLayeredGraph[{e1, e2, …}] creates a graph with edges ej represented as a layered plot.\nLayeredGraph[{…, w[ei], …}] creates a graph with edges ei with features defined by the symbolic wrapper w.\nLayeredGraph[…, vpos] places the dominant vertex v in the plot at position pos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LayeredGraph)))
(def LayeredGraph3D "LayeredGraph3D[g] creates a graph with vertices and edges from the graph g represented as a 3D layered plot.\nLayeredGraph3D[{e1, e2, …}] creates a graph with edges ej represented as a 3D layered plot.\nLayeredGraph3D[{…, w[ei], …}] creates a graph with edges ei with features defined by the symbolic wrapper w.\nLayeredGraph3D[…, vpos] places the dominant vertex v in the plot at position pos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LayeredGraph3D)))
(def LayeredGraphPlot "LayeredGraphPlot[g] generates a layered plot of the graph g.\nLayeredGraphPlot[{e1, e2, …}] generates a layered plot of the graph with edges ej.\nLayeredGraphPlot[{…, w[ei], …}] plots ei with features defined by the symbolic wrapper w.\nLayeredGraphPlot[{v i1v j1, …}] uses rules vikvjk to specify the graph g.\nLayeredGraphPlot[m] uses the adjacency matrix m to specify the graph g.\nLayeredGraphPlot[…, vpos] places the dominant vertex v in the plot at position pos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LayeredGraphPlot)))
(def LayeredGraphPlot3D "LayeredGraphPlot3D[g] generates a 3D layered plot of the graph g.\nLayeredGraphPlot3D[{e1, e2, …}] generates a 3D layered plot of the graph with edges ei.\nLayeredGraphPlot3D[{…, w[ei], …}] plots ei with features defined by the symbolic wrapper w.\nLayeredGraphPlot3D[{v i1v j1, …}] uses rules vikvjk to specify the graph g.\nLayeredGraphPlot3D[m] uses the adjacency matrix m to specify the graph g.\nLayeredGraphPlot3D[…, vpos] places the dominant vertex v in the plot at position pos." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LayeredGraphPlot3D)))
(def LeaderSize "LeaderSize is an option for Callout that specifies what sizes to use for leader lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeaderSize)))
(def LeafCount "LeafCount[expr] gives the total number of indivisible subexpressions in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeafCount)))
(def LeapVariant "LeapVariant[n] represents a repeated calendar element caused by a leap period." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeapVariant)))
(def LeapYearQ "LeapYearQ[date] returns True if the year corresponding to date is a leap year." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeapYearQ)))
(def LearnDistribution "LearnDistribution[{example1, example2, …}] generates a LearnedDistribution[…] that attempts to represent an underlying distribution for the examples given." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LearnDistribution)))
(def LearnedDistribution "LearnedDistribution[…] represents a distribution generated by LearnDistribution." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LearnedDistribution)))
(def LearningRate "LearningRate is an option for NetTrain that specifies the rate at which to adjust neural net weights in order to minimize the training loss." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LearningRate)))
(def LearningRateMultipliers "LearningRateMultipliers is an option for net layers and for NetTrain, NetChain, NetGraph that specifies learning rate multipliers to apply during training." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LearningRateMultipliers)))
(def LeastSquares "LeastSquares[m, b] finds an x that solves the linear least-squares problem for the matrix equation m.x==b.\nLeastSquares[a, b] finds an x that solves the linear least-squares problem for the array equation a.x==b." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeastSquares)))
(def LeastSquaresFilterKernel "LeastSquaresFilterKernel[{{ω1, …, ω k-1}, {a1, …, ak}}, n] creates a k-band finite impulse response (FIR) filter kernel of length n designed using a least squares method, given the specified frequencies ωi and amplitudes ai.\nLeastSquaresFilterKernel[{\"type\", spec}, n] uses the full filter specification {\"type\", spec}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeastSquaresFilterKernel)))
(def Left "Left is a symbol that represents the left-hand side for purposes of alignment and positioning." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Left)))
(def LeftArrow "LeftArrow[x, y, …] displays as x←y←…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftArrow)))
(def LeftArrowBar "LeftArrowBar[x, y, …] displays as x⇤y⇤…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftArrowBar)))
(def LeftArrowRightArrow "LeftArrowRightArrow[x, y, …] displays as x⇆y⇆…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftArrowRightArrow)))
(def LeftDownTeeVector "LeftDownTeeVector[x, y, …] displays as x⥡y⥡…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftDownTeeVector)))
(def LeftDownVector "LeftDownVector[x, y, …] displays as x⇃y⇃…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftDownVector)))
(def LeftDownVectorBar "LeftDownVectorBar[x, y, …] displays as x⥙y⥙…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftDownVectorBar)))
(def LeftRightArrow "LeftRightArrow[x, y, …] displays as x↔y↔…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftRightArrow)))
(def LeftRightVector "LeftRightVector[x, y, …] displays as x⥎y⥎…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftRightVector)))
(def LeftTee "LeftTee[x, y] displays as x⊣y." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTee)))
(def LeftTeeArrow "LeftTeeArrow[x, y, …] displays as x↤y↤…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTeeArrow)))
(def LeftTeeVector "LeftTeeVector[x, y, …] displays as x⥚y⥚…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTeeVector)))
(def LeftTriangle "LeftTriangle[x, y, …] displays as x⊲y⊲…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTriangle)))
(def LeftTriangleBar "LeftTriangleBar[x, y, …] displays as x⧏y⧏…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTriangleBar)))
(def LeftTriangleEqual "LeftTriangleEqual[x, y, …] displays as x⊴y⊴…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftTriangleEqual)))
(def LeftUpDownVector "LeftUpDownVector[x, y, …] displays as x⥑y⥑…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftUpDownVector)))
(def LeftUpTeeVector "LeftUpTeeVector[x, y, …] displays as x⥠y⥠…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftUpTeeVector)))
(def LeftUpVector "LeftUpVector[x, y, …] displays as x↿y↿…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftUpVector)))
(def LeftUpVectorBar "LeftUpVectorBar[x, y, …] displays as x⥘y⥘…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftUpVectorBar)))
(def LeftVector "LeftVector[x, y, …] displays as x↼y↼…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftVector)))
(def LeftVectorBar "LeftVectorBar[x, y, …] displays as x⥒y⥒…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeftVectorBar)))
(def LegendAppearance "LegendAppearance is an option for charting functions that specifies the appearance of any legends that are generated." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendAppearance)))
(def LegendFunction "LegendFunction is an option for legends that specifies an overall function to apply to the generated legend." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendFunction)))
(def LegendLabel "LegendLabel is an option for legends that specifies an overall label for a legend." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendLabel)))
(def LegendLayout "LegendLayout is an option for legends that specifies how to format the legend content." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendLayout)))
(def LegendMargins "LegendMargins is an option for legends that specifies the margins to leave around the legend." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendMargins)))
(def LegendMarkerSize "LegendMarkerSize is an option for legends such as PointLegend that specifies the size of marker regions for each element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendMarkerSize)))
(def LegendMarkers "LegendMarkers is an option for legends such as PointLegend that specifies markers for each element." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendMarkers)))
(def Legended "Legended[expr, leg] displays expr with legend leg. \nLegended[expr, lbl] indicates in plotting and charting functions that a legend entry for expr should be created, with label lbl." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Legended)))
(def LegendreP "LegendreP[n, x] gives the Legendre polynomial Pn (x). \nLegendreP[n, m, x] gives the associated Legendre polynomial P_n^m(x)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendreP)))
(def LegendreQ "LegendreQ[n, z] gives the Legendre function of the second kind Qn (z). \nLegendreQ[n, m, z] gives the associated Legendre function of the second kind Q_n^m(z)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LegendreQ)))
(def Length "Length[expr] gives the number of elements in expr." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Length)))
(def LengthWhile "LengthWhile[list, crit] gives the number of contiguous elements ei starting at the beginning of list for which crit[ei] is True." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LengthWhile)))
(def LerchPhi "LerchPhi[z, s, a] gives the Lerch transcendent Φ (z, s, a)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LerchPhi)))
(def Less "x<y yields True if x is determined to be less than y. \nx1<x2<x3 yields True if the xi form a strictly increasing sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Less)))
(def LessEqual "x<=y or x≤y yields True if x is determined to be less than or equal to y.\nx1≤x2≤x3 yields True if the xi form a nondecreasing sequence." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessEqual)))
(def LessEqualGreater "LessEqualGreater[x, y, …] displays as x⋚y⋚…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessEqualGreater)))
(def LessEqualThan "LessEqualThan[y] is an operator form that yields x≤y when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessEqualThan)))
(def LessFullEqual "LessFullEqual[x, y, …] displays as x≦y≦…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessFullEqual)))
(def LessGreater "LessGreater[x, y, …] displays as x≶y≶…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessGreater)))
(def LessLess "LessLess[x, y, …] displays as x≪y≪…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessLess)))
(def LessSlantEqual "LessSlantEqual[x, y, …] displays as x⩽y⩽…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessSlantEqual)))
(def LessThan "LessThan[y] is an operator form that yields x<y when applied to an expression x." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessThan)))
(def LessTilde "LessTilde[x, y, …] displays as x≲y≲…." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LessTilde)))
(def LetterCharacter "LetterCharacter represents a letter character in StringExpression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LetterCharacter)))
(def LetterCounts "LetterCounts[\"string\"] gives an association whose keys are the distinct letters in string, and whose values give the number of times those letters appear in string.\nLetterCounts[\"string\", n] gives counts of the distinct n-grams consisting of runs of n letters in string.\nLetterCounts[\"string\", n, {c1, c2, …}] allows the characters ci to appear in n-grams, in addition to ordinary letters.\nLetterCounts[{string1, string2, …}, …] gives the counts for each of the stringi." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LetterCounts)))
(def LetterNumber "LetterNumber[\"c\"] gives the position of the character c in the English alphabet.\nLetterNumber[\"c\", alpha] gives the position of c in the alphabet specified by alpha.\nLetterNumber[\"string\", …] gives a list of the positions of characters in string." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LetterNumber)))
(def LetterQ "LetterQ[string] yields True if all the characters in the string are letters, and yields False otherwise." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LetterQ)))
(def Level "Level[expr, levelspec] gives a list of all subexpressions of expr on levels specified by levelspec. \nLevel[expr, levelspec, f] applies f to the sequence of subexpressions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Level)))
(def LeveneTest "LeveneTest[data] tests whether the variance of data is 1. \nLeveneTest[{data1, data2, …}] tests whether the variances of data1, data2, … are equal.\nLeveneTest[dspec, σ_0^2] tests a dispersion measure against σ_0^2.\nLeveneTest[dspec, σ_0^2, \"property\"] returns the value of \"property\"." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeveneTest)))
(def LeviCivitaTensor "LeviCivitaTensor[d] gives the d-dimensional Levi-Civita totally antisymmetric tensor." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LeviCivitaTensor)))
(def LevyDistribution "LevyDistribution[μ, σ] represents a Lévy distribution with location parameter μ and dispersion parameter σ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LevyDistribution)))
(def LexicographicOrder "LexicographicOrder[{a1, a2, …}, {b1, b2, …}] gives Order[ai, bi] for the first non-coinciding pair ai, bi of elements, and 0 if the lists are identical.\nLexicographicOrder[{a1, a2, …}, {b1, b2, …}, p] uses the ordering function p to compare ai with bi.\nLexicographicOrder[p] represents an operator form that compares lists when applied to {a1, a2, …}, {b1, b2, …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LexicographicOrder)))
(def LexicographicSort "LexicographicSort[{e1, e2, …}] sorts the list of expressions ei in lexicographic order.\nLexicographicSort[{e1, e2, …}, p] compares elements of the ei expressions using the ordering function p." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LexicographicSort)))
(def LibraryDataType "LibraryDataType[datatype] specifies the data type for a LibraryFunction argument or result to be datatype.\nLibraryDataType[datatype, etype] specifies an element type etype for data structures.\nLibraryDataType[datatype, etype, d] specifies an array depth d for array data types." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryDataType)))
(def LibraryFunction "LibraryFunction[args] represents a function that has been loaded from a Wolfram Library." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunction)))
(def LibraryFunctionDeclaration "LibraryFunctionDeclaration[\"extName\", lib, type] represents a function declaration that exposes the library function extName with the type type from the library lib, for use in compiled code.\nLibraryFunctionDeclaration[name->\"extName\", lib, type] aliases the function with name in compiled code.\nLibraryFunctionDeclaration[nameSpec, type] assumes that the library will be loaded by the time the function is compiled." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunctionDeclaration)))
(def LibraryFunctionError "LibraryFunctionError[name, code] represents an error returned from a LibraryFunction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunctionError)))
(def LibraryFunctionInformation "LibraryFunctionInformation[fun] returns information about a LibraryFunction." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunctionInformation)))
(def LibraryFunctionLoad "LibraryFunctionLoad[lib, fun, argtype, rettype] loads Wolfram Library lib and makes the library function fun available in the Wolfram Language." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunctionLoad)))
(def LibraryFunctionUnload "LibraryFunctionUnload[fun] unloads a LibraryFunction so that it cannot be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryFunctionUnload)))
(def LibraryLoad "LibraryLoad[lib] loads the dynamic library lib into the Wolfram System runtime." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryLoad)))
(def LibraryUnload "LibraryUnload[lib] unloads all functions that have been loaded from a Wolfram Library, then it unloads the library." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LibraryUnload)))
(def LicenseEntitlementObject "LicenseEntitlementObject[…] represents an on-demand license entitlement.\nLicenseEntitlementObject[id] gives the entitlement object representing the entitlement specified by id." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LicenseEntitlementObject)))
(def LicenseEntitlements "LicenseEntitlements[] gives a list of on-demand license entitlements owned by you." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LicenseEntitlements)))
(def LicensingSettings "LicensingSettings is an option for RemoteBatchSubmit and related functions to configure licensing for remote kernels." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LicensingSettings)))
(def LiftingFilterData "LiftingFilterData[…] represents lifting-filter data used to compute forward and inverse lifting wavelet transforms." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LiftingFilterData)))
(def LiftingWaveletTransform "LiftingWaveletTransform[data] gives the lifting wavelet transform (LWT) of an array of data.\nLiftingWaveletTransform[data, wave] gives the lifting wavelet transform using the wavelet wave.\nLiftingWaveletTransform[data, wave, r] gives the lifting wavelet transform using r levels of refinement." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LiftingWaveletTransform)))
(def LightBlue "LightBlue represents a light blue color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightBlue)))
(def LightBrown "LightBrown represents a light brown color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightBrown)))
(def LightCyan "LightCyan represents a light cyan color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightCyan)))
(def LightGray "LightGray represents a light gray color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightGray)))
(def LightGreen "LightGreen represents a light green color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightGreen)))
(def LightMagenta "LightMagenta represents a light magenta color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightMagenta)))
(def LightOrange "LightOrange represents a light orange color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightOrange)))
(def LightPink "LightPink represents a light pink color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightPink)))
(def LightPurple "LightPurple represents a light purple color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightPurple)))
(def LightRed "LightRed represents a light red color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightRed)))
(def LightYellow "LightYellow represents a light yellow color in graphics or style specifications." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightYellow)))
(def Lighter "Lighter[color] represents a lighter version of the specified color. \nLighter[color, f] represents a version of the specified color lightened by a fraction f. \nLighter[image, …] gives a lighter version of an image.\nLighter[video, …] gives a version of a video with lighter frames." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Lighter)))
(def Lighting "Lighting is an option for Graphics3D and related functions that specifies what simulated lighting to use in coloring 3D surfaces." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Lighting)))
(def LightingAngle "LightingAngle is an option for ReliefPlot and related functions that specifies the angle from which simulated illumination is taken to come." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LightingAngle)))
(def Likelihood "Likelihood[dist, {x1, x2, …}] gives the likelihood function for observations x1, x2, … from the distribution dist.\nLikelihood[proc, {{t1, x1}, {t2, x2}, …}] gives the likelihood function for the observations xi at time ti from the process proc.\nLikelihood[proc, {path1, path2, …}] gives the likelihood function for observations from path1, path2, … from the process proc." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Likelihood)))
(def Limit "Limit[f, xx^*] gives the limit xx^*f(x). \nLimit[f, {x1x_1^*, …, xnx_n^*}] gives the nested limit _x1x_1^*⋯ _xnx_n^*f(x1, …, xn). \nLimit[f, {x1, …, xn}{x_1^*, …, x_n^*}] gives the multivariate limit _{x1, …, xn}{x_1^*, …, x_n^*}f(x1, …, xn)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Limit)))
(def LimitsPositioning "LimitsPositioning is an option for UnderoverscriptBox and related boxes that specifies whether to change the positioning of underscripts and overscripts in the way conventional for limits." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LimitsPositioning)))
(def LindleyDistribution "LindleyDistribution[δ] represents a Lindley distribution with shape parameter δ." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LindleyDistribution)))
(def Line "Line[{p1, p2, …}] represents the line segments joining a sequence for points pi.\nLine[{{p11, p12, …}, {p21, …}, …}] represents a collection of lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote Line)))
(def LineBreakChart "LineBreakChart[{{date1, p1}, {date2, p2}, …}] makes a line break chart with prices pi at date datei.\nLineBreakChart[{\"name\", daterange}] makes a line break chart of closing prices for the financial entity \"name\" over the date range daterange.\nLineBreakChart[{…}, n] makes a line break chart where n bars in a row cause a reversal." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineBreakChart)))
(def LineGraph "LineGraph[g] gives the line graph of the graph g.\nLineGraph[{vw, …}] uses rules vw to specify the graph g." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineGraph)))
(def LineIndent "LineIndent is an option for Style and Cell that specifies how many ems of indentation to add at the beginnings of lines for each level of nesting in an expression." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineIndent)))
(def LineIndentMaxFraction "LineIndentMaxFraction is an option for Cell, StyleBox, and Style that specifies the maximum fraction of the total page width to indent at the beginnings of lines." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineIndentMaxFraction)))
(def LineIntegralConvolutionPlot "LineIntegralConvolutionPlot[{{vx, vy}, image}, {x, xmin, xmax}, {y, ymin, ymax}] generates a line integral convolution plot of image convolved with the vector field {vx, vy} as a function of x and y.\nLineIntegralConvolutionPlot[{vx, vy}, {x, xmin, xmax}, {y, ymin, ymax}] generates a line integral convolution plot of white noise with the vector field {vx, vy}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineIntegralConvolutionPlot)))
(def LineIntegralConvolutionScale "LineIntegralConvolutionScale is an option to LineIntegralConvolutionPlot and related functions that determines the scale of the line integral convolution to be used." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineIntegralConvolutionScale)))
(def LineIntegrate "LineIntegrate[f, {x, y, …}∈curve] computes the scalar line integral of the function f[x, y, …] over the curve.\nLineIntegrate[{p, q, …}, {x, y, …}∈curve] computes the vector line integral of the vector function {p[x, y, …], q[x, y, …], …}." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineIntegrate)))
(def LineLegend "LineLegend[{col1, …}, {lbl1, …}] generates a legend that associates color coli with label lbli.\nLineLegend[{col1, …}, Automatic] generates a legend with placeholder labels for the colors coli.\nLineLegend[{lbl1, …}] represents a legend with inherited colors within visualization functions." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineLegend)))
(def LineSpacing "LineSpacing is an option for Style and Cell that specifies the spacing between successive lines of text." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LineSpacing)))
(def LinearFractionalOptimization "LinearFractionalOptimization[f, cons, vars] finds values of variables vars that minimize the linear fractional objective f subject to linear constraints cons.\nLinearFractionalOptimization[{α, β, γ, δ}, {a, b}] finds a vector x that minimizes the linear fractional function (α.x+β)/(γ.x+δ) subject to the linear inequality constraints a.x+b⪰0. \nLinearFractionalOptimization[{α, β, γ, δ}, {a, b}, {aeq, beq}] includes the linear equality constraints aeq.x+beq0.\nLinearFractionalOptimization[{α, β, γ, δ}, …, {dom1, dom2, …}] takes xi to be in the domain domi, where domi is Integers or Reals. \nLinearFractionalOptimization[…, \"prop\"] specifies what solution property \"prop\" should be returned." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LinearFractionalOptimization)))
(def LinearFractionalTransform "LinearFractionalTransform[m] gives a TransformationFunction that represents a linear fractional transformation defined by the homogeneous matrix m. \nLinearFractionalTransform[{a, b, c, d}] represents a linear fractional transformation that maps r to (a.r+b)/(c.r+d)." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LinearFractionalTransform)))
(def LinearGradientFilling "LinearGradientFilling[{col1, col2, …, coln}] is a two-dimensional graphics directive specifying that faces of polygons and other filled graphics objects are to be drawn using a progressive transition between colors coli along a straight horizontal line.\nLinearGradientFilling[{pos1, pos2, …, posn}{col1, col2, …, coln}] uses the colors coli at the scaled positions posi.\nLinearGradientFilling[{pos1, pos2, …, posn}{col1, col2, …, coln}, dir] draws along the straight line with a direction dir.\nLinearGradientFilling[{pos1, …, posn}{col1, …, coln}, dir, padding] uses the specified padding when drawing beyond the boundary positions pos1 and posn." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LinearGradientFilling)))
(def LinearGradientImage "LinearGradientImage[gcol] returns an image with values linearly changing from left to right based on gradient color gcol.\nLinearGradientImage[{pos1, pos2}gcol] returns an image where the gradient starts at pos1 and ends at pos2.\nLinearGradientImage[…, size] returns a linear gradient image of the specified size.\nLinearGradientImage[…, size, \"type\"] gives an image converted to the specified type." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LinearGradientImage)))
(def LinearLayer "LinearLayer[n] represents a trainable, fully connected net layer that computes w.x+b with output vector of size n. \nLinearLayer[{n1, n2, …}] represents a layer that outputs an array of dimensions n1×n2×….\nLinearLayer[] leaves the dimensions of the output array to be inferred from context.\nLinearLayer[n, opts] includes options for initial weights and other parameters." (wolframite.impl.wolfram-syms.intern/wolfram-fn (quote LinearLa