(ns scicloj.viz.gg.prop
  (:require [scicloj.viz.gg.utils-props :as utils-props]
            [scicloj.viz.gg.scale :as scale]))

(defn decide-scale [scale property]
  (case scale
    true (-> property
             utils-props/trim-prop-event
             scale/propname->scale)
    false nil
    scale))

(defprotocol Proppable
  (new-prop [x]))

(defn new-prop [x property scale offset mult]
  (if (-> x :class (= :prop))
    x
    {:property property
     :value    x
     :scale    (-> scale
                   (or false)
                   (decide-scale property))
     :offset   offset
     :mult     mult}))

(defn ->prop [x property {:keys [scale offset mult]}]
  (new-prop x property scale offset mult))
