
(ns scicloj.viz.ggvis
  (:require
   [tech.v3.dataset :as tmd]))




(defn ggvis [data props]
  (-> {:marks     {}
       :scales    {}
       :axes      {}
       :legends   {}
       :options   {}
       :data      {}
       :cur-data  nil
       :props     []
       :cur-props nil}
      (add-data data)
      (add-props props)))

(defn add-props [vis props]
  (-> vis
      (update :props conj props)
      (assoc :cur-props props)))

(defn add-data [vis data
                {:keys [name]
                 :or {name (tmd/dataset-name
                            data)}}]
  (-> vis
      (update :data assoc name data)
      (assoc :cur-data data)))






