(ns viz.viz
  (:require [aerial.hanami.common :as hc]
            [aerial.hanami.templates :as ht]
            [aerial.hanami.core :as hmi]
            [clojure.java.io :as io]
            [cheshire.core]
            [tablecloth.api :as tablecloth]
            [notespace.api :as notespace]
            [notespace.kinds :as kind]
            [viz.api :as api]
            [tech.v3.dataset :as tmd]
            [clojure.string :as string]))

^kind/vega
(hc/xform ht/point-chart
          :UDATA "data/cars.json"
          :X "Horsepower" :Y "Miles_per_Gallon" :COLOR "Origin")


^kind/vega
(-> (api/data "data/cars.json")
    (api/type "point")
    (api/x "Horsepower")
    (api/y "Miles_per_Gallon")
    (api/color "Origin")
    (api/viz))


(def mpg-data (tmd/->dataset "resources/data/mpg.csv"))

^kind/vega
(-> (api/data mpg-data)
    (api/type "point")
    (api/x "displ")
    (api/y "hwy")
    (api/viz))

^kind/vega
(-> (api/data "data/cars.json")
    (api/type "boxplot")
    (api/x "Horsepower")
    (api/y "Origin" {:type "nominal"})
    (api/color "Origin")
    (api/viz))

(def diamond-data (tmd/->dataset "resources/data/diamonds.csv"))

^kind/vega
(-> (api/data (tablecloth/head diamond-data))
    (api/type "bar")
    (api/x "cut" {:bin true})
    (api/y nil {:aggregate "count"}))

(defonce so-survey-data (tmd/->dataset "resources/data/survey_results_public.csv" {:key-fn keyword}))

(defonce processed-stackoverflow-survey-dataset
         (-> so-survey-data
             (tablecloth/add-columns
               {:experience (fn [ds]
                              (->> ds
                                   :YearsCodePro
                                   (map (fn [y]
                                          (case y
                                            nil                  nil
                                            "Less than 1 year"   0.5
                                            "More than 50 years" 51
                                            (Integer/valueOf y))))))
                :salary     (fn [ds]
                              (->> ds
                                   :ConvertedComp))
                :languages (fn [ds]
                             (->> ds
                                  :LanguageWorkedWith
                                  (map (fn [s]
                                         (or (some-> s
                                                     (string/split #";")
                                                     set)
                                             #{})))))
                :dev-types  (fn [ds]
                              (->> ds
                                   :DevType
                                   (map (fn [s]
                                          (or (some-> s
                                                      (string/split #";")
                                                      set)
                                              #{})))))})
             (tablecloth/add-columns
               {:clojure? (fn [ds]
                            (->> ds
                                 :languages
                                 (map (fn [languanges-set]
                                        (some? (languanges-set "Clojure"))))))
                :r?       (fn [ds]
                            (->> ds
                                 :languages
                                 (map (fn [languanges-set]
                                        (some? (languanges-set "R"))))))
                :data-science? (fn [ds]
                                 (->> ds
                                      :dev-types
                                      (map (fn [dev-types-set]
                                             (some? (dev-types-set "Data scientist or machine learning specialist"))))))})
             (tablecloth/select-columns
               [:salary :experience :clojure? :r? :data-science? :languages :dev-types])))

^kind/dataset
(-> "public/data/cars.json"
    io/resource
    slurp
    (cheshire.core/parse-string keyword)
    (tablecloth/dataset))

^kind/dataset
(tablecloth/dataset "resources/data/mpg.csv")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :COLOR "class")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :SIZE "class")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :OPACITY "class")


(def point-chart
  (assoc ht/view-base
    :mark (merge ht/mark-base {:type "point"})))

^kind/vega
(hc/xform point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :SHAPE "class")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :MCOLOR "blue")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :HEIGHT 200, :WIDTH 150
          :COLUMN "class")

^kind/vega
(hc/xform ht/point-chart
          :FDATA "resources/data/mpg.csv"
          :X "displ" :Y "hwy"
          :HEIGHT 200, :WIDTH 150
          :COLUMN "cyl"
          :ROW "drv")

^kind/vega
(hc/xform ht/bar-chart
          :FDATA "resources/data/diamonds.csv"
          :X "cut")

