(ns viz.api
  (:require [aerial.hanami.common :as hc]
            [aerial.hanami.templates :as ht]
            [viz.templates :as vt]
            [tech.v3.dataset :as tmd])
  (:refer-clojure :exclude [type]))

(def map-of-templates {"point" ht/point-chart
                       "bar" ht/bar-chart
                       "boxplot" vt/boxplot-chart})

(defn viz
  [{:keys [type] :as options}]
  (apply hc/xform (map-of-templates type) (apply concat (dissoc options :type :aggregate))))

(defn data
  "Pass the data as either url/file path (string) or dataset"
  [data]
  (cond (string? data)
        {:UDATA data}
        (instance? tech.v3.dataset.impl.dataset.Dataset data)
        {:DATA (tmd/mapseq-reader data)}
        :else {:DATA data}))

(defn type
  [viz-map, type]
  (assoc viz-map :type type))

(defn- set-coordinates
  ([viz-map, field-name, {:keys [type aggregate] :as options}, field-key]
   (merge viz-map
          {field-key field-name}
          (when type {(keyword (str (name field-key) "TYPE")) type})
          (when aggregate {(keyword (str (name field-key) "AGG")) aggregate})
          (dissoc options :type))))

(defn x
  ([viz-map, field-name]
   (x viz-map field-name {}))
  ([viz-map, field-name, options]
   (set-coordinates viz-map field-name options :X)))

(defn y
  ([viz-map, field-name]
  (y viz-map field-name {}))
  ([viz-map, field-name, options]
   (set-coordinates viz-map field-name options :Y)))

(defn color
  [viz-map, color]
  (assoc viz-map :COLOR color))
