(ns scicloj.metamorph.ml.rdatasets
  (:require [tablecloth.api :as tc] [clojure.string :as str] [camel-snake-kebab.core :as csk])
  (:import [com.vladsch.flexmark.html2md.converter FlexmarkHtmlConverter]))


;;    Based on
;;    @Manual{,
;;    title = {Rdatasets: A collection of datasets originally distributed in various R packages},
;;    author = {Vincent Arel-Bundock},
;;    year = {2024},
;;    note = {R package version 1.0.0},
;;    url = {https://vincentarelbundock.github.io/Rdatasets},
;;   }
    
(defn clean-R-relevant [s]
  (-> (str/replace s #"\n\n### Examples(?s).*```" "")
   (str/replace ":::: container\n::: container\n" "")
   (str/replace #"### Usage(?s).*```" "")
   (str/replace "R Documentation" "Documentation")
   (str/replace #"\|(\-*)\|(\-*)\|" "")))
(defn doc-url->md [doc]
  (clean-R-relevant (.. (FlexmarkHtmlConverter/builder) build (convert (slurp doc)))))
(defn _fetch-dataset [csv]
  (-> csv (tc/dataset {:key-fn (fn [s] (-> s (str/replace #"\." "-") csk/->kebab-case-keyword))})))

(def fetch-dataset (memoize _fetch-dataset))

(defn AER-Affairs
  "Fetch the dataset 'AER-Affairs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Affairs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Affairs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Affairs.csv"))

(defn AER-ArgentinaCPI
  "Fetch the dataset 'AER-ArgentinaCPI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ArgentinaCPI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ArgentinaCPI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ArgentinaCPI.csv"))

(defn AER-BankWages
  "Fetch the dataset 'AER-BankWages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/BankWages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/BankWages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/BankWages.csv"))

(defn AER-BenderlyZwick
  "Fetch the dataset 'AER-BenderlyZwick' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/BenderlyZwick.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/BenderlyZwick.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/BenderlyZwick.csv"))

(defn AER-BondYield
  "Fetch the dataset 'AER-BondYield' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/BondYield.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/BondYield.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/BondYield.csv"))

(defn AER-CartelStability
  "Fetch the dataset 'AER-CartelStability' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CartelStability.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CartelStability.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CartelStability.csv"))

(defn AER-CASchools
  "Fetch the dataset 'AER-CASchools' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CASchools.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CASchools.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CASchools.csv"))

(defn AER-ChinaIncome
  "Fetch the dataset 'AER-ChinaIncome' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ChinaIncome.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ChinaIncome.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ChinaIncome.csv"))

(defn AER-CigarettesB
  "Fetch the dataset 'AER-CigarettesB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CigarettesB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CigarettesB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CigarettesB.csv"))

(defn AER-CigarettesSW
  "Fetch the dataset 'AER-CigarettesSW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CigarettesSW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CigarettesSW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CigarettesSW.csv"))

(defn AER-CollegeDistance
  "Fetch the dataset 'AER-CollegeDistance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CollegeDistance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CollegeDistance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CollegeDistance.csv"))

(defn AER-ConsumerGood
  "Fetch the dataset 'AER-ConsumerGood' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ConsumerGood.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ConsumerGood.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ConsumerGood.csv"))

(defn AER-CPS1985
  "Fetch the dataset 'AER-CPS1985' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPS1985.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPS1985.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPS1985.csv"))

(defn AER-CPS1988
  "Fetch the dataset 'AER-CPS1988' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPS1988.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPS1988.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPS1988.csv"))

(defn AER-CPSSW04
  "Fetch the dataset 'AER-CPSSW04' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW04.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW04.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSW04.csv"))

(defn AER-CPSSW3
  "Fetch the dataset 'AER-CPSSW3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSW3.csv"))

(defn AER-CPSSW8
  "Fetch the dataset 'AER-CPSSW8' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW8.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW8.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSW8.csv"))

(defn AER-CPSSW9204
  "Fetch the dataset 'AER-CPSSW9204' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW9204.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW9204.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSW9204.csv"))

(defn AER-CPSSW9298
  "Fetch the dataset 'AER-CPSSW9298' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW9298.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSW9298.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSW9298.csv"))

(defn AER-CPSSWEducation
  "Fetch the dataset 'AER-CPSSWEducation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSWEducation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CPSSWEducation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CPSSWEducation.csv"))

(defn AER-CreditCard
  "Fetch the dataset 'AER-CreditCard' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/CreditCard.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/CreditCard.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/CreditCard.csv"))

(defn AER-DJFranses
  "Fetch the dataset 'AER-DJFranses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/DJFranses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/DJFranses.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/DJFranses.csv"))

(defn AER-DJIA8012
  "Fetch the dataset 'AER-DJIA8012' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/DJIA8012.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/DJIA8012.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/DJIA8012.csv"))

(defn AER-DoctorVisits
  "Fetch the dataset 'AER-DoctorVisits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/DoctorVisits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/DoctorVisits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/DoctorVisits.csv"))

(defn AER-DutchAdvert
  "Fetch the dataset 'AER-DutchAdvert' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/DutchAdvert.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/DutchAdvert.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/DutchAdvert.csv"))

(defn AER-DutchSales
  "Fetch the dataset 'AER-DutchSales' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/DutchSales.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/DutchSales.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/DutchSales.csv"))

(defn AER-Electricity1955
  "Fetch the dataset 'AER-Electricity1955' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Electricity1955.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Electricity1955.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Electricity1955.csv"))

(defn AER-Electricity1970
  "Fetch the dataset 'AER-Electricity1970' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Electricity1970.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Electricity1970.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Electricity1970.csv"))

(defn AER-EquationCitations
  "Fetch the dataset 'AER-EquationCitations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/EquationCitations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/EquationCitations.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/EquationCitations.csv"))

(defn AER-Equipment
  "Fetch the dataset 'AER-Equipment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Equipment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Equipment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Equipment.csv"))

(defn AER-EuroEnergy
  "Fetch the dataset 'AER-EuroEnergy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/EuroEnergy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/EuroEnergy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/EuroEnergy.csv"))

(defn AER-Fatalities
  "Fetch the dataset 'AER-Fatalities' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fatalities.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fatalities.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Fatalities.csv"))

(defn AER-Fertility
  "Fetch the dataset 'AER-Fertility' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fertility.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fertility.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Fertility.csv"))

(defn AER-Fertility2
  "Fetch the dataset 'AER-Fertility2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fertility2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Fertility2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Fertility2.csv"))

(defn AER-FrozenJuice
  "Fetch the dataset 'AER-FrozenJuice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/FrozenJuice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/FrozenJuice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/FrozenJuice.csv"))

(defn AER-GermanUnemployment
  "Fetch the dataset 'AER-GermanUnemployment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GermanUnemployment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GermanUnemployment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GermanUnemployment.csv"))

(defn AER-GoldSilver
  "Fetch the dataset 'AER-GoldSilver' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GoldSilver.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GoldSilver.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GoldSilver.csv"))

(defn AER-GrowthDJ
  "Fetch the dataset 'AER-GrowthDJ' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GrowthDJ.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GrowthDJ.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GrowthDJ.csv"))

(defn AER-GrowthSW
  "Fetch the dataset 'AER-GrowthSW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GrowthSW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GrowthSW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GrowthSW.csv"))

(defn AER-Grunfeld
  "Fetch the dataset 'AER-Grunfeld' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Grunfeld.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Grunfeld.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Grunfeld.csv"))

(defn AER-GSOEP9402
  "Fetch the dataset 'AER-GSOEP9402' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GSOEP9402.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GSOEP9402.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GSOEP9402.csv"))

(defn AER-GSS7402
  "Fetch the dataset 'AER-GSS7402' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/GSS7402.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/GSS7402.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/GSS7402.csv"))

(defn AER-Guns
  "Fetch the dataset 'AER-Guns' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Guns.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Guns.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Guns.csv"))

(defn AER-HealthInsurance
  "Fetch the dataset 'AER-HealthInsurance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/HealthInsurance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/HealthInsurance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/HealthInsurance.csv"))

(defn AER-HMDA
  "Fetch the dataset 'AER-HMDA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/HMDA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/HMDA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/HMDA.csv"))

(defn AER-HousePrices
  "Fetch the dataset 'AER-HousePrices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/HousePrices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/HousePrices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/HousePrices.csv"))

(defn AER-Journals
  "Fetch the dataset 'AER-Journals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Journals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Journals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Journals.csv"))

(defn AER-KleinI
  "Fetch the dataset 'AER-KleinI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/KleinI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/KleinI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/KleinI.csv"))

(defn AER-Longley
  "Fetch the dataset 'AER-Longley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Longley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Longley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Longley.csv"))

(defn AER-ManufactCosts
  "Fetch the dataset 'AER-ManufactCosts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ManufactCosts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ManufactCosts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ManufactCosts.csv"))

(defn AER-MarkDollar
  "Fetch the dataset 'AER-MarkDollar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MarkDollar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MarkDollar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MarkDollar.csv"))

(defn AER-MarkPound
  "Fetch the dataset 'AER-MarkPound' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MarkPound.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MarkPound.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MarkPound.csv"))

(defn AER-MASchools
  "Fetch the dataset 'AER-MASchools' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MASchools.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MASchools.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MASchools.csv"))

(defn AER-Medicaid1986
  "Fetch the dataset 'AER-Medicaid1986' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Medicaid1986.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Medicaid1986.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Medicaid1986.csv"))

(defn AER-Mortgage
  "Fetch the dataset 'AER-Mortgage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Mortgage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Mortgage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Mortgage.csv"))

(defn AER-MotorCycles
  "Fetch the dataset 'AER-MotorCycles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MotorCycles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MotorCycles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MotorCycles.csv"))

(defn AER-MotorCycles2
  "Fetch the dataset 'AER-MotorCycles2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MotorCycles2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MotorCycles2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MotorCycles2.csv"))

(defn AER-MSCISwitzerland
  "Fetch the dataset 'AER-MSCISwitzerland' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MSCISwitzerland.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MSCISwitzerland.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MSCISwitzerland.csv"))

(defn AER-Municipalities
  "Fetch the dataset 'AER-Municipalities' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Municipalities.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Municipalities.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Municipalities.csv"))

(defn AER-MurderRates
  "Fetch the dataset 'AER-MurderRates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/MurderRates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/MurderRates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/MurderRates.csv"))

(defn AER-NaturalGas
  "Fetch the dataset 'AER-NaturalGas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/NaturalGas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/NaturalGas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/NaturalGas.csv"))

(defn AER-NMES1988
  "Fetch the dataset 'AER-NMES1988' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/NMES1988.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/NMES1988.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/NMES1988.csv"))

(defn AER-NYSESW
  "Fetch the dataset 'AER-NYSESW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/NYSESW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/NYSESW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/NYSESW.csv"))

(defn AER-OECDGas
  "Fetch the dataset 'AER-OECDGas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/OECDGas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/OECDGas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/OECDGas.csv"))

(defn AER-OECDGrowth
  "Fetch the dataset 'AER-OECDGrowth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/OECDGrowth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/OECDGrowth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/OECDGrowth.csv"))

(defn AER-OlympicTV
  "Fetch the dataset 'AER-OlympicTV' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/OlympicTV.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/OlympicTV.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/OlympicTV.csv"))

(defn AER-OrangeCounty
  "Fetch the dataset 'AER-OrangeCounty' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/OrangeCounty.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/OrangeCounty.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/OrangeCounty.csv"))

(defn AER-Parade2005
  "Fetch the dataset 'AER-Parade2005' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/Parade2005.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/Parade2005.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/Parade2005.csv"))

(defn AER-PepperPrice
  "Fetch the dataset 'AER-PepperPrice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/PepperPrice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/PepperPrice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/PepperPrice.csv"))

(defn AER-PhDPublications
  "Fetch the dataset 'AER-PhDPublications' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/PhDPublications.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/PhDPublications.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/PhDPublications.csv"))

(defn AER-ProgramEffectiveness
  "Fetch the dataset 'AER-ProgramEffectiveness' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ProgramEffectiveness.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ProgramEffectiveness.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ProgramEffectiveness.csv"))

(defn AER-PSID1976
  "Fetch the dataset 'AER-PSID1976' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID1976.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID1976.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/PSID1976.csv"))

(defn AER-PSID1982
  "Fetch the dataset 'AER-PSID1982' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID1982.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID1982.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/PSID1982.csv"))

(defn AER-PSID7682
  "Fetch the dataset 'AER-PSID7682' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID7682.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/PSID7682.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/PSID7682.csv"))

(defn AER-RecreationDemand
  "Fetch the dataset 'AER-RecreationDemand' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/RecreationDemand.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/RecreationDemand.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/RecreationDemand.csv"))

(defn AER-ResumeNames
  "Fetch the dataset 'AER-ResumeNames' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ResumeNames.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ResumeNames.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ResumeNames.csv"))

(defn AER-ShipAccidents
  "Fetch the dataset 'AER-ShipAccidents' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/ShipAccidents.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/ShipAccidents.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/ShipAccidents.csv"))

(defn AER-SIC33
  "Fetch the dataset 'AER-SIC33' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/SIC33.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/SIC33.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/SIC33.csv"))

(defn AER-SmokeBan
  "Fetch the dataset 'AER-SmokeBan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/SmokeBan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/SmokeBan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/SmokeBan.csv"))

(defn AER-SportsCards
  "Fetch the dataset 'AER-SportsCards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/SportsCards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/SportsCards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/SportsCards.csv"))

(defn AER-STAR
  "Fetch the dataset 'AER-STAR' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/STAR.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/STAR.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/STAR.csv"))

(defn AER-StrikeDuration
  "Fetch the dataset 'AER-StrikeDuration' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/StrikeDuration.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/StrikeDuration.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/StrikeDuration.csv"))

(defn AER-SwissLabor
  "Fetch the dataset 'AER-SwissLabor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/SwissLabor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/SwissLabor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/SwissLabor.csv"))

(defn AER-TeachingRatings
  "Fetch the dataset 'AER-TeachingRatings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/TeachingRatings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/TeachingRatings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/TeachingRatings.csv"))

(defn AER-TechChange
  "Fetch the dataset 'AER-TechChange' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/TechChange.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/TechChange.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/TechChange.csv"))

(defn AER-TradeCredit
  "Fetch the dataset 'AER-TradeCredit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/TradeCredit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/TradeCredit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/TradeCredit.csv"))

(defn AER-TravelMode
  "Fetch the dataset 'AER-TravelMode' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/TravelMode.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/TravelMode.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/TravelMode.csv"))

(defn AER-UKInflation
  "Fetch the dataset 'AER-UKInflation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/UKInflation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/UKInflation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/UKInflation.csv"))

(defn AER-UKNonDurables
  "Fetch the dataset 'AER-UKNonDurables' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/UKNonDurables.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/UKNonDurables.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/UKNonDurables.csv"))

(defn AER-USAirlines
  "Fetch the dataset 'AER-USAirlines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USAirlines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USAirlines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USAirlines.csv"))

(defn AER-USConsump1950
  "Fetch the dataset 'AER-USConsump1950' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1950.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1950.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USConsump1950.csv"))

(defn AER-USConsump1979
  "Fetch the dataset 'AER-USConsump1979' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1979.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1979.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USConsump1979.csv"))

(defn AER-USConsump1993
  "Fetch the dataset 'AER-USConsump1993' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1993.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USConsump1993.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USConsump1993.csv"))

(defn AER-USCrudes
  "Fetch the dataset 'AER-USCrudes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USCrudes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USCrudes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USCrudes.csv"))

(defn AER-USGasB
  "Fetch the dataset 'AER-USGasB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USGasB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USGasB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USGasB.csv"))

(defn AER-USGasG
  "Fetch the dataset 'AER-USGasG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USGasG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USGasG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USGasG.csv"))

(defn AER-USInvest
  "Fetch the dataset 'AER-USInvest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USInvest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USInvest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USInvest.csv"))

(defn AER-USMacroB
  "Fetch the dataset 'AER-USMacroB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMacroB.csv"))

(defn AER-USMacroG
  "Fetch the dataset 'AER-USMacroG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMacroG.csv"))

(defn AER-USMacroSW
  "Fetch the dataset 'AER-USMacroSW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMacroSW.csv"))

(defn AER-USMacroSWM
  "Fetch the dataset 'AER-USMacroSWM' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSWM.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSWM.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMacroSWM.csv"))

(defn AER-USMacroSWQ
  "Fetch the dataset 'AER-USMacroSWQ' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSWQ.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMacroSWQ.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMacroSWQ.csv"))

(defn AER-USMoney
  "Fetch the dataset 'AER-USMoney' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMoney.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USMoney.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USMoney.csv"))

(defn AER-USProdIndex
  "Fetch the dataset 'AER-USProdIndex' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USProdIndex.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USProdIndex.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USProdIndex.csv"))

(defn AER-USSeatBelts
  "Fetch the dataset 'AER-USSeatBelts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USSeatBelts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USSeatBelts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USSeatBelts.csv"))

(defn AER-USStocksSW
  "Fetch the dataset 'AER-USStocksSW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/USStocksSW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/USStocksSW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/USStocksSW.csv"))

(defn AER-WeakInstrument
  "Fetch the dataset 'AER-WeakInstrument' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/AER/WeakInstrument.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/AER/WeakInstrument.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/AER/WeakInstrument.csv"))

(defn aod-antibio
  "Fetch the dataset 'aod-antibio' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/antibio.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/antibio.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/antibio.csv"))

(defn aod-cohorts
  "Fetch the dataset 'aod-cohorts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/cohorts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/cohorts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/cohorts.csv"))

(defn aod-dja
  "Fetch the dataset 'aod-dja' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/dja.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/dja.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/dja.csv"))

(defn aod-lizards
  "Fetch the dataset 'aod-lizards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/lizards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/lizards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/lizards.csv"))

(defn aod-mice
  "Fetch the dataset 'aod-mice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/mice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/mice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/mice.csv"))

(defn aod-orob1
  "Fetch the dataset 'aod-orob1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/orob1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/orob1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/orob1.csv"))

(defn aod-orob2
  "Fetch the dataset 'aod-orob2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/orob2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/orob2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/orob2.csv"))

(defn aod-rabbits
  "Fetch the dataset 'aod-rabbits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/rabbits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/rabbits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/rabbits.csv"))

(defn aod-rats
  "Fetch the dataset 'aod-rats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/rats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/rats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/rats.csv"))

(defn aod-salmonella
  "Fetch the dataset 'aod-salmonella' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/aod/salmonella.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/aod/salmonella.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/aod/salmonella.csv"))

(defn asaur-ashkenazi
  "Fetch the dataset 'asaur-ashkenazi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/ashkenazi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/ashkenazi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/ashkenazi.csv"))

(defn asaur-ChanningHouse
  "Fetch the dataset 'asaur-ChanningHouse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/ChanningHouse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/ChanningHouse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/ChanningHouse.csv"))

(defn asaur-gastricXelox
  "Fetch the dataset 'asaur-gastricXelox' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/gastricXelox.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/gastricXelox.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/gastricXelox.csv"))

(defn asaur-hepatoCellular
  "Fetch the dataset 'asaur-hepatoCellular' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/hepatoCellular.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/hepatoCellular.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/hepatoCellular.csv"))

(defn asaur-pancreatic
  "Fetch the dataset 'asaur-pancreatic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pancreatic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pancreatic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/pancreatic.csv"))

(defn asaur-pancreatic2
  "Fetch the dataset 'asaur-pancreatic2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pancreatic2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pancreatic2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/pancreatic2.csv"))

(defn asaur-pharmacoSmoking
  "Fetch the dataset 'asaur-pharmacoSmoking' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pharmacoSmoking.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/pharmacoSmoking.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/pharmacoSmoking.csv"))

(defn asaur-prostateSurvival
  "Fetch the dataset 'asaur-prostateSurvival' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/asaur/prostateSurvival.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/asaur/prostateSurvival.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/asaur/prostateSurvival.csv"))

(defn bakeoff-bakersdata
  "Fetch the dataset 'bakeoff-bakers (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/bakers.csv"))

(defn bakeoff-bakers_rawdata
  "Fetch the dataset 'bakeoff-bakers_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakers_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakers_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/bakers_raw.csv"))

(defn bakeoff-bakes_rawdata
  "Fetch the dataset 'bakeoff-bakes_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakes_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/bakes_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/bakes_raw.csv"))

(defn bakeoff-challengesdata
  "Fetch the dataset 'bakeoff-challenges (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/challenges.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/challenges.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/challenges.csv"))

(defn bakeoff-episodesdata
  "Fetch the dataset 'bakeoff-episodes (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/episodes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/episodes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/episodes.csv"))

(defn bakeoff-episodes_rawdata
  "Fetch the dataset 'bakeoff-episodes_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/episodes_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/episodes_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/episodes_raw.csv"))

(defn bakeoff-ratingsdata
  "Fetch the dataset 'bakeoff-ratings (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/ratings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/ratings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/ratings.csv"))

(defn bakeoff-ratings_rawdata
  "Fetch the dataset 'bakeoff-ratings_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/ratings_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/ratings_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/ratings_raw.csv"))

(defn bakeoff-results_rawdata
  "Fetch the dataset 'bakeoff-results_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/results_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/results_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/results_raw.csv"))

(defn bakeoff-seasons_rawdata
  "Fetch the dataset 'bakeoff-seasons_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/seasons_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/seasons_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/seasons_raw.csv"))

(defn bakeoff-series_rawdata
  "Fetch the dataset 'bakeoff-series_raw (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/series_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/series_raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/series_raw.csv"))

(defn bakeoff-spice_test_widedata
  "Fetch the dataset 'bakeoff-spice_test_wide (data)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/spice_test_wide.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/bakeoff/spice_test_wide.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/bakeoff/spice_test_wide.csv"))

(defn betareg-CarTask
  "Fetch the dataset 'betareg-CarTask' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/CarTask.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/CarTask.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/CarTask.csv"))

(defn betareg-FoodExpenditure
  "Fetch the dataset 'betareg-FoodExpenditure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/FoodExpenditure.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/FoodExpenditure.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/FoodExpenditure.csv"))

(defn betareg-GasolineYield
  "Fetch the dataset 'betareg-GasolineYield' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/GasolineYield.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/GasolineYield.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/GasolineYield.csv"))

(defn betareg-ImpreciseTask
  "Fetch the dataset 'betareg-ImpreciseTask' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/ImpreciseTask.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/ImpreciseTask.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/ImpreciseTask.csv"))

(defn betareg-LossAversion
  "Fetch the dataset 'betareg-LossAversion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/LossAversion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/LossAversion.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/LossAversion.csv"))

(defn betareg-MockJurors
  "Fetch the dataset 'betareg-MockJurors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/MockJurors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/MockJurors.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/MockJurors.csv"))

(defn betareg-ReadingSkills
  "Fetch the dataset 'betareg-ReadingSkills' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/ReadingSkills.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/ReadingSkills.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/ReadingSkills.csv"))

(defn betareg-StressAnxiety
  "Fetch the dataset 'betareg-StressAnxiety' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/StressAnxiety.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/StressAnxiety.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/StressAnxiety.csv"))

(defn betareg-WeatherTask
  "Fetch the dataset 'betareg-WeatherTask' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/betareg/WeatherTask.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/betareg/WeatherTask.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/betareg/WeatherTask.csv"))

(defn boot-acme
  "Fetch the dataset 'boot-acme' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/acme.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/acme.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/acme.csv"))

(defn boot-aids
  "Fetch the dataset 'boot-aids' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/aids.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/aids.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/aids.csv"))

(defn boot-aircondit
  "Fetch the dataset 'boot-aircondit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/aircondit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/aircondit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/aircondit.csv"))

(defn boot-aircondit7
  "Fetch the dataset 'boot-aircondit7' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/aircondit7.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/aircondit7.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/aircondit7.csv"))

(defn boot-amis
  "Fetch the dataset 'boot-amis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/amis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/amis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/amis.csv"))

(defn boot-aml
  "Fetch the dataset 'boot-aml' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/aml.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/aml.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/aml.csv"))

(defn boot-beaver
  "Fetch the dataset 'boot-beaver' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/beaver.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/beaver.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/beaver.csv"))

(defn boot-bigcity
  "Fetch the dataset 'boot-bigcity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/bigcity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/bigcity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/bigcity.csv"))

(defn boot-brambles
  "Fetch the dataset 'boot-brambles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/brambles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/brambles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/brambles.csv"))

(defn boot-breslow
  "Fetch the dataset 'boot-breslow' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/breslow.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/breslow.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/breslow.csv"))

(defn boot-calcium
  "Fetch the dataset 'boot-calcium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/calcium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/calcium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/calcium.csv"))

(defn boot-cane
  "Fetch the dataset 'boot-cane' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/cane.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/cane.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/cane.csv"))

(defn boot-capability
  "Fetch the dataset 'boot-capability' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/capability.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/capability.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/capability.csv"))

(defn boot-catsM
  "Fetch the dataset 'boot-catsM' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/catsM.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/catsM.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/catsM.csv"))

(defn boot-cav
  "Fetch the dataset 'boot-cav' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/cav.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/cav.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/cav.csv"))

(defn boot-cd4
  "Fetch the dataset 'boot-cd4' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/cd4.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/cd4.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/cd4.csv"))

(defn boot-channing
  "Fetch the dataset 'boot-channing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/channing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/channing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/channing.csv"))

(defn boot-city
  "Fetch the dataset 'boot-city' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/city.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/city.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/city.csv"))

(defn boot-claridge
  "Fetch the dataset 'boot-claridge' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/claridge.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/claridge.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/claridge.csv"))

(defn boot-cloth
  "Fetch the dataset 'boot-cloth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/cloth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/cloth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/cloth.csv"))

(defn boot-co.transfer
  "Fetch the dataset 'boot-co.transfer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/co.transfer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/co.transfer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/co.transfer.csv"))

(defn boot-coal
  "Fetch the dataset 'boot-coal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/coal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/coal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/coal.csv"))

(defn boot-darwin
  "Fetch the dataset 'boot-darwin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/darwin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/darwin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/darwin.csv"))

(defn boot-dogs
  "Fetch the dataset 'boot-dogs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/dogs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/dogs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/dogs.csv"))

(defn boot-downs.bc
  "Fetch the dataset 'boot-downs.bc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/downs.bc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/downs.bc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/downs.bc.csv"))

(defn boot-ducks
  "Fetch the dataset 'boot-ducks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/ducks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/ducks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/ducks.csv"))

(defn boot-fir
  "Fetch the dataset 'boot-fir' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/fir.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/fir.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/fir.csv"))

(defn boot-frets
  "Fetch the dataset 'boot-frets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/frets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/frets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/frets.csv"))

(defn boot-grav
  "Fetch the dataset 'boot-grav' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/grav.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/grav.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/grav.csv"))

(defn boot-gravity
  "Fetch the dataset 'boot-gravity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/gravity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/gravity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/gravity.csv"))

(defn boot-hirose
  "Fetch the dataset 'boot-hirose' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/hirose.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/hirose.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/hirose.csv"))

(defn boot-islay
  "Fetch the dataset 'boot-islay' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/islay.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/islay.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/islay.csv"))

(defn boot-manaus
  "Fetch the dataset 'boot-manaus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/manaus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/manaus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/manaus.csv"))

(defn boot-melanoma
  "Fetch the dataset 'boot-melanoma' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/melanoma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/melanoma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/melanoma.csv"))

(defn boot-motor
  "Fetch the dataset 'boot-motor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/motor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/motor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/motor.csv"))

(defn boot-neuro
  "Fetch the dataset 'boot-neuro' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/neuro.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/neuro.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/neuro.csv"))

(defn boot-nitrofen
  "Fetch the dataset 'boot-nitrofen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/nitrofen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/nitrofen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/nitrofen.csv"))

(defn boot-nodal
  "Fetch the dataset 'boot-nodal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/nodal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/nodal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/nodal.csv"))

(defn boot-nuclear
  "Fetch the dataset 'boot-nuclear' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/nuclear.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/nuclear.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/nuclear.csv"))

(defn boot-paulsen
  "Fetch the dataset 'boot-paulsen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/paulsen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/paulsen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/paulsen.csv"))

(defn boot-poisons
  "Fetch the dataset 'boot-poisons' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/poisons.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/poisons.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/poisons.csv"))

(defn boot-polar
  "Fetch the dataset 'boot-polar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/polar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/polar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/polar.csv"))

(defn boot-remission
  "Fetch the dataset 'boot-remission' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/remission.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/remission.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/remission.csv"))

(defn boot-salinity
  "Fetch the dataset 'boot-salinity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/salinity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/salinity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/salinity.csv"))

(defn boot-survival
  "Fetch the dataset 'boot-survival' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/survival.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/survival.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/survival.csv"))

(defn boot-tau
  "Fetch the dataset 'boot-tau' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/tau.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/tau.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/tau.csv"))

(defn boot-tuna
  "Fetch the dataset 'boot-tuna' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/tuna.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/tuna.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/tuna.csv"))

(defn boot-urine
  "Fetch the dataset 'boot-urine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/urine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/urine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/urine.csv"))

(defn boot-wool
  "Fetch the dataset 'boot-wool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/boot/wool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/boot/wool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/boot/wool.csv"))

(defn carData-Adler
  "Fetch the dataset 'carData-Adler' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Adler.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Adler.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Adler.csv"))

(defn carData-AMSsurvey
  "Fetch the dataset 'carData-AMSsurvey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/AMSsurvey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/AMSsurvey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/AMSsurvey.csv"))

(defn carData-Angell
  "Fetch the dataset 'carData-Angell' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Angell.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Angell.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Angell.csv"))

(defn carData-Anscombe
  "Fetch the dataset 'carData-Anscombe' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Anscombe.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Anscombe.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Anscombe.csv"))

(defn carData-Arrests
  "Fetch the dataset 'carData-Arrests' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Arrests.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Arrests.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Arrests.csv"))

(defn carData-Baumann
  "Fetch the dataset 'carData-Baumann' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Baumann.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Baumann.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Baumann.csv"))

(defn carData-BEPS
  "Fetch the dataset 'carData-BEPS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/BEPS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/BEPS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/BEPS.csv"))

(defn carData-Bfox
  "Fetch the dataset 'carData-Bfox' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Bfox.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Bfox.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Bfox.csv"))

(defn carData-Blackmore
  "Fetch the dataset 'carData-Blackmore' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Blackmore.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Blackmore.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Blackmore.csv"))

(defn carData-Burt
  "Fetch the dataset 'carData-Burt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Burt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Burt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Burt.csv"))

(defn carData-CanPop
  "Fetch the dataset 'carData-CanPop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/CanPop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/CanPop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/CanPop.csv"))

(defn carData-CES11
  "Fetch the dataset 'carData-CES11' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/CES11.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/CES11.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/CES11.csv"))

(defn carData-Chile
  "Fetch the dataset 'carData-Chile' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Chile.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Chile.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Chile.csv"))

(defn carData-Chirot
  "Fetch the dataset 'carData-Chirot' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Chirot.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Chirot.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Chirot.csv"))

(defn carData-Cowles
  "Fetch the dataset 'carData-Cowles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Cowles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Cowles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Cowles.csv"))

(defn carData-Davis
  "Fetch the dataset 'carData-Davis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Davis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Davis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Davis.csv"))

(defn carData-DavisThin
  "Fetch the dataset 'carData-DavisThin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/DavisThin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/DavisThin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/DavisThin.csv"))

(defn carData-Depredations
  "Fetch the dataset 'carData-Depredations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Depredations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Depredations.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Depredations.csv"))

(defn carData-Duncan
  "Fetch the dataset 'carData-Duncan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Duncan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Duncan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Duncan.csv"))

(defn carData-Ericksen
  "Fetch the dataset 'carData-Ericksen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ericksen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ericksen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Ericksen.csv"))

(defn carData-Florida
  "Fetch the dataset 'carData-Florida' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Florida.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Florida.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Florida.csv"))

(defn carData-Freedman
  "Fetch the dataset 'carData-Freedman' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Freedman.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Freedman.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Freedman.csv"))

(defn carData-Friendly
  "Fetch the dataset 'carData-Friendly' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Friendly.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Friendly.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Friendly.csv"))

(defn carData-Ginzberg
  "Fetch the dataset 'carData-Ginzberg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ginzberg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ginzberg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Ginzberg.csv"))

(defn carData-Greene
  "Fetch the dataset 'carData-Greene' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Greene.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Greene.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Greene.csv"))

(defn carData-GSSvocab
  "Fetch the dataset 'carData-GSSvocab' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/GSSvocab.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/GSSvocab.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/GSSvocab.csv"))

(defn carData-Guyer
  "Fetch the dataset 'carData-Guyer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Guyer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Guyer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Guyer.csv"))

(defn carData-Hartnagel
  "Fetch the dataset 'carData-Hartnagel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Hartnagel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Hartnagel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Hartnagel.csv"))

(defn carData-Highway1
  "Fetch the dataset 'carData-Highway1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Highway1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Highway1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Highway1.csv"))

(defn carData-KosteckiDillon
  "Fetch the dataset 'carData-KosteckiDillon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/KosteckiDillon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/KosteckiDillon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/KosteckiDillon.csv"))

(defn carData-Leinhardt
  "Fetch the dataset 'carData-Leinhardt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Leinhardt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Leinhardt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Leinhardt.csv"))

(defn carData-LoBD
  "Fetch the dataset 'carData-LoBD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/LoBD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/LoBD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/LoBD.csv"))

(defn carData-Mandel
  "Fetch the dataset 'carData-Mandel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Mandel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Mandel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Mandel.csv"))

(defn carData-Migration
  "Fetch the dataset 'carData-Migration' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Migration.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Migration.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Migration.csv"))

(defn carData-Moore
  "Fetch the dataset 'carData-Moore' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Moore.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Moore.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Moore.csv"))

(defn carData-MplsDemo
  "Fetch the dataset 'carData-MplsDemo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/MplsDemo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/MplsDemo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/MplsDemo.csv"))

(defn carData-MplsStops
  "Fetch the dataset 'carData-MplsStops' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/MplsStops.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/MplsStops.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/MplsStops.csv"))

(defn carData-Mroz
  "Fetch the dataset 'carData-Mroz' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Mroz.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Mroz.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Mroz.csv"))

(defn carData-OBrienKaiser
  "Fetch the dataset 'carData-OBrienKaiser' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/OBrienKaiser.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/OBrienKaiser.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/OBrienKaiser.csv"))

(defn carData-OBrienKaiserLong
  "Fetch the dataset 'carData-OBrienKaiserLong' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/OBrienKaiserLong.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/OBrienKaiserLong.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/OBrienKaiserLong.csv"))

(defn carData-Ornstein
  "Fetch the dataset 'carData-Ornstein' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ornstein.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Ornstein.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Ornstein.csv"))

(defn carData-Pottery
  "Fetch the dataset 'carData-Pottery' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Pottery.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Pottery.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Pottery.csv"))

(defn carData-Prestige
  "Fetch the dataset 'carData-Prestige' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Prestige.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Prestige.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Prestige.csv"))

(defn carData-Quartet
  "Fetch the dataset 'carData-Quartet' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Quartet.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Quartet.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Quartet.csv"))

(defn carData-Robey
  "Fetch the dataset 'carData-Robey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Robey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Robey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Robey.csv"))

(defn carData-Rossi
  "Fetch the dataset 'carData-Rossi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Rossi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Rossi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Rossi.csv"))

(defn carData-Sahlins
  "Fetch the dataset 'carData-Sahlins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Sahlins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Sahlins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Sahlins.csv"))

(defn carData-Salaries
  "Fetch the dataset 'carData-Salaries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Salaries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Salaries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Salaries.csv"))

(defn carData-SLID
  "Fetch the dataset 'carData-SLID' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/SLID.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/SLID.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/SLID.csv"))

(defn carData-Soils
  "Fetch the dataset 'carData-Soils' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Soils.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Soils.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Soils.csv"))

(defn carData-States
  "Fetch the dataset 'carData-States' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/States.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/States.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/States.csv"))

(defn carData-TitanicSurvival
  "Fetch the dataset 'carData-TitanicSurvival' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/TitanicSurvival.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/TitanicSurvival.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/TitanicSurvival.csv"))

(defn carData-Transact
  "Fetch the dataset 'carData-Transact' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Transact.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Transact.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Transact.csv"))

(defn carData-UN
  "Fetch the dataset 'carData-UN' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/UN.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/UN.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/UN.csv"))

(defn carData-UN98
  "Fetch the dataset 'carData-UN98' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/UN98.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/UN98.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/UN98.csv"))

(defn carData-USPop
  "Fetch the dataset 'carData-USPop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/USPop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/USPop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/USPop.csv"))

(defn carData-Vocab
  "Fetch the dataset 'carData-Vocab' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Vocab.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Vocab.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Vocab.csv"))

(defn carData-WeightLoss
  "Fetch the dataset 'carData-WeightLoss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/WeightLoss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/WeightLoss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/WeightLoss.csv"))

(defn carData-Wells
  "Fetch the dataset 'carData-Wells' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wells.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wells.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Wells.csv"))

(defn carData-Womenlf
  "Fetch the dataset 'carData-Womenlf' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Womenlf.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Womenlf.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Womenlf.csv"))

(defn carData-Wong
  "Fetch the dataset 'carData-Wong' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wong.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wong.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Wong.csv"))

(defn carData-Wool
  "Fetch the dataset 'carData-Wool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/Wool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/Wool.csv"))

(defn carData-WVS
  "Fetch the dataset 'carData-WVS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/carData/WVS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/carData/WVS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/carData/WVS.csv"))

(defn causaldata-abortion
  "Fetch the dataset 'causaldata-abortion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/abortion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/abortion.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/abortion.csv"))

(defn causaldata-adult_services
  "Fetch the dataset 'causaldata-adult_services' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/adult_services.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/adult_services.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/adult_services.csv"))

(defn causaldata-auto
  "Fetch the dataset 'causaldata-auto' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/auto.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/auto.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/auto.csv"))

(defn causaldata-avocado
  "Fetch the dataset 'causaldata-avocado' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/avocado.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/avocado.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/avocado.csv"))

(defn causaldata-black_politicians
  "Fetch the dataset 'causaldata-black_politicians' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/black_politicians.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/black_politicians.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/black_politicians.csv"))

(defn causaldata-castle
  "Fetch the dataset 'causaldata-castle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/castle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/castle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/castle.csv"))

(defn causaldata-close_college
  "Fetch the dataset 'causaldata-close_college' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/close_college.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/close_college.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/close_college.csv"))

(defn causaldata-close_elections_lmb
  "Fetch the dataset 'causaldata-close_elections_lmb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/close_elections_lmb.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/close_elections_lmb.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/close_elections_lmb.csv"))

(defn causaldata-cps_mixtape
  "Fetch the dataset 'causaldata-cps_mixtape' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/cps_mixtape.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/cps_mixtape.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/cps_mixtape.csv"))

(defn causaldata-credit_cards
  "Fetch the dataset 'causaldata-credit_cards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/credit_cards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/credit_cards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/credit_cards.csv"))

(defn causaldata-gapminder
  "Fetch the dataset 'causaldata-gapminder' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gapminder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gapminder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/gapminder.csv"))

(defn causaldata-google_stock
  "Fetch the dataset 'causaldata-google_stock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/google_stock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/google_stock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/google_stock.csv"))

(defn causaldata-gov_transfers
  "Fetch the dataset 'causaldata-gov_transfers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gov_transfers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gov_transfers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/gov_transfers.csv"))

(defn causaldata-gov_transfers_density
  "Fetch the dataset 'causaldata-gov_transfers_density' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gov_transfers_density.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/gov_transfers_density.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/gov_transfers_density.csv"))

(defn causaldata-greek_data
  "Fetch the dataset 'causaldata-greek_data' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/greek_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/greek_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/greek_data.csv"))

(defn causaldata-mortgages
  "Fetch the dataset 'causaldata-mortgages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/mortgages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/mortgages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/mortgages.csv"))

(defn causaldata-Mroz
  "Fetch the dataset 'causaldata-Mroz' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/Mroz.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/Mroz.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/Mroz.csv"))

(defn causaldata-nhefs
  "Fetch the dataset 'causaldata-nhefs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/nhefs.csv"))

(defn causaldata-nhefs_codebook
  "Fetch the dataset 'causaldata-nhefs_codebook' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs_codebook.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs_codebook.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/nhefs_codebook.csv"))

(defn causaldata-nhefs_complete
  "Fetch the dataset 'causaldata-nhefs_complete' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs_complete.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nhefs_complete.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/nhefs_complete.csv"))

(defn causaldata-nsw_mixtape
  "Fetch the dataset 'causaldata-nsw_mixtape' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nsw_mixtape.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/nsw_mixtape.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/nsw_mixtape.csv"))

(defn causaldata-organ_donations
  "Fetch the dataset 'causaldata-organ_donations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/organ_donations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/organ_donations.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/organ_donations.csv"))

(defn causaldata-restaurant_inspections
  "Fetch the dataset 'causaldata-restaurant_inspections' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/restaurant_inspections.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/restaurant_inspections.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/restaurant_inspections.csv"))

(defn causaldata-ri
  "Fetch the dataset 'causaldata-ri' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/ri.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/ri.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/ri.csv"))

(defn causaldata-scorecard
  "Fetch the dataset 'causaldata-scorecard' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/scorecard.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/scorecard.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/scorecard.csv"))

(defn causaldata-snow
  "Fetch the dataset 'causaldata-snow' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/snow.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/snow.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/snow.csv"))

(defn causaldata-social_insure
  "Fetch the dataset 'causaldata-social_insure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/social_insure.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/social_insure.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/social_insure.csv"))

(defn causaldata-texas
  "Fetch the dataset 'causaldata-texas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/texas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/texas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/texas.csv"))

(defn causaldata-thornton_hiv
  "Fetch the dataset 'causaldata-thornton_hiv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/thornton_hiv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/thornton_hiv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/thornton_hiv.csv"))

(defn causaldata-titanic
  "Fetch the dataset 'causaldata-titanic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/titanic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/titanic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/titanic.csv"))

(defn causaldata-training_bias_reduction
  "Fetch the dataset 'causaldata-training_bias_reduction' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/training_bias_reduction.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/training_bias_reduction.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/training_bias_reduction.csv"))

(defn causaldata-training_example
  "Fetch the dataset 'causaldata-training_example' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/training_example.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/training_example.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/training_example.csv"))

(defn causaldata-yule
  "Fetch the dataset 'causaldata-yule' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/yule.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/causaldata/yule.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/causaldata/yule.csv"))

(defn cluster-agriculture
  "Fetch the dataset 'cluster-agriculture' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/agriculture.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/agriculture.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/agriculture.csv"))

(defn cluster-animals
  "Fetch the dataset 'cluster-animals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/animals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/animals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/animals.csv"))

(defn cluster-chorSub
  "Fetch the dataset 'cluster-chorSub' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/chorSub.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/chorSub.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/chorSub.csv"))

(defn cluster-flower
  "Fetch the dataset 'cluster-flower' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/flower.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/flower.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/flower.csv"))

(defn cluster-plantTraits
  "Fetch the dataset 'cluster-plantTraits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/plantTraits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/plantTraits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/plantTraits.csv"))

(defn cluster-pluton
  "Fetch the dataset 'cluster-pluton' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/pluton.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/pluton.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/pluton.csv"))

(defn cluster-ruspini
  "Fetch the dataset 'cluster-ruspini' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/ruspini.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/ruspini.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/ruspini.csv"))

(defn cluster-votes.repub
  "Fetch the dataset 'cluster-votes.repub' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/votes.repub.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/votes.repub.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/votes.repub.csv"))

(defn cluster-xclara
  "Fetch the dataset 'cluster-xclara' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/cluster/xclara.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/cluster/xclara.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/cluster/xclara.csv"))

(defn collegeScorecard-school
  "Fetch the dataset 'collegeScorecard-school' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/collegeScorecard/school.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/collegeScorecard/school.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/collegeScorecard/school.csv"))

(defn collegeScorecard-scorecard
  "Fetch the dataset 'collegeScorecard-scorecard' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/collegeScorecard/scorecard.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/collegeScorecard/scorecard.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/collegeScorecard/scorecard.csv"))

(defn COUNT-affairs
  "Fetch the dataset 'COUNT-affairs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/affairs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/affairs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/affairs.csv"))

(defn COUNT-azcabgptca
  "Fetch the dataset 'COUNT-azcabgptca' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azcabgptca.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azcabgptca.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/azcabgptca.csv"))

(defn COUNT-azdrg112
  "Fetch the dataset 'COUNT-azdrg112' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azdrg112.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azdrg112.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/azdrg112.csv"))

(defn COUNT-azpro
  "Fetch the dataset 'COUNT-azpro' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azpro.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azpro.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/azpro.csv"))

(defn COUNT-azprocedure
  "Fetch the dataset 'COUNT-azprocedure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azprocedure.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/azprocedure.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/azprocedure.csv"))

(defn COUNT-badhealth
  "Fetch the dataset 'COUNT-badhealth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/badhealth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/badhealth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/badhealth.csv"))

(defn COUNT-fasttrakg
  "Fetch the dataset 'COUNT-fasttrakg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/fasttrakg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/fasttrakg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/fasttrakg.csv"))

(defn COUNT-fishing
  "Fetch the dataset 'COUNT-fishing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/fishing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/fishing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/fishing.csv"))

(defn COUNT-lbw
  "Fetch the dataset 'COUNT-lbw' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/lbw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/lbw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/lbw.csv"))

(defn COUNT-lbwgrp
  "Fetch the dataset 'COUNT-lbwgrp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/lbwgrp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/lbwgrp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/lbwgrp.csv"))

(defn COUNT-loomis
  "Fetch the dataset 'COUNT-loomis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/loomis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/loomis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/loomis.csv"))

(defn COUNT-mdvis
  "Fetch the dataset 'COUNT-mdvis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/mdvis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/mdvis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/mdvis.csv"))

(defn COUNT-medpar
  "Fetch the dataset 'COUNT-medpar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/medpar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/medpar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/medpar.csv"))

(defn COUNT-nuts
  "Fetch the dataset 'COUNT-nuts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/nuts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/nuts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/nuts.csv"))

(defn COUNT-rwm
  "Fetch the dataset 'COUNT-rwm' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/rwm.csv"))

(defn COUNT-rwm1984
  "Fetch the dataset 'COUNT-rwm1984' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm1984.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm1984.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/rwm1984.csv"))

(defn COUNT-rwm5yr
  "Fetch the dataset 'COUNT-rwm5yr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm5yr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/rwm5yr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/rwm5yr.csv"))

(defn COUNT-ships
  "Fetch the dataset 'COUNT-ships' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/ships.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/ships.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/ships.csv"))

(defn COUNT-smoking
  "Fetch the dataset 'COUNT-smoking' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/smoking.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/smoking.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/smoking.csv"))

(defn COUNT-titanic
  "Fetch the dataset 'COUNT-titanic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/titanic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/titanic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/titanic.csv"))

(defn COUNT-titanicgrp
  "Fetch the dataset 'COUNT-titanicgrp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/titanicgrp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/COUNT/titanicgrp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/COUNT/titanicgrp.csv"))

(defn crch-RainIbk
  "Fetch the dataset 'crch-RainIbk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/crch/RainIbk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/crch/RainIbk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/crch/RainIbk.csv"))

(defn DAAG-ACF1
  "Fetch the dataset 'DAAG-ACF1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ACF1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ACF1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/ACF1.csv"))

(defn DAAG-ais
  "Fetch the dataset 'DAAG-ais' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ais.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ais.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/ais.csv"))

(defn DAAG-alc2018
  "Fetch the dataset 'DAAG-alc2018' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/alc2018.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/alc2018.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/alc2018.csv"))

(defn DAAG-allbacks
  "Fetch the dataset 'DAAG-allbacks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/allbacks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/allbacks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/allbacks.csv"))

(defn DAAG-anesthetic
  "Fetch the dataset 'DAAG-anesthetic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/anesthetic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/anesthetic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/anesthetic.csv"))

(defn DAAG-ant111b
  "Fetch the dataset 'DAAG-ant111b' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ant111b.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ant111b.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/ant111b.csv"))

(defn DAAG-antigua
  "Fetch the dataset 'DAAG-antigua' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/antigua.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/antigua.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/antigua.csv"))

(defn DAAG-appletaste
  "Fetch the dataset 'DAAG-appletaste' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/appletaste.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/appletaste.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/appletaste.csv"))

(defn DAAG-audists
  "Fetch the dataset 'DAAG-audists' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/audists.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/audists.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/audists.csv"))

(defn DAAG-aulatlong
  "Fetch the dataset 'DAAG-aulatlong' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/aulatlong.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/aulatlong.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/aulatlong.csv"))

(defn DAAG-austpop
  "Fetch the dataset 'DAAG-austpop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/austpop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/austpop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/austpop.csv"))

(defn DAAG-biomass
  "Fetch the dataset 'DAAG-biomass' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/biomass.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/biomass.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/biomass.csv"))

(defn DAAG-bomregions
  "Fetch the dataset 'DAAG-bomregions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/bomregions.csv"))

(defn DAAG-bomregions2018
  "Fetch the dataset 'DAAG-bomregions2018' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions2018.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions2018.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/bomregions2018.csv"))

(defn DAAG-bomregions2021
  "Fetch the dataset 'DAAG-bomregions2021' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions2021.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomregions2021.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/bomregions2021.csv"))

(defn DAAG-bomsoi
  "Fetch the dataset 'DAAG-bomsoi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomsoi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bomsoi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/bomsoi.csv"))

(defn DAAG-bostonc
  "Fetch the dataset 'DAAG-bostonc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bostonc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/bostonc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/bostonc.csv"))

(defn DAAG-carprice
  "Fetch the dataset 'DAAG-carprice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/carprice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/carprice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/carprice.csv"))

(defn DAAG-Cars93.summary
  "Fetch the dataset 'DAAG-Cars93.summary' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Cars93.summary.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Cars93.summary.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/Cars93.summary.csv"))

(defn DAAG-cerealsugar
  "Fetch the dataset 'DAAG-cerealsugar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cerealsugar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cerealsugar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cerealsugar.csv"))

(defn DAAG-cfseal
  "Fetch the dataset 'DAAG-cfseal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cfseal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cfseal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cfseal.csv"))

(defn DAAG-cities
  "Fetch the dataset 'DAAG-cities' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cities.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cities.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cities.csv"))

(defn DAAG-codling
  "Fetch the dataset 'DAAG-codling' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/codling.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/codling.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/codling.csv"))

(defn DAAG-coralPval
  "Fetch the dataset 'DAAG-coralPval' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/coralPval.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/coralPval.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/coralPval.csv"))

(defn DAAG-cottonworkers
  "Fetch the dataset 'DAAG-cottonworkers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cottonworkers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cottonworkers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cottonworkers.csv"))

(defn DAAG-cps1
  "Fetch the dataset 'DAAG-cps1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cps1.csv"))

(defn DAAG-cps2
  "Fetch the dataset 'DAAG-cps2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cps2.csv"))

(defn DAAG-cps3
  "Fetch the dataset 'DAAG-cps3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cps3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cps3.csv"))

(defn DAAG-cricketer
  "Fetch the dataset 'DAAG-cricketer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cricketer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cricketer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cricketer.csv"))

(defn DAAG-cuckoohosts
  "Fetch the dataset 'DAAG-cuckoohosts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cuckoohosts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cuckoohosts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cuckoohosts.csv"))

(defn DAAG-cuckoos
  "Fetch the dataset 'DAAG-cuckoos' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cuckoos.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/cuckoos.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/cuckoos.csv"))

(defn DAAG-dengue
  "Fetch the dataset 'DAAG-dengue' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/dengue.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/dengue.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/dengue.csv"))

(defn DAAG-dewpoint
  "Fetch the dataset 'DAAG-dewpoint' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/dewpoint.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/dewpoint.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/dewpoint.csv"))

(defn DAAG-droughts
  "Fetch the dataset 'DAAG-droughts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/droughts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/droughts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/droughts.csv"))

(defn DAAG-edcCO2
  "Fetch the dataset 'DAAG-edcCO2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/edcCO2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/edcCO2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/edcCO2.csv"))

(defn DAAG-edcT
  "Fetch the dataset 'DAAG-edcT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/edcT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/edcT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/edcT.csv"))

(defn DAAG-elastic1
  "Fetch the dataset 'DAAG-elastic1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elastic1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elastic1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/elastic1.csv"))

(defn DAAG-elastic2
  "Fetch the dataset 'DAAG-elastic2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elastic2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elastic2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/elastic2.csv"))

(defn DAAG-elasticband
  "Fetch the dataset 'DAAG-elasticband' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elasticband.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/elasticband.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/elasticband.csv"))

(defn DAAG-fossilfuel
  "Fetch the dataset 'DAAG-fossilfuel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fossilfuel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fossilfuel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/fossilfuel.csv"))

(defn DAAG-fossum
  "Fetch the dataset 'DAAG-fossum' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fossum.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fossum.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/fossum.csv"))

(defn DAAG-frogs
  "Fetch the dataset 'DAAG-frogs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/frogs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/frogs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/frogs.csv"))

(defn DAAG-frostedflakes
  "Fetch the dataset 'DAAG-frostedflakes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/frostedflakes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/frostedflakes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/frostedflakes.csv"))

(defn DAAG-fruitohms
  "Fetch the dataset 'DAAG-fruitohms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fruitohms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/fruitohms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/fruitohms.csv"))

(defn DAAG-gaba
  "Fetch the dataset 'DAAG-gaba' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/gaba.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/gaba.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/gaba.csv"))

(defn DAAG-geophones
  "Fetch the dataset 'DAAG-geophones' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/geophones.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/geophones.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/geophones.csv"))

(defn DAAG-greatLakes
  "Fetch the dataset 'DAAG-greatLakes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/greatLakes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/greatLakes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/greatLakes.csv"))

(defn DAAG-grog
  "Fetch the dataset 'DAAG-grog' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/grog.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/grog.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/grog.csv"))

(defn DAAG-headInjury
  "Fetch the dataset 'DAAG-headInjury' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/headInjury.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/headInjury.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/headInjury.csv"))

(defn DAAG-hills
  "Fetch the dataset 'DAAG-hills' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hills.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hills.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/hills.csv"))

(defn DAAG-hills2000
  "Fetch the dataset 'DAAG-hills2000' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hills2000.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hills2000.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/hills2000.csv"))

(defn DAAG-hotspots
  "Fetch the dataset 'DAAG-hotspots' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hotspots.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hotspots.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/hotspots.csv"))

(defn DAAG-hotspots2006
  "Fetch the dataset 'DAAG-hotspots2006' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hotspots2006.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hotspots2006.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/hotspots2006.csv"))

(defn DAAG-houseprices
  "Fetch the dataset 'DAAG-houseprices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/houseprices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/houseprices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/houseprices.csv"))

(defn DAAG-humanpower1
  "Fetch the dataset 'DAAG-humanpower1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/humanpower1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/humanpower1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/humanpower1.csv"))

(defn DAAG-humanpower2
  "Fetch the dataset 'DAAG-humanpower2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/humanpower2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/humanpower2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/humanpower2.csv"))

(defn DAAG-hurricNamed
  "Fetch the dataset 'DAAG-hurricNamed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hurricNamed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/hurricNamed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/hurricNamed.csv"))

(defn DAAG-intersalt
  "Fetch the dataset 'DAAG-intersalt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/intersalt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/intersalt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/intersalt.csv"))

(defn DAAG-ironslag
  "Fetch the dataset 'DAAG-ironslag' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ironslag.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ironslag.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/ironslag.csv"))

(defn DAAG-jobs
  "Fetch the dataset 'DAAG-jobs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/jobs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/jobs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/jobs.csv"))

(defn DAAG-kiwishade
  "Fetch the dataset 'DAAG-kiwishade' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/kiwishade.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/kiwishade.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/kiwishade.csv"))

(defn DAAG-leafshape
  "Fetch the dataset 'DAAG-leafshape' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leafshape.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leafshape.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/leafshape.csv"))

(defn DAAG-leafshape17
  "Fetch the dataset 'DAAG-leafshape17' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leafshape17.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leafshape17.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/leafshape17.csv"))

(defn DAAG-leaftemp
  "Fetch the dataset 'DAAG-leaftemp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leaftemp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leaftemp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/leaftemp.csv"))

(defn DAAG-leaftemp.all
  "Fetch the dataset 'DAAG-leaftemp.all' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leaftemp.all.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/leaftemp.all.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/leaftemp.all.csv"))

(defn DAAG-litters
  "Fetch the dataset 'DAAG-litters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/litters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/litters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/litters.csv"))

(defn DAAG-lognihills
  "Fetch the dataset 'DAAG-lognihills' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/lognihills.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/lognihills.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/lognihills.csv"))

(defn DAAG-Lottario
  "Fetch the dataset 'DAAG-Lottario' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Lottario.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Lottario.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/Lottario.csv"))

(defn DAAG-lung
  "Fetch the dataset 'DAAG-lung' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/lung.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/lung.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/lung.csv"))

(defn DAAG-Manitoba.lakes
  "Fetch the dataset 'DAAG-Manitoba.lakes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Manitoba.lakes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/Manitoba.lakes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/Manitoba.lakes.csv"))

(defn DAAG-mdbAVtJtoD
  "Fetch the dataset 'DAAG-mdbAVtJtoD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mdbAVtJtoD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mdbAVtJtoD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/mdbAVtJtoD.csv"))

(defn DAAG-measles
  "Fetch the dataset 'DAAG-measles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/measles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/measles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/measles.csv"))

(defn DAAG-medExpenses
  "Fetch the dataset 'DAAG-medExpenses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/medExpenses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/medExpenses.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/medExpenses.csv"))

(defn DAAG-mifem
  "Fetch the dataset 'DAAG-mifem' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mifem.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mifem.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/mifem.csv"))

(defn DAAG-mignonette
  "Fetch the dataset 'DAAG-mignonette' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mignonette.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/mignonette.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/mignonette.csv"))

(defn DAAG-milk
  "Fetch the dataset 'DAAG-milk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/milk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/milk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/milk.csv"))

(defn DAAG-modelcars
  "Fetch the dataset 'DAAG-modelcars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/modelcars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/modelcars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/modelcars.csv"))

(defn DAAG-monica
  "Fetch the dataset 'DAAG-monica' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/monica.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/monica.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/monica.csv"))

(defn DAAG-moths
  "Fetch the dataset 'DAAG-moths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/moths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/moths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/moths.csv"))

(defn DAAG-nassCDS
  "Fetch the dataset 'DAAG-nassCDS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nassCDS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nassCDS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nassCDS.csv"))

(defn DAAG-nasshead
  "Fetch the dataset 'DAAG-nasshead' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nasshead.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nasshead.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nasshead.csv"))

(defn DAAG-nihills
  "Fetch the dataset 'DAAG-nihills' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nihills.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nihills.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nihills.csv"))

(defn DAAG-nsw74demo
  "Fetch the dataset 'DAAG-nsw74demo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74demo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74demo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nsw74demo.csv"))

(defn DAAG-nsw74psid1
  "Fetch the dataset 'DAAG-nsw74psid1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psid1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psid1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nsw74psid1.csv"))

(defn DAAG-nsw74psid3
  "Fetch the dataset 'DAAG-nsw74psid3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psid3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psid3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nsw74psid3.csv"))

(defn DAAG-nsw74psidA
  "Fetch the dataset 'DAAG-nsw74psidA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psidA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nsw74psidA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nsw74psidA.csv"))

(defn DAAG-nswdemo
  "Fetch the dataset 'DAAG-nswdemo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nswdemo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nswdemo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nswdemo.csv"))

(defn DAAG-nswpsid1
  "Fetch the dataset 'DAAG-nswpsid1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nswpsid1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/nswpsid1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/nswpsid1.csv"))

(defn DAAG-oddbooks
  "Fetch the dataset 'DAAG-oddbooks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/oddbooks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/oddbooks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/oddbooks.csv"))

(defn DAAG-orings
  "Fetch the dataset 'DAAG-orings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/orings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/orings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/orings.csv"))

(defn DAAG-ozone
  "Fetch the dataset 'DAAG-ozone' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ozone.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/ozone.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/ozone.csv"))

(defn DAAG-pair65
  "Fetch the dataset 'DAAG-pair65' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/pair65.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/pair65.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/pair65.csv"))

(defn DAAG-possum
  "Fetch the dataset 'DAAG-possum' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/possum.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/possum.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/possum.csv"))

(defn DAAG-possumsites
  "Fetch the dataset 'DAAG-possumsites' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/possumsites.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/possumsites.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/possumsites.csv"))

(defn DAAG-poxetc
  "Fetch the dataset 'DAAG-poxetc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/poxetc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/poxetc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/poxetc.csv"))

(defn DAAG-primates
  "Fetch the dataset 'DAAG-primates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/primates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/primates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/primates.csv"))

(defn DAAG-progression
  "Fetch the dataset 'DAAG-progression' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/progression.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/progression.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/progression.csv"))

(defn DAAG-psid1
  "Fetch the dataset 'DAAG-psid1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/psid1.csv"))

(defn DAAG-psid2
  "Fetch the dataset 'DAAG-psid2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/psid2.csv"))

(defn DAAG-psid3
  "Fetch the dataset 'DAAG-psid3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/psid3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/psid3.csv"))

(defn DAAG-races2000
  "Fetch the dataset 'DAAG-races2000' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/races2000.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/races2000.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/races2000.csv"))

(defn DAAG-rainforest
  "Fetch the dataset 'DAAG-rainforest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rainforest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rainforest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/rainforest.csv"))

(defn DAAG-rareplants
  "Fetch the dataset 'DAAG-rareplants' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rareplants.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rareplants.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/rareplants.csv"))

(defn DAAG-repPsych
  "Fetch the dataset 'DAAG-repPsych' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/repPsych.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/repPsych.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/repPsych.csv"))

(defn DAAG-rice
  "Fetch the dataset 'DAAG-rice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/rice.csv"))

(defn DAAG-rockArt
  "Fetch the dataset 'DAAG-rockArt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rockArt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/rockArt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/rockArt.csv"))

(defn DAAG-roller
  "Fetch the dataset 'DAAG-roller' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/roller.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/roller.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/roller.csv"))

(defn DAAG-science
  "Fetch the dataset 'DAAG-science' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/science.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/science.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/science.csv"))

(defn DAAG-seedrates
  "Fetch the dataset 'DAAG-seedrates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/seedrates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/seedrates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/seedrates.csv"))

(defn DAAG-socsupport
  "Fetch the dataset 'DAAG-socsupport' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/socsupport.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/socsupport.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/socsupport.csv"))

(defn DAAG-softbacks
  "Fetch the dataset 'DAAG-softbacks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/softbacks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/softbacks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/softbacks.csv"))

(defn DAAG-sorption
  "Fetch the dataset 'DAAG-sorption' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/sorption.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/sorption.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/sorption.csv"))

(defn DAAG-SP500close
  "Fetch the dataset 'DAAG-SP500close' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/SP500close.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/SP500close.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/SP500close.csv"))

(defn DAAG-SP500W90
  "Fetch the dataset 'DAAG-SP500W90' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/SP500W90.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/SP500W90.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/SP500W90.csv"))

(defn DAAG-spam7
  "Fetch the dataset 'DAAG-spam7' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/spam7.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/spam7.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/spam7.csv"))

(defn DAAG-stVincent
  "Fetch the dataset 'DAAG-stVincent' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/stVincent.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/stVincent.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/stVincent.csv"))

(defn DAAG-sugar
  "Fetch the dataset 'DAAG-sugar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/sugar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/sugar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/sugar.csv"))

(defn DAAG-tinting
  "Fetch the dataset 'DAAG-tinting' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/tinting.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/tinting.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/tinting.csv"))

(defn DAAG-tomato
  "Fetch the dataset 'DAAG-tomato' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/tomato.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/tomato.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/tomato.csv"))

(defn DAAG-toycars
  "Fetch the dataset 'DAAG-toycars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/toycars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/toycars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/toycars.csv"))

(defn DAAG-vince111b
  "Fetch the dataset 'DAAG-vince111b' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/vince111b.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/vince111b.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/vince111b.csv"))

(defn DAAG-vlt
  "Fetch the dataset 'DAAG-vlt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/vlt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/vlt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/vlt.csv"))

(defn DAAG-wages1833
  "Fetch the dataset 'DAAG-wages1833' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/wages1833.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/wages1833.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/wages1833.csv"))

(defn DAAG-whoops
  "Fetch the dataset 'DAAG-whoops' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/whoops.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/whoops.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/whoops.csv"))

(defn DAAG-worldRecords
  "Fetch the dataset 'DAAG-worldRecords' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/worldRecords.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/DAAG/worldRecords.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/DAAG/worldRecords.csv"))

(defn datasets-ability.cov
  "Fetch the dataset 'datasets-ability.cov' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ability.cov.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ability.cov.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/ability.cov.csv"))

(defn datasets-airmiles
  "Fetch the dataset 'datasets-airmiles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/airmiles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/airmiles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/airmiles.csv"))

(defn datasets-AirPassengers
  "Fetch the dataset 'datasets-AirPassengers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/AirPassengers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/AirPassengers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/AirPassengers.csv"))

(defn datasets-airquality
  "Fetch the dataset 'datasets-airquality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/airquality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/airquality.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/airquality.csv"))

(defn datasets-anscombe
  "Fetch the dataset 'datasets-anscombe' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/anscombe.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/anscombe.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/anscombe.csv"))

(defn datasets-attenu
  "Fetch the dataset 'datasets-attenu' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/attenu.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/attenu.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/attenu.csv"))

(defn datasets-attitude
  "Fetch the dataset 'datasets-attitude' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/attitude.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/attitude.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/attitude.csv"))

(defn datasets-austres
  "Fetch the dataset 'datasets-austres' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/austres.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/austres.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/austres.csv"))

(defn datasets-beaver1beavers
  "Fetch the dataset 'datasets-beaver1 (beavers)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/beaver1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/beaver1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/beaver1.csv"))

(defn datasets-beaver2beavers
  "Fetch the dataset 'datasets-beaver2 (beavers)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/beaver2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/beaver2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/beaver2.csv"))

(defn datasets-BJsales
  "Fetch the dataset 'datasets-BJsales' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BJsales.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BJsales.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/BJsales.csv"))

(defn datasets-BJsales.leadBJsales
  "Fetch the dataset 'datasets-BJsales.lead (BJsales)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BJsales.lead.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BJsales.lead.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/BJsales.lead.csv"))

(defn datasets-BOD
  "Fetch the dataset 'datasets-BOD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BOD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/BOD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/BOD.csv"))

(defn datasets-cars
  "Fetch the dataset 'datasets-cars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/cars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/cars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/cars.csv"))

(defn datasets-ChickWeight
  "Fetch the dataset 'datasets-ChickWeight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ChickWeight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ChickWeight.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/ChickWeight.csv"))

(defn datasets-chickwts
  "Fetch the dataset 'datasets-chickwts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/chickwts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/chickwts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/chickwts.csv"))

(defn datasets-CO2
  "Fetch the dataset 'datasets-CO2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/CO2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/CO2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/CO2.csv"))

(defn datasets-co2
  "Fetch the dataset 'datasets-co2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/co2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/co2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/co2.csv"))

(defn datasets-crimtab
  "Fetch the dataset 'datasets-crimtab' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/crimtab.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/crimtab.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/crimtab.csv"))

(defn datasets-discoveries
  "Fetch the dataset 'datasets-discoveries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/discoveries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/discoveries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/discoveries.csv"))

(defn datasets-DNase
  "Fetch the dataset 'datasets-DNase' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/DNase.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/DNase.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/DNase.csv"))

(defn datasets-esoph
  "Fetch the dataset 'datasets-esoph' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/esoph.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/esoph.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/esoph.csv"))

(defn datasets-euro
  "Fetch the dataset 'datasets-euro' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/euro.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/euro.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/euro.csv"))

(defn datasets-euro.crosseuro
  "Fetch the dataset 'datasets-euro.cross (euro)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/euro.cross.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/euro.cross.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/euro.cross.csv"))

(defn datasets-eurodist
  "Fetch the dataset 'datasets-eurodist' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/eurodist.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/eurodist.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/eurodist.csv"))

(defn datasets-EuStockMarkets
  "Fetch the dataset 'datasets-EuStockMarkets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/EuStockMarkets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/EuStockMarkets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/EuStockMarkets.csv"))

(defn datasets-faithful
  "Fetch the dataset 'datasets-faithful' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/faithful.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/faithful.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/faithful.csv"))

(defn datasets-fdeathsUKLungDeaths
  "Fetch the dataset 'datasets-fdeaths (UKLungDeaths)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/fdeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/fdeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/fdeaths.csv"))

(defn datasets-Formaldehyde
  "Fetch the dataset 'datasets-Formaldehyde' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Formaldehyde.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Formaldehyde.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Formaldehyde.csv"))

(defn datasets-freeny
  "Fetch the dataset 'datasets-freeny' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/freeny.csv"))

(defn datasets-freeny.xfreeny
  "Fetch the dataset 'datasets-freeny.x (freeny)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.x.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.x.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/freeny.x.csv"))

(defn datasets-freeny.yfreeny
  "Fetch the dataset 'datasets-freeny.y (freeny)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.y.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/freeny.y.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/freeny.y.csv"))

(defn datasets-HairEyeColor
  "Fetch the dataset 'datasets-HairEyeColor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/HairEyeColor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/HairEyeColor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/HairEyeColor.csv"))

(defn datasets-Harman23.cor
  "Fetch the dataset 'datasets-Harman23.cor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Harman23.cor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Harman23.cor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Harman23.cor.csv"))

(defn datasets-Harman74.cor
  "Fetch the dataset 'datasets-Harman74.cor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Harman74.cor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Harman74.cor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Harman74.cor.csv"))

(defn datasets-Indometh
  "Fetch the dataset 'datasets-Indometh' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Indometh.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Indometh.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Indometh.csv"))

(defn datasets-infert
  "Fetch the dataset 'datasets-infert' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/infert.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/infert.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/infert.csv"))

(defn datasets-InsectSprays
  "Fetch the dataset 'datasets-InsectSprays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/InsectSprays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/InsectSprays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/InsectSprays.csv"))

(defn datasets-iris
  "Fetch the dataset 'datasets-iris' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/iris.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/iris.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/iris.csv"))

(defn datasets-iris3
  "Fetch the dataset 'datasets-iris3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/iris3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/iris3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/iris3.csv"))

(defn datasets-islands
  "Fetch the dataset 'datasets-islands' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/islands.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/islands.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/islands.csv"))

(defn datasets-JohnsonJohnson
  "Fetch the dataset 'datasets-JohnsonJohnson' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/JohnsonJohnson.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/JohnsonJohnson.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/JohnsonJohnson.csv"))

(defn datasets-LakeHuron
  "Fetch the dataset 'datasets-LakeHuron' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/LakeHuron.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/LakeHuron.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/LakeHuron.csv"))

(defn datasets-ldeathsUKLungDeaths
  "Fetch the dataset 'datasets-ldeaths (UKLungDeaths)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ldeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ldeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/ldeaths.csv"))

(defn datasets-lh
  "Fetch the dataset 'datasets-lh' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/lh.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/lh.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/lh.csv"))

(defn datasets-LifeCycleSavings
  "Fetch the dataset 'datasets-LifeCycleSavings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/LifeCycleSavings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/LifeCycleSavings.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/LifeCycleSavings.csv"))

(defn datasets-Loblolly
  "Fetch the dataset 'datasets-Loblolly' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Loblolly.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Loblolly.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Loblolly.csv"))

(defn datasets-longley
  "Fetch the dataset 'datasets-longley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/longley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/longley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/longley.csv"))

(defn datasets-lynx
  "Fetch the dataset 'datasets-lynx' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/lynx.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/lynx.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/lynx.csv"))

(defn datasets-mdeathsUKLungDeaths
  "Fetch the dataset 'datasets-mdeaths (UKLungDeaths)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/mdeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/mdeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/mdeaths.csv"))

(defn datasets-morley
  "Fetch the dataset 'datasets-morley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/morley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/morley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/morley.csv"))

(defn datasets-mtcars
  "Fetch the dataset 'datasets-mtcars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/mtcars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/mtcars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/mtcars.csv"))

(defn datasets-nhtemp
  "Fetch the dataset 'datasets-nhtemp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/nhtemp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/nhtemp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/nhtemp.csv"))

(defn datasets-Nile
  "Fetch the dataset 'datasets-Nile' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Nile.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Nile.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Nile.csv"))

(defn datasets-nottem
  "Fetch the dataset 'datasets-nottem' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/nottem.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/nottem.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/nottem.csv"))

(defn datasets-npk
  "Fetch the dataset 'datasets-npk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/npk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/npk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/npk.csv"))

(defn datasets-occupationalStatus
  "Fetch the dataset 'datasets-occupationalStatus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/occupationalStatus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/occupationalStatus.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/occupationalStatus.csv"))

(defn datasets-Orange
  "Fetch the dataset 'datasets-Orange' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Orange.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Orange.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Orange.csv"))

(defn datasets-OrchardSprays
  "Fetch the dataset 'datasets-OrchardSprays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/OrchardSprays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/OrchardSprays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/OrchardSprays.csv"))

(defn datasets-PlantGrowth
  "Fetch the dataset 'datasets-PlantGrowth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/PlantGrowth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/PlantGrowth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/PlantGrowth.csv"))

(defn datasets-precip
  "Fetch the dataset 'datasets-precip' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/precip.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/precip.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/precip.csv"))

(defn datasets-presidents
  "Fetch the dataset 'datasets-presidents' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/presidents.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/presidents.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/presidents.csv"))

(defn datasets-pressure
  "Fetch the dataset 'datasets-pressure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/pressure.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/pressure.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/pressure.csv"))

(defn datasets-Puromycin
  "Fetch the dataset 'datasets-Puromycin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Puromycin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Puromycin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Puromycin.csv"))

(defn datasets-quakes
  "Fetch the dataset 'datasets-quakes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/quakes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/quakes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/quakes.csv"))

(defn datasets-randu
  "Fetch the dataset 'datasets-randu' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/randu.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/randu.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/randu.csv"))

(defn datasets-rivers
  "Fetch the dataset 'datasets-rivers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/rivers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/rivers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/rivers.csv"))

(defn datasets-rock
  "Fetch the dataset 'datasets-rock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/rock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/rock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/rock.csv"))

(defn datasets-Seatbelts
  "Fetch the dataset 'datasets-Seatbelts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Seatbelts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Seatbelts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Seatbelts.csv"))

(defn datasets-sleep
  "Fetch the dataset 'datasets-sleep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sleep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sleep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/sleep.csv"))

(defn datasets-stack.lossstackloss
  "Fetch the dataset 'datasets-stack.loss (stackloss)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stack.loss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stack.loss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/stack.loss.csv"))

(defn datasets-stack.xstackloss
  "Fetch the dataset 'datasets-stack.x (stackloss)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stack.x.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stack.x.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/stack.x.csv"))

(defn datasets-stackloss
  "Fetch the dataset 'datasets-stackloss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stackloss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/stackloss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/stackloss.csv"))

(defn datasets-state.abbstate
  "Fetch the dataset 'datasets-state.abb (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.abb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.abb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.abb.csv"))

(defn datasets-state.areastate
  "Fetch the dataset 'datasets-state.area (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.area.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.area.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.area.csv"))

(defn datasets-state.centerstate
  "Fetch the dataset 'datasets-state.center (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.center.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.center.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.center.csv"))

(defn datasets-state.divisionstate
  "Fetch the dataset 'datasets-state.division (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.division.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.division.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.division.csv"))

(defn datasets-state.namestate
  "Fetch the dataset 'datasets-state.name (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.name.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.name.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.name.csv"))

(defn datasets-state.regionstate
  "Fetch the dataset 'datasets-state.region (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.region.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.region.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.region.csv"))

(defn datasets-state.x77state
  "Fetch the dataset 'datasets-state.x77 (state)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.x77.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/state.x77.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/state.x77.csv"))

(defn datasets-sunspot.month
  "Fetch the dataset 'datasets-sunspot.month' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspot.month.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspot.month.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/sunspot.month.csv"))

(defn datasets-sunspot.year
  "Fetch the dataset 'datasets-sunspot.year' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspot.year.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspot.year.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/sunspot.year.csv"))

(defn datasets-sunspots
  "Fetch the dataset 'datasets-sunspots' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspots.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/sunspots.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/sunspots.csv"))

(defn datasets-swiss
  "Fetch the dataset 'datasets-swiss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/swiss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/swiss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/swiss.csv"))

(defn datasets-Theoph
  "Fetch the dataset 'datasets-Theoph' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Theoph.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Theoph.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Theoph.csv"))

(defn datasets-Titanic
  "Fetch the dataset 'datasets-Titanic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Titanic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/Titanic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/Titanic.csv"))

(defn datasets-ToothGrowth
  "Fetch the dataset 'datasets-ToothGrowth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ToothGrowth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/ToothGrowth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/ToothGrowth.csv"))

(defn datasets-treering
  "Fetch the dataset 'datasets-treering' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/treering.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/treering.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/treering.csv"))

(defn datasets-trees
  "Fetch the dataset 'datasets-trees' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/trees.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/trees.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/trees.csv"))

(defn datasets-UCBAdmissions
  "Fetch the dataset 'datasets-UCBAdmissions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UCBAdmissions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UCBAdmissions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/UCBAdmissions.csv"))

(defn datasets-UKDriverDeaths
  "Fetch the dataset 'datasets-UKDriverDeaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UKDriverDeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UKDriverDeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/UKDriverDeaths.csv"))

(defn datasets-UKgas
  "Fetch the dataset 'datasets-UKgas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UKgas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UKgas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/UKgas.csv"))

(defn datasets-USAccDeaths
  "Fetch the dataset 'datasets-USAccDeaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USAccDeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USAccDeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/USAccDeaths.csv"))

(defn datasets-USArrests
  "Fetch the dataset 'datasets-USArrests' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USArrests.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USArrests.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/USArrests.csv"))

(defn datasets-UScitiesD
  "Fetch the dataset 'datasets-UScitiesD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UScitiesD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/UScitiesD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/UScitiesD.csv"))

(defn datasets-USJudgeRatings
  "Fetch the dataset 'datasets-USJudgeRatings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USJudgeRatings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USJudgeRatings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/USJudgeRatings.csv"))

(defn datasets-USPersonalExpenditure
  "Fetch the dataset 'datasets-USPersonalExpenditure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USPersonalExpenditure.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/USPersonalExpenditure.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/USPersonalExpenditure.csv"))

(defn datasets-uspop
  "Fetch the dataset 'datasets-uspop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/uspop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/uspop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/uspop.csv"))

(defn datasets-VADeaths
  "Fetch the dataset 'datasets-VADeaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/VADeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/VADeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/VADeaths.csv"))

(defn datasets-volcano
  "Fetch the dataset 'datasets-volcano' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/volcano.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/volcano.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/volcano.csv"))

(defn datasets-warpbreaks
  "Fetch the dataset 'datasets-warpbreaks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/warpbreaks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/warpbreaks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/warpbreaks.csv"))

(defn datasets-women
  "Fetch the dataset 'datasets-women' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/women.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/women.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/women.csv"))

(defn datasets-WorldPhones
  "Fetch the dataset 'datasets-WorldPhones' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/WorldPhones.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/WorldPhones.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/WorldPhones.csv"))

(defn datasets-WWWusage
  "Fetch the dataset 'datasets-WWWusage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/datasets/WWWusage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/datasets/WWWusage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/datasets/WWWusage.csv"))

(defn dplyr-band_instruments
  "Fetch the dataset 'dplyr-band_instruments' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_instruments.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_instruments.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dplyr/band_instruments.csv"))

(defn dplyr-band_instruments2
  "Fetch the dataset 'dplyr-band_instruments2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_instruments2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_instruments2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dplyr/band_instruments2.csv"))

(defn dplyr-band_members
  "Fetch the dataset 'dplyr-band_members' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_members.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/band_members.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dplyr/band_members.csv"))

(defn dplyr-starwars
  "Fetch the dataset 'dplyr-starwars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/starwars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/starwars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dplyr/starwars.csv"))

(defn dplyr-storms
  "Fetch the dataset 'dplyr-storms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/storms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dplyr/storms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dplyr/storms.csv"))

(defn dragracer-rpdr_contep
  "Fetch the dataset 'dragracer-rpdr_contep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_contep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_contep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dragracer/rpdr_contep.csv"))

(defn dragracer-rpdr_contestants
  "Fetch the dataset 'dragracer-rpdr_contestants' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_contestants.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_contestants.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dragracer/rpdr_contestants.csv"))

(defn dragracer-rpdr_ep
  "Fetch the dataset 'dragracer-rpdr_ep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_ep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dragracer/rpdr_ep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dragracer/rpdr_ep.csv"))

(defn drc-acidiq
  "Fetch the dataset 'drc-acidiq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/acidiq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/acidiq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/acidiq.csv"))

(defn drc-algae
  "Fetch the dataset 'drc-algae' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/algae.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/algae.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/algae.csv"))

(defn drc-auxins
  "Fetch the dataset 'drc-auxins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/auxins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/auxins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/auxins.csv"))

(defn drc-chickweed
  "Fetch the dataset 'drc-chickweed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/chickweed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/chickweed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/chickweed.csv"))

(defn drc-chickweed0
  "Fetch the dataset 'drc-chickweed0' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/chickweed0.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/chickweed0.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/chickweed0.csv"))

(defn drc-daphnids
  "Fetch the dataset 'drc-daphnids' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/daphnids.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/daphnids.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/daphnids.csv"))

(defn drc-decontaminants
  "Fetch the dataset 'drc-decontaminants' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/decontaminants.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/decontaminants.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/decontaminants.csv"))

(defn drc-deguelin
  "Fetch the dataset 'drc-deguelin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/deguelin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/deguelin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/deguelin.csv"))

(defn drc-earthworms
  "Fetch the dataset 'drc-earthworms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/earthworms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/earthworms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/earthworms.csv"))

(defn drc-etmotc
  "Fetch the dataset 'drc-etmotc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/etmotc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/etmotc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/etmotc.csv"))

(defn drc-finney71
  "Fetch the dataset 'drc-finney71' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/finney71.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/finney71.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/finney71.csv"))

(defn drc-G.aparine
  "Fetch the dataset 'drc-G.aparine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/G.aparine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/G.aparine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/G.aparine.csv"))

(defn drc-germination
  "Fetch the dataset 'drc-germination' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/germination.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/germination.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/germination.csv"))

(defn drc-glymet
  "Fetch the dataset 'drc-glymet' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/glymet.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/glymet.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/glymet.csv"))

(defn drc-H.virescens
  "Fetch the dataset 'drc-H.virescens' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/H.virescens.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/H.virescens.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/H.virescens.csv"))

(defn drc-heartrate
  "Fetch the dataset 'drc-heartrate' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/heartrate.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/heartrate.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/heartrate.csv"))

(defn drc-leaflength
  "Fetch the dataset 'drc-leaflength' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/leaflength.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/leaflength.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/leaflength.csv"))

(defn drc-lepidium
  "Fetch the dataset 'drc-lepidium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/lepidium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/lepidium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/lepidium.csv"))

(defn drc-lettuce
  "Fetch the dataset 'drc-lettuce' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/lettuce.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/lettuce.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/lettuce.csv"))

(defn drc-M.bahia
  "Fetch the dataset 'drc-M.bahia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/M.bahia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/M.bahia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/M.bahia.csv"))

(defn drc-mecter
  "Fetch the dataset 'drc-mecter' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/mecter.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/mecter.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/mecter.csv"))

(defn drc-metals
  "Fetch the dataset 'drc-metals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/metals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/metals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/metals.csv"))

(defn drc-methionine
  "Fetch the dataset 'drc-methionine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/methionine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/methionine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/methionine.csv"))

(defn drc-nasturtium
  "Fetch the dataset 'drc-nasturtium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/nasturtium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/nasturtium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/nasturtium.csv"))

(defn drc-O.mykiss
  "Fetch the dataset 'drc-O.mykiss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/O.mykiss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/O.mykiss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/O.mykiss.csv"))

(defn drc-P.promelas
  "Fetch the dataset 'drc-P.promelas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/P.promelas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/P.promelas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/P.promelas.csv"))

(defn drc-RScompetition
  "Fetch the dataset 'drc-RScompetition' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/RScompetition.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/RScompetition.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/RScompetition.csv"))

(defn drc-ryegrass
  "Fetch the dataset 'drc-ryegrass' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/ryegrass.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/ryegrass.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/ryegrass.csv"))

(defn drc-S.alba
  "Fetch the dataset 'drc-S.alba' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/S.alba.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/S.alba.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/S.alba.csv"))

(defn drc-S.capricornutum
  "Fetch the dataset 'drc-S.capricornutum' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/S.capricornutum.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/S.capricornutum.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/S.capricornutum.csv"))

(defn drc-secalonic
  "Fetch the dataset 'drc-secalonic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/secalonic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/secalonic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/secalonic.csv"))

(defn drc-selenium
  "Fetch the dataset 'drc-selenium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/selenium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/selenium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/selenium.csv"))

(defn drc-spinach
  "Fetch the dataset 'drc-spinach' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/spinach.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/spinach.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/spinach.csv"))

(defn drc-terbuthylazin
  "Fetch the dataset 'drc-terbuthylazin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/terbuthylazin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/terbuthylazin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/terbuthylazin.csv"))

(defn drc-vinclozolin
  "Fetch the dataset 'drc-vinclozolin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/drc/vinclozolin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/drc/vinclozolin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/drc/vinclozolin.csv"))

(defn dslabs-admissions
  "Fetch the dataset 'dslabs-admissions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/admissions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/admissions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/admissions.csv"))

(defn dslabs-brca
  "Fetch the dataset 'dslabs-brca' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/brca.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/brca.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/brca.csv"))

(defn dslabs-brexit_polls
  "Fetch the dataset 'dslabs-brexit_polls' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/brexit_polls.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/brexit_polls.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/brexit_polls.csv"))

(defn dslabs-death_prob
  "Fetch the dataset 'dslabs-death_prob' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/death_prob.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/death_prob.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/death_prob.csv"))

(defn dslabs-divorce_margarine
  "Fetch the dataset 'dslabs-divorce_margarine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/divorce_margarine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/divorce_margarine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/divorce_margarine.csv"))

(defn dslabs-gapminder
  "Fetch the dataset 'dslabs-gapminder' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/gapminder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/gapminder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/gapminder.csv"))

(defn dslabs-greenhouse_gases
  "Fetch the dataset 'dslabs-greenhouse_gases' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/greenhouse_gases.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/greenhouse_gases.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/greenhouse_gases.csv"))

(defn dslabs-heights
  "Fetch the dataset 'dslabs-heights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/heights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/heights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/heights.csv"))

(defn dslabs-historic_co2
  "Fetch the dataset 'dslabs-historic_co2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/historic_co2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/historic_co2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/historic_co2.csv"))

(defn dslabs-mice_weightsmice_weigths
  "Fetch the dataset 'dslabs-mice_weights (mice_weigths)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/mice_weights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/mice_weights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/mice_weights.csv"))

(defn dslabs-movielens
  "Fetch the dataset 'dslabs-movielens' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/movielens.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/movielens.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/movielens.csv"))

(defn dslabs-murders
  "Fetch the dataset 'dslabs-murders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/murders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/murders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/murders.csv"))

(defn dslabs-na_example
  "Fetch the dataset 'dslabs-na_example' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/na_example.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/na_example.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/na_example.csv"))

(defn dslabs-nyc_regents_scores
  "Fetch the dataset 'dslabs-nyc_regents_scores' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/nyc_regents_scores.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/nyc_regents_scores.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/nyc_regents_scores.csv"))

(defn dslabs-oecdgapminder
  "Fetch the dataset 'dslabs-oecd (gapminder)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/oecd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/oecd.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/oecd.csv"))

(defn dslabs-olive
  "Fetch the dataset 'dslabs-olive' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/olive.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/olive.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/olive.csv"))

(defn dslabs-opecgapminder
  "Fetch the dataset 'dslabs-opec (gapminder)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/opec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/opec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/opec.csv"))

(defn dslabs-outlier_example
  "Fetch the dataset 'dslabs-outlier_example' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/outlier_example.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/outlier_example.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/outlier_example.csv"))

(defn dslabs-polls_2008
  "Fetch the dataset 'dslabs-polls_2008' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/polls_2008.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/polls_2008.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/polls_2008.csv"))

(defn dslabs-polls_us_election_2016
  "Fetch the dataset 'dslabs-polls_us_election_2016' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/polls_us_election_2016.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/polls_us_election_2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/polls_us_election_2016.csv"))

(defn dslabs-pr_death_countspr-death-counts
  "Fetch the dataset 'dslabs-pr_death_counts (pr-death-counts)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/pr_death_counts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/pr_death_counts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/pr_death_counts.csv"))

(defn dslabs-raw_data_research_funding_rates
  "Fetch the dataset 'dslabs-raw_data_research_funding_rates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/raw_data_research_funding_rates.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/raw_data_research_funding_rates.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/raw_data_research_funding_rates.csv"))

(defn dslabs-reported_heights
  "Fetch the dataset 'dslabs-reported_heights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/reported_heights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/reported_heights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/reported_heights.csv"))

(defn dslabs-research_funding_rates
  "Fetch the dataset 'dslabs-research_funding_rates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/research_funding_rates.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/research_funding_rates.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/research_funding_rates.csv"))

(defn dslabs-results_us_election_2016polls_us_election_2016
  "Fetch the dataset 'dslabs-results_us_election_2016 (polls_us_election_2016)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/results_us_election_2016.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/results_us_election_2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/results_us_election_2016.csv"))

(defn dslabs-sentiment_countstrump_tweets
  "Fetch the dataset 'dslabs-sentiment_counts (trump_tweets)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/sentiment_counts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/sentiment_counts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/sentiment_counts.csv"))

(defn dslabs-stars
  "Fetch the dataset 'dslabs-stars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/stars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/stars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/stars.csv"))

(defn dslabs-temp_carbon
  "Fetch the dataset 'dslabs-temp_carbon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/temp_carbon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/temp_carbon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/temp_carbon.csv"))

(defn dslabs-tissue_gene_expression
  "Fetch the dataset 'dslabs-tissue_gene_expression' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/tissue_gene_expression.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/tissue_gene_expression.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/tissue_gene_expression.csv"))

(defn dslabs-trump_tweets
  "Fetch the dataset 'dslabs-trump_tweets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/trump_tweets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/trump_tweets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/trump_tweets.csv"))

(defn dslabs-us_contagious_diseases
  "Fetch the dataset 'dslabs-us_contagious_diseases' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/us_contagious_diseases.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/dslabs/us_contagious_diseases.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/dslabs/us_contagious_diseases.csv"))

(defn Ecdat-Accident
  "Fetch the dataset 'Ecdat-Accident' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Accident.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Accident.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Accident.csv"))

(defn Ecdat-AccountantsAuditorsPct
  "Fetch the dataset 'Ecdat-AccountantsAuditorsPct' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/AccountantsAuditorsPct.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/AccountantsAuditorsPct.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/AccountantsAuditorsPct.csv"))

(defn Ecdat-Airline
  "Fetch the dataset 'Ecdat-Airline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Airline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Airline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Airline.csv"))

(defn Ecdat-Airq
  "Fetch the dataset 'Ecdat-Airq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Airq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Airq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Airq.csv"))

(defn Ecdat-bankingCrises
  "Fetch the dataset 'Ecdat-bankingCrises' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/bankingCrises.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/bankingCrises.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/bankingCrises.csv"))

(defn Ecdat-Benefits
  "Fetch the dataset 'Ecdat-Benefits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Benefits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Benefits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Benefits.csv"))

(defn Ecdat-Bids
  "Fetch the dataset 'Ecdat-Bids' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Bids.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Bids.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Bids.csv"))

(defn Ecdat-breaches
  "Fetch the dataset 'Ecdat-breaches' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/breaches.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/breaches.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/breaches.csv"))

(defn Ecdat-BudgetFood
  "Fetch the dataset 'Ecdat-BudgetFood' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetFood.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetFood.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/BudgetFood.csv"))

(defn Ecdat-BudgetItaly
  "Fetch the dataset 'Ecdat-BudgetItaly' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetItaly.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetItaly.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/BudgetItaly.csv"))

(defn Ecdat-BudgetUK
  "Fetch the dataset 'Ecdat-BudgetUK' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetUK.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/BudgetUK.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/BudgetUK.csv"))

(defn Ecdat-Bwages
  "Fetch the dataset 'Ecdat-Bwages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Bwages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Bwages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Bwages.csv"))

(defn Ecdat-Capm
  "Fetch the dataset 'Ecdat-Capm' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Capm.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Capm.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Capm.csv"))

(defn Ecdat-Car
  "Fetch the dataset 'Ecdat-Car' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Car.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Car.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Car.csv"))

(defn Ecdat-Caschool
  "Fetch the dataset 'Ecdat-Caschool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Caschool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Caschool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Caschool.csv"))

(defn Ecdat-Catsup
  "Fetch the dataset 'Ecdat-Catsup' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Catsup.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Catsup.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Catsup.csv"))

(defn Ecdat-Cigar
  "Fetch the dataset 'Ecdat-Cigar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cigar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cigar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Cigar.csv"))

(defn Ecdat-Cigarette
  "Fetch the dataset 'Ecdat-Cigarette' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cigarette.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cigarette.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Cigarette.csv"))

(defn Ecdat-Clothing
  "Fetch the dataset 'Ecdat-Clothing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Clothing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Clothing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Clothing.csv"))

(defn Ecdat-Computers
  "Fetch the dataset 'Ecdat-Computers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Computers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Computers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Computers.csv"))

(defn Ecdat-Consumption
  "Fetch the dataset 'Ecdat-Consumption' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Consumption.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Consumption.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Consumption.csv"))

(defn Ecdat-coolingFromNuclearWar
  "Fetch the dataset 'Ecdat-coolingFromNuclearWar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/coolingFromNuclearWar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/coolingFromNuclearWar.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/coolingFromNuclearWar.csv"))

(defn Ecdat-CPSch3
  "Fetch the dataset 'Ecdat-CPSch3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CPSch3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CPSch3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/CPSch3.csv"))

(defn Ecdat-Cracker
  "Fetch the dataset 'Ecdat-Cracker' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cracker.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Cracker.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Cracker.csv"))

(defn Ecdat-CRANpackages
  "Fetch the dataset 'Ecdat-CRANpackages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRANpackages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRANpackages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/CRANpackages.csv"))

(defn Ecdat-Crime
  "Fetch the dataset 'Ecdat-Crime' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Crime.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Crime.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Crime.csv"))

(defn Ecdat-CRSPday
  "Fetch the dataset 'Ecdat-CRSPday' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRSPday.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRSPday.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/CRSPday.csv"))

(defn Ecdat-CRSPmon
  "Fetch the dataset 'Ecdat-CRSPmon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRSPmon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/CRSPmon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/CRSPmon.csv"))

(defn Ecdat-Diamond
  "Fetch the dataset 'Ecdat-Diamond' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Diamond.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Diamond.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Diamond.csv"))

(defn Ecdat-DM
  "Fetch the dataset 'Ecdat-DM' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DM.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DM.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/DM.csv"))

(defn Ecdat-Doctor
  "Fetch the dataset 'Ecdat-Doctor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Doctor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Doctor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Doctor.csv"))

(defn Ecdat-DoctorAUS
  "Fetch the dataset 'Ecdat-DoctorAUS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DoctorAUS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DoctorAUS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/DoctorAUS.csv"))

(defn Ecdat-DoctorContacts
  "Fetch the dataset 'Ecdat-DoctorContacts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DoctorContacts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/DoctorContacts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/DoctorContacts.csv"))

(defn Ecdat-Earnings
  "Fetch the dataset 'Ecdat-Earnings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Earnings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Earnings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Earnings.csv"))

(defn Ecdat-Electricity
  "Fetch the dataset 'Ecdat-Electricity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Electricity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Electricity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Electricity.csv"))

(defn Ecdat-Fair
  "Fetch the dataset 'Ecdat-Fair' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fair.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fair.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Fair.csv"))

(defn Ecdat-Fatality
  "Fetch the dataset 'Ecdat-Fatality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fatality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fatality.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Fatality.csv"))

(defn Ecdat-Fishing
  "Fetch the dataset 'Ecdat-Fishing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fishing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Fishing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Fishing.csv"))

(defn Ecdat-Forward
  "Fetch the dataset 'Ecdat-Forward' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Forward.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Forward.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Forward.csv"))

(defn Ecdat-FriendFoe
  "Fetch the dataset 'Ecdat-FriendFoe' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/FriendFoe.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/FriendFoe.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/FriendFoe.csv"))

(defn Ecdat-Garch
  "Fetch the dataset 'Ecdat-Garch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Garch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Garch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Garch.csv"))

(defn Ecdat-Gasoline
  "Fetch the dataset 'Ecdat-Gasoline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Gasoline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Gasoline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Gasoline.csv"))

(defn Ecdat-Griliches
  "Fetch the dataset 'Ecdat-Griliches' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Griliches.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Griliches.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Griliches.csv"))

(defn Ecdat-Grunfeld
  "Fetch the dataset 'Ecdat-Grunfeld' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Grunfeld.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Grunfeld.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Grunfeld.csv"))

(defn Ecdat-HC
  "Fetch the dataset 'Ecdat-HC' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HC.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HC.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/HC.csv"))

(defn Ecdat-Hdma
  "Fetch the dataset 'Ecdat-Hdma' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hdma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hdma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Hdma.csv"))

(defn Ecdat-Heating
  "Fetch the dataset 'Ecdat-Heating' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Heating.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Heating.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Heating.csv"))

(defn Ecdat-Hedonic
  "Fetch the dataset 'Ecdat-Hedonic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hedonic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hedonic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Hedonic.csv"))

(defn Ecdat-HHSCyberSecurityBreaches
  "Fetch the dataset 'Ecdat-HHSCyberSecurityBreaches' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HHSCyberSecurityBreaches.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HHSCyberSecurityBreaches.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/HHSCyberSecurityBreaches.csv"))

(defn Ecdat-HI
  "Fetch the dataset 'Ecdat-HI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/HI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/HI.csv"))

(defn Ecdat-Hmda
  "Fetch the dataset 'Ecdat-Hmda' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hmda.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hmda.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Hmda.csv"))

(defn Ecdat-Housing
  "Fetch the dataset 'Ecdat-Housing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Housing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Housing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Housing.csv"))

(defn Ecdat-Hstarts
  "Fetch the dataset 'Ecdat-Hstarts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hstarts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Hstarts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Hstarts.csv"))

(defn Ecdat-Icecream
  "Fetch the dataset 'Ecdat-Icecream' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Icecream.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Icecream.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Icecream.csv"))

(defn Ecdat-incidents.byCountryYr
  "Fetch the dataset 'Ecdat-incidents.byCountryYr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/incidents.byCountryYr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/incidents.byCountryYr.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/incidents.byCountryYr.csv"))

(defn Ecdat-incomeInequality
  "Fetch the dataset 'Ecdat-incomeInequality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/incomeInequality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/incomeInequality.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/incomeInequality.csv"))

(defn Ecdat-IncomeUK
  "Fetch the dataset 'Ecdat-IncomeUK' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/IncomeUK.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/IncomeUK.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/IncomeUK.csv"))

(defn Ecdat-Irates
  "Fetch the dataset 'Ecdat-Irates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Irates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Irates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Irates.csv"))

(defn Ecdat-Journals
  "Fetch the dataset 'Ecdat-Journals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Journals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Journals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Journals.csv"))

(defn Ecdat-Kakadu
  "Fetch the dataset 'Ecdat-Kakadu' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Kakadu.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Kakadu.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Kakadu.csv"))

(defn Ecdat-Ketchup
  "Fetch the dataset 'Ecdat-Ketchup' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Ketchup.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Ketchup.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Ketchup.csv"))

(defn Ecdat-Klein
  "Fetch the dataset 'Ecdat-Klein' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Klein.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Klein.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Klein.csv"))

(defn Ecdat-LaborSupply
  "Fetch the dataset 'Ecdat-LaborSupply' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/LaborSupply.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/LaborSupply.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/LaborSupply.csv"))

(defn Ecdat-Labour
  "Fetch the dataset 'Ecdat-Labour' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Labour.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Labour.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Labour.csv"))

(defn Ecdat-Longley
  "Fetch the dataset 'Ecdat-Longley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Longley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Longley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Longley.csv"))

(defn Ecdat-LT
  "Fetch the dataset 'Ecdat-LT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/LT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/LT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/LT.csv"))

(defn Ecdat-Macrodat
  "Fetch the dataset 'Ecdat-Macrodat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Macrodat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Macrodat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Macrodat.csv"))

(defn Ecdat-Males
  "Fetch the dataset 'Ecdat-Males' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Males.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Males.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Males.csv"))

(defn Ecdat-ManufCost
  "Fetch the dataset 'Ecdat-ManufCost' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/ManufCost.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/ManufCost.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/ManufCost.csv"))

(defn Ecdat-Mathlevel
  "Fetch the dataset 'Ecdat-Mathlevel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mathlevel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mathlevel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mathlevel.csv"))

(defn Ecdat-MCAS
  "Fetch the dataset 'Ecdat-MCAS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MCAS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MCAS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/MCAS.csv"))

(defn Ecdat-MedExp
  "Fetch the dataset 'Ecdat-MedExp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MedExp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MedExp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/MedExp.csv"))

(defn Ecdat-Metal
  "Fetch the dataset 'Ecdat-Metal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Metal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Metal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Metal.csv"))

(defn Ecdat-Mishkin
  "Fetch the dataset 'Ecdat-Mishkin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mishkin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mishkin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mishkin.csv"))

(defn Ecdat-Mode
  "Fetch the dataset 'Ecdat-Mode' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mode.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mode.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mode.csv"))

(defn Ecdat-ModeChoice
  "Fetch the dataset 'Ecdat-ModeChoice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/ModeChoice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/ModeChoice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/ModeChoice.csv"))

(defn Ecdat-Mofa
  "Fetch the dataset 'Ecdat-Mofa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mofa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mofa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mofa.csv"))

(defn Ecdat-Money
  "Fetch the dataset 'Ecdat-Money' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Money.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Money.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Money.csv"))

(defn Ecdat-MoneyUS
  "Fetch the dataset 'Ecdat-MoneyUS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MoneyUS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MoneyUS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/MoneyUS.csv"))

(defn Ecdat-Mpyr
  "Fetch the dataset 'Ecdat-Mpyr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mpyr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mpyr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mpyr.csv"))

(defn Ecdat-Mroz
  "Fetch the dataset 'Ecdat-Mroz' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mroz.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Mroz.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Mroz.csv"))

(defn Ecdat-MunExp
  "Fetch the dataset 'Ecdat-MunExp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MunExp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MunExp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/MunExp.csv"))

(defn Ecdat-MW
  "Fetch the dataset 'Ecdat-MW' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MW.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/MW.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/MW.csv"))

(defn Ecdat-NaturalPark
  "Fetch the dataset 'Ecdat-NaturalPark' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/NaturalPark.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/NaturalPark.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/NaturalPark.csv"))

(defn Ecdat-Nerlove
  "Fetch the dataset 'Ecdat-Nerlove' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Nerlove.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Nerlove.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Nerlove.csv"))

(defn Ecdat-nkill.byCountryYr
  "Fetch the dataset 'Ecdat-nkill.byCountryYr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nkill.byCountryYr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nkill.byCountryYr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/nkill.byCountryYr.csv"))

(defn Ecdat-nonEnglishNames
  "Fetch the dataset 'Ecdat-nonEnglishNames' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nonEnglishNames.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nonEnglishNames.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/nonEnglishNames.csv"))

(defn Ecdat-nuclearWeaponStates
  "Fetch the dataset 'Ecdat-nuclearWeaponStates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nuclearWeaponStates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/nuclearWeaponStates.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/nuclearWeaponStates.csv"))

(defn Ecdat-OCC1950
  "Fetch the dataset 'Ecdat-OCC1950' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/OCC1950.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/OCC1950.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/OCC1950.csv"))

(defn Ecdat-OFP
  "Fetch the dataset 'Ecdat-OFP' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/OFP.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/OFP.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/OFP.csv"))

(defn Ecdat-Oil
  "Fetch the dataset 'Ecdat-Oil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Oil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Oil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Oil.csv"))

(defn Ecdat-Orange
  "Fetch the dataset 'Ecdat-Orange' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Orange.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Orange.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Orange.csv"))

(defn Ecdat-Participation
  "Fetch the dataset 'Ecdat-Participation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Participation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Participation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Participation.csv"))

(defn Ecdat-PatentsHGH
  "Fetch the dataset 'Ecdat-PatentsHGH' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PatentsHGH.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PatentsHGH.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/PatentsHGH.csv"))

(defn Ecdat-PatentsRD
  "Fetch the dataset 'Ecdat-PatentsRD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PatentsRD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PatentsRD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/PatentsRD.csv"))

(defn Ecdat-PE
  "Fetch the dataset 'Ecdat-PE' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PE.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PE.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/PE.csv"))

(defn Ecdat-politicalKnowledge
  "Fetch the dataset 'Ecdat-politicalKnowledge' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/politicalKnowledge.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/politicalKnowledge.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/politicalKnowledge.csv"))

(defn Ecdat-Pound
  "Fetch the dataset 'Ecdat-Pound' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Pound.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Pound.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Pound.csv"))

(defn Ecdat-PPP
  "Fetch the dataset 'Ecdat-PPP' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PPP.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PPP.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/PPP.csv"))

(defn Ecdat-Pricing
  "Fetch the dataset 'Ecdat-Pricing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Pricing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Pricing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Pricing.csv"))

(defn Ecdat-Produc
  "Fetch the dataset 'Ecdat-Produc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Produc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Produc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Produc.csv"))

(defn Ecdat-PSID
  "Fetch the dataset 'Ecdat-PSID' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PSID.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/PSID.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/PSID.csv"))

(defn Ecdat-RetSchool
  "Fetch the dataset 'Ecdat-RetSchool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/RetSchool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/RetSchool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/RetSchool.csv"))

(defn Ecdat-Schooling
  "Fetch the dataset 'Ecdat-Schooling' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Schooling.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Schooling.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Schooling.csv"))

(defn Ecdat-Solow
  "Fetch the dataset 'Ecdat-Solow' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Solow.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Solow.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Solow.csv"))

(defn Ecdat-Somerville
  "Fetch the dataset 'Ecdat-Somerville' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Somerville.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Somerville.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Somerville.csv"))

(defn Ecdat-SP500
  "Fetch the dataset 'Ecdat-SP500' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/SP500.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/SP500.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/SP500.csv"))

(defn Ecdat-Star
  "Fetch the dataset 'Ecdat-Star' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Star.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Star.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Star.csv"))

(defn Ecdat-Strike
  "Fetch the dataset 'Ecdat-Strike' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Strike.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Strike.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Strike.csv"))

(defn Ecdat-StrikeDur
  "Fetch the dataset 'Ecdat-StrikeDur' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/StrikeDur.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/StrikeDur.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/StrikeDur.csv"))

(defn Ecdat-StrikeNb
  "Fetch the dataset 'Ecdat-StrikeNb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/StrikeNb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/StrikeNb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/StrikeNb.csv"))

(defn Ecdat-SumHes
  "Fetch the dataset 'Ecdat-SumHes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/SumHes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/SumHes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/SumHes.csv"))

(defn Ecdat-Tbrate
  "Fetch the dataset 'Ecdat-Tbrate' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tbrate.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tbrate.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Tbrate.csv"))

(defn Ecdat-terrorism
  "Fetch the dataset 'Ecdat-terrorism' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/terrorism.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/terrorism.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/terrorism.csv"))

(defn Ecdat-Tobacco
  "Fetch the dataset 'Ecdat-Tobacco' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tobacco.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tobacco.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Tobacco.csv"))

(defn Ecdat-Train
  "Fetch the dataset 'Ecdat-Train' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Train.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Train.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Train.csv"))

(defn Ecdat-TranspEq
  "Fetch the dataset 'Ecdat-TranspEq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/TranspEq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/TranspEq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/TranspEq.csv"))

(defn Ecdat-Treatment
  "Fetch the dataset 'Ecdat-Treatment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Treatment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Treatment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Treatment.csv"))

(defn Ecdat-Tuna
  "Fetch the dataset 'Ecdat-Tuna' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tuna.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Tuna.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Tuna.csv"))

(defn Ecdat-UnempDur
  "Fetch the dataset 'Ecdat-UnempDur' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/UnempDur.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/UnempDur.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/UnempDur.csv"))

(defn Ecdat-Unemployment
  "Fetch the dataset 'Ecdat-Unemployment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Unemployment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Unemployment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Unemployment.csv"))

(defn Ecdat-University
  "Fetch the dataset 'Ecdat-University' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/University.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/University.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/University.csv"))

(defn Ecdat-USclassifiedDocuments
  "Fetch the dataset 'Ecdat-USclassifiedDocuments' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USclassifiedDocuments.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USclassifiedDocuments.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USclassifiedDocuments.csv"))

(defn Ecdat-USFinanceIndustry
  "Fetch the dataset 'Ecdat-USFinanceIndustry' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USFinanceIndustry.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USFinanceIndustry.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USFinanceIndustry.csv"))

(defn Ecdat-USGDPpresidents
  "Fetch the dataset 'Ecdat-USGDPpresidents' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USGDPpresidents.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USGDPpresidents.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USGDPpresidents.csv"))

(defn Ecdat-USincarcerations
  "Fetch the dataset 'Ecdat-USincarcerations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USincarcerations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USincarcerations.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USincarcerations.csv"))

(defn Ecdat-USnewspapers
  "Fetch the dataset 'Ecdat-USnewspapers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USnewspapers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USnewspapers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USnewspapers.csv"))

(defn Ecdat-USPS
  "Fetch the dataset 'Ecdat-USPS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USPS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USPS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USPS.csv"))

(defn Ecdat-USstateAbbreviations
  "Fetch the dataset 'Ecdat-USstateAbbreviations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USstateAbbreviations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/USstateAbbreviations.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/USstateAbbreviations.csv"))

(defn Ecdat-UStaxWords
  "Fetch the dataset 'Ecdat-UStaxWords' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/UStaxWords.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/UStaxWords.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/UStaxWords.csv"))

(defn Ecdat-VietNamH
  "Fetch the dataset 'Ecdat-VietNamH' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/VietNamH.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/VietNamH.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/VietNamH.csv"))

(defn Ecdat-VietNamI
  "Fetch the dataset 'Ecdat-VietNamI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/VietNamI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/VietNamI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/VietNamI.csv"))

(defn Ecdat-Wages
  "Fetch the dataset 'Ecdat-Wages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Wages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Wages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Wages.csv"))

(defn Ecdat-Wages1
  "Fetch the dataset 'Ecdat-Wages1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Wages1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Wages1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Wages1.csv"))

(defn Ecdat-Workinghours
  "Fetch the dataset 'Ecdat-Workinghours' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Workinghours.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Workinghours.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Workinghours.csv"))

(defn Ecdat-Yen
  "Fetch the dataset 'Ecdat-Yen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Yen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Yen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Yen.csv"))

(defn Ecdat-Yogurt
  "Fetch the dataset 'Ecdat-Yogurt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Yogurt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Ecdat/Yogurt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Ecdat/Yogurt.csv"))

(defn evir-bmw
  "Fetch the dataset 'evir-bmw' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/bmw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/bmw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/bmw.csv"))

(defn evir-danish
  "Fetch the dataset 'evir-danish' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/danish.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/danish.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/danish.csv"))

(defn evir-nidd.annual
  "Fetch the dataset 'evir-nidd.annual' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/nidd.annual.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/nidd.annual.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/nidd.annual.csv"))

(defn evir-nidd.thresh
  "Fetch the dataset 'evir-nidd.thresh' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/nidd.thresh.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/nidd.thresh.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/nidd.thresh.csv"))

(defn evir-siemens
  "Fetch the dataset 'evir-siemens' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/siemens.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/siemens.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/siemens.csv"))

(defn evir-sp.raw
  "Fetch the dataset 'evir-sp.raw' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/sp.raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/sp.raw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/sp.raw.csv"))

(defn evir-spto87
  "Fetch the dataset 'evir-spto87' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/evir/spto87.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/evir/spto87.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/evir/spto87.csv"))

(defn forecast-gas
  "Fetch the dataset 'forecast-gas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/forecast/gas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/forecast/gas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/forecast/gas.csv"))

(defn forecast-gold
  "Fetch the dataset 'forecast-gold' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/forecast/gold.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/forecast/gold.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/forecast/gold.csv"))

(defn forecast-taylor
  "Fetch the dataset 'forecast-taylor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/forecast/taylor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/forecast/taylor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/forecast/taylor.csv"))

(defn forecast-wineind
  "Fetch the dataset 'forecast-wineind' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/forecast/wineind.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/forecast/wineind.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/forecast/wineind.csv"))

(defn forecast-woolyrnq
  "Fetch the dataset 'forecast-woolyrnq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/forecast/woolyrnq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/forecast/woolyrnq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/forecast/woolyrnq.csv"))

(defn fpp2-a10
  "Fetch the dataset 'fpp2-a10' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/a10.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/a10.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/a10.csv"))

(defn fpp2-arrivals
  "Fetch the dataset 'fpp2-arrivals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/arrivals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/arrivals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/arrivals.csv"))

(defn fpp2-ausair
  "Fetch the dataset 'fpp2-ausair' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/ausair.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/ausair.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/ausair.csv"))

(defn fpp2-ausbeer
  "Fetch the dataset 'fpp2-ausbeer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/ausbeer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/ausbeer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/ausbeer.csv"))

(defn fpp2-auscafe
  "Fetch the dataset 'fpp2-auscafe' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/auscafe.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/auscafe.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/auscafe.csv"))

(defn fpp2-austa
  "Fetch the dataset 'fpp2-austa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/austa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/austa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/austa.csv"))

(defn fpp2-austourists
  "Fetch the dataset 'fpp2-austourists' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/austourists.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/austourists.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/austourists.csv"))

(defn fpp2-calls
  "Fetch the dataset 'fpp2-calls' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/calls.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/calls.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/calls.csv"))

(defn fpp2-debitcards
  "Fetch the dataset 'fpp2-debitcards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/debitcards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/debitcards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/debitcards.csv"))

(defn fpp2-departures
  "Fetch the dataset 'fpp2-departures' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/departures.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/departures.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/departures.csv"))

(defn fpp2-elecdaily
  "Fetch the dataset 'fpp2-elecdaily' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecdaily.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecdaily.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/elecdaily.csv"))

(defn fpp2-elecdemand
  "Fetch the dataset 'fpp2-elecdemand' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecdemand.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecdemand.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/elecdemand.csv"))

(defn fpp2-elecequip
  "Fetch the dataset 'fpp2-elecequip' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecequip.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecequip.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/elecequip.csv"))

(defn fpp2-elecsales
  "Fetch the dataset 'fpp2-elecsales' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecsales.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/elecsales.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/elecsales.csv"))

(defn fpp2-euretail
  "Fetch the dataset 'fpp2-euretail' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/euretail.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/euretail.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/euretail.csv"))

(defn fpp2-gasoline
  "Fetch the dataset 'fpp2-gasoline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/gasoline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/gasoline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/gasoline.csv"))

(defn fpp2-goog
  "Fetch the dataset 'fpp2-goog' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/goog.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/goog.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/goog.csv"))

(defn fpp2-goog200
  "Fetch the dataset 'fpp2-goog200' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/goog200.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/goog200.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/goog200.csv"))

(defn fpp2-guinearice
  "Fetch the dataset 'fpp2-guinearice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/guinearice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/guinearice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/guinearice.csv"))

(defn fpp2-h02
  "Fetch the dataset 'fpp2-h02' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/h02.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/h02.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/h02.csv"))

(defn fpp2-hyndsight
  "Fetch the dataset 'fpp2-hyndsight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/hyndsight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/hyndsight.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/hyndsight.csv"))

(defn fpp2-insurance
  "Fetch the dataset 'fpp2-insurance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/insurance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/insurance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/insurance.csv"))

(defn fpp2-livestock
  "Fetch the dataset 'fpp2-livestock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/livestock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/livestock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/livestock.csv"))

(defn fpp2-marathon
  "Fetch the dataset 'fpp2-marathon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/marathon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/marathon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/marathon.csv"))

(defn fpp2-maxtemp
  "Fetch the dataset 'fpp2-maxtemp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/maxtemp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/maxtemp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/maxtemp.csv"))

(defn fpp2-melsyd
  "Fetch the dataset 'fpp2-melsyd' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/melsyd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/melsyd.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/melsyd.csv"))

(defn fpp2-mens400
  "Fetch the dataset 'fpp2-mens400' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/mens400.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/mens400.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/mens400.csv"))

(defn fpp2-oil
  "Fetch the dataset 'fpp2-oil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/oil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/oil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/oil.csv"))

(defn fpp2-prison
  "Fetch the dataset 'fpp2-prison' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/prison.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/prison.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/prison.csv"))

(defn fpp2-prisonLF
  "Fetch the dataset 'fpp2-prisonLF' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/prisonLF.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/prisonLF.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/prisonLF.csv"))

(defn fpp2-qauselec
  "Fetch the dataset 'fpp2-qauselec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qauselec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qauselec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/qauselec.csv"))

(defn fpp2-qcement
  "Fetch the dataset 'fpp2-qcement' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qcement.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qcement.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/qcement.csv"))

(defn fpp2-qgas
  "Fetch the dataset 'fpp2-qgas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qgas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/qgas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/qgas.csv"))

(defn fpp2-sunspotarea
  "Fetch the dataset 'fpp2-sunspotarea' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/sunspotarea.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/sunspotarea.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/sunspotarea.csv"))

(defn fpp2-uschange
  "Fetch the dataset 'fpp2-uschange' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/uschange.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/uschange.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/uschange.csv"))

(defn fpp2-usmelec
  "Fetch the dataset 'fpp2-usmelec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/usmelec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/usmelec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/usmelec.csv"))

(defn fpp2-visnights
  "Fetch the dataset 'fpp2-visnights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/visnights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/visnights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/visnights.csv"))

(defn fpp2-wmurders
  "Fetch the dataset 'fpp2-wmurders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/wmurders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp2/wmurders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp2/wmurders.csv"))

(defn fpp3-aus_accommodation
  "Fetch the dataset 'fpp3-aus_accommodation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_accommodation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_accommodation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_accommodation.csv"))

(defn fpp3-aus_airpassengers
  "Fetch the dataset 'fpp3-aus_airpassengers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_airpassengers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_airpassengers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_airpassengers.csv"))

(defn fpp3-aus_arrivals
  "Fetch the dataset 'fpp3-aus_arrivals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_arrivals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_arrivals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_arrivals.csv"))

(defn fpp3-aus_births
  "Fetch the dataset 'fpp3-aus_births' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_births.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_births.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_births.csv"))

(defn fpp3-aus_fertility
  "Fetch the dataset 'fpp3-aus_fertility' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_fertility.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_fertility.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_fertility.csv"))

(defn fpp3-aus_inbound
  "Fetch the dataset 'fpp3-aus_inbound' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_inbound.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_inbound.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_inbound.csv"))

(defn fpp3-aus_migration
  "Fetch the dataset 'fpp3-aus_migration' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_migration.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_migration.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_migration.csv"))

(defn fpp3-aus_mortality
  "Fetch the dataset 'fpp3-aus_mortality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_mortality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_mortality.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_mortality.csv"))

(defn fpp3-aus_outbound
  "Fetch the dataset 'fpp3-aus_outbound' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_outbound.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_outbound.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_outbound.csv"))

(defn fpp3-aus_tobacco
  "Fetch the dataset 'fpp3-aus_tobacco' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_tobacco.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_tobacco.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_tobacco.csv"))

(defn fpp3-aus_vehicle_sales
  "Fetch the dataset 'fpp3-aus_vehicle_sales' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_vehicle_sales.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/aus_vehicle_sales.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/aus_vehicle_sales.csv"))

(defn fpp3-bank_calls
  "Fetch the dataset 'fpp3-bank_calls' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/bank_calls.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/bank_calls.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/bank_calls.csv"))

(defn fpp3-boston_marathon
  "Fetch the dataset 'fpp3-boston_marathon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/boston_marathon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/boston_marathon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/boston_marathon.csv"))

(defn fpp3-canadian_gas
  "Fetch the dataset 'fpp3-canadian_gas' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/canadian_gas.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/canadian_gas.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/canadian_gas.csv"))

(defn fpp3-guinea_rice
  "Fetch the dataset 'fpp3-guinea_rice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/guinea_rice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/guinea_rice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/guinea_rice.csv"))

(defn fpp3-insurance
  "Fetch the dataset 'fpp3-insurance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/insurance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/insurance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/insurance.csv"))

(defn fpp3-melb_walkers
  "Fetch the dataset 'fpp3-melb_walkers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/melb_walkers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/melb_walkers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/melb_walkers.csv"))

(defn fpp3-nsw_offences
  "Fetch the dataset 'fpp3-nsw_offences' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/nsw_offences.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/nsw_offences.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/nsw_offences.csv"))

(defn fpp3-ny_childcare
  "Fetch the dataset 'fpp3-ny_childcare' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/ny_childcare.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/ny_childcare.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/ny_childcare.csv"))

(defn fpp3-otexts_views
  "Fetch the dataset 'fpp3-otexts_views' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/otexts_views.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/otexts_views.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/otexts_views.csv"))

(defn fpp3-prices
  "Fetch the dataset 'fpp3-prices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/prices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/prices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/prices.csv"))

(defn fpp3-souvenirs
  "Fetch the dataset 'fpp3-souvenirs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/souvenirs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/souvenirs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/souvenirs.csv"))

(defn fpp3-us_change
  "Fetch the dataset 'fpp3-us_change' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_change.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_change.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/us_change.csv"))

(defn fpp3-us_employment
  "Fetch the dataset 'fpp3-us_employment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_employment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_employment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/us_employment.csv"))

(defn fpp3-us_gasoline
  "Fetch the dataset 'fpp3-us_gasoline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_gasoline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/fpp3/us_gasoline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/fpp3/us_gasoline.csv"))

(defn gap-hg18
  "Fetch the dataset 'gap-hg18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg18.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg18.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gap/hg18.csv"))

(defn gap-hg19
  "Fetch the dataset 'gap-hg19' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg19.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg19.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gap/hg19.csv"))

(defn gap-hg38
  "Fetch the dataset 'gap-hg38' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg38.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gap/hg38.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gap/hg38.csv"))

(defn gapminder-continent_colors
  "Fetch the dataset 'gapminder-continent_colors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/continent_colors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/continent_colors.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/gapminder/continent_colors.csv"))

(defn gapminder-country_codes
  "Fetch the dataset 'gapminder-country_codes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/country_codes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/country_codes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gapminder/country_codes.csv"))

(defn gapminder-country_colors
  "Fetch the dataset 'gapminder-country_colors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/country_colors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/country_colors.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gapminder/country_colors.csv"))

(defn gapminder-gapminder
  "Fetch the dataset 'gapminder-gapminder' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/gapminder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/gapminder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gapminder/gapminder.csv"))

(defn gapminder-gapminder_unfiltered
  "Fetch the dataset 'gapminder-gapminder_unfiltered' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/gapminder_unfiltered.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/gapminder/gapminder_unfiltered.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/gapminder/gapminder_unfiltered.csv"))

(defn geepack-dietox
  "Fetch the dataset 'geepack-dietox' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/dietox.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/dietox.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/dietox.csv"))

(defn geepack-koch
  "Fetch the dataset 'geepack-koch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/koch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/koch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/koch.csv"))

(defn geepack-muscatine
  "Fetch the dataset 'geepack-muscatine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/muscatine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/muscatine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/muscatine.csv"))

(defn geepack-ohio
  "Fetch the dataset 'geepack-ohio' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/ohio.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/ohio.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/ohio.csv"))

(defn geepack-respdis
  "Fetch the dataset 'geepack-respdis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/respdis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/respdis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/respdis.csv"))

(defn geepack-respiratory
  "Fetch the dataset 'geepack-respiratory' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/respiratory.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/respiratory.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/respiratory.csv"))

(defn geepack-seizure
  "Fetch the dataset 'geepack-seizure' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/seizure.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/seizure.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/seizure.csv"))

(defn geepack-sitka89
  "Fetch the dataset 'geepack-sitka89' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/sitka89.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/sitka89.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/sitka89.csv"))

(defn geepack-spruce
  "Fetch the dataset 'geepack-spruce' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/geepack/spruce.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/geepack/spruce.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/geepack/spruce.csv"))

(defn ggplot2-diamonds
  "Fetch the dataset 'ggplot2-diamonds' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/diamonds.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/diamonds.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/diamonds.csv"))

(defn ggplot2-economics
  "Fetch the dataset 'ggplot2-economics' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/economics.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/economics.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/economics.csv"))

(defn ggplot2-economics_long
  "Fetch the dataset 'ggplot2-economics_long' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/economics_long.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/economics_long.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/economics_long.csv"))

(defn ggplot2-faithfuld
  "Fetch the dataset 'ggplot2-faithfuld' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/faithfuld.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/faithfuld.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/faithfuld.csv"))

(defn ggplot2-luv_colours
  "Fetch the dataset 'ggplot2-luv_colours' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/luv_colours.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/luv_colours.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/luv_colours.csv"))

(defn ggplot2-midwest
  "Fetch the dataset 'ggplot2-midwest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/midwest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/midwest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/midwest.csv"))

(defn ggplot2-mpg
  "Fetch the dataset 'ggplot2-mpg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/mpg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/mpg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/mpg.csv"))

(defn ggplot2-msleep
  "Fetch the dataset 'ggplot2-msleep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/msleep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/msleep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/msleep.csv"))

(defn ggplot2-presidential
  "Fetch the dataset 'ggplot2-presidential' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/presidential.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/presidential.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/presidential.csv"))

(defn ggplot2-seals
  "Fetch the dataset 'ggplot2-seals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/seals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/seals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/seals.csv"))

(defn ggplot2-txhousing
  "Fetch the dataset 'ggplot2-txhousing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/txhousing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2/txhousing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2/txhousing.csv"))

(defn ggplot2movies-movies
  "Fetch the dataset 'ggplot2movies-movies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2movies/movies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ggplot2movies/movies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2movies/movies.csv"))

(defn gt-constants
  "Fetch the dataset 'gt-constants' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/constants.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/constants.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/constants.csv"))

(defn gt-countrypops
  "Fetch the dataset 'gt-countrypops' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/countrypops.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/countrypops.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/countrypops.csv"))

(defn gt-exibble
  "Fetch the dataset 'gt-exibble' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/exibble.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/exibble.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/exibble.csv"))

(defn gt-films
  "Fetch the dataset 'gt-films' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/films.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/films.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/films.csv"))

(defn gt-gibraltar
  "Fetch the dataset 'gt-gibraltar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/gibraltar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/gibraltar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/gibraltar.csv"))

(defn gt-gtcars
  "Fetch the dataset 'gt-gtcars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/gtcars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/gtcars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/gtcars.csv"))

(defn gt-illness
  "Fetch the dataset 'gt-illness' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/illness.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/illness.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/illness.csv"))

(defn gt-metro
  "Fetch the dataset 'gt-metro' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/metro.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/metro.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/metro.csv"))

(defn gt-nuclides
  "Fetch the dataset 'gt-nuclides' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/nuclides.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/nuclides.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/nuclides.csv"))

(defn gt-peeps
  "Fetch the dataset 'gt-peeps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/peeps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/peeps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/peeps.csv"))

(defn gt-photolysis
  "Fetch the dataset 'gt-photolysis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/photolysis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/photolysis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/photolysis.csv"))

(defn gt-pizzaplace
  "Fetch the dataset 'gt-pizzaplace' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/pizzaplace.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/pizzaplace.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/pizzaplace.csv"))

(defn gt-reactions
  "Fetch the dataset 'gt-reactions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/reactions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/reactions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/reactions.csv"))

(defn gt-rx_addv
  "Fetch the dataset 'gt-rx_addv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/rx_addv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/rx_addv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/rx_addv.csv"))

(defn gt-rx_adsl
  "Fetch the dataset 'gt-rx_adsl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/rx_adsl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/rx_adsl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/rx_adsl.csv"))

(defn gt-sp500
  "Fetch the dataset 'gt-sp500' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/sp500.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/sp500.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/sp500.csv"))

(defn gt-sza
  "Fetch the dataset 'gt-sza' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/sza.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/sza.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/sza.csv"))

(defn gt-towny
  "Fetch the dataset 'gt-towny' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/gt/towny.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/gt/towny.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/gt/towny.csv"))

(defn heplots-AddHealth
  "Fetch the dataset 'heplots-AddHealth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/AddHealth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/AddHealth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/AddHealth.csv"))

(defn heplots-Adopted
  "Fetch the dataset 'heplots-Adopted' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Adopted.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Adopted.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Adopted.csv"))

(defn heplots-Bees
  "Fetch the dataset 'heplots-Bees' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Bees.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Bees.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Bees.csv"))

(defn heplots-Diabetes
  "Fetch the dataset 'heplots-Diabetes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Diabetes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Diabetes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Diabetes.csv"))

(defn heplots-FootHead
  "Fetch the dataset 'heplots-FootHead' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/FootHead.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/FootHead.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/FootHead.csv"))

(defn heplots-Headache
  "Fetch the dataset 'heplots-Headache' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Headache.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Headache.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Headache.csv"))

(defn heplots-Hernior
  "Fetch the dataset 'heplots-Hernior' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Hernior.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Hernior.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Hernior.csv"))

(defn heplots-Iwasaki_Big_Five
  "Fetch the dataset 'heplots-Iwasaki_Big_Five' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Iwasaki_Big_Five.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Iwasaki_Big_Five.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Iwasaki_Big_Five.csv"))

(defn heplots-mathscore
  "Fetch the dataset 'heplots-mathscore' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/mathscore.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/mathscore.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/mathscore.csv"))

(defn heplots-MockJury
  "Fetch the dataset 'heplots-MockJury' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/MockJury.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/MockJury.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/MockJury.csv"))

(defn heplots-NeuroCog
  "Fetch the dataset 'heplots-NeuroCog' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/NeuroCog.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/NeuroCog.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/NeuroCog.csv"))

(defn heplots-NLSY
  "Fetch the dataset 'heplots-NLSY' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/NLSY.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/NLSY.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/NLSY.csv"))

(defn heplots-Oslo
  "Fetch the dataset 'heplots-Oslo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Oslo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Oslo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Oslo.csv"))

(defn heplots-Overdose
  "Fetch the dataset 'heplots-Overdose' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Overdose.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Overdose.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Overdose.csv"))

(defn heplots-Parenting
  "Fetch the dataset 'heplots-Parenting' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Parenting.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Parenting.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Parenting.csv"))

(defn heplots-peng
  "Fetch the dataset 'heplots-peng' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/peng.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/peng.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/peng.csv"))

(defn heplots-Plastic
  "Fetch the dataset 'heplots-Plastic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Plastic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Plastic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Plastic.csv"))

(defn heplots-Pottery2
  "Fetch the dataset 'heplots-Pottery2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Pottery2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Pottery2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Pottery2.csv"))

(defn heplots-Probe1
  "Fetch the dataset 'heplots-Probe1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Probe1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Probe1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Probe1.csv"))

(defn heplots-Probe2
  "Fetch the dataset 'heplots-Probe2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Probe2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Probe2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Probe2.csv"))

(defn heplots-RatWeight
  "Fetch the dataset 'heplots-RatWeight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/RatWeight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/RatWeight.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/RatWeight.csv"))

(defn heplots-ReactTime
  "Fetch the dataset 'heplots-ReactTime' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/ReactTime.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/ReactTime.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/ReactTime.csv"))

(defn heplots-Rohwer
  "Fetch the dataset 'heplots-Rohwer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Rohwer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Rohwer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Rohwer.csv"))

(defn heplots-RootStock
  "Fetch the dataset 'heplots-RootStock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/RootStock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/RootStock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/RootStock.csv"))

(defn heplots-Sake
  "Fetch the dataset 'heplots-Sake' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Sake.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Sake.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Sake.csv"))

(defn heplots-schooldata
  "Fetch the dataset 'heplots-schooldata' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/schooldata.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/schooldata.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/schooldata.csv"))

(defn heplots-Skulls
  "Fetch the dataset 'heplots-Skulls' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Skulls.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/Skulls.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/Skulls.csv"))

(defn heplots-SocGrades
  "Fetch the dataset 'heplots-SocGrades' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/SocGrades.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/SocGrades.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/SocGrades.csv"))

(defn heplots-SocialCog
  "Fetch the dataset 'heplots-SocialCog' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/SocialCog.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/SocialCog.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/SocialCog.csv"))

(defn heplots-TIPI
  "Fetch the dataset 'heplots-TIPI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/TIPI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/TIPI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/TIPI.csv"))

(defn heplots-VocabGrowth
  "Fetch the dataset 'heplots-VocabGrowth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/VocabGrowth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/VocabGrowth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/VocabGrowth.csv"))

(defn heplots-WeightLoss
  "Fetch the dataset 'heplots-WeightLoss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/heplots/WeightLoss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/heplots/WeightLoss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/heplots/WeightLoss.csv"))

(defn HistData-Arbuthnot
  "Fetch the dataset 'HistData-Arbuthnot' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Arbuthnot.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Arbuthnot.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Arbuthnot.csv"))

(defn HistData-Armada
  "Fetch the dataset 'HistData-Armada' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Armada.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Armada.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Armada.csv"))

(defn HistData-Bowley
  "Fetch the dataset 'HistData-Bowley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Bowley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Bowley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Bowley.csv"))

(defn HistData-Breslau
  "Fetch the dataset 'HistData-Breslau' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Breslau.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Breslau.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Breslau.csv"))

(defn HistData-Cavendish
  "Fetch the dataset 'HistData-Cavendish' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Cavendish.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Cavendish.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Cavendish.csv"))

(defn HistData-ChestSizes
  "Fetch the dataset 'HistData-ChestSizes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ChestSizes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ChestSizes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/ChestSizes.csv"))

(defn HistData-ChestStigler
  "Fetch the dataset 'HistData-ChestStigler' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ChestStigler.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ChestStigler.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/ChestStigler.csv"))

(defn HistData-Cholera
  "Fetch the dataset 'HistData-Cholera' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Cholera.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Cholera.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Cholera.csv"))

(defn HistData-CholeraDeaths1849
  "Fetch the dataset 'HistData-CholeraDeaths1849' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CholeraDeaths1849.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CholeraDeaths1849.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/CholeraDeaths1849.csv"))

(defn HistData-CushnyPeebles
  "Fetch the dataset 'HistData-CushnyPeebles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CushnyPeebles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CushnyPeebles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/CushnyPeebles.csv"))

(defn HistData-CushnyPeeblesN
  "Fetch the dataset 'HistData-CushnyPeeblesN' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CushnyPeeblesN.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/CushnyPeeblesN.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/CushnyPeeblesN.csv"))

(defn HistData-Dactyl
  "Fetch the dataset 'HistData-Dactyl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Dactyl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Dactyl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Dactyl.csv"))

(defn HistData-DrinksWages
  "Fetch the dataset 'HistData-DrinksWages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/DrinksWages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/DrinksWages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/DrinksWages.csv"))

(defn HistData-EdgeworthDeaths
  "Fetch the dataset 'HistData-EdgeworthDeaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/EdgeworthDeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/EdgeworthDeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/EdgeworthDeaths.csv"))

(defn HistData-Fingerprints
  "Fetch the dataset 'HistData-Fingerprints' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Fingerprints.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Fingerprints.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Fingerprints.csv"))

(defn HistData-Galton
  "Fetch the dataset 'HistData-Galton' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Galton.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Galton.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Galton.csv"))

(defn HistData-GaltonFamilies
  "Fetch the dataset 'HistData-GaltonFamilies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/GaltonFamilies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/GaltonFamilies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/GaltonFamilies.csv"))

(defn HistData-Guerry
  "Fetch the dataset 'HistData-Guerry' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Guerry.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Guerry.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Guerry.csv"))

(defn HistData-HalleyLifeTable
  "Fetch the dataset 'HistData-HalleyLifeTable' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/HalleyLifeTable.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/HalleyLifeTable.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/HalleyLifeTable.csv"))

(defn HistData-Jevons
  "Fetch the dataset 'HistData-Jevons' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Jevons.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Jevons.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Jevons.csv"))

(defn HistData-Langren.all
  "Fetch the dataset 'HistData-Langren.all' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Langren.all.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Langren.all.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Langren.all.csv"))

(defn HistData-Langren1644
  "Fetch the dataset 'HistData-Langren1644' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Langren1644.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Langren1644.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Langren1644.csv"))

(defn HistData-Macdonell
  "Fetch the dataset 'HistData-Macdonell' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Macdonell.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Macdonell.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Macdonell.csv"))

(defn HistData-MacdonellDF
  "Fetch the dataset 'HistData-MacdonellDF' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/MacdonellDF.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/MacdonellDF.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/MacdonellDF.csv"))

(defn HistData-Mayer
  "Fetch the dataset 'HistData-Mayer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Mayer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Mayer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Mayer.csv"))

(defn HistData-Michelson
  "Fetch the dataset 'HistData-Michelson' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Michelson.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Michelson.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Michelson.csv"))

(defn HistData-MichelsonSets
  "Fetch the dataset 'HistData-MichelsonSets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/MichelsonSets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/MichelsonSets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/MichelsonSets.csv"))

(defn HistData-Minard.cities
  "Fetch the dataset 'HistData-Minard.cities' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.cities.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.cities.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Minard.cities.csv"))

(defn HistData-Minard.temp
  "Fetch the dataset 'HistData-Minard.temp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.temp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.temp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Minard.temp.csv"))

(defn HistData-Minard.troops
  "Fetch the dataset 'HistData-Minard.troops' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.troops.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Minard.troops.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Minard.troops.csv"))

(defn HistData-Nightingale
  "Fetch the dataset 'HistData-Nightingale' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Nightingale.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Nightingale.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Nightingale.csv"))

(defn HistData-OldMaps
  "Fetch the dataset 'HistData-OldMaps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/OldMaps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/OldMaps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/OldMaps.csv"))

(defn HistData-PearsonLee
  "Fetch the dataset 'HistData-PearsonLee' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/PearsonLee.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/PearsonLee.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/PearsonLee.csv"))

(defn HistData-PolioTrials
  "Fetch the dataset 'HistData-PolioTrials' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/PolioTrials.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/PolioTrials.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/PolioTrials.csv"))

(defn HistData-Pollen
  "Fetch the dataset 'HistData-Pollen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Pollen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Pollen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Pollen.csv"))

(defn HistData-Prostitutes
  "Fetch the dataset 'HistData-Prostitutes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Prostitutes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Prostitutes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Prostitutes.csv"))

(defn HistData-Pyx
  "Fetch the dataset 'HistData-Pyx' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Pyx.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Pyx.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Pyx.csv"))

(defn HistData-Quarrels
  "Fetch the dataset 'HistData-Quarrels' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Quarrels.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Quarrels.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Quarrels.csv"))

(defn HistData-Saturn
  "Fetch the dataset 'HistData-Saturn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Saturn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Saturn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Saturn.csv"))

(defn HistData-Snow.dates
  "Fetch the dataset 'HistData-Snow.dates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.dates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.dates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Snow.dates.csv"))

(defn HistData-Snow.deaths
  "Fetch the dataset 'HistData-Snow.deaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.deaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.deaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Snow.deaths.csv"))

(defn HistData-Snow.deaths2
  "Fetch the dataset 'HistData-Snow.deaths2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.deaths2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.deaths2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Snow.deaths2.csv"))

(defn HistData-Snow.pumps
  "Fetch the dataset 'HistData-Snow.pumps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.pumps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.pumps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Snow.pumps.csv"))

(defn HistData-Snow.streets
  "Fetch the dataset 'HistData-Snow.streets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.streets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Snow.streets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Snow.streets.csv"))

(defn HistData-Virginis
  "Fetch the dataset 'HistData-Virginis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Virginis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Virginis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Virginis.csv"))

(defn HistData-Virginis.interp
  "Fetch the dataset 'HistData-Virginis.interp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Virginis.interp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Virginis.interp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Virginis.interp.csv"))

(defn HistData-Wheat
  "Fetch the dataset 'HistData-Wheat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Wheat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Wheat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Wheat.csv"))

(defn HistData-Wheat.monarchs
  "Fetch the dataset 'HistData-Wheat.monarchs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Wheat.monarchs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Wheat.monarchs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Wheat.monarchs.csv"))

(defn HistData-Yeast
  "Fetch the dataset 'HistData-Yeast' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Yeast.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/Yeast.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/Yeast.csv"))

(defn HistData-YeastD.mat
  "Fetch the dataset 'HistData-YeastD.mat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/YeastD.mat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/YeastD.mat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/YeastD.mat.csv"))

(defn HistData-ZeaMays
  "Fetch the dataset 'HistData-ZeaMays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ZeaMays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HistData/ZeaMays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HistData/ZeaMays.csv"))

(defn HLMdiag-ahd
  "Fetch the dataset 'HLMdiag-ahd' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/ahd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/ahd.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HLMdiag/ahd.csv"))

(defn HLMdiag-autism
  "Fetch the dataset 'HLMdiag-autism' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/autism.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/autism.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HLMdiag/autism.csv"))

(defn HLMdiag-radon
  "Fetch the dataset 'HLMdiag-radon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/radon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/radon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HLMdiag/radon.csv"))

(defn HLMdiag-wages
  "Fetch the dataset 'HLMdiag-wages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/wages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HLMdiag/wages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HLMdiag/wages.csv"))

(defn HSAUR-agefat
  "Fetch the dataset 'HSAUR-agefat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/agefat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/agefat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/agefat.csv"))

(defn HSAUR-aspirin
  "Fetch the dataset 'HSAUR-aspirin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/aspirin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/aspirin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/aspirin.csv"))

(defn HSAUR-BCG
  "Fetch the dataset 'HSAUR-BCG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/BCG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/BCG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/BCG.csv"))

(defn HSAUR-birthdeathrates
  "Fetch the dataset 'HSAUR-birthdeathrates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/birthdeathrates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/birthdeathrates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/birthdeathrates.csv"))

(defn HSAUR-bladdercancer
  "Fetch the dataset 'HSAUR-bladdercancer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/bladdercancer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/bladdercancer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/bladdercancer.csv"))

(defn HSAUR-BtheB
  "Fetch the dataset 'HSAUR-BtheB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/BtheB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/BtheB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/BtheB.csv"))

(defn HSAUR-clouds
  "Fetch the dataset 'HSAUR-clouds' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/clouds.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/clouds.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/clouds.csv"))

(defn HSAUR-CYGOB1
  "Fetch the dataset 'HSAUR-CYGOB1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/CYGOB1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/CYGOB1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/CYGOB1.csv"))

(defn HSAUR-epilepsy
  "Fetch the dataset 'HSAUR-epilepsy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/epilepsy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/epilepsy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/epilepsy.csv"))

(defn HSAUR-Forbes2000
  "Fetch the dataset 'HSAUR-Forbes2000' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/Forbes2000.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/Forbes2000.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/Forbes2000.csv"))

(defn HSAUR-foster
  "Fetch the dataset 'HSAUR-foster' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/foster.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/foster.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/foster.csv"))

(defn HSAUR-gardenflowers
  "Fetch the dataset 'HSAUR-gardenflowers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/gardenflowers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/gardenflowers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/gardenflowers.csv"))

(defn HSAUR-GHQ
  "Fetch the dataset 'HSAUR-GHQ' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/GHQ.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/GHQ.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/GHQ.csv"))

(defn HSAUR-heptathlon
  "Fetch the dataset 'HSAUR-heptathlon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/heptathlon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/heptathlon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/heptathlon.csv"))

(defn HSAUR-Lanza
  "Fetch the dataset 'HSAUR-Lanza' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/Lanza.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/Lanza.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/Lanza.csv"))

(defn HSAUR-mastectomy
  "Fetch the dataset 'HSAUR-mastectomy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/mastectomy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/mastectomy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/mastectomy.csv"))

(defn HSAUR-meteo
  "Fetch the dataset 'HSAUR-meteo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/meteo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/meteo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/meteo.csv"))

(defn HSAUR-orallesions
  "Fetch the dataset 'HSAUR-orallesions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/orallesions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/orallesions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/orallesions.csv"))

(defn HSAUR-phosphate
  "Fetch the dataset 'HSAUR-phosphate' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/phosphate.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/phosphate.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/phosphate.csv"))

(defn HSAUR-pistonrings
  "Fetch the dataset 'HSAUR-pistonrings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/pistonrings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/pistonrings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/pistonrings.csv"))

(defn HSAUR-planets
  "Fetch the dataset 'HSAUR-planets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/planets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/planets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/planets.csv"))

(defn HSAUR-plasma
  "Fetch the dataset 'HSAUR-plasma' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/plasma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/plasma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/plasma.csv"))

(defn HSAUR-polyps
  "Fetch the dataset 'HSAUR-polyps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/polyps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/polyps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/polyps.csv"))

(defn HSAUR-polyps3
  "Fetch the dataset 'HSAUR-polyps3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/polyps3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/polyps3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/polyps3.csv"))

(defn HSAUR-pottery
  "Fetch the dataset 'HSAUR-pottery' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/pottery.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/pottery.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/pottery.csv"))

(defn HSAUR-rearrests
  "Fetch the dataset 'HSAUR-rearrests' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/rearrests.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/rearrests.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/rearrests.csv"))

(defn HSAUR-respiratory
  "Fetch the dataset 'HSAUR-respiratory' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/respiratory.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/respiratory.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/respiratory.csv"))

(defn HSAUR-roomwidth
  "Fetch the dataset 'HSAUR-roomwidth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/roomwidth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/roomwidth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/roomwidth.csv"))

(defn HSAUR-schizophrenia
  "Fetch the dataset 'HSAUR-schizophrenia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schizophrenia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schizophrenia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/schizophrenia.csv"))

(defn HSAUR-schizophrenia2
  "Fetch the dataset 'HSAUR-schizophrenia2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schizophrenia2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schizophrenia2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/schizophrenia2.csv"))

(defn HSAUR-schooldays
  "Fetch the dataset 'HSAUR-schooldays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schooldays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/schooldays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/schooldays.csv"))

(defn HSAUR-skulls
  "Fetch the dataset 'HSAUR-skulls' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/skulls.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/skulls.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/skulls.csv"))

(defn HSAUR-smoking
  "Fetch the dataset 'HSAUR-smoking' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/smoking.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/smoking.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/smoking.csv"))

(defn HSAUR-students
  "Fetch the dataset 'HSAUR-students' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/students.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/students.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/students.csv"))

(defn HSAUR-suicides
  "Fetch the dataset 'HSAUR-suicides' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/suicides.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/suicides.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/suicides.csv"))

(defn HSAUR-toothpaste
  "Fetch the dataset 'HSAUR-toothpaste' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/toothpaste.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/toothpaste.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/toothpaste.csv"))

(defn HSAUR-voting
  "Fetch the dataset 'HSAUR-voting' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/voting.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/voting.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/voting.csv"))

(defn HSAUR-water
  "Fetch the dataset 'HSAUR-water' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/water.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/water.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/water.csv"))

(defn HSAUR-watervoles
  "Fetch the dataset 'HSAUR-watervoles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/watervoles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/watervoles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/watervoles.csv"))

(defn HSAUR-waves
  "Fetch the dataset 'HSAUR-waves' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/waves.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/waves.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/waves.csv"))

(defn HSAUR-weightgain
  "Fetch the dataset 'HSAUR-weightgain' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/weightgain.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/weightgain.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/weightgain.csv"))

(defn HSAUR-womensrole
  "Fetch the dataset 'HSAUR-womensrole' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/womensrole.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/HSAUR/womensrole.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/HSAUR/womensrole.csv"))

(defn hwde-IndianIrish
  "Fetch the dataset 'hwde-IndianIrish' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/hwde/IndianIrish.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/hwde/IndianIrish.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/hwde/IndianIrish.csv"))

(defn hwde-mendelABC
  "Fetch the dataset 'hwde-mendelABC' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/hwde/mendelABC.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/hwde/mendelABC.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/hwde/mendelABC.csv"))

(defn ISLR-Auto
  "Fetch the dataset 'ISLR-Auto' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Auto.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Auto.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Auto.csv"))

(defn ISLR-Caravan
  "Fetch the dataset 'ISLR-Caravan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Caravan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Caravan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Caravan.csv"))

(defn ISLR-Carseats
  "Fetch the dataset 'ISLR-Carseats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Carseats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Carseats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Carseats.csv"))

(defn ISLR-College
  "Fetch the dataset 'ISLR-College' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/College.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/College.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/College.csv"))

(defn ISLR-Credit
  "Fetch the dataset 'ISLR-Credit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Credit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Credit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Credit.csv"))

(defn ISLR-Default
  "Fetch the dataset 'ISLR-Default' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Default.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Default.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Default.csv"))

(defn ISLR-Hitters
  "Fetch the dataset 'ISLR-Hitters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Hitters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Hitters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Hitters.csv"))

(defn ISLR-NCI60
  "Fetch the dataset 'ISLR-NCI60' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/NCI60.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/NCI60.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/NCI60.csv"))

(defn ISLR-OJ
  "Fetch the dataset 'ISLR-OJ' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/OJ.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/OJ.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/OJ.csv"))

(defn ISLR-Portfolio
  "Fetch the dataset 'ISLR-Portfolio' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Portfolio.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Portfolio.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Portfolio.csv"))

(defn ISLR-Smarket
  "Fetch the dataset 'ISLR-Smarket' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Smarket.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Smarket.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Smarket.csv"))

(defn ISLR-Wage
  "Fetch the dataset 'ISLR-Wage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Wage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Wage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Wage.csv"))

(defn ISLR-Weekly
  "Fetch the dataset 'ISLR-Weekly' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Weekly.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ISLR/Weekly.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ISLR/Weekly.csv"))

(defn itsadug-eeg
  "Fetch the dataset 'itsadug-eeg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/itsadug/eeg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/itsadug/eeg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/itsadug/eeg.csv"))

(defn itsadug-simdat
  "Fetch the dataset 'itsadug-simdat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/itsadug/simdat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/itsadug/simdat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/itsadug/simdat.csv"))

(defn KMsurv-aids
  "Fetch the dataset 'KMsurv-aids' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/aids.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/aids.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/aids.csv"))

(defn KMsurv-alloauto
  "Fetch the dataset 'KMsurv-alloauto' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/alloauto.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/alloauto.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/alloauto.csv"))

(defn KMsurv-allograft
  "Fetch the dataset 'KMsurv-allograft' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/allograft.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/allograft.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/allograft.csv"))

(defn KMsurv-azt
  "Fetch the dataset 'KMsurv-azt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/azt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/azt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/azt.csv"))

(defn KMsurv-baboon
  "Fetch the dataset 'KMsurv-baboon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/baboon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/baboon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/baboon.csv"))

(defn KMsurv-bcdeter
  "Fetch the dataset 'KMsurv-bcdeter' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bcdeter.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bcdeter.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/bcdeter.csv"))

(defn KMsurv-bfeed
  "Fetch the dataset 'KMsurv-bfeed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bfeed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bfeed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/bfeed.csv"))

(defn KMsurv-bmt
  "Fetch the dataset 'KMsurv-bmt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bmt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bmt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/bmt.csv"))

(defn KMsurv-bnct
  "Fetch the dataset 'KMsurv-bnct' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bnct.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/bnct.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/bnct.csv"))

(defn KMsurv-btrial
  "Fetch the dataset 'KMsurv-btrial' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/btrial.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/btrial.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/btrial.csv"))

(defn KMsurv-burn
  "Fetch the dataset 'KMsurv-burn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/burn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/burn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/burn.csv"))

(defn KMsurv-channing
  "Fetch the dataset 'KMsurv-channing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/channing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/channing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/channing.csv"))

(defn KMsurv-drug6mp
  "Fetch the dataset 'KMsurv-drug6mp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/drug6mp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/drug6mp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/drug6mp.csv"))

(defn KMsurv-drughiv
  "Fetch the dataset 'KMsurv-drughiv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/drughiv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/drughiv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/drughiv.csv"))

(defn KMsurv-hodg
  "Fetch the dataset 'KMsurv-hodg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/hodg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/hodg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/hodg.csv"))

(defn KMsurv-kidney
  "Fetch the dataset 'KMsurv-kidney' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidney.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidney.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/kidney.csv"))

(defn KMsurv-kidrecurr
  "Fetch the dataset 'KMsurv-kidrecurr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidrecurr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidrecurr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/kidrecurr.csv"))

(defn KMsurv-kidtran
  "Fetch the dataset 'KMsurv-kidtran' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidtran.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/kidtran.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/kidtran.csv"))

(defn KMsurv-larynx
  "Fetch the dataset 'KMsurv-larynx' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/larynx.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/larynx.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/larynx.csv"))

(defn KMsurv-lung
  "Fetch the dataset 'KMsurv-lung' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/lung.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/lung.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/lung.csv"))

(defn KMsurv-pneumon
  "Fetch the dataset 'KMsurv-pneumon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/pneumon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/pneumon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/pneumon.csv"))

(defn KMsurv-psych
  "Fetch the dataset 'KMsurv-psych' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/psych.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/psych.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/psych.csv"))

(defn KMsurv-rats
  "Fetch the dataset 'KMsurv-rats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/rats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/rats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/rats.csv"))

(defn KMsurv-std
  "Fetch the dataset 'KMsurv-std' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/std.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/std.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/std.csv"))

(defn KMsurv-stddiag
  "Fetch the dataset 'KMsurv-stddiag' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/stddiag.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/stddiag.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/stddiag.csv"))

(defn KMsurv-tongue
  "Fetch the dataset 'KMsurv-tongue' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/tongue.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/tongue.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/tongue.csv"))

(defn KMsurv-twins
  "Fetch the dataset 'KMsurv-twins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/twins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/KMsurv/twins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/KMsurv/twins.csv"))

(defn lattice-barley
  "Fetch the dataset 'lattice-barley' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/barley.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/barley.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/barley.csv"))

(defn lattice-environmental
  "Fetch the dataset 'lattice-environmental' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/environmental.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/environmental.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/environmental.csv"))

(defn lattice-ethanol
  "Fetch the dataset 'lattice-ethanol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/ethanol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/ethanol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/ethanol.csv"))

(defn lattice-melanoma
  "Fetch the dataset 'lattice-melanoma' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/melanoma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/melanoma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/melanoma.csv"))

(defn lattice-singer
  "Fetch the dataset 'lattice-singer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/singer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/singer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/singer.csv"))

(defn lattice-USMortality
  "Fetch the dataset 'lattice-USMortality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/USMortality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/USMortality.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/USMortality.csv"))

(defn lattice-USRegionalMortality
  "Fetch the dataset 'lattice-USRegionalMortality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lattice/USRegionalMortality.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lattice/USRegionalMortality.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/lattice/USRegionalMortality.csv"))

(defn lme4-Arabidopsis
  "Fetch the dataset 'lme4-Arabidopsis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Arabidopsis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Arabidopsis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/Arabidopsis.csv"))

(defn lme4-cake
  "Fetch the dataset 'lme4-cake' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/cake.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/cake.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/cake.csv"))

(defn lme4-cbpp
  "Fetch the dataset 'lme4-cbpp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/cbpp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/cbpp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/cbpp.csv"))

(defn lme4-Dyestuff
  "Fetch the dataset 'lme4-Dyestuff' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Dyestuff.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Dyestuff.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/Dyestuff.csv"))

(defn lme4-Dyestuff2
  "Fetch the dataset 'lme4-Dyestuff2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Dyestuff2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Dyestuff2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/Dyestuff2.csv"))

(defn lme4-grouseticks
  "Fetch the dataset 'lme4-grouseticks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/grouseticks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/grouseticks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/grouseticks.csv"))

(defn lme4-grouseticks_agggrouseticks
  "Fetch the dataset 'lme4-grouseticks_agg (grouseticks)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/grouseticks_agg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/grouseticks_agg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/grouseticks_agg.csv"))

(defn lme4-InstEval
  "Fetch the dataset 'lme4-InstEval' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/InstEval.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/InstEval.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/InstEval.csv"))

(defn lme4-Pastes
  "Fetch the dataset 'lme4-Pastes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Pastes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Pastes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/Pastes.csv"))

(defn lme4-Penicillin
  "Fetch the dataset 'lme4-Penicillin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Penicillin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/Penicillin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/Penicillin.csv"))

(defn lme4-sleepstudy
  "Fetch the dataset 'lme4-sleepstudy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/sleepstudy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/sleepstudy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/sleepstudy.csv"))

(defn lme4-VerbAgg
  "Fetch the dataset 'lme4-VerbAgg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/lme4/VerbAgg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/lme4/VerbAgg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/lme4/VerbAgg.csv"))

(defn MASS-abbey
  "Fetch the dataset 'MASS-abbey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/abbey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/abbey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/abbey.csv"))

(defn MASS-accdeaths
  "Fetch the dataset 'MASS-accdeaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/accdeaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/accdeaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/accdeaths.csv"))

(defn MASS-Aids2
  "Fetch the dataset 'MASS-Aids2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Aids2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Aids2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Aids2.csv"))

(defn MASS-Animals
  "Fetch the dataset 'MASS-Animals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Animals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Animals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Animals.csv"))

(defn MASS-anorexia
  "Fetch the dataset 'MASS-anorexia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/anorexia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/anorexia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/anorexia.csv"))

(defn MASS-bacteria
  "Fetch the dataset 'MASS-bacteria' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/bacteria.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/bacteria.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/bacteria.csv"))

(defn MASS-beav1
  "Fetch the dataset 'MASS-beav1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/beav1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/beav1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/beav1.csv"))

(defn MASS-beav2
  "Fetch the dataset 'MASS-beav2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/beav2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/beav2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/beav2.csv"))

(defn MASS-biopsy
  "Fetch the dataset 'MASS-biopsy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/biopsy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/biopsy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/biopsy.csv"))

(defn MASS-birthwt
  "Fetch the dataset 'MASS-birthwt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/birthwt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/birthwt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/birthwt.csv"))

(defn MASS-Boston
  "Fetch the dataset 'MASS-Boston' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Boston.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Boston.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Boston.csv"))

(defn MASS-cabbages
  "Fetch the dataset 'MASS-cabbages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cabbages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cabbages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/cabbages.csv"))

(defn MASS-caith
  "Fetch the dataset 'MASS-caith' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/caith.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/caith.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/caith.csv"))

(defn MASS-Cars93
  "Fetch the dataset 'MASS-Cars93' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Cars93.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Cars93.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Cars93.csv"))

(defn MASS-cats
  "Fetch the dataset 'MASS-cats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/cats.csv"))

(defn MASS-cement
  "Fetch the dataset 'MASS-cement' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cement.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cement.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/cement.csv"))

(defn MASS-chem
  "Fetch the dataset 'MASS-chem' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/chem.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/chem.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/chem.csv"))

(defn MASS-coop
  "Fetch the dataset 'MASS-coop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/coop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/coop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/coop.csv"))

(defn MASS-cpus
  "Fetch the dataset 'MASS-cpus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cpus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/cpus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/cpus.csv"))

(defn MASS-crabs
  "Fetch the dataset 'MASS-crabs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/crabs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/crabs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/crabs.csv"))

(defn MASS-Cushings
  "Fetch the dataset 'MASS-Cushings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Cushings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Cushings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Cushings.csv"))

(defn MASS-DDT
  "Fetch the dataset 'MASS-DDT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/DDT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/DDT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/DDT.csv"))

(defn MASS-deaths
  "Fetch the dataset 'MASS-deaths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/deaths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/deaths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/deaths.csv"))

(defn MASS-drivers
  "Fetch the dataset 'MASS-drivers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/drivers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/drivers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/drivers.csv"))

(defn MASS-eagles
  "Fetch the dataset 'MASS-eagles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/eagles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/eagles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/eagles.csv"))

(defn MASS-epil
  "Fetch the dataset 'MASS-epil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/epil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/epil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/epil.csv"))

(defn MASS-farms
  "Fetch the dataset 'MASS-farms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/farms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/farms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/farms.csv"))

(defn MASS-fgl
  "Fetch the dataset 'MASS-fgl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/fgl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/fgl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/fgl.csv"))

(defn MASS-forbes
  "Fetch the dataset 'MASS-forbes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/forbes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/forbes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/forbes.csv"))

(defn MASS-GAGurine
  "Fetch the dataset 'MASS-GAGurine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/GAGurine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/GAGurine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/GAGurine.csv"))

(defn MASS-galaxies
  "Fetch the dataset 'MASS-galaxies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/galaxies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/galaxies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/galaxies.csv"))

(defn MASS-gehan
  "Fetch the dataset 'MASS-gehan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/gehan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/gehan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/gehan.csv"))

(defn MASS-genotype
  "Fetch the dataset 'MASS-genotype' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/genotype.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/genotype.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/genotype.csv"))

(defn MASS-geyser
  "Fetch the dataset 'MASS-geyser' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/geyser.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/geyser.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/geyser.csv"))

(defn MASS-gilgais
  "Fetch the dataset 'MASS-gilgais' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/gilgais.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/gilgais.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/gilgais.csv"))

(defn MASS-hills
  "Fetch the dataset 'MASS-hills' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/hills.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/hills.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/hills.csv"))

(defn MASS-housing
  "Fetch the dataset 'MASS-housing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/housing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/housing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/housing.csv"))

(defn MASS-immer
  "Fetch the dataset 'MASS-immer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/immer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/immer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/immer.csv"))

(defn MASS-Insurance
  "Fetch the dataset 'MASS-Insurance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Insurance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Insurance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Insurance.csv"))

(defn MASS-leuk
  "Fetch the dataset 'MASS-leuk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/leuk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/leuk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/leuk.csv"))

(defn MASS-mammals
  "Fetch the dataset 'MASS-mammals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/mammals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/mammals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/mammals.csv"))

(defn MASS-mcycle
  "Fetch the dataset 'MASS-mcycle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/mcycle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/mcycle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/mcycle.csv"))

(defn MASS-Melanoma
  "Fetch the dataset 'MASS-Melanoma' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Melanoma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Melanoma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Melanoma.csv"))

(defn MASS-menarche
  "Fetch the dataset 'MASS-menarche' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/menarche.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/menarche.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/menarche.csv"))

(defn MASS-michelson
  "Fetch the dataset 'MASS-michelson' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/michelson.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/michelson.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/michelson.csv"))

(defn MASS-minn38
  "Fetch the dataset 'MASS-minn38' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/minn38.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/minn38.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/minn38.csv"))

(defn MASS-motors
  "Fetch the dataset 'MASS-motors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/motors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/motors.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/motors.csv"))

(defn MASS-muscle
  "Fetch the dataset 'MASS-muscle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/muscle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/muscle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/muscle.csv"))

(defn MASS-newcomb
  "Fetch the dataset 'MASS-newcomb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/newcomb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/newcomb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/newcomb.csv"))

(defn MASS-nlschools
  "Fetch the dataset 'MASS-nlschools' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/nlschools.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/nlschools.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/nlschools.csv"))

(defn MASS-npk
  "Fetch the dataset 'MASS-npk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/npk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/npk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/npk.csv"))

(defn MASS-npr1
  "Fetch the dataset 'MASS-npr1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/npr1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/npr1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/npr1.csv"))

(defn MASS-oats
  "Fetch the dataset 'MASS-oats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/oats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/oats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/oats.csv"))

(defn MASS-OME
  "Fetch the dataset 'MASS-OME' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/OME.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/OME.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/OME.csv"))

(defn MASS-painters
  "Fetch the dataset 'MASS-painters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/painters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/painters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/painters.csv"))

(defn MASS-petrol
  "Fetch the dataset 'MASS-petrol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/petrol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/petrol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/petrol.csv"))

(defn MASS-phones
  "Fetch the dataset 'MASS-phones' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/phones.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/phones.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/phones.csv"))

(defn MASS-Pima.te
  "Fetch the dataset 'MASS-Pima.te' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.te.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.te.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Pima.te.csv"))

(defn MASS-Pima.tr
  "Fetch the dataset 'MASS-Pima.tr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.tr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.tr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Pima.tr.csv"))

(defn MASS-Pima.tr2
  "Fetch the dataset 'MASS-Pima.tr2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.tr2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Pima.tr2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Pima.tr2.csv"))

(defn MASS-quine
  "Fetch the dataset 'MASS-quine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/quine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/quine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/quine.csv"))

(defn MASS-Rabbit
  "Fetch the dataset 'MASS-Rabbit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Rabbit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Rabbit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Rabbit.csv"))

(defn MASS-road
  "Fetch the dataset 'MASS-road' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/road.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/road.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/road.csv"))

(defn MASS-rotifer
  "Fetch the dataset 'MASS-rotifer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/rotifer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/rotifer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/rotifer.csv"))

(defn MASS-Rubber
  "Fetch the dataset 'MASS-Rubber' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Rubber.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Rubber.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Rubber.csv"))

(defn MASS-ships
  "Fetch the dataset 'MASS-ships' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/ships.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/ships.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/ships.csv"))

(defn MASS-shoes
  "Fetch the dataset 'MASS-shoes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shoes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shoes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/shoes.csv"))

(defn MASS-shrimp
  "Fetch the dataset 'MASS-shrimp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shrimp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shrimp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/shrimp.csv"))

(defn MASS-shuttle
  "Fetch the dataset 'MASS-shuttle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shuttle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/shuttle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/shuttle.csv"))

(defn MASS-Sitka
  "Fetch the dataset 'MASS-Sitka' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Sitka.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Sitka.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Sitka.csv"))

(defn MASS-Sitka89
  "Fetch the dataset 'MASS-Sitka89' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Sitka89.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Sitka89.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Sitka89.csv"))

(defn MASS-Skye
  "Fetch the dataset 'MASS-Skye' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Skye.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Skye.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Skye.csv"))

(defn MASS-snails
  "Fetch the dataset 'MASS-snails' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/snails.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/snails.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/snails.csv"))

(defn MASS-SP500
  "Fetch the dataset 'MASS-SP500' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/SP500.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/SP500.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/SP500.csv"))

(defn MASS-steam
  "Fetch the dataset 'MASS-steam' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/steam.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/steam.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/steam.csv"))

(defn MASS-stormer
  "Fetch the dataset 'MASS-stormer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/stormer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/stormer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/stormer.csv"))

(defn MASS-survey
  "Fetch the dataset 'MASS-survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/survey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/survey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/survey.csv"))

(defn MASS-synth.te
  "Fetch the dataset 'MASS-synth.te' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/synth.te.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/synth.te.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/synth.te.csv"))

(defn MASS-synth.tr
  "Fetch the dataset 'MASS-synth.tr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/synth.tr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/synth.tr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/synth.tr.csv"))

(defn MASS-topo
  "Fetch the dataset 'MASS-topo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/topo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/topo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/topo.csv"))

(defn MASS-Traffic
  "Fetch the dataset 'MASS-Traffic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Traffic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/Traffic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/Traffic.csv"))

(defn MASS-UScereal
  "Fetch the dataset 'MASS-UScereal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/UScereal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/UScereal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/UScereal.csv"))

(defn MASS-UScrime
  "Fetch the dataset 'MASS-UScrime' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/UScrime.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/UScrime.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/UScrime.csv"))

(defn MASS-VA
  "Fetch the dataset 'MASS-VA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/VA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/VA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/VA.csv"))

(defn MASS-waders
  "Fetch the dataset 'MASS-waders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/waders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/waders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/waders.csv"))

(defn MASS-whiteside
  "Fetch the dataset 'MASS-whiteside' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/whiteside.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/whiteside.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/whiteside.csv"))

(defn MASS-wtloss
  "Fetch the dataset 'MASS-wtloss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MASS/wtloss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MASS/wtloss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MASS/wtloss.csv"))

(defn MatchIt-lalonde
  "Fetch the dataset 'MatchIt-lalonde' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/MatchIt/lalonde.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/MatchIt/lalonde.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/MatchIt/lalonde.csv"))

(defn mediation-boundsdata
  "Fetch the dataset 'mediation-boundsdata' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/boundsdata.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/boundsdata.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/boundsdata.csv"))

(defn mediation-CEDdata
  "Fetch the dataset 'mediation-CEDdata' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/CEDdata.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/CEDdata.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/CEDdata.csv"))

(defn mediation-framing
  "Fetch the dataset 'mediation-framing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/framing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/framing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/framing.csv"))

(defn mediation-jobs
  "Fetch the dataset 'mediation-jobs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/jobs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/jobs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/jobs.csv"))

(defn mediation-school
  "Fetch the dataset 'mediation-school' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/school.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/school.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/school.csv"))

(defn mediation-student
  "Fetch the dataset 'mediation-student' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mediation/student.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mediation/student.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mediation/student.csv"))

(defn medicaldata-blood_storage
  "Fetch the dataset 'medicaldata-blood_storage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/blood_storage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/blood_storage.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/blood_storage.csv"))

(defn medicaldata-covid_testing
  "Fetch the dataset 'medicaldata-covid_testing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/covid_testing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/covid_testing.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/covid_testing.csv"))

(defn medicaldata-cytomegalovirus
  "Fetch the dataset 'medicaldata-cytomegalovirus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/cytomegalovirus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/cytomegalovirus.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/cytomegalovirus.csv"))

(defn medicaldata-esoph_ca
  "Fetch the dataset 'medicaldata-esoph_ca' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/esoph_ca.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/esoph_ca.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/esoph_ca.csv"))

(defn medicaldata-indo_rct
  "Fetch the dataset 'medicaldata-indo_rct' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/indo_rct.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/indo_rct.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/indo_rct.csv"))

(defn medicaldata-indometh
  "Fetch the dataset 'medicaldata-indometh' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/indometh.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/indometh.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/indometh.csv"))

(defn medicaldata-laryngoscope
  "Fetch the dataset 'medicaldata-laryngoscope' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/laryngoscope.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/laryngoscope.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/laryngoscope.csv"))

(defn medicaldata-licorice_gargle
  "Fetch the dataset 'medicaldata-licorice_gargle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/licorice_gargle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/licorice_gargle.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/licorice_gargle.csv"))

(defn medicaldata-opt
  "Fetch the dataset 'medicaldata-opt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/opt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/opt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/opt.csv"))

(defn medicaldata-polyps
  "Fetch the dataset 'medicaldata-polyps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/polyps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/polyps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/polyps.csv"))

(defn medicaldata-scurvy
  "Fetch the dataset 'medicaldata-scurvy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/scurvy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/scurvy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/scurvy.csv"))

(defn medicaldata-smartpill
  "Fetch the dataset 'medicaldata-smartpill' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/smartpill.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/smartpill.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/smartpill.csv"))

(defn medicaldata-strep_tb
  "Fetch the dataset 'medicaldata-strep_tb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/strep_tb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/strep_tb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/strep_tb.csv"))

(defn medicaldata-supraclavicular
  "Fetch the dataset 'medicaldata-supraclavicular' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/supraclavicular.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/supraclavicular.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/supraclavicular.csv"))

(defn medicaldata-theoph
  "Fetch the dataset 'medicaldata-theoph' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/theoph.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/medicaldata/theoph.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/medicaldata/theoph.csv"))

(defn mi-CHAIN
  "Fetch the dataset 'mi-CHAIN' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mi/CHAIN.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mi/CHAIN.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mi/CHAIN.csv"))

(defn mi-nlsyV
  "Fetch the dataset 'mi-nlsyV' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mi/nlsyV.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mi/nlsyV.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mi/nlsyV.csv"))

(defn mlmRev-bdf
  "Fetch the dataset 'mlmRev-bdf' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/bdf.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/bdf.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/bdf.csv"))

(defn mlmRev-Chem97
  "Fetch the dataset 'mlmRev-Chem97' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Chem97.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Chem97.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Chem97.csv"))

(defn mlmRev-Contraception
  "Fetch the dataset 'mlmRev-Contraception' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Contraception.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Contraception.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Contraception.csv"))

(defn mlmRev-Early
  "Fetch the dataset 'mlmRev-Early' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Early.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Early.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Early.csv"))

(defn mlmRev-egsingle
  "Fetch the dataset 'mlmRev-egsingle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/egsingle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/egsingle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/egsingle.csv"))

(defn mlmRev-Exam
  "Fetch the dataset 'mlmRev-Exam' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Exam.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Exam.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Exam.csv"))

(defn mlmRev-Gcsemv
  "Fetch the dataset 'mlmRev-Gcsemv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Gcsemv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Gcsemv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Gcsemv.csv"))

(defn mlmRev-guImmun
  "Fetch the dataset 'mlmRev-guImmun' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/guImmun.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/guImmun.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/guImmun.csv"))

(defn mlmRev-guPrenat
  "Fetch the dataset 'mlmRev-guPrenat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/guPrenat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/guPrenat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/guPrenat.csv"))

(defn mlmRev-Hsb82
  "Fetch the dataset 'mlmRev-Hsb82' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Hsb82.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Hsb82.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Hsb82.csv"))

(defn mlmRev-Mmmec
  "Fetch the dataset 'mlmRev-Mmmec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Mmmec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Mmmec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Mmmec.csv"))

(defn mlmRev-Oxboys
  "Fetch the dataset 'mlmRev-Oxboys' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Oxboys.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Oxboys.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Oxboys.csv"))

(defn mlmRev-s3bbx
  "Fetch the dataset 'mlmRev-s3bbx' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/s3bbx.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/s3bbx.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/s3bbx.csv"))

(defn mlmRev-s3bby
  "Fetch the dataset 'mlmRev-s3bby' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/s3bby.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/s3bby.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/s3bby.csv"))

(defn mlmRev-ScotsSec
  "Fetch the dataset 'mlmRev-ScotsSec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/ScotsSec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/ScotsSec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/ScotsSec.csv"))

(defn mlmRev-Socatt
  "Fetch the dataset 'mlmRev-Socatt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Socatt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/Socatt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/Socatt.csv"))

(defn mlmRev-star
  "Fetch the dataset 'mlmRev-star' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/star.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mlmRev/star.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mlmRev/star.csv"))

(defn modeldata-ad_data
  "Fetch the dataset 'modeldata-ad_data' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ad_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ad_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/ad_data.csv"))

(defn modeldata-ames
  "Fetch the dataset 'modeldata-ames' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ames.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ames.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/ames.csv"))

(defn modeldata-attrition
  "Fetch the dataset 'modeldata-attrition' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/attrition.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/attrition.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/attrition.csv"))

(defn modeldata-biomass
  "Fetch the dataset 'modeldata-biomass' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/biomass.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/biomass.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/biomass.csv"))

(defn modeldata-bivariate_testbivariate
  "Fetch the dataset 'modeldata-bivariate_test (bivariate)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_test.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_test.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/bivariate_test.csv"))

(defn modeldata-bivariate_trainbivariate
  "Fetch the dataset 'modeldata-bivariate_train (bivariate)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_train.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_train.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/bivariate_train.csv"))

(defn modeldata-bivariate_valbivariate
  "Fetch the dataset 'modeldata-bivariate_val (bivariate)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_val.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/bivariate_val.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/bivariate_val.csv"))

(defn modeldata-car_prices
  "Fetch the dataset 'modeldata-car_prices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/car_prices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/car_prices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/car_prices.csv"))

(defn modeldata-cat_adoption
  "Fetch the dataset 'modeldata-cat_adoption' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/cat_adoption.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/cat_adoption.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/cat_adoption.csv"))

(defn modeldata-cells
  "Fetch the dataset 'modeldata-cells' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/cells.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/cells.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/cells.csv"))

(defn modeldata-check_times
  "Fetch the dataset 'modeldata-check_times' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/check_times.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/check_times.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/check_times.csv"))

(defn modeldata-chem_proc_yield
  "Fetch the dataset 'modeldata-chem_proc_yield' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/chem_proc_yield.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/chem_proc_yield.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/chem_proc_yield.csv"))

(defn modeldata-Chicago
  "Fetch the dataset 'modeldata-Chicago' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Chicago.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Chicago.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/Chicago.csv"))

(defn modeldata-concrete
  "Fetch the dataset 'modeldata-concrete' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/concrete.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/concrete.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/concrete.csv"))

(defn modeldata-covers
  "Fetch the dataset 'modeldata-covers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/covers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/covers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/covers.csv"))

(defn modeldata-credit_data
  "Fetch the dataset 'modeldata-credit_data' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/credit_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/credit_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/credit_data.csv"))

(defn modeldata-crickets
  "Fetch the dataset 'modeldata-crickets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/crickets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/crickets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/crickets.csv"))

(defn modeldata-deliveries
  "Fetch the dataset 'modeldata-deliveries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/deliveries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/deliveries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/deliveries.csv"))

(defn modeldata-drinks
  "Fetch the dataset 'modeldata-drinks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/drinks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/drinks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/drinks.csv"))

(defn modeldata-grants_2008grants
  "Fetch the dataset 'modeldata-grants_2008 (grants)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_2008.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_2008.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/grants_2008.csv"))

(defn modeldata-grants_othergrants
  "Fetch the dataset 'modeldata-grants_other (grants)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_other.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_other.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/grants_other.csv"))

(defn modeldata-grants_testgrants
  "Fetch the dataset 'modeldata-grants_test (grants)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_test.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/grants_test.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/grants_test.csv"))

(defn modeldata-hepatic_injury_qsar
  "Fetch the dataset 'modeldata-hepatic_injury_qsar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hepatic_injury_qsar.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hepatic_injury_qsar.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/hepatic_injury_qsar.csv"))

(defn modeldata-hotel_rates
  "Fetch the dataset 'modeldata-hotel_rates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hotel_rates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hotel_rates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/hotel_rates.csv"))

(defn modeldata-hpc_cv
  "Fetch the dataset 'modeldata-hpc_cv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hpc_cv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hpc_cv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/hpc_cv.csv"))

(defn modeldata-hpc_data
  "Fetch the dataset 'modeldata-hpc_data' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hpc_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/hpc_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/hpc_data.csv"))

(defn modeldata-ischemic_stroke
  "Fetch the dataset 'modeldata-ischemic_stroke' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ischemic_stroke.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/ischemic_stroke.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/ischemic_stroke.csv"))

(defn modeldata-leaf_id_flavia
  "Fetch the dataset 'modeldata-leaf_id_flavia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/leaf_id_flavia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/leaf_id_flavia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/leaf_id_flavia.csv"))

(defn modeldata-lending_club
  "Fetch the dataset 'modeldata-lending_club' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/lending_club.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/lending_club.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/lending_club.csv"))

(defn modeldata-meats
  "Fetch the dataset 'modeldata-meats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/meats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/meats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/meats.csv"))

(defn modeldata-mlc_churn
  "Fetch the dataset 'modeldata-mlc_churn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/mlc_churn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/mlc_churn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/mlc_churn.csv"))

(defn modeldata-oils
  "Fetch the dataset 'modeldata-oils' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/oils.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/oils.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/oils.csv"))

(defn modeldata-parabolic
  "Fetch the dataset 'modeldata-parabolic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/parabolic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/parabolic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/parabolic.csv"))

(defn modeldata-pathology
  "Fetch the dataset 'modeldata-pathology' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/pathology.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/pathology.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/pathology.csv"))

(defn modeldata-pd_speech
  "Fetch the dataset 'modeldata-pd_speech' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/pd_speech.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/pd_speech.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/pd_speech.csv"))

(defn modeldata-penguins
  "Fetch the dataset 'modeldata-penguins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/penguins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/penguins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/penguins.csv"))

(defn modeldata-permeability_qsar
  "Fetch the dataset 'modeldata-permeability_qsar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/permeability_qsar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/permeability_qsar.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/permeability_qsar.csv"))

(defn modeldata-Sacramento
  "Fetch the dataset 'modeldata-Sacramento' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Sacramento.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Sacramento.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/Sacramento.csv"))

(defn modeldata-scat
  "Fetch the dataset 'modeldata-scat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/scat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/scat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/scat.csv"))

(defn modeldata-Smithsonian
  "Fetch the dataset 'modeldata-Smithsonian' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Smithsonian.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/Smithsonian.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/Smithsonian.csv"))

(defn modeldata-solubility_test
  "Fetch the dataset 'modeldata-solubility_test' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/solubility_test.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/solubility_test.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/solubility_test.csv"))

(defn modeldata-stackoverflow
  "Fetch the dataset 'modeldata-stackoverflow' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/stackoverflow.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/stackoverflow.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/stackoverflow.csv"))

(defn modeldata-stationsChicago
  "Fetch the dataset 'modeldata-stations (Chicago)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/stations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/stations.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/stations.csv"))

(defn modeldata-steroidogenic_toxicity
  "Fetch the dataset 'modeldata-steroidogenic_toxicity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/steroidogenic_toxicity.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/steroidogenic_toxicity.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/steroidogenic_toxicity.csv"))

(defn modeldata-tate_text
  "Fetch the dataset 'modeldata-tate_text' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/tate_text.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/tate_text.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/tate_text.csv"))

(defn modeldata-taxi
  "Fetch the dataset 'modeldata-taxi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/taxi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/taxi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/taxi.csv"))

(defn modeldata-testing_datasmall_fine_foods
  "Fetch the dataset 'modeldata-testing_data (small_fine_foods)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/testing_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/testing_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/testing_data.csv"))

(defn modeldata-training_datasmall_fine_foods
  "Fetch the dataset 'modeldata-training_data (small_fine_foods)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/training_data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/training_data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/training_data.csv"))

(defn modeldata-two_class_dat
  "Fetch the dataset 'modeldata-two_class_dat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/two_class_dat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/two_class_dat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/two_class_dat.csv"))

(defn modeldata-two_class_example
  "Fetch the dataset 'modeldata-two_class_example' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/two_class_example.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/two_class_example.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/two_class_example.csv"))

(defn modeldata-wa_churn
  "Fetch the dataset 'modeldata-wa_churn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/wa_churn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/modeldata/wa_churn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/modeldata/wa_churn.csv"))

(defn mosaicData-Alcohol
  "Fetch the dataset 'mosaicData-Alcohol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Alcohol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Alcohol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Alcohol.csv"))

(defn mosaicData-Birthdays
  "Fetch the dataset 'mosaicData-Birthdays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Birthdays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Birthdays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Birthdays.csv"))

(defn mosaicData-Births
  "Fetch the dataset 'mosaicData-Births' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Births.csv"))

(defn mosaicData-Births2015
  "Fetch the dataset 'mosaicData-Births2015' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births2015.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births2015.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Births2015.csv"))

(defn mosaicData-Births78
  "Fetch the dataset 'mosaicData-Births78' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births78.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Births78.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Births78.csv"))

(defn mosaicData-BirthsCDC
  "Fetch the dataset 'mosaicData-BirthsCDC' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/BirthsCDC.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/BirthsCDC.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/BirthsCDC.csv"))

(defn mosaicData-BirthsSSA
  "Fetch the dataset 'mosaicData-BirthsSSA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/BirthsSSA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/BirthsSSA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/BirthsSSA.csv"))

(defn mosaicData-Cards
  "Fetch the dataset 'mosaicData-Cards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Cards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Cards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Cards.csv"))

(defn mosaicData-CoolingWater
  "Fetch the dataset 'mosaicData-CoolingWater' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/CoolingWater.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/CoolingWater.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/CoolingWater.csv"))

(defn mosaicData-Countries
  "Fetch the dataset 'mosaicData-Countries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Countries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Countries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Countries.csv"))

(defn mosaicData-CPS85
  "Fetch the dataset 'mosaicData-CPS85' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/CPS85.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/CPS85.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/CPS85.csv"))

(defn mosaicData-Dimes
  "Fetch the dataset 'mosaicData-Dimes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Dimes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Dimes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Dimes.csv"))

(defn mosaicData-Galton
  "Fetch the dataset 'mosaicData-Galton' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Galton.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Galton.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Galton.csv"))

(defn mosaicData-Gestation
  "Fetch the dataset 'mosaicData-Gestation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Gestation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Gestation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Gestation.csv"))

(defn mosaicData-GoosePermits
  "Fetch the dataset 'mosaicData-GoosePermits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/GoosePermits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/GoosePermits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/GoosePermits.csv"))

(defn mosaicData-HeatX
  "Fetch the dataset 'mosaicData-HeatX' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HeatX.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HeatX.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/HeatX.csv"))

(defn mosaicData-HELPfull
  "Fetch the dataset 'mosaicData-HELPfull' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPfull.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPfull.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/HELPfull.csv"))

(defn mosaicData-HELPmiss
  "Fetch the dataset 'mosaicData-HELPmiss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPmiss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPmiss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/HELPmiss.csv"))

(defn mosaicData-HELPrct
  "Fetch the dataset 'mosaicData-HELPrct' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPrct.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/HELPrct.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/HELPrct.csv"))

(defn mosaicData-KidsFeet
  "Fetch the dataset 'mosaicData-KidsFeet' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/KidsFeet.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/KidsFeet.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/KidsFeet.csv"))

(defn mosaicData-Marriage
  "Fetch the dataset 'mosaicData-Marriage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Marriage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Marriage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Marriage.csv"))

(defn mosaicData-Mites
  "Fetch the dataset 'mosaicData-Mites' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Mites.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Mites.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Mites.csv"))

(defn mosaicData-RailTrail
  "Fetch the dataset 'mosaicData-RailTrail' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/RailTrail.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/RailTrail.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/RailTrail.csv"))

(defn mosaicData-Riders
  "Fetch the dataset 'mosaicData-Riders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Riders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Riders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Riders.csv"))

(defn mosaicData-SaratogaHouses
  "Fetch the dataset 'mosaicData-SaratogaHouses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SaratogaHouses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SaratogaHouses.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/SaratogaHouses.csv"))

(defn mosaicData-SAT
  "Fetch the dataset 'mosaicData-SAT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SAT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SAT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/SAT.csv"))

(defn mosaicData-SnowGR
  "Fetch the dataset 'mosaicData-SnowGR' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SnowGR.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SnowGR.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/SnowGR.csv"))

(defn mosaicData-SwimRecords
  "Fetch the dataset 'mosaicData-SwimRecords' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SwimRecords.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/SwimRecords.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/SwimRecords.csv"))

(defn mosaicData-TenMileRace
  "Fetch the dataset 'mosaicData-TenMileRace' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/TenMileRace.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/TenMileRace.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/TenMileRace.csv"))

(defn mosaicData-Utilities
  "Fetch the dataset 'mosaicData-Utilities' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Utilities.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Utilities.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Utilities.csv"))

(defn mosaicData-Utilities2
  "Fetch the dataset 'mosaicData-Utilities2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Utilities2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Utilities2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Utilities2.csv"))

(defn mosaicData-Weather
  "Fetch the dataset 'mosaicData-Weather' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Weather.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Weather.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Weather.csv"))

(defn mosaicData-Whickham
  "Fetch the dataset 'mosaicData-Whickham' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Whickham.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mosaicData/Whickham.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mosaicData/Whickham.csv"))

(defn mstate-aidssi
  "Fetch the dataset 'mstate-aidssi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/aidssi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/aidssi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/aidssi.csv"))

(defn mstate-aidssi2
  "Fetch the dataset 'mstate-aidssi2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/aidssi2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/aidssi2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/aidssi2.csv"))

(defn mstate-bmt
  "Fetch the dataset 'mstate-bmt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/bmt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/bmt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/bmt.csv"))

(defn mstate-ebmt1
  "Fetch the dataset 'mstate-ebmt1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/ebmt1.csv"))

(defn mstate-ebmt2
  "Fetch the dataset 'mstate-ebmt2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/ebmt2.csv"))

(defn mstate-ebmt3
  "Fetch the dataset 'mstate-ebmt3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/ebmt3.csv"))

(defn mstate-ebmt4
  "Fetch the dataset 'mstate-ebmt4' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt4.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/ebmt4.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/ebmt4.csv"))

(defn mstate-prothr
  "Fetch the dataset 'mstate-prothr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/mstate/prothr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/mstate/prothr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/mstate/prothr.csv"))

(defn multgee-arthritis
  "Fetch the dataset 'multgee-arthritis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/multgee/arthritis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/multgee/arthritis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/multgee/arthritis.csv"))

(defn multgee-housing
  "Fetch the dataset 'multgee-housing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/multgee/housing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/multgee/housing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/multgee/housing.csv"))

(defn nlme-Alfalfa
  "Fetch the dataset 'nlme-Alfalfa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Alfalfa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Alfalfa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Alfalfa.csv"))

(defn nlme-Assay
  "Fetch the dataset 'nlme-Assay' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Assay.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Assay.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Assay.csv"))

(defn nlme-bdf
  "Fetch the dataset 'nlme-bdf' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/bdf.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/bdf.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/bdf.csv"))

(defn nlme-BodyWeight
  "Fetch the dataset 'nlme-BodyWeight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/BodyWeight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/BodyWeight.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/BodyWeight.csv"))

(defn nlme-Cefamandole
  "Fetch the dataset 'nlme-Cefamandole' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Cefamandole.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Cefamandole.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Cefamandole.csv"))

(defn nlme-Dialyzer
  "Fetch the dataset 'nlme-Dialyzer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Dialyzer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Dialyzer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Dialyzer.csv"))

(defn nlme-Earthquake
  "Fetch the dataset 'nlme-Earthquake' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Earthquake.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Earthquake.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Earthquake.csv"))

(defn nlme-ergoStool
  "Fetch the dataset 'nlme-ergoStool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/ergoStool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/ergoStool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/ergoStool.csv"))

(defn nlme-Fatigue
  "Fetch the dataset 'nlme-Fatigue' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Fatigue.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Fatigue.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Fatigue.csv"))

(defn nlme-Gasoline
  "Fetch the dataset 'nlme-Gasoline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Gasoline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Gasoline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Gasoline.csv"))

(defn nlme-Glucose
  "Fetch the dataset 'nlme-Glucose' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Glucose.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Glucose.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Glucose.csv"))

(defn nlme-Glucose2
  "Fetch the dataset 'nlme-Glucose2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Glucose2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Glucose2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Glucose2.csv"))

(defn nlme-Gun
  "Fetch the dataset 'nlme-Gun' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Gun.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Gun.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Gun.csv"))

(defn nlme-IGF
  "Fetch the dataset 'nlme-IGF' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/IGF.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/IGF.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/IGF.csv"))

(defn nlme-Machines
  "Fetch the dataset 'nlme-Machines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Machines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Machines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Machines.csv"))

(defn nlme-MathAchieve
  "Fetch the dataset 'nlme-MathAchieve' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/MathAchieve.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/MathAchieve.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/MathAchieve.csv"))

(defn nlme-MathAchSchool
  "Fetch the dataset 'nlme-MathAchSchool' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/MathAchSchool.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/MathAchSchool.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/MathAchSchool.csv"))

(defn nlme-Meat
  "Fetch the dataset 'nlme-Meat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Meat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Meat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Meat.csv"))

(defn nlme-Milk
  "Fetch the dataset 'nlme-Milk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Milk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Milk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Milk.csv"))

(defn nlme-Muscle
  "Fetch the dataset 'nlme-Muscle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Muscle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Muscle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Muscle.csv"))

(defn nlme-Nitrendipene
  "Fetch the dataset 'nlme-Nitrendipene' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Nitrendipene.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Nitrendipene.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Nitrendipene.csv"))

(defn nlme-Oats
  "Fetch the dataset 'nlme-Oats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Oats.csv"))

(defn nlme-Orthodont
  "Fetch the dataset 'nlme-Orthodont' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Orthodont.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Orthodont.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Orthodont.csv"))

(defn nlme-Ovary
  "Fetch the dataset 'nlme-Ovary' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Ovary.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Ovary.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Ovary.csv"))

(defn nlme-Oxboys
  "Fetch the dataset 'nlme-Oxboys' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oxboys.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oxboys.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Oxboys.csv"))

(defn nlme-Oxide
  "Fetch the dataset 'nlme-Oxide' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oxide.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Oxide.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Oxide.csv"))

(defn nlme-PBG
  "Fetch the dataset 'nlme-PBG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/PBG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/PBG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/PBG.csv"))

(defn nlme-Phenobarb
  "Fetch the dataset 'nlme-Phenobarb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Phenobarb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Phenobarb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Phenobarb.csv"))

(defn nlme-Pixel
  "Fetch the dataset 'nlme-Pixel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Pixel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Pixel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Pixel.csv"))

(defn nlme-Quinidine
  "Fetch the dataset 'nlme-Quinidine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Quinidine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Quinidine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Quinidine.csv"))

(defn nlme-Rail
  "Fetch the dataset 'nlme-Rail' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Rail.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Rail.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Rail.csv"))

(defn nlme-RatPupWeight
  "Fetch the dataset 'nlme-RatPupWeight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/RatPupWeight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/RatPupWeight.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/RatPupWeight.csv"))

(defn nlme-Relaxin
  "Fetch the dataset 'nlme-Relaxin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Relaxin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Relaxin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Relaxin.csv"))

(defn nlme-Remifentanil
  "Fetch the dataset 'nlme-Remifentanil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Remifentanil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Remifentanil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Remifentanil.csv"))

(defn nlme-Soybean
  "Fetch the dataset 'nlme-Soybean' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Soybean.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Soybean.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Soybean.csv"))

(defn nlme-Spruce
  "Fetch the dataset 'nlme-Spruce' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Spruce.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Spruce.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Spruce.csv"))

(defn nlme-Tetracycline1
  "Fetch the dataset 'nlme-Tetracycline1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Tetracycline1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Tetracycline1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Tetracycline1.csv"))

(defn nlme-Tetracycline2
  "Fetch the dataset 'nlme-Tetracycline2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Tetracycline2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Tetracycline2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Tetracycline2.csv"))

(defn nlme-Wafer
  "Fetch the dataset 'nlme-Wafer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wafer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wafer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Wafer.csv"))

(defn nlme-Wheat
  "Fetch the dataset 'nlme-Wheat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wheat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wheat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Wheat.csv"))

(defn nlme-Wheat2
  "Fetch the dataset 'nlme-Wheat2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wheat2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nlme/Wheat2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nlme/Wheat2.csv"))

(defn nycflights13-airlines
  "Fetch the dataset 'nycflights13-airlines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/airlines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/airlines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nycflights13/airlines.csv"))

(defn nycflights13-airports
  "Fetch the dataset 'nycflights13-airports' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/airports.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/airports.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nycflights13/airports.csv"))

(defn nycflights13-flights
  "Fetch the dataset 'nycflights13-flights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/flights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/flights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nycflights13/flights.csv"))

(defn nycflights13-planes
  "Fetch the dataset 'nycflights13-planes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/planes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/planes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nycflights13/planes.csv"))

(defn nycflights13-weather
  "Fetch the dataset 'nycflights13-weather' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/weather.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/nycflights13/weather.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/nycflights13/weather.csv"))

(defn openintro-absenteeism
  "Fetch the dataset 'openintro-absenteeism' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/absenteeism.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/absenteeism.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/absenteeism.csv"))

(defn openintro-acs12
  "Fetch the dataset 'openintro-acs12' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/acs12.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/acs12.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/acs12.csv"))

(defn openintro-age_at_mar
  "Fetch the dataset 'openintro-age_at_mar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/age_at_mar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/age_at_mar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/age_at_mar.csv"))

(defn openintro-ames
  "Fetch the dataset 'openintro-ames' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ames.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ames.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ames.csv"))

(defn openintro-ami_occurrences
  "Fetch the dataset 'openintro-ami_occurrences' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ami_occurrences.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ami_occurrences.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ami_occurrences.csv"))

(defn openintro-antibiotics
  "Fetch the dataset 'openintro-antibiotics' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/antibiotics.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/antibiotics.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/antibiotics.csv"))

(defn openintro-arbuthnot
  "Fetch the dataset 'openintro-arbuthnot' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/arbuthnot.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/arbuthnot.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/arbuthnot.csv"))

(defn openintro-ask
  "Fetch the dataset 'openintro-ask' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ask.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ask.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ask.csv"))

(defn openintro-association
  "Fetch the dataset 'openintro-association' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/association.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/association.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/association.csv"))

(defn openintro-assortative_mating
  "Fetch the dataset 'openintro-assortative_mating' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/assortative_mating.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/assortative_mating.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/assortative_mating.csv"))

(defn openintro-assortive_mating
  "Fetch the dataset 'openintro-assortive_mating' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/assortive_mating.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/assortive_mating.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/assortive_mating.csv"))

(defn openintro-avandia
  "Fetch the dataset 'openintro-avandia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/avandia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/avandia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/avandia.csv"))

(defn openintro-babies
  "Fetch the dataset 'openintro-babies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/babies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/babies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/babies.csv"))

(defn openintro-babies_crawl
  "Fetch the dataset 'openintro-babies_crawl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/babies_crawl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/babies_crawl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/babies_crawl.csv"))

(defn openintro-bac
  "Fetch the dataset 'openintro-bac' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/bac.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/bac.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/bac.csv"))

(defn openintro-ball_bearing
  "Fetch the dataset 'openintro-ball_bearing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ball_bearing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ball_bearing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ball_bearing.csv"))

(defn openintro-bdims
  "Fetch the dataset 'openintro-bdims' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/bdims.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/bdims.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/bdims.csv"))

(defn openintro-biontech_adolescents
  "Fetch the dataset 'openintro-biontech_adolescents' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/biontech_adolescents.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/biontech_adolescents.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/biontech_adolescents.csv"))

(defn openintro-birds
  "Fetch the dataset 'openintro-birds' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/birds.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/birds.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/birds.csv"))

(defn openintro-births
  "Fetch the dataset 'openintro-births' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/births.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/births.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/births.csv"))

(defn openintro-births14
  "Fetch the dataset 'openintro-births14' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/births14.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/births14.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/births14.csv"))

(defn openintro-blizzard_salary
  "Fetch the dataset 'openintro-blizzard_salary' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/blizzard_salary.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/blizzard_salary.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/blizzard_salary.csv"))

(defn openintro-books
  "Fetch the dataset 'openintro-books' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/books.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/books.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/books.csv"))

(defn openintro-burger
  "Fetch the dataset 'openintro-burger' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/burger.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/burger.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/burger.csv"))

(defn openintro-cancer_in_dogs
  "Fetch the dataset 'openintro-cancer_in_dogs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cancer_in_dogs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cancer_in_dogs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cancer_in_dogs.csv"))

(defn openintro-cards
  "Fetch the dataset 'openintro-cards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cards.csv"))

(defn openintro-cars04
  "Fetch the dataset 'openintro-cars04' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cars04.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cars04.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cars04.csv"))

(defn openintro-cars93
  "Fetch the dataset 'openintro-cars93' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cars93.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cars93.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cars93.csv"))

(defn openintro-cchousing
  "Fetch the dataset 'openintro-cchousing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cchousing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cchousing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cchousing.csv"))

(defn openintro-census
  "Fetch the dataset 'openintro-census' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/census.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/census.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/census.csv"))

(defn openintro-cherry
  "Fetch the dataset 'openintro-cherry' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cherry.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cherry.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cherry.csv"))

(defn openintro-china
  "Fetch the dataset 'openintro-china' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/china.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/china.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/china.csv"))

(defn openintro-cia_factbook
  "Fetch the dataset 'openintro-cia_factbook' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cia_factbook.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cia_factbook.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cia_factbook.csv"))

(defn openintro-classdata
  "Fetch the dataset 'openintro-classdata' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/classdata.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/classdata.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/classdata.csv"))

(defn openintro-cle_sac
  "Fetch the dataset 'openintro-cle_sac' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cle_sac.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cle_sac.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cle_sac.csv"))

(defn openintro-climate70
  "Fetch the dataset 'openintro-climate70' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/climate70.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/climate70.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/climate70.csv"))

(defn openintro-climber_drugs
  "Fetch the dataset 'openintro-climber_drugs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/climber_drugs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/climber_drugs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/climber_drugs.csv"))

(defn openintro-coast_starlight
  "Fetch the dataset 'openintro-coast_starlight' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/coast_starlight.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/coast_starlight.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/coast_starlight.csv"))

(defn openintro-COL
  "Fetch the dataset 'openintro-COL' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/COL.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/COL.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/COL.csv"))

(defn openintro-comics
  "Fetch the dataset 'openintro-comics' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/comics.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/comics.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/comics.csv"))

(defn openintro-corr_match
  "Fetch the dataset 'openintro-corr_match' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/corr_match.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/corr_match.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/corr_match.csv"))

(defn openintro-country_iso
  "Fetch the dataset 'openintro-country_iso' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/country_iso.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/country_iso.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/country_iso.csv"))

(defn openintro-cpr
  "Fetch the dataset 'openintro-cpr' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cpr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cpr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cpr.csv"))

(defn openintro-cpu
  "Fetch the dataset 'openintro-cpu' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cpu.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/cpu.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/cpu.csv"))

(defn openintro-credits
  "Fetch the dataset 'openintro-credits' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/credits.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/credits.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/credits.csv"))

(defn openintro-daycare_fines
  "Fetch the dataset 'openintro-daycare_fines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/daycare_fines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/daycare_fines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/daycare_fines.csv"))

(defn openintro-diabetes2
  "Fetch the dataset 'openintro-diabetes2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/diabetes2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/diabetes2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/diabetes2.csv"))

(defn openintro-dream
  "Fetch the dataset 'openintro-dream' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/dream.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/dream.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/dream.csv"))

(defn openintro-drone_blades
  "Fetch the dataset 'openintro-drone_blades' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/drone_blades.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/drone_blades.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/drone_blades.csv"))

(defn openintro-drug_use
  "Fetch the dataset 'openintro-drug_use' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/drug_use.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/drug_use.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/drug_use.csv"))

(defn openintro-duke_forest
  "Fetch the dataset 'openintro-duke_forest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/duke_forest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/duke_forest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/duke_forest.csv"))

(defn openintro-earthquakes
  "Fetch the dataset 'openintro-earthquakes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/earthquakes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/earthquakes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/earthquakes.csv"))

(defn openintro-ebola_survey
  "Fetch the dataset 'openintro-ebola_survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ebola_survey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ebola_survey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ebola_survey.csv"))

(defn openintro-elmhurst
  "Fetch the dataset 'openintro-elmhurst' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/elmhurst.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/elmhurst.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/elmhurst.csv"))

(defn openintro-email
  "Fetch the dataset 'openintro-email' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/email.csv"))

(defn openintro-email_test
  "Fetch the dataset 'openintro-email_test' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email_test.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email_test.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/email_test.csv"))

(defn openintro-email50
  "Fetch the dataset 'openintro-email50' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email50.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/email50.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/email50.csv"))

(defn openintro-env_regulation
  "Fetch the dataset 'openintro-env_regulation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/env_regulation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/env_regulation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/env_regulation.csv"))

(defn openintro-epa2012
  "Fetch the dataset 'openintro-epa2012' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/epa2012.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/epa2012.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/epa2012.csv"))

(defn openintro-epa2021
  "Fetch the dataset 'openintro-epa2021' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/epa2021.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/epa2021.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/epa2021.csv"))

(defn openintro-esi
  "Fetch the dataset 'openintro-esi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/esi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/esi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/esi.csv"))

(defn openintro-ethanol
  "Fetch the dataset 'openintro-ethanol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ethanol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ethanol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ethanol.csv"))

(defn openintro-evals
  "Fetch the dataset 'openintro-evals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/evals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/evals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/evals.csv"))

(defn openintro-exam_grades
  "Fetch the dataset 'openintro-exam_grades' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exam_grades.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exam_grades.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/exam_grades.csv"))

(defn openintro-exams
  "Fetch the dataset 'openintro-exams' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exams.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exams.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/exams.csv"))

(defn openintro-exclusive_relationship
  "Fetch the dataset 'openintro-exclusive_relationship' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exclusive_relationship.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/exclusive_relationship.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/exclusive_relationship.csv"))

(defn openintro-fact_opinion
  "Fetch the dataset 'openintro-fact_opinion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fact_opinion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fact_opinion.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fact_opinion.csv"))

(defn openintro-family_college
  "Fetch the dataset 'openintro-family_college' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/family_college.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/family_college.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/family_college.csv"))

(defn openintro-fastfood
  "Fetch the dataset 'openintro-fastfood' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fastfood.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fastfood.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fastfood.csv"))

(defn openintro-fcid
  "Fetch the dataset 'openintro-fcid' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fcid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fcid.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fcid.csv"))

(defn openintro-fheights
  "Fetch the dataset 'openintro-fheights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fheights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fheights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fheights.csv"))

(defn openintro-fish_age
  "Fetch the dataset 'openintro-fish_age' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fish_age.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fish_age.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fish_age.csv"))

(defn openintro-fish_oil_18
  "Fetch the dataset 'openintro-fish_oil_18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fish_oil_18.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/fish_oil_18.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/fish_oil_18.csv"))

(defn openintro-flow_rates
  "Fetch the dataset 'openintro-flow_rates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/flow_rates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/flow_rates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/flow_rates.csv"))

(defn openintro-friday
  "Fetch the dataset 'openintro-friday' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/friday.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/friday.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/friday.csv"))

(defn openintro-full_body_scan
  "Fetch the dataset 'openintro-full_body_scan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/full_body_scan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/full_body_scan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/full_body_scan.csv"))

(defn openintro-gdp_countries
  "Fetch the dataset 'openintro-gdp_countries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gdp_countries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gdp_countries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gdp_countries.csv"))

(defn openintro-gear_company
  "Fetch the dataset 'openintro-gear_company' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gear_company.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gear_company.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gear_company.csv"))

(defn openintro-gender_discrimination
  "Fetch the dataset 'openintro-gender_discrimination' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gender_discrimination.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gender_discrimination.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gender_discrimination.csv"))

(defn openintro-get_it_dunn_run
  "Fetch the dataset 'openintro-get_it_dunn_run' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/get_it_dunn_run.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/get_it_dunn_run.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/get_it_dunn_run.csv"))

(defn openintro-gifted
  "Fetch the dataset 'openintro-gifted' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gifted.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gifted.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gifted.csv"))

(defn openintro-global_warming_pew
  "Fetch the dataset 'openintro-global_warming_pew' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/global_warming_pew.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/global_warming_pew.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/global_warming_pew.csv"))

(defn openintro-goog
  "Fetch the dataset 'openintro-goog' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/goog.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/goog.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/goog.csv"))

(defn openintro-gov_poll
  "Fetch the dataset 'openintro-gov_poll' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gov_poll.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gov_poll.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gov_poll.csv"))

(defn openintro-gpa
  "Fetch the dataset 'openintro-gpa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gpa.csv"))

(defn openintro-gpa_iq
  "Fetch the dataset 'openintro-gpa_iq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa_iq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa_iq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gpa_iq.csv"))

(defn openintro-gpa_study_hours
  "Fetch the dataset 'openintro-gpa_study_hours' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa_study_hours.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gpa_study_hours.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gpa_study_hours.csv"))

(defn openintro-gradestv
  "Fetch the dataset 'openintro-gradestv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gradestv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gradestv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gradestv.csv"))

(defn openintro-gsearch
  "Fetch the dataset 'openintro-gsearch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gsearch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gsearch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gsearch.csv"))

(defn openintro-gss_wordsum_class
  "Fetch the dataset 'openintro-gss_wordsum_class' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gss_wordsum_class.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gss_wordsum_class.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gss_wordsum_class.csv"))

(defn openintro-gss2010
  "Fetch the dataset 'openintro-gss2010' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gss2010.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/gss2010.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/gss2010.csv"))

(defn openintro-health_coverage
  "Fetch the dataset 'openintro-health_coverage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/health_coverage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/health_coverage.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/health_coverage.csv"))

(defn openintro-healthcare_law_survey
  "Fetch the dataset 'openintro-healthcare_law_survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/healthcare_law_survey.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/healthcare_law_survey.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/healthcare_law_survey.csv"))

(defn openintro-heart_transplant
  "Fetch the dataset 'openintro-heart_transplant' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/heart_transplant.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/heart_transplant.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/heart_transplant.csv"))

(defn openintro-helium
  "Fetch the dataset 'openintro-helium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/helium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/helium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/helium.csv"))

(defn openintro-helmet
  "Fetch the dataset 'openintro-helmet' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/helmet.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/helmet.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/helmet.csv"))

(defn openintro-hfi
  "Fetch the dataset 'openintro-hfi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/hfi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/hfi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/hfi.csv"))

(defn openintro-house
  "Fetch the dataset 'openintro-house' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/house.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/house.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/house.csv"))

(defn openintro-housing
  "Fetch the dataset 'openintro-housing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/housing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/housing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/housing.csv"))

(defn openintro-hsb2
  "Fetch the dataset 'openintro-hsb2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/hsb2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/hsb2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/hsb2.csv"))

(defn openintro-husbands_wives
  "Fetch the dataset 'openintro-husbands_wives' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/husbands_wives.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/husbands_wives.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/husbands_wives.csv"))

(defn openintro-immigration
  "Fetch the dataset 'openintro-immigration' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/immigration.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/immigration.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/immigration.csv"))

(defn openintro-IMSCOL
  "Fetch the dataset 'openintro-IMSCOL' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/IMSCOL.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/IMSCOL.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/IMSCOL.csv"))

(defn openintro-infmortrate
  "Fetch the dataset 'openintro-infmortrate' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/infmortrate.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/infmortrate.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/infmortrate.csv"))

(defn openintro-iowa
  "Fetch the dataset 'openintro-iowa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/iowa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/iowa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/iowa.csv"))

(defn openintro-ipod
  "Fetch the dataset 'openintro-ipod' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ipod.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ipod.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ipod.csv"))

(defn openintro-iran
  "Fetch the dataset 'openintro-iran' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/iran.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/iran.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/iran.csv"))

(defn openintro-jury
  "Fetch the dataset 'openintro-jury' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/jury.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/jury.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/jury.csv"))

(defn openintro-kobe_basket
  "Fetch the dataset 'openintro-kobe_basket' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/kobe_basket.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/kobe_basket.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/kobe_basket.csv"))

(defn openintro-labor_market_discrimination
  "Fetch the dataset 'openintro-labor_market_discrimination' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/labor_market_discrimination.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/labor_market_discrimination.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/labor_market_discrimination.csv"))

(defn openintro-LAhomes
  "Fetch the dataset 'openintro-LAhomes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/LAhomes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/LAhomes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/LAhomes.csv"))

(defn openintro-law_resume
  "Fetch the dataset 'openintro-law_resume' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/law_resume.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/law_resume.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/law_resume.csv"))

(defn openintro-lecture_learning
  "Fetch the dataset 'openintro-lecture_learning' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lecture_learning.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lecture_learning.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/lecture_learning.csv"))

(defn openintro-leg_mari
  "Fetch the dataset 'openintro-leg_mari' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/leg_mari.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/leg_mari.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/leg_mari.csv"))

(defn openintro-lego_population
  "Fetch the dataset 'openintro-lego_population' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lego_population.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lego_population.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/lego_population.csv"))

(defn openintro-lego_sample
  "Fetch the dataset 'openintro-lego_sample' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lego_sample.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lego_sample.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/lego_sample.csv"))

(defn openintro-life_exp
  "Fetch the dataset 'openintro-life_exp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/life_exp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/life_exp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/life_exp.csv"))

(defn openintro-lizard_habitat
  "Fetch the dataset 'openintro-lizard_habitat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lizard_habitat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lizard_habitat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/lizard_habitat.csv"))

(defn openintro-lizard_run
  "Fetch the dataset 'openintro-lizard_run' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lizard_run.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/lizard_run.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/lizard_run.csv"))

(defn openintro-loan50
  "Fetch the dataset 'openintro-loan50' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/loan50.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/loan50.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/loan50.csv"))

(defn openintro-loans_full_schema
  "Fetch the dataset 'openintro-loans_full_schema' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/loans_full_schema.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/loans_full_schema.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/loans_full_schema.csv"))

(defn openintro-london_boroughs
  "Fetch the dataset 'openintro-london_boroughs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/london_boroughs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/london_boroughs.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/london_boroughs.csv"))

(defn openintro-london_murders
  "Fetch the dataset 'openintro-london_murders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/london_murders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/london_murders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/london_murders.csv"))

(defn openintro-mail_me
  "Fetch the dataset 'openintro-mail_me' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mail_me.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mail_me.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mail_me.csv"))

(defn openintro-major_survey
  "Fetch the dataset 'openintro-major_survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/major_survey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/major_survey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/major_survey.csv"))

(defn openintro-malaria
  "Fetch the dataset 'openintro-malaria' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/malaria.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/malaria.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/malaria.csv"))

(defn openintro-male_heights
  "Fetch the dataset 'openintro-male_heights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/male_heights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/male_heights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/male_heights.csv"))

(defn openintro-male_heights_fcid
  "Fetch the dataset 'openintro-male_heights_fcid' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/male_heights_fcid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/male_heights_fcid.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/male_heights_fcid.csv"))

(defn openintro-mammals
  "Fetch the dataset 'openintro-mammals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mammals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mammals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mammals.csv"))

(defn openintro-mammogram
  "Fetch the dataset 'openintro-mammogram' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mammogram.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mammogram.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mammogram.csv"))

(defn openintro-manhattan
  "Fetch the dataset 'openintro-manhattan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/manhattan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/manhattan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/manhattan.csv"))

(defn openintro-marathon
  "Fetch the dataset 'openintro-marathon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/marathon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/marathon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/marathon.csv"))

(defn openintro-mariokart
  "Fetch the dataset 'openintro-mariokart' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mariokart.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mariokart.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mariokart.csv"))

(defn openintro-mcu_films
  "Fetch the dataset 'openintro-mcu_films' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mcu_films.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mcu_films.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mcu_films.csv"))

(defn openintro-midterms_house
  "Fetch the dataset 'openintro-midterms_house' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/midterms_house.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/midterms_house.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/midterms_house.csv"))

(defn openintro-migraine
  "Fetch the dataset 'openintro-migraine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/migraine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/migraine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/migraine.csv"))

(defn openintro-military
  "Fetch the dataset 'openintro-military' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/military.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/military.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/military.csv"))

(defn openintro-mlb
  "Fetch the dataset 'openintro-mlb' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mlb.csv"))

(defn openintro-mlb_players_18
  "Fetch the dataset 'openintro-mlb_players_18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb_players_18.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb_players_18.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mlb_players_18.csv"))

(defn openintro-mlb_teams
  "Fetch the dataset 'openintro-mlb_teams' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb_teams.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlb_teams.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mlb_teams.csv"))

(defn openintro-mlbbat10
  "Fetch the dataset 'openintro-mlbbat10' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlbbat10.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mlbbat10.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mlbbat10.csv"))

(defn openintro-mn_police_use_of_force
  "Fetch the dataset 'openintro-mn_police_use_of_force' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mn_police_use_of_force.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mn_police_use_of_force.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mn_police_use_of_force.csv"))

(defn openintro-movies
  "Fetch the dataset 'openintro-movies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/movies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/movies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/movies.csv"))

(defn openintro-mtl
  "Fetch the dataset 'openintro-mtl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mtl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/mtl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/mtl.csv"))

(defn openintro-murders
  "Fetch the dataset 'openintro-murders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/murders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/murders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/murders.csv"))

(defn openintro-nba_finals
  "Fetch the dataset 'openintro-nba_finals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_finals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_finals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nba_finals.csv"))

(defn openintro-nba_finals_teams
  "Fetch the dataset 'openintro-nba_finals_teams' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_finals_teams.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_finals_teams.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nba_finals_teams.csv"))

(defn openintro-nba_heights
  "Fetch the dataset 'openintro-nba_heights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_heights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_heights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nba_heights.csv"))

(defn openintro-nba_players_19
  "Fetch the dataset 'openintro-nba_players_19' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_players_19.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nba_players_19.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nba_players_19.csv"))

(defn openintro-ncbirths
  "Fetch the dataset 'openintro-ncbirths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ncbirths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ncbirths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ncbirths.csv"))

(defn openintro-nuclear_survey
  "Fetch the dataset 'openintro-nuclear_survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nuclear_survey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nuclear_survey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nuclear_survey.csv"))

(defn openintro-nyc
  "Fetch the dataset 'openintro-nyc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nyc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nyc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nyc.csv"))

(defn openintro-nyc_marathon
  "Fetch the dataset 'openintro-nyc_marathon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nyc_marathon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nyc_marathon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nyc_marathon.csv"))

(defn openintro-nycflights
  "Fetch the dataset 'openintro-nycflights' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nycflights.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/nycflights.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/nycflights.csv"))

(defn openintro-offshore_drilling
  "Fetch the dataset 'openintro-offshore_drilling' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/offshore_drilling.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/offshore_drilling.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/offshore_drilling.csv"))

(defn openintro-openintro_colors
  "Fetch the dataset 'openintro-openintro_colors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/openintro_colors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/openintro_colors.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/openintro_colors.csv"))

(defn openintro-opportunity_cost
  "Fetch the dataset 'openintro-opportunity_cost' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/opportunity_cost.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/opportunity_cost.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/opportunity_cost.csv"))

(defn openintro-orings
  "Fetch the dataset 'openintro-orings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/orings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/orings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/orings.csv"))

(defn openintro-oscars
  "Fetch the dataset 'openintro-oscars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/oscars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/oscars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/oscars.csv"))

(defn openintro-outliers
  "Fetch the dataset 'openintro-outliers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/outliers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/outliers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/outliers.csv"))

(defn openintro-paralympic_1500
  "Fetch the dataset 'openintro-paralympic_1500' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/paralympic_1500.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/paralympic_1500.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/paralympic_1500.csv"))

(defn openintro-penelope
  "Fetch the dataset 'openintro-penelope' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penelope.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penelope.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/penelope.csv"))

(defn openintro-penetrating_oil
  "Fetch the dataset 'openintro-penetrating_oil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penetrating_oil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penetrating_oil.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/penetrating_oil.csv"))

(defn openintro-penny_ages
  "Fetch the dataset 'openintro-penny_ages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penny_ages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/penny_ages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/penny_ages.csv"))

(defn openintro-pew_energy_2018
  "Fetch the dataset 'openintro-pew_energy_2018' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pew_energy_2018.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pew_energy_2018.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/pew_energy_2018.csv"))

(defn openintro-photo_classify
  "Fetch the dataset 'openintro-photo_classify' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/photo_classify.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/photo_classify.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/photo_classify.csv"))

(defn openintro-piracy
  "Fetch the dataset 'openintro-piracy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/piracy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/piracy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/piracy.csv"))

(defn openintro-playing_cards
  "Fetch the dataset 'openintro-playing_cards' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/playing_cards.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/playing_cards.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/playing_cards.csv"))

(defn openintro-pm25_2011_durham
  "Fetch the dataset 'openintro-pm25_2011_durham' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pm25_2011_durham.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pm25_2011_durham.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/pm25_2011_durham.csv"))

(defn openintro-pm25_2022_durham
  "Fetch the dataset 'openintro-pm25_2022_durham' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pm25_2022_durham.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/pm25_2022_durham.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/pm25_2022_durham.csv"))

(defn openintro-poker
  "Fetch the dataset 'openintro-poker' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/poker.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/poker.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/poker.csv"))

(defn openintro-possum
  "Fetch the dataset 'openintro-possum' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/possum.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/possum.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/possum.csv"))

(defn openintro-ppp_201503
  "Fetch the dataset 'openintro-ppp_201503' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ppp_201503.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ppp_201503.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ppp_201503.csv"))

(defn openintro-present
  "Fetch the dataset 'openintro-present' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/present.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/present.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/present.csv"))

(defn openintro-president
  "Fetch the dataset 'openintro-president' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/president.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/president.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/president.csv"))

(defn openintro-prison
  "Fetch the dataset 'openintro-prison' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/prison.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/prison.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/prison.csv"))

(defn openintro-prius_mpg
  "Fetch the dataset 'openintro-prius_mpg' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/prius_mpg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/prius_mpg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/prius_mpg.csv"))

(defn openintro-race_justice
  "Fetch the dataset 'openintro-race_justice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/race_justice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/race_justice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/race_justice.csv"))

(defn openintro-reddit_finance
  "Fetch the dataset 'openintro-reddit_finance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/reddit_finance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/reddit_finance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/reddit_finance.csv"))

(defn openintro-res_demo_1
  "Fetch the dataset 'openintro-res_demo_1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/res_demo_1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/res_demo_1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/res_demo_1.csv"))

(defn openintro-res_demo_2
  "Fetch the dataset 'openintro-res_demo_2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/res_demo_2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/res_demo_2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/res_demo_2.csv"))

(defn openintro-resume
  "Fetch the dataset 'openintro-resume' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/resume.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/resume.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/resume.csv"))

(defn openintro-rosling_responses
  "Fetch the dataset 'openintro-rosling_responses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/rosling_responses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/rosling_responses.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/rosling_responses.csv"))

(defn openintro-russian_influence_on_us_election_2016
  "Fetch the dataset 'openintro-russian_influence_on_us_election_2016' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/russian_influence_on_us_election_2016.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/russian_influence_on_us_election_2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/russian_influence_on_us_election_2016.csv"))

(defn openintro-sa_gdp_elec
  "Fetch the dataset 'openintro-sa_gdp_elec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sa_gdp_elec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sa_gdp_elec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sa_gdp_elec.csv"))

(defn openintro-salinity
  "Fetch the dataset 'openintro-salinity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/salinity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/salinity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/salinity.csv"))

(defn openintro-sat_improve
  "Fetch the dataset 'openintro-sat_improve' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sat_improve.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sat_improve.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sat_improve.csv"))

(defn openintro-satgpa
  "Fetch the dataset 'openintro-satgpa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/satgpa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/satgpa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/satgpa.csv"))

(defn openintro-scotus_healthcare
  "Fetch the dataset 'openintro-scotus_healthcare' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/scotus_healthcare.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/scotus_healthcare.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/scotus_healthcare.csv"))

(defn openintro-seattlepets
  "Fetch the dataset 'openintro-seattlepets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/seattlepets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/seattlepets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/seattlepets.csv"))

(defn openintro-sex_discrimination
  "Fetch the dataset 'openintro-sex_discrimination' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sex_discrimination.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sex_discrimination.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sex_discrimination.csv"))

(defn openintro-simpsons_paradox_covid
  "Fetch the dataset 'openintro-simpsons_paradox_covid' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simpsons_paradox_covid.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simpsons_paradox_covid.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/simpsons_paradox_covid.csv"))

(defn openintro-simulated_normal
  "Fetch the dataset 'openintro-simulated_normal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simulated_normal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simulated_normal.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/simulated_normal.csv"))

(defn openintro-simulated_scatter
  "Fetch the dataset 'openintro-simulated_scatter' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simulated_scatter.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/simulated_scatter.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/simulated_scatter.csv"))

(defn openintro-sinusitis
  "Fetch the dataset 'openintro-sinusitis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sinusitis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sinusitis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sinusitis.csv"))

(defn openintro-sleep_deprivation
  "Fetch the dataset 'openintro-sleep_deprivation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sleep_deprivation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sleep_deprivation.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sleep_deprivation.csv"))

(defn openintro-smallpox
  "Fetch the dataset 'openintro-smallpox' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/smallpox.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/smallpox.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/smallpox.csv"))

(defn openintro-smoking
  "Fetch the dataset 'openintro-smoking' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/smoking.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/smoking.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/smoking.csv"))

(defn openintro-snowfall
  "Fetch the dataset 'openintro-snowfall' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/snowfall.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/snowfall.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/snowfall.csv"))

(defn openintro-socialexp
  "Fetch the dataset 'openintro-socialexp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/socialexp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/socialexp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/socialexp.csv"))

(defn openintro-soda
  "Fetch the dataset 'openintro-soda' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/soda.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/soda.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/soda.csv"))

(defn openintro-solar
  "Fetch the dataset 'openintro-solar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/solar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/solar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/solar.csv"))

(defn openintro-sowc_child_mortality
  "Fetch the dataset 'openintro-sowc_child_mortality' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_child_mortality.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_child_mortality.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sowc_child_mortality.csv"))

(defn openintro-sowc_demographics
  "Fetch the dataset 'openintro-sowc_demographics' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_demographics.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_demographics.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sowc_demographics.csv"))

(defn openintro-sowc_maternal_newborn
  "Fetch the dataset 'openintro-sowc_maternal_newborn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_maternal_newborn.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sowc_maternal_newborn.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sowc_maternal_newborn.csv"))

(defn openintro-sp500
  "Fetch the dataset 'openintro-sp500' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sp500.csv"))

(defn openintro-sp500_1950_2018
  "Fetch the dataset 'openintro-sp500_1950_2018' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500_1950_2018.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500_1950_2018.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sp500_1950_2018.csv"))

(defn openintro-sp500_seq
  "Fetch the dataset 'openintro-sp500_seq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500_seq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sp500_seq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sp500_seq.csv"))

(defn openintro-speed_gender_height
  "Fetch the dataset 'openintro-speed_gender_height' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/speed_gender_height.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/speed_gender_height.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/speed_gender_height.csv"))

(defn openintro-ssd_speed
  "Fetch the dataset 'openintro-ssd_speed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ssd_speed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ssd_speed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ssd_speed.csv"))

(defn openintro-starbucks
  "Fetch the dataset 'openintro-starbucks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/starbucks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/starbucks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/starbucks.csv"))

(defn openintro-stats_scores
  "Fetch the dataset 'openintro-stats_scores' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stats_scores.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stats_scores.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/stats_scores.csv"))

(defn openintro-stem_cell
  "Fetch the dataset 'openintro-stem_cell' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stem_cell.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stem_cell.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/stem_cell.csv"))

(defn openintro-stent30
  "Fetch the dataset 'openintro-stent30' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stent30.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stent30.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/stent30.csv"))

(defn openintro-stent365
  "Fetch the dataset 'openintro-stent365' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stent365.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stent365.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/stent365.csv"))

(defn openintro-stocks_18
  "Fetch the dataset 'openintro-stocks_18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stocks_18.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/stocks_18.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/stocks_18.csv"))

(defn openintro-student_housing
  "Fetch the dataset 'openintro-student_housing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/student_housing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/student_housing.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/student_housing.csv"))

(defn openintro-student_sleep
  "Fetch the dataset 'openintro-student_sleep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/student_sleep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/student_sleep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/student_sleep.csv"))

(defn openintro-sulphinpyrazone
  "Fetch the dataset 'openintro-sulphinpyrazone' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sulphinpyrazone.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/sulphinpyrazone.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/sulphinpyrazone.csv"))

(defn openintro-supreme_court
  "Fetch the dataset 'openintro-supreme_court' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/supreme_court.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/supreme_court.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/supreme_court.csv"))

(defn openintro-teacher
  "Fetch the dataset 'openintro-teacher' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/teacher.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/teacher.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/teacher.csv"))

(defn openintro-textbooks
  "Fetch the dataset 'openintro-textbooks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/textbooks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/textbooks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/textbooks.csv"))

(defn openintro-thanksgiving_spend
  "Fetch the dataset 'openintro-thanksgiving_spend' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/thanksgiving_spend.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/thanksgiving_spend.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/thanksgiving_spend.csv"))

(defn openintro-tips
  "Fetch the dataset 'openintro-tips' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/tips.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/tips.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/tips.csv"))

(defn openintro-toohey
  "Fetch the dataset 'openintro-toohey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/toohey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/toohey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/toohey.csv"))

(defn openintro-tourism
  "Fetch the dataset 'openintro-tourism' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/tourism.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/tourism.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/tourism.csv"))

(defn openintro-toy_anova
  "Fetch the dataset 'openintro-toy_anova' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/toy_anova.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/toy_anova.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/toy_anova.csv"))

(defn openintro-transplant
  "Fetch the dataset 'openintro-transplant' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/transplant.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/transplant.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/transplant.csv"))

(defn openintro-twins
  "Fetch the dataset 'openintro-twins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/twins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/twins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/twins.csv"))

(defn openintro-ucb_admit
  "Fetch the dataset 'openintro-ucb_admit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucb_admit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucb_admit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ucb_admit.csv"))

(defn openintro-ucla_f18
  "Fetch the dataset 'openintro-ucla_f18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucla_f18.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucla_f18.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ucla_f18.csv"))

(defn openintro-ucla_textbooks_f18
  "Fetch the dataset 'openintro-ucla_textbooks_f18' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucla_textbooks_f18.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ucla_textbooks_f18.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ucla_textbooks_f18.csv"))

(defn openintro-ukdemo
  "Fetch the dataset 'openintro-ukdemo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ukdemo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/ukdemo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/ukdemo.csv"))

(defn openintro-unempl
  "Fetch the dataset 'openintro-unempl' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/unempl.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/unempl.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/unempl.csv"))

(defn openintro-unemploy_pres
  "Fetch the dataset 'openintro-unemploy_pres' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/unemploy_pres.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/unemploy_pres.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/unemploy_pres.csv"))

(defn openintro-us_temperature
  "Fetch the dataset 'openintro-us_temperature' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/us_temperature.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/us_temperature.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/us_temperature.csv"))

(defn openintro-winery_cars
  "Fetch the dataset 'openintro-winery_cars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/winery_cars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/winery_cars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/winery_cars.csv"))

(defn openintro-world_pop
  "Fetch the dataset 'openintro-world_pop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/world_pop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/world_pop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/world_pop.csv"))

(defn openintro-xom
  "Fetch the dataset 'openintro-xom' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/xom.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/xom.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/xom.csv"))

(defn openintro-yawn
  "Fetch the dataset 'openintro-yawn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yawn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yawn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/yawn.csv"))

(defn openintro-yrbss
  "Fetch the dataset 'openintro-yrbss' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yrbss.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yrbss.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/yrbss.csv"))

(defn openintro-yrbss_samp
  "Fetch the dataset 'openintro-yrbss_samp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yrbss_samp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/openintro/yrbss_samp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/openintro/yrbss_samp.csv"))

(defn ordinal-income
  "Fetch the dataset 'ordinal-income' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/income.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/income.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ordinal/income.csv"))

(defn ordinal-soup
  "Fetch the dataset 'ordinal-soup' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/soup.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/soup.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ordinal/soup.csv"))

(defn ordinal-wine
  "Fetch the dataset 'ordinal-wine' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/wine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ordinal/wine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ordinal/wine.csv"))

(defn palmerpenguins-penguins
  "Fetch the dataset 'palmerpenguins-penguins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/palmerpenguins/penguins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/palmerpenguins/penguins.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/palmerpenguins/penguins.csv"))

(defn palmerpenguins-penguins_rawpenguins
  "Fetch the dataset 'palmerpenguins-penguins_raw (penguins)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/palmerpenguins/penguins_raw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/palmerpenguins/penguins_raw.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/palmerpenguins/penguins_raw.csv"))

(defn plm-Cigar
  "Fetch the dataset 'plm-Cigar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Cigar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Cigar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Cigar.csv"))

(defn plm-Crime
  "Fetch the dataset 'plm-Crime' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Crime.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Crime.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Crime.csv"))

(defn plm-EmplUK
  "Fetch the dataset 'plm-EmplUK' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/EmplUK.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/EmplUK.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/EmplUK.csv"))

(defn plm-Gasoline
  "Fetch the dataset 'plm-Gasoline' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Gasoline.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Gasoline.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Gasoline.csv"))

(defn plm-Grunfeld
  "Fetch the dataset 'plm-Grunfeld' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Grunfeld.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Grunfeld.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Grunfeld.csv"))

(defn plm-Hedonic
  "Fetch the dataset 'plm-Hedonic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Hedonic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Hedonic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Hedonic.csv"))

(defn plm-LaborSupply
  "Fetch the dataset 'plm-LaborSupply' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/LaborSupply.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/LaborSupply.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/LaborSupply.csv"))

(defn plm-Males
  "Fetch the dataset 'plm-Males' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Males.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Males.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Males.csv"))

(defn plm-Parity
  "Fetch the dataset 'plm-Parity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Parity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Parity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Parity.csv"))

(defn plm-Produc
  "Fetch the dataset 'plm-Produc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Produc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Produc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Produc.csv"))

(defn plm-RiceFarms
  "Fetch the dataset 'plm-RiceFarms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/RiceFarms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/RiceFarms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/RiceFarms.csv"))

(defn plm-Snmesp
  "Fetch the dataset 'plm-Snmesp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Snmesp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Snmesp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Snmesp.csv"))

(defn plm-SumHes
  "Fetch the dataset 'plm-SumHes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/SumHes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/SumHes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/SumHes.csv"))

(defn plm-Wages
  "Fetch the dataset 'plm-Wages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plm/Wages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plm/Wages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plm/Wages.csv"))

(defn plyr-baseball
  "Fetch the dataset 'plyr-baseball' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plyr/baseball.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plyr/baseball.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plyr/baseball.csv"))

(defn plyr-ozone
  "Fetch the dataset 'plyr-ozone' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/plyr/ozone.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/plyr/ozone.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/plyr/ozone.csv"))

(defn pscl-absentee
  "Fetch the dataset 'pscl-absentee' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/absentee.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/absentee.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/absentee.csv"))

(defn pscl-admit
  "Fetch the dataset 'pscl-admit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/admit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/admit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/admit.csv"))

(defn pscl-AustralianElectionPolling
  "Fetch the dataset 'pscl-AustralianElectionPolling' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/AustralianElectionPolling.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/AustralianElectionPolling.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/AustralianElectionPolling.csv"))

(defn pscl-AustralianElections
  "Fetch the dataset 'pscl-AustralianElections' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/AustralianElections.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/AustralianElections.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/AustralianElections.csv"))

(defn pscl-bioChemists
  "Fetch the dataset 'pscl-bioChemists' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/bioChemists.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/bioChemists.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/bioChemists.csv"))

(defn pscl-ca2006
  "Fetch the dataset 'pscl-ca2006' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/ca2006.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/ca2006.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/ca2006.csv"))

(defn pscl-EfronMorris
  "Fetch the dataset 'pscl-EfronMorris' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/EfronMorris.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/EfronMorris.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/EfronMorris.csv"))

(defn pscl-iraqVote
  "Fetch the dataset 'pscl-iraqVote' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/iraqVote.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/iraqVote.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/iraqVote.csv"))

(defn pscl-partycodes
  "Fetch the dataset 'pscl-partycodes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/partycodes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/partycodes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/partycodes.csv"))

(defn pscl-politicalInformation
  "Fetch the dataset 'pscl-politicalInformation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/politicalInformation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/politicalInformation.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/politicalInformation.csv"))

(defn pscl-presidentialElections
  "Fetch the dataset 'pscl-presidentialElections' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/presidentialElections.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/presidentialElections.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/presidentialElections.csv"))

(defn pscl-prussian
  "Fetch the dataset 'pscl-prussian' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/prussian.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/prussian.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/prussian.csv"))

(defn pscl-RockTheVote
  "Fetch the dataset 'pscl-RockTheVote' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/RockTheVote.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/RockTheVote.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/RockTheVote.csv"))

(defn pscl-state.info
  "Fetch the dataset 'pscl-state.info' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/state.info.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/state.info.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/state.info.csv"))

(defn pscl-UKHouseOfCommons
  "Fetch the dataset 'pscl-UKHouseOfCommons' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/UKHouseOfCommons.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/UKHouseOfCommons.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/UKHouseOfCommons.csv"))

(defn pscl-unionDensity
  "Fetch the dataset 'pscl-unionDensity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/unionDensity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/unionDensity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/unionDensity.csv"))

(defn pscl-vote92
  "Fetch the dataset 'pscl-vote92' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/pscl/vote92.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/pscl/vote92.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/pscl/vote92.csv"))

(defn psych-Bechtoldt
  "Fetch the dataset 'psych-Bechtoldt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Bechtoldt.csv"))

(defn psych-Bechtoldt.1
  "Fetch the dataset 'psych-Bechtoldt.1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Bechtoldt.1.csv"))

(defn psych-Bechtoldt.2
  "Fetch the dataset 'psych-Bechtoldt.2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Bechtoldt.2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Bechtoldt.2.csv"))

(defn psych-bfi
  "Fetch the dataset 'psych-bfi' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/bfi.csv"))

(defn psych-bfi.dictionary
  "Fetch the dataset 'psych-bfi.dictionary' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.dictionary.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.dictionary.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/bfi.dictionary.csv"))

(defn psych-bfi.keysbfi
  "Fetch the dataset 'psych-bfi.keys (bfi)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.keys.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/bfi.keys.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/bfi.keys.csv"))

(defn psych-bock.tablebock
  "Fetch the dataset 'psych-bock.table (bock)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/bock.table.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/bock.table.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/bock.table.csv"))

(defn psych-cattell
  "Fetch the dataset 'psych-cattell' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/cattell.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/cattell.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/cattell.csv"))

(defn psych-ChenSchmid
  "Fetch the dataset 'psych-Chen (Schmid)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Chen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Chen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Chen.csv"))

(defn psych-Dwyer
  "Fetch the dataset 'psych-Dwyer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Dwyer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Dwyer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Dwyer.csv"))

(defn psych-GarciaGSBE
  "Fetch the dataset 'psych-Garcia (GSBE)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Garcia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Garcia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Garcia.csv"))

(defn psych-Gleser
  "Fetch the dataset 'psych-Gleser' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Gleser.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Gleser.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Gleser.csv"))

(defn psych-Gorsuch
  "Fetch the dataset 'psych-Gorsuch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Gorsuch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Gorsuch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Gorsuch.csv"))

(defn psych-Harman.5
  "Fetch the dataset 'psych-Harman.5' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.5.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.5.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Harman.5.csv"))

(defn psych-Harman.8
  "Fetch the dataset 'psych-Harman.8' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.8.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.8.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Harman.8.csv"))

(defn psych-Harman.BurtHarman
  "Fetch the dataset 'psych-Harman.Burt (Harman)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.Burt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.Burt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Harman.Burt.csv"))

(defn psych-Harman.HolzingerHarman
  "Fetch the dataset 'psych-Harman.Holzinger (Harman)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.Holzinger.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.Holzinger.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Harman.Holzinger.csv"))

(defn psych-Harman.political
  "Fetch the dataset 'psych-Harman.political' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.political.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Harman.political.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Harman.political.csv"))

(defn psych-Holzinger
  "Fetch the dataset 'psych-Holzinger' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Holzinger.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Holzinger.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Holzinger.csv"))

(defn psych-Holzinger.9
  "Fetch the dataset 'psych-Holzinger.9' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Holzinger.9.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Holzinger.9.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Holzinger.9.csv"))

(defn psych-lsat6bock
  "Fetch the dataset 'psych-lsat6 (bock)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/lsat6.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/lsat6.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/lsat6.csv"))

(defn psych-lsat7bock
  "Fetch the dataset 'psych-lsat7 (bock)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/lsat7.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/lsat7.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/lsat7.csv"))

(defn psych-Reise
  "Fetch the dataset 'psych-Reise' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Reise.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Reise.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Reise.csv"))

(defn psych-sat.act
  "Fetch the dataset 'psych-sat.act' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/sat.act.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/sat.act.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/sat.act.csv"))

(defn psych-Schmid
  "Fetch the dataset 'psych-Schmid' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Schmid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Schmid.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Schmid.csv"))

(defn psych-schmid.leimanSchmid
  "Fetch the dataset 'psych-schmid.leiman (Schmid)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/schmid.leiman.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/schmid.leiman.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/schmid.leiman.csv"))

(defn psych-small.msq
  "Fetch the dataset 'psych-small.msq' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/small.msq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/small.msq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/small.msq.csv"))

(defn psych-Tal_Ortal_or
  "Fetch the dataset 'psych-Tal_Or (tal_or)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tal_Or.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tal_Or.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Tal_Or.csv"))

(defn psych-Tal.Or
  "Fetch the dataset 'psych-Tal.Or' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tal.Or.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tal.Or.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Tal.Or.csv"))

(defn psych-Thurstone
  "Fetch the dataset 'psych-Thurstone' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Thurstone.csv"))

(defn psych-Thurstone.33
  "Fetch the dataset 'psych-Thurstone.33' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.33.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.33.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Thurstone.33.csv"))

(defn psych-Thurstone.33G
  "Fetch the dataset 'psych-Thurstone.33G' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.33G.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.33G.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Thurstone.33G.csv"))

(defn psych-Thurstone.9
  "Fetch the dataset 'psych-Thurstone.9' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.9.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Thurstone.9.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Thurstone.9.csv"))

(defn psych-Tucker
  "Fetch the dataset 'psych-Tucker' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tucker.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/Tucker.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/Tucker.csv"))

(defn psych-WestSchmid
  "Fetch the dataset 'psych-West (Schmid)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/West.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/West.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/West.csv"))

(defn psych-withinBetween
  "Fetch the dataset 'psych-withinBetween' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/psych/withinBetween.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/psych/withinBetween.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/psych/withinBetween.csv"))

(defn quantreg-barro
  "Fetch the dataset 'quantreg-barro' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/barro.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/barro.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/barro.csv"))

(defn quantreg-Bosco
  "Fetch the dataset 'quantreg-Bosco' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/Bosco.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/Bosco.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/Bosco.csv"))

(defn quantreg-CobarOre
  "Fetch the dataset 'quantreg-CobarOre' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/CobarOre.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/CobarOre.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/CobarOre.csv"))

(defn quantreg-engel
  "Fetch the dataset 'quantreg-engel' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/engel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/engel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/engel.csv"))

(defn quantreg-gasprice
  "Fetch the dataset 'quantreg-gasprice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/gasprice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/gasprice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/gasprice.csv"))

(defn quantreg-Mammals
  "Fetch the dataset 'quantreg-Mammals' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/Mammals.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/Mammals.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/Mammals.csv"))

(defn quantreg-MelTemp
  "Fetch the dataset 'quantreg-MelTemp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/MelTemp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/MelTemp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/MelTemp.csv"))

(defn quantreg-uis
  "Fetch the dataset 'quantreg-uis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/uis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/quantreg/uis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/quantreg/uis.csv"))

(defn ratdat-complete
  "Fetch the dataset 'ratdat-complete' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/complete.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/complete.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ratdat/complete.csv"))

(defn ratdat-complete_old
  "Fetch the dataset 'ratdat-complete_old' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/complete_old.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/complete_old.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ratdat/complete_old.csv"))

(defn ratdat-plots
  "Fetch the dataset 'ratdat-plots' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/plots.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/plots.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ratdat/plots.csv"))

(defn ratdat-species
  "Fetch the dataset 'ratdat-species' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/species.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/species.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ratdat/species.csv"))

(defn ratdat-surveys
  "Fetch the dataset 'ratdat-surveys' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/surveys.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/ratdat/surveys.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/ratdat/surveys.csv"))

(defn reshape2-french_fries
  "Fetch the dataset 'reshape2-french_fries' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/french_fries.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/french_fries.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/reshape2/french_fries.csv"))

(defn reshape2-smiths
  "Fetch the dataset 'reshape2-smiths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/smiths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/smiths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/reshape2/smiths.csv"))

(defn reshape2-tips
  "Fetch the dataset 'reshape2-tips' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/tips.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/reshape2/tips.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/reshape2/tips.csv"))

(defn robustbase-aircraft
  "Fetch the dataset 'robustbase-aircraft' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/aircraft.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/aircraft.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/aircraft.csv"))

(defn robustbase-airmay
  "Fetch the dataset 'robustbase-airmay' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/airmay.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/airmay.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/airmay.csv"))

(defn robustbase-alcohol
  "Fetch the dataset 'robustbase-alcohol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/alcohol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/alcohol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/alcohol.csv"))

(defn robustbase-ambientNOxCH
  "Fetch the dataset 'robustbase-ambientNOxCH' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/ambientNOxCH.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/ambientNOxCH.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/ambientNOxCH.csv"))

(defn robustbase-Animals2
  "Fetch the dataset 'robustbase-Animals2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/Animals2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/Animals2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/Animals2.csv"))

(defn robustbase-biomassTill
  "Fetch the dataset 'robustbase-biomassTill' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/biomassTill.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/biomassTill.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/biomassTill.csv"))

(defn robustbase-bushfire
  "Fetch the dataset 'robustbase-bushfire' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/bushfire.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/bushfire.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/bushfire.csv"))

(defn robustbase-carrots
  "Fetch the dataset 'robustbase-carrots' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/carrots.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/carrots.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/carrots.csv"))

(defn robustbase-cloud
  "Fetch the dataset 'robustbase-cloud' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/cloud.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/cloud.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/cloud.csv"))

(defn robustbase-coleman
  "Fetch the dataset 'robustbase-coleman' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/coleman.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/coleman.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/coleman.csv"))

(defn robustbase-condroz
  "Fetch the dataset 'robustbase-condroz' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/condroz.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/condroz.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/condroz.csv"))

(defn robustbase-CrohnD
  "Fetch the dataset 'robustbase-CrohnD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/CrohnD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/CrohnD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/CrohnD.csv"))

(defn robustbase-cushny
  "Fetch the dataset 'robustbase-cushny' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/cushny.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/cushny.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/cushny.csv"))

(defn robustbase-delivery
  "Fetch the dataset 'robustbase-delivery' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/delivery.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/delivery.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/delivery.csv"))

(defn robustbase-education
  "Fetch the dataset 'robustbase-education' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/education.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/education.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/education.csv"))

(defn robustbase-epilepsy
  "Fetch the dataset 'robustbase-epilepsy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/epilepsy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/epilepsy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/epilepsy.csv"))

(defn robustbase-exAM
  "Fetch the dataset 'robustbase-exAM' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/exAM.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/exAM.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/exAM.csv"))

(defn robustbase-foodstamp
  "Fetch the dataset 'robustbase-foodstamp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/foodstamp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/foodstamp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/foodstamp.csv"))

(defn robustbase-hbk
  "Fetch the dataset 'robustbase-hbk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/hbk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/hbk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/hbk.csv"))

(defn robustbase-heart
  "Fetch the dataset 'robustbase-heart' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/heart.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/heart.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/heart.csv"))

(defn robustbase-kootenay
  "Fetch the dataset 'robustbase-kootenay' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/kootenay.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/kootenay.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/kootenay.csv"))

(defn robustbase-lactic
  "Fetch the dataset 'robustbase-lactic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/lactic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/lactic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/lactic.csv"))

(defn robustbase-los
  "Fetch the dataset 'robustbase-los' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/los.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/los.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/los.csv"))

(defn robustbase-milk
  "Fetch the dataset 'robustbase-milk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/milk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/milk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/milk.csv"))

(defn robustbase-NOxEmissions
  "Fetch the dataset 'robustbase-NOxEmissions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/NOxEmissions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/NOxEmissions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/NOxEmissions.csv"))

(defn robustbase-pension
  "Fetch the dataset 'robustbase-pension' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pension.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pension.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/pension.csv"))

(defn robustbase-phosphor
  "Fetch the dataset 'robustbase-phosphor' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/phosphor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/phosphor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/phosphor.csv"))

(defn robustbase-pilot
  "Fetch the dataset 'robustbase-pilot' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pilot.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pilot.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/pilot.csv"))

(defn robustbase-possum.matpossumDiv
  "Fetch the dataset 'robustbase-possum.mat (possumDiv)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/possum.mat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/possum.mat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/possum.mat.csv"))

(defn robustbase-possumDiv
  "Fetch the dataset 'robustbase-possumDiv' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/possumDiv.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/possumDiv.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/possumDiv.csv"))

(defn robustbase-pulpfiber
  "Fetch the dataset 'robustbase-pulpfiber' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pulpfiber.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/pulpfiber.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/pulpfiber.csv"))

(defn robustbase-radarImage
  "Fetch the dataset 'robustbase-radarImage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/radarImage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/radarImage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/radarImage.csv"))

(defn robustbase-salinity
  "Fetch the dataset 'robustbase-salinity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/salinity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/salinity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/salinity.csv"))

(defn robustbase-SiegelsEx
  "Fetch the dataset 'robustbase-SiegelsEx' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/SiegelsEx.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/SiegelsEx.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/SiegelsEx.csv"))

(defn robustbase-starsCYG
  "Fetch the dataset 'robustbase-starsCYG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/starsCYG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/starsCYG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/starsCYG.csv"))

(defn robustbase-steamUse
  "Fetch the dataset 'robustbase-steamUse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/steamUse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/steamUse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/steamUse.csv"))

(defn robustbase-telef
  "Fetch the dataset 'robustbase-telef' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/telef.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/telef.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/telef.csv"))

(defn robustbase-toxicity
  "Fetch the dataset 'robustbase-toxicity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/toxicity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/toxicity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/toxicity.csv"))

(defn robustbase-vaso
  "Fetch the dataset 'robustbase-vaso' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/vaso.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/vaso.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/vaso.csv"))

(defn robustbase-wagnerGrowth
  "Fetch the dataset 'robustbase-wagnerGrowth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/wagnerGrowth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/wagnerGrowth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/wagnerGrowth.csv"))

(defn robustbase-wood
  "Fetch the dataset 'robustbase-wood' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/wood.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/wood.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/wood.csv"))

(defn robustbase-x30o50
  "Fetch the dataset 'robustbase-x30o50' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/x30o50.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/robustbase/x30o50.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/robustbase/x30o50.csv"))

(defn rpart-car.test.frame
  "Fetch the dataset 'rpart-car.test.frame' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/car.test.frame.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/car.test.frame.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/car.test.frame.csv"))

(defn rpart-car90
  "Fetch the dataset 'rpart-car90' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/car90.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/car90.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/car90.csv"))

(defn rpart-cu.summary
  "Fetch the dataset 'rpart-cu.summary' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/cu.summary.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/cu.summary.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/cu.summary.csv"))

(defn rpart-kyphosis
  "Fetch the dataset 'rpart-kyphosis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/kyphosis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/kyphosis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/kyphosis.csv"))

(defn rpart-solder
  "Fetch the dataset 'rpart-solder' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/solder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/solder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/solder.csv"))

(defn rpart-solder.balancesolder
  "Fetch the dataset 'rpart-solder.balance (solder)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/solder.balance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/solder.balance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/solder.balance.csv"))

(defn rpart-stagec
  "Fetch the dataset 'rpart-stagec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/rpart/stagec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/rpart/stagec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/rpart/stagec.csv"))

(defn sampleSelection-Mroz87
  "Fetch the dataset 'sampleSelection-Mroz87' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/Mroz87.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/Mroz87.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sampleSelection/Mroz87.csv"))

(defn sampleSelection-nlswork
  "Fetch the dataset 'sampleSelection-nlswork' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/nlswork.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/nlswork.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sampleSelection/nlswork.csv"))

(defn sampleSelection-RandHIE
  "Fetch the dataset 'sampleSelection-RandHIE' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/RandHIE.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/RandHIE.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sampleSelection/RandHIE.csv"))

(defn sampleSelection-Smoke
  "Fetch the dataset 'sampleSelection-Smoke' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/Smoke.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sampleSelection/Smoke.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sampleSelection/Smoke.csv"))

(defn sandwich-InstInnovation
  "Fetch the dataset 'sandwich-InstInnovation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/InstInnovation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/InstInnovation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sandwich/InstInnovation.csv"))

(defn sandwich-Investment
  "Fetch the dataset 'sandwich-Investment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/Investment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/Investment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sandwich/Investment.csv"))

(defn sandwich-PetersenCL
  "Fetch the dataset 'sandwich-PetersenCL' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/PetersenCL.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/PetersenCL.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sandwich/PetersenCL.csv"))

(defn sandwich-PublicSchools
  "Fetch the dataset 'sandwich-PublicSchools' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/PublicSchools.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sandwich/PublicSchools.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sandwich/PublicSchools.csv"))

(defn sem-Bollen
  "Fetch the dataset 'sem-Bollen' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/Bollen.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/Bollen.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/Bollen.csv"))

(defn sem-CNES
  "Fetch the dataset 'sem-CNES' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/CNES.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/CNES.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/CNES.csv"))

(defn sem-HS.data
  "Fetch the dataset 'sem-HS.data' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/HS.data.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/HS.data.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/HS.data.csv"))

(defn sem-Klein
  "Fetch the dataset 'sem-Klein' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/Klein.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/Klein.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/Klein.csv"))

(defn sem-Kmenta
  "Fetch the dataset 'sem-Kmenta' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/Kmenta.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/Kmenta.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/Kmenta.csv"))

(defn sem-Tests
  "Fetch the dataset 'sem-Tests' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/sem/Tests.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/sem/Tests.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/sem/Tests.csv"))

(defn Stat2Data-AccordPrice
  "Fetch the dataset 'Stat2Data-AccordPrice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AccordPrice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AccordPrice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AccordPrice.csv"))

(defn Stat2Data-AHCAvote2017
  "Fetch the dataset 'Stat2Data-AHCAvote2017' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AHCAvote2017.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AHCAvote2017.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AHCAvote2017.csv"))

(defn Stat2Data-Airlines
  "Fetch the dataset 'Stat2Data-Airlines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Airlines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Airlines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Airlines.csv"))

(defn Stat2Data-Alfalfa
  "Fetch the dataset 'Stat2Data-Alfalfa' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Alfalfa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Alfalfa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Alfalfa.csv"))

(defn Stat2Data-AlitoConfirmation
  "Fetch the dataset 'Stat2Data-AlitoConfirmation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AlitoConfirmation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AlitoConfirmation.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AlitoConfirmation.csv"))

(defn Stat2Data-Amyloid
  "Fetch the dataset 'Stat2Data-Amyloid' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Amyloid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Amyloid.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Amyloid.csv"))

(defn Stat2Data-AppleStock
  "Fetch the dataset 'Stat2Data-AppleStock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AppleStock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AppleStock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AppleStock.csv"))

(defn Stat2Data-ArcheryData
  "Fetch the dataset 'Stat2Data-ArcheryData' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ArcheryData.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ArcheryData.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ArcheryData.csv"))

(defn Stat2Data-AthleteGrad
  "Fetch the dataset 'Stat2Data-AthleteGrad' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AthleteGrad.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AthleteGrad.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AthleteGrad.csv"))

(defn Stat2Data-AudioVisual
  "Fetch the dataset 'Stat2Data-AudioVisual' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AudioVisual.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AudioVisual.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AudioVisual.csv"))

(defn Stat2Data-AutoPollution
  "Fetch the dataset 'Stat2Data-AutoPollution' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AutoPollution.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/AutoPollution.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/AutoPollution.csv"))

(defn Stat2Data-Backpack
  "Fetch the dataset 'Stat2Data-Backpack' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Backpack.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Backpack.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Backpack.csv"))

(defn Stat2Data-BaseballTimes
  "Fetch the dataset 'Stat2Data-BaseballTimes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BaseballTimes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BaseballTimes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BaseballTimes.csv"))

(defn Stat2Data-BaseballTimes2017
  "Fetch the dataset 'Stat2Data-BaseballTimes2017' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BaseballTimes2017.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BaseballTimes2017.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BaseballTimes2017.csv"))

(defn Stat2Data-BeeStings
  "Fetch the dataset 'Stat2Data-BeeStings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BeeStings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BeeStings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BeeStings.csv"))

(defn Stat2Data-BirdCalcium
  "Fetch the dataset 'Stat2Data-BirdCalcium' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BirdCalcium.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BirdCalcium.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BirdCalcium.csv"))

(defn Stat2Data-BirdNest
  "Fetch the dataset 'Stat2Data-BirdNest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BirdNest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BirdNest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BirdNest.csv"))

(defn Stat2Data-Blood1
  "Fetch the dataset 'Stat2Data-Blood1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Blood1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Blood1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Blood1.csv"))

(defn Stat2Data-BlueJays
  "Fetch the dataset 'Stat2Data-BlueJays' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BlueJays.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BlueJays.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BlueJays.csv"))

(defn Stat2Data-BrainpH
  "Fetch the dataset 'Stat2Data-BrainpH' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BrainpH.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BrainpH.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BrainpH.csv"))

(defn Stat2Data-BreesPass
  "Fetch the dataset 'Stat2Data-BreesPass' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BreesPass.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BreesPass.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BreesPass.csv"))

(defn Stat2Data-BritishUnions
  "Fetch the dataset 'Stat2Data-BritishUnions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BritishUnions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/BritishUnions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/BritishUnions.csv"))

(defn Stat2Data-ButterfliesBc
  "Fetch the dataset 'Stat2Data-ButterfliesBc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ButterfliesBc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ButterfliesBc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ButterfliesBc.csv"))

(defn Stat2Data-CAFE
  "Fetch the dataset 'Stat2Data-CAFE' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CAFE.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CAFE.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CAFE.csv"))

(defn Stat2Data-CalciumBP
  "Fetch the dataset 'Stat2Data-CalciumBP' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CalciumBP.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CalciumBP.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CalciumBP.csv"))

(defn Stat2Data-CanadianDrugs
  "Fetch the dataset 'Stat2Data-CanadianDrugs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CanadianDrugs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CanadianDrugs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CanadianDrugs.csv"))

(defn Stat2Data-CancerSurvival
  "Fetch the dataset 'Stat2Data-CancerSurvival' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CancerSurvival.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CancerSurvival.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CancerSurvival.csv"))

(defn Stat2Data-Caterpillars
  "Fetch the dataset 'Stat2Data-Caterpillars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Caterpillars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Caterpillars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Caterpillars.csv"))

(defn Stat2Data-CavsShooting
  "Fetch the dataset 'Stat2Data-CavsShooting' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CavsShooting.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CavsShooting.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CavsShooting.csv"))

(defn Stat2Data-Cereal
  "Fetch the dataset 'Stat2Data-Cereal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Cereal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Cereal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Cereal.csv"))

(defn Stat2Data-ChemoTHC
  "Fetch the dataset 'Stat2Data-ChemoTHC' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ChemoTHC.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ChemoTHC.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ChemoTHC.csv"))

(defn Stat2Data-ChildSpeaks
  "Fetch the dataset 'Stat2Data-ChildSpeaks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ChildSpeaks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ChildSpeaks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ChildSpeaks.csv"))

(defn Stat2Data-ClintonSanders
  "Fetch the dataset 'Stat2Data-ClintonSanders' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ClintonSanders.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ClintonSanders.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ClintonSanders.csv"))

(defn Stat2Data-Clothing
  "Fetch the dataset 'Stat2Data-Clothing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Clothing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Clothing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Clothing.csv"))

(defn Stat2Data-CloudSeeding
  "Fetch the dataset 'Stat2Data-CloudSeeding' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CloudSeeding.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CloudSeeding.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CloudSeeding.csv"))

(defn Stat2Data-CloudSeeding2
  "Fetch the dataset 'Stat2Data-CloudSeeding2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CloudSeeding2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CloudSeeding2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CloudSeeding2.csv"))

(defn Stat2Data-CO2
  "Fetch the dataset 'Stat2Data-CO2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CO2.csv"))

(defn Stat2Data-CO2Germany
  "Fetch the dataset 'Stat2Data-CO2Germany' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2Germany.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2Germany.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CO2Germany.csv"))

(defn Stat2Data-CO2Hawaii
  "Fetch the dataset 'Stat2Data-CO2Hawaii' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2Hawaii.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2Hawaii.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CO2Hawaii.csv"))

(defn Stat2Data-CO2SouthPole
  "Fetch the dataset 'Stat2Data-CO2SouthPole' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2SouthPole.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CO2SouthPole.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CO2SouthPole.csv"))

(defn Stat2Data-Contraceptives
  "Fetch the dataset 'Stat2Data-Contraceptives' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Contraceptives.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Contraceptives.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Contraceptives.csv"))

(defn Stat2Data-CountyHealth
  "Fetch the dataset 'Stat2Data-CountyHealth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CountyHealth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CountyHealth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CountyHealth.csv"))

(defn Stat2Data-CrabShip
  "Fetch the dataset 'Stat2Data-CrabShip' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CrabShip.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CrabShip.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CrabShip.csv"))

(defn Stat2Data-CrackerFiber
  "Fetch the dataset 'Stat2Data-CrackerFiber' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CrackerFiber.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CrackerFiber.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CrackerFiber.csv"))

(defn Stat2Data-CreditRisk
  "Fetch the dataset 'Stat2Data-CreditRisk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CreditRisk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/CreditRisk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/CreditRisk.csv"))

(defn Stat2Data-Cuckoo
  "Fetch the dataset 'Stat2Data-Cuckoo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Cuckoo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Cuckoo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Cuckoo.csv"))

(defn Stat2Data-Day1Survey
  "Fetch the dataset 'Stat2Data-Day1Survey' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Day1Survey.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Day1Survey.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Day1Survey.csv"))

(defn Stat2Data-DiabeticDogs
  "Fetch the dataset 'Stat2Data-DiabeticDogs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/DiabeticDogs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/DiabeticDogs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/DiabeticDogs.csv"))

(defn Stat2Data-Diamonds
  "Fetch the dataset 'Stat2Data-Diamonds' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Diamonds.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Diamonds.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Diamonds.csv"))

(defn Stat2Data-Diamonds2
  "Fetch the dataset 'Stat2Data-Diamonds2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Diamonds2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Diamonds2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Diamonds2.csv"))

(defn Stat2Data-Dinosaurs
  "Fetch the dataset 'Stat2Data-Dinosaurs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Dinosaurs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Dinosaurs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Dinosaurs.csv"))

(defn Stat2Data-Election08
  "Fetch the dataset 'Stat2Data-Election08' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Election08.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Election08.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Election08.csv"))

(defn Stat2Data-Election16
  "Fetch the dataset 'Stat2Data-Election16' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Election16.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Election16.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Election16.csv"))

(defn Stat2Data-ElephantsFB
  "Fetch the dataset 'Stat2Data-ElephantsFB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ElephantsFB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ElephantsFB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ElephantsFB.csv"))

(defn Stat2Data-ElephantsMF
  "Fetch the dataset 'Stat2Data-ElephantsMF' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ElephantsMF.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ElephantsMF.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ElephantsMF.csv"))

(defn Stat2Data-Ethanol
  "Fetch the dataset 'Stat2Data-Ethanol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Ethanol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Ethanol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Ethanol.csv"))

(defn Stat2Data-Eyes
  "Fetch the dataset 'Stat2Data-Eyes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Eyes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Eyes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Eyes.csv"))

(defn Stat2Data-Faces
  "Fetch the dataset 'Stat2Data-Faces' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Faces.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Faces.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Faces.csv"))

(defn Stat2Data-FaithfulFaces
  "Fetch the dataset 'Stat2Data-FaithfulFaces' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FaithfulFaces.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FaithfulFaces.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FaithfulFaces.csv"))

(defn Stat2Data-FantasyBaseball
  "Fetch the dataset 'Stat2Data-FantasyBaseball' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FantasyBaseball.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FantasyBaseball.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FantasyBaseball.csv"))

(defn Stat2Data-FatRats
  "Fetch the dataset 'Stat2Data-FatRats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FatRats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FatRats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FatRats.csv"))

(defn Stat2Data-Fertility
  "Fetch the dataset 'Stat2Data-Fertility' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fertility.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fertility.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Fertility.csv"))

(defn Stat2Data-FGByDistance
  "Fetch the dataset 'Stat2Data-FGByDistance' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FGByDistance.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FGByDistance.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FGByDistance.csv"))

(defn Stat2Data-Film
  "Fetch the dataset 'Stat2Data-Film' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Film.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Film.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Film.csv"))

(defn Stat2Data-FinalFourIzzo
  "Fetch the dataset 'Stat2Data-FinalFourIzzo' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourIzzo.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourIzzo.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourIzzo.csv"))

(defn Stat2Data-FinalFourIzzo17
  "Fetch the dataset 'Stat2Data-FinalFourIzzo17' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourIzzo17.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourIzzo17.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourIzzo17.csv"))

(defn Stat2Data-FinalFourLong
  "Fetch the dataset 'Stat2Data-FinalFourLong' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourLong.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourLong.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourLong.csv"))

(defn Stat2Data-FinalFourLong17
  "Fetch the dataset 'Stat2Data-FinalFourLong17' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourLong17.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourLong17.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourLong17.csv"))

(defn Stat2Data-FinalFourShort
  "Fetch the dataset 'Stat2Data-FinalFourShort' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourShort.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourShort.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourShort.csv"))

(defn Stat2Data-FinalFourShort17
  "Fetch the dataset 'Stat2Data-FinalFourShort17' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourShort17.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FinalFourShort17.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FinalFourShort17.csv"))

(defn Stat2Data-Fingers
  "Fetch the dataset 'Stat2Data-Fingers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fingers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fingers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Fingers.csv"))

(defn Stat2Data-FirstYearGPA
  "Fetch the dataset 'Stat2Data-FirstYearGPA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FirstYearGPA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FirstYearGPA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FirstYearGPA.csv"))

(defn Stat2Data-FishEggs
  "Fetch the dataset 'Stat2Data-FishEggs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FishEggs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FishEggs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FishEggs.csv"))

(defn Stat2Data-Fitch
  "Fetch the dataset 'Stat2Data-Fitch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fitch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fitch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Fitch.csv"))

(defn Stat2Data-FlightResponse
  "Fetch the dataset 'Stat2Data-FlightResponse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FlightResponse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FlightResponse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FlightResponse.csv"))

(defn Stat2Data-FloridaDP
  "Fetch the dataset 'Stat2Data-FloridaDP' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FloridaDP.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FloridaDP.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FloridaDP.csv"))

(defn Stat2Data-Fluorescence
  "Fetch the dataset 'Stat2Data-Fluorescence' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fluorescence.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Fluorescence.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Fluorescence.csv"))

(defn Stat2Data-FranticFingers
  "Fetch the dataset 'Stat2Data-FranticFingers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FranticFingers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FranticFingers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FranticFingers.csv"))

(defn Stat2Data-FruitFlies
  "Fetch the dataset 'Stat2Data-FruitFlies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FruitFlies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FruitFlies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FruitFlies.csv"))

(defn Stat2Data-FruitFlies2
  "Fetch the dataset 'Stat2Data-FruitFlies2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FruitFlies2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FruitFlies2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FruitFlies2.csv"))

(defn Stat2Data-FunnelDrop
  "Fetch the dataset 'Stat2Data-FunnelDrop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FunnelDrop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/FunnelDrop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/FunnelDrop.csv"))

(defn Stat2Data-GlowWorms
  "Fetch the dataset 'Stat2Data-GlowWorms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/GlowWorms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/GlowWorms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/GlowWorms.csv"))

(defn Stat2Data-Goldenrod
  "Fetch the dataset 'Stat2Data-Goldenrod' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Goldenrod.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Goldenrod.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Goldenrod.csv"))

(defn Stat2Data-GrinnellHouses
  "Fetch the dataset 'Stat2Data-GrinnellHouses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/GrinnellHouses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/GrinnellHouses.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/GrinnellHouses.csv"))

(defn Stat2Data-Grocery
  "Fetch the dataset 'Stat2Data-Grocery' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Grocery.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Grocery.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Grocery.csv"))

(defn Stat2Data-Gunnels
  "Fetch the dataset 'Stat2Data-Gunnels' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Gunnels.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Gunnels.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Gunnels.csv"))

(defn Stat2Data-Handwriting
  "Fetch the dataset 'Stat2Data-Handwriting' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Handwriting.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Handwriting.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Handwriting.csv"))

(defn Stat2Data-Hawks
  "Fetch the dataset 'Stat2Data-Hawks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Hawks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Hawks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Hawks.csv"))

(defn Stat2Data-HawkTail
  "Fetch the dataset 'Stat2Data-HawkTail' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HawkTail.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HawkTail.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HawkTail.csv"))

(defn Stat2Data-HawkTail2
  "Fetch the dataset 'Stat2Data-HawkTail2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HawkTail2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HawkTail2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HawkTail2.csv"))

(defn Stat2Data-HearingTest
  "Fetch the dataset 'Stat2Data-HearingTest' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HearingTest.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HearingTest.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HearingTest.csv"))

(defn Stat2Data-HeatingOil
  "Fetch the dataset 'Stat2Data-HeatingOil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HeatingOil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HeatingOil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HeatingOil.csv"))

(defn Stat2Data-HighPeaks
  "Fetch the dataset 'Stat2Data-HighPeaks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HighPeaks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HighPeaks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HighPeaks.csv"))

(defn Stat2Data-Hoops
  "Fetch the dataset 'Stat2Data-Hoops' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Hoops.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Hoops.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Hoops.csv"))

(defn Stat2Data-HorsePrices
  "Fetch the dataset 'Stat2Data-HorsePrices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HorsePrices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HorsePrices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HorsePrices.csv"))

(defn Stat2Data-Houses
  "Fetch the dataset 'Stat2Data-Houses' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Houses.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Houses.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Houses.csv"))

(defn Stat2Data-HousesNY
  "Fetch the dataset 'Stat2Data-HousesNY' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HousesNY.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/HousesNY.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/HousesNY.csv"))

(defn Stat2Data-ICU
  "Fetch the dataset 'Stat2Data-ICU' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ICU.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ICU.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ICU.csv"))

(defn Stat2Data-InfantMortality2010
  "Fetch the dataset 'Stat2Data-InfantMortality2010' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/InfantMortality2010.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/InfantMortality2010.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/InfantMortality2010.csv"))

(defn Stat2Data-Inflation
  "Fetch the dataset 'Stat2Data-Inflation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Inflation.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Inflation.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Inflation.csv"))

(defn Stat2Data-InsuranceVote
  "Fetch the dataset 'Stat2Data-InsuranceVote' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/InsuranceVote.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/InsuranceVote.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/InsuranceVote.csv"))

(defn Stat2Data-IQGuessing
  "Fetch the dataset 'Stat2Data-IQGuessing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/IQGuessing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/IQGuessing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/IQGuessing.csv"))

(defn Stat2Data-Jurors
  "Fetch the dataset 'Stat2Data-Jurors' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Jurors.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Jurors.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Jurors.csv"))

(defn Stat2Data-Kershaw
  "Fetch the dataset 'Stat2Data-Kershaw' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Kershaw.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Kershaw.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Kershaw.csv"))

(defn Stat2Data-KeyWestWater
  "Fetch the dataset 'Stat2Data-KeyWestWater' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/KeyWestWater.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/KeyWestWater.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/KeyWestWater.csv"))

(defn Stat2Data-Kids198
  "Fetch the dataset 'Stat2Data-Kids198' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Kids198.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Kids198.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Kids198.csv"))

(defn Stat2Data-Leafhoppers
  "Fetch the dataset 'Stat2Data-Leafhoppers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Leafhoppers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Leafhoppers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Leafhoppers.csv"))

(defn Stat2Data-LeafWidth
  "Fetch the dataset 'Stat2Data-LeafWidth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LeafWidth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LeafWidth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LeafWidth.csv"))

(defn Stat2Data-Leukemia
  "Fetch the dataset 'Stat2Data-Leukemia' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Leukemia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Leukemia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Leukemia.csv"))

(defn Stat2Data-LeveeFailures
  "Fetch the dataset 'Stat2Data-LeveeFailures' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LeveeFailures.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LeveeFailures.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LeveeFailures.csv"))

(defn Stat2Data-LewyBody2Groups
  "Fetch the dataset 'Stat2Data-LewyBody2Groups' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LewyBody2Groups.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LewyBody2Groups.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LewyBody2Groups.csv"))

(defn Stat2Data-LewyDLBad
  "Fetch the dataset 'Stat2Data-LewyDLBad' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LewyDLBad.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LewyDLBad.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LewyDLBad.csv"))

(defn Stat2Data-LongJumpOlympics
  "Fetch the dataset 'Stat2Data-LongJumpOlympics' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LongJumpOlympics.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LongJumpOlympics.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LongJumpOlympics.csv"))

(defn Stat2Data-LongJumpOlympics2016
  "Fetch the dataset 'Stat2Data-LongJumpOlympics2016' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LongJumpOlympics2016.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LongJumpOlympics2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LongJumpOlympics2016.csv"))

(defn Stat2Data-LosingSleep
  "Fetch the dataset 'Stat2Data-LosingSleep' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LosingSleep.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LosingSleep.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LosingSleep.csv"))

(defn Stat2Data-LostLetter
  "Fetch the dataset 'Stat2Data-LostLetter' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LostLetter.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/LostLetter.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/LostLetter.csv"))

(defn Stat2Data-Marathon
  "Fetch the dataset 'Stat2Data-Marathon' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Marathon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Marathon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Marathon.csv"))

(defn Stat2Data-Markets
  "Fetch the dataset 'Stat2Data-Markets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Markets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Markets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Markets.csv"))

(defn Stat2Data-MathEnrollment
  "Fetch the dataset 'Stat2Data-MathEnrollment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MathEnrollment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MathEnrollment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MathEnrollment.csv"))

(defn Stat2Data-MathPlacement
  "Fetch the dataset 'Stat2Data-MathPlacement' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MathPlacement.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MathPlacement.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MathPlacement.csv"))

(defn Stat2Data-MedGPA
  "Fetch the dataset 'Stat2Data-MedGPA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MedGPA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MedGPA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MedGPA.csv"))

(defn Stat2Data-Meniscus
  "Fetch the dataset 'Stat2Data-Meniscus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Meniscus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Meniscus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Meniscus.csv"))

(defn Stat2Data-MentalHealth
  "Fetch the dataset 'Stat2Data-MentalHealth' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MentalHealth.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MentalHealth.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MentalHealth.csv"))

(defn Stat2Data-MetabolicRate
  "Fetch the dataset 'Stat2Data-MetabolicRate' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetabolicRate.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetabolicRate.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MetabolicRate.csv"))

(defn Stat2Data-MetroCommutes
  "Fetch the dataset 'Stat2Data-MetroCommutes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetroCommutes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetroCommutes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MetroCommutes.csv"))

(defn Stat2Data-MetroHealth83
  "Fetch the dataset 'Stat2Data-MetroHealth83' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetroHealth83.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MetroHealth83.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MetroHealth83.csv"))

(defn Stat2Data-Migraines
  "Fetch the dataset 'Stat2Data-Migraines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Migraines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Migraines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Migraines.csv"))

(defn Stat2Data-Milgram
  "Fetch the dataset 'Stat2Data-Milgram' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Milgram.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Milgram.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Milgram.csv"))

(defn Stat2Data-MLB2007Standings
  "Fetch the dataset 'Stat2Data-MLB2007Standings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MLB2007Standings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MLB2007Standings.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MLB2007Standings.csv"))

(defn Stat2Data-MLBStandings2016
  "Fetch the dataset 'Stat2Data-MLBStandings2016' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MLBStandings2016.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MLBStandings2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MLBStandings2016.csv"))

(defn Stat2Data-MothEggs
  "Fetch the dataset 'Stat2Data-MothEggs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MothEggs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MothEggs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MothEggs.csv"))

(defn Stat2Data-MouseBrain
  "Fetch the dataset 'Stat2Data-MouseBrain' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MouseBrain.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MouseBrain.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MouseBrain.csv"))

(defn Stat2Data-MusicTime
  "Fetch the dataset 'Stat2Data-MusicTime' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MusicTime.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/MusicTime.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/MusicTime.csv"))

(defn Stat2Data-NCbirths
  "Fetch the dataset 'Stat2Data-NCbirths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NCbirths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NCbirths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/NCbirths.csv"))

(defn Stat2Data-NFL2007Standings
  "Fetch the dataset 'Stat2Data-NFL2007Standings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NFL2007Standings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NFL2007Standings.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/NFL2007Standings.csv"))

(defn Stat2Data-NFLStandings2016
  "Fetch the dataset 'Stat2Data-NFLStandings2016' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NFLStandings2016.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/NFLStandings2016.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/NFLStandings2016.csv"))

(defn Stat2Data-Nursing
  "Fetch the dataset 'Stat2Data-Nursing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Nursing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Nursing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Nursing.csv"))

(defn Stat2Data-OilDeapsorbtion
  "Fetch the dataset 'Stat2Data-OilDeapsorbtion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/OilDeapsorbtion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/OilDeapsorbtion.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/OilDeapsorbtion.csv"))

(defn Stat2Data-Olives
  "Fetch the dataset 'Stat2Data-Olives' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Olives.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Olives.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Olives.csv"))

(defn Stat2Data-Orings
  "Fetch the dataset 'Stat2Data-Orings' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Orings.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Orings.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Orings.csv"))

(defn Stat2Data-Overdrawn
  "Fetch the dataset 'Stat2Data-Overdrawn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Overdrawn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Overdrawn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Overdrawn.csv"))

(defn Stat2Data-Oysters
  "Fetch the dataset 'Stat2Data-Oysters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Oysters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Oysters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Oysters.csv"))

(defn Stat2Data-PalmBeach
  "Fetch the dataset 'Stat2Data-PalmBeach' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PalmBeach.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PalmBeach.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PalmBeach.csv"))

(defn Stat2Data-PeaceBridge2003
  "Fetch the dataset 'Stat2Data-PeaceBridge2003' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PeaceBridge2003.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PeaceBridge2003.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PeaceBridge2003.csv"))

(defn Stat2Data-PeaceBridge2012
  "Fetch the dataset 'Stat2Data-PeaceBridge2012' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PeaceBridge2012.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PeaceBridge2012.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PeaceBridge2012.csv"))

(defn Stat2Data-Pedometer
  "Fetch the dataset 'Stat2Data-Pedometer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pedometer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pedometer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Pedometer.csv"))

(defn Stat2Data-Perch
  "Fetch the dataset 'Stat2Data-Perch' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Perch.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Perch.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Perch.csv"))

(defn Stat2Data-PigFeed
  "Fetch the dataset 'Stat2Data-PigFeed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PigFeed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PigFeed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PigFeed.csv"))

(defn Stat2Data-Pines
  "Fetch the dataset 'Stat2Data-Pines' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pines.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pines.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Pines.csv"))

(defn Stat2Data-PKU
  "Fetch the dataset 'Stat2Data-PKU' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PKU.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PKU.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PKU.csv"))

(defn Stat2Data-Political
  "Fetch the dataset 'Stat2Data-Political' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Political.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Political.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Political.csv"))

(defn Stat2Data-Pollster08
  "Fetch the dataset 'Stat2Data-Pollster08' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pollster08.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pollster08.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Pollster08.csv"))

(defn Stat2Data-Popcorn
  "Fetch the dataset 'Stat2Data-Popcorn' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Popcorn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Popcorn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Popcorn.csv"))

(defn Stat2Data-PorscheJaguar
  "Fetch the dataset 'Stat2Data-PorscheJaguar' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PorscheJaguar.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PorscheJaguar.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PorscheJaguar.csv"))

(defn Stat2Data-PorschePrice
  "Fetch the dataset 'Stat2Data-PorschePrice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PorschePrice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/PorschePrice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/PorschePrice.csv"))

(defn Stat2Data-Pulse
  "Fetch the dataset 'Stat2Data-Pulse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pulse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Pulse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Pulse.csv"))

(defn Stat2Data-Putts1
  "Fetch the dataset 'Stat2Data-Putts1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Putts1.csv"))

(defn Stat2Data-Putts2
  "Fetch the dataset 'Stat2Data-Putts2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Putts2.csv"))

(defn Stat2Data-Putts3
  "Fetch the dataset 'Stat2Data-Putts3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Putts3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Putts3.csv"))

(defn Stat2Data-RacialAnimus
  "Fetch the dataset 'Stat2Data-RacialAnimus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RacialAnimus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RacialAnimus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RacialAnimus.csv"))

(defn Stat2Data-RadioactiveTwins
  "Fetch the dataset 'Stat2Data-RadioactiveTwins' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RadioactiveTwins.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RadioactiveTwins.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RadioactiveTwins.csv"))

(defn Stat2Data-RailsTrails
  "Fetch the dataset 'Stat2Data-RailsTrails' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RailsTrails.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RailsTrails.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RailsTrails.csv"))

(defn Stat2Data-Rectangles
  "Fetch the dataset 'Stat2Data-Rectangles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Rectangles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Rectangles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Rectangles.csv"))

(defn Stat2Data-ReligionGDP
  "Fetch the dataset 'Stat2Data-ReligionGDP' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ReligionGDP.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ReligionGDP.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ReligionGDP.csv"))

(defn Stat2Data-RepeatedPulse
  "Fetch the dataset 'Stat2Data-RepeatedPulse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RepeatedPulse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RepeatedPulse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RepeatedPulse.csv"))

(defn Stat2Data-ResidualOil
  "Fetch the dataset 'Stat2Data-ResidualOil' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ResidualOil.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ResidualOil.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ResidualOil.csv"))

(defn Stat2Data-Retirement
  "Fetch the dataset 'Stat2Data-Retirement' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Retirement.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Retirement.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Retirement.csv"))

(defn Stat2Data-Ricci
  "Fetch the dataset 'Stat2Data-Ricci' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Ricci.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Ricci.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Ricci.csv"))

(defn Stat2Data-RiverElements
  "Fetch the dataset 'Stat2Data-RiverElements' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RiverElements.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RiverElements.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RiverElements.csv"))

(defn Stat2Data-RiverIron
  "Fetch the dataset 'Stat2Data-RiverIron' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RiverIron.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/RiverIron.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/RiverIron.csv"))

(defn Stat2Data-SampleFG
  "Fetch the dataset 'Stat2Data-SampleFG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SampleFG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SampleFG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SampleFG.csv"))

(defn Stat2Data-SandwichAnts
  "Fetch the dataset 'Stat2Data-SandwichAnts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SandwichAnts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SandwichAnts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SandwichAnts.csv"))

(defn Stat2Data-SATGPA
  "Fetch the dataset 'Stat2Data-SATGPA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SATGPA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SATGPA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SATGPA.csv"))

(defn Stat2Data-SeaIce
  "Fetch the dataset 'Stat2Data-SeaIce' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SeaIce.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SeaIce.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SeaIce.csv"))

(defn Stat2Data-SeaSlugs
  "Fetch the dataset 'Stat2Data-SeaSlugs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SeaSlugs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SeaSlugs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SeaSlugs.csv"))

(defn Stat2Data-SleepingShrews
  "Fetch the dataset 'Stat2Data-SleepingShrews' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SleepingShrews.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SleepingShrews.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SleepingShrews.csv"))

(defn Stat2Data-Sparrows
  "Fetch the dataset 'Stat2Data-Sparrows' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Sparrows.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Sparrows.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Sparrows.csv"))

(defn Stat2Data-SpeciesArea
  "Fetch the dataset 'Stat2Data-SpeciesArea' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SpeciesArea.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SpeciesArea.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SpeciesArea.csv"))

(defn Stat2Data-Speed
  "Fetch the dataset 'Stat2Data-Speed' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Speed.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Speed.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Speed.csv"))

(defn Stat2Data-SugarEthanol
  "Fetch the dataset 'Stat2Data-SugarEthanol' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SugarEthanol.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SugarEthanol.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SugarEthanol.csv"))

(defn Stat2Data-SuicideChina
  "Fetch the dataset 'Stat2Data-SuicideChina' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SuicideChina.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/SuicideChina.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/SuicideChina.csv"))

(defn Stat2Data-Swahili
  "Fetch the dataset 'Stat2Data-Swahili' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Swahili.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Swahili.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Swahili.csv"))

(defn Stat2Data-Tadpoles
  "Fetch the dataset 'Stat2Data-Tadpoles' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Tadpoles.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Tadpoles.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Tadpoles.csv"))

(defn Stat2Data-TechStocks
  "Fetch the dataset 'Stat2Data-TechStocks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TechStocks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TechStocks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TechStocks.csv"))

(defn Stat2Data-TeenPregnancy
  "Fetch the dataset 'Stat2Data-TeenPregnancy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TeenPregnancy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TeenPregnancy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TeenPregnancy.csv"))

(defn Stat2Data-TextPrices
  "Fetch the dataset 'Stat2Data-TextPrices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TextPrices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TextPrices.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TextPrices.csv"))

(defn Stat2Data-ThomasConfirmation
  "Fetch the dataset 'Stat2Data-ThomasConfirmation' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThomasConfirmation.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThomasConfirmation.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ThomasConfirmation.csv"))

(defn Stat2Data-ThreeCars
  "Fetch the dataset 'Stat2Data-ThreeCars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThreeCars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThreeCars.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ThreeCars.csv"))

(defn Stat2Data-ThreeCars2017
  "Fetch the dataset 'Stat2Data-ThreeCars2017' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThreeCars2017.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/ThreeCars2017.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/ThreeCars2017.csv"))

(defn Stat2Data-TipJoke
  "Fetch the dataset 'Stat2Data-TipJoke' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TipJoke.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TipJoke.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TipJoke.csv"))

(defn Stat2Data-Titanic
  "Fetch the dataset 'Stat2Data-Titanic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Titanic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Titanic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Titanic.csv"))

(defn Stat2Data-TMS
  "Fetch the dataset 'Stat2Data-TMS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TMS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TMS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TMS.csv"))

(defn Stat2Data-TomlinsonRush
  "Fetch the dataset 'Stat2Data-TomlinsonRush' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TomlinsonRush.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TomlinsonRush.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TomlinsonRush.csv"))

(defn Stat2Data-TwinsLungs
  "Fetch the dataset 'Stat2Data-TwinsLungs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TwinsLungs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/TwinsLungs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/TwinsLungs.csv"))

(defn Stat2Data-Undoing
  "Fetch the dataset 'Stat2Data-Undoing' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Undoing.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Undoing.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Undoing.csv"))

(defn Stat2Data-USstamps
  "Fetch the dataset 'Stat2Data-USstamps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/USstamps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/USstamps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/USstamps.csv"))

(defn Stat2Data-VisualVerbal
  "Fetch the dataset 'Stat2Data-VisualVerbal' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/VisualVerbal.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/VisualVerbal.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/VisualVerbal.csv"))

(defn Stat2Data-Volts
  "Fetch the dataset 'Stat2Data-Volts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Volts.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Volts.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Volts.csv"))

(defn Stat2Data-WalkingBabies
  "Fetch the dataset 'Stat2Data-WalkingBabies' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WalkingBabies.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WalkingBabies.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WalkingBabies.csv"))

(defn Stat2Data-WalkTheDogs
  "Fetch the dataset 'Stat2Data-WalkTheDogs' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WalkTheDogs.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WalkTheDogs.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WalkTheDogs.csv"))

(defn Stat2Data-WeightLossIncentive
  "Fetch the dataset 'Stat2Data-WeightLossIncentive' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WeightLossIncentive.csv"))

(defn Stat2Data-WeightLossIncentive4
  "Fetch the dataset 'Stat2Data-WeightLossIncentive4' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive4.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive4.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WeightLossIncentive4.csv"))

(defn Stat2Data-WeightLossIncentive7
  "Fetch the dataset 'Stat2Data-WeightLossIncentive7' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive7.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WeightLossIncentive7.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WeightLossIncentive7.csv"))

(defn Stat2Data-Whickham2
  "Fetch the dataset 'Stat2Data-Whickham2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Whickham2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Whickham2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Whickham2.csv"))

(defn Stat2Data-WordMemory
  "Fetch the dataset 'Stat2Data-WordMemory' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WordMemory.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WordMemory.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WordMemory.csv"))

(defn Stat2Data-WordsWithFriends
  "Fetch the dataset 'Stat2Data-WordsWithFriends' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WordsWithFriends.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/WordsWithFriends.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/WordsWithFriends.csv"))

(defn Stat2Data-Wrinkle
  "Fetch the dataset 'Stat2Data-Wrinkle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Wrinkle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Wrinkle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Wrinkle.csv"))

(defn Stat2Data-YouthRisk
  "Fetch the dataset 'Stat2Data-YouthRisk' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/YouthRisk.csv"))

(defn Stat2Data-YouthRisk2007
  "Fetch the dataset 'Stat2Data-YouthRisk2007' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk2007.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk2007.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/YouthRisk2007.csv"))

(defn Stat2Data-YouthRisk2009
  "Fetch the dataset 'Stat2Data-YouthRisk2009' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk2009.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/YouthRisk2009.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/YouthRisk2009.csv"))

(defn Stat2Data-Zimmerman
  "Fetch the dataset 'Stat2Data-Zimmerman' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Zimmerman.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/Stat2Data/Zimmerman.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/Stat2Data/Zimmerman.csv"))

(defn stevedata-af_crime93
  "Fetch the dataset 'stevedata-af_crime93' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/af_crime93.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/af_crime93.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/af_crime93.csv"))

(defn stevedata-african_coups
  "Fetch the dataset 'stevedata-african_coups' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/african_coups.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/african_coups.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/african_coups.csv"))

(defn stevedata-aluminum_premiums
  "Fetch the dataset 'stevedata-aluminum_premiums' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/aluminum_premiums.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/aluminum_premiums.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/aluminum_premiums.csv"))

(defn stevedata-anes_partytherms
  "Fetch the dataset 'stevedata-anes_partytherms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_partytherms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_partytherms.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/anes_partytherms.csv"))

(defn stevedata-anes_prochoice
  "Fetch the dataset 'stevedata-anes_prochoice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_prochoice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_prochoice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/anes_prochoice.csv"))

(defn stevedata-anes_vote84
  "Fetch the dataset 'stevedata-anes_vote84' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_vote84.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/anes_vote84.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/anes_vote84.csv"))

(defn stevedata-Arca
  "Fetch the dataset 'stevedata-Arca' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Arca.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Arca.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Arca.csv"))

(defn stevedata-arcticseaice
  "Fetch the dataset 'stevedata-arcticseaice' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/arcticseaice.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/arcticseaice.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/arcticseaice.csv"))

(defn stevedata-arg_tariff
  "Fetch the dataset 'stevedata-arg_tariff' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/arg_tariff.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/arg_tariff.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/arg_tariff.csv"))

(defn stevedata-asn_stats
  "Fetch the dataset 'stevedata-asn_stats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/asn_stats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/asn_stats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/asn_stats.csv"))

(defn stevedata-CFT15
  "Fetch the dataset 'stevedata-CFT15' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/CFT15.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/CFT15.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/CFT15.csv"))

(defn stevedata-clemson_temps
  "Fetch the dataset 'stevedata-clemson_temps' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/clemson_temps.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/clemson_temps.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/clemson_temps.csv"))

(defn stevedata-co2emissions
  "Fetch the dataset 'stevedata-co2emissions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/co2emissions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/co2emissions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/co2emissions.csv"))

(defn stevedata-coffee_imports
  "Fetch the dataset 'stevedata-coffee_imports' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/coffee_imports.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/coffee_imports.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/coffee_imports.csv"))

(defn stevedata-coffee_price
  "Fetch the dataset 'stevedata-coffee_price' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/coffee_price.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/coffee_price.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/coffee_price.csv"))

(defn stevedata-commodity_prices
  "Fetch the dataset 'stevedata-commodity_prices' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/commodity_prices.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/commodity_prices.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/commodity_prices.csv"))

(defn stevedata-CP77
  "Fetch the dataset 'stevedata-CP77' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/CP77.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/CP77.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/CP77.csv"))

(defn stevedata-DAPO
  "Fetch the dataset 'stevedata-DAPO' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DAPO.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DAPO.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/DAPO.csv"))

(defn stevedata-Datasaurus
  "Fetch the dataset 'stevedata-Datasaurus' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Datasaurus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Datasaurus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Datasaurus.csv"))

(defn stevedata-DCE12
  "Fetch the dataset 'stevedata-DCE12' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DCE12.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DCE12.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/DCE12.csv"))

(defn stevedata-Dee04
  "Fetch the dataset 'stevedata-Dee04' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Dee04.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Dee04.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Dee04.csv"))

(defn stevedata-DJIA
  "Fetch the dataset 'stevedata-DJIA' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DJIA.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DJIA.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/DJIA.csv"))

(defn stevedata-DST
  "Fetch the dataset 'stevedata-DST' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DST.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/DST.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/DST.csv"))

(defn stevedata-EBJ
  "Fetch the dataset 'stevedata-EBJ' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/EBJ.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/EBJ.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/EBJ.csv"))

(defn stevedata-eight_schools
  "Fetch the dataset 'stevedata-eight_schools' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eight_schools.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eight_schools.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/eight_schools.csv"))

(defn stevedata-election_turnout
  "Fetch the dataset 'stevedata-election_turnout' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/election_turnout.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/election_turnout.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/election_turnout.csv"))

(defn stevedata-eq_passengercars
  "Fetch the dataset 'stevedata-eq_passengercars' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eq_passengercars.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eq_passengercars.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/eq_passengercars.csv"))

(defn stevedata-ESS10NO
  "Fetch the dataset 'stevedata-ESS10NO' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESS10NO.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESS10NO.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ESS10NO.csv"))

(defn stevedata-ESS9GB
  "Fetch the dataset 'stevedata-ESS9GB' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESS9GB.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESS9GB.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ESS9GB.csv"))

(defn stevedata-ESSBE5
  "Fetch the dataset 'stevedata-ESSBE5' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESSBE5.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ESSBE5.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ESSBE5.csv"))

(defn stevedata-eurostat_codes
  "Fetch the dataset 'stevedata-eurostat_codes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eurostat_codes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eurostat_codes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/eurostat_codes.csv"))

(defn stevedata-eustates
  "Fetch the dataset 'stevedata-eustates' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eustates.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/eustates.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/eustates.csv"))

(defn stevedata-fakeAPI
  "Fetch the dataset 'stevedata-fakeAPI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeAPI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeAPI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/fakeAPI.csv"))

(defn stevedata-fakeHappiness
  "Fetch the dataset 'stevedata-fakeHappiness' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeHappiness.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeHappiness.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/fakeHappiness.csv"))

(defn stevedata-fakeLogit
  "Fetch the dataset 'stevedata-fakeLogit' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeLogit.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeLogit.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/fakeLogit.csv"))

(defn stevedata-fakeTSCS
  "Fetch the dataset 'stevedata-fakeTSCS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeTSCS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeTSCS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/fakeTSCS.csv"))

(defn stevedata-fakeTSD
  "Fetch the dataset 'stevedata-fakeTSD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeTSD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/fakeTSD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/fakeTSD.csv"))

(defn stevedata-ghp100k
  "Fetch the dataset 'stevedata-ghp100k' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ghp100k.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ghp100k.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ghp100k.csv"))

(defn stevedata-GHR04
  "Fetch the dataset 'stevedata-GHR04' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/GHR04.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/GHR04.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/GHR04.csv"))

(defn stevedata-gss_abortion
  "Fetch the dataset 'stevedata-gss_abortion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_abortion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_abortion.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/gss_abortion.csv"))

(defn stevedata-gss_spending
  "Fetch the dataset 'stevedata-gss_spending' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_spending.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_spending.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/gss_spending.csv"))

(defn stevedata-gss_wages
  "Fetch the dataset 'stevedata-gss_wages' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_wages.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/gss_wages.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/gss_wages.csv"))

(defn stevedata-Guber99
  "Fetch the dataset 'stevedata-Guber99' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Guber99.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Guber99.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Guber99.csv"))

(defn stevedata-illiteracy30
  "Fetch the dataset 'stevedata-illiteracy30' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/illiteracy30.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/illiteracy30.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/illiteracy30.csv"))

(defn stevedata-inglehart03
  "Fetch the dataset 'stevedata-inglehart03' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/inglehart03.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/inglehart03.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/inglehart03.csv"))

(defn stevedata-Lipset59
  "Fetch the dataset 'stevedata-Lipset59' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Lipset59.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Lipset59.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Lipset59.csv"))

(defn stevedata-LOTI
  "Fetch the dataset 'stevedata-LOTI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LOTI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LOTI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/LOTI.csv"))

(defn stevedata-LTPT
  "Fetch the dataset 'stevedata-LTPT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LTPT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LTPT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/LTPT.csv"))

(defn stevedata-LTWT
  "Fetch the dataset 'stevedata-LTWT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LTWT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/LTWT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/LTWT.csv"))

(defn stevedata-min_wage
  "Fetch the dataset 'stevedata-min_wage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/min_wage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/min_wage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/min_wage.csv"))

(defn stevedata-mm_mlda
  "Fetch the dataset 'stevedata-mm_mlda' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mm_mlda.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mm_mlda.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/mm_mlda.csv"))

(defn stevedata-mm_nhis
  "Fetch the dataset 'stevedata-mm_nhis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mm_nhis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mm_nhis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/mm_nhis.csv"))

(defn stevedata-mvprod
  "Fetch the dataset 'stevedata-mvprod' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mvprod.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/mvprod.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/mvprod.csv"))

(defn stevedata-nesarc_drinkspd
  "Fetch the dataset 'stevedata-nesarc_drinkspd' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/nesarc_drinkspd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/nesarc_drinkspd.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/nesarc_drinkspd.csv"))

(defn stevedata-Newhouse77
  "Fetch the dataset 'stevedata-Newhouse77' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Newhouse77.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Newhouse77.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Newhouse77.csv"))

(defn stevedata-ODGI
  "Fetch the dataset 'stevedata-ODGI' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ODGI.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ODGI.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ODGI.csv"))

(defn stevedata-OODTPT
  "Fetch the dataset 'stevedata-OODTPT' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/OODTPT.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/OODTPT.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/OODTPT.csv"))

(defn stevedata-PPGE
  "Fetch the dataset 'stevedata-PPGE' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/PPGE.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/PPGE.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/PPGE.csv"))

(defn stevedata-PRDEG
  "Fetch the dataset 'stevedata-PRDEG' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/PRDEG.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/PRDEG.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/PRDEG.csv"))

(defn stevedata-Presidents
  "Fetch the dataset 'stevedata-Presidents' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Presidents.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/Presidents.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/Presidents.csv"))

(defn stevedata-pwt_sample
  "Fetch the dataset 'stevedata-pwt_sample' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/pwt_sample.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/pwt_sample.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/pwt_sample.csv"))

(defn stevedata-quartets
  "Fetch the dataset 'stevedata-quartets' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/quartets.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/quartets.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/quartets.csv"))

(defn stevedata-recessions
  "Fetch the dataset 'stevedata-recessions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/recessions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/recessions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/recessions.csv"))

(defn stevedata-SBCD
  "Fetch the dataset 'stevedata-SBCD' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/SBCD.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/SBCD.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/SBCD.csv"))

(defn stevedata-scb_regions
  "Fetch the dataset 'stevedata-scb_regions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/scb_regions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/scb_regions.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/scb_regions.csv"))

(defn stevedata-SCP16
  "Fetch the dataset 'stevedata-SCP16' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/SCP16.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/SCP16.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/SCP16.csv"))

(defn stevedata-sealevels
  "Fetch the dataset 'stevedata-sealevels' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sealevels.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sealevels.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/sealevels.csv"))

(defn stevedata-so2concentrations
  "Fetch the dataset 'stevedata-so2concentrations' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/so2concentrations.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/so2concentrations.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/so2concentrations.csv"))

(defn stevedata-states_war
  "Fetch the dataset 'stevedata-states_war' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/states_war.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/states_war.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/states_war.csv"))

(defn stevedata-steves_clothes
  "Fetch the dataset 'stevedata-steves_clothes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/steves_clothes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/steves_clothes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/steves_clothes.csv"))

(defn stevedata-sugar_price
  "Fetch the dataset 'stevedata-sugar_price' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sugar_price.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sugar_price.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/sugar_price.csv"))

(defn stevedata-sweden_counties
  "Fetch the dataset 'stevedata-sweden_counties' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sweden_counties.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/sweden_counties.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/sweden_counties.csv"))

(defn stevedata-thatcher_approval
  "Fetch the dataset 'stevedata-thatcher_approval' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/thatcher_approval.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/thatcher_approval.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/thatcher_approval.csv"))

(defn stevedata-therms
  "Fetch the dataset 'stevedata-therms' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/therms.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/therms.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/therms.csv"))

(defn stevedata-turnips
  "Fetch the dataset 'stevedata-turnips' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/turnips.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/turnips.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/turnips.csv"))

(defn stevedata-TV16
  "Fetch the dataset 'stevedata-TV16' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/TV16.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/TV16.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/TV16.csv"))

(defn stevedata-ukg_eeri
  "Fetch the dataset 'stevedata-ukg_eeri' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ukg_eeri.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/ukg_eeri.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/ukg_eeri.csv"))

(defn stevedata-uniondensity
  "Fetch the dataset 'stevedata-uniondensity' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/uniondensity.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/uniondensity.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/uniondensity.csv"))

(defn stevedata-usa_chn_gdp_forecasts
  "Fetch the dataset 'stevedata-usa_chn_gdp_forecasts' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_chn_gdp_forecasts.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_chn_gdp_forecasts.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/usa_chn_gdp_forecasts.csv"))

(defn stevedata-usa_computers
  "Fetch the dataset 'stevedata-usa_computers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_computers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_computers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/usa_computers.csv"))

(defn stevedata-usa_migration
  "Fetch the dataset 'stevedata-usa_migration' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_migration.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_migration.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/usa_migration.csv"))

(defn stevedata-usa_states
  "Fetch the dataset 'stevedata-usa_states' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_states.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_states.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/usa_states.csv"))

(defn stevedata-usa_tradegdp
  "Fetch the dataset 'stevedata-usa_tradegdp' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_tradegdp.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/usa_tradegdp.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/usa_tradegdp.csv"))

(defn stevedata-USFAHR
  "Fetch the dataset 'stevedata-USFAHR' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/USFAHR.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/USFAHR.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/USFAHR.csv"))

(defn stevedata-voteincome
  "Fetch the dataset 'stevedata-voteincome' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/voteincome.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/voteincome.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/voteincome.csv"))

(defn stevedata-wbd_example
  "Fetch the dataset 'stevedata-wbd_example' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wbd_example.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wbd_example.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wbd_example.csv"))

(defn stevedata-wvs_ccodes
  "Fetch the dataset 'stevedata-wvs_ccodes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_ccodes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_ccodes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_ccodes.csv"))

(defn stevedata-wvs_immig
  "Fetch the dataset 'stevedata-wvs_immig' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_immig.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_immig.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_immig.csv"))

(defn stevedata-wvs_justifbribe
  "Fetch the dataset 'stevedata-wvs_justifbribe' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_justifbribe.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_justifbribe.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_justifbribe.csv"))

(defn stevedata-wvs_usa_abortion
  "Fetch the dataset 'stevedata-wvs_usa_abortion' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_abortion.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_abortion.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_usa_abortion.csv"))

(defn stevedata-wvs_usa_educat
  "Fetch the dataset 'stevedata-wvs_usa_educat' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_educat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_educat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_usa_educat.csv"))

(defn stevedata-wvs_usa_regions
  "Fetch the dataset 'stevedata-wvs_usa_regions' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_regions.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/wvs_usa_regions.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/wvs_usa_regions.csv"))

(defn stevedata-yugo_sales
  "Fetch the dataset 'stevedata-yugo_sales' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/yugo_sales.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/stevedata/yugo_sales.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/stevedata/yugo_sales.csv"))

(defn survival-amlcancer
  "Fetch the dataset 'survival-aml (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/aml.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/aml.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/aml.csv"))

(defn survival-bladdercancer
  "Fetch the dataset 'survival-bladder (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/bladder.csv"))

(defn survival-bladder1cancer
  "Fetch the dataset 'survival-bladder1 (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/bladder1.csv"))

(defn survival-bladder2cancer
  "Fetch the dataset 'survival-bladder2 (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/bladder2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/bladder2.csv"))

(defn survival-cancer
  "Fetch the dataset 'survival-cancer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/cancer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/cancer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/cancer.csv"))

(defn survival-capacitorreliability
  "Fetch the dataset 'survival-capacitor (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/capacitor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/capacitor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/capacitor.csv"))

(defn survival-cgd
  "Fetch the dataset 'survival-cgd' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/cgd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/cgd.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/cgd.csv"))

(defn survival-cgd0cgd
  "Fetch the dataset 'survival-cgd0 (cgd)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/cgd0.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/cgd0.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/cgd0.csv"))

(defn survival-coloncancer
  "Fetch the dataset 'survival-colon (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/colon.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/colon.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/colon.csv"))

(defn survival-cracksreliability
  "Fetch the dataset 'survival-cracks (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/cracks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/cracks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/cracks.csv"))

(defn survival-diabetic
  "Fetch the dataset 'survival-diabetic' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/diabetic.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/diabetic.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/diabetic.csv"))

(defn survival-flchain
  "Fetch the dataset 'survival-flchain' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/flchain.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/flchain.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/flchain.csv"))

(defn survival-gbsgcancer
  "Fetch the dataset 'survival-gbsg (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/gbsg.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/gbsg.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/gbsg.csv"))

(defn survival-genfanreliability
  "Fetch the dataset 'survival-genfan (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/genfan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/genfan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/genfan.csv"))

(defn survival-heart
  "Fetch the dataset 'survival-heart' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/heart.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/heart.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/heart.csv"))

(defn survival-hoelcancer
  "Fetch the dataset 'survival-hoel (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/hoel.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/hoel.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/hoel.csv"))

(defn survival-ifluidreliability
  "Fetch the dataset 'survival-ifluid (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/ifluid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/ifluid.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/ifluid.csv"))

(defn survival-imotorreliability
  "Fetch the dataset 'survival-imotor (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/imotor.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/imotor.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/imotor.csv"))

(defn survival-jasaheart
  "Fetch the dataset 'survival-jasa (heart)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/jasa.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/jasa.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/jasa.csv"))

(defn survival-jasa1heart
  "Fetch the dataset 'survival-jasa1 (heart)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/jasa1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/jasa1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/jasa1.csv"))

(defn survival-kidneycancer
  "Fetch the dataset 'survival-kidney (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/kidney.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/kidney.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/kidney.csv"))

(defn survival-leukemiacancer
  "Fetch the dataset 'survival-leukemia (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/leukemia.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/leukemia.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/leukemia.csv"))

(defn survival-logan
  "Fetch the dataset 'survival-logan' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/logan.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/logan.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/logan.csv"))

(defn survival-lungcancer
  "Fetch the dataset 'survival-lung (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/lung.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/lung.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/lung.csv"))

(defn survival-mguscancer
  "Fetch the dataset 'survival-mgus (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/mgus.csv"))

(defn survival-mgus1cancer
  "Fetch the dataset 'survival-mgus1 (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/mgus1.csv"))

(defn survival-mgus2cancer
  "Fetch the dataset 'survival-mgus2 (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/mgus2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/mgus2.csv"))

(defn survival-myeloidcancer
  "Fetch the dataset 'survival-myeloid (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/myeloid.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/myeloid.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/myeloid.csv"))

(defn survival-myelomacancer
  "Fetch the dataset 'survival-myeloma (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/myeloma.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/myeloma.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/myeloma.csv"))

(defn survival-nafld1nafld
  "Fetch the dataset 'survival-nafld1 (nafld)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/nafld1.csv"))

(defn survival-nafld2nafld
  "Fetch the dataset 'survival-nafld2 (nafld)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/nafld2.csv"))

(defn survival-nafld3nafld
  "Fetch the dataset 'survival-nafld3 (nafld)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/nafld3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/nafld3.csv"))

(defn survival-nwtco
  "Fetch the dataset 'survival-nwtco' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/nwtco.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/nwtco.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/nwtco.csv"))

(defn survival-ovariancancer
  "Fetch the dataset 'survival-ovarian (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/ovarian.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/ovarian.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/ovarian.csv"))

(defn survival-pbc
  "Fetch the dataset 'survival-pbc' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/pbc.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/pbc.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/pbc.csv"))

(defn survival-pbcseqpbc
  "Fetch the dataset 'survival-pbcseq (pbc)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/pbcseq.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/pbcseq.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/pbcseq.csv"))

(defn survival-ratscancer
  "Fetch the dataset 'survival-rats (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/rats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/rats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/rats.csv"))

(defn survival-rats2cancer
  "Fetch the dataset 'survival-rats2 (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/rats2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/rats2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/rats2.csv"))

(defn survival-retinopathy
  "Fetch the dataset 'survival-retinopathy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/retinopathy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/retinopathy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/retinopathy.csv"))

(defn survival-rhDNase
  "Fetch the dataset 'survival-rhDNase' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/rhDNase.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/rhDNase.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/rhDNase.csv"))

(defn survival-rotterdamcancer
  "Fetch the dataset 'survival-rotterdam (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/rotterdam.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/rotterdam.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/rotterdam.csv"))

(defn survival-solder
  "Fetch the dataset 'survival-solder' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/solder.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/solder.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/solder.csv"))

(defn survival-stanford2heart
  "Fetch the dataset 'survival-stanford2 (heart)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/stanford2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/stanford2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/stanford2.csv"))

(defn survival-survexp.mnsurvexp
  "Fetch the dataset 'survival-survexp.mn (survexp)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.mn.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.mn.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/survexp.mn.csv"))

(defn survival-survexp.ussurvexp
  "Fetch the dataset 'survival-survexp.us (survexp)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.us.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.us.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/survexp.us.csv"))

(defn survival-survexp.usrsurvexp
  "Fetch the dataset 'survival-survexp.usr (survexp)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.usr.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/survexp.usr.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/survexp.usr.csv"))

(defn survival-tobin
  "Fetch the dataset 'survival-tobin' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/tobin.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/tobin.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/tobin.csv"))

(defn survival-transplant
  "Fetch the dataset 'survival-transplant' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/transplant.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/transplant.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/transplant.csv"))

(defn survival-turbinereliability
  "Fetch the dataset 'survival-turbine (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/turbine.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/turbine.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/turbine.csv"))

(defn survival-udca
  "Fetch the dataset 'survival-udca' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/udca.csv"))

(defn survival-udca1udca
  "Fetch the dataset 'survival-udca1 (udca)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/udca1.csv"))

(defn survival-udca2udca
  "Fetch the dataset 'survival-udca2 (udca)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/udca2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/udca2.csv"))

(defn survival-uspop2survexp
  "Fetch the dataset 'survival-uspop2 (survexp)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/uspop2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/uspop2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/uspop2.csv"))

(defn survival-valveSeatreliability
  "Fetch the dataset 'survival-valveSeat (reliability)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/valveSeat.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/valveSeat.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/valveSeat.csv"))

(defn survival-veterancancer
  "Fetch the dataset 'survival-veteran (cancer)' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/survival/veteran.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/survival/veteran.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/survival/veteran.csv"))

(defn texmex-liver
  "Fetch the dataset 'texmex-liver' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/liver.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/liver.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/liver.csv"))

(defn texmex-nidd
  "Fetch the dataset 'texmex-nidd' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/nidd.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/nidd.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/nidd.csv"))

(defn texmex-portpirie
  "Fetch the dataset 'texmex-portpirie' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/portpirie.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/portpirie.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/portpirie.csv"))

(defn texmex-rain
  "Fetch the dataset 'texmex-rain' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/rain.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/rain.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/rain.csv"))

(defn texmex-summer
  "Fetch the dataset 'texmex-summer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/summer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/summer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/summer.csv"))

(defn texmex-wavesurge
  "Fetch the dataset 'texmex-wavesurge' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/wavesurge.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/wavesurge.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/wavesurge.csv"))

(defn texmex-winter
  "Fetch the dataset 'texmex-winter' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/texmex/winter.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/texmex/winter.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/texmex/winter.csv"))

(defn tidyr-billboard
  "Fetch the dataset 'tidyr-billboard' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/billboard.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/billboard.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/billboard.csv"))

(defn tidyr-cms_patient_care
  "Fetch the dataset 'tidyr-cms_patient_care' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/cms_patient_care.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/cms_patient_care.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/cms_patient_care.csv"))

(defn tidyr-cms_patient_experience
  "Fetch the dataset 'tidyr-cms_patient_experience' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/cms_patient_experience.html"
  {:doc-link
   "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/cms_patient_experience.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/cms_patient_experience.csv"))

(defn tidyr-construction
  "Fetch the dataset 'tidyr-construction' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/construction.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/construction.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/construction.csv"))

(defn tidyr-fish_encounters
  "Fetch the dataset 'tidyr-fish_encounters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/fish_encounters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/fish_encounters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/fish_encounters.csv"))

(defn tidyr-household
  "Fetch the dataset 'tidyr-household' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/household.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/household.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/household.csv"))

(defn tidyr-population
  "Fetch the dataset 'tidyr-population' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/population.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/population.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/population.csv"))

(defn tidyr-relig_income
  "Fetch the dataset 'tidyr-relig_income' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/relig_income.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/relig_income.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/relig_income.csv"))

(defn tidyr-smiths
  "Fetch the dataset 'tidyr-smiths' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/smiths.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/smiths.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/smiths.csv"))

(defn tidyr-table1
  "Fetch the dataset 'tidyr-table1' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table1.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table1.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table1.csv"))

(defn tidyr-table2
  "Fetch the dataset 'tidyr-table2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table2.csv"))

(defn tidyr-table3
  "Fetch the dataset 'tidyr-table3' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table3.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table3.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table3.csv"))

(defn tidyr-table4a
  "Fetch the dataset 'tidyr-table4a' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table4a.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table4a.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table4a.csv"))

(defn tidyr-table4b
  "Fetch the dataset 'tidyr-table4b' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table4b.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table4b.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table4b.csv"))

(defn tidyr-table5
  "Fetch the dataset 'tidyr-table5' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table5.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/table5.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/table5.csv"))

(defn tidyr-us_rent_income
  "Fetch the dataset 'tidyr-us_rent_income' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/us_rent_income.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/us_rent_income.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/us_rent_income.csv"))

(defn tidyr-who
  "Fetch the dataset 'tidyr-who' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/who.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/who.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/who.csv"))

(defn tidyr-who2
  "Fetch the dataset 'tidyr-who2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/who2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/who2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/who2.csv"))

(defn tidyr-world_bank_pop
  "Fetch the dataset 'tidyr-world_bank_pop' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/world_bank_pop.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tidyr/world_bank_pop.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tidyr/world_bank_pop.csv"))

(defn tsibble-pedestrian
  "Fetch the dataset 'tsibble-pedestrian' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibble/pedestrian.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibble/pedestrian.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibble/pedestrian.csv"))

(defn tsibble-tourism
  "Fetch the dataset 'tsibble-tourism' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibble/tourism.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibble/tourism.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibble/tourism.csv"))

(defn tsibbledata-ansett
  "Fetch the dataset 'tsibbledata-ansett' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/ansett.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/ansett.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/ansett.csv"))

(defn tsibbledata-aus_livestock
  "Fetch the dataset 'tsibbledata-aus_livestock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_livestock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_livestock.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/aus_livestock.csv"))

(defn tsibbledata-aus_production
  "Fetch the dataset 'tsibbledata-aus_production' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_production.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_production.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/aus_production.csv"))

(defn tsibbledata-aus_retail
  "Fetch the dataset 'tsibbledata-aus_retail' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_retail.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/aus_retail.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/aus_retail.csv"))

(defn tsibbledata-gafa_stock
  "Fetch the dataset 'tsibbledata-gafa_stock' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/gafa_stock.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/gafa_stock.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/gafa_stock.csv"))

(defn tsibbledata-global_economy
  "Fetch the dataset 'tsibbledata-global_economy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/global_economy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/global_economy.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/global_economy.csv"))

(defn tsibbledata-hh_budget
  "Fetch the dataset 'tsibbledata-hh_budget' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/hh_budget.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/hh_budget.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/hh_budget.csv"))

(defn tsibbledata-nyc_bikes
  "Fetch the dataset 'tsibbledata-nyc_bikes' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/nyc_bikes.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/nyc_bikes.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/nyc_bikes.csv"))

(defn tsibbledata-olympic_running
  "Fetch the dataset 'tsibbledata-olympic_running' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/olympic_running.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/olympic_running.html"}
  []
  (fetch-dataset
    "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/olympic_running.csv"))

(defn tsibbledata-PBS
  "Fetch the dataset 'tsibbledata-PBS' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/PBS.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/PBS.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/PBS.csv"))

(defn tsibbledata-pelt
  "Fetch the dataset 'tsibbledata-pelt' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/pelt.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/pelt.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/pelt.csv"))

(defn tsibbledata-vic_elec
  "Fetch the dataset 'tsibbledata-vic_elec' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/vic_elec.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/tsibbledata/vic_elec.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/tsibbledata/vic_elec.csv"))

(defn validate-nace_rev2
  "Fetch the dataset 'validate-nace_rev2' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/validate/nace_rev2.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/validate/nace_rev2.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/validate/nace_rev2.csv"))

(defn validate-retailers
  "Fetch the dataset 'validate-retailers' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/validate/retailers.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/validate/retailers.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/validate/retailers.csv"))

(defn validate-samplonomy
  "Fetch the dataset 'validate-samplonomy' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/validate/samplonomy.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/validate/samplonomy.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/validate/samplonomy.csv"))

(defn validate-SBS2000
  "Fetch the dataset 'validate-SBS2000' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/validate/SBS2000.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/validate/SBS2000.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/validate/SBS2000.csv"))

(defn vcd-Arthritis
  "Fetch the dataset 'vcd-Arthritis' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Arthritis.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Arthritis.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Arthritis.csv"))

(defn vcd-Baseball
  "Fetch the dataset 'vcd-Baseball' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Baseball.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Baseball.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Baseball.csv"))

(defn vcd-BrokenMarriage
  "Fetch the dataset 'vcd-BrokenMarriage' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/BrokenMarriage.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/BrokenMarriage.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/BrokenMarriage.csv"))

(defn vcd-Bundesliga
  "Fetch the dataset 'vcd-Bundesliga' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Bundesliga.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Bundesliga.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Bundesliga.csv"))

(defn vcd-Bundestag2005
  "Fetch the dataset 'vcd-Bundestag2005' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Bundestag2005.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Bundestag2005.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Bundestag2005.csv"))

(defn vcd-Butterfly
  "Fetch the dataset 'vcd-Butterfly' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Butterfly.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Butterfly.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Butterfly.csv"))

(defn vcd-CoalMiners
  "Fetch the dataset 'vcd-CoalMiners' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/CoalMiners.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/CoalMiners.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/CoalMiners.csv"))

(defn vcd-DanishWelfare
  "Fetch the dataset 'vcd-DanishWelfare' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/DanishWelfare.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/DanishWelfare.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/DanishWelfare.csv"))

(defn vcd-Employment
  "Fetch the dataset 'vcd-Employment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Employment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Employment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Employment.csv"))

(defn vcd-Federalist
  "Fetch the dataset 'vcd-Federalist' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Federalist.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Federalist.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Federalist.csv"))

(defn vcd-Hitters
  "Fetch the dataset 'vcd-Hitters' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Hitters.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Hitters.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Hitters.csv"))

(defn vcd-HorseKicks
  "Fetch the dataset 'vcd-HorseKicks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/HorseKicks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/HorseKicks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/HorseKicks.csv"))

(defn vcd-Hospital
  "Fetch the dataset 'vcd-Hospital' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Hospital.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Hospital.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Hospital.csv"))

(defn vcd-JobSatisfaction
  "Fetch the dataset 'vcd-JobSatisfaction' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/JobSatisfaction.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/JobSatisfaction.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/JobSatisfaction.csv"))

(defn vcd-JointSports
  "Fetch the dataset 'vcd-JointSports' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/JointSports.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/JointSports.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/JointSports.csv"))

(defn vcd-Lifeboats
  "Fetch the dataset 'vcd-Lifeboats' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Lifeboats.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Lifeboats.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Lifeboats.csv"))

(defn vcd-MSPatients
  "Fetch the dataset 'vcd-MSPatients' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/MSPatients.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/MSPatients.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/MSPatients.csv"))

(defn vcd-NonResponse
  "Fetch the dataset 'vcd-NonResponse' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/NonResponse.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/NonResponse.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/NonResponse.csv"))

(defn vcd-OvaryCancer
  "Fetch the dataset 'vcd-OvaryCancer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/OvaryCancer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/OvaryCancer.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/OvaryCancer.csv"))

(defn vcd-PreSex
  "Fetch the dataset 'vcd-PreSex' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/PreSex.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/PreSex.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/PreSex.csv"))

(defn vcd-Punishment
  "Fetch the dataset 'vcd-Punishment' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Punishment.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Punishment.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Punishment.csv"))

(defn vcd-RepVict
  "Fetch the dataset 'vcd-RepVict' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/RepVict.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/RepVict.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/RepVict.csv"))

(defn vcd-Rochdale
  "Fetch the dataset 'vcd-Rochdale' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Rochdale.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Rochdale.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Rochdale.csv"))

(defn vcd-Saxony
  "Fetch the dataset 'vcd-Saxony' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Saxony.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Saxony.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Saxony.csv"))

(defn vcd-SexualFun
  "Fetch the dataset 'vcd-SexualFun' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/SexualFun.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/SexualFun.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/SexualFun.csv"))

(defn vcd-SpaceShuttle
  "Fetch the dataset 'vcd-SpaceShuttle' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/SpaceShuttle.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/SpaceShuttle.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/SpaceShuttle.csv"))

(defn vcd-Suicide
  "Fetch the dataset 'vcd-Suicide' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Suicide.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Suicide.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Suicide.csv"))

(defn vcd-Trucks
  "Fetch the dataset 'vcd-Trucks' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Trucks.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/Trucks.html"}
  []
  (fetch-dataset "https://vincentarelbundock.github.io/Rdatasets/csv/vcd/Trucks.csv"))

(defn vcd-UKSoccer
  "Fetch the dataset 'vcd-UKSoccer' from rdatasets. \n                                               \n                                               Data description: https://vincentarelbundock.github.io/Rdatasets/doc/vcd/UKSoccer.html"
  {:doc-link "https://vincentarelbundock.github.io/Rdatasets/doc/vcd/UKSoc