(ns scicloj.kindly-render.api)

(defn visualize [note]
  (let [notebook (hiccups/with-hiccups {:notes          [note]
                                        :kindly/options {:deps    #{:kindly :clay}
                                                         ;; TODO: there's a problem showing embedded js
                                                         :package :embed}})
        ;; TODO: maybe there should be an api call to create a single page notebook
        kind (get-in notebook [:notes 0 :kind])
        hiccups (to-hiccup-page/hiccups notebook)]
    (when (and kind (seq hiccups))
      {:html (to-html-page/page notebook)
       :kind (pr-str kind)})))
