(ns scicloj.clay.v2.tool.scittle.three-d-mol
  (:require [scicloj.clay.v2.tool.scittle.widget :as widget]))

(def three-d-mol-viewer-cljs
  '(defn three-d-mol-viewer
     [{:keys [data-pdb]}]
     [:div {:style {:height "400px"
                    :width "400px"
                    :position :relative}
            :class "viewer_3Dmoljs"
            :data-pdb data-pdb
            :data-backgroundcolor "0xffffff"
            :data-style "stick"
            :data-ui true}]))

(def three-d-mol-cljs
  '(defn three-d-mol
     [{:keys [pdb]}]
     [:div
      {:style {:width "100%"
               :height "500px"
               :position "relative"}
       :ref (fn [el]
              (let [config (clj->js
                            {:backgroundColor "0xffffff"})
                    viewer (.createViewer js/$3Dmol el config)]
                (.setViewStyle viewer (cljs->js
                                       {:style "outline"}))
                (.addModelsAsFrames viewer pdb "pdb")
                (.addSphere viewer (clj->js
                                    {:center {:x 0
                                              :y 0
                                              :z 0}
                                     :radius 3
                                     :color "green"}))
                (.zoomTo viewer)
                (.render viewer)
                (.zoom viewer 0.8 2000)))}]))
