(ns ifast.meal-record
  (:require #?(:clj [clojure.spec.alpha :as s]
               :cljs [cljs.spec.alpha :as s])))

(s/def ::timestamp int?)

(s/def ::last-meal-at (s/or :timestamp ::timestamp
                            :none-yet  nil?))
(s/def ::meal-record (s/keys :req [::last-meal-at]))

(defn empty-record
  "Create an empty meal record."
  []
  {::last-meal-at nil})

(defn last-meal
  "Get the last meal of a meal record."
  [meal-record]
  (::last-meal-at meal-record))

(s/fdef record-meal-at
        :args (s/cat :meal-record ::meal-record :timestamp ::timestamp)
        :ret  ::meal-record)

(defn record-meal-at
  "Record a `timestamp` as the latest meal."
  [meal-record timestamp]
  (assoc meal-record ::last-meal-at timestamp))
