# bg-plus is a build tool based on Badigeon.

Badigeon is a build library based on tools.deps. Badigeon can be used to:

- Compile java sources
- AOT compile Clojure sources
- Package a project as a jar file
- Install jar files to the local maven repository
- Install jar files to remote maven repository
- Sign jar files
- Package a project into a standalone bundle with a start script
- Package a project as an uberjar file
- Produce a custom JRE runtime using jlink
- Package a project as a war file
- Execute shell commands in a separate process

# Release information

The main goal of this fork is to maintain all functionality as close as possible to its
original and also have slightly more high level functions when building jar/uberjar.
All hard work is made by Ewen Grosjean.

This fork differs from its original with the following functionality:
- overwrite (by default) same class from multiple jars with warning, during uberjar building.
- show details about class presence in multiple places (jars).
- put this library as jar artifact into clojars (original is not in clojars).
- high level functions to build config based on file build.edn
- high level functions to run build process jar/uberjar based on build config
- main function to run high level tasks.

[deps.edn](https://clojure.org/guides/deps_and_cli) dependency information:

[![Clojars Project](https://img.shields.io/clojars/v/org.rssys/bg-plus.svg)](https://clojars.org/org.rssys/bg-plus)

# Badigeon API

[API usage](https://github.com/EwenG/badigeon/blob/master/API.md)

[Sample file](https://github.com/EwenG/badigeon/blob/master/sample/badigeon/sample.clj)

# bp-plus API

---

## bg-plus License

Copyright 2020 Mike Ananev

The use and distribution terms for this software are covered by the
Eclipse Public License 2.0.

## Badigeon License

Copyright 2019 Ewen Grosjean.

The use and distribution terms for this software are covered by the
Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0)
which can be found in the file [epl-v10.html](epl-v10.html) at the root of this distribution.

By using this software in any fashion, you are agreeing to be bound by
the terms of this license.

You must not remove this notice, or any other, from this software.
