(ns routom-bidi.core
  (:require [bidi.bidi :as b]
            [clojure.string :as s]))

(def children-key :sub-routes)

(def routes-atom (atom nil))

(defn- routes->bidi-route
  ([routes]
   (let [bidi-routes (routes->bidi-route {children-key routes} [])]
     ["" bidi-routes]))
  ([routes hierarchy]
   (let [sub-routes (get routes children-key)]
     (reduce-kv
       (fn [hier k v]
         (let [path (:bidi/path v)
               new-hier [path k]]
           (if (contains? v children-key)
             (if path
               (conj hier [path (into [["" k]] (routes->bidi-route v []))])
               (routes->bidi-route v hier))
             (conj hier new-hier)))) hierarchy sub-routes))))

(defn start-bidi-router!
  [history set-active-route! routes]
  (reset! routes-atom (routes->bidi-route @routes))

  (let []

    (letfn [
            (token->location [token]
              (or (b/match-route @routes-atom token)
                  "/"))


            (on-navigate [location]
              (let [{:keys [handler route-params]} (token->location (.-pathname location))]
                (set-active-route!
                  {:route/name   handler
                   :route/params route-params})))]
      (let [initial-token (let [token (.getCurrentLocation history)]
                            (if-not (s/blank? token)
                              token
                              "/"))


            unlisten (.listen history
                              on-navigate)]

        (.replace history initial-token)
        (add-watch routes :bidi/router
                   (fn [_ _ _ new-state]
                     (reset! routes-atom (routes->bidi-route new-state))
                     (let [token (.getCurrentLocation history)
                           token (if-not (s/blank? token)
                                   token
                                   "/")]
                       (.replace history token))))

        (fn []
          (unlisten)
          (remove-watch routes :bidi/router))))
    ))



(defn path-for
  ([route-id]
   (path-for route-id nil))
  ([route-id route-params]
   (let [routes @routes-atom]
     (b/unmatch-pair routes {:handler route-id :params route-params}))))