(ns scrum.devtools.styles)

(defn container [position]
  (let [pos
        (case position
          :left {:top 0 :left 0}
          :right {:top 0 :right 0}
          {:top 0 :right 0})]
    (merge
      pos
      {:position "fixed"
       :background "#fff"
       :boxShadow "0 -2px 16px rgba(0, 0, 0, 0.35)"
       :width 480
       :height "100vh"
       :padding 8
       :boxSizing "border-box"
       :zIndex 9999})))

(defn menu-container []
  {:display "flex"
   :flexDirection "column"
   :justifyContent "center"
   :height "100%"})

(defn menu-item []
  {:margin "8px 0"
   :display "flex"
   :justifyContent "center"})

(defn button []
  {:padding "8px 16px"
   :border "none"
   :borderRadius 2
   :fontSize "14px"
   :background "#c3c3c3"
   :color "#242424"})

(defn header []
  {:display "flex"})

(defn header-title []
  {:fontSize "20px"
   :alignSelf "center"
   :flex 1
   :textAlign "center"})

(defn screen-container []
  {:overflow "scroll"
   :height "calc(100vh - 49px)"
   :fontSize "12px"
   :fontFamily "monospace"})

(defn keyword-literal []
  {:color "#e45649"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn number-literal []
  {:color "#986801"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn string-literal []
  {:color "#50a14f"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn boolean-literal []
  {:color "#242424"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn nil-literal []
  {:color "#a626a4"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn syntax-literal []
  {:color "#242424"
   :display "inline-block"
   :whiteSpace "nowrap"})

(defn map-literal []
  {})

(defn map-entry-literal []
  {:marginBottom 2})

(defn vector-literal []
  {:display "inline-block"})

(defn list-literal []
  {:display "inline-block"})

(defn history-item [active?]
  {:boxSizing "border-box"
   :border (if active? "1px solid #242424" "none")
   :padding 8
   :margin "8px 0"
   :background "#eee"
   :borderRadius 2
   :display "flex"
   :flexDirection "column"})
