(ns rksm.cloxp-projects.tasks
  (:require [clojure.java.shell :as shell]
            [leiningen.core.main :as lmain]
            [leiningen.core.project :as lproj]
            [clojure.java.io :as io]))

(defn git-status
  [{:keys [dir] :as project}]
  (shell/with-sh-dir dir
    (shell/sh "git" "status")))

(defmacro lein
  [{:keys [dir] :as project} task & args]
  `(binding [leiningen.core.main/*exit-process?* false
             leiningen.core.main/*debug* true
             leiningen.core.main/*info* true]
     (let [conf# (lproj/read (str (io/file ~dir "project.clj")))]
       (lmain/apply-task ~task conf# [~@args]))))