/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.remoting.cli.examples;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.clientapi.RemoteClient;

public class ResourceConfiguration {
    private final RemoteClient client;

    public ResourceConfiguration(RemoteClient client) {
        this.client = client;
    }

    public void printConfigurationDefinition(Resource resource) {
        int resourceTypeId = resource.getResourceType().getId();
        ConfigurationDefinition configDef = this.client.getConfigurationManager().getResourceConfigurationDefinitionForResourceType(this.client.getSubject(), resourceTypeId);
        for (PropertyDefinition def : configDef.getPropertyDefinitions().values()) {
            this.printPropertyDefinition(def, "");
        }
    }

    public void printConfiguration(Resource resource) {
        Configuration config = this.client.getConfigurationManager().getResourceConfiguration(this.client.getSubject(), resource.getId());
        for (Property property : config.getAllProperties().values()) {
            this.printProperty(property, "");
        }
    }

    public ResourceConfigurationUpdate updateResourceConfiguration(Resource resource, String key, Object value) {
        Configuration config = this.client.getConfigurationManager().getResourceConfiguration(this.client.getSubject(), resource.getId());
        PropertySimple property = config.getSimple(key);
        if (property == null) {
            throw new RuntimeException("Property [" + key + "] not found in configuration");
        }
        property.setValue(value);
        config.put((Property)property);
        ResourceConfigurationUpdate update = this.client.getConfigurationManager().updateResourceConfiguration(this.client.getSubject(), resource.getId(), config);
        if (update == null) {
            return null;
        }
        update = this.waitForUpdateFinishes(resource.getId(), update);
        return update;
    }

    private ResourceConfigurationUpdate waitForUpdateFinishes(int resourceId, ResourceConfigurationUpdate update) {
        while (update.getStatus().equals((Object)ConfigurationUpdateStatus.INPROGRESS)) {
            try {
                Thread.currentThread().join(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            update = this.client.getConfigurationManager().getLatestResourceConfigurationUpdate(this.client.getSubject(), resourceId);
        }
        return update;
    }

    private void printProperty(Property property, String indent) {
        if (PropertyMap.class.equals(property.getClass())) {
            PropertyMap map = (PropertyMap)property;
            System.out.println("{\n");
            for (Property prop : map.getMap().values()) {
                this.printProperty(prop, indent + "  ");
            }
            System.out.println("}\n");
        } else {
            System.out.println(indent + property.toString());
        }
    }

    private void printPropertyDefinition(PropertyDefinition definition, String indent) {
        if (PropertyDefinitionMap.class.equals(definition.getClass())) {
            PropertyDefinitionMap def = (PropertyDefinitionMap)definition;
            System.out.println("{\n");
            for (PropertyDefinition propDef : def.getMap().values()) {
                this.printPropertyDefinition(propDef, indent + "  ");
            }
            System.out.println("}\n");
        } else {
            System.out.println(indent + definition.toString());
        }
    }
}

