/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.remoting.cli.examples;

import java.io.File;
import java.io.FileInputStream;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.clientapi.RemoteClient;

public class DeployBundle {
    private final RemoteClient client;

    public DeployBundle(RemoteClient client) {
        this.client = client;
    }

    public BundleDeployment deployBundle(File input, ResourceGroup group, Configuration config, String name, String baseDirName, String deployDir) throws Exception {
        BundleVersion version = this.createBundleVersion(input);
        BundleDestination destination = this.client.getBundleManager().createBundleDestination(this.client.getSubject(), version.getBundle().getId(), name, "", baseDirName, deployDir, Integer.valueOf(group.getId()));
        BundleDeployment deployment = this.client.getBundleManager().createBundleDeployment(this.client.getSubject(), version.getId(), destination.getId(), "", config);
        deployment = this.client.getBundleManager().scheduleBundleDeployment(this.client.getSubject(), deployment.getId(), false);
        return this.waitForBundleDeploymentFinishes(deployment);
    }

    private BundleVersion createBundleVersion(File input) throws Exception {
        FileInputStream is = new FileInputStream(input);
        int length = (int)input.length();
        byte[] array = new byte[length];
        int numRead = 0;
        for (int offset = 0; numRead >= 0 && offset < array.length; offset += numRead) {
            numRead = is.read(array, offset, array.length - offset);
        }
        is.close();
        return this.client.getBundleManager().createBundleVersionViaByteArray(this.client.getSubject(), array);
    }

    private BundleDeployment waitForBundleDeploymentFinishes(BundleDeployment deployment) {
        while (deployment.getStatus().equals((Object)BundleDeploymentStatus.IN_PROGRESS) || deployment.getStatus().equals((Object)BundleDeploymentStatus.PENDING)) {
            try {
                Thread.currentThread().join(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            BundleDeploymentCriteria criteria = new BundleDeploymentCriteria();
            criteria.addFilterBundleId(Integer.valueOf(deployment.getId()));
            deployment = (BundleDeployment)this.client.getBundleManager().findBundleDeploymentsByCriteria(this.client.getSubject(), criteria).get(0);
        }
        return deployment;
    }
}

