/*
 * Decompiled with CFR 0.152.
 */
package org.replikativ.scriptum;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public class BranchedDirectory
extends Directory {
    private final Directory baseDir;
    private final Directory overlayDir;
    private final String branchName;
    private final Set<String> overlayFiles = ConcurrentHashMap.newKeySet();
    private final Set<String> deletedBaseFiles = ConcurrentHashMap.newKeySet();
    private final AtomicLong tempFileCounter = new AtomicLong(0L);
    private volatile boolean closed = false;

    public BranchedDirectory(Directory directory, Directory directory2, String string) {
        this.baseDir = directory;
        this.overlayDir = directory2;
        this.branchName = string;
        try {
            String[] stringArray;
            for (String string2 : stringArray = directory2.listAll()) {
                this.overlayFiles.add(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Directory getBaseDir() {
        return this.baseDir;
    }

    public Directory getOverlayDir() {
        return this.overlayDir;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public Set<String> getOverlayFileNames() {
        return Collections.unmodifiableSet(this.overlayFiles);
    }

    public Set<String> getDeletedBaseFileNames() {
        return Collections.unmodifiableSet(this.deletedBaseFiles);
    }

    public String[] listAll() throws IOException {
        this.ensureOpen();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.baseDir.listAll()) {
            if (this.deletedBaseFiles.contains(string) || string.startsWith("segments_")) continue;
            treeSet.add(string);
        }
        treeSet.addAll(this.overlayFiles);
        return treeSet.toArray(new String[0]);
    }

    public void deleteFile(String string) throws IOException {
        this.ensureOpen();
        if (this.overlayFiles.contains(string)) {
            this.overlayDir.deleteFile(string);
            this.overlayFiles.remove(string);
        } else {
            boolean bl = false;
            try {
                this.baseDir.fileLength(string);
                bl = true;
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                // empty catch block
            }
            if (!bl) {
                throw new NoSuchFileException(string);
            }
            this.deletedBaseFiles.add(string);
        }
    }

    public long fileLength(String string) throws IOException {
        this.ensureOpen();
        if (this.overlayFiles.contains(string)) {
            return this.overlayDir.fileLength(string);
        }
        if (this.deletedBaseFiles.contains(string)) {
            throw new NoSuchFileException(string);
        }
        return this.baseDir.fileLength(string);
    }

    public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        this.ensureOpen();
        IndexOutput indexOutput = this.overlayDir.createOutput(string, iOContext);
        this.overlayFiles.add(string);
        return indexOutput;
    }

    public IndexOutput createTempOutput(String string, String string2, IOContext iOContext) throws IOException {
        this.ensureOpen();
        IndexOutput indexOutput = this.overlayDir.createTempOutput(string, string2, iOContext);
        this.overlayFiles.add(indexOutput.getName());
        return indexOutput;
    }

    public void sync(Collection<String> collection) throws IOException {
        this.ensureOpen();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : collection) {
            if (!this.overlayFiles.contains(string)) continue;
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            this.overlayDir.sync(hashSet);
        }
    }

    public void syncMetaData() throws IOException {
        this.ensureOpen();
        this.overlayDir.syncMetaData();
    }

    public void rename(String string, String string2) throws IOException {
        this.ensureOpen();
        if (this.overlayFiles.contains(string)) {
            this.overlayDir.rename(string, string2);
            this.overlayFiles.remove(string);
            this.overlayFiles.add(string2);
        } else {
            try (IndexInput indexInput = this.baseDir.openInput(string, IOContext.READONCE);
                 IndexOutput indexOutput = this.overlayDir.createOutput(string2, IOContext.DEFAULT);){
                indexOutput.copyBytes((DataInput)indexInput, indexInput.length());
            }
            this.overlayFiles.add(string2);
            this.deletedBaseFiles.add(string);
        }
    }

    public IndexInput openInput(String string, IOContext iOContext) throws IOException {
        this.ensureOpen();
        if (this.overlayFiles.contains(string)) {
            return this.overlayDir.openInput(string, iOContext);
        }
        if (this.deletedBaseFiles.contains(string)) {
            throw new NoSuchFileException(string);
        }
        return this.baseDir.openInput(string, iOContext);
    }

    public Lock obtainLock(String string) throws IOException {
        this.ensureOpen();
        return this.overlayDir.obtainLock(this.branchName + "_" + string);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.overlayDir.close();
            }
            finally {
                this.baseDir.close();
            }
        }
    }

    public Set<String> getPendingDeletions() throws IOException {
        this.ensureOpen();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.overlayDir.getPendingDeletions());
        return hashSet;
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("BranchedDirectory[" + this.branchName + "] is closed");
        }
    }

    public String toString() {
        return "BranchedDirectory(" + this.branchName + ", base=" + String.valueOf(this.baseDir) + ", overlay=" + String.valueOf(this.overlayDir) + ")";
    }
}

