/*
 * Decompiled with CFR 0.152.
 */
package org.replikativ.scriptum;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.replikativ.scriptum.BranchAwareMergePolicy;
import org.replikativ.scriptum.BranchDeletionPolicy;
import org.replikativ.scriptum.BranchedDirectory;

public class BranchIndexWriter
implements Closeable {
    private static final String COMMIT_TIMESTAMP_KEY = "scriptum.timestamp";
    private static final String COMMIT_MESSAGE_KEY = "scriptum.message";
    private static final String COMMIT_BRANCH_KEY = "scriptum.branch";
    private static final String COMMIT_UUID_KEY = "scriptum.uuid";
    private static final String COMMIT_PARENT_IDS_KEY = "scriptum.parent-ids";
    private final IndexWriter writer;
    private final Directory directory;
    private final BranchDeletionPolicy deletionPolicy;
    private final BranchAwareMergePolicy mergePolicy;
    private final String branchName;
    private final Path basePath;
    private final Analyzer analyzer;
    private final boolean isMainBranch;
    private volatile String pendingCommitMessage;
    private volatile String lastCommitId;
    private volatile String pendingExtraParentIds;

    private BranchIndexWriter(IndexWriter indexWriter, Directory directory, BranchDeletionPolicy branchDeletionPolicy, BranchAwareMergePolicy branchAwareMergePolicy, String string, Path path, Analyzer analyzer, boolean bl) {
        this.writer = indexWriter;
        this.directory = directory;
        this.deletionPolicy = branchDeletionPolicy;
        this.mergePolicy = branchAwareMergePolicy;
        this.branchName = string;
        this.basePath = path;
        this.analyzer = analyzer;
        this.isMainBranch = bl;
    }

    private void initLastCommitId() {
        IndexCommit indexCommit = this.deletionPolicy.getLastCommit();
        if (indexCommit != null) {
            try {
                Map map = indexCommit.getUserData();
                this.lastCommitId = (String)map.get(COMMIT_UUID_KEY);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static BranchIndexWriter create(Path path, String string) throws IOException {
        return BranchIndexWriter.create(path, string, (Analyzer)new StandardAnalyzer());
    }

    public static BranchIndexWriter create(Path path, String string, Analyzer analyzer) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        FSDirectory fSDirectory = MMapDirectory.open((Path)path);
        BranchDeletionPolicy branchDeletionPolicy = new BranchDeletionPolicy();
        BranchAwareMergePolicy branchAwareMergePolicy = new BranchAwareMergePolicy((MergePolicy)new TieredMergePolicy());
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(analyzer);
        indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)branchDeletionPolicy);
        indexWriterConfig.setMergePolicy((MergePolicy)branchAwareMergePolicy);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        IndexWriter indexWriter = new IndexWriter((Directory)fSDirectory, indexWriterConfig);
        BranchIndexWriter branchIndexWriter = new BranchIndexWriter(indexWriter, (Directory)fSDirectory, branchDeletionPolicy, branchAwareMergePolicy, string, path, analyzer, true);
        branchIndexWriter.initLastCommitId();
        branchIndexWriter.discoverAndProtectBranches();
        return branchIndexWriter;
    }

    public static BranchIndexWriter open(Path path, String string, Analyzer analyzer) throws IOException {
        SegmentCommitInfo segmentCommitInfo2;
        Path path2 = path.resolve("branches").resolve(string);
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new IOException("Branch directory not found: " + String.valueOf(path2));
        }
        FSDirectory fSDirectory = MMapDirectory.open((Path)path);
        FSDirectory fSDirectory2 = MMapDirectory.open((Path)path2);
        BranchedDirectory branchedDirectory = new BranchedDirectory((Directory)fSDirectory, (Directory)fSDirectory2, string);
        BranchDeletionPolicy branchDeletionPolicy = new BranchDeletionPolicy();
        BranchAwareMergePolicy branchAwareMergePolicy = new BranchAwareMergePolicy((MergePolicy)new TieredMergePolicy());
        SegmentInfos segmentInfos = SegmentInfos.readLatestCommit((Directory)branchedDirectory);
        HashSet<String> hashSet = new HashSet<String>();
        for (SegmentCommitInfo segmentCommitInfo2 : segmentInfos) {
            try {
                fSDirectory.fileLength(segmentCommitInfo2.info.name + ".cfs");
                hashSet.add(segmentCommitInfo2.info.name);
            }
            catch (IOException iOException) {
                try {
                    fSDirectory.fileLength(segmentCommitInfo2.info.name + ".si");
                    hashSet.add(segmentCommitInfo2.info.name);
                }
                catch (IOException iOException2) {}
            }
        }
        branchAwareMergePolicy.setSharedSegmentNames(hashSet);
        Iterator iterator = new IndexWriterConfig(analyzer);
        iterator.setIndexDeletionPolicy(branchDeletionPolicy);
        iterator.setMergePolicy((MergePolicy)branchAwareMergePolicy);
        iterator.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        segmentCommitInfo2 = new IndexWriter((Directory)branchedDirectory, (IndexWriterConfig)iterator);
        BranchIndexWriter branchIndexWriter = new BranchIndexWriter((IndexWriter)segmentCommitInfo2, branchedDirectory, branchDeletionPolicy, branchAwareMergePolicy, string, path, analyzer, false);
        branchIndexWriter.initLastCommitId();
        return branchIndexWriter;
    }

    public static BranchIndexWriter open(Path path, String string) throws IOException {
        return BranchIndexWriter.open(path, string, (Analyzer)new StandardAnalyzer());
    }

    private void discoverAndProtectBranches() throws IOException {
        Path path = this.basePath.resolve("branches");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                try {
                    String string = path2.getFileName().toString();
                    FSDirectory fSDirectory = MMapDirectory.open((Path)this.basePath);
                    try {
                        FSDirectory fSDirectory2 = MMapDirectory.open((Path)path2);
                        try (BranchedDirectory branchedDirectory = new BranchedDirectory((Directory)fSDirectory, (Directory)fSDirectory2, string);){
                            SegmentInfos segmentInfos = SegmentInfos.readLatestCommit((Directory)branchedDirectory);
                            for (SegmentCommitInfo segmentCommitInfo : segmentInfos) {
                                hashSet.add(segmentCommitInfo.info.name);
                            }
                        }
                        finally {
                            if (fSDirectory2 == null) continue;
                            fSDirectory2.close();
                        }
                    }
                    finally {
                        if (fSDirectory == null) continue;
                        fSDirectory.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (!hashSet.isEmpty()) {
            this.mergePolicy.setSharedSegmentNames(hashSet);
        }
    }

    public static Set<String> discoverBranches(Path path) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        Path path2 = path.resolve("branches");
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            return hashSet;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
            for (Path path3 : directoryStream) {
                if (!Files.isDirectory(path3, new LinkOption[0])) continue;
                hashSet.add(path3.getFileName().toString());
            }
        }
        return hashSet;
    }

    public synchronized BranchIndexWriter fork(String string) throws IOException {
        Object object2;
        this.writer.flush();
        String string2 = this.setCommitData("Fork point for " + string);
        this.writer.commit();
        this.lastCommitId = string2;
        SegmentInfos segmentInfos = SegmentInfos.readLatestCommit((Directory)this.directory);
        Path path = this.basePath.resolve("branches").resolve(string);
        Files.createDirectories(path, new FileAttribute[0]);
        FSDirectory fSDirectory = MMapDirectory.open((Path)this.basePath);
        FSDirectory fSDirectory2 = MMapDirectory.open((Path)path);
        BranchedDirectory branchedDirectory = new BranchedDirectory((Directory)fSDirectory, (Directory)fSDirectory2, string);
        SegmentInfos segmentInfos2 = segmentInfos.clone();
        segmentInfos2.counter = segmentInfos.counter + 10000L;
        segmentInfos2.commit((Directory)branchedDirectory);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : segmentInfos) {
            hashSet.add(((SegmentCommitInfo)object2).info.name);
        }
        this.mergePolicy.setSharedSegmentNames(hashSet);
        Object object3 = new BranchDeletionPolicy();
        object2 = new BranchAwareMergePolicy((MergePolicy)new TieredMergePolicy());
        ((BranchAwareMergePolicy)((Object)object2)).setSharedSegmentNames(hashSet);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)object3);
        indexWriterConfig.setMergePolicy((MergePolicy)object2);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        IndexWriter indexWriter = new IndexWriter((Directory)branchedDirectory, indexWriterConfig);
        BranchIndexWriter branchIndexWriter = new BranchIndexWriter(indexWriter, branchedDirectory, (BranchDeletionPolicy)((Object)object3), (BranchAwareMergePolicy)((Object)object2), string, this.basePath, this.analyzer, false);
        branchIndexWriter.lastCommitId = this.lastCommitId;
        return branchIndexWriter;
    }

    public long addDocument(Iterable<? extends IndexableField> iterable) throws IOException {
        return this.writer.addDocument(iterable);
    }

    public long deleteDocuments(Term ... termArray) throws IOException {
        return this.writer.deleteDocuments(termArray);
    }

    public long deleteDocuments(Query ... queryArray) throws IOException {
        return this.writer.deleteDocuments(queryArray);
    }

    public long updateDocument(Term term, Iterable<? extends IndexableField> iterable) throws IOException {
        return this.writer.updateDocument(term, iterable);
    }

    public void setCommitMessage(String string) {
        this.pendingCommitMessage = string;
    }

    private String setCommitData(String string) {
        String string2 = UUID.randomUUID().toString();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(COMMIT_UUID_KEY, string2);
        linkedHashMap.put(COMMIT_TIMESTAMP_KEY, Instant.now().toString());
        linkedHashMap.put(COMMIT_BRANCH_KEY, this.branchName);
        if (string != null && !string.isEmpty()) {
            linkedHashMap.put(COMMIT_MESSAGE_KEY, string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lastCommitId != null) {
            stringBuilder.append(this.lastCommitId);
        }
        if (this.pendingExtraParentIds != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.pendingExtraParentIds);
            this.pendingExtraParentIds = null;
        }
        if (stringBuilder.length() > 0) {
            linkedHashMap.put(COMMIT_PARENT_IDS_KEY, stringBuilder.toString());
        }
        this.writer.setLiveCommitData(linkedHashMap.entrySet());
        return string2;
    }

    public long commit() throws IOException {
        String string = this.setCommitData(this.pendingCommitMessage);
        this.pendingCommitMessage = null;
        long l = this.writer.commit();
        this.lastCommitId = string;
        return l;
    }

    public long commit(String string) throws IOException {
        String string2 = this.setCommitData(string);
        this.pendingCommitMessage = null;
        long l = this.writer.commit();
        this.lastCommitId = string2;
        return l;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void forceMerge(int n) throws IOException {
        this.writer.forceMerge(n);
    }

    public DirectoryReader openReader() throws IOException {
        return DirectoryReader.open((IndexWriter)this.writer);
    }

    public DirectoryReader openCommittedReader() throws IOException {
        return DirectoryReader.open((Directory)this.directory);
    }

    public DirectoryReader openReaderAt(long l) throws IOException {
        for (IndexCommit indexCommit : this.deletionPolicy.getAllCommits()) {
            if (indexCommit.getGeneration() != l) continue;
            return DirectoryReader.open((IndexCommit)indexCommit);
        }
        throw new IOException("Commit generation " + l + " not found (may have been garbage collected)");
    }

    public boolean isCommitAvailable(long l) {
        for (IndexCommit indexCommit : this.deletionPolicy.getAllCommits()) {
            if (indexCommit.getGeneration() != l) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> listSnapshots() throws IOException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (IndexCommit indexCommit : this.deletionPolicy.getAllCommits()) {
            LinkedHashMap<String, Number> linkedHashMap = new LinkedHashMap<String, Number>();
            linkedHashMap.put("generation", indexCommit.getGeneration());
            linkedHashMap.put("segmentCount", indexCommit.getSegmentCount());
            Map map = indexCommit.getUserData();
            if (map.containsKey(COMMIT_UUID_KEY)) {
                linkedHashMap.put("snapshotId", (Number)map.get(COMMIT_UUID_KEY));
            }
            if (map.containsKey(COMMIT_TIMESTAMP_KEY)) {
                linkedHashMap.put("timestamp", (Number)map.get(COMMIT_TIMESTAMP_KEY));
            }
            if (map.containsKey(COMMIT_MESSAGE_KEY)) {
                linkedHashMap.put("message", (Number)map.get(COMMIT_MESSAGE_KEY));
            }
            if (map.containsKey(COMMIT_BRANCH_KEY)) {
                linkedHashMap.put("branch", (Number)map.get(COMMIT_BRANCH_KEY));
            }
            if (map.containsKey(COMMIT_PARENT_IDS_KEY)) {
                linkedHashMap.put("parentIds", (Number)map.get(COMMIT_PARENT_IDS_KEY));
            }
            arrayList.add(linkedHashMap);
        }
        return arrayList;
    }

    public int gc(Instant instant) throws IOException {
        if (!this.isMainBranch) {
            throw new IOException("gc() can only be called on the main branch writer");
        }
        Set<String> set = this.collectBranchReferencedFiles(instant);
        this.deletionPolicy.setGcCutoff(instant, set);
        String string = this.setCommitData("GC pass");
        this.writer.commit();
        this.lastCommitId = string;
        return this.deletionPolicy.getLastGcDeleted();
    }

    private Set<String> collectBranchReferencedFiles(Instant instant) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        Path path = this.basePath.resolve("branches");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return hashSet;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                try {
                    String string = path2.getFileName().toString();
                    FSDirectory fSDirectory = MMapDirectory.open((Path)this.basePath);
                    try {
                        FSDirectory fSDirectory2 = MMapDirectory.open((Path)path2);
                        try (BranchedDirectory branchedDirectory = new BranchedDirectory((Directory)fSDirectory, (Directory)fSDirectory2, string);){
                            String[] stringArray;
                            for (String string2 : stringArray = fSDirectory2.listAll()) {
                                if (!string2.startsWith("segments_")) continue;
                                try {
                                    SegmentInfos segmentInfos = SegmentInfos.readCommit((Directory)branchedDirectory, (String)string2);
                                    boolean bl = true;
                                    String string3 = (String)segmentInfos.getUserData().get(COMMIT_TIMESTAMP_KEY);
                                    if (string3 != null) {
                                        try {
                                            Instant instant2 = Instant.parse(string3);
                                            bl = !instant2.isBefore(instant);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (!bl) continue;
                                    for (SegmentCommitInfo segmentCommitInfo : segmentInfos) {
                                        hashSet.addAll(segmentCommitInfo.files());
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        finally {
                            if (fSDirectory2 == null) continue;
                            fSDirectory2.close();
                        }
                    }
                    finally {
                        if (fSDirectory == null) continue;
                        fSDirectory.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return hashSet;
    }

    public void mergeFrom(BranchIndexWriter branchIndexWriter) throws IOException {
        branchIndexWriter.commit("Pre-merge snapshot");
        this.commit("Pre-merge snapshot");
        try (DirectoryReader directoryReader = DirectoryReader.open((Directory)branchIndexWriter.directory);){
            ArrayList<CodecReader> arrayList = new ArrayList<CodecReader>();
            for (LeafReaderContext leafReaderContext : directoryReader.leaves()) {
                arrayList.add((CodecReader)leafReaderContext.reader());
            }
            this.writer.addIndexes(arrayList.toArray(new CodecReader[0]));
        }
        this.pendingExtraParentIds = branchIndexWriter.lastCommitId;
        this.commit("Merged from " + branchIndexWriter.branchName);
    }

    public String getLastCommitId() {
        return this.lastCommitId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public IndexWriter getIndexWriter() {
        return this.writer;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public int maxDoc() {
        return this.writer.getDocStats().maxDoc;
    }

    public int numDocs() {
        return this.writer.getDocStats().numDocs;
    }

    public boolean isOpen() {
        return this.writer.isOpen();
    }

    public boolean isMainBranch() {
        return this.isMainBranch;
    }

    public BranchDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.directory.close();
    }

    public String toString() {
        return "BranchIndexWriter(" + this.branchName + ", docs=" + this.numDocs() + ", base=" + String.valueOf(this.basePath) + ")";
    }
}

