/*
 * Decompiled with CFR 0.152.
 */
package org.replikativ.scriptum;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class BranchAwareMergePolicy
extends FilterMergePolicy {
    private volatile Set<String> sharedSegmentNames = Collections.emptySet();

    public BranchAwareMergePolicy(MergePolicy mergePolicy) {
        super(mergePolicy);
    }

    public void setSharedSegmentNames(Set<String> set) {
        this.sharedSegmentNames = Collections.unmodifiableSet(new HashSet<String>(set));
    }

    public synchronized void addSharedSegment(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.sharedSegmentNames);
        hashSet.add(string);
        this.sharedSegmentNames = Collections.unmodifiableSet(hashSet);
    }

    public synchronized void removeSharedSegment(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.sharedSegmentNames);
        hashSet.remove(string);
        this.sharedSegmentNames = Collections.unmodifiableSet(hashSet);
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = super.findMerges(mergeTrigger, segmentInfos, mergeContext);
        return this.filterMerges(mergeSpecification);
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int n, Map<SegmentCommitInfo, Boolean> map, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = super.findForcedMerges(segmentInfos, n, map, mergeContext);
        return this.filterMerges(mergeSpecification);
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = super.findForcedDeletesMerges(segmentInfos, mergeContext);
        return this.filterMerges(mergeSpecification);
    }

    public MergePolicy.MergeSpecification findFullFlushMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = super.findFullFlushMerges(mergeTrigger, segmentInfos, mergeContext);
        return this.filterMerges(mergeSpecification);
    }

    private MergePolicy.MergeSpecification filterMerges(MergePolicy.MergeSpecification mergeSpecification) {
        Set<String> set = this.sharedSegmentNames;
        if (mergeSpecification == null || set.isEmpty()) {
            return mergeSpecification;
        }
        MergePolicy.MergeSpecification mergeSpecification2 = new MergePolicy.MergeSpecification();
        for (MergePolicy.OneMerge oneMerge : mergeSpecification.merges) {
            boolean bl = false;
            for (SegmentCommitInfo segmentCommitInfo : oneMerge.segments) {
                if (set.contains(segmentCommitInfo.info.name)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            mergeSpecification2.add(oneMerge);
        }
        return mergeSpecification2.merges.isEmpty() ? null : mergeSpecification2;
    }

    public String toString() {
        return "BranchAwareMergePolicy(" + String.valueOf(this.in) + ", sharedSegments=" + this.sharedSegmentNames.size() + ")";
    }
}

