/*
 * Decompiled with CFR 0.152.
 */
package org.replikativ.scriptum;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;

public class BranchDeletionPolicy
extends IndexDeletionPolicy {
    private static final String TIMESTAMP_KEY = "scriptum.timestamp";
    private volatile List<IndexCommit> commitSnapshot = Collections.emptyList();
    private volatile Instant gcCutoff;
    private volatile Set<String> gcProtectedFiles;
    private volatile int lastGcDeleted;

    public void onInit(List<? extends IndexCommit> list) throws IOException {
        this.commitSnapshot = Collections.unmodifiableList(new ArrayList<IndexCommit>(list));
    }

    public void onCommit(List<? extends IndexCommit> list) throws IOException {
        Instant instant = this.gcCutoff;
        Set<String> set = this.gcProtectedFiles;
        if (instant != null && set != null) {
            this.lastGcDeleted = 0;
            ArrayList<IndexCommit> arrayList = new ArrayList<IndexCommit>();
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                IndexCommit indexCommit = list.get(i);
                boolean bl2 = bl = i == list.size() - 1;
                if (!bl && this.isBeforeCutoff(indexCommit, instant) && !this.hasProtectedFiles(indexCommit, set)) {
                    indexCommit.delete();
                    ++this.lastGcDeleted;
                    continue;
                }
                arrayList.add(indexCommit);
            }
            this.commitSnapshot = Collections.unmodifiableList(arrayList);
            this.gcCutoff = null;
            this.gcProtectedFiles = null;
        } else {
            this.commitSnapshot = Collections.unmodifiableList(new ArrayList<IndexCommit>(list));
        }
    }

    public void setGcCutoff(Instant instant, Set<String> set) {
        this.gcProtectedFiles = Collections.unmodifiableSet(new HashSet<String>(set));
        this.gcCutoff = instant;
    }

    public int getLastGcDeleted() {
        return this.lastGcDeleted;
    }

    private boolean isBeforeCutoff(IndexCommit indexCommit, Instant instant) throws IOException {
        Map map = indexCommit.getUserData();
        String string = (String)map.get(TIMESTAMP_KEY);
        if (string == null) {
            return false;
        }
        try {
            Instant instant2 = Instant.parse(string);
            return instant2.isBefore(instant);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasProtectedFiles(IndexCommit indexCommit, Set<String> set) throws IOException {
        for (String string : indexCommit.getFileNames()) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    public List<IndexCommit> getAllCommits() {
        return this.commitSnapshot;
    }

    public IndexCommit getLastCommit() {
        List<IndexCommit> list = this.commitSnapshot;
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public int getCommitCount() {
        return this.commitSnapshot.size();
    }
}

