(ns hooks.proximum.codegen
  "clj-kondo hooks for proximum.codegen.clojure macros.

   These hooks teach clj-kondo about the emit-api and def-api-fn macros
   that generate the public API from proximum.specification.
   
   This file is AUTO-GENERATED by scripts/generate-clj-kondo-types.clj
   Do not edit directly - regenerate from specification."
  (:require [clj-kondo.hooks-api :as api]))

;; List of all API operations from proximum.specification
;; Generated at: Thu Jan 15 12:06:55 PST 2026
(def api-operations
  '[abort-online-compaction! ancestor? ancestors branch! branches capacity close! commit-graph commit-info common-ancestor compact compaction-progress count-vectors create-index crypto-hash? delete delete-branch! finish-online-compaction! flush! fork gc! get-branch get-commit-hash get-commit-id get-metadata get-vector hash-index-commit history index-config index-metrics index-type insert insert-batch load load-commit lookup-internal-id make-id-filter needs-compaction? parents recommended-ef-construction recommended-ef-search remaining-capacity reset! restore-index search search-filtered search-with-metadata start-online-compaction sync! verify-from-cold with-metadata])

(defn def-api-fn
  "Hook for def-api-fn macro.

   Transforms (def-api-fn :insert) into (def insert nil)
   so clj-kondo understands the generated function definition."
  [{:keys [node]}]
  (let [children (:children node)
        [_def-api-fn-sym op-key] children]
    (when-not op-key
      (throw (ex-info "def-api-fn requires an operation key" {})))

    ;; Extract the operation name from the keyword
    (let [op-name (-> op-key
                      api/sexpr
                      name
                      symbol
                      api/token-node)]
      ;; Transform to: (def op-name nil)
      ;; Using nil as placeholder since clj-kondo only cares about the var existence
      {:node (api/list-node
              [(api/token-node 'def)
               op-name
               (api/token-node 'nil)])})))

(defn emit-api
  "Hook for emit-api macro.

   Transforms (emit-api proximum.specification/api-specification)
   into a series of (def function-name nil) forms
   so clj-kondo understands all generated API functions.
   
   Type information is handled separately in config.edn's :type-mismatch linter."
  [{:keys [node]}]
  (let [;; Create a (do (def fn1 nil) (def fn2 nil) ...) form
        ;; Using nil as placeholder since clj-kondo only cares about the var existence
        def-forms (map (fn [op-name]
                        (api/list-node
                         [(api/token-node 'def)
                          (api/token-node op-name)
                          (api/token-node 'nil)]))
                      api-operations)]
    ;; Wrap all defs in a do block
    {:node (api/list-node
            (cons (api/token-node 'do) def-forms))}))
