/*
 * Decompiled with CFR 0.152.
 */
package org.replikativ.proximum.langchain4j;

import clojure.lang.Keyword;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.filter.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.replikativ.proximum.DistanceMetric;
import org.replikativ.proximum.ProximumVectorStore;
import org.replikativ.proximum.SearchResult;

public class ProximumEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private ProximumVectorStore store;
    private final int dimensions;

    private ProximumEmbeddingStore(ProximumVectorStore proximumVectorStore, int n) {
        this.store = Objects.requireNonNull(proximumVectorStore, "store");
        if (n <= 0) {
            throw new IllegalArgumentException("dimensions must be set and positive");
        }
        this.dimensions = n;
    }

    private ProximumEmbeddingStore(Builder builder) {
        this.dimensions = builder.dimensions;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("backend", ":file");
        hashMap.put("path", builder.storagePath);
        hashMap.put("id", UUID.randomUUID());
        this.store = ProximumVectorStore.builder().dim(this.dimensions).storeConfig(hashMap).m(builder.m).efConstruction(builder.efConstruction).capacity(builder.capacity).distance(builder.distance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProximumEmbeddingStore connect(String string, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("backend", ":file");
        hashMap.put("path", string);
        hashMap.put("id", UUID.randomUUID());
        ProximumVectorStore proximumVectorStore = ProximumVectorStore.connect(hashMap);
        return new ProximumEmbeddingStore(proximumVectorStore, n);
    }

    public String add(Embedding embedding) {
        return this.add(embedding, null);
    }

    public void add(String string, Embedding embedding) {
        this.addInternal(string, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String string = UUID.randomUUID().toString();
        this.addInternal(string, embedding, textSegment);
        return string;
    }

    public List<String> addAll(List<Embedding> list) {
        return this.addAll(list, null);
    }

    public List<String> addAll(List<Embedding> list, List<TextSegment> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            TextSegment textSegment = list2 != null && i < list2.size() ? list2.get(i) : null;
            String string = this.add(list.get(i), textSegment);
            arrayList.add(string);
        }
        return arrayList;
    }

    public void addAll(List<String> list, List<Embedding> list2, List<TextSegment> list3) {
        for (int i = 0; i < list.size(); ++i) {
            TextSegment textSegment = list3 != null && i < list3.size() ? list3.get(i) : null;
            this.addInternal(list.get(i), list2.get(i), textSegment);
        }
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        Integer n = this.store.lookupId((Object)string);
        if (n != null) {
            this.store = this.store.deleteById((Object)string);
        }
    }

    public void removeAll(Collection<String> collection) {
        for (String string : collection) {
            this.remove(string);
        }
    }

    public void removeAll(Filter filter) {
        throw new UnsupportedOperationException("removeAll(filter) is not supported without scanning the dataset");
    }

    public void removeAll() {
        throw new UnsupportedOperationException("removeAll() is not supported without scanning the dataset");
    }

    public EmbeddingSearchResult<TextSegment> search(EmbeddingSearchRequest embeddingSearchRequest) {
        float[] fArray = embeddingSearchRequest.queryEmbedding().vector();
        int n = embeddingSearchRequest.maxResults();
        Filter filter = embeddingSearchRequest.filter();
        if (filter == null) {
            List list = this.store.search(fArray, n);
            return new EmbeddingSearchResult(this.toMatches(list, n, embeddingSearchRequest.minScore(), null));
        }
        int[] nArray = new int[]{3, 10, 30};
        ArrayList<EmbeddingMatch<TextSegment>> arrayList = new ArrayList<EmbeddingMatch<TextSegment>>(n);
        for (int n2 : nArray) {
            arrayList.clear();
            int n3 = ProximumEmbeddingStore.safeCandidateK(n, n2);
            List list = this.store.search(fArray, n3);
            arrayList.addAll(this.toMatches(list, n, embeddingSearchRequest.minScore(), filter));
            if (arrayList.size() >= n) break;
        }
        return new EmbeddingSearchResult(arrayList);
    }

    private static int safeCandidateK(int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        long l = (long)n * (long)n2;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private List<EmbeddingMatch<TextSegment>> toMatches(List<SearchResult> list, int n, double d, Filter filter) {
        ArrayList<EmbeddingMatch<TextSegment>> arrayList = new ArrayList<EmbeddingMatch<TextSegment>>(Math.min(n, list.size()));
        for (SearchResult searchResult : list) {
            double d2;
            if (arrayList.size() >= n) break;
            HashMap<String, Object> hashMap = this.store.getMetadataById(searchResult.getId());
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            if (filter != null && !this.matchesFilter(hashMap, filter) || (d2 = searchResult.getSimilarity()) < d) continue;
            String string = String.valueOf(searchResult.getId());
            TextSegment textSegment = ProximumEmbeddingStore.toTextSegment(hashMap);
            float[] fArray = this.store.getVectorById(searchResult.getId());
            Embedding embedding = fArray != null ? Embedding.from((float[])fArray) : null;
            arrayList.add((EmbeddingMatch<TextSegment>)new EmbeddingMatch(Double.valueOf(d2), string, embedding, (Object)textSegment));
        }
        return arrayList;
    }

    public CompletableFuture<Void> sync() {
        return this.store.sync().thenApply(proximumVectorStore -> {
            this.store = proximumVectorStore;
            return null;
        });
    }

    public CompletableFuture<Void> sync(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(":message", string);
        return this.store.sync(hashMap).thenApply(proximumVectorStore -> {
            this.store = proximumVectorStore;
            return null;
        });
    }

    public ProximumVectorStore getStore() {
        return this.store;
    }

    public long count() {
        return this.store.count();
    }

    public void close() {
        this.store.close();
    }

    private void addInternal(String string2, Embedding embedding, TextSegment textSegment) {
        float[] fArray = embedding.vector();
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("id is required for persistence-backed EmbeddingStore");
        }
        Integer n = this.store.lookupId((Object)string2);
        if (n != null) {
            this.store = this.store.deleteById((Object)string2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (textSegment != null) {
            hashMap.put("_text", textSegment.text());
            if (textSegment.metadata() != null) {
                textSegment.metadata().toMap().forEach((string, object) -> hashMap.put((String)string, (String)object));
            }
        }
        this.store = this.store.addWithId(fArray, (Object)string2, hashMap);
    }

    private static TextSegment toTextSegment(Map<String, Object> map) {
        String string;
        if (map == null) {
            return null;
        }
        String string2 = string = map.get("_text") != null ? String.valueOf(map.get("_text")) : null;
        if (string == null || string.isBlank()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object;
            String string3 = entry.getKey();
            Object object2 = entry.getValue();
            if (string3 == null || object2 == null || "_text".equals(string3) || "external-id".equals(string3) || (object = ProximumEmbeddingStore.normalizeLangChain4jValue(object2)) == null) continue;
            hashMap.put(string3, object);
        }
        return TextSegment.from((String)string, (Metadata)new Metadata(hashMap));
    }

    private boolean matchesFilter(Map<String, Object> map, Filter filter) {
        if (filter == null) {
            return true;
        }
        Map<String, Object> map2 = ProximumEmbeddingStore.normalizeForLangChain4jMetadata(map);
        try {
            return filter.test((Object)Metadata.from(map2));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private static Map<String, Object> normalizeForLangChain4jMetadata(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map == null) {
            return hashMap;
        }
        Map<String, Object> map2 = map;
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (string == null || object == null) continue;
            String string2 = string instanceof Keyword ? ((Keyword)string).getName() : String.valueOf(string);
            Object object2 = ProximumEmbeddingStore.normalizeLangChain4jValue(object);
            if (object2 == null) continue;
            hashMap.put(string2, object2);
        }
        return hashMap;
    }

    private static Object normalizeLangChain4jValue(Object object) {
        if (object instanceof String || object instanceof UUID || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            return object;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl.toString();
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).intValue();
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (Double.isFinite(d)) {
                return d;
            }
            return String.valueOf(object);
        }
        return String.valueOf(object);
    }

    public static class Builder {
        private String storagePath;
        private int dimensions;
        private int m = 16;
        private int efConstruction = 200;
        private int efSearch = 50;
        private int capacity = 10000000;
        private DistanceMetric distance = DistanceMetric.COSINE;

        public Builder storagePath(String string) {
            this.storagePath = string;
            return this;
        }

        public Builder dimensions(int n) {
            this.dimensions = n;
            return this;
        }

        public Builder m(int n) {
            this.m = n;
            return this;
        }

        public Builder efConstruction(int n) {
            this.efConstruction = n;
            return this;
        }

        public Builder efSearch(int n) {
            this.efSearch = n;
            return this;
        }

        public Builder capacity(int n) {
            this.capacity = n;
            return this;
        }

        public Builder distance(DistanceMetric distanceMetric) {
            this.distance = distanceMetric;
            return this;
        }

        public ProximumEmbeddingStore build() {
            if (this.dimensions <= 0) {
                throw new IllegalArgumentException("dimensions must be set and positive");
            }
            return new ProximumEmbeddingStore(this);
        }
    }
}

