/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.IFn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.tonsky.persistent_sorted_set.Branch;
import me.tonsky.persistent_sorted_set.IStorage;
import me.tonsky.persistent_sorted_set.Leaf;
import me.tonsky.persistent_sorted_set.Settings;

public abstract class ANode<Key, Address> {
    public int _len;
    public final Key[] _keys;
    public final Settings _settings;

    public ANode(int n, Key[] KeyArray, Settings settings) {
        assert (KeyArray.length >= n);
        this._len = n;
        this._keys = KeyArray;
        this._settings = settings;
    }

    public int len() {
        return this._len;
    }

    public Key minKey() {
        return this._keys[0];
    }

    public Key maxKey() {
        return this._keys[this._len - 1];
    }

    public List<Key> keys() {
        if (this._keys.length == this._len) {
            return Arrays.asList(this._keys);
        }
        return Arrays.asList(Arrays.copyOfRange(this._keys, 0, this._len));
    }

    public boolean editable() {
        return this._settings.editable();
    }

    public int search(Key Key, Comparator<Key> comparator) {
        return Arrays.binarySearch(this._keys, 0, this._len, Key, comparator);
    }

    public int searchFirst(Key Key, Comparator<Key> comparator) {
        int n = 0;
        int n2 = this._len;
        while (n < n2) {
            int n3 = n2 + n >>> 1;
            int n4 = comparator.compare(this._keys[n3], Key);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return n;
    }

    public int searchLast(Key Key, Comparator<Key> comparator) {
        int n = 0;
        int n2 = this._len;
        while (n < n2) {
            int n3 = n2 + n >>> 1;
            int n4 = comparator.compare(this._keys[n3], Key);
            if (n4 <= 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return n - 1;
    }

    public static <Key, Address> ANode restore(int n, List<Key> list, List<Address> list2, Settings settings) {
        if (n == 0 || list2 == null) {
            return new Leaf(list, settings);
        }
        return new Branch<Key, Address>(n, list, list2, settings);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, null, "");
        return stringBuilder.toString();
    }

    public abstract int count(IStorage var1);

    public abstract int level();

    public abstract boolean contains(IStorage var1, Key var2, Comparator<Key> var3);

    public abstract ANode[] add(IStorage var1, Key var2, Comparator<Key> var3, Settings var4);

    public abstract ANode[] remove(IStorage var1, Key var2, ANode var3, ANode var4, Comparator<Key> var5, Settings var6);

    public abstract ANode[] replace(IStorage var1, Key var2, Key var3, Comparator<Key> var4, Settings var5);

    public abstract String str(IStorage var1, int var2);

    public abstract void walkAddresses(IStorage var1, IFn var2);

    public abstract Address store(IStorage<Key, Address> var1);

    public abstract void toString(StringBuilder var1, Address var2, String var3);

    protected static int newLen(int n, Settings settings) {
        if (settings.editable()) {
            return Math.min(settings.branchingFactor(), n + settings.expandLen());
        }
        return n;
    }

    protected static int safeLen(ANode aNode) {
        return aNode == null ? -1 : aNode._len;
    }
}

