/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.APersistentVector;
import datahike.java.Datahike;
import datahike.java.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatahikeGeneratedTest {
    private Map<String, Object> config;
    private Object conn;
    private Object schema = Clojure.read((String)"[{:db/ident :name\n                 :db/valueType :db.type/string\n                 :db/unique :db.unique/identity\n                 :db/index true\n                 :db/cardinality :db.cardinality/one}\n                {:db/ident :age\n                 :db/valueType :db.type/long\n                 :db/cardinality :db.cardinality/one}]");

    @Before
    public void setUp() {
        UUID uUID = UUID.randomUUID();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("backend", Util.kwd(":memory"));
        hashMap.put("id", uUID);
        this.config = new HashMap<String, Object>();
        this.config.put("store", hashMap);
        this.config.put("initial-tx", this.schema);
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        Datahike.transact(this.conn, (List)Util.vec(Util.map(Util.kwd(":db/id"), 1, Util.kwd(":name"), "Alice", Util.kwd(":age"), 25L), Util.map(Util.kwd(":db/id"), 2, Util.kwd(":name"), "Bob", Util.kwd(":age"), 30L), Util.map(Util.kwd(":db/id"), 3, Util.kwd(":name"), "Charlie", Util.kwd(":age"), 35L)));
    }

    @After
    public void tearDown() {
        if (this.conn != null) {
            Datahike.release(this.conn);
        }
        Datahike.deleteDatabase(this.config);
    }

    @Test
    public void testDb() {
        Object object = Datahike.db(this.conn);
        Assert.assertNotNull((Object)object);
        Set set = (Set)Datahike.q("[:find ?n :where [_ :name ?n]]", object);
        Assert.assertEquals((long)3L, (long)set.size());
    }

    @Test
    public void testDatoms() {
        Object object = Datahike.db(this.conn);
        Object object2 = Datahike.datoms(object, Util.kwd(":eavt"));
        Assert.assertNotNull((Object)object2);
    }

    @Test
    public void testDeleteDatabase() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("backend", Util.kwd(":memory"));
        hashMap2.put("id", UUID.randomUUID());
        hashMap.put("store", hashMap2);
        Datahike.createDatabase(hashMap);
        Assert.assertTrue((boolean)Datahike.databaseExists(hashMap));
        Datahike.deleteDatabase(hashMap);
        Assert.assertFalse((boolean)Datahike.databaseExists(hashMap));
    }

    @Test
    public void testSchema() {
        Object object = Datahike.db(this.conn);
        Object object2 = Datahike.schema(object);
        Assert.assertNotNull((Object)object2);
        Assert.assertTrue((boolean)(object2 instanceof Map));
        Map map = (Map)object2;
        Assert.assertTrue((boolean)map.containsKey(Util.kwd(":name")));
        Assert.assertTrue((boolean)map.containsKey(Util.kwd(":age")));
    }

    @Test
    public void testReverseSchema() {
        Object object = Datahike.db(this.conn);
        Map<?, ?> map = Datahike.reverseSchema(object);
        Assert.assertNotNull(map);
        Assert.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void testMetrics() {
        Object object = Datahike.db(this.conn);
        Object object2 = Datahike.metrics(object);
        Assert.assertNotNull((Object)object2);
        Assert.assertTrue((boolean)(object2 instanceof Map));
    }

    @Test
    public void testQueryStats() {
        Object object = Datahike.db(this.conn);
        String string = "[:find ?n :where [?e :name ?n]]";
        Map<?, ?> map = Datahike.queryStats(Util.map(Util.kwd(":query"), Clojure.read((String)string), Util.kwd(":args"), Util.vec(object)));
        Assert.assertNotNull(map);
        Assert.assertTrue((boolean)map.containsKey(Util.kwd(":query")));
    }

    @Test
    public void testWith() {
        Object object = Datahike.db(this.conn);
        Object object2 = Datahike.with(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), -1, Util.kwd(":name"), "David", Util.kwd(":age"), 40L)));
        Assert.assertNotNull((Object)object2);
        Assert.assertTrue((boolean)(object2 instanceof Map));
        Map map = (Map)object2;
        Assert.assertTrue((boolean)map.containsKey(Util.kwd(":db-after")));
    }

    @Test
    public void testTransactAsync() throws Exception {
        Object object = Datahike.transactAsync(this.conn, (List)Util.vec(Util.map(Util.kwd(":db/id"), -1, Util.kwd(":name"), "Eve", Util.kwd(":age"), 28L)));
        Assert.assertNotNull((Object)object);
        Object object2 = Util.derefFn.invoke(object);
        Assert.assertNotNull((Object)object2);
        Assert.assertTrue((boolean)(object2 instanceof Map));
        Object object3 = Datahike.db(this.conn);
        Set set = (Set)Datahike.q("[:find ?n :where [?e :name \"Eve\"] [?e :name ?n]]", object3);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testLoadEntities() {
        APersistentVector aPersistentVector = Util.vec(Util.map(Util.kwd(":db/id"), -1, Util.kwd(":name"), "Frank", Util.kwd(":age"), 45L), Util.map(Util.kwd(":db/id"), -2, Util.kwd(":name"), "Grace", Util.kwd(":age"), 32L), Util.map(Util.kwd(":db/id"), -3, Util.kwd(":name"), "Henry", Util.kwd(":age"), 27L));
        Object object = Datahike.loadEntities(this.conn, (List)aPersistentVector);
        Assert.assertNotNull((Object)object);
    }

    @Test
    public void testIndexRange() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testListenAndUnlisten() {
        ArrayList arrayList = new ArrayList();
        Object object = Clojure.read((String)"(fn [report] nil)");
        Object object2 = Datahike.listen(this.conn, Util.kwd(":test-listener"), object);
        Assert.assertNotNull((Object)object2);
        Map<?, ?> map = Datahike.unlisten(this.conn, Util.kwd(":test-listener"));
        Assert.assertNotNull(map);
    }

    @Test
    public void testConnectOverloads() {
        Object object = null;
        try {
            object = Datahike.connect();
            Assert.fail((String)"Expected exception for missing default config");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)true);
        }
        finally {
            if (object != null) {
                Datahike.release(object);
            }
        }
        Object object2 = Datahike.connect(this.config);
        Assert.assertNotNull((Object)object2);
        Datahike.release(object2);
    }

    @Test
    public void testDatabaseExistsOverloads() {
        Assert.assertTrue((boolean)Datahike.databaseExists(this.config));
        try {
            Datahike.databaseExists();
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testCreateDatabaseOverload() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("backend", Util.kwd(":memory"));
        hashMap2.put("id", UUID.randomUUID());
        hashMap.put("store", hashMap2);
        Object object = Datahike.createDatabase(hashMap);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)Datahike.databaseExists(hashMap));
        Datahike.deleteDatabase(hashMap);
    }

    @Test
    public void testPullOverloads() {
        Object object = Datahike.db(this.conn);
        Map<?, ?> map = Datahike.pull(object, "[:db/id :name :age]", (Object)1);
        Assert.assertNotNull(map);
        Assert.assertEquals((Object)"Alice", map.get(Util.kwd(":name")));
        Map<?, ?> map2 = Datahike.pull(object, Util.vec(Util.kwd(":db/id"), Util.kwd(":name")), 1);
        Assert.assertNotNull(map2);
        Assert.assertEquals((Object)"Alice", map2.get(Util.kwd(":name")));
    }

    @Test
    public void testSeekDatomsOverloads() {
        Object object = Datahike.db(this.conn);
        Iterable<?> iterable = Datahike.seekdatoms(object, Util.kwd(":eavt"), 1);
        Assert.assertNotNull(iterable);
        Assert.assertTrue((boolean)iterable.iterator().hasNext());
        Iterable<?> iterable2 = Datahike.seekdatoms(object, Util.kwd(":eavt"), 1, Util.kwd(":name"));
        Assert.assertNotNull(iterable2);
    }

    @Test
    public void testTempidOverloads() {
        Object object = Datahike.tempid(Util.kwd(":db.part/user"));
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((((Number)object).longValue() < 0L ? 1 : 0) != 0);
        Object object2 = Datahike.tempid(Util.kwd(":db.part/user"), -5000);
        Assert.assertNotNull((Object)object2);
        Assert.assertEquals((long)-5000L, (long)((Number)object2).longValue());
    }

    @Test
    public void testWithOverloads() {
        Object object = Datahike.db(this.conn);
        Object object2 = Datahike.with(object, (List)Util.vec(Util.map(Util.kwd(":db/id"), -1, Util.kwd(":name"), "Test1", Util.kwd(":age"), 50L)));
        Assert.assertNotNull((Object)object2);
    }

    @Test
    public void testMapToPersistentMapConversion() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put(":backend", Util.kwd(":memory"));
        hashMap2.put(":id", UUID.randomUUID());
        hashMap.put(":store", hashMap2);
        Datahike.createDatabase(hashMap);
        Assert.assertTrue((boolean)Datahike.databaseExists(hashMap));
        Datahike.deleteDatabase(hashMap);
    }
}

